/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.print;

import com.spss.java_client.ui.controls.SpssProgressDlg;
import com.spss.java_client.ui.dialogs.documents.output.pagesetup.PageSetupUtil;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.print.PrintOptions;
import com.spss.shared.export.IExportOptions;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import javax.swing.RepaintManager;

public abstract class SpssPrintable
implements Printable,
ActionListener {
    protected boolean mDoubleBufferingEnabled = false;
    protected int mNumberOfPages = 1;
    protected PrintOptions mPrintOptions;
    protected double mZoomFactor = 0.75;
    protected final double mOffsetFactor = 0.75;
    protected boolean mPrintSelection;
    protected PageFormat mPageFormat;
    protected boolean mPrintHidden = false;
    protected Window mErrorDisplayWindow = null;
    protected SpssProgressDlg mProgressDlg;
    protected IExportOptions.ModelViewOptions mModelViewsPrintOption = IExportOptions.ModelViewOptions.MVPrintSetting;
    protected String mPrinterName;

    public SpssPrintable(PrintOptions printOptions) {
        this.mPrintOptions = printOptions;
    }

    public int getTotalNumberOfPages() {
        return this.mNumberOfPages;
    }

    public void setZoomFactor(double d) {
        this.mZoomFactor = d * 72.0 / 96.0;
    }

    public PrintOptions getPrintOPtions() {
        return this.mPrintOptions;
    }

    public boolean hasAnySelected() {
        return true;
    }

    public void setPrintSelection(boolean bl) {
        this.mPrintSelection = bl;
        this.mPrintOptions.setPrintSelection(bl);
        this.mPrintHidden = false;
    }

    public void printInit() {
    }

    public void setModelViewsPrintOption(IExportOptions.ModelViewOptions modelViewOptions) {
        this.mModelViewsPrintOption = modelViewOptions;
        this.mPrintOptions.setModelViewsPrintOption(modelViewOptions);
    }

    public PageFormat getPageFormat() {
        return this.mPageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.mPageFormat = pageFormat;
    }

    public Window getErrorDisplayWindow() {
        return this.mErrorDisplayWindow;
    }

    public void setErrorDisplayWindow(Window window) {
        this.mErrorDisplayWindow = window;
    }

    public abstract void reset();

    public int getMediaTrayValue() {
        return -1;
    }

    public void setProgessDlg(SpssProgressDlg spssProgressDlg) {
        this.mProgressDlg = spssProgressDlg;
    }

    public void switchToRowsTable() {
    }

    public void dispose() {
    }

    protected void setProgressBarValue(int n) {
        if (this.mProgressDlg != null) {
            this.mProgressDlg.setValue(n);
        }
    }

    protected int getProgressBarValue() {
        if (this.mProgressDlg != null) {
            return this.mProgressDlg.getValue();
        }
        return 0;
    }

    protected void setProgressBarDetermineMode() {
        if (this.mProgressDlg != null) {
            this.mProgressDlg.setDeterminateMode();
        }
    }

    protected void setDisplayMessage(String string) {
        if (this.mProgressDlg != null) {
            this.mProgressDlg.setMessage(string);
        }
    }

    protected void disableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        this.mDoubleBufferingEnabled = repaintManager.isDoubleBufferingEnabled();
        repaintManager.setDoubleBufferingEnabled(false);
    }

    protected void enableDoubleBuffering(Component component) {
        if (this.mDoubleBufferingEnabled) {
            RepaintManager repaintManager = RepaintManager.currentManager(component);
            repaintManager.setDoubleBufferingEnabled(true);
        }
    }

    protected PageFormat createPageFormat() {
        PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();
        Paper paper = pageFormat.getPaper();
        double d = paper.getImageableX();
        double d2 = paper.getImageableY();
        double d3 = paper.getImageableWidth();
        double d4 = paper.getImageableHeight();
        Paper paper2 = new Paper();
        pageFormat = new PageFormat();
        paper2.setImageableArea(d / 0.75, d2 / 0.75, d3 / 0.75, d4 / 0.75);
        pageFormat.setPaper(paper2);
        return pageFormat;
    }

    protected PageFormat createPageFormat(ITopWindow iTopWindow) {
        Paper paper;
        Object object;
        try {
            object = PrinterJob.getPrinterJob();
            paper = ((PrinterJob)object).defaultPage().getPaper();
        }
        catch (Exception exception) {
            paper = new Paper();
        }
        object = PageSetupUtil.getPaper(iTopWindow.getViewerPanel(), paper);
        double d = ((Paper)object).getImageableX();
        double d2 = ((Paper)object).getImageableY();
        double d3 = ((Paper)object).getImageableWidth();
        double d4 = ((Paper)object).getImageableHeight();
        PageFormat pageFormat = new PageFormat();
        paper.setImageableArea(d / 0.75, d2 / 0.75, d3 / 0.75, d4 / 0.75);
        pageFormat.setPaper(paper);
        pageFormat.setOrientation(PageSetupUtil.getOrientation(iTopWindow.getViewerPanel(), pageFormat.getOrientation()));
        return pageFormat;
    }

    protected double getImageableX(PageFormat pageFormat) {
        double d;
        Paper paper = pageFormat.getPaper();
        switch (pageFormat.getOrientation()) {
            case 0: {
                d = paper.getHeight() / 0.75 - (paper.getImageableY() + paper.getImageableHeight());
                break;
            }
            case 1: {
                d = paper.getImageableX();
                break;
            }
            case 2: {
                d = paper.getImageableY();
                break;
            }
            default: {
                throw new InternalError("unrecognized orientation");
            }
        }
        return d;
    }

    public void setPrinterName(String string) {
        this.mPrinterName = string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public static enum PrintMode {
        NORMAL,
        FIT_WIDTH;

    }
}

