/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.print;

import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.documents.output.pagesetup.PageSetupUtil;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.output.ViewerPanel;
import com.spss.java_client.ui.print.OutputViewPrintable;
import com.spss.java_client.ui.print.PrintPreviewCanvas;
import com.spss.java_client.ui.print.PrintUtilities;
import com.spss.java_client.ui.print.SpssPrintable;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.ResizeConstrainer;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class SpssPrintPreview
extends JFrame
implements ActionListener,
WindowListener {
    private JButton mPrintBtn;
    private JButton mNextBtn;
    private JButton mPrevBtn;
    private JButton mOneOrTwoPageBtn;
    private JButton mZoomInBtn;
    private JButton mZoomOutBtn;
    private JButton mPageSetupBtn;
    private JButton mCloseBtn;
    private ResourceBundle mBundle;
    private boolean mIsOnePage = true;
    private PrintPreviewCanvas mFirstPanel;
    private PrintPreviewCanvas mSecondPanel;
    private double[] mZoomValues = new double[]{0.1, 0.25, 0.5, 0.75, 1.0, 1.5, 2.0, 5.0};
    private int mCurrentZoomIndex = 4;
    private Window mWindow;
    private JLabel mStatusBar;
    private SpssPrintable mSpssPrintable;
    private ResizeConstrainer mResizeConstrainer = null;

    public SpssPrintPreview(JFrame jFrame, SpssPrintable spssPrintable) {
        super(jFrame.getTitle());
        this.mWindow = jFrame;
        this.mSpssPrintable = spssPrintable;
        this.mFirstPanel = new PrintPreviewCanvas(spssPrintable, spssPrintable.getPrintOPtions(), this);
        this.mSpssPrintable.setErrorDisplayWindow(this);
        this.setIconImage(jFrame.getIconImage());
        this.addWindowListener(this);
        this.mSecondPanel = new PrintPreviewCanvas(spssPrintable, spssPrintable.getPrintOPtions(), this);
        this.init();
    }

    public SpssPrintPreview(JDialog jDialog, SpssPrintable spssPrintable) {
        super(jDialog.getTitle());
        this.mWindow = jDialog;
        this.mSpssPrintable = spssPrintable;
        this.mFirstPanel = new PrintPreviewCanvas(spssPrintable, spssPrintable.getPrintOPtions(), this);
        this.mSpssPrintable.setErrorDisplayWindow(this);
        this.addWindowListener(this);
        this.mSecondPanel = new PrintPreviewCanvas(spssPrintable, spssPrintable.getPrintOPtions(), this);
        this.init();
    }

    protected void init() {
        this.createButtons();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(this.mPrintBtn);
        jPanel.add(this.mNextBtn);
        jPanel.add(this.mPrevBtn);
        jPanel.add(this.mOneOrTwoPageBtn);
        jPanel.add(this.mZoomInBtn);
        jPanel.add(this.mZoomOutBtn);
        if (this.mSpssPrintable instanceof OutputViewPrintable) {
            jPanel.add(this.mPageSetupBtn);
        }
        jPanel.add(this.mCloseBtn);
        int n = 60;
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            n += 10;
        }
        jPanel.setMinimumSize(new Dimension(750, n));
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 3;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, 23, null);
        if (this.mIsOnePage) {
            this.mSecondPanel.setVisible(false);
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.mFirstPanel);
        jPanel2.add(this.mSecondPanel);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, new JScrollPane(jPanel2), gridBagConstraints, 0, 1, 1, 1, 10, null);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        jPanel3.setLayout(new GridLayout(1, 2));
        jPanel3.add(this.mStatusBar);
        jPanel3.add(new JLabel(this.mBundle.getString("IDS_PREVIEW_READY")));
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, jPanel3, gridBagConstraints, 0, 2, 1, 1, 25, null);
        this.pack();
        this.addListeners();
        int n2 = this.mPrintBtn.getWidth() + this.mNextBtn.getWidth() + this.mPrevBtn.getWidth() + this.mOneOrTwoPageBtn.getWidth();
        int n3 = this.mZoomInBtn.getWidth() + this.mZoomOutBtn.getWidth() + this.mPageSetupBtn.getWidth() + this.mCloseBtn.getWidth();
        int n4 = n2 > n3 ? n2 : n3;
        Dimension dimension = new Dimension(n4 += 40, 200);
        this.mResizeConstrainer = new ResizeConstrainer((Container)this, dimension);
        this.addComponentListener((ComponentListener)this.mResizeConstrainer);
    }

    private void createButtons() {
        this.mBundle = ResUtil.getBundle("com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle", ResUtil.getLocale());
        this.mPrintBtn = new JButton(this.mBundle.getString("IDS_PREVIEW_PRINT"));
        this.mNextBtn = new JButton(ResUtil.getCommonDlgString("IDS_PREVIEW_NEXT"));
        this.mPrevBtn = new JButton(ResUtil.getCommonDlgString("IDS_PREVIEW_PREV"));
        this.mOneOrTwoPageBtn = new JButton(ResUtil.getCommonDlgString("IDS_PREVIEW_TWO_PAGE"));
        this.mZoomInBtn = new JButton(ResUtil.getCommonDlgString("IDS_PREVIEW_ZOOM_IN"));
        this.mZoomOutBtn = new JButton(ResUtil.getCommonDlgString("IDS_PREVIEW_ZOOM_OUT"));
        this.mPageSetupBtn = new JButton(ResUtil.getCommonDlgString("IDS_PREVIEW_PAGESETUP"));
        this.mCloseBtn = new JButton(ResUtil.getCommonDlgString("IDS_PREVIEW_CLOSE"));
        this.mStatusBar = new JLabel(this.mBundle.getString("IDS_PREVIEW_PAGE") + "1");
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            this.mPrintBtn.setMnemonic((Integer)ResUtil.getObject("IDK_PREVIEW_PRINT_KEY", this.mBundle));
            this.mNextBtn.setMnemonic((Integer)ResUtil.getObject("IDK_PREVIEW_NEXT_KEY", this.mBundle));
            this.mPrevBtn.setMnemonic((Integer)ResUtil.getObject("IDK_PREVIEW_PREV_KEY", this.mBundle));
            this.mOneOrTwoPageBtn.setMnemonic((Integer)ResUtil.getObject("IDK_PREVIEW_TWO_PAGE_KEY", this.mBundle));
            this.mZoomInBtn.setMnemonic((Integer)ResUtil.getObject("IDK_PREVIEW_ZOOM_IN_KEY", this.mBundle));
            this.mZoomOutBtn.setMnemonic((Integer)ResUtil.getObject("IDK_PREVIEW_ZOOM_OUT_KEY", this.mBundle));
            this.mPageSetupBtn.setMnemonic((Integer)ResUtil.getObject("IDS_PREVIEW_PAGESETUP_KEY", this.mBundle));
            this.mCloseBtn.setMnemonic((Integer)ResUtil.getObject("IDK_PREVIEW_CLOSE_KEY", this.mBundle));
        }
    }

    private void addListeners() {
        this.mPrintBtn.addActionListener(this);
        this.enterPressesWhenFocused(this.mPrintBtn);
        this.mNextBtn.addActionListener(this);
        this.enterPressesWhenFocused(this.mNextBtn);
        this.mPrevBtn.addActionListener(this);
        this.enterPressesWhenFocused(this.mPrevBtn);
        this.mOneOrTwoPageBtn.addActionListener(this);
        this.enterPressesWhenFocused(this.mOneOrTwoPageBtn);
        this.mZoomInBtn.addActionListener(this);
        this.enterPressesWhenFocused(this.mZoomInBtn);
        this.mZoomOutBtn.addActionListener(this);
        this.enterPressesWhenFocused(this.mZoomOutBtn);
        this.mPageSetupBtn.addActionListener(this);
        this.mCloseBtn.addActionListener(this);
        this.enterPressesWhenFocused(this.mCloseBtn);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mPrintBtn) {
            this.mSpssPrintable.reset();
            this.mSpssPrintable.setZoomFactor(1.0);
            PrintUtilities.print(this.mWindow, this.mSpssPrintable);
            this.dispose();
        } else if (object == this.mNextBtn) {
            this.mFirstPanel.showNextPage();
            this.mSecondPanel.showNextPage();
            this.checkButtonStatus();
            this.mFirstPanel.setImage(null);
            this.mSecondPanel.setImage(null);
        } else if (object == this.mPrevBtn) {
            this.mFirstPanel.showPrevPage();
            this.mSecondPanel.showPrevPage();
            this.checkButtonStatus();
            this.mFirstPanel.setImage(null);
            this.mSecondPanel.setImage(null);
        } else if (object == this.mOneOrTwoPageBtn) {
            this.mSecondPanel.setCurrPageIndex(this.mFirstPanel.getCurrPageIndex() + 1);
            boolean bl = this.mIsOnePage = !this.mIsOnePage;
            if (this.mIsOnePage) {
                this.mOneOrTwoPageBtn.setText(ResUtil.getCommonDlgString("IDS_PREVIEW_TWO_PAGE"));
                if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                    this.mOneOrTwoPageBtn.setMnemonic((Integer)ResUtil.getObject("IDK_PREVIEW_TWO_PAGE_KEY", this.mBundle));
                }
                this.mSecondPanel.setVisible(false);
            } else {
                this.mOneOrTwoPageBtn.setText(ResUtil.getCommonDlgString("IDS_PREVIEW_ONE_PAGE"));
                if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                    this.mOneOrTwoPageBtn.setMnemonic((Integer)ResUtil.getObject("IDK_PREVIEW_ONE_PAGE_KEY", this.mBundle));
                }
                this.mSecondPanel.setVisible(true);
            }
            this.mFirstPanel.setImage(null);
            this.mSecondPanel.setImage(null);
        } else if (object == this.mZoomInBtn) {
            if (this.mCurrentZoomIndex < this.mZoomValues.length - 1) {
                ++this.mCurrentZoomIndex;
                this.mFirstPanel.zoomPage(this.mZoomValues[this.mCurrentZoomIndex]);
                this.mSecondPanel.zoomPage(this.mZoomValues[this.mCurrentZoomIndex]);
            }
            this.mFirstPanel.setImage(null);
            this.mSecondPanel.setImage(null);
        } else if (object == this.mZoomOutBtn) {
            if (this.mCurrentZoomIndex > 0) {
                --this.mCurrentZoomIndex;
                this.mFirstPanel.zoomPage(this.mZoomValues[this.mCurrentZoomIndex]);
                this.mSecondPanel.zoomPage(this.mZoomValues[this.mCurrentZoomIndex]);
            }
            this.mFirstPanel.setImage(null);
            this.mSecondPanel.setImage(null);
        } else if (object == this.mPageSetupBtn) {
            if (this.mWindow instanceof ITopWindow) {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                PageFormat pageFormat = printerJob.defaultPage();
                ITopWindow iTopWindow = (ITopWindow)((Object)this.mWindow);
                ViewerPanel viewerPanel = iTopWindow.getViewerPanel();
                pageFormat.setOrientation(PageSetupUtil.getOrientation(viewerPanel, pageFormat.getOrientation()));
                Paper paper = PageSetupUtil.getPaper(viewerPanel, pageFormat.getPaper());
                pageFormat.setPaper(paper);
                PageFormat pageFormat2 = printerJob.pageDialog(pageFormat);
                if (pageFormat2 != pageFormat) {
                    PageSetupUtil.setOrientation(viewerPanel, pageFormat2.getOrientation());
                    PageSetupUtil.setPaper(viewerPanel, pageFormat2.getPaper());
                    this.updataPageFormat(pageFormat2);
                }
            }
        } else if (object == this.mCloseBtn) {
            this.onClose();
        }
    }

    private void updataPageFormat(PageFormat pageFormat) {
        this.mSpssPrintable.printInit();
        this.mSpssPrintable.setPageFormat(pageFormat);
        this.mSpssPrintable.getPrintOPtions().setPageFormat(this.mSpssPrintable.getPageFormat());
        this.mFirstPanel.canvasInit(this.mSpssPrintable, this.mSpssPrintable.getPrintOPtions());
        this.mSecondPanel.canvasInit(this.mSpssPrintable, this.mSpssPrintable.getPrintOPtions());
        this.mFirstPanel.zoomPage(this.mZoomValues[this.mCurrentZoomIndex]);
        this.mSecondPanel.zoomPage(this.mZoomValues[this.mCurrentZoomIndex]);
        this.mFirstPanel.revalidate();
        this.mFirstPanel.repaint();
        this.mSecondPanel.revalidate();
        this.mSecondPanel.repaint();
    }

    public void checkButtonStatus() {
        if (this.mFirstPanel.getTotalNumPages() == 1) {
            this.mOneOrTwoPageBtn.setEnabled(false);
        }
        if (this.mCurrentZoomIndex < this.mZoomValues.length - 1) {
            this.mZoomInBtn.setEnabled(true);
        } else {
            this.mZoomInBtn.setEnabled(false);
        }
        if (this.mCurrentZoomIndex > 0) {
            this.mZoomOutBtn.setEnabled(true);
        } else {
            this.mZoomOutBtn.setEnabled(false);
        }
        if (this.mIsOnePage) {
            if (this.mFirstPanel.hasNextPage()) {
                this.mNextBtn.setEnabled(true);
            } else {
                this.mNextBtn.setEnabled(false);
            }
            if (this.mFirstPanel.hasPrevPage()) {
                this.mPrevBtn.setEnabled(true);
            } else {
                this.mPrevBtn.setEnabled(false);
            }
        } else {
            if (this.mSecondPanel.hasNextPage()) {
                this.mNextBtn.setEnabled(true);
            } else {
                this.mNextBtn.setEnabled(false);
            }
            if (this.mFirstPanel.hasPrevPage()) {
                this.mPrevBtn.setEnabled(true);
            } else {
                this.mPrevBtn.setEnabled(false);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string = SpssPrintPreview.this.mBundle.getString("IDS_PREVIEW_PAGE") + (SpssPrintPreview.this.mFirstPanel.getCurrPageIndex() + 1);
                if (!SpssPrintPreview.this.mIsOnePage) {
                    string = string + " - " + (SpssPrintPreview.this.mFirstPanel.getCurrPageIndex() + 2);
                }
                SpssPrintPreview.this.mStatusBar.setText(string);
                SpssPrintPreview.this.mStatusBar.getParent().repaint();
            }
        });
    }

    private void enterPressesWhenFocused(JButton jButton) {
        jButton.registerKeyboardAction(jButton.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, false)), KeyStroke.getKeyStroke(10, 0, false), 0);
        jButton.registerKeyboardAction(jButton.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, true)), KeyStroke.getKeyStroke(10, 0, true), 0);
    }

    private void onClose() {
        if (this.mSpssPrintable instanceof OutputViewPrintable) {
            ((OutputViewPrintable)this.mSpssPrintable).setPreviewWindowClose();
        }
        this.mSpssPrintable.dispose();
        this.dispose();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.onClose();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

