/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.print;

import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.resources.ComponentResBundle;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.export.IExportOptions;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.NumberSpinner;
import com.spss.uitools.controls.SPSSTextField;
import com.spss.uitools.controls.WindowsButtonGroup;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.ResizeConstrainer;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.print.PrintService;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SpssPrintDialog
extends BaseDialog
implements ActionListener {
    private PrinterJob mPrintJob;
    private JComboBox mPrinterCombo;
    private JRadioButton mPrintAllRadio;
    private JRadioButton mPrintSelectionRadio;
    private NumberSpinner mNumCopySpinner;
    private JCheckBox mCollate;
    private JCheckBox mSavePagesetup;
    private JButton mOkBtn;
    private JButton mCancelBtn;
    private boolean mIsOk;
    private boolean mPrintSelect;
    private int mNumCopy;
    private boolean mIsCollate;
    private ResizeConstrainer mResizeConstrainer = null;
    private static final ResourceBundle sBundle = ResUtil.getBundle("com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle", ResUtil.getLocale());
    private static PrintService[] sServices = PrinterJob.lookupPrintServices();
    public static final int MIN_COPIES = 1;
    public static final int MAX_COPIES = 9999;

    public SpssPrintDialog(Window window, PrinterJob printerJob, boolean bl, boolean bl2) {
        super(window, "", true, ResUtil.getBundle(ComponentResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), "");
        Point point;
        this.setTitle(ResUtil.getCommonDlgString("IDS_PRINT_TITLE"));
        this.mPrintJob = printerJob;
        this.mPrintSelect = bl;
        this.setup(window, bl2);
        this.pack();
        this.setResizable(true);
        Dimension dimension = ProcedureDlgMgr.getMgr().getDialogSize("file_print");
        if (dimension != null) {
            this.setSize(dimension);
        }
        if ((point = ProcedureDlgMgr.getMgr().getDialogLocation("file_print")) != null) {
            this.setLocation(point);
        } else {
            this.setLocationRelativeTo(window);
        }
        this.setVisible(true);
    }

    public void doHelp() {
    }

    protected JPanel setupCmdButtonPanel() {
        return null;
    }

    private void setup(Window window, boolean bl) {
        Object object;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 21;
        Insets insets = new Insets(4, 5, 4, 5);
        this.mPrinterCombo = new JComboBox<PrintService>(sServices);
        this.mPrinterCombo.setSelectedItem(this.mPrintJob.getPrintService());
        Dimension dimension = this.mPrinterCombo.getPreferredSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width > dimension2.width * 2 / 3) {
            this.mPrinterCombo.setPreferredSize(new Dimension(dimension2.width * 2 / 3, dimension.height));
        }
        if (bl) {
            if (window instanceof ViewerFrame) {
                this.mPrintAllRadio = new JRadioButton(ResUtil.getCommonDlgString("IDS_PRINT_ALL_VISIBLE"));
                this.mPrintSelectionRadio = new JRadioButton(ResUtil.getCommonDlgString("IDS_PRINT_SELECTED_OUTPUT"));
            } else {
                this.mPrintAllRadio = new JRadioButton(ResUtil.getCommonDlgString("IDS_PRINT_ALL"));
                this.mPrintSelectionRadio = new JRadioButton(ResUtil.getCommonDlgString("IDS_PRINT_SELECTION"));
            }
        }
        this.mNumCopySpinner = new NumberSpinner(1, 1, 9999, true, 1);
        IntTextField intTextField = this.getNumCopiesEditor();
        intTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SpssPrintDialog.this.processEditorChange();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SpssPrintDialog.this.processEditorChange();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SpssPrintDialog.this.processEditorChange();
            }
        });
        this.mCollate = new JCheckBox(ResUtil.getCommonDlgString("IDS_PRINT_COLLATE"));
        this.mCollate.setEnabled(false);
        this.mSavePagesetup = new JCheckBox(ResUtil.getCommonDlgString("IDS_PRINT_SAVE_PAGESETUP_CHECK"));
        this.mSavePagesetup.setEnabled(true);
        this.mSavePagesetup.setSelected(false);
        this.mOkBtn = new JButton(ResUtil.getCommonDlgString("IDS_PRINT_OK"));
        this.mCancelBtn = new JButton(ResUtil.getCommonDlgString("IDS_PRINT_CANCEL"));
        if (bl) {
            object = new WindowsButtonGroup();
            ((ButtonGroup)object).add(this.mPrintAllRadio);
            ((ButtonGroup)object).add(this.mPrintSelectionRadio);
            if (this.mPrintSelect) {
                this.mPrintSelectionRadio.setSelected(true);
            } else {
                this.mPrintAllRadio.setSelected(true);
                this.mPrintSelectionRadio.setEnabled(false);
            }
        }
        object = new JPanel();
        ((Container)object).setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(ResUtil.getCommonDlgString("IDS_PRINTER"));
        DialogUtil.addUsingGBL((Container)object, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL((Container)object, this.mPrinterCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        JLabel jLabel2 = new JLabel(ResUtil.getCommonDlgString("IDS_PRINT_NUM_COPY"));
        DialogUtil.addUsingGBL(jPanel2, jLabel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mNumCopySpinner, gridBagConstraints, 1, 0, 1, 1, n, insets);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        int n2 = OSCheck.getOSType() == OSInfo.OSType.MAC ? 1 : 0;
        int n3 = OSCheck.getOSType() == OSInfo.OSType.MAC ? 0 : 1;
        DialogUtil.addUsingGBL(jPanel3, this.mOkBtn, gridBagConstraints, n2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel3, this.mCancelBtn, gridBagConstraints, n3, 0, 1, 1, n, insets);
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel3);
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            jLabel.setDisplayedMnemonic(ResUtil.getCommonDlgAccessKey("IDK_PRINTER"));
        }
        jLabel.setLabelFor(this.mPrinterCombo);
        if (bl && OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mPrintAllRadio.setMnemonic(ResUtil.getCommonDlgAccessKey("IDK_PRINT_ALL"));
            this.mPrintSelectionRadio.setMnemonic(ResUtil.getCommonDlgAccessKey("IDK_PRINT_SELECTION"));
        }
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mCollate.setMnemonic(ResUtil.getCommonDlgAccessKey("IDK_PRINT_COLLATE"));
            jLabel2.setDisplayedMnemonic(ResUtil.getCommonDlgAccessKey("IDK_PRINT_NUM_COPY"));
        }
        jLabel2.setLabelFor((Component)this.mNumCopySpinner);
        this.getRootPane().setDefaultButton(this.mOkBtn);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)object, gridBagConstraints, 0, 0, 1, 1, n, insets);
        if (bl) {
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new GridLayout(2, 1));
            jPanel4.setBorder(BorderFactory.createTitledBorder(ResUtil.getCommonDlgString("IDS_PRINT_RANGE")));
            jPanel4.add(this.mPrintAllRadio);
            jPanel4.add(this.mPrintSelectionRadio);
            DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 1, 1, 1, n, insets);
        }
        DialogUtil.addUsingGBL(jPanel, this.mCollate, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 5, 1, 1, 26, insets);
        this.add(jPanel);
        this.addActionListeners();
        if (this.mPrinterCombo.getModel().getSize() == 0) {
            this.mOkBtn.setEnabled(false);
        }
    }

    private IntTextField getNumCopiesEditor() {
        IntTextField intTextField = (IntTextField)this.mNumCopySpinner.getEditor();
        return intTextField;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mOkBtn) {
            IntTextField intTextField;
            String string;
            JComponent jComponent;
            ProcedureDlgMgr.getMgr().saveDialogSize("file_print", this.getSize());
            ProcedureDlgMgr.getMgr().saveDialogLocation("file_print", this.getLocation());
            if (this.mPrintSelectionRadio != null) {
                this.mPrintSelect = this.mPrintSelectionRadio.isSelected();
            }
            if ((jComponent = this.mNumCopySpinner.getEditor()) instanceof IntTextField && ((string = (intTextField = (IntTextField)jComponent).getText()).length() == 0 || Integer.parseInt(string) == 0)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String string = MessageFormat.format(UIToolResUtil.getString((String)"ERR_WARNING_MESSAGE"), "1", "9999");
                        SPSSTextField.showWarningDialog((JComponent)intTextField, (String)string, (String)UIToolResUtil.getString((String)"IDS_WARNING_TITLE"));
                        intTextField.requestFocus();
                    }
                });
                this.mIsOk = false;
                return;
            }
            this.mNumCopy = (Integer)this.mNumCopySpinner.getValue();
            this.mIsCollate = this.mCollate.isSelected();
            try {
                this.mPrintJob.setPrintService((PrintService)this.mPrinterCombo.getSelectedItem());
            }
            catch (PrinterException printerException) {
                printerException.printStackTrace();
            }
            this.mIsOk = true;
            this.dispose();
        } else if (object == this.mCancelBtn) {
            ProcedureDlgMgr.getMgr().saveDialogSize("file_print", this.getSize());
            ProcedureDlgMgr.getMgr().saveDialogLocation("file_print", this.getLocation());
            this.mIsOk = false;
            this.dispose();
        }
    }

    private void processEditorChange() {
        int n;
        IntTextField intTextField = this.getNumCopiesEditor();
        int n2 = n = intTextField != null && intTextField.getText().length() > 0 ? Integer.parseInt(intTextField.getText()) : 0;
        if (n == 0) {
            if (n == 1) {
                this.mCollate.setEnabled(false);
            } else {
                this.mCollate.setEnabled(true);
            }
        }
        boolean bl = n >= 1 && n <= 9999;
        this.mOkBtn.setEnabled(bl);
    }

    public boolean isOK() {
        return this.mIsOk;
    }

    public boolean isPrintSelect() {
        return this.mPrintSelect;
    }

    public int getNumberOfCopies() {
        return this.mNumCopy;
    }

    public boolean isCollate() {
        return this.mIsCollate;
    }

    private void addActionListeners() {
        if (this.mPrintAllRadio != null) {
            this.mPrintAllRadio.addActionListener(this);
        }
        if (this.mPrintSelectionRadio != null) {
            this.mPrintSelectionRadio.addActionListener(this);
        }
        this.mCollate.addActionListener(this);
        this.mOkBtn.addActionListener(this);
        this.mCancelBtn.addActionListener(this);
    }

    public void pack() {
        this.removeComponentListener((ComponentListener)this.mResizeConstrainer);
        super.pack();
        Dimension dimension = this.getSizeConstraints();
        Dimension dimension2 = this.getSize();
        dimension2.width = dimension2.width > dimension.width ? dimension2.width : dimension.width;
        dimension2.height = dimension2.height > dimension.height ? dimension2.height : dimension.height;
        this.setSizeConstraints(dimension2);
        this.addComponentListener((ComponentListener)this.mResizeConstrainer);
    }

    public Dimension getSizeConstraints() {
        if (this.mResizeConstrainer == null) {
            this.mResizeConstrainer = new ResizeConstrainer((Container)((Object)this), new Dimension(0, 0));
        }
        return this.mResizeConstrainer.getSizeConstraints();
    }

    public void setSizeConstraints(Dimension dimension) {
        if (this.mResizeConstrainer == null) {
            this.mResizeConstrainer = new ResizeConstrainer((Container)((Object)this), dimension);
        } else {
            this.mResizeConstrainer.setSizeConstraints(dimension);
        }
    }

    public IExportOptions.ModelViewOptions getModelViewsPrintOption() {
        return IExportOptions.ModelViewOptions.MVPrintSetting;
    }
}

