/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.print;

import com.spss.java_client.core.documents.ICoreDocument;
import com.spss.java_client.core.documents.data.DataDocument;
import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.output.OutputDocument;
import com.spss.java_client.core.documents.output.OutputManager;
import com.spss.java_client.ui.controls.SpssProgressDlg;
import com.spss.java_client.ui.dialogs.documents.output.pagesetup.PageSetupUtil;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.print.OutputViewPrintable;
import com.spss.java_client.ui.print.SpssPrintDialog;
import com.spss.java_client.ui.print.SpssPrintable;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.util.TraceSettings;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Vector;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.SheetCollate;
import javax.swing.SwingUtilities;

public class PrintUtilities {
    public static void print(final Window window, final SpssPrintable spssPrintable) {
        if (spssPrintable != null) {
            final PrinterJob printerJob = PrinterJob.getPrinterJob();
            String string = PrintUtilities.getPrintJobTitle(window);
            if (string.length() > 0) {
                printerJob.setJobName(string);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    final SpssPrintDialog spssPrintDialog = new SpssPrintDialog(window, printerJob, spssPrintable.hasAnySelected(), true);
                    if (spssPrintDialog.isOK()) {
                        spssPrintable.setPrinterName(printerJob.getPrintService().getName());
                        TraceSettings.tracePerformance((String)"PrintUtilities.print( START )");
                        spssPrintable.setPrintSelection(spssPrintDialog.isPrintSelect());
                        spssPrintable.setModelViewsPrintOption(spssPrintDialog.getModelViewsPrintOption());
                        spssPrintable.printInit();
                        final SpssProgressDlg spssProgressDlg = new SpssProgressDlg(window, ResUtil.getString("IDS_PRINT_PROGRESS_TITLE"));
                        spssPrintable.setProgessDlg(spssProgressDlg);
                        spssPrintable.setProgressBarDetermineMode();
                        Runnable runnable = new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    String[] stringArray;
                                    Object object;
                                    Cloneable cloneable;
                                    HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
                                    hashPrintRequestAttributeSet.add(new Copies(spssPrintDialog.getNumberOfCopies()));
                                    if (spssPrintDialog.isCollate()) {
                                        hashPrintRequestAttributeSet.add(SheetCollate.COLLATED);
                                    }
                                    if (spssPrintable.getMediaTrayValue() != -1 && printerJob.getPrintService().isAttributeCategorySupported(MediaTray.class)) {
                                        cloneable = null;
                                        switch (spssPrintable.getMediaTrayValue()) {
                                            case 0: {
                                                cloneable = MediaTray.TOP;
                                                break;
                                            }
                                            case 1: {
                                                cloneable = MediaTray.MIDDLE;
                                                break;
                                            }
                                            case 2: {
                                                cloneable = MediaTray.BOTTOM;
                                                break;
                                            }
                                            case 3: {
                                                cloneable = MediaTray.ENVELOPE;
                                                break;
                                            }
                                        }
                                        if (cloneable != null && printerJob.getPrintService().isAttributeValueSupported((Attribute)((Object)cloneable), null, null)) {
                                            hashPrintRequestAttributeSet.add((Attribute)((Object)cloneable));
                                        }
                                    }
                                    cloneable = (PageFormat)PrinterJob.getPrinterJob().defaultPage().clone();
                                    if (spssPrintable instanceof OutputViewPrintable) {
                                        object = PageSetupUtil.getPaper(((ITopWindow)((Object)window)).getViewerPanel(), ((PageFormat)cloneable).getPaper());
                                        ((PageFormat)cloneable).setPaper((Paper)object);
                                        ((PageFormat)cloneable).setOrientation(PageSetupUtil.getOrientation(((ITopWindow)((Object)window)).getViewerPanel(), ((PageFormat)cloneable).getOrientation()));
                                    }
                                    printerJob.setPrintable(spssPrintable, (PageFormat)cloneable);
                                    if (window instanceof SpssFrame) {
                                        ((SpssFrame)window).setIsPrinting(true);
                                    }
                                    if ((object = System.getProperty("os.version")) != null && (stringArray = ((String)object).split("\\s")).length > 0) {
                                        System.setProperty("os.version", stringArray[0]);
                                    }
                                    printerJob.print(hashPrintRequestAttributeSet);
                                    if (object != null) {
                                        System.setProperty("os.version", (String)object);
                                    }
                                    spssPrintable.setProgessDlg(null);
                                    if (spssPrintable instanceof OutputViewPrintable) {
                                        ((OutputViewPrintable)spssPrintable).showLongTableRowLableMessage();
                                    }
                                }
                                catch (PrinterException printerException) {
                                    printerException.printStackTrace();
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                finally {
                                    if (window instanceof SpssFrame) {
                                        ((SpssFrame)window).setIsPrinting(false);
                                    }
                                    spssProgressDlg.dispose();
                                    spssPrintable.dispose();
                                    TraceSettings.tracePerformance((String)"PrintUtilities.print( END )");
                                }
                            }
                        };
                        Thread thread = new Thread(runnable);
                        thread.start();
                        spssProgressDlg.setVisible(true);
                    }
                }
            });
        }
    }

    public static void print(final Window window, final OutputViewPrintable outputViewPrintable, final Vector<ViewerItem> vector) {
        if (outputViewPrintable != null) {
            final PrinterJob printerJob = PrinterJob.getPrinterJob();
            String string = PrintUtilities.getPrintJobTitle(window);
            if (string.length() > 0) {
                printerJob.setJobName(string);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    final SpssPrintDialog spssPrintDialog = new SpssPrintDialog(window, printerJob, outputViewPrintable.hasAnySelected(), false);
                    if (spssPrintDialog.isOK()) {
                        TraceSettings.tracePerformance((String)"PrintUtilities.print( START )");
                        outputViewPrintable.setPrintSelection(spssPrintDialog.isPrintSelect());
                        outputViewPrintable.setModelViewsPrintOption(spssPrintDialog.getModelViewsPrintOption());
                        outputViewPrintable.printInit(vector);
                        final SpssProgressDlg spssProgressDlg = new SpssProgressDlg(window, ResUtil.getString("IDS_PRINT_PROGRESS_TITLE"));
                        outputViewPrintable.setProgessDlg(spssProgressDlg);
                        outputViewPrintable.setProgressBarDetermineMode();
                        Runnable runnable = new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    String[] stringArray;
                                    Object object;
                                    Cloneable cloneable;
                                    HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
                                    hashPrintRequestAttributeSet.add(new Copies(spssPrintDialog.getNumberOfCopies()));
                                    if (spssPrintDialog.isCollate()) {
                                        hashPrintRequestAttributeSet.add(SheetCollate.COLLATED);
                                    }
                                    if (outputViewPrintable.getMediaTrayValue() != -1 && printerJob.getPrintService().isAttributeCategorySupported(MediaTray.class)) {
                                        cloneable = null;
                                        switch (outputViewPrintable.getMediaTrayValue()) {
                                            case 0: {
                                                cloneable = MediaTray.TOP;
                                                break;
                                            }
                                            case 1: {
                                                cloneable = MediaTray.MIDDLE;
                                                break;
                                            }
                                            case 2: {
                                                cloneable = MediaTray.BOTTOM;
                                                break;
                                            }
                                            case 3: {
                                                cloneable = MediaTray.ENVELOPE;
                                                break;
                                            }
                                        }
                                        if (cloneable != null && printerJob.getPrintService().isAttributeValueSupported((Attribute)((Object)cloneable), null, null)) {
                                            hashPrintRequestAttributeSet.add((Attribute)((Object)cloneable));
                                        }
                                    }
                                    cloneable = (PageFormat)PrinterJob.getPrinterJob().defaultPage().clone();
                                    if (outputViewPrintable instanceof OutputViewPrintable) {
                                        object = PageSetupUtil.getPaper((ViewerFrame)window, ((PageFormat)cloneable).getPaper());
                                        ((PageFormat)cloneable).setPaper((Paper)object);
                                        ((PageFormat)cloneable).setOrientation(PageSetupUtil.getOrientation((ViewerFrame)window, ((PageFormat)cloneable).getOrientation()));
                                    }
                                    printerJob.setPrintable(outputViewPrintable, (PageFormat)cloneable);
                                    if (window instanceof SpssFrame) {
                                        ((SpssFrame)window).setIsPrinting(true);
                                    }
                                    if ((object = System.getProperty("os.version")) != null && (stringArray = ((String)object).split("\\s")).length > 0) {
                                        System.setProperty("os.version", stringArray[0]);
                                    }
                                    printerJob.print(hashPrintRequestAttributeSet);
                                    if (object != null) {
                                        System.setProperty("os.version", (String)object);
                                    }
                                    outputViewPrintable.setProgessDlg(null);
                                }
                                catch (PrinterException printerException) {
                                    printerException.printStackTrace();
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                finally {
                                    if (window instanceof SpssFrame) {
                                        ((SpssFrame)window).setIsPrinting(false);
                                    }
                                    spssProgressDlg.dispose();
                                    outputViewPrintable.dispose();
                                    TraceSettings.tracePerformance((String)"PrintUtilities.print( END )");
                                }
                            }
                        };
                        Thread thread = new Thread(runnable);
                        thread.start();
                        spssProgressDlg.setVisible(true);
                    }
                }
            });
        }
    }

    public static Thread printNoDialog(SpssPrintable spssPrintable) {
        Thread thread = null;
        if (spssPrintable != null) {
            final PrinterJob printerJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat = spssPrintable.getPageFormat();
            if (pageFormat == null) {
                pageFormat = PrinterJob.getPrinterJob().defaultPage();
            }
            printerJob.setPrintable(spssPrintable, pageFormat);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException printerException) {
                        // empty catch block
                    }
                }
            };
            thread = new Thread(runnable);
            thread.start();
        }
        return thread;
    }

    private static String getPrintJobTitle(Window window) {
        ICoreDocument iCoreDocument;
        String string = "";
        if (window instanceof ITopWindow && (iCoreDocument = ((ITopWindow)((Object)window)).getCoreDocument()) != null) {
            string = iCoreDocument.getDocName();
            if (window instanceof DataFrame) {
                string = string + " [" + ((DataDocument)iCoreDocument).getDatasetName() + "]";
            } else if (window instanceof ViewerFrame) {
                string = string + " [" + OutputManager.getOutputManager().getOutputDocumentUniqueName((IOutputDocument)((OutputDocument)iCoreDocument)) + "]";
            }
        }
        return string;
    }
}

