/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.print;

import com.spss.java_client.ui.print.OutputViewPrintable;
import com.spss.java_client.ui.print.PrintOptions;
import com.spss.java_client.ui.print.SpssPrintPreview;
import com.spss.java_client.ui.print.SpssPrintable;
import com.spss.java_client.ui.print.SyntaxViewPrintable;
import com.spss.pivottable.resources.PTResUtil;
import com.spss.shared.export.IExportOptions;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class PrintPreviewCanvas
extends JPanel
implements Cloneable {
    private int mCurrentPageIndex = 0;
    private int mTotalNumPages = 1;
    private SpssPrintable mPrintable;
    private PageFormat mPageFormat;
    private SpssPrintPreview mPreview;
    private BufferedImage mImage;
    private Map<Integer, BufferedImage> mCachedImages = new HashMap<Integer, BufferedImage>();

    public PrintPreviewCanvas(SpssPrintable spssPrintable, PrintOptions printOptions, SpssPrintPreview spssPrintPreview) {
        this.mPreview = spssPrintPreview;
        this.canvasInit(spssPrintable, printOptions);
        this.setBackground(Color.WHITE);
        this.setFocusable(true);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(33, 0), "page-up");
        this.getActionMap().put("page-up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintPreviewCanvas.this.showPrevPage();
                PrintPreviewCanvas.this.setImage(null);
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(34, 0), "page-down");
        this.getActionMap().put("page-down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintPreviewCanvas.this.showNextPage();
                PrintPreviewCanvas.this.setImage(null);
            }
        });
    }

    public void canvasInit(SpssPrintable spssPrintable, PrintOptions printOptions) {
        this.mPrintable = spssPrintable;
        this.mPrintable.setPrintSelection(spssPrintable.hasAnySelected());
        this.mPrintable.setModelViewsPrintOption(IExportOptions.ModelViewOptions.MVPrintSetting);
        this.mPrintable.printInit();
        this.mPageFormat = printOptions.getPageFormat();
        if (this.mPageFormat == null) {
            this.mPageFormat = PrinterJob.getPrinterJob().defaultPage();
        }
        this.setPreferredSize(new Dimension((int)this.mPageFormat.getWidth(), (int)this.mPageFormat.getHeight()));
        this.mCachedImages.clear();
        this.mImage = null;
    }

    public boolean hasNextPage() {
        return this.mCurrentPageIndex < this.mTotalNumPages - 1;
    }

    public boolean hasPrevPage() {
        return this.mCurrentPageIndex > 0;
    }

    public void showNextPage() {
        if (this.hasNextPage()) {
            ++this.mCurrentPageIndex;
            this.repaint();
        }
    }

    public void showPrevPage() {
        if (this.hasPrevPage()) {
            --this.mCurrentPageIndex;
            this.repaint();
        }
    }

    public void zoomPage(double d) {
        this.mCachedImages.clear();
        this.mPrintable.setZoomFactor(d);
        int n = 0;
        if (d == 1.0) {
            n = 40;
        }
        this.setPreferredSize(new Dimension((int)(d * this.mPageFormat.getWidth()) + n, (int)(d * this.mPageFormat.getHeight())));
        if (this.isVisible()) {
            this.revalidate();
        }
    }

    public int getTotalNumPages() {
        return this.mTotalNumPages;
    }

    public PrintPreviewCanvas clone() throws CloneNotSupportedException {
        PrintPreviewCanvas printPreviewCanvas = (PrintPreviewCanvas)super.clone();
        printPreviewCanvas.mPageFormat = (PageFormat)this.mPageFormat.clone();
        return printPreviewCanvas;
    }

    public int getCurrPageIndex() {
        return this.mCurrentPageIndex;
    }

    public void setCurrPageIndex(int n) {
        this.mCurrentPageIndex = n;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(Color.black);
            this.mPrintable.reset();
            if (this.mPrintable instanceof OutputViewPrintable) {
                OutputViewPrintable outputViewPrintable = (OutputViewPrintable)this.mPrintable;
                outputViewPrintable.setPrintPreview(true);
                this.mImage = this.mCachedImages.get(this.mCurrentPageIndex);
                if (this.mImage == null) {
                    graphics.drawString(PTResUtil.getString((String)"PreviewProcessing"), 150, 150);
                    Thread thread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Dimension dimension = PrintPreviewCanvas.this.getPreferredSize();
                            PrintPreviewCanvas.this.mImage = new BufferedImage(dimension.width, dimension.height, 6);
                            Graphics2D graphics2D = PrintPreviewCanvas.this.mImage.createGraphics();
                            try {
                                SpssPrintable spssPrintable = PrintPreviewCanvas.this.mPrintable;
                                synchronized (spssPrintable) {
                                    PrintPreviewCanvas.this.mPrintable.print(graphics2D, PrintPreviewCanvas.this.mPageFormat, PrintPreviewCanvas.this.mCurrentPageIndex);
                                }
                            }
                            catch (PrinterException printerException) {
                                printerException.printStackTrace();
                            }
                            finally {
                                PrintPreviewCanvas.this.mCachedImages.put(PrintPreviewCanvas.this.mCurrentPageIndex, PrintPreviewCanvas.this.mImage);
                                graphics2D.dispose();
                                PrintPreviewCanvas.this.repaint();
                            }
                        }
                    };
                    thread.start();
                    return;
                }
                graphics.drawImage(this.mImage, 0, 0, null);
            } else {
                if (this.mPrintable instanceof SyntaxViewPrintable) {
                    graphics2D.scale(this.mPrintable.mZoomFactor, this.mPrintable.mZoomFactor);
                    this.drawBorder(graphics2D);
                    SyntaxViewPrintable syntaxViewPrintable = (SyntaxViewPrintable)this.mPrintable;
                    syntaxViewPrintable.wrapSyntax(graphics2D);
                    graphics2D.scale(1.0 / this.mPrintable.mZoomFactor, 1.0 / this.mPrintable.mZoomFactor);
                }
                this.mPrintable.print(graphics, this.mPageFormat, this.mCurrentPageIndex);
            }
            this.mTotalNumPages = this.mPrintable.getTotalNumberOfPages();
            if (this.mPreview != null) {
                this.mPreview.checkButtonStatus();
            }
        }
        catch (PrinterException printerException) {
            printerException.printStackTrace();
        }
        this.getTopLevelAncestor().setCursor(Cursor.getDefaultCursor());
    }

    public void setImage(BufferedImage bufferedImage) {
        this.mImage = bufferedImage;
    }

    private void drawBorder(Graphics2D graphics2D) {
        float[] fArray = new float[]{5.0f, 2.0f, 5.0f, 2.0f};
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(0.1f, 0, 0, 10.0f, fArray, 0.0f));
        int n = (int)(this.mPageFormat.getImageableWidth() + this.mPageFormat.getImageableX());
        int n2 = (int)(this.mPageFormat.getImageableHeight() + this.mPageFormat.getImageableY());
        int n3 = (int)(this.mPageFormat.getWidth() / this.mPrintable.mZoomFactor);
        int n4 = (int)(this.mPageFormat.getHeight() / this.mPrintable.mZoomFactor);
        graphics2D.drawLine((int)this.mPageFormat.getImageableX(), 10, (int)this.mPageFormat.getImageableX(), n4 - 10);
        graphics2D.drawLine(10, (int)this.mPageFormat.getImageableY(), n3 - 10, (int)this.mPageFormat.getImageableY());
        graphics2D.drawLine(n, 10, n, n4 - 10);
        graphics2D.drawLine(10, n2, n3 - 10, n2);
        graphics2D.setStroke(stroke);
    }

    private void drawOutputBorder(Graphics2D graphics2D) {
        AffineTransform affineTransform = graphics2D.getTransform();
        float[] fArray = new float[]{5.0f, 2.0f, 5.0f, 2.0f};
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(0.1f, 0, 0, 10.0f, fArray, 0.0f));
        int n = (int)(this.mPageFormat.getImageableWidth() + this.mPrintable.getImageableX(this.mPageFormat));
        int n2 = (int)(this.mPageFormat.getImageableHeight() + this.mPageFormat.getImageableY());
        int n3 = (int)(this.mPageFormat.getWidth() / this.mPrintable.mZoomFactor);
        int n4 = (int)(this.mPageFormat.getHeight() / this.mPrintable.mZoomFactor);
        graphics2D.scale(this.mPrintable.mZoomFactor, this.mPrintable.mZoomFactor);
        graphics2D.drawLine((int)this.mPrintable.getImageableX(this.mPageFormat), 1, (int)this.mPrintable.getImageableX(this.mPageFormat), n4 - 1);
        graphics2D.drawLine(1, (int)this.mPageFormat.getImageableY(), n3 - 1, (int)this.mPageFormat.getImageableY());
        graphics2D.drawLine(n, 1, n, n4 - 1);
        graphics2D.drawLine(1, n2, n3 - 1, n2);
        graphics2D.setStroke(stroke);
        graphics2D.setTransform(affineTransform);
    }
}

