/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.print;

import com.spss.java_client.ui.print.PrintDecoration;
import com.spss.java_client.ui.print.SpssPrintable;
import com.spss.shared.export.IExportOptions;
import java.awt.Dimension;
import java.awt.print.PageFormat;
import java.util.ArrayList;

public class PrintOptions {
    public final int VERTICAL_MARGIN = 10;
    protected boolean mShowBox = false;
    protected int mStartingPageNumber = 1;
    protected Dimension mPagesAcrossAndDown;
    protected ArrayList mDecorations;
    protected PageFormat mPageformat = null;
    protected boolean mMaintainAspect = true;
    protected SpssPrintable.PrintMode mPrintMode = SpssPrintable.PrintMode.NORMAL;
    protected double mScale = 0.8;
    private boolean mPrintSelection;
    private IExportOptions.ModelViewOptions mModelPrintOption = IExportOptions.ModelViewOptions.MVPrintSetting;

    public PrintOptions() {
        this.mPagesAcrossAndDown = new Dimension(0, 0);
        this.mDecorations = new ArrayList();
    }

    public void addPrintDecoration(PrintDecoration printDecoration) {
        if (printDecoration != null) {
            this.mDecorations.add(printDecoration);
        }
    }

    public void clearPrintDecorations() {
        this.mDecorations.clear();
    }

    public int getDecorationCount() {
        return this.mDecorations.size();
    }

    public PrintDecoration getDecorationAt(int n) {
        if (n < 0 || n >= this.getDecorationCount()) {
            return null;
        }
        return (PrintDecoration)this.mDecorations.get(n);
    }

    public void setPagesAcrossAndDown(Dimension dimension, boolean bl) {
        if (null != dimension) {
            this.mPagesAcrossAndDown = dimension;
            if (this.mPagesAcrossAndDown.height <= 0 || this.mPagesAcrossAndDown.width <= 0) {
                this.mPagesAcrossAndDown.setSize(0, 0);
            }
        } else {
            this.mPagesAcrossAndDown.setSize(0, 0);
        }
        this.mMaintainAspect = bl;
    }

    public Dimension getPagesAcrossAndDown() {
        return this.mPagesAcrossAndDown;
    }

    public boolean getMaintainAspectRatio() {
        return this.mMaintainAspect;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.mPageformat = pageFormat;
    }

    public PageFormat getPageFormat() {
        return this.mPageformat;
    }

    public void setStartingPageNumber(int n) {
        this.mStartingPageNumber = n;
    }

    public int getStartingPageNumber() {
        return this.mStartingPageNumber;
    }

    public int getHeaderHeight() {
        return this.getLevelHeight(true);
    }

    public int getFooterHeight() {
        return this.getLevelHeight(false);
    }

    public void setShowDecorationBox(boolean bl) {
        this.mShowBox = bl;
    }

    public boolean getShowDecorationBox() {
        return this.mShowBox;
    }

    public void setPrintMode(SpssPrintable.PrintMode printMode) {
        this.mPrintMode = printMode;
    }

    public SpssPrintable.PrintMode getPrintMode() {
        return this.mPrintMode;
    }

    public double getScle() {
        return this.mScale;
    }

    public boolean isPrintSelection() {
        return this.mPrintSelection;
    }

    public void setPrintSelection(boolean bl) {
        this.mPrintSelection = bl;
    }

    public void setModelViewsPrintOption(IExportOptions.ModelViewOptions modelViewOptions) {
        this.mModelPrintOption = modelViewOptions;
    }

    public IExportOptions.ModelViewOptions getModelViewsPrintOption() {
        return this.mModelPrintOption;
    }

    protected int getLevelHeight(boolean bl) {
        int n;
        int n2 = 0;
        int[] nArray = new int[]{0, 0, 0};
        block5: for (n = 0; n < this.getDecorationCount(); ++n) {
            PrintDecoration printDecoration = this.getDecorationAt(n);
            int n3 = printDecoration.getDecorationPosition();
            if ((!bl || !this.isHeaderPosition(n3)) && (bl || this.isHeaderPosition(n3))) continue;
            switch (n3) {
                case 1: 
                case 4: {
                    nArray[0] = nArray[0] + printDecoration.getHeight();
                    continue block5;
                }
                case 2: 
                case 5: {
                    nArray[1] = nArray[1] + printDecoration.getHeight();
                    continue block5;
                }
                case 3: 
                case 6: {
                    nArray[2] = nArray[2] + printDecoration.getHeight();
                    continue block5;
                }
            }
        }
        if (nArray[0] > 0 || nArray[1] > 0 || nArray[2] > 0) {
            n = nArray[0] > nArray[1] ? nArray[0] : nArray[1];
            n = n > nArray[2] ? n : nArray[2];
            n2 = n + 15;
        }
        return n2;
    }

    protected boolean isHeaderPosition(int n) {
        return 1 == n || 2 == n || 3 == n;
    }
}

