/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.print;

import java.awt.Color;
import java.awt.Font;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.print.PrintException;

public class PrintDecoration {
    public static final int POSITION_TOPLEFT = 1;
    public static final int POSITION_TOPCENTER = 2;
    public static final int POSITION_TOPRIGHT = 3;
    public static final int POSITION_BOTTOMLEFT = 4;
    public static final int POSITION_BOTTOMCENTER = 5;
    public static final int POSITION_BOTTOMRIGHT = 6;
    public static final int DECOR_NONE = 0;
    public static final int DECOR_DATE = 1;
    public static final int DECOR_PAGENO = 2;
    public static final int DECOR_MATRIX = 3;
    public static final int DECOR_TITLE = 4;
    private int mDecorationType = 0;
    private int mDecorationPosition = 2;
    private String mStringData;
    private Font mFont = null;
    private Color mTextColor;

    public void setDateTimeDecoration(SimpleDateFormat simpleDateFormat, int n, Font font, Color color) throws PrintException {
        if (simpleDateFormat == null || n < 1 || n > 6) {
            throw new PrintException("setDateTimeDecoration()");
        }
        this.mDecorationType = 1;
        Date date = new Date();
        this.mStringData = simpleDateFormat.format(date);
        this.mDecorationPosition = n;
        this.mFont = null != font ? font : new Font("SansSerif", 0, 10);
        this.mTextColor = null != color ? color : Color.black;
    }

    public void setPageNumberDecoration(String string, int n, Font font, Color color) throws PrintException {
        if (string == null || n < 1 || n > 6) {
            throw new PrintException("setPageNumberDecoration()");
        }
        this.mDecorationType = 2;
        this.mStringData = string;
        this.mDecorationPosition = n;
        this.mFont = null != font ? font : new Font("SansSerif", 0, 10);
        this.mTextColor = null != color ? color : Color.black;
    }

    public void setPageMatrixDecoration(String string, int n, Font font, Color color) throws PrintException {
        if (string == null || n < 1 || n > 6) {
            throw new PrintException("setPageMatrixDecoration()");
        }
        this.mDecorationType = 3;
        this.mStringData = string;
        this.mDecorationPosition = n;
        this.mFont = null != font ? font : new Font("SansSerif", 0, 10);
        this.mTextColor = null != color ? color : Color.black;
    }

    public void setStringDecoration(String string, int n, Font font, Color color) throws PrintException {
        if (string == null || n < 1 || n > 6) {
            throw new PrintException("setStringDecoration()");
        }
        this.mDecorationType = 4;
        this.mStringData = string;
        this.mDecorationPosition = n;
        this.mFont = null != font ? font : new Font("SansSerif", 0, 10);
        this.mTextColor = null != color ? color : Color.black;
    }

    public String getDecorationString(int n, int n2) {
        String string = new String("");
        switch (this.mDecorationType) {
            case 2: {
                string = this.formatPageString(n, n2);
                break;
            }
            case 3: {
                string = this.formatMatrixString(n, n2);
                break;
            }
            case 1: 
            case 4: {
                string = this.mStringData;
                break;
            }
        }
        return string;
    }

    public int getDecorationType() {
        return this.mDecorationType;
    }

    public int getDecorationPosition() {
        return this.mDecorationPosition;
    }

    public int getHeight() {
        int n = 0;
        if (this.mFont != null) {
            n = this.mFont.getSize() + 2;
        }
        return n;
    }

    public Font getFont() {
        return this.mFont;
    }

    public Color getColor() {
        return this.mTextColor;
    }

    protected String formatPageString(int n, int n2) {
        String string = new String("");
        if (2 == this.mDecorationType) {
            int n3;
            String string2 = new String("");
            string = this.mStringData;
            int n4 = string.indexOf("%p");
            if (n4 >= 0) {
                string2 = string.substring(0, n4);
                string2 = string2 + Integer.toString(n);
                string = string2 = string2 + string.substring(n4 + 2);
            }
            if ((n3 = string.indexOf("%P")) >= 0) {
                string2 = string.substring(0, n3);
                string2 = string2 + Integer.toString(n2);
                string = string2 = string2 + string.substring(n3 + 2);
            }
        }
        return string;
    }

    protected String formatMatrixString(int n, int n2) {
        String string = new String("");
        if (3 == this.mDecorationType) {
            int n3;
            String string2 = "";
            string = this.mStringData;
            int n4 = string.indexOf("%r");
            if (n4 >= 0) {
                string2 = string.substring(0, n4);
                string2 = string2 + Integer.toString(n);
                string = string2 = string2 + string.substring(n4 + 2);
            }
            if ((n3 = string.indexOf("%c")) >= 0) {
                string2 = string.substring(0, n3);
                string2 = string2 + Integer.toString(n2);
                string = string2 = string2 + string.substring(n3 + 2);
            }
        }
        return string;
    }
}

