/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.print;

import com.ibm.statistics.lighttable.PrintSettings;
import com.ibm.statistics.lighttable.renderer.LtPrintRenderer;
import com.ibm.statistics.lighttable.renderer.SimpleRenderer;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.OutputItemAlignment;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.AppMgr;
import com.spss.java_client.core.documents.output.GenericItem;
import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.IPageSetupInfo;
import com.spss.java_client.core.documents.output.VizCache;
import com.spss.java_client.core.documents.output.chart.ChartItem;
import com.spss.java_client.core.documents.output.chart.JsonChartItem;
import com.spss.java_client.core.documents.output.export.FootnotesVisTemplate;
import com.spss.java_client.core.documents.output.header.HeaderItem;
import com.spss.java_client.core.documents.output.header.RootItem;
import com.spss.java_client.core.documents.output.interactive.JsonInteractiveItem;
import com.spss.java_client.core.documents.output.lighttable.LightTableItem;
import com.spss.java_client.core.documents.output.modelviewer.ModelItem;
import com.spss.java_client.core.documents.output.rgraph.ImageItem;
import com.spss.java_client.core.documents.output.table.TableItem;
import com.spss.java_client.core.documents.output.text.TextItem;
import com.spss.java_client.core.documents.output.treemodel.TreeModelItem;
import com.spss.java_client.core.template.viewer.PageAttributes;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.output.ChartViewerItem;
import com.spss.java_client.ui.doc_types.output.GenericViewerItem;
import com.spss.java_client.ui.doc_types.output.GraphBoardViewerItem;
import com.spss.java_client.ui.doc_types.output.HeaderViewerItem;
import com.spss.java_client.ui.doc_types.output.ImageViewerItem;
import com.spss.java_client.ui.doc_types.output.JsonChartViewerItem;
import com.spss.java_client.ui.doc_types.output.JsonInteractiveViewerItem;
import com.spss.java_client.ui.doc_types.output.LightTableViewerItem;
import com.spss.java_client.ui.doc_types.output.ModelViewerItem;
import com.spss.java_client.ui.doc_types.output.PageTitleViewerItem;
import com.spss.java_client.ui.doc_types.output.TableViewerItem;
import com.spss.java_client.ui.doc_types.output.TextViewerItem;
import com.spss.java_client.ui.doc_types.output.TreeModelViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.print.PrintOptions;
import com.spss.java_client.ui.print.SpssPrintable;
import com.spss.java_client.ui.print.TablePrintInfo;
import com.spss.java_client.ui.print.output.ChartRenderer;
import com.spss.java_client.ui.print.output.GenericRenderer;
import com.spss.java_client.ui.print.output.HeaderFooterHeightCalculator;
import com.spss.java_client.ui.print.output.PrintData;
import com.spss.java_client.ui.print.output.TextPrintData;
import com.spss.java_client.ui.print.output.TextRenderer;
import com.spss.java_client.ui.print.output.TreeRenderer;
import com.spss.java_client.ui.print.output.ViewerNode;
import com.spss.java_client.ui.print.output.XHTMLSplitter;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.texteditor.SpssTextPane;
import com.spss.pivottable.util.PvtLogger;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.export.IExportOptions;
import com.spss.shared.export.table_export.BaseImageRenderer;
import com.spss.shared.export.table_export.LightTableOutputManager;
import com.spss.shared.export.table_look.TableProperties;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.vis.CustomOutputManager;
import com.spss.vis.ResultsProcessor;
import com.spss.vis.Visualization;
import com.spss.vis.VisualizationFactory;
import com.spss.vis.component.VisualizationComponent;
import com.spss.vis.exception.VisualizationException;
import com.spss.vis.exception.VisualizationPageFitException;
import com.spss.vis.exception.VisualizationRuntimeException;
import com.spss.vis.graphboard.Graphboard;
import com.spss.vis.modelviewer.ModelViewer;
import com.spss.vis.modelviewer.interactivity.InformationController;
import com.spss.vis.modelviewer.main.ModelViewerImpl;
import com.spss.vis.modelviewer.view.View;
import com.spss.vis.modelviewer.view.common.InformationView;
import com.spss.vis.modelviewer.view.common.information.InformationPanel;
import com.spss.vis.processors.Graphics2DProcessor;
import com.spss.vis.specification.GraphSpecification;
import com.spss.vis.specification.LabelFrameSpecification;
import com.spss.vis.specification.LabelPurposeType;
import com.spss.vis.specification.Length;
import com.spss.vis.specification.Specification;
import com.spss.vis.specification.VisualizationSpecification;
import com.spss.vis.specification.data.DataSpecification;
import com.spss.vis.specification.data.EmbeddedSourceSpecification;
import com.spss.vis.specification.data.SourceVariableSpecification;
import com.spss.vis.specification.facet.FacetingSpecification;
import com.spss.vis.specification.facet.TableLayoutSpecification;
import com.spss.vis.specification.label.LabelSpecification;
import com.spss.vis.specification.label.TextSpecification;
import com.spss.vizimager.VizDataSource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;

public class OutputViewPrintable
extends SpssPrintable {
    private ViewerNode mViewerRoot;
    private Vector<ViewerItem> mViewerItems;
    private ITopWindow mFrame;
    private double mInterItemSpacing;
    private PrintedChartSize mSelectedChartSize;
    private int mStartPageNumber;
    private PrintRange mPrintRange;
    private final TableLayerPrintSetting mTableLayerSetting;
    private int mChartHeight;
    private int mChartWidth;
    private Map<Integer, List<PrintData>> mPrintDataMap;
    private int mCurrentPageNumber = 0;
    private double mCurrentY = 0.0;
    private TreeMap<Integer, String> mPagetTitleData = new TreeMap();
    private TreeMap<Integer, Color> mPagetTitleColor = new TreeMap();
    private Rectangle2D mHeaderBounds;
    private Rectangle2D mFooterBounds;
    private boolean mUniformHeader;
    private boolean mUniformFooter;
    private String mHeaderHtml;
    private String mFooterHtml;
    private IPageSetupInfo mPageSetupInfo;
    private double mTableMaxWidth = 0.0;
    private final String mMonitor = new String("ABC");
    private final String mTableRenderLock = new String("TRL");
    private volatile boolean mPreviewWindowClose = false;
    private boolean mIsPrintPreview = false;
    private boolean mUseITextPDFFix = false;
    private boolean mUseITextPDFFix_bidi = false;
    private int mNodeToBeMeasuredIndex;
    private List<ViewerNode> mPrintNodeList;
    private final String mPrintMsg = ResUtil.getString("IDS_PRINT_NODE_MSG");
    private final String mPrintPageMsg = ResUtil.getString("IDS_PRINTING_MSG");
    private List<TablePrintInfo> mUsedTablePrintInfoList = new ArrayList<TablePrintInfo>();
    private Map<CustomOutputManager, List<TablePrintInfo>> mCusTpisMap = new HashMap<CustomOutputManager, List<TablePrintInfo>>();
    private List<TablePrintInfo> mAllTpisList = new ArrayList<TablePrintInfo>();
    private List<PrintData> mAllModelPrintList = new ArrayList<PrintData>();
    private final int mAllowedMaxFootnotes = 30;
    private final double mPageFormatHeightScale = 0.98;
    private boolean mIsPrinting = true;
    private AffineTransform mSavedTransform;
    private ArrayList<ViewerItem> mTablesWithLongRowLabel;

    public OutputViewPrintable(ViewerFrame viewerFrame, PrintOptions printOptions) {
        this(viewerFrame, printOptions, null, TableLayerPrintSetting.eHONOR_TABLE_SETTING);
    }

    public OutputViewPrintable(ITopWindow iTopWindow, PrintOptions printOptions, PrintRange printRange, TableLayerPrintSetting tableLayerPrintSetting) {
        super(printOptions);
        this.mPageFormat = this.createPageFormat(iTopWindow);
        printOptions.setPageFormat(this.mPageFormat);
        this.mFrame = iTopWindow;
        this.mPrintRange = printRange;
        if (this.mPrintRange == null) {
            this.mPrintRange = PrintRange.eSELECTED;
        }
        this.mTableLayerSetting = tableLayerPrintSetting;
        this.mViewerItems = this.mFrame.getViewerDocument().getViewerItems();
        IOutputDocument iOutputDocument = this.mFrame.getViewerDocument().getCoreDocument();
        this.mPageSetupInfo = iOutputDocument.getPageSetupInfo();
        this.mInterItemSpacing = 12.0;
        String string = this.mPageSetupInfo.getSpaceAfter();
        if (string != null && string.length() > 0) {
            Length length = new Length(string);
            this.mInterItemSpacing = length.getValue();
        }
        this.mStartPageNumber = this.mPageSetupInfo.getInitPageNumber();
        this.getTree();
        this.removeRedundantNodes(this.mViewerRoot);
        if (printRange == PrintRange.eSELECTED) {
            this.setPrintSelection(true);
            this.mPrintHidden = false;
        } else if (printRange == PrintRange.eALL) {
            this.setPrintSelection(false);
            this.mPrintHidden = true;
        } else if (printRange == PrintRange.eVISIBLE) {
            this.setPrintSelection(false);
            this.mPrintHidden = false;
        }
    }

    @Override
    public synchronized void printInit() {
        this.init();
        this.fillPrintNodeList(this.mViewerRoot);
    }

    public synchronized void printInit(Vector<ViewerItem> vector) {
        this.init();
        this.mViewerItems = vector;
        for (ViewerItem viewerItem : vector) {
            ViewerNode viewerNode = new ViewerNode(this.mViewerRoot, viewerItem);
            viewerNode.setPrintable(true);
            this.mPrintNodeList.add(viewerNode);
        }
    }

    public void setPrintPreview(boolean bl) {
        this.mIsPrintPreview = bl;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        Object object;
        if (this.isCancel()) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.mSavedTransform = graphics2D.getTransform();
        this.mNumberOfPages = this.mPrintDataMap.keySet().size();
        PageFormat pageFormat2 = this.getPrintOPtions().getPageFormat();
        Shape shape = graphics2D.getClip();
        graphics2D.scale(this.mZoomFactor, this.mZoomFactor);
        graphics2D.translate(this.getImageableX(pageFormat2), pageFormat2.getImageableY());
        if (OSInfo.getOSType() == OSInfo.OSType.MAC && shape != null) {
            object = graphics2D.getClip().getBounds();
            if (((Rectangle)object).x > 0 && ((Rectangle)object).y > 0) {
                double d = pageFormat2.getImageableWidth();
                double d2 = pageFormat2.getImageableHeight();
                graphics2D.scale((d - (double)((Rectangle)object).x) / d, (d2 - (double)((Rectangle)object).y) / d2);
                object = graphics2D.getClip().getBounds();
                graphics2D.translate(((Rectangle)object).x > 0 ? ((Rectangle)object).x : 0, ((Rectangle)object).y > 0 ? ((Rectangle)object).y : 0);
            }
        }
        if ((object = this.mPrintDataMap.get(n)) == null || object.size() == 0 || n >= this.mCurrentPageNumber) {
            this.doPageMeasurements(n, graphics2D);
            object = this.mPrintDataMap.get(n);
        }
        if (object == null || this.mPrintDataMap.size() < n + 1) {
            return 1;
        }
        this.printHeader(graphics2D, n);
        ArrayList<ViewerItem> arrayList = new ArrayList<ViewerItem>();
        if (object != null) {
            for (PrintData printData : new ArrayList(object)) {
                ViewerItem viewerItem = printData.getViewerItem();
                if (viewerItem instanceof ChartViewerItem || viewerItem instanceof GraphBoardViewerItem) {
                    this.renderChart(viewerItem, printData.getBounds(), graphics2D, false);
                } else if (viewerItem instanceof ModelViewerItem) {
                    this.renderModel(printData, graphics2D, (ModelViewerItem)viewerItem, n);
                } else if (viewerItem instanceof ImageViewerItem) {
                    this.renderImage((ImageViewerItem)viewerItem, printData.getBounds(), graphics2D);
                } else if (viewerItem instanceof GenericViewerItem) {
                    this.renderGenericItem((GenericViewerItem)viewerItem, printData.getBounds(), graphics2D);
                } else if (viewerItem instanceof TableViewerItem) {
                    this.renderTable(printData, graphics2D, (TableViewerItem)viewerItem, n);
                } else if (viewerItem instanceof LightTableViewerItem) {
                    this.renderLightTable(printData, graphics2D, (LightTableViewerItem)viewerItem, n);
                    arrayList.add(viewerItem);
                } else if (viewerItem instanceof TextViewerItem) {
                    this.renderTextItem(printData, printData.getBounds(), graphics2D);
                } else if (viewerItem instanceof TreeModelViewerItem) {
                    this.renderTreeModelItem((TreeModelViewerItem)viewerItem, graphics2D, printData);
                }
                if (viewerItem instanceof JsonChartViewerItem) {
                    this.renderJsonChart(printData, viewerItem, printData.getBounds(), graphics2D);
                }
                if (!(viewerItem instanceof JsonInteractiveViewerItem)) continue;
                this.renderJsonInteractiveItem(printData, viewerItem, printData.getBounds(), graphics2D);
            }
        }
        this.printFooter(graphics2D, n);
        graphics2D.setClip(shape);
        if (this.mIsPrintPreview) {
            this.showLongTableRowLableMessageForPrintPreview(arrayList);
        }
        return 0;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n, boolean bl) throws PrinterException {
        Object object;
        if (this.isCancel()) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.mSavedTransform = graphics2D.getTransform();
        this.mNumberOfPages = this.mPrintDataMap.keySet().size();
        PageFormat pageFormat2 = this.getPrintOPtions().getPageFormat();
        Shape shape = graphics2D.getClip();
        graphics2D.scale(this.mZoomFactor, this.mZoomFactor);
        graphics2D.translate(this.getImageableX(pageFormat2), pageFormat2.getImageableY());
        if (OSInfo.getOSType() == OSInfo.OSType.MAC && shape != null) {
            object = graphics2D.getClip().getBounds();
            if (((Rectangle)object).x > 0 && ((Rectangle)object).y > 0) {
                double d = pageFormat2.getImageableWidth();
                double d2 = pageFormat2.getImageableHeight();
                graphics2D.scale((d - (double)((Rectangle)object).x) / d, (d2 - (double)((Rectangle)object).y) / d2);
                object = graphics2D.getClip().getBounds();
                graphics2D.translate(((Rectangle)object).x > 0 ? ((Rectangle)object).x : 0, ((Rectangle)object).y > 0 ? ((Rectangle)object).y : 0);
            }
        }
        if ((object = this.mPrintDataMap.get(n)) == null || object.size() == 0 || n >= this.mCurrentPageNumber) {
            this.doPageMeasurements(n, graphics2D);
            object = this.mPrintDataMap.get(n);
        }
        if (object == null || this.mPrintDataMap.size() < n + 1) {
            return 1;
        }
        this.printHeader(graphics2D, n);
        boolean bl2 = false;
        ArrayList<ViewerItem> arrayList = new ArrayList<ViewerItem>();
        if (object != null) {
            for (PrintData printData : new ArrayList(object)) {
                ViewerItem viewerItem = printData.getViewerItem();
                if (viewerItem instanceof ChartViewerItem || viewerItem instanceof GraphBoardViewerItem) {
                    this.renderChart(viewerItem, printData.getBounds(), graphics2D, bl);
                    bl2 = true;
                }
                if (bl && bl2) break;
                if (viewerItem instanceof ModelViewerItem && !bl) {
                    this.renderModel(printData, graphics2D, (ModelViewerItem)viewerItem, n);
                } else if (viewerItem instanceof ImageViewerItem && !bl) {
                    this.renderImage((ImageViewerItem)viewerItem, printData.getBounds(), graphics2D);
                } else if (viewerItem instanceof GenericViewerItem && !bl) {
                    this.renderGenericItem((GenericViewerItem)viewerItem, printData.getBounds(), graphics2D);
                } else if (viewerItem instanceof TableViewerItem && !bl) {
                    this.renderTable(printData, graphics2D, (TableViewerItem)viewerItem, n);
                } else if (viewerItem instanceof LightTableViewerItem && !bl) {
                    this.renderLightTable(printData, graphics2D, (LightTableViewerItem)viewerItem, n);
                    arrayList.add(viewerItem);
                } else if (viewerItem instanceof TextViewerItem && !bl) {
                    this.renderTextItem(printData, printData.getBounds(), graphics2D);
                } else if (viewerItem instanceof TreeModelViewerItem && !bl) {
                    this.renderTreeModelItem((TreeModelViewerItem)viewerItem, graphics2D, printData);
                }
                if (viewerItem instanceof JsonChartViewerItem && !bl) {
                    this.renderJsonChart(printData, viewerItem, printData.getBounds(), graphics2D);
                }
                if (!(viewerItem instanceof JsonInteractiveViewerItem) || bl) continue;
                this.renderJsonInteractiveItem(printData, viewerItem, printData.getBounds(), graphics2D);
            }
        }
        this.printFooter(graphics2D, n);
        graphics2D.setClip(shape);
        if (this.mIsPrintPreview) {
            this.showLongTableRowLableMessageForPrintPreview(arrayList);
        }
        return 0;
    }

    public ViewerNode getViewerRoot() {
        return this.mViewerRoot;
    }

    @Override
    public void reset() {
    }

    @Override
    public void dispose() {
        Object object;
        for (TablePrintInfo object22 : this.mAllTpisList) {
            boolean iterator;
            if (object22.getTableViewerItem() == null || (object = object22.getTableViewerItem().getDataFilterInfo()) == null || !(iterator = object.isCachedDisplayRows())) continue;
            object.setCachedDisplayRows(false);
            object.setDisplayFiltering(true);
        }
        this.mAllTpisList.clear();
        this.mCusTpisMap.clear();
        this.mUsedTablePrintInfoList.clear();
        Collection<List<PrintData>> collection = this.mPrintDataMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (List)iterator.next();
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                LightTableOutputManager lightTableOutputManager;
                PrintData printData = (PrintData)iterator2.next();
                TablePrintInfo tablePrintInfo = printData.getTablePrintInfo();
                if (tablePrintInfo == null) continue;
                CustomOutputManager customOutputManager = tablePrintInfo.getCustomManager();
                if (customOutputManager != null) {
                    customOutputManager.dispose();
                    tablePrintInfo.setCustomOutputManager(null);
                }
                if ((lightTableOutputManager = tablePrintInfo.getLightPrintManager()) == null) continue;
                lightTableOutputManager.dispose();
            }
        }
        this.mPrintDataMap.clear();
        VizCache.getCache().clearCache();
        this.mViewerItems = null;
        this.mPagetTitleData.clear();
    }

    @Override
    public boolean hasAnySelected() {
        return this.checkNodesSelection(this.mViewerRoot);
    }

    @Override
    public int getMediaTrayValue() {
        return this.mPageSetupInfo.getPaperSource();
    }

    @Override
    public int getTotalNumberOfPages() {
        this.mNumberOfPages = this.mPrintDataMap.keySet().size();
        return this.mNumberOfPages;
    }

    public boolean useITextPdfFix() {
        return this.mUseITextPDFFix;
    }

    public void setITextPdfFix(boolean bl) {
        this.mUseITextPDFFix = bl;
    }

    public boolean useITextPdfFix_bidi() {
        return this.mUseITextPDFFix_bidi;
    }

    public void setITextPdfFix_bidi(boolean bl) {
        this.mUseITextPDFFix_bidi = bl;
    }

    public void setIsPrinting(boolean bl) {
        this.mIsPrinting = bl;
    }

    public void showLongTableRowLableMessage() {
        if (this.mTablesWithLongRowLabel.size() > 0) {
            String string = ResUtil.getCommonDlgString("IDS_LONG_TABLE_ROW_LABEL_WARNING");
            string = ResUtil.wrapStringByWord(string, 80) + "\n\n";
            for (ViewerItem viewerItem : this.mTablesWithLongRowLabel) {
                string = string + ResUtil.wrapStringByWord(viewerItem.getName(), 80) + "\n";
            }
            JOptionPane.showMessageDialog(null, string);
        }
    }

    private void doHeaderFooterCalculation() {
        Locale locale = ComponentState.getSPSSLocale();
        Calendar calendar = Calendar.getInstance(locale);
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        String string = dateFormat.format(calendar.getTime());
        dateFormat = DateFormat.getTimeInstance(2, locale);
        String string2 = dateFormat.format(calendar.getTime());
        File file = this.mFrame.getCoreDocument().getFileSpec();
        String string3 = "";
        if (file != null && (string3 = file.getAbsolutePath()) == null) {
            string3 = "";
        }
        if (string3.length() == 0) {
            string3 = "[" + this.mFrame.getCoreDocument().getDocName() + "]";
        }
        this.mHeaderHtml = HeaderFooterHeightCalculator.doDateTimeFilePathReplacement(this.getHeaderPrintHTML(), string, string2, string3);
        HeaderFooterHeightCalculator headerFooterHeightCalculator = new HeaderFooterHeightCalculator(this.mViewerRoot, this.mHeaderHtml, this.mPageFormat.getImageableWidth(), false);
        headerFooterHeightCalculator.calculateHeight(this.mHeaderHtml);
        this.mUniformHeader = headerFooterHeightCalculator.getUniform();
        this.mHeaderBounds = new Rectangle2D.Double(0.0, 0.0, this.mPageFormat.getImageableWidth(), headerFooterHeightCalculator.getMaxHeight());
        this.mFooterHtml = HeaderFooterHeightCalculator.doDateTimeFilePathReplacement(this.getFooterPrintHTML(), string, string2, string3);
        HeaderFooterHeightCalculator headerFooterHeightCalculator2 = new HeaderFooterHeightCalculator(this.mViewerRoot, this.mFooterHtml, this.mPageFormat.getImageableWidth(), true);
        headerFooterHeightCalculator2.calculateHeight(this.mFooterHtml);
        this.mUniformFooter = headerFooterHeightCalculator2.getUniform();
        double d = this.mPageFormat.getImageableHeight() - headerFooterHeightCalculator2.getMaxHeight();
        this.mFooterBounds = new Rectangle2D.Double(0.0, d, this.mPageFormat.getImageableWidth(), headerFooterHeightCalculator2.getMaxHeight());
    }

    private void printHeader(Graphics2D graphics2D, int n) {
        Shape shape = graphics2D.getClip();
        String string = this.getHeaderFooter(n, this.mHeaderHtml, this.mUniformHeader);
        Color color = this.mPagetTitleColor.get(n);
        if (color == null) {
            color = this.mPagetTitleColor.get(this.findLastPageWithHeader(n));
        }
        TextRenderer textRenderer = new TextRenderer(string, this.getPrintableWidth(), this.getPrintableHeightForItems(), true, color);
        textRenderer.doPaging(this.getPrintableHeightForItems());
        textRenderer.print(graphics2D, 0);
        graphics2D.setClip(shape);
    }

    private void printFooter(Graphics2D graphics2D, int n) {
        Shape shape = graphics2D.getClip();
        String string = this.getHeaderFooter(n, this.mFooterHtml, this.mUniformFooter);
        graphics2D.translate(this.mFooterBounds.getX(), this.mFooterBounds.getY());
        Color color = this.mPagetTitleColor.get(n);
        if (color == null) {
            color = this.mPagetTitleColor.get(this.findLastPageWithHeader(n));
        }
        TextRenderer textRenderer = new TextRenderer(string, this.getPrintableWidth(), this.getPrintableHeightForItems(), true, color);
        textRenderer.doPaging(this.getPrintableHeightForItems());
        textRenderer.print(graphics2D, 0);
        graphics2D.setClip(shape);
    }

    private String getHeaderFooter(int n, String string, boolean bl) {
        String string2;
        String string3 = string;
        int n2 = n;
        if (this.mPagetTitleData.get(n) == null) {
            n2 = this.findLastPageWithHeader(n);
        }
        if (string3.contains("&[Page]")) {
            string3 = this.getHTMLString(string3, "&[Page]", String.valueOf(n + this.mStartPageNumber));
        } else if (string3.contains("&amp;[Page]")) {
            string3 = this.getHTMLString(string3, "&amp;[Page]", String.valueOf(n + this.mStartPageNumber));
        }
        String string4 = this.mPagetTitleData.get(n);
        if (string4 != null && string4.contains("\n")) {
            string4 = string4.replace("\n", "<BR>");
        }
        if (string3.contains("&[PageTitle]")) {
            if (string4 == null && n > n2) {
                string4 = this.mPagetTitleData.get(n2);
            }
            if (string4 != null) {
                if (string4.contains("\n")) {
                    string4 = string4.replace("\n", "<BR>");
                }
                string3 = this.getHTMLString(string3, "&[PageTitle]", string4);
            } else {
                string3 = this.getHTMLString(string3, "&[PageTitle]", "");
            }
        } else if (string3.contains("&amp;[PageTitle]")) {
            if (string4 == null && n > n2) {
                string4 = this.mPagetTitleData.get(n2);
            }
            if (string4 != null) {
                if (string4.contains("\n")) {
                    string4 = string4.replace("\n", "<BR>");
                }
                string3 = this.getHTMLString(string3, "&amp;[PageTitle]", string4);
            } else {
                string3 = this.getHTMLString(string3, "&amp;[PageTitle]", "");
            }
        }
        List<PrintData> list = this.mPrintDataMap.get(n);
        int n3 = 0;
        Vector<ViewerItem> vector = null;
        if (list != null && list.size() > 0 && list.get(0) != null) {
            n3 = list.get(0).getViewerNode().getHeaders().size();
            vector = list.get(0).getViewerNode().getHeaders();
        }
        boolean bl2 = string3.contains("&amp;[Head1]");
        boolean bl3 = string3.contains("&[Head1]");
        boolean bl4 = string3.contains("&amp;\\[Head1\\]");
        if (bl2 || bl3 || bl4) {
            string2 = "";
            if (n3 > 0) {
                string2 = ((ViewerItem)vector.get(0)).getCoreItem().getDescription();
            }
            if (string2 == null) {
                string2 = "";
            }
            string3 = bl2 ? this.replaceString(string3, "&amp;[Head1]", string2) : (bl3 ? this.replaceString(string3, "&[Head1]", string2) : this.replaceString(string3, "&amp;\\[Head1\\]", string2));
        }
        bl2 = string3.contains("&amp;[Head2]");
        bl3 = string3.contains("&[Head2]");
        bl4 = string3.contains("&amp;\\[Head2\\]");
        if (bl2 || bl3 || bl4) {
            string2 = "";
            if (n3 > 1) {
                string2 = vector.get(1).getCoreItem().getDescription();
            }
            if (string2 == null) {
                string2 = "";
            }
            string3 = bl2 ? this.replaceString(string3, "&amp;[Head2]", string2) : (bl3 ? this.replaceString(string3, "&[Head2]", string2) : this.replaceString(string3, "&amp;\\[Head2\\]", string2));
        }
        bl2 = string3.contains("&amp;[Head3]");
        bl3 = string3.contains("&[Head3]");
        bl4 = string3.contains("&amp;\\[Head3\\]");
        if (bl2 || bl3 || bl4) {
            string2 = "";
            if (n3 > 2) {
                string2 = vector.get(2).getCoreItem().getDescription();
            }
            if (string2 == null) {
                string2 = "";
            }
            string3 = bl2 ? this.replaceString(string3, "&amp;[Head3]", string2) : (bl3 ? this.replaceString(string3, "&[Head3]", string2) : this.replaceString(string3, "&amp;\\[Head3\\]", string2));
        }
        bl2 = string3.contains("&amp;[Head4]");
        bl3 = string3.contains("&[Head4]");
        bl4 = string3.contains("&amp;\\[Head4\\]");
        if (bl2 || bl3 || bl4) {
            string2 = "";
            if (n3 > 3) {
                string2 = vector.get(3).getCoreItem().getDescription();
            }
            if (string2 == null) {
                string2 = "";
            }
            string3 = bl2 ? this.replaceString(string3, "&amp;[Head4]", string2) : (bl3 ? this.replaceString(string3, "&[Head4]", string2) : this.replaceString(string3, "&amp;\\[Head4\\]", string2));
        }
        if (string3.contains("&[Page]")) {
            string3 = string3.replace("&amp;[Page]", Integer.toString(n + this.mStartPageNumber));
        }
        return string3;
    }

    private void renderChart(ViewerItem viewerItem, Rectangle2D rectangle2D, Graphics2D graphics2D, boolean bl) {
        Shape shape = graphics2D.getClip();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(rectangle2D.getX(), rectangle2D.getY());
        if (bl) {
            graphics2D.translate(-95, -95);
        }
        RenderingHints renderingHints = (RenderingHints)graphics2D.getRenderingHints().clone();
        ChartRenderer chartRenderer = new ChartRenderer(viewerItem, (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        PageFormat pageFormat = (PageFormat)this.mPageFormat.clone();
        pageFormat.setOrientation(1);
        if ("Adobe PDF".equalsIgnoreCase(this.mPrinterName)) {
            chartRenderer.setCanPrintShadow(false);
        }
        if (!this.useITextPdfFix_bidi()) {
            if (bl) {
                chartRenderer.renderWithoutScaling(graphics2D, pageFormat);
            } else {
                chartRenderer.render(graphics2D, pageFormat);
            }
        } else if (bl) {
            chartRenderer.renderWithoutScaling(graphics2D, pageFormat, true);
        } else {
            chartRenderer.render(graphics2D, pageFormat, true);
        }
        graphics2D.setRenderingHints(renderingHints);
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
    }

    private void renderJsonChart(PrintData printData, ViewerItem viewerItem, Rectangle2D rectangle2D, Graphics2D graphics2D) {
        Shape shape = graphics2D.getClip();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(rectangle2D.getX(), rectangle2D.getY());
        double d = printData.getChartRatio();
        if (d > 1.0) {
            graphics2D.scale(1.0 / d, 1.0 / d);
        }
        JsonChartItem jsonChartItem = (JsonChartItem)viewerItem.getCoreItem();
        BufferedImage bufferedImage = jsonChartItem.render();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
    }

    private void renderJsonInteractiveItem(PrintData printData, ViewerItem viewerItem, Rectangle2D rectangle2D, Graphics2D graphics2D) {
        Shape shape = graphics2D.getClip();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(rectangle2D.getX(), rectangle2D.getY());
        double d = printData.getChartRatio();
        if (d > 1.0) {
            graphics2D.scale(1.0 / d, 1.0 / d);
        }
        JsonInteractiveItem jsonInteractiveItem = (JsonInteractiveItem)viewerItem.getCoreItem();
        BufferedImage bufferedImage = printData.getImage() != null ? printData.getImage() : jsonInteractiveItem.render();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
    }

    private void renderModel(PrintData printData, final Graphics2D graphics2D, ModelViewerItem modelViewerItem, int n) {
        AffineTransform affineTransform;
        Shape shape;
        block12: {
            shape = graphics2D.getClip();
            affineTransform = graphics2D.getTransform();
            Rectangle2D.Double double_ = printData.getBounds();
            graphics2D.translate(((RectangularShape)double_).getX(), ((RectangularShape)double_).getY());
            int n2 = ((RectangularShape)double_).getY() + ((RectangularShape)double_).getHeight() + 4.0 < this.mFooterBounds.getY() ? (int)((RectangularShape)double_).getHeight() + 4 : (int)(this.mFooterBounds.getY() - ((RectangularShape)double_).getY());
            graphics2D.setClip(-2, -2, (int)this.mPageFormat.getImageableWidth() + 4, n2);
            try {
                Graphics2DProcessor graphics2DProcessor = new Graphics2DProcessor(graphics2D){

                    public FontRenderContext getFontRenderContext() {
                        return graphics2D.getFontRenderContext();
                    }
                };
                TablePrintInfo tablePrintInfo = printData.getTablePrintInfo();
                if (tablePrintInfo == null) {
                    if ("Information".equals(printData.getModelViewInfoId())) {
                        ModelViewer modelViewer = modelViewerItem.getModelViewer();
                        Graphboard graphboard = modelViewer.getComponent().getGraphboard(true);
                        VisualizationComponent visualizationComponent = graphboard.getVisualizationComponent();
                        List list = ((ModelViewerImpl)modelViewer).getViews();
                        for (View view : list) {
                            if (!(view instanceof InformationView)) continue;
                            InformationView informationView = (InformationView)view;
                            List list2 = informationView.getUserController(ComponentState.getOLangLocale(), graphboard);
                            InformationPanel informationPanel = ((InformationController)list2.get(0)).getInformationPanel();
                            if (informationPanel.getParent() == null) {
                                JDialog jDialog = new JDialog();
                                jDialog.getContentPane().add((Component)informationPanel);
                                jDialog.setSize((int)this.mPageFormat.getImageableWidth(), (int)this.mPageFormat.getImageableHeight());
                                jDialog.setVisible(true);
                                jDialog.setVisible(false);
                                informationPanel.print(graphics2D);
                                jDialog.dispose();
                            } else {
                                informationPanel.print(graphics2D);
                            }
                            break block12;
                        }
                        break block12;
                    }
                    Visualization visualization = printData.getVisualization();
                    if (visualization == null) {
                        visualization = this.createVisualizationForModel(printData, modelViewerItem.getModelViewer());
                    }
                    printData.setPageIndex(n);
                    if (printData.getVisSize() != null) {
                        Dimension dimension = printData.getVisSize();
                        visualization.setOutputSize((int)((RectangularShape)double_).getWidth(), (int)((RectangularShape)double_).getHeight());
                        visualization.runProcessor((ResultsProcessor)graphics2DProcessor);
                        visualization.setOutputSize(dimension.width, dimension.height);
                    } else {
                        visualization.runProcessor((ResultsProcessor)graphics2DProcessor);
                    }
                    break block12;
                }
                tablePrintInfo.setPageIndex(n);
                graphics2DProcessor.setParameter("printing_fix", "true");
                CustomOutputManager customOutputManager = tablePrintInfo.getCustomManager();
                if (customOutputManager == null) {
                    customOutputManager = this.createCustomOutputManagerForModelTable(tablePrintInfo, modelViewerItem.getModelViewer(), graphics2D);
                }
                if (customOutputManager == null) {
                    return;
                }
                customOutputManager.setFirstPageFormat(tablePrintInfo.getFirstPageFormat());
                customOutputManager.setShrinkToFit(false, false);
                customOutputManager.runProcessor((ResultsProcessor)graphics2DProcessor, tablePrintInfo.getPageDimension());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
    }

    private void renderImage(ImageViewerItem imageViewerItem, Rectangle2D rectangle2D, Graphics2D graphics2D) {
        Shape shape = graphics2D.getClip();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(rectangle2D.getX(), rectangle2D.getY());
        graphics2D.setClip(-2, -2, (int)this.mPageFormat.getImageableWidth() + 4, (int)rectangle2D.getHeight() + 4);
        imageViewerItem.print(graphics2D, (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderTable(PrintData printData, Graphics2D graphics2D, TableViewerItem tableViewerItem, int n) {
        Shape shape = graphics2D.getClip();
        AffineTransform affineTransform = graphics2D.getTransform();
        Rectangle2D.Double double_ = printData.getBounds();
        graphics2D.translate(((RectangularShape)double_).getX(), ((RectangularShape)double_).getY());
        try {
            CustomOutputManager customOutputManager;
            TablePrintInfo tablePrintInfo = printData.getTablePrintInfo();
            tablePrintInfo.setPageIndex(n);
            tablePrintInfo.setTableViewerItem(tableViewerItem);
            if (tablePrintInfo.isNoScale()) {
                graphics2D.setTransform(this.mSavedTransform);
            }
            Graphics2DProcessor graphics2DProcessor = new Graphics2DProcessor(graphics2D);
            graphics2DProcessor.setParameter("printing_fix", "true");
            if (this.mUseITextPDFFix) {
                graphics2DProcessor.setParameter("iTextPdfBug", (Object)Boolean.TRUE);
                if (this.isRtLSpssLocale() || this.isRtLOLang()) {
                    graphics2DProcessor.setParameter("iTextPdfBug2", (Object)Boolean.TRUE);
                }
            }
            if ((customOutputManager = tablePrintInfo.getCustomManager()) == null) {
                customOutputManager = this.createCustomOutputManagerForTable(tablePrintInfo, tableViewerItem, graphics2D);
                if (tablePrintInfo.isNoScale()) {
                    customOutputManager.setAffineTransform(AffineTransform.getScaleInstance(1.0, 1.0));
                    if (tablePrintInfo.isFitWidth() || tablePrintInfo.isFitHeight()) {
                        customOutputManager.setShrinkToFit(tablePrintInfo.isFitWidth(), tablePrintInfo.isFitHeight());
                    }
                }
            }
            String string = this.mTableRenderLock;
            synchronized (string) {
                customOutputManager.runProcessor((ResultsProcessor)graphics2DProcessor, tablePrintInfo.getPageDimension());
            }
            this.tablePrintMemoryHandle(customOutputManager, tablePrintInfo, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
    }

    private boolean isRtLSpssLocale() {
        Locale locale = ComponentState.getSPSSLocale();
        String string = locale.getLanguage();
        return string.equalsIgnoreCase("he") || string.equalsIgnoreCase("iw") || string.equalsIgnoreCase("ar");
    }

    private boolean isRtLOLang() {
        Locale locale = ComponentState.getOLangLocale();
        String string = locale.getLanguage();
        return string.equalsIgnoreCase("he") || string.equalsIgnoreCase("iw") || string.equalsIgnoreCase("ar");
    }

    private void renderLightTable(PrintData printData, Graphics2D graphics2D, LightTableViewerItem lightTableViewerItem, int n) {
        Shape shape = graphics2D.getClip();
        AffineTransform affineTransform = graphics2D.getTransform();
        Rectangle2D.Double double_ = printData.getBounds();
        graphics2D.translate(((RectangularShape)double_).getX(), ((RectangularShape)double_).getY());
        if (!this.mIsPrintPreview) {
            graphics2D.setClip(-2, -2, (int)this.mPageFormat.getImageableWidth() + 4, (int)((RectangularShape)double_).getHeight() + 5);
        }
        try {
            TablePrintInfo tablePrintInfo = printData.getTablePrintInfo();
            LightTableOutputManager lightTableOutputManager = tablePrintInfo.getLightPrintManager();
            if (lightTableOutputManager.getLightPivotTable().getCurrentLayerIndex() != tablePrintInfo.getLayerIndex()) {
                lightTableOutputManager.setLayerChanged();
                lightTableOutputManager.getLightPivotTable().setCurrentLayerIndex(tablePrintInfo.getLayerIndex());
            }
            lightTableOutputManager.render(graphics2D, tablePrintInfo.getPageDimension());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
    }

    private void tablePrintMemoryHandle(CustomOutputManager customOutputManager, TablePrintInfo tablePrintInfo, int n) {
        List<TablePrintInfo> list = this.mCusTpisMap.get(customOutputManager);
        if (list == null) {
            list = new ArrayList<TablePrintInfo>();
            this.mCusTpisMap.put(customOutputManager, list);
        }
        list.add(tablePrintInfo);
        this.mAllTpisList.add(tablePrintInfo);
        if (tablePrintInfo.isLastPart()) {
            this.mUsedTablePrintInfoList.add(tablePrintInfo);
            this.releaseMemory(n);
        }
    }

    private void modelPrintMemoryHandle(PrintData printData, int n) {
        this.mAllModelPrintList.add(printData);
        for (PrintData printData2 : this.mAllModelPrintList) {
            if (printData2.getPageIndex() >= n) continue;
            if (printData2.getVisualization() != null) {
                printData2.getVisualization().setSpecification(new VisualizationSpecification());
            }
            printData2.setVisualization(null);
        }
    }

    private void releaseMemory(int n) {
        ArrayList<TablePrintInfo> arrayList = new ArrayList<TablePrintInfo>();
        for (TablePrintInfo tablePrintInfo : this.mUsedTablePrintInfoList) {
            CustomOutputManager customOutputManager;
            if (tablePrintInfo.getPageIndex() >= n || (customOutputManager = tablePrintInfo.getCustomManager()) == null) continue;
            if (tablePrintInfo.getTableViewerItem() != null) {
                VizCache.getCache().clearItem(tablePrintInfo.getTableViewerItem().getId());
            }
            if (tablePrintInfo.getVizObj() != null) {
                tablePrintInfo.getVizObj().setSpecification(new VisualizationSpecification());
                tablePrintInfo.setVizObj(null);
            }
            customOutputManager.dispose();
            List<TablePrintInfo> list = this.mCusTpisMap.get(customOutputManager);
            for (TablePrintInfo tablePrintInfo2 : list) {
                tablePrintInfo2.setCustomOutputManager(null);
            }
            list.clear();
            this.mCusTpisMap.remove(customOutputManager);
            arrayList.add(tablePrintInfo);
        }
        if (arrayList.size() > 0) {
            this.mUsedTablePrintInfoList.removeAll(arrayList);
        }
    }

    private void renderGenericItem(GenericViewerItem genericViewerItem, Rectangle2D rectangle2D, Graphics2D graphics2D) {
        Shape shape = graphics2D.getClip();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(rectangle2D.getX(), rectangle2D.getY());
        GenericRenderer genericRenderer = new GenericRenderer(genericViewerItem, (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        genericRenderer.render(graphics2D);
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
    }

    private void renderTextItem(PrintData printData, Rectangle2D rectangle2D, Graphics2D graphics2D) {
        Shape shape = graphics2D.getClip();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(0.0, rectangle2D.getY());
        TextPrintData textPrintData = (TextPrintData)printData;
        TextRenderer textRenderer = textPrintData.getRenderer();
        textRenderer.print(graphics2D, textPrintData.getTextRendererPage());
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
    }

    private void renderTreeModelItem(TreeModelViewerItem treeModelViewerItem, Graphics2D graphics2D, PrintData printData) {
        Shape shape = graphics2D.getClip();
        AffineTransform affineTransform = graphics2D.getTransform();
        Rectangle2D.Double double_ = printData.getBounds();
        graphics2D.translate(double_.getX(), double_.getY());
        TreeRenderer treeRenderer = new TreeRenderer(treeModelViewerItem, (int)double_.getWidth(), (int)double_.getHeight());
        treeRenderer.render(graphics2D, printData.getTreePageDim());
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
    }

    private RootItem getRoot() {
        ViewerDocument viewerDocument = this.mFrame.getViewerDocument();
        Vector<ViewerItem> vector = viewerDocument.getViewerItems();
        for (ViewerItem viewerItem : vector) {
            IOutputItem iOutputItem = viewerItem.getCoreItem();
            while (iOutputItem.getParentItem() != null) {
                iOutputItem = iOutputItem.getParentItem();
            }
            if (!(iOutputItem instanceof RootItem)) continue;
            return (RootItem)iOutputItem;
        }
        return null;
    }

    private void getTree() {
        this.mViewerRoot = new ViewerNode(null, null);
        this.addChilds((HeaderItem)this.getRoot(), this.mViewerRoot);
    }

    private boolean removeRedundantNodes(ViewerNode viewerNode) {
        ArrayList<ViewerNode> arrayList = new ArrayList<ViewerNode>();
        if (viewerNode.getParent() == null || viewerNode.getViewerItem() instanceof HeaderViewerItem) {
            ArrayList<ViewerNode> arrayList2 = viewerNode.getChildNodes();
            for (ViewerNode viewerNode2 : arrayList2) {
                if (!this.removeRedundantNodes(viewerNode2)) continue;
                arrayList.add(viewerNode2);
            }
            for (ViewerNode viewerNode2 : arrayList) {
                arrayList2.remove(viewerNode2);
            }
            if (arrayList2.size() == 0) {
                return true;
            }
        }
        return false;
    }

    private void addChilds(HeaderItem headerItem, ViewerNode viewerNode) {
        int n = headerItem.getChildCount();
        for (int i = 0; i < n; ++i) {
            IOutputItem iOutputItem = headerItem.getChildItem(i);
            ViewerNode viewerNode2 = new ViewerNode(viewerNode, this.getRespectiveViewerItem(iOutputItem));
            viewerNode.addChild(viewerNode2);
            this.setPrintProperty(viewerNode2);
            if (!(iOutputItem instanceof HeaderItem)) continue;
            this.addChilds((HeaderItem)iOutputItem, viewerNode2);
        }
    }

    private void setPrintProperty(ViewerNode viewerNode) {
        if (viewerNode == null || viewerNode.getViewerItem() == null) {
            return;
        }
        switch (this.mPrintRange) {
            case eALL: {
                if (!viewerNode.getViewerItem().isCollapsed()) {
                    viewerNode.setPrintable(true);
                    break;
                }
                viewerNode.setPrintable(false);
                break;
            }
            case eSELECTED: {
                viewerNode.setPrintable(viewerNode.getViewerItem().isSelected());
                break;
            }
            case eVISIBLE: {
                viewerNode.setPrintable(viewerNode.getViewerItem().isVisible());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ViewerItem getRespectiveViewerItem(IOutputItem iOutputItem) {
        Object object = this.mFrame.getViewerDocument().getItemLock();
        synchronized (object) {
            for (ViewerItem viewerItem : this.mViewerItems) {
                if (!viewerItem.getCoreItem().equals(iOutputItem)) continue;
                return viewerItem;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void measureTextItem(ViewerNode viewerNode, boolean bl) {
        void var14_20;
        List<String> list;
        Object object;
        Object object2;
        if (viewerNode.getViewerItem().isHidden() && !this.mPrintHidden) {
            return;
        }
        if (this.mPrintSelection && !viewerNode.getViewerItem().isSelected()) {
            return;
        }
        boolean bl2 = false;
        TextViewerItem textViewerItem = (TextViewerItem)viewerNode.getViewerItem();
        boolean bl3 = !textViewerItem.getTextPane().isHTMLDocument();
        TextItem textItem = (TextItem)textViewerItem.getCoreItem();
        OutputItemAlignment outputItemAlignment = textItem.getAlignment();
        Map<TextAttribute, ?> map = null;
        boolean bl4 = this.hasAnyPrintableItemBeforeMe(viewerNode.getViewerItem());
        if (bl3) {
            map = textViewerItem.getTextPane().getFont().getAttributes();
            object2 = textViewerItem.getText();
            object = ((String)object2).split("(\\f|\u000f)\n");
            list = new ArrayList<String>(((String[])object).length);
            for (Object object3 : object) {
                boolean bl5;
                boolean bl6 = bl5 = ((String)object3).length() > 0 || list.size() == 0 && bl4;
                if (!bl5) continue;
                list.add((String)object3);
            }
        } else {
            String string = textItem.getXHTMLContents();
            if (string.contains("pageBreak.png")) {
                int n = string.indexOf("<img");
                int n2 = string.indexOf(">", n + 1);
                String i = string.substring(n, n2);
                string = string.replace(i, "\u00ad");
                XHTMLSplitter xHTMLSplitter = new XHTMLSplitter(string);
                List<String> list2 = xHTMLSplitter.getSplittedHtmls();
                list = new ArrayList<String>();
                for (String list3 : list2) {
                    if (list3.contains("\u00ad")) {
                        String[] stringArray;
                        for (String string2 : stringArray = list3.split("\u00ad")) {
                            list.add(string2.replace("&gt;", ""));
                        }
                        continue;
                    }
                    list.add(list3);
                }
            } else {
                XHTMLSplitter xHTMLSplitter = new XHTMLSplitter(string);
                list = xHTMLSplitter.getSplittedHtmls();
            }
        }
        int n = list.size();
        object2 = viewerNode.getTextRendererList();
        if (this.isPageBreakItem((IOutputItem)textItem)) {
            this.moveToNextPage();
        }
        boolean bl7 = false;
        while (var14_20 < n) {
            if (this.mIsPrintPreview && object2 != null && ((ArrayList)object2).size() > var14_20) {
                object = (TextRenderer)((ArrayList)object2).get((int)var14_20);
            } else {
                String string = list.get((int)var14_20);
                if (bl3) {
                    string = string.replace(" ", "\u00a0");
                    object = new TextRenderer(string, map, this.getPrintableWidth(), this.getPrintableHeightForItems(), textViewerItem.getTextPane().getForeground());
                } else {
                    object = new TextRenderer(string, this.getPrintableWidth(), this.getPrintableHeightForItems(), outputItemAlignment);
                }
            }
            ((TextRenderer)object).setPrintPreView(this.mIsPrintPreview);
            ((TextRenderer)object).doPaging(this.getAvailPrintHeightForItems());
            int n2 = ((TextRenderer)object).getNumberOfPages();
            for (int i = 0; i < n2; ++i) {
                Object object3;
                if (((TextRenderer)object).getPageHeight(i) > this.getAvailPrintHeightForItems()) {
                    this.moveToNextPage();
                }
                object3 = null;
                if (bl) {
                    object3 = new TextPrintData();
                    ((PrintData)object3).setViewerNode(viewerNode);
                    double d = this.getLocationX(outputItemAlignment, viewerNode.getViewerItem().getPreferredSize().width);
                    ((PrintData)object3).setBounds(new Rectangle2D.Double(d, this.mCurrentY, this.getPrintableWidth(), ((TextRenderer)object).getPageHeight(i)));
                    ((TextPrintData)object3).setRenderer((TextRenderer)object);
                    ((TextPrintData)object3).setTextRendererPage(i);
                }
                if (!bl2) {
                    viewerNode.setX(this.getImageableX(this.mPageFormat));
                    double d = this.mPageFormat.getHeight() - (this.mCurrentY + this.mPageFormat.getImageableY());
                    viewerNode.setY(d);
                    viewerNode.setPageNumber(this.mCurrentPageNumber + 1);
                    bl2 = true;
                }
                if (!bl) continue;
                this.mCurrentY += ((TextRenderer)object).getPageHeight(i);
                List<PrintData> list3 = this.mPrintDataMap.get(this.mCurrentPageNumber);
                list3.add((PrintData)object3);
                this.mCurrentY += this.mInterItemSpacing;
            }
            if (var14_20 <= n - 2) {
                this.moveToNextPage();
            }
            ++var14_20;
        }
    }

    private void measureChartItem(ViewerNode viewerNode, Graphics2D graphics2D) {
        int n;
        if (viewerNode.getViewerItem().isHidden() && !this.mPrintHidden) {
            return;
        }
        if (this.mPrintSelection && !viewerNode.getViewerItem().isSelected()) {
            return;
        }
        ChartItem chartItem = (ChartItem)viewerNode.getViewerItem().getCoreItem();
        if (this.isPageBreakItem((IOutputItem)chartItem)) {
            this.moveToNextPage();
        }
        double d = chartItem.getWidth();
        double d2 = chartItem.getHeight();
        if (this.mSelectedChartSize == PrintedChartSize.eAS_IS) {
            if (d > this.getPrintableWidth()) {
                d2 *= this.getPrintableWidth() / d;
                d = this.getPrintableWidth();
            }
            if (d2 > this.getPrintableHeightForItems()) {
                d *= this.getPrintableHeightForItems() / d2;
                d2 = this.getPrintableHeightForItems();
            }
            if (this.getAvailPrintHeightForItems() < d2) {
                this.moveToNextPage();
            }
        } else {
            if ((double)this.mChartHeight > this.getAvailPrintHeightForItems()) {
                this.moveToNextPage();
            }
            d = this.mChartWidth;
            d2 = this.mChartHeight;
        }
        PrintData printData = new PrintData();
        printData.setViewerNode(viewerNode);
        try {
            n = VizCache.getCache().getVisualization((ChartItem)viewerNode.getViewerItem().getCoreItem()).getOutputWidth(graphics2D.getFontRenderContext());
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
            n = viewerNode.getViewerItem().getPreferredSize().width;
        }
        double d3 = this.getLocationX(viewerNode.getViewerItem().getCoreItem().getAlignment(), n);
        printData.setBounds(new Rectangle2D.Double(d3, this.mCurrentY, d, d2));
        viewerNode.setX(this.getImageableX(this.mPageFormat));
        viewerNode.setY(this.mPageFormat.getHeight() - (this.mCurrentY + this.mPageFormat.getImageableY()) * this.mZoomFactor);
        viewerNode.setPageNumber(this.mCurrentPageNumber + 1);
        this.mCurrentY += d2;
        List<PrintData> list = this.mPrintDataMap.get(this.mCurrentPageNumber);
        list.add(printData);
        this.mCurrentY += this.mInterItemSpacing;
    }

    private void measureJsonInteractiveItem(ViewerNode viewerNode, Graphics2D graphics2D) {
        ViewerItem viewerItem = viewerNode.getViewerItem();
        JsonInteractiveItem jsonInteractiveItem = (JsonInteractiveItem)viewerItem.getCoreItem();
        List list = null;
        String string = jsonInteractiveItem.getPrintSetting();
        boolean bl = false;
        if ("all".equals(string)) {
            bl = true;
        }
        if (bl) {
            list = jsonInteractiveItem.getAllViews();
            for (JsonInteractiveItem.AView aView : list) {
                int n = aView.getImage().getWidth();
                int n2 = aView.getImage().getHeight();
                this.measureBy(viewerNode, aView.getImage(), n, n2);
            }
        } else {
            List list2 = jsonInteractiveItem.getVisibleViews();
            for (BufferedImage bufferedImage : list2) {
                int n = bufferedImage.getWidth();
                int n3 = bufferedImage.getHeight();
                this.measureBy(viewerNode, bufferedImage, n, n3);
            }
        }
    }

    private void measureJsonItem(ViewerNode viewerNode, Graphics2D graphics2D) {
        if (viewerNode.getViewerItem().isHidden() && !this.mPrintHidden) {
            return;
        }
        if (this.mPrintSelection && !viewerNode.getViewerItem().isSelected()) {
            return;
        }
        IOutputItem iOutputItem = viewerNode.getViewerItem().getCoreItem();
        if (this.isPageBreakItem(iOutputItem)) {
            this.moveToNextPage();
        }
        double d = iOutputItem.getWidth();
        double d2 = iOutputItem.getHeight();
        this.measureBy(viewerNode, null, d, d2);
    }

    private void measureBy(ViewerNode viewerNode, BufferedImage bufferedImage, double d, double d2) {
        double d3 = 1.0;
        if (this.mSelectedChartSize == PrintedChartSize.eAS_IS) {
            double d4;
            double d5;
            if (d > this.getPrintableWidth()) {
                d5 = d2 * (this.getPrintableWidth() / d);
                d4 = this.getPrintableWidth();
                d3 = Math.max(d / d4, d2 / d5);
                d = d4;
                d2 = d5;
            }
            if (d2 > this.getPrintableHeightForItems()) {
                d5 = d * (this.getPrintableHeightForItems() / d2);
                d4 = this.getPrintableHeightForItems();
                d3 = Math.max(d / d5, d2 / d4);
                d = d5;
                d2 = d4;
            }
            if (this.getAvailPrintHeightForItems() < d2) {
                this.moveToNextPage();
            }
        } else {
            if ((double)this.mChartHeight > this.getAvailPrintHeightForItems()) {
                this.moveToNextPage();
            }
            d = this.mChartWidth;
            d2 = this.mChartHeight;
        }
        PrintData printData = new PrintData();
        printData.setChartRatio(d3);
        printData.setViewerNode(viewerNode);
        printData.setImage(bufferedImage);
        double d6 = this.getLocationX(viewerNode.getViewerItem().getCoreItem().getAlignment(), d);
        printData.setBounds(new Rectangle2D.Double(d6, this.mCurrentY, d, d2));
        viewerNode.setX(this.getImageableX(this.mPageFormat));
        viewerNode.setY(this.mPageFormat.getHeight() - (this.mCurrentY + this.mPageFormat.getImageableY()) * this.mZoomFactor);
        viewerNode.setPageNumber(this.mCurrentPageNumber + 1);
        this.mCurrentY += d2;
        List<PrintData> list = this.mPrintDataMap.get(this.mCurrentPageNumber);
        list.add(printData);
        this.mCurrentY += this.mInterItemSpacing;
    }

    private void measureModelItem(ViewerNode viewerNode, Graphics2D graphics2D) {
        if (viewerNode.getViewerItem().isHidden() && !this.mPrintHidden) {
            return;
        }
        if (this.mPrintSelection && !viewerNode.getViewerItem().isSelected()) {
            return;
        }
        boolean bl = false;
        ModelItem modelItem = (ModelItem)viewerNode.getViewerItem().getCoreItem();
        if (this.mModelViewsPrintOption == IExportOptions.ModelViewOptions.MVPrintSetting) {
            String string = modelItem.getPrintSetting();
            if ("all".equals(string)) {
                bl = true;
            } else if ("visible".equals(string)) {
                bl = false;
            }
        } else if (this.mModelViewsPrintOption == IExportOptions.ModelViewOptions.MVExportAll) {
            bl = true;
        } else if (this.mModelViewsPrintOption == IExportOptions.ModelViewOptions.MVExportVisible) {
            bl = false;
        }
        if (this.isPageBreakItem((IOutputItem)modelItem)) {
            this.moveToNextPage();
        }
        this.measureModelViews(viewerNode, bl, graphics2D);
    }

    private void measureVisibleModelView(ViewerNode viewerNode, double d, double d2, Visualization visualization, String string, int n) {
        int n2 = (int)d;
        int n3 = (int)d2;
        if (this.mSelectedChartSize == PrintedChartSize.eAS_IS) {
            if (d > this.getPrintableWidth()) {
                d = this.getPrintableWidth();
            }
            if (d2 > this.getPrintableHeightForItems()) {
                d2 = this.getPrintableHeightForItems();
            }
            if (this.getAvailPrintHeightForItems() < d2) {
                this.moveToNextPage();
            }
        } else {
            if ((double)this.mChartHeight > this.getAvailPrintHeightForItems()) {
                this.moveToNextPage();
            }
            if (d > (double)this.mChartWidth) {
                d = this.mChartWidth;
            }
            if (d2 > (double)this.mChartHeight) {
                d = (double)(this.mChartWidth * this.mChartHeight) / d2;
                d2 = this.mChartHeight;
            }
        }
        PrintData printData = new PrintData();
        printData.setViewerNode(viewerNode);
        printData.setModelViewInfoId(string);
        printData.setVizIndex(n);
        double d3 = this.getLocationX(viewerNode.getViewerItem().getCoreItem().getAlignment(), d);
        printData.setBounds(new Rectangle2D.Double(d3, this.mCurrentY, d, d2));
        if ((double)n2 > d || (double)n3 > d2) {
            printData.setVisSize(new Dimension(n2, n3));
        }
        viewerNode.setX(this.getImageableX(this.mPageFormat));
        viewerNode.setY(this.mPageFormat.getHeight() - (this.mCurrentY + this.mPageFormat.getImageableY()) * this.mZoomFactor);
        viewerNode.setPageNumber(this.mCurrentPageNumber + 1);
        this.mCurrentY += d2;
        List<PrintData> list = this.mPrintDataMap.get(this.mCurrentPageNumber);
        printData.setVisualization(visualization);
        list.add(printData);
        this.mCurrentY += this.mInterItemSpacing;
    }

    private void measureModelViews(ViewerNode viewerNode, boolean bl, Graphics2D graphics2D) {
        ModelViewerItem modelViewerItem = (ModelViewerItem)viewerNode.getViewerItem();
        ModelViewer modelViewer = modelViewerItem.getModelViewer();
        this.measureModelViews(viewerNode, modelViewer, bl, graphics2D);
        if (bl) {
            ArrayList<ModelViewer> arrayList = modelViewerItem.getChildrenModelViewers();
            for (ModelViewer modelViewer2 : arrayList) {
                this.measureModelViews(viewerNode, modelViewer2, bl, graphics2D);
            }
        }
    }

    private void measureModelViews(ViewerNode viewerNode, ModelViewer modelViewer, boolean bl, Graphics2D graphics2D) {
        List list = ((ModelViewerImpl)modelViewer).getViews();
        for (View view : list) {
            if (view.getName() == null) continue;
            try {
                if (bl) {
                    this.measureAModelView(viewerNode, view, modelViewer, graphics2D);
                    continue;
                }
                if (!view.isMainView() || !view.isShowing()) continue;
                this.measureAModelView(viewerNode, view, modelViewer, graphics2D);
            }
            catch (VisualizationException visualizationException) {
                visualizationException.printStackTrace();
            }
        }
    }

    private void measureAModelView(ViewerNode viewerNode, View view, ModelViewer modelViewer, Graphics2D graphics2D) throws VisualizationException {
        if (view instanceof InformationView) {
            this.measureInformationView(viewerNode, view);
        } else {
            Visualization[] visualizationArray = modelViewer.makeVisualizationsForView(view.getName());
            if (visualizationArray != null && visualizationArray.length > 0) {
                for (int i = 0; i < visualizationArray.length; ++i) {
                    this.measureAModelViewByVis(viewerNode, visualizationArray[i], view.getName(), i, graphics2D);
                }
            }
        }
    }

    private void measureInformationView(ViewerNode viewerNode, View view) {
        Object object;
        int n = 600;
        int n2 = 500;
        InformationView informationView = (InformationView)view;
        ModelViewerItem modelViewerItem = (ModelViewerItem)viewerNode.getViewerItem();
        ModelViewer modelViewer = modelViewerItem.getModelViewer();
        Graphboard graphboard = modelViewer.getComponent().getGraphboard(true);
        List list = informationView.getUserController(ComponentState.getOLangLocale(), graphboard);
        InformationPanel informationPanel = ((InformationController)list.get(0)).getInformationPanel();
        if (informationPanel != null) {
            if (informationPanel.getParent() == null) {
                object = new JDialog();
                ((JDialog)object).getContentPane().add((Component)informationPanel);
                ((Window)object).setSize((int)this.mPageFormat.getImageableWidth(), (int)this.mPageFormat.getImageableHeight());
                ((Dialog)object).setVisible(true);
                ((Dialog)object).setVisible(false);
                n = informationPanel.getBounds().width;
                n2 = informationPanel.getBounds().height;
                ((Window)object).dispose();
            } else {
                n = informationPanel.getBounds().width;
                n2 = informationPanel.getBounds().height;
            }
        }
        object = new PrintData();
        ((PrintData)object).setViewerNode(viewerNode);
        ((PrintData)object).setModelViewInfoId(view.getName());
        double d = this.getAvailPrintHeightForItems();
        if (d < (double)n2) {
            this.moveToNextPage(false);
        }
        double d2 = this.getLocationX(viewerNode.getViewerItem().getCoreItem().getAlignment(), n);
        ((PrintData)object).setBounds(new Rectangle2D.Double(d2, this.mCurrentY, n, n2));
        viewerNode.setX(this.getImageableX(this.mPageFormat));
        viewerNode.setY(this.mPageFormat.getHeight() - (this.mCurrentY + this.mPageFormat.getImageableY()) * this.mZoomFactor);
        viewerNode.setPageNumber(this.mCurrentPageNumber + 1);
        this.mCurrentY += (double)n2;
        List<PrintData> list2 = this.mPrintDataMap.get(this.mCurrentPageNumber);
        list2.add((PrintData)object);
        this.mCurrentY += this.mInterItemSpacing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void measureAModelViewByVis(ViewerNode viewerNode, Visualization visualization, String string, int n, Graphics2D graphics2D) throws VisualizationException {
        block32: {
            TablePrintInfo tablePrintInfo;
            PrintData printData;
            List<PrintData> list;
            Paper paper;
            PageFormat pageFormat;
            CustomOutputManager customOutputManager;
            PageFormat pageFormat2;
            block34: {
                TablePrintInfo tablePrintInfo2;
                PrintData printData2;
                List<PrintData> list2;
                block33: {
                    if (visualization == null) {
                        return;
                    }
                    VisualizationSpecification visualizationSpecification = visualization.getSpecification();
                    SourceVariableSpecification[] sourceVariableSpecificationArray = (SourceVariableSpecification[])visualizationSpecification.findDescendantsOfType(SourceVariableSpecification.class);
                    if (sourceVariableSpecificationArray.length == 0) {
                        return;
                    }
                    pageFormat2 = (PageFormat)this.mPageFormat.clone();
                    pageFormat2.setOrientation(1);
                    Paper paper2 = (Paper)this.mPageFormat.getPaper().clone();
                    paper2.setImageableArea(0.0, 0.0, this.mPageFormat.getImageableWidth(), this.getPrintableHeightForItems());
                    pageFormat2.setPaper(paper2);
                    customOutputManager = visualization.getCustomOutputManager(pageFormat2);
                    customOutputManager.setAffineTransform(AffineTransform.getScaleInstance(this.mZoomFactor, this.mZoomFactor));
                    pageFormat2 = (PageFormat)this.mPageFormat.clone();
                    pageFormat2.setOrientation(1);
                    paper2 = (Paper)this.mPageFormat.getPaper().clone();
                    paper2.setImageableArea(0.0, 0.0, this.mPageFormat.getImageableWidth(), this.getPrintableHeightForItems());
                    pageFormat2.setPaper(paper2);
                    pageFormat = (PageFormat)this.mPageFormat.clone();
                    pageFormat.setOrientation(1);
                    paper = (Paper)this.mPageFormat.getPaper().clone();
                    paper.setImageableArea(0.0, 0.0, this.mPageFormat.getImageableWidth(), this.getAvailPrintHeightForItems());
                    pageFormat.setPaper(paper);
                    customOutputManager.setFirstPageFormat(pageFormat);
                    customOutputManager.setContinuationText(null, "(continued)");
                    customOutputManager.setScalingFactor(1.0f);
                    int n2 = visualization.getOutputWidth(graphics2D.getFontRenderContext());
                    int n3 = visualization.getOutputHeight(graphics2D.getFontRenderContext());
                    if (!((double)n2 < 1.2 * this.mPageFormat.getImageableWidth() && (double)n3 < 1.2 * this.mPageFormat.getImageableHeight() || ((GraphSpecification[])visualization.getSpecification().findDescendantsOfType(GraphSpecification.class)).length > 1) && ((TableLayoutSpecification[])visualization.getSpecification().findDescendantsOfType(TableLayoutSpecification.class)).length != 0) break block33;
                    this.measureVisibleModelView(viewerNode, n2, n3, visualization, string, n);
                    break block32;
                }
                if (((FacetingSpecification[])visualization.getSpecification().findDescendantsOfType(FacetingSpecification.class)).length <= 0) break block34;
                customOutputManager.setShrinkToFit(false, false);
                try {
                    int n4;
                    list2 = null;
                    for (n4 = 0; n4 < 2; ++n4) {
                        try {
                            list2 = customOutputManager.getSizeInPages();
                            break;
                        }
                        catch (VisualizationRuntimeException visualizationRuntimeException) {
                            this.moveToNextPage();
                            paper = (Paper)this.mPageFormat.getPaper().clone();
                            paper.setImageableArea(0.0, 0.0, this.mPageFormat.getImageableWidth(), this.getAvailPrintHeightForItems());
                            pageFormat.setPaper(paper);
                            customOutputManager.setFirstPageFormat(pageFormat);
                            continue;
                        }
                    }
                    if (list2 == null) {
                        return;
                    }
                    n4 = ((Dimension)((Object)list2)).width;
                    int n5 = ((Dimension)((Object)list2)).height;
                    for (int i = 0; i < n5; ++i) {
                        for (int j = 0; j < n4; ++j) {
                            TablePrintInfo tablePrintInfo3 = new TablePrintInfo();
                            Dimension dimension = new Dimension(j, i);
                            tablePrintInfo3.setPageDimension(dimension);
                            tablePrintInfo3.setFirstPageFormat(pageFormat);
                            tablePrintInfo3.setPageFormat(pageFormat2);
                            tablePrintInfo3.setCustomOutputManager(customOutputManager);
                            tablePrintInfo3.setModelViewInfoId(string);
                            tablePrintInfo3.setVizIndex(n);
                            tablePrintInfo3.setVizObj(visualization);
                            this.addTablePrintData(viewerNode, customOutputManager, tablePrintInfo3, dimension);
                        }
                    }
                }
                catch (VisualizationException visualizationException) {
                    visualizationException.printStackTrace();
                    if (visualizationException.getCause() instanceof OutOfMemoryError) {
                        AppMgr.getAppMgr().handleOutOfMemoryCondition();
                    }
                    break block32;
                }
                finally {
                    TablePrintInfo tablePrintInfo4;
                    PrintData printData3;
                    List<PrintData> list3 = this.mPrintDataMap.get(this.mCurrentPageNumber);
                    if (list3.size() > 0 && (printData3 = list3.get(list3.size() - 1)) != null && (tablePrintInfo4 = printData3.getTablePrintInfo()) != null) {
                        tablePrintInfo4.setLastPart(true);
                    }
                }
                list2 = this.mPrintDataMap.get(this.mCurrentPageNumber);
                if (list2.size() > 0 && (printData2 = (PrintData)list2.get(list2.size() - 1)) != null && (tablePrintInfo2 = printData2.getTablePrintInfo()) != null) {
                    tablePrintInfo2.setLastPart(true);
                }
                break block32;
            }
            customOutputManager.setShrinkToFit(false, false);
            try {
                int n6;
                list = null;
                for (n6 = 0; n6 < 2; ++n6) {
                    try {
                        list = customOutputManager.getSizeInPages();
                        break;
                    }
                    catch (VisualizationRuntimeException visualizationRuntimeException) {
                        this.moveToNextPage();
                        paper = (Paper)this.mPageFormat.getPaper().clone();
                        paper.setImageableArea(0.0, 0.0, this.mPageFormat.getImageableWidth(), this.getAvailPrintHeightForItems());
                        pageFormat.setPaper(paper);
                        customOutputManager.setFirstPageFormat(pageFormat);
                        continue;
                    }
                }
                if (list == null) {
                    return;
                }
                n6 = ((Dimension)((Object)list)).width;
                int n7 = ((Dimension)((Object)list)).height;
                for (int i = 0; i < n7; ++i) {
                    for (int j = 0; j < n6; ++j) {
                        TablePrintInfo tablePrintInfo5 = new TablePrintInfo();
                        Dimension dimension = new Dimension(j, i);
                        tablePrintInfo5.setPageDimension(dimension);
                        tablePrintInfo5.setFirstPageFormat(pageFormat);
                        tablePrintInfo5.setPageFormat(pageFormat2);
                        tablePrintInfo5.setCustomOutputManager(customOutputManager);
                        tablePrintInfo5.setModelViewInfoId(string);
                        tablePrintInfo5.setVizIndex(n);
                        tablePrintInfo5.setVizObj(visualization);
                        this.addTablePrintData(viewerNode, customOutputManager, tablePrintInfo5, dimension);
                    }
                }
            }
            catch (VisualizationException visualizationException) {
                visualizationException.printStackTrace();
                if (visualizationException.getCause() instanceof OutOfMemoryError) {
                    AppMgr.getAppMgr().handleOutOfMemoryCondition();
                }
                break block32;
            }
            finally {
                TablePrintInfo tablePrintInfo6;
                PrintData printData4;
                List<PrintData> list4 = this.mPrintDataMap.get(this.mCurrentPageNumber);
                if (list4.size() > 0 && (printData4 = list4.get(list4.size() - 1)) != null && (tablePrintInfo6 = printData4.getTablePrintInfo()) != null) {
                    tablePrintInfo6.setLastPart(true);
                }
            }
            list = this.mPrintDataMap.get(this.mCurrentPageNumber);
            if (list.size() > 0 && (printData = (PrintData)list.get(list.size() - 1)) != null && (tablePrintInfo = printData.getTablePrintInfo()) != null) {
                tablePrintInfo.setLastPart(true);
            }
        }
    }

    private void measureImageItem(ViewerNode viewerNode) {
        if (viewerNode.getViewerItem().isHidden() && !this.mPrintHidden) {
            return;
        }
        if (this.mPrintSelection && !viewerNode.getViewerItem().isSelected()) {
            return;
        }
        ImageItem imageItem = (ImageItem)viewerNode.getViewerItem().getCoreItem();
        if (this.isPageBreakItem((IOutputItem)imageItem)) {
            this.moveToNextPage();
        }
        double d = imageItem.getWidth();
        double d2 = imageItem.getHeight();
        if (d > this.getPrintableWidth()) {
            d2 *= this.getPrintableWidth() / d;
            d = this.getPrintableWidth();
        }
        if (d2 > this.getPrintableHeightForItems()) {
            d *= this.getPrintableHeightForItems() / d2;
            d2 = this.getPrintableHeightForItems();
        }
        if (this.getAvailPrintHeightForItems() < d2) {
            this.moveToNextPage();
        }
        PrintData printData = new PrintData();
        printData.setViewerNode(viewerNode);
        double d3 = this.getLocationX(viewerNode.getViewerItem().getCoreItem().getAlignment(), viewerNode.getViewerItem().getPreferredSize().width);
        printData.setBounds(new Rectangle2D.Double(d3, this.mCurrentY, d, d2));
        viewerNode.setX(this.getImageableX(this.mPageFormat));
        viewerNode.setY(this.mPageFormat.getHeight() - (this.mCurrentY + this.mPageFormat.getImageableY()) * this.mZoomFactor);
        viewerNode.setPageNumber(this.mCurrentPageNumber + 1);
        this.mCurrentY += d2;
        List<PrintData> list = this.mPrintDataMap.get(this.mCurrentPageNumber);
        list.add(printData);
        this.mCurrentY += this.mInterItemSpacing;
    }

    private void measureGenericItem(ViewerNode viewerNode) {
        if (viewerNode.getViewerItem().isHidden() && !this.mPrintHidden) {
            return;
        }
        if (this.mPrintSelection && !viewerNode.getViewerItem().isSelected()) {
            return;
        }
        GenericItem genericItem = (GenericItem)viewerNode.getViewerItem().getCoreItem();
        if (this.isPageBreakItem((IOutputItem)genericItem)) {
            this.moveToNextPage();
        }
        double d = genericItem.getWidth();
        double d2 = genericItem.getHeight();
        if (d > this.getPrintableWidth()) {
            d2 *= this.getPrintableWidth() / d;
            d = this.getPrintableWidth();
        }
        if (d2 > this.getPrintableHeightForItems()) {
            d *= this.getPrintableHeightForItems() / d2;
            d2 = this.getPrintableHeightForItems();
        }
        if (this.getAvailPrintHeightForItems() < d2) {
            this.moveToNextPage();
        }
        PrintData printData = new PrintData();
        printData.setViewerNode(viewerNode);
        double d3 = this.getLocationX(viewerNode.getViewerItem().getCoreItem().getAlignment(), viewerNode.getViewerItem().getPreferredSize().width);
        printData.setBounds(new Rectangle2D.Double(d3, this.mCurrentY, d, d2));
        viewerNode.setX(this.getImageableX(this.mPageFormat));
        viewerNode.setY(this.mPageFormat.getHeight() - (this.mCurrentY + this.mPageFormat.getImageableY()) * this.mZoomFactor);
        viewerNode.setPageNumber(this.mCurrentPageNumber + 1);
        this.mCurrentY += d2;
        List<PrintData> list = this.mPrintDataMap.get(this.mCurrentPageNumber);
        list.add(printData);
        this.mCurrentY += this.mInterItemSpacing;
    }

    private void measureTreeItem(ViewerNode viewerNode) {
        if (viewerNode.getViewerItem().isHidden() && !this.mPrintHidden) {
            return;
        }
        if (this.mPrintSelection && !viewerNode.getViewerItem().isSelected()) {
            return;
        }
        TreeModelItem treeModelItem = (TreeModelItem)viewerNode.getViewerItem().getCoreItem();
        if (this.isPageBreakItem((IOutputItem)treeModelItem)) {
            this.moveToNextPage();
        }
        double d = treeModelItem.getWidth();
        double d2 = treeModelItem.getHeight();
        double d3 = this.getPrintableWidth();
        double d4 = this.getPrintableHeightForItems();
        int n = (int)((d + d3 - 1.0) / d3);
        int n2 = (int)((d2 + d4 - 1.0) / d4);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Dimension dimension = new Dimension(j, i);
                this.addTreePrintData(viewerNode, dimension);
            }
        }
    }

    private void measureTableItem(ViewerNode viewerNode, Graphics2D graphics2D) {
        block14: {
            if (viewerNode.getViewerItem().isHidden() && !this.mPrintHidden) {
                return;
            }
            if (this.mPrintSelection && !viewerNode.getViewerItem().isSelected()) {
                return;
            }
            TableViewerItem tableViewerItem = (TableViewerItem)viewerNode.getViewerItem();
            TableItem tableItem = (TableItem)tableViewerItem.getCoreItem();
            TableProperties tableProperties = tableItem.getDisplayedTableProperties();
            boolean bl = tableProperties.isPrintAllLayers();
            boolean bl2 = tableProperties.isPrintEachLayerOnNewPage();
            boolean bl3 = tableProperties.isRescaleWideTblToFitPage();
            boolean bl4 = tableProperties.isRescaleLongTblToFitPage();
            double d = this.getAvailPrintHeightForItems();
            double d2 = this.getPrintableHeightForItems();
            boolean bl5 = !bl4 && d < (double)tableItem.getHeight() && d2 / 2.0 > d;
            Visualization visualization = tableViewerItem.acquireVisualization();
            if (visualization == null) {
                return;
            }
            try {
                VizDataSource.switchToFullTable((Visualization)visualization);
                visualization.setRenderingHints(BaseImageRenderer.getRendingHints());
                PageFormat pageFormat = (PageFormat)this.mPageFormat.clone();
                pageFormat.setOrientation(1);
                Paper paper = (Paper)pageFormat.getPaper().clone();
                paper.setImageableArea(0.0, 0.0, this.mPageFormat.getImageableWidth(), d2 * 0.98);
                pageFormat.setPaper(paper);
                CustomOutputManager customOutputManager = visualization.getCustomOutputManager(pageFormat);
                customOutputManager.setAffineTransform(AffineTransform.getScaleInstance(this.mZoomFactor, this.mZoomFactor));
                if (bl3 || bl4) {
                    customOutputManager.setShrinkToFit(bl3, bl4);
                }
                customOutputManager.setScalingFactor(1.0f);
                List list = customOutputManager.getLayers();
                if (this.isRenderAllLayers(bl)) {
                    if (list.size() == 0) {
                        this.calculateSingleLayerTable(viewerNode, customOutputManager, tableProperties, false, bl3, bl4, graphics2D);
                    } else {
                        for (int i = 0; i < list.size(); ++i) {
                            CustomOutputManager customOutputManager2 = visualization.getCustomOutputManager(pageFormat);
                            customOutputManager2.setAffineTransform(AffineTransform.getScaleInstance(this.mZoomFactor, this.mZoomFactor));
                            if (bl3 || bl4) {
                                customOutputManager2.setShrinkToFit(bl3, bl4);
                            }
                            customOutputManager2.setScalingFactor(1.0f);
                            customOutputManager2.setCurrentLayer((String[])list.get(i));
                            if (bl2 && i > 0) {
                                this.moveToNextPage(false);
                                this.calculateSingleLayerTable(viewerNode, customOutputManager2, tableProperties, true, bl3, bl4, graphics2D);
                                continue;
                            }
                            this.calculateSingleLayerTable(viewerNode, customOutputManager2, tableProperties, false, bl3, bl4, graphics2D);
                        }
                    }
                } else {
                    if (this.mCurrentY > this.mHeaderBounds.getMaxY() + this.mInterItemSpacing && this.isPageBreakItem((IOutputItem)tableItem)) {
                        this.moveToNextPage(false);
                    }
                    this.calculateSingleLayerTable(viewerNode, customOutputManager, tableProperties, false, bl3, bl4, graphics2D);
                }
            }
            catch (VisualizationException visualizationException) {
                visualizationException.printStackTrace();
                if (!(visualizationException.getCause() instanceof OutOfMemoryError)) break block14;
                AppMgr.getAppMgr().handleOutOfMemoryCondition();
            }
        }
    }

    private boolean isRenderAllLayers(boolean bl) {
        boolean bl2 = false;
        if (this.mIsPrinting) {
            bl2 = bl;
        } else if (this.mTableLayerSetting == TableLayerPrintSetting.eALL_LAYERS) {
            bl2 = true;
        } else if (this.mTableLayerSetting == TableLayerPrintSetting.eHONOR_TABLE_SETTING) {
            bl2 = bl;
        }
        return bl2;
    }

    private void measureLightTableItem(ViewerNode viewerNode) {
        block17: {
            int n;
            Object object;
            if (viewerNode.getViewerItem().isHidden() && !this.mPrintHidden) {
                return;
            }
            if (this.mPrintSelection && !viewerNode.getViewerItem().isSelected()) {
                return;
            }
            LightTableViewerItem lightTableViewerItem = (LightTableViewerItem)viewerNode.getViewerItem();
            LightTableItem lightTableItem = lightTableViewerItem.getCoreItem();
            double d = this.getAvailPrintHeightForItems();
            double d2 = this.getPrintableHeightForItems();
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            Object object2 = null;
            Object object3 = null;
            PrintSettings printSettings = lightTableItem.getLightPivotTable().getPrintSettings();
            if (printSettings != null) {
                boolean bl5;
                bl = printSettings.isPrintAllLayers();
                bl2 = printSettings.isPrintNewLayers();
                bl3 = printSettings.isRescaleWideToFit();
                bl4 = printSettings.isRescaleLongToFit();
                boolean bl6 = !bl4 && d < (double)lightTableItem.getHeight() && d2 / 2.0 > d;
                boolean bl7 = bl5 = bl4 && d < d2 * 2.0 / 3.0;
                if (this.isPageBreakItem((IOutputItem)lightTableItem) || bl6 || bl5) {
                    this.moveToNextPage(false);
                }
                object = printSettings.getContinuationText();
                boolean bl8 = printSettings.isContinuationAtBottom();
                n = printSettings.isContinuationAtTop();
                if (n != 0) {
                    object2 = object;
                }
                if (bl8) {
                    object3 = object;
                }
            }
            try {
                PageFormat pageFormat = (PageFormat)this.mPageFormat.clone();
                pageFormat.setOrientation(1);
                Paper paper = (Paper)pageFormat.getPaper().clone();
                paper.setImageableArea(0.0, 0.0, this.mPageFormat.getImageableWidth(), d2);
                pageFormat.setPaper(paper);
                object = (PageFormat)this.mPageFormat.clone();
                ((PageFormat)object).setOrientation(1);
                if (this.getAvailPrintHeightForItems() < 100.0) {
                    object = pageFormat;
                } else {
                    Paper paper2 = (Paper)((PageFormat)object).getPaper().clone();
                    paper2.setImageableArea(0.0, 0.0, this.mPageFormat.getImageableWidth(), this.getAvailPrintHeightForItems());
                    ((PageFormat)object).setPaper(paper2);
                }
                if (this.mTableLayerSetting == TableLayerPrintSetting.eALL_LAYERS || bl) {
                    int n2 = lightTableItem.getLightPivotTable().getLayerCount();
                    for (n = 0; n < n2; ++n) {
                        if (n2 > 1) {
                            lightTableItem.getLightPivotTable().setCurrentLayerIndex(n);
                        }
                        if (bl2 && n > 0) {
                            this.moveToNextPage(false);
                        }
                        LightTableOutputManager lightTableOutputManager = new LightTableOutputManager(lightTableItem.getLightPivotTable(), (SimpleRenderer)new LtPrintRenderer(lightTableItem.getLightPivotTable(), pageFormat.getImageableWidth()), pageFormat, (PageFormat)object);
                        lightTableOutputManager.setZoomFactor(this.mZoomFactor);
                        if (!bl3 && lightTableOutputManager.checkColumnWidthFit()) {
                            bl3 = true;
                            this.mTablesWithLongRowLabel.add(viewerNode.getViewerItem());
                        }
                        lightTableOutputManager.setShrinkToFit(bl3, bl4);
                        lightTableOutputManager.setContinuationText((String)object2, (String)object3);
                        lightTableOutputManager.setWidowOrphanLimit(printSettings.getOrphanLineCount());
                        lightTableOutputManager.setPageBreak(lightTableViewerItem.getVisibleBreakpointIndexSet(true), lightTableViewerItem.getVisibleBreakpointIndexSet(false), lightTableViewerItem.getVisibleTogetherMap(true), lightTableViewerItem.getVisibleTogetherMap(false));
                        this.calculateALayerLightTable(viewerNode, lightTableOutputManager, (PageFormat)object, pageFormat, n);
                    }
                } else {
                    LightTableOutputManager lightTableOutputManager = new LightTableOutputManager(lightTableItem.getLightPivotTable(), (SimpleRenderer)new LtPrintRenderer(lightTableItem.getLightPivotTable(), pageFormat.getImageableWidth()), pageFormat, (PageFormat)object);
                    lightTableOutputManager.setZoomFactor(this.mZoomFactor);
                    if (!bl3 && lightTableOutputManager.checkColumnWidthFit()) {
                        bl3 = true;
                        this.mTablesWithLongRowLabel.add(viewerNode.getViewerItem());
                    }
                    lightTableOutputManager.setShrinkToFit(bl3, bl4);
                    lightTableOutputManager.setContinuationText((String)object2, (String)object3);
                    lightTableOutputManager.setWidowOrphanLimit(printSettings.getOrphanLineCount());
                    lightTableOutputManager.setPageBreak(lightTableViewerItem.getVisibleBreakpointIndexSet(true), lightTableViewerItem.getVisibleBreakpointIndexSet(false), lightTableViewerItem.getVisibleTogetherMap(true), lightTableViewerItem.getVisibleTogetherMap(false));
                    this.calculateALayerLightTable(viewerNode, lightTableOutputManager, (PageFormat)object, pageFormat, lightTableItem.getLightPivotTable().getCurrentLayerIndex());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!(exception.getCause() instanceof OutOfMemoryError)) break block17;
                AppMgr.getAppMgr().handleOutOfMemoryCondition();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateALayerLightTable(ViewerNode viewerNode, LightTableOutputManager lightTableOutputManager, PageFormat pageFormat, PageFormat pageFormat2, int n) {
        Dimension dimension = lightTableOutputManager.getSizeInPages();
        for (int i = 0; i < dimension.height; ++i) {
            for (int j = 0; j < dimension.width; ++j) {
                Dimension dimension2;
                Dimension dimension3 = new Dimension(j, i);
                Object object = this.mTableRenderLock;
                synchronized (object) {
                    dimension2 = lightTableOutputManager.getPageSize(dimension3);
                }
                if (dimension2 == null) continue;
                if (this.mCurrentY + (double)dimension2.height > this.mFooterBounds.getY() || lightTableOutputManager.isBreakPointPage(j, i)) {
                    this.moveToNextPage();
                }
                object = new PrintData();
                ((PrintData)object).setViewerNode(viewerNode);
                double d = this.getLocationX(viewerNode.getViewerItem().getCoreItem().getAlignment(), dimension2.width);
                if ((double)dimension2.width > this.mTableMaxWidth) {
                    this.mTableMaxWidth = dimension2.width;
                }
                ((PrintData)object).setBounds(new Rectangle2D.Double(d, this.mCurrentY, this.mTableMaxWidth, dimension2.height));
                if (viewerNode.getPageNumber() == 0) {
                    viewerNode.setX(this.getImageableX(this.mPageFormat));
                    viewerNode.setY(this.mPageFormat.getHeight() - (this.mCurrentY + this.mPageFormat.getImageableY()) * this.mZoomFactor);
                    viewerNode.setPageNumber(this.mCurrentPageNumber + 1);
                }
                TablePrintInfo tablePrintInfo = new TablePrintInfo();
                tablePrintInfo.setPageDimension(dimension3);
                tablePrintInfo.setFirstPageFormat(pageFormat);
                tablePrintInfo.setPageFormat(pageFormat2);
                tablePrintInfo.setLightPrintManager(lightTableOutputManager);
                tablePrintInfo.setLayerIndex(n >= 0 ? n : 0);
                ((PrintData)object).setTablePrintInfo(tablePrintInfo);
                this.mCurrentY += (double)dimension2.height;
                List<PrintData> list = this.mPrintDataMap.get(this.mCurrentPageNumber);
                list.add((PrintData)object);
                this.mCurrentY += 12.0;
            }
        }
        this.mCurrentY += this.mInterItemSpacing;
    }

    /*
     * Exception decompiling
     */
    private void calculateSingleLayerTable(ViewerNode var1_1, CustomOutputManager var2_2, TableProperties var3_3, boolean var4_4, boolean var5_5, boolean var6_6, Graphics2D var7_7) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void showWideTableError() {
        String string = ResUtil.getString("IDS_TABLE_CELLS_TOO_LARGE");
        Window window = this.getErrorDisplayWindow();
        window = window != null ? window : (Window)this.mFrame.getViewerPanel().getParent();
        SpssAlertOptionPane.showWarningMessageDialog(window, string, VersionInfo.getAppVersionString());
    }

    private void showCellHightTableError(String string) {
        String string2 = ResUtil.getString(string);
        Window window = this.getErrorDisplayWindow();
        window = window != null ? window : (Window)this.mFrame.getViewerPanel().getParent();
        SpssAlertOptionPane.showWarningMessageDialog(window, string2, VersionInfo.getAppVersionString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTablePrintData(ViewerNode viewerNode, CustomOutputManager customOutputManager, TablePrintInfo tablePrintInfo, Dimension dimension) {
        block9: {
            try {
                Dimension dimension2;
                Object object = this.mTableRenderLock;
                synchronized (object) {
                    dimension2 = customOutputManager.getPageSize(dimension);
                }
                if (dimension2 == null) {
                    return;
                }
                if (this.mCurrentY + (double)dimension2.height > this.mFooterBounds.getY()) {
                    this.moveToNextPage();
                }
                object = new PrintData();
                ((PrintData)object).setTablePrintInfo(tablePrintInfo);
                ((PrintData)object).setViewerNode(viewerNode);
                double d = this.getLocationX(viewerNode.getViewerItem().getCoreItem().getAlignment(), dimension2.width);
                if ((double)dimension2.width > this.mTableMaxWidth) {
                    this.mTableMaxWidth = dimension2.width;
                }
                ((PrintData)object).setBounds(new Rectangle2D.Double(d, this.mCurrentY, this.mTableMaxWidth, dimension2.height));
                viewerNode.setX(this.getImageableX(this.mPageFormat));
                viewerNode.setY(this.mPageFormat.getHeight() - (this.mCurrentY + this.mPageFormat.getImageableY()) * this.mZoomFactor);
                viewerNode.setPageNumber(this.mCurrentPageNumber + 1);
                this.mCurrentY += (double)dimension2.height;
                List<PrintData> list = this.mPrintDataMap.get(this.mCurrentPageNumber);
                list.add((PrintData)object);
                this.mCurrentY += this.mInterItemSpacing;
            }
            catch (VisualizationPageFitException visualizationPageFitException) {
            }
            catch (VisualizationException visualizationException) {
                visualizationException.printStackTrace();
                if (!(visualizationException.getCause() instanceof OutOfMemoryError)) break block9;
                AppMgr.getAppMgr().handleOutOfMemoryCondition();
            }
        }
    }

    private void moveToNextPage() {
        this.moveToNextPage(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveToNextPage(boolean bl) {
        if (this.mCurrentPageNumber > 0 && bl) {
            String string = this.mMonitor;
            synchronized (string) {
                this.mMonitor.notifyAll();
            }
        }
        ++this.mCurrentPageNumber;
        this.mPrintDataMap.put(this.mCurrentPageNumber, new ArrayList());
        this.mCurrentY = this.mHeaderBounds.getMaxY();
        if (this.mUniformHeader) {
            this.mCurrentY += this.mInterItemSpacing;
        }
        if (this.mSelectedChartSize == PrintedChartSize.eAS_IS) {
            this.mChartHeight = (int)this.getPrintableHeightForItems();
        }
    }

    private void calculatePageTitle(PageTitleViewerItem pageTitleViewerItem) {
        boolean bl;
        if (!pageTitleViewerItem.isAlwaysPrint()) {
            if (pageTitleViewerItem.isHidden() && !this.mPrintHidden) {
                return;
            }
            if (this.mPrintSelection && !pageTitleViewerItem.isSelected()) {
                return;
            }
        }
        TextItem textItem = (TextItem)pageTitleViewerItem.getCoreItem();
        String string = textItem.getXHTMLContents();
        int n = string.indexOf("<body>");
        int n2 = string.indexOf("</body>");
        String string2 = n > -1 && n2 > -1 ? string.substring(n + String.valueOf("<body>").length(), n2) : OutputViewPrintable.extractPlainText(string);
        if (string2.equals(string2.toUpperCase())) {
            string2 = string2.replaceAll(" ", "&#160;");
        }
        if ((bl = this.hasAnyPrintableItemBeforeMe(pageTitleViewerItem)) && this.isPageBreakItem((IOutputItem)textItem)) {
            this.moveToNextPage();
        }
        if (bl && !pageTitleViewerItem.getPageBreak()) {
            this.mPagetTitleData.put(this.mCurrentPageNumber + 1, string2);
            this.mPagetTitleColor.put(this.mCurrentPageNumber + 1, pageTitleViewerItem.getTextPane().getForeground());
        } else {
            this.mPagetTitleData.put(this.mCurrentPageNumber, string2);
            this.mPagetTitleColor.put(this.mCurrentPageNumber, pageTitleViewerItem.getTextPane().getForeground());
        }
        HeaderFooterHeightCalculator headerFooterHeightCalculator = pageTitleViewerItem.getHeaderHeightCalculator();
        if (headerFooterHeightCalculator == null) {
            headerFooterHeightCalculator = new HeaderFooterHeightCalculator(this.mViewerRoot, string, this.mPageFormat.getImageableWidth(), false);
            headerFooterHeightCalculator.calculateHeight(string);
            pageTitleViewerItem.setHeaderHeightCalculator(headerFooterHeightCalculator);
        }
        if (pageTitleViewerItem.getUniformHeader() == null) {
            this.mUniformHeader = headerFooterHeightCalculator.getUniform();
            if (this.mUniformHeader) {
                pageTitleViewerItem.setUniformHeader("true");
            } else {
                pageTitleViewerItem.setUniformHeader("false");
            }
        } else {
            this.mUniformHeader = pageTitleViewerItem.getUniformHeader().equals("true");
        }
        this.mHeaderBounds = new Rectangle2D.Double(0.0, 0.0, this.mPageFormat.getImageableWidth(), headerFooterHeightCalculator.getMaxHeight());
        String string3 = this.mFooterHtml;
        if (this.mFooterHtml.contains("&amp;[Page]")) {
            string3 = this.getHTMLString(this.mFooterHtml, "&amp;[Page]", String.valueOf(this.mCurrentPageNumber));
        } else if (this.mFooterHtml.contains("&[Page]")) {
            string3 = this.getHTMLString(this.mFooterHtml, "&[Page]", String.valueOf(this.mCurrentPageNumber));
        }
        HeaderFooterHeightCalculator headerFooterHeightCalculator2 = pageTitleViewerItem.getFooterHeightCalculator();
        if (headerFooterHeightCalculator2 == null) {
            headerFooterHeightCalculator2 = new HeaderFooterHeightCalculator(this.mViewerRoot, this.mFooterHtml, this.mPageFormat.getImageableWidth(), true);
            headerFooterHeightCalculator2.calculateHeight(string3);
            pageTitleViewerItem.setFooterHeightCalculator(headerFooterHeightCalculator2);
        }
        if (pageTitleViewerItem.getUniformFooter() == null) {
            this.mUniformFooter = headerFooterHeightCalculator2.getUniform();
            if (this.mUniformFooter) {
                pageTitleViewerItem.setUniformFooter("true");
            } else {
                pageTitleViewerItem.setUniformFooter("false");
            }
        } else {
            this.mUniformFooter = pageTitleViewerItem.getUniformFooter().equals("true");
        }
        double d = this.mPageFormat.getImageableHeight() - headerFooterHeightCalculator2.getMaxHeight();
        this.mFooterBounds = new Rectangle2D.Double(0.0, d, this.mPageFormat.getImageableWidth(), headerFooterHeightCalculator2.getMaxHeight());
        this.mCurrentY = bl && !pageTitleViewerItem.getPageBreak() ? (this.mCurrentY += this.mInterItemSpacing) : this.mHeaderBounds.getMaxY() + this.mInterItemSpacing;
        if (this.mSelectedChartSize == PrintedChartSize.eAS_IS) {
            this.mChartHeight = (int)this.getPrintableHeightForItems();
        }
    }

    private double getPrintableWidth() {
        return this.mPageFormat.getImageableWidth();
    }

    private double getPrintableHeightForItems() {
        return this.mFooterBounds.getY() - this.mHeaderBounds.getMaxY() - (this.mUniformHeader ? this.mInterItemSpacing : 0.0);
    }

    private double getAvailPrintHeightForItems() {
        return this.mFooterBounds.getY() - this.mCurrentY;
    }

    private PrintedChartSize getSelectedChartSize() {
        PrintedChartSize printedChartSize = PrintedChartSize.eAS_IS;
        String string = this.mPageSetupInfo.getChartSize();
        block6: for (int i = 0; i < PageAttributes.CHART_SIZE.length; ++i) {
            if (!PageAttributes.CHART_SIZE[i].equals(string)) continue;
            switch (i) {
                case 0: {
                    printedChartSize = PrintedChartSize.eAS_IS;
                    continue block6;
                }
                case 1: {
                    printedChartSize = PrintedChartSize.eFULL_PAGE_HEIGHT;
                    continue block6;
                }
                case 2: {
                    printedChartSize = PrintedChartSize.eHALF_PAGE_HEIGHT;
                    continue block6;
                }
                case 3: {
                    printedChartSize = PrintedChartSize.eQUARTER_PAGE_HEIGHT;
                }
            }
        }
        return printedChartSize;
    }

    private String getHeaderPrintHTML() {
        String string = this.mPageSetupInfo.getHeaderHTML();
        string = string.length() == 0 ? PageAttributes.getPrefPageHeader() : (this.mPageSetupInfo.isModified() ? this.mPageSetupInfo.getHeaderHTML() : (PageAttributes.isPageHeaderFooterModified() ? PageAttributes.getPrefPageHeader() : this.mPageSetupInfo.getDefaultHeaderHtml()));
        return OutputViewPrintable.deleteHeadElement(string);
    }

    private String getFooterPrintHTML() {
        String string = this.mPageSetupInfo.getFootnoteHTML();
        string = string.length() == 0 ? PageAttributes.getPrefPageFooter() : (this.mPageSetupInfo.isModified() ? this.mPageSetupInfo.getFootnoteHTML() : (PageAttributes.isPageHeaderFooterModified() ? PageAttributes.getPrefPageFooter() : this.mPageSetupInfo.getDefaultFooterHtml(UIToolResUtil.getLocale().toString())));
        return OutputViewPrintable.deleteHeadElement(string);
    }

    private boolean checkNodesSelection(ViewerNode viewerNode) {
        boolean bl;
        boolean bl2 = bl = viewerNode.getViewerItem() != null && viewerNode.getViewerItem().isSelected();
        if (bl) {
            return true;
        }
        ArrayList<ViewerNode> arrayList = viewerNode.getChildNodes();
        for (ViewerNode viewerNode2 : arrayList) {
            bl = this.checkNodesSelection(viewerNode2);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private double getLocationX(OutputItemAlignment outputItemAlignment, double d) {
        double d2 = 0.0;
        double d3 = this.getPrintableWidth();
        if (outputItemAlignment == OutputItemAlignment.Right) {
            d2 = d3 - d;
        } else if (outputItemAlignment == OutputItemAlignment.Center) {
            d2 = (d3 - d) / 2.0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        return d2;
    }

    public static String extractPlainText(String string) {
        SpssTextPane spssTextPane = new SpssTextPane();
        spssTextPane.setText(string);
        String string2 = "";
        String string3 = spssTextPane.getText();
        int n = spssTextPane.getSelectionStart();
        int n2 = spssTextPane.getSelectionEnd();
        spssTextPane.setSelectionStart(0);
        spssTextPane.setSelectionEnd(string3.length());
        int n3 = spssTextPane.getSelectionStart();
        int n4 = spssTextPane.getSelectionEnd();
        if (n4 - n3 > 0) {
            StringWriter stringWriter = new StringWriter(n4 - n3);
            try {
                spssTextPane.getEditorKit().write(stringWriter, spssTextPane.getDocument(), n3, n4 - n3);
                StringReader stringReader = new StringReader(stringWriter.toString());
                HTMLDocument hTMLDocument = new HTMLDocument();
                spssTextPane.getEditorKit().read(stringReader, (Document)hTMLDocument, 0);
                string2 = spssTextPane.getSelectedText(hTMLDocument, spssTextPane.getSelectedText());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        spssTextPane.select(n, n2);
        return string2;
    }

    private String getHTMLString(String string, String string2, String string3) {
        String string4 = "";
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.indexOf(string2);
        if (n >= 0) {
            string4 = stringBuffer.replace(n, n + string2.length(), string3).toString();
        }
        return string4;
    }

    public void setPreviewWindowClose() {
        this.mPreviewWindowClose = true;
    }

    private void addTreePrintData(ViewerNode viewerNode, Dimension dimension) {
        double d = this.getPrintableWidth();
        double d2 = this.getPrintableHeightForItems();
        if (this.mCurrentY + d2 > this.mFooterBounds.getY() || dimension.width > 0) {
            this.moveToNextPage();
        }
        PrintData printData = new PrintData();
        printData.setViewerNode(viewerNode);
        printData.setTreePageDim(dimension);
        double d3 = this.getLocationX(viewerNode.getViewerItem().getCoreItem().getAlignment(), viewerNode.getViewerItem().getPreferredSize().width);
        printData.setBounds(new Rectangle2D.Double(d3, this.mCurrentY, d, d2));
        viewerNode.setX(this.getImageableX(this.mPageFormat));
        viewerNode.setY(this.mPageFormat.getHeight() - (this.mCurrentY + this.mPageFormat.getImageableY()) * this.mZoomFactor);
        viewerNode.setPageNumber(this.mCurrentPageNumber + 1);
        this.mCurrentY += d2;
        List<PrintData> list = this.mPrintDataMap.get(this.mCurrentPageNumber);
        list.add(printData);
        this.mCurrentY += this.mInterItemSpacing;
    }

    private String replaceString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string.indexOf(string2);
        String string4 = n >= 0 ? stringBuffer.replace(n, n + string2.length(), string3).toString() : string;
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAnyPrintableItemBeforeMe(ViewerItem viewerItem) {
        Object object = this.mFrame.getViewerDocument().getItemLock();
        synchronized (object) {
            for (ViewerItem viewerItem2 : this.mViewerItems) {
                if (viewerItem2.equals(viewerItem)) {
                    return false;
                }
                if (!this.isItemPrintable(viewerItem2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isItemPrintable(ViewerItem viewerItem) {
        if (viewerItem.getCoreItem() instanceof RootItem) {
            return false;
        }
        if (viewerItem.isHidden() && !this.mPrintHidden) {
            return false;
        }
        return !this.mPrintSelection || viewerItem.isSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetPageTitleForFirstPrintableItem() {
        PageTitleViewerItem pageTitleViewerItem = null;
        Object object = this.mFrame.getViewerDocument().getItemLock();
        synchronized (object) {
            for (ViewerItem viewerItem : this.mViewerItems) {
                if (viewerItem instanceof PageTitleViewerItem) {
                    pageTitleViewerItem = (PageTitleViewerItem)viewerItem;
                    continue;
                }
                if (!this.isItemPrintable(viewerItem)) continue;
                if (pageTitleViewerItem != null) {
                    pageTitleViewerItem.setAlwaysPrint(this.isItemPrintable(pageTitleViewerItem));
                }
                return;
            }
        }
    }

    private void showProgessBarMeasureMsg(ViewerItem viewerItem) {
        if (viewerItem == null) {
            return;
        }
        IOutputItem iOutputItem = viewerItem.getCoreItem();
        if (iOutputItem != null) {
            String string = MessageFormat.format(this.mPrintMsg, iOutputItem.getDescription(), this.mNodeToBeMeasuredIndex, this.mPrintNodeList.size());
            this.setDisplayMessage(string);
            this.setProgressBarValue(this.mNodeToBeMeasuredIndex * 100 / this.mPrintNodeList.size());
        }
    }

    private boolean isCancel() {
        return this.mProgressDlg != null && this.mProgressDlg.abort();
    }

    private int findLastPageWithHeader(int n) {
        int n2 = -1;
        if (this.mPagetTitleData.size() > 0) {
            Set<Integer> set = this.mPagetTitleData.keySet();
            for (Integer n3 : set) {
                if (n < n3) break;
                n2 = n3;
            }
        }
        return n2;
    }

    private boolean isPageBreakItem(IOutputItem iOutputItem) {
        return iOutputItem != null && iOutputItem.getVisible() && iOutputItem.getPageBreak();
    }

    private boolean isPageBreakItem(JsonInteractiveViewerItem jsonInteractiveViewerItem) {
        return jsonInteractiveViewerItem != null && jsonInteractiveViewerItem.getPageBreak();
    }

    public static String deleteHeadElement(String string) {
        String string2 = string;
        int n = string2.indexOf("<head>");
        int n2 = string2.indexOf("</head>");
        StringBuffer stringBuffer = new StringBuffer(string2);
        if (n > 0 && n2 > 0 && n2 > n) {
            string2 = stringBuffer.delete(n, n2 + 7).toString();
        }
        return string2;
    }

    @Override
    public void setPageFormat(PageFormat pageFormat) {
        this.mPageFormat = this.createPageFormat(this.mFrame);
    }

    private void calculateTextSize(ViewerNode viewerNode, boolean bl) {
        ArrayList<ViewerNode> arrayList;
        ViewerItem viewerItem = viewerNode.getViewerItem();
        if (viewerItem instanceof TextViewerItem && !(viewerItem instanceof PageTitleViewerItem) && viewerNode.isPrintable()) {
            this.measureTextItem(viewerNode, bl);
        }
        if ((arrayList = viewerNode.getChildNodes()) != null) {
            for (ViewerNode viewerNode2 : arrayList) {
                this.calculateTextSize(viewerNode2, bl);
            }
        }
    }

    private CustomOutputManager createCustomOutputManagerForTable(TablePrintInfo tablePrintInfo, TableViewerItem tableViewerItem, Graphics2D graphics2D) throws VisualizationException {
        Visualization visualization = tableViewerItem.acquireVisualization();
        VizDataSource.switchToFullTable((Visualization)visualization);
        visualization.setRenderingHints(BaseImageRenderer.getRendingHints());
        CustomOutputManager customOutputManager = visualization.getCustomOutputManager(tablePrintInfo.getPageFormat());
        customOutputManager.setAffineTransform(AffineTransform.getScaleInstance(this.mZoomFactor, this.mZoomFactor));
        tablePrintInfo.setCustomOutputManager(customOutputManager);
        customOutputManager.setFirstPageFormat(tablePrintInfo.getFirstPageFormat());
        customOutputManager.setScalingFactor(1.0f);
        customOutputManager.setShrinkToFit(tablePrintInfo.isFitWidth(), tablePrintInfo.isFitHeight());
        customOutputManager.setWidowOrphanLimit(tablePrintInfo.getWidowOrphanLimit());
        boolean bl = tablePrintInfo.isContAtBottom();
        boolean bl2 = tablePrintInfo.isContAtTop();
        String string = tablePrintInfo.getContinueText();
        String string2 = null;
        String string3 = null;
        if (bl2) {
            string2 = string;
        }
        if (bl) {
            string3 = string;
        }
        customOutputManager.setContinuationText(string2, string3);
        if (customOutputManager.getLayers().size() > 0) {
            customOutputManager.setCurrentLayer(tablePrintInfo.getCurrentLayer());
        }
        return customOutputManager;
    }

    private CustomOutputManager createCustomOutputManagerForModelTable(TablePrintInfo tablePrintInfo, ModelViewer modelViewer, Graphics2D graphics2D) throws VisualizationException {
        if (tablePrintInfo.getModelViewInfoId() == null) {
            return null;
        }
        Visualization[] visualizationArray = modelViewer.makeVisualizationsForView(tablePrintInfo.getModelViewInfoId());
        Visualization visualization = visualizationArray[tablePrintInfo.getVizIndex()];
        visualization.setRenderingHints(BaseImageRenderer.getRendingHints());
        CustomOutputManager customOutputManager = visualization.getCustomOutputManager(tablePrintInfo.getPageFormat());
        customOutputManager.setAffineTransform(AffineTransform.getScaleInstance(this.mZoomFactor, this.mZoomFactor));
        tablePrintInfo.setCustomOutputManager(customOutputManager);
        customOutputManager.setFirstPageFormat(tablePrintInfo.getFirstPageFormat());
        customOutputManager.setScalingFactor(1.0f);
        customOutputManager.setShrinkToFit(tablePrintInfo.isFitWidth(), tablePrintInfo.isFitHeight());
        customOutputManager.setWidowOrphanLimit(tablePrintInfo.getWidowOrphanLimit());
        boolean bl = tablePrintInfo.isContAtBottom();
        boolean bl2 = tablePrintInfo.isContAtTop();
        String string = tablePrintInfo.getContinueText();
        String string2 = null;
        String string3 = null;
        if (bl2) {
            string2 = string;
        }
        if (bl) {
            string3 = string;
        }
        customOutputManager.setContinuationText(string2, string3);
        if (customOutputManager.getLayers().size() > 0) {
            customOutputManager.setCurrentLayer(tablePrintInfo.getCurrentLayer());
        }
        return customOutputManager;
    }

    private Visualization createVisualizationForModel(PrintData printData, ModelViewer modelViewer) throws VisualizationException {
        if (printData.getModelViewInfoId() == null) {
            return null;
        }
        Visualization[] visualizationArray = modelViewer.makeVisualizationsForView(printData.getModelViewInfoId());
        return visualizationArray[printData.getVizIndex()];
    }

    private void fillPrintNodeList(ViewerNode viewerNode) {
        ArrayList<ViewerNode> arrayList;
        ViewerItem viewerItem = viewerNode.getViewerItem();
        if ((viewerNode.isPrintable() && (viewerItem instanceof ChartViewerItem || viewerItem instanceof GraphBoardViewerItem) || viewerNode.isPrintable() && viewerItem instanceof JsonChartViewerItem || viewerNode.isPrintable() && viewerItem instanceof JsonInteractiveViewerItem || viewerNode.isPrintable() && viewerItem instanceof ModelViewerItem || viewerNode.isPrintable() && viewerItem instanceof ImageViewerItem || viewerNode.isPrintable() && viewerItem instanceof GenericViewerItem || viewerNode.isPrintable() && viewerItem instanceof TableViewerItem || viewerNode.isPrintable() && viewerItem instanceof LightTableViewerItem || viewerItem instanceof TextViewerItem || viewerNode.isPrintable() && viewerItem instanceof TreeModelViewerItem) && (!this.mPrintSelection || this.mPrintSelection && viewerNode.getViewerItem().isSelected())) {
            this.mPrintNodeList.add(viewerNode);
        }
        if ((arrayList = viewerNode.getChildNodes()) != null) {
            for (ViewerNode viewerNode2 : arrayList) {
                this.fillPrintNodeList(viewerNode2);
            }
        }
    }

    private void doPageMeasurements(int n, Graphics2D graphics2D) {
        if (this.isCancel()) {
            return;
        }
        if (this.mIsPrintPreview && this.mPreviewWindowClose) {
            return;
        }
        ListIterator<ViewerNode> listIterator = this.mPrintNodeList.listIterator(this.mNodeToBeMeasuredIndex);
        while (listIterator.hasNext()) {
            ViewerNode viewerNode = listIterator.next();
            ViewerItem viewerItem = viewerNode.getViewerItem();
            try {
                if (viewerNode.isPrintable() && (viewerItem instanceof ChartViewerItem || viewerItem instanceof GraphBoardViewerItem)) {
                    this.showProgessBarMeasureMsg(viewerItem);
                    this.measureChartItem(viewerNode, graphics2D);
                } else if (viewerNode.isPrintable() && viewerItem instanceof ModelViewerItem) {
                    this.showProgessBarMeasureMsg(viewerItem);
                    this.measureModelItem(viewerNode, graphics2D);
                } else if (viewerNode.isPrintable() && viewerItem instanceof ImageViewerItem) {
                    this.showProgessBarMeasureMsg(viewerItem);
                    this.measureImageItem(viewerNode);
                } else if (viewerNode.isPrintable() && viewerItem instanceof GenericViewerItem) {
                    this.showProgessBarMeasureMsg(viewerItem);
                    this.measureGenericItem(viewerNode);
                } else if (!viewerNode.isPrintable() || !(viewerItem instanceof HeaderViewerItem)) {
                    if (viewerNode.isPrintable() && viewerItem instanceof TableViewerItem) {
                        this.showProgessBarMeasureMsg(viewerItem);
                        this.measureTableItem(viewerNode, graphics2D);
                    } else if (viewerNode.isPrintable() && viewerItem instanceof LightTableViewerItem) {
                        this.showProgessBarMeasureMsg(viewerItem);
                        this.measureLightTableItem(viewerNode);
                    } else if (viewerItem instanceof TextViewerItem) {
                        this.showProgessBarMeasureMsg(viewerItem);
                        if (viewerItem instanceof PageTitleViewerItem) {
                            this.calculatePageTitle((PageTitleViewerItem)viewerItem);
                        } else if (viewerNode.isPrintable()) {
                            this.measureTextItem(viewerNode, true);
                        }
                    } else if (viewerNode.isPrintable() && viewerItem instanceof TreeModelViewerItem) {
                        this.showProgessBarMeasureMsg(viewerItem);
                        this.measureTreeItem(viewerNode);
                    } else if (viewerNode.isPrintable() && viewerItem instanceof JsonChartViewerItem) {
                        this.showProgessBarMeasureMsg(viewerItem);
                        this.measureJsonItem(viewerNode, graphics2D);
                    } else if (viewerNode.isPrintable() && viewerItem instanceof JsonInteractiveViewerItem) {
                        this.showProgessBarMeasureMsg(viewerItem);
                        this.measureJsonInteractiveItem(viewerNode, graphics2D);
                    }
                }
            }
            catch (Exception exception) {
                PvtLogger.printStackTrace((Exception)exception);
            }
            this.mNodeToBeMeasuredIndex = listIterator.nextIndex();
            if (this.mPrintDataMap.get(n + 1) == null) continue;
            break;
        }
    }

    private boolean handleBigFootnotes(ViewerNode viewerNode, ArrayList<String> arrayList) {
        LabelSpecification[] labelSpecificationArray;
        boolean bl = false;
        TableViewerItem tableViewerItem = (TableViewerItem)viewerNode.getViewerItem();
        Visualization visualization = tableViewerItem.acquireVisualization();
        VisualizationSpecification visualizationSpecification = visualization.getSpecification();
        for (LabelSpecification labelSpecification : labelSpecificationArray = (LabelSpecification[])visualizationSpecification.findDescendantsOfType(LabelSpecification.class)) {
            TextSpecification[] textSpecificationArray;
            if (labelSpecification.getLabelPurpose() != LabelPurposeType.FOOTNOTE || (textSpecificationArray = labelSpecification.getTextSpecifications()) == null || textSpecificationArray.length <= 30) continue;
            this.extractBigFootnotes(arrayList, labelSpecification, textSpecificationArray);
            bl = true;
        }
        return bl;
    }

    private void measureBigFootnotes(ViewerNode viewerNode, TableProperties tableProperties, ArrayList<String> arrayList, Graphics2D graphics2D) {
        PageFormat pageFormat = (PageFormat)this.mPageFormat.clone();
        pageFormat.setOrientation(1);
        Paper paper = (Paper)pageFormat.getPaper().clone();
        paper.setImageableArea(0.0, 0.0, this.mPageFormat.getImageableWidth(), this.getPrintableHeightForItems());
        pageFormat.setPaper(paper);
        try {
            VisualizationFactory visualizationFactory = VisualizationFactory.getInstance();
            VisualizationSpecification visualizationSpecification = new VisualizationSpecification((Reader)new StringReader(FootnotesVisTemplate.sFootnotesVisStr));
            DataSpecification[] dataSpecificationArray = visualizationSpecification.getDataSpecifications();
            EmbeddedSourceSpecification embeddedSourceSpecification = (EmbeddedSourceSpecification)dataSpecificationArray[0];
            int n = arrayList.size();
            String[][] stringArray = new String[5][n];
            stringArray[0] = new String[n];
            stringArray[1] = new String[n];
            stringArray[3] = new String[n];
            stringArray[4] = new String[n];
            stringArray[2] = arrayList.toArray(new String[0]);
            for (int i = 0; i < n; ++i) {
                stringArray[1][i] = String.valueOf(i);
                stringArray[3][i] = " ";
            }
            embeddedSourceSpecification.setData((Object[])stringArray);
            Visualization visualization = visualizationFactory.makeVisualization(visualizationSpecification);
            CustomOutputManager customOutputManager = visualization.getCustomOutputManager(pageFormat);
            customOutputManager.setAffineTransform(AffineTransform.getScaleInstance(this.mZoomFactor, this.mZoomFactor));
            customOutputManager.setShrinkToFit(true, false);
            customOutputManager.setScalingFactor(1.0f);
            this.calculateSingleLayerTable(viewerNode, customOutputManager, tableProperties, false, true, false, graphics2D);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
    }

    private void extractBigFootnotes(ArrayList<String> arrayList, LabelSpecification labelSpecification, TextSpecification[] textSpecificationArray) {
        LabelFrameSpecification labelFrameSpecification = (LabelFrameSpecification)labelSpecification.getParent();
        Specification specification = labelFrameSpecification.getParent();
        specification.remove((Specification)labelFrameSpecification);
        String string = null;
        for (int i = 0; i < textSpecificationArray.length; ++i) {
            if (i % 2 == 0) {
                string = textSpecificationArray[i].getText();
                continue;
            }
            string = string + textSpecificationArray[i].getText().replace('\n', ' ');
            arrayList.add(string);
        }
    }

    private void showWideHeightTableErrorMessage(final boolean bl, final boolean bl2) {
        if (this.mIsPrintPreview) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (bl) {
                        OutputViewPrintable.this.showWideTableError();
                    } else {
                        OutputViewPrintable.this.showCellHightTableError(bl2 ? "IDS_TABLE_CELLS_TOO_HIGH1" : "IDS_TABLE_CELLS_TOO_HIGH");
                    }
                }
            });
        } else if (bl) {
            this.showWideTableError();
        } else {
            this.showCellHightTableError(bl2 ? "IDS_TABLE_CELLS_TOO_HIGH1" : "IDS_TABLE_CELLS_TOO_HIGH");
        }
    }

    private void init() {
        this.doHeaderFooterCalculation();
        int n = (int)this.getPrintableHeightForItems();
        this.mSelectedChartSize = this.getSelectedChartSize();
        this.mChartHeight = n;
        this.mChartWidth = (int)this.getPrintableWidth();
        if (this.mSelectedChartSize == PrintedChartSize.eFULL_PAGE_HEIGHT) {
            this.mChartHeight = n - (int)(this.mHeaderBounds.getMaxY() + (this.mUniformHeader ? this.mInterItemSpacing : 0.0));
        } else if (this.mSelectedChartSize == PrintedChartSize.eHALF_PAGE_HEIGHT) {
            this.mChartHeight = (int)((double)(n / 2) - this.mInterItemSpacing) - 1;
        } else if (this.mSelectedChartSize == PrintedChartSize.eQUARTER_PAGE_HEIGHT) {
            this.mChartHeight = (int)((double)(n / 4) - this.mInterItemSpacing) - 1;
        } else if (this.mSelectedChartSize == PrintedChartSize.eAS_IS) {
            this.mChartHeight = n;
        }
        this.mCurrentPageNumber = 0;
        this.mPrintDataMap = new Hashtable<Integer, List<PrintData>>();
        this.mPrintDataMap.put(0, new ArrayList());
        this.mCurrentY = this.mHeaderBounds.getMaxY();
        if (this.mUniformHeader) {
            this.mCurrentY += this.mInterItemSpacing;
        }
        this.resetPageTitleForFirstPrintableItem();
        this.mNodeToBeMeasuredIndex = 0;
        this.mPrintNodeList = new LinkedList<ViewerNode>();
        this.mTablesWithLongRowLabel = new ArrayList();
    }

    private void showLongTableRowLableMessageForPrintPreview(ArrayList<ViewerItem> arrayList) {
        if (this.mTablesWithLongRowLabel.size() > 0) {
            boolean bl = false;
            String string = ResUtil.getCommonDlgString("IDS_LONG_TABLE_ROW_LABEL_WARNING");
            string = ResUtil.wrapStringByWord(string, 80) + "\n\n";
            for (ViewerItem viewerItem : this.mTablesWithLongRowLabel) {
                if (!arrayList.contains(viewerItem)) continue;
                string = string + ResUtil.wrapStringByWord(viewerItem.getName(), 80) + "\n";
                bl = true;
            }
            if (bl) {
                this.mTablesWithLongRowLabel.removeAll(arrayList);
                JOptionPane.showMessageDialog(null, string);
            }
        }
    }

    public static enum TableLayerPrintSetting {
        eHONOR_TABLE_SETTING,
        eALL_LAYERS,
        eVISIBLE_LAYER_ONLY;

    }

    public static enum PrintRange {
        eALL,
        eSELECTED,
        eVISIBLE;

    }

    public static enum PrintedChartSize {
        eAS_IS,
        eFULL_PAGE_HEIGHT,
        eHALF_PAGE_HEIGHT,
        eQUARTER_PAGE_HEIGHT;

    }
}

