/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.print;

import com.spss.java_client.core.documents.data.dictionary.DisplayAlignment;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataTableCellRenderer;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.java_client.ui.doc_types.data.SpssRowHeaderTable;
import com.spss.java_client.ui.doc_types.data.SpssTable;
import com.spss.java_client.ui.print.PrintOptions;
import com.spss.java_client.ui.print.SpssPrintable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.MessageFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DataEditViewPrintable
extends SpssPrintable {
    private JTable mMainClonedTable;
    private SpssTable mMainOriginalTable;
    private SpssRowHeaderTable mRowHeaderTable;
    private JTableHeader mMainHeader;
    private JTableHeader mRowHeaderHeader;
    private TableColumnModel mColModel;
    private int mTotalColWidth;
    private SpssPrintable.PrintMode mPrintMode;
    private String mHeaderText;
    private MessageFormat mFooterFormatLeft;
    private MessageFormat mFooterFormatRight;
    private int mLast = -1;
    private int mRow = 0;
    private int mCol = 0;
    private final Rectangle mMainClip = new Rectangle(0, 0, 0, 0);
    private final Rectangle mHeaderClip = new Rectangle(0, 0, 0, 0);
    private final Rectangle mRowHeaderClip = new Rectangle(0, 0, 0, 0);
    private final Rectangle mTempRect = new Rectangle(0, 0, 0, 0);
    private static final int H_F_SPACE = 8;
    private static final int HEADER_FONT_SIZE = 14;
    private static final int FOOTER_FONT_SIZE = 12;
    private Font mHeaderFont;
    private Font mFooterFont;
    private long mRowCount;
    private Date mCurrentTime;
    private DataView mDataView;
    private int mRowSelStart;
    private int mRowSelEnd;
    private int mColSelStart;
    private int mColSelEnd;
    private DisplayAlignment mCellAlign;
    private int mCellColumnOffset = 0;

    public DataEditViewPrintable(DataFrame dataFrame, PrintOptions printOptions, String string) {
        super(printOptions);
        this.mDataView = dataFrame.getDataView();
        PageFormat pageFormat = printOptions.getPageFormat();
        if (pageFormat == null) {
            pageFormat = this.createPageFormat();
        }
        printOptions.setPageFormat(pageFormat);
        try {
            this.mMainOriginalTable = (SpssTable)this.mDataView.getDataTables()[0];
            this.mMainClonedTable = this.mMainOriginalTable.clone();
            this.mMainClonedTable.setRowHeight(this.mMainOriginalTable.getRowHeight());
            this.mRowHeaderTable = ((SpssRowHeaderTable)this.mDataView.getDataTables()[1]).clone();
            this.mRowHeaderTable.setRowHeight(this.mMainOriginalTable.getRowHeight());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        this.mMainHeader = this.mMainClonedTable.getTableHeader();
        this.mRowHeaderHeader = this.mRowHeaderTable.getTableHeader();
        this.mColModel = this.mMainClonedTable.getColumnModel();
        if (this.mMainHeader != null) {
            this.mHeaderClip.height = this.mMainHeader.getHeight();
        }
        this.mRowHeaderClip.width = this.mRowHeaderTable.getColumnModel().getColumn(0).getWidth();
        this.mPrintMode = this.mPrintOptions.getPrintMode();
        this.mHeaderText = string;
        this.mFooterFormatLeft = new MessageFormat("{0}");
        this.mFooterFormatRight = new MessageFormat("{0}");
        this.mHeaderFont = this.mMainClonedTable.getFont().deriveFont(0, 14.0f);
        this.mFooterFont = this.mMainClonedTable.getFont().deriveFont(0, 12.0f);
        this.mCurrentTime = new GregorianCalendar().getTime();
    }

    @Override
    public void printInit() {
        if (this.getPrintOPtions().isPrintSelection()) {
            this.mRowCount = this.mMainOriginalTable.getSelectedRowCount();
            int n = this.mMainOriginalTable.getSelectedColumnCount();
            this.mRowSelStart = this.mMainOriginalTable.getSelectedRows()[0];
            this.mRowSelEnd = this.mMainOriginalTable.getSelectedRows()[this.mMainOriginalTable.getSelectedRowCount() - 1];
            this.mColSelStart = this.mMainOriginalTable.getSelectedColumns()[0];
            this.mColSelEnd = this.mMainOriginalTable.getSelectedColumns()[this.mMainOriginalTable.getSelectedColumnCount() - 1];
            this.mRow = this.mRowSelStart;
            this.mCol = this.mColSelStart;
            this.mTotalColWidth = 0;
            for (int i = 0; i < n; ++i) {
                TableColumn tableColumn = this.mColModel.getColumn(i);
                if (!this.mMainOriginalTable.isColumnSelected(i)) continue;
                this.mTotalColWidth += tableColumn.getPreferredWidth();
            }
        } else {
            this.mRowCount = this.mDataView.getDataRowCount();
            int n = this.mDataView.getDataColumnCount();
            this.mRowSelStart = 0;
            this.mRowSelEnd = (int)this.mRowCount - 1;
            this.mColSelStart = 0;
            this.mColSelEnd = n - 1;
            this.mRow = this.mRowSelStart;
            this.mCol = this.mColSelStart;
            this.mTotalColWidth = 0;
            for (int i = 0; i < n; ++i) {
                TableColumn tableColumn = this.mColModel.getColumn(i);
                this.mTotalColWidth += tableColumn.getPreferredWidth();
            }
        }
    }

    @Override
    public boolean hasAnySelected() {
        return this.mMainOriginalTable.getSelectedRowCount() > 1 || this.mMainOriginalTable.getSelectedColumnCount() > 1;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        PageFormat pageFormat2 = this.getPrintOPtions().getPageFormat();
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        Color color = graphics2D.getColor();
        graphics2D.scale(this.mZoomFactor, this.mZoomFactor);
        graphics2D.setBackground(Color.white);
        graphics2D.clearRect(0, 0, (int)(pageFormat2.getWidth() / this.mZoomFactor), (int)(pageFormat2.getHeight() / this.mZoomFactor));
        graphics2D.translate(this.getImageableX(pageFormat2), pageFormat2.getImageableY());
        this.mCellAlign = null;
        if (n == 0) {
            this.mNumberOfPages = this.getTotalPageNumber(graphics, pageFormat2);
        }
        if (this.printHeaderFooter(graphics2D, pageFormat2, n) == 1) {
            return 1;
        }
        AffineTransform affineTransform2 = graphics2D.getTransform();
        Shape shape2 = graphics2D.getClip();
        int n2 = this.mMainClip.x;
        if (this.mCellColumnOffset > 0) {
            this.mMainClip.x = this.mCellColumnOffset;
        }
        graphics2D.translate(-this.mMainClip.x + this.mRowHeaderClip.width, -this.mMainClip.y + this.mHeaderClip.height);
        graphics2D.clip(this.mMainClip);
        this.mMainClonedTable.print(graphics2D);
        this.mMainClip.x = n2;
        graphics2D.setTransform(affineTransform2);
        graphics2D.setClip(shape2);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(0, 0, this.mRowHeaderClip.width + this.mMainClip.width, this.mHeaderClip.height + this.mMainClip.height);
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
        graphics2D.setColor(color);
        return 0;
    }

    private int printHeaderFooter(Graphics2D graphics2D, PageFormat pageFormat, int n) throws PrinterException {
        Object object;
        int n2 = (int)pageFormat.getImageableWidth();
        int n3 = (int)pageFormat.getImageableHeight();
        if (n2 <= 0) {
            throw new PrinterException("Width of printable area is too small.");
        }
        String string = null;
        String string2 = null;
        if (this.mFooterFormatLeft != null) {
            object = String.valueOf(n + 1) + "/" + this.mNumberOfPages;
            string = this.mFooterFormatLeft.format(new Object[]{this.mCurrentTime});
            string2 = this.mFooterFormatRight.format(new Object[]{object});
        }
        object = null;
        Rectangle2D rectangle2D = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = n3;
        if (this.mHeaderText != null) {
            graphics2D.setFont(this.mHeaderFont);
            object = graphics2D.getFontMetrics().getStringBounds(this.mHeaderText, graphics2D);
            n4 = (int)Math.ceil(((RectangularShape)object).getHeight());
            n6 -= n4 + 8;
        }
        if (string != null) {
            graphics2D.setFont(this.mFooterFont);
            rectangle2D = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
            n5 = (int)Math.ceil(rectangle2D.getHeight());
            n6 -= n5 + 8;
        }
        if (n6 <= 0) {
            throw new PrinterException("Height of printable area is too small.");
        }
        double d = this.getScaleFactor(n2);
        while (this.mLast < n) {
            if (this.mRow > this.mRowSelEnd && this.mCol == this.mColSelStart) {
                return 1;
            }
            int n7 = (int)((double)(n2 - this.mRowHeaderClip.width) / d);
            int n8 = (int)((double)(n6 - this.mHeaderClip.height) / d);
            this.findNextClip(n7, n8, this.mLast);
            ++this.mLast;
        }
        if (string != null) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(0, n3 - n5);
            this.printText(graphics2D, string, rectangle2D, this.mFooterFont, n2, 2);
            rectangle2D = graphics2D.getFontMetrics().getStringBounds(string2, graphics2D);
            this.printText(graphics2D, string2, rectangle2D, this.mFooterFont, n2, 4);
            graphics2D.setTransform(affineTransform);
        }
        if (this.mHeaderText != null) {
            this.printText(graphics2D, this.mHeaderText, (Rectangle2D)object, this.mHeaderFont, n2, 0);
            graphics2D.translate(0, n4 + 8);
        }
        this.mTempRect.x = 0;
        this.mTempRect.y = 0;
        this.mTempRect.width = n2;
        this.mTempRect.height = n6;
        graphics2D.clip(this.mTempRect);
        if (d != 1.0) {
            graphics2D.scale(d, d);
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        if (this.mMainHeader != null) {
            graphics2D.clip(new Rectangle(0, 0, this.mRowHeaderClip.width, this.mHeaderClip.height));
            this.mRowHeaderTable.setHeaderPrintMode(true);
            this.mRowHeaderHeader.print(graphics2D);
            this.mRowHeaderTable.setHeaderPrintMode(false);
            graphics2D.setTransform(affineTransform);
            graphics2D.setClip(shape);
            this.mHeaderClip.x = this.mMainClip.x;
            this.mHeaderClip.width = this.mMainClip.width;
            int n9 = this.mHeaderClip.x;
            int n10 = n2 - this.mRowHeaderClip.width;
            if (this.mHeaderClip.width > n10) {
                this.mHeaderClip.x += (this.mHeaderClip.width - n10) / 2;
            }
            graphics2D.translate(-this.mHeaderClip.x + this.mRowHeaderClip.width, 0);
            graphics2D.clip(this.mHeaderClip);
            this.mMainHeader.print(graphics2D);
            this.mHeaderClip.x = n9;
            graphics2D.setTransform(affineTransform);
            graphics2D.setClip(shape);
            graphics2D.translate(0, this.mHeaderClip.height);
        }
        this.mRowHeaderClip.x = 0;
        this.mRowHeaderClip.y = this.mMainClip.y;
        this.mRowHeaderClip.height = this.mMainClip.height;
        graphics2D.translate(0, -this.mRowHeaderClip.y);
        graphics2D.clip(this.mRowHeaderClip);
        this.mRowHeaderTable.setPrintMode(true);
        this.mRowHeaderTable.print(graphics2D);
        this.mRowHeaderTable.setPrintMode(false);
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
        return 0;
    }

    private void printText(Graphics2D graphics2D, String string, Rectangle2D rectangle2D, Font font, int n, int n2) {
        int n3 = 0;
        if (rectangle2D.getWidth() < (double)n) {
            if (n2 == 0) {
                n3 = (int)(((double)n - rectangle2D.getWidth()) / 2.0);
            } else if (n2 == 2) {
                n3 = 0;
            } else if (n2 == 4) {
                n3 = (int)((double)n - rectangle2D.getWidth());
            }
        } else {
            n3 = this.mMainClonedTable.getComponentOrientation().isLeftToRight() ? 0 : -((int)(Math.ceil(rectangle2D.getWidth()) - (double)n));
        }
        int n4 = (int)Math.ceil(Math.abs(rectangle2D.getY()));
        graphics2D.setColor(Color.BLACK);
        graphics2D.setFont(font);
        graphics2D.drawString(string, n3, n4);
    }

    private void findNextClip(int n, int n2, int n3) {
        DataTableCellRenderer dataTableCellRenderer;
        ISpssVariable iSpssVariable;
        TableCellRenderer tableCellRenderer;
        int n4;
        boolean bl = this.mMainClonedTable.getComponentOrientation().isLeftToRight();
        if (this.mCol == this.mColSelStart) {
            this.mMainClip.x = bl ? this.getXAt(this.mColSelStart, false) : this.mTotalColWidth;
            this.mMainClip.y = n3 == -1 ? this.getYAt(this.mRowSelStart) : (this.mMainClip.y += this.mMainClip.height);
            this.mMainClip.width = 0;
            this.mMainClip.height = 0;
            n4 = this.mMainClonedTable.getRowHeight(this.mRow);
            do {
                this.mMainClip.height += n4;
            } while ((long)(++this.mRow) < this.mRowCount + (long)this.mRowSelStart && this.mMainClip.height + (n4 = this.mMainClonedTable.getRowHeight(this.mRow)) <= n2);
        }
        if (this.mPrintMode == SpssPrintable.PrintMode.FIT_WIDTH) {
            this.mMainClip.x = 0;
            this.mMainClip.width = this.mTotalColWidth;
            return;
        }
        if (bl) {
            this.mMainClip.x += this.mMainClip.width;
        }
        this.mMainClip.width = 0;
        this.mCellColumnOffset = 0;
        n4 = this.mColModel.getColumn(this.mCol).getWidth();
        if (n4 >= n && (tableCellRenderer = this.mColModel.getColumn(this.mCol).getCellRenderer()) instanceof DataTableCellRenderer && (iSpssVariable = (dataTableCellRenderer = (DataTableCellRenderer)tableCellRenderer).getSpssVariable()) != null) {
            this.mCellColumnOffset = this.mMainClip.x;
            this.mCellAlign = iSpssVariable.getDisplayAlignment();
            if (this.mCellAlign == DisplayAlignment.right) {
                this.mCellColumnOffset += n4 - n;
            } else if (this.mCellAlign == DisplayAlignment.center) {
                this.mCellColumnOffset += (n4 - n) / 2;
            }
        }
        do {
            this.mMainClip.width += n4;
            if (!bl) {
                this.mMainClip.x -= n4;
            }
            if (++this.mCol <= this.mColSelEnd) continue;
            this.mCol = this.mColSelStart;
            break;
        } while (this.mMainClip.width + (n4 = this.mColModel.getColumn(this.mCol).getWidth()) <= n);
    }

    private int getXAt(int n, boolean bl) {
        int n2 = 0;
        int n3 = n;
        if (bl) {
            n3 = n + 1;
        }
        for (int i = 0; i < n3; ++i) {
            n2 += this.mColModel.getColumn(i).getWidth();
        }
        return n2;
    }

    private int getYAt(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.mMainClonedTable.getRowHeight(i);
        }
        return n2;
    }

    private double getScaleFactor(int n) {
        double d = 1.0;
        if (this.mPrintMode == SpssPrintable.PrintMode.FIT_WIDTH && this.mTotalColWidth > n) {
            assert (n > 0);
            assert (this.mTotalColWidth > 1);
            d = (double)n / (double)(this.mTotalColWidth + this.mRowHeaderClip.width);
        }
        assert (d > 0.0);
        return d;
    }

    private int getTotalPageNumber(Graphics graphics, PageFormat pageFormat) throws PrinterException {
        int n = (int)pageFormat.getImageableWidth();
        int n2 = (int)pageFormat.getImageableHeight();
        int n3 = 0;
        while (true) {
            Object object;
            String string = null;
            if (this.mFooterFormatLeft != null) {
                object = String.valueOf(1) + "/" + this.mNumberOfPages;
                string = this.mFooterFormatLeft.format(new Object[]{this.mCurrentTime, object});
            }
            int n4 = n2;
            if (this.mHeaderText != null) {
                graphics.setFont(this.mHeaderFont);
                object = graphics.getFontMetrics().getStringBounds(this.mHeaderText, graphics);
                int n5 = (int)Math.ceil(((RectangularShape)object).getHeight());
                n4 -= n5 + 8;
            }
            if (string != null) {
                graphics.setFont(this.mFooterFont);
                Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(string, graphics);
                int n6 = (int)Math.ceil(rectangle2D.getHeight());
                n4 -= n6 + 8;
            }
            if (n4 <= 0) {
                throw new PrinterException("Height of printable area is too small.");
            }
            double d = 1.0;
            while (this.mLast < n3) {
                int n7 = (int)((double)(n - this.mRowHeaderClip.width) / d);
                int n8 = (int)((double)(n4 - this.mHeaderClip.height) / d);
                this.findNextClip(n7, n8, this.mLast);
                ++this.mLast;
            }
            if ((long)this.mRow >= this.mRowCount + (long)this.mRowSelStart && this.mCol == this.mColSelStart) break;
            ++n3;
        }
        this.reset();
        return n3 + 1;
    }

    @Override
    public void reset() {
        this.mLast = -1;
        this.mRow = this.mRowSelStart;
        this.mCol = this.mColSelStart;
        this.mMainClip.x = 0;
        this.mMainClip.y = 0;
        this.mMainClip.width = 0;
        this.mMainClip.height = 0;
    }

    @Override
    protected PageFormat createPageFormat() {
        PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();
        Paper paper = pageFormat.getPaper();
        double d = paper.getImageableX();
        double d2 = paper.getImageableY();
        double d3 = paper.getImageableWidth();
        double d4 = paper.getImageableHeight();
        Paper paper2 = new Paper();
        pageFormat = (PageFormat)pageFormat.clone();
        paper2.setImageableArea(d / this.mZoomFactor, d2 / this.mZoomFactor, d3 / this.mZoomFactor, d4 / this.mZoomFactor);
        pageFormat.setPaper(paper2);
        return pageFormat;
    }
}

