/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.laf;

import com.spss.java_client.ui.laf.UITheme;
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalTheme;

public class WindowsMetalUITheme
extends MetalTheme
implements UITheme {
    private static Font menuFont;
    private static Font captionFont;
    private static Font smallFont;
    private static Color menuBackgroundColor;
    private static Color menuForegroundColor;
    private static Color windowBackgroundColor;
    private static Color windowTextColor;
    private static Color disabledTextColor;
    private static Color panelBackgroundColour;
    private static Color panelHighlightColour;
    private static Color panelLightColour;
    private static Color panelLightShadowColour;
    private static Color panelDarkShadowColour;
    private static Color highlightBackgroundColour;
    private static Color highlightForegroundColour;
    private final ColorUIResource menuBackground = new ColorUIResource(menuBackgroundColor);
    private final ColorUIResource menuForeground = new ColorUIResource(menuForegroundColor);
    private final ColorUIResource windowBackground = new ColorUIResource(windowBackgroundColor);
    private final ColorUIResource textForeground = new ColorUIResource(windowTextColor);
    private final ColorUIResource selectionBackground = new ColorUIResource(highlightBackgroundColour);
    private final ColorUIResource selectionForeground = new ColorUIResource(highlightForegroundColour);
    private final ColorUIResource primary1 = new ColorUIResource(panelDarkShadowColour);
    private final ColorUIResource primary2 = new ColorUIResource(panelLightShadowColour);
    private final ColorUIResource primary3 = new ColorUIResource(panelBackgroundColour);
    private final ColorUIResource secondary1 = new ColorUIResource(panelDarkShadowColour);
    private final ColorUIResource secondary2 = new ColorUIResource(panelLightShadowColour);
    private final ColorUIResource secondary3 = new ColorUIResource(panelBackgroundColour);
    private FontUIResource controlFontRes;
    private FontUIResource systemFontRes;
    private FontUIResource userFontRes;
    private FontUIResource menuFontRes;
    private FontUIResource smallFontRes;
    private FontUIResource windowFontRes;

    @Override
    public String getName() {
        return "NativeMetal";
    }

    @Override
    protected ColorUIResource getPrimary1() {
        return this.primary1;
    }

    @Override
    protected ColorUIResource getPrimary2() {
        return this.primary2;
    }

    @Override
    protected ColorUIResource getPrimary3() {
        return this.primary3;
    }

    @Override
    protected ColorUIResource getSecondary1() {
        return this.secondary1;
    }

    @Override
    protected ColorUIResource getSecondary2() {
        return this.secondary2;
    }

    @Override
    protected ColorUIResource getSecondary3() {
        return this.secondary3;
    }

    @Override
    public ColorUIResource getUserTextColor() {
        return this.textForeground;
    }

    @Override
    public ColorUIResource getSystemTextColor() {
        return this.textForeground;
    }

    @Override
    public ColorUIResource getControlInfo() {
        return this.textForeground;
    }

    @Override
    public ColorUIResource getPrimaryControlInfo() {
        return this.textForeground;
    }

    @Override
    public ColorUIResource getWindowBackground() {
        return this.windowBackground;
    }

    @Override
    public ColorUIResource getMenuBackground() {
        return this.menuBackground;
    }

    @Override
    public ColorUIResource getMenuForeground() {
        return this.menuForeground;
    }

    @Override
    public ColorUIResource getMenuSelectedBackground() {
        return this.selectionBackground;
    }

    @Override
    public ColorUIResource getMenuSelectedForeground() {
        return this.selectionForeground;
    }

    @Override
    public ColorUIResource getAcceleratorForeground() {
        return this.menuForeground;
    }

    @Override
    public ColorUIResource getAcceleratorSelectedForeground() {
        return this.selectionForeground;
    }

    @Override
    public ColorUIResource getTextHighlightColor() {
        return this.selectionBackground;
    }

    @Override
    public ColorUIResource getHighlightedTextColor() {
        return this.selectionForeground;
    }

    @Override
    public FontUIResource getControlTextFont() {
        if (this.controlFontRes == null) {
            this.controlFontRes = new FontUIResource(smallFont);
        }
        return this.controlFontRes;
    }

    @Override
    public FontUIResource getSystemTextFont() {
        if (this.systemFontRes == null) {
            this.systemFontRes = new FontUIResource(smallFont);
        }
        return this.systemFontRes;
    }

    @Override
    public FontUIResource getUserTextFont() {
        if (this.userFontRes == null) {
            this.userFontRes = new FontUIResource(smallFont);
        }
        return this.userFontRes;
    }

    @Override
    public FontUIResource getMenuTextFont() {
        if (this.menuFontRes == null) {
            this.menuFontRes = new FontUIResource(menuFont);
        }
        return this.menuFontRes;
    }

    @Override
    public FontUIResource getWindowTitleFont() {
        if (this.windowFontRes == null) {
            this.windowFontRes = new FontUIResource(smallFont);
        }
        return this.windowFontRes;
    }

    @Override
    public FontUIResource getSubTextFont() {
        if (this.smallFontRes == null) {
            this.smallFontRes = new FontUIResource(smallFont);
        }
        return this.smallFontRes;
    }

    @Override
    public FontUIResource getDefaultLabelFont() {
        return this.getSystemTextFont();
    }

    @Override
    public FontUIResource getDefaultBoldLabelFont() {
        return this.getControlTextFont();
    }

    @Override
    public Color getApplicationColor() {
        return this.getWindowBackgroundColor();
    }

    @Override
    public Color getWindowBackgroundColor() {
        return this.getWindowBackground();
    }

    @Override
    public Color getWindowTextColor() {
        return this.getUserTextColor();
    }

    @Override
    public Color getStreamCanvasBackgroundColor() {
        return this.getWindowBackground();
    }

    @Override
    public Color getStreamCanvasForegroundColor() {
        return this.getWindowTextColor();
    }

    @Override
    public Color getCustomWindowBackgroundColor1() {
        return this.getWindowBackground();
    }

    @Override
    public Color getCustomWindowForegroundColor1() {
        return this.getWindowTextColor();
    }

    @Override
    public Color getPanelBackgroundColor1() {
        return this.getControl();
    }

    @Override
    public Color getAreaFocusBorderColor() {
        return Color.black;
    }

    @Override
    public Color getNodeFocusBorderColor() {
        return this.getWindowTextColor();
    }

    @Override
    public void addCustomEntriesToTable(UIDefaults uIDefaults) {
        super.addCustomEntriesToTable(uIDefaults);
        Object[] objectArray = new Object[]{"ComboBox.foreground", this.getUserTextColor(), "ComboBox.background", this.getWindowBackground(), "ComboBox.selectionForeground", this.getHighlightedTextColor(), "ComboBox.selectionBackground", this.getTextHighlightColor(), "TabbedPane.background", this.getControl(), "ScrollBar.width", Toolkit.getDefaultToolkit().getDesktopProperty("win.scrollbar.width")};
        uIDefaults.putDefaults(objectArray);
    }

    private static void lookupWindowsSettings() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        menuFont = (Font)toolkit.getDesktopProperty("win.menu.font");
        captionFont = (Font)toolkit.getDesktopProperty("win.frame.captionFont");
        smallFont = (Font)toolkit.getDesktopProperty("win.status.font");
        menuBackgroundColor = (Color)toolkit.getDesktopProperty("win.menu.backgroundColor");
        menuForegroundColor = (Color)toolkit.getDesktopProperty("win.menu.textColor");
        windowTextColor = (Color)toolkit.getDesktopProperty("win.frame.textColor");
        windowBackgroundColor = (Color)toolkit.getDesktopProperty("win.frame.backgroundColor");
        highlightBackgroundColour = (Color)toolkit.getDesktopProperty("win.item.highlightColor");
        highlightForegroundColour = (Color)toolkit.getDesktopProperty("win.item.highlightTextColor");
        disabledTextColor = (Color)toolkit.getDesktopProperty("win.frame.inactiveCaptionTextColor");
        panelBackgroundColour = (Color)toolkit.getDesktopProperty("win.3d.backgroundColor");
        panelHighlightColour = (Color)toolkit.getDesktopProperty("win.3d.highlightColor");
        panelLightColour = (Color)toolkit.getDesktopProperty("win.3d.lightColor");
        panelLightShadowColour = (Color)toolkit.getDesktopProperty("win.3d.shadowColor");
        panelDarkShadowColour = (Color)toolkit.getDesktopProperty("win.3d.darkShadowColor");
    }

    static {
        WindowsMetalUITheme.lookupWindowsSettings();
    }
}

