/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.laf;

import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.JTextComponent;

public class SpssPlasticXPLookAndFeel
extends PlasticXPLookAndFeel {
    private static Border textFieldBorder;
    private static Border toggleButtonBorder;

    static Border getTextFieldBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new BorderUIResource.CompoundBorderUIResource(new BugFixXPTextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return textFieldBorder;
    }

    static Border getToggleButtonBorder() {
        if (toggleButtonBorder == null) {
            toggleButtonBorder = new BorderUIResource.CompoundBorderUIResource(new BugFixToggleButtonBorder(), new BasicBorders.MarginBorder());
        }
        return toggleButtonBorder;
    }

    protected void initClassDefaults(UIDefaults uIDefaults) {
        super.initClassDefaults(uIDefaults);
        String string = "com.spss.java_client.ui.laf.";
        Object[] objectArray = new Object[]{"TabbedPaneUI", string + "SpssPlasticTabbedPaneUI", "ToolBarUI", string + "SpssPlasticToolBarUI"};
        uIDefaults.putDefaults(objectArray);
    }

    protected void initComponentDefaults(UIDefaults uIDefaults) {
        super.initComponentDefaults(uIDefaults);
        Object[] objectArray = new Object[]{"FileView.hardDriveIcon", LookAndFeel.makeIcon(Plastic3DLookAndFeel.class, "icons/HardDrive.gif"), "FileView.fileIcon", LookAndFeel.makeIcon(Plastic3DLookAndFeel.class, "icons/File.gif"), "FileChooser.upFolderIcon", LookAndFeel.makeIcon(Plastic3DLookAndFeel.class, "icons/UpFolder.gif"), "OptionPane.questionIcon", LookAndFeel.makeIcon(Plastic3DLookAndFeel.class, "icons/Question.png"), "OptionPane.errorIcon", LookAndFeel.makeIcon(Plastic3DLookAndFeel.class, "icons/Error.png"), "FileChooser.newFolderIcon", LookAndFeel.makeIcon(Plastic3DLookAndFeel.class, "icons/NewFolder.gif"), "RadioButton.checkIcon", LookAndFeel.makeIcon(Plastic3DLookAndFeel.class, "icons/RadioLight5x5.png"), "FileView.computerIcon", LookAndFeel.makeIcon(Plastic3DLookAndFeel.class, "icons/Computer.gif"), "OptionPane.informationIcon", LookAndFeel.makeIcon(Plastic3DLookAndFeel.class, "icons/Inform.png"), "OptionPane.warningIcon", LookAndFeel.makeIcon(Plastic3DLookAndFeel.class, "icons/Warn.png"), "Tree.closedIcon", LookAndFeel.makeIcon(Plastic3DLookAndFeel.class, "icons/TreeClosed.gif"), "FileChooser.homeFolderIcon", LookAndFeel.makeIcon(Plastic3DLookAndFeel.class, "icons/HomeFolder.gif"), "Tree.leafIcon", LookAndFeel.makeIcon(Plastic3DLookAndFeel.class, "icons/TreeLeaf.gif"), "FileView.directoryIcon", LookAndFeel.makeIcon(Plastic3DLookAndFeel.class, "icons/TreeClosed.gif"), "FileView.floppyDriveIcon", LookAndFeel.makeIcon(Plastic3DLookAndFeel.class, "icons/FloppyDrive.gif"), "Tree.openIcon", LookAndFeel.makeIcon(Plastic3DLookAndFeel.class, "icons/TreeOpen.gif"), "TextField.border", SpssPlasticXPLookAndFeel.getTextFieldBorder(), "TextField.margin", new Insets(2, 2, 2, 2), "Button.borderPaintsFocus", Boolean.FALSE, "RadioButton.border", SpssPlasticXPLookAndFeel.getToggleButtonBorder(), "CheckBox.border", SpssPlasticXPLookAndFeel.getToggleButtonBorder()};
        uIDefaults.putDefaults(objectArray);
        String string = "TabbedPane.ancestorInputMap";
        InputMap inputMap = (InputMap)uIDefaults.get(string);
        if (inputMap == null) {
            inputMap = new InputMap();
            uIDefaults.put(string, inputMap);
        }
        inputMap.put(KeyStroke.getKeyStroke(9, 128), "navigateNext");
        inputMap.put(KeyStroke.getKeyStroke(9, 192), "navigatePrevious");
    }

    private static class SpssPlasticXPUtils {
        private SpssPlasticXPUtils() {
        }

        static void drawDark3DBorder(Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            SpssPlasticXPUtils.drawFlush3DBorder(graphics, 0, 0, n3, n4);
            graphics.setColor(PlasticLookAndFeel.getControlHighlight());
            graphics.drawLine(n3 - 2, 1, n3 - 2, n4 - 2);
            graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
            graphics.setColor(PlasticLookAndFeel.getControlShadow());
            graphics.drawLine(1, 1, 1, n4 - 2);
            graphics.drawLine(1, 1, n3 - 2, 1);
            graphics.translate(-n, -n2);
        }

        static void drawDisabledBorder(Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(PlasticLookAndFeel.getControlShadow());
            graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            graphics.translate(-n, -n2);
        }

        static void drawFlush3DBorder(Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
            graphics.drawRect(0, 0, n3 - 2, n4 - 2);
            graphics.setColor(PlasticLookAndFeel.getControlHighlight());
            graphics.drawRect(1, 1, n3 - 2, n4 - 2);
            graphics.setColor(PlasticLookAndFeel.getControl());
            graphics.drawLine(0, n4 - 1, 1, n4 - 2);
            graphics.drawLine(n3 - 1, 0, n3 - 2, 1);
            graphics.translate(-n, -n2);
        }

        static void drawPressed3DBorder(Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            SpssPlasticXPUtils.drawFlush3DBorder(graphics, 0, 0, n3, n4);
            graphics.setColor(PlasticLookAndFeel.getControlShadow());
            graphics.drawLine(1, 1, 1, n4 - 2);
            graphics.drawLine(1, 1, n3 - 2, 1);
            graphics.translate(-n, -n2);
        }
    }

    private static class BugFixToggleButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected static final Insets INSETS = new Insets(3, 3, 0, 3);

        private BugFixToggleButtonBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (!buttonModel.isEnabled()) {
                SpssPlasticXPUtils.drawDisabledBorder(graphics, n, n2, n3 - 1, n4 - 1);
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                SpssPlasticXPUtils.drawPressed3DBorder(graphics, n, n2, n3, n4);
            } else if (buttonModel.isSelected()) {
                SpssPlasticXPUtils.drawDark3DBorder(graphics, n, n2, n3, n4);
            } else {
                SpssPlasticXPUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = BugFixToggleButtonBorder.INSETS.top;
            insets.left = BugFixToggleButtonBorder.INSETS.left;
            insets.bottom = BugFixToggleButtonBorder.INSETS.bottom;
            insets.right = BugFixToggleButtonBorder.INSETS.right;
            return insets;
        }
    }

    private static class BugFixXPTextFieldBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(0, 1, 0, 1);

        private BugFixXPTextFieldBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = component instanceof JTextComponent && component.isEnabled() && ((JTextComponent)component).isEditable() || component.isEnabled();
            graphics.setColor(bl ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlShadow());
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = BugFixXPTextFieldBorder.INSETS.top;
            insets.left = BugFixXPTextFieldBorder.INSETS.left;
            insets.bottom = BugFixXPTextFieldBorder.INSETS.bottom;
            insets.right = BugFixXPTextFieldBorder.INSETS.right;
            return insets;
        }
    }
}

