/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.laf;

import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.dialogs.fopen.ChooserUIFactory;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.laf.PlasticUITheme;
import com.spss.java_client.ui.laf.SpssPlasticXPLookAndFeel;
import com.spss.java_client.ui.laf.UITheme;
import com.spss.java_client.ui.laf.WindowsMetalUITheme;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.res.UIToolResUtil;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public final class LookAndFeelManager {
    private UITheme mUITheme = null;
    private LookAndFeel mLookAndFeel = null;
    Class mCobaltLAFClass = null;
    Class mAnalyticsLAFClass = null;

    public LookAndFeelManager() {
        try {
            this.mCobaltLAFClass = Class.forName("com.spss.cobalt_laf.CobaltLookAndFeel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            this.mAnalyticsLAFClass = Class.forName("com.spss.analytics_laf.AnalyticsLafLookAndFeel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public Font getDefaultLabelFont() {
        return this.mUITheme.getDefaultLabelFont();
    }

    public Font getDefaultBoldLabelFont() {
        return this.mUITheme.getDefaultBoldLabelFont();
    }

    public Color getApplicationColor() {
        return this.mUITheme.getApplicationColor();
    }

    public Color getWindowBackgroundColor() {
        return this.mUITheme.getWindowBackgroundColor();
    }

    public Color getWindowTextColor() {
        return this.mUITheme.getWindowTextColor();
    }

    public Color getStreamCanvasBackgroundColor() {
        return this.mUITheme.getStreamCanvasBackgroundColor();
    }

    public Color getStreamCanvasForegroundColor() {
        return this.mUITheme.getStreamCanvasForegroundColor();
    }

    public Color getCustomWindowBackgroundColor1() {
        return this.mUITheme.getCustomWindowBackgroundColor1();
    }

    public Color getCustomWindowForegroundColor1() {
        return this.mUITheme.getCustomWindowForegroundColor1();
    }

    public Color getPanelBackgroundColor1() {
        return this.mUITheme.getPanelBackgroundColor1();
    }

    public Color getAreaFocusBorderColor() {
        return this.mUITheme.getAreaFocusBorderColor();
    }

    public Color getNodeFocusBorderColor() {
        return this.mUITheme.getNodeFocusBorderColor();
    }

    public UITheme getUITheme() {
        return this.mUITheme;
    }

    public void setUITheme(UITheme uITheme) {
        this.mUITheme = uITheme;
    }

    public LookAndFeel getLookAndFeel() {
        return this.mLookAndFeel;
    }

    public void setLookAndFeel(String string) {
        try {
            Object object;
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            Icon icon = UIManager.getLookAndFeel() instanceof WindowsLookAndFeel ? (Icon)UIManager.get("FileChooser.viewMenuIcon") : new ImageIcon(UIToolResUtil.getImageResource((String)"Filechooser_viewMenu.png"));
            if (string.contains("SpssPlasticXPLookAndFeel")) {
                this.mUITheme = new PlasticUITheme();
                PlasticXPLookAndFeel.setMyCurrentTheme((PlasticTheme)((PlasticUITheme)this.mUITheme));
                object = new SpssPlasticXPLookAndFeel();
            } else if (this.mCobaltLAFClass != null && string.contains("CobaltLookAndFeel")) {
                FontUIResource fontUIResource = (FontUIResource)UIManager.get("Menu.font");
                Float f = Float.valueOf(fontUIResource.getSize2D());
                object = (LookAndFeel)this.mCobaltLAFClass.getConstructor(Float.TYPE).newInstance(f);
            } else if (this.mAnalyticsLAFClass != null && string.contains("AnalyticsLafLookAndFeel")) {
                FontUIResource fontUIResource = (FontUIResource)UIManager.get("Menu.font");
                Float f = Float.valueOf(fontUIResource.getSize2D());
                object = (LookAndFeel)this.mAnalyticsLAFClass.getConstructor(Float.TYPE).newInstance(f);
            } else if ("javax.swing.plaf.metal.MetalLookAndFeel".equals(string)) {
                this.mUITheme = new WindowsMetalUITheme();
                MetalLookAndFeel.setCurrentTheme((WindowsMetalUITheme)this.mUITheme);
                object = new MetalLookAndFeel();
            } else if (OSCheck.getOSType() == OSInfo.OSType.MAC && UIManager.getSystemLookAndFeelClassName().equals(string)) {
                Class<?> clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                object = (LookAndFeel)clazz.newInstance();
            } else {
                Class<?> clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                UIManager.getDefaults().put("TextArea.font", UIManager.getFont("TextField.font"));
                object = (LookAndFeel)clazz.newInstance();
            }
            this.setLookAndFeel((LookAndFeel)object);
            ChooserUIFactory.setUseQuaqua(false);
            if (!(object instanceof WindowsLookAndFeel)) {
                UIManager.put("FileChooser.viewMenuIcon", icon);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public void setLookAndFeel(LookAndFeel lookAndFeel) {
        this.mLookAndFeel = lookAndFeel;
        if (!CommandLine.isClementineCaller() || CommandLine.hasLookAndFeel()) {
            this.activateLookAndFeel();
        }
    }

    private void activateLookAndFeel() {
        try {
            boolean bl = false;
            JFrame.setDefaultLookAndFeelDecorated(bl);
            UIManager.setLookAndFeel(this.mLookAndFeel);
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            ViewerItem.setHighlightBorderColor();
            LookAndFeelManager.updateAllUIs();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void updateAllUIs() {
        Frame[] frameArray = Frame.getFrames();
        Dimension dimension = null;
        for (Frame frame : frameArray) {
            if ("InvisibleWelcomeWindow".equals(frame.getName())) continue;
            dimension = frame.getSize();
            LookAndFeelManager.updateWindowUI(frame);
            frame.invalidate();
            frame.doLayout();
            frame.pack();
            frame.setSize(dimension);
        }
    }

    public static void updateWindowUI(Window window) {
        Window[] windowArray;
        try {
            if (UIManager.getLookAndFeel().getName().contains("CobaltLookAndFeel")) {
                SwingUtilities.updateComponentTreeUI(window);
            } else {
                LookAndFeelManager.updateComponentTreeUI(window);
            }
        }
        catch (Exception exception) {
            ComponentState.trace1((String)"Error in LookAndFeelManager.updateWindowUI()", (int)15);
        }
        for (Window window2 : windowArray = window.getOwnedWindows()) {
            LookAndFeelManager.updateWindowUI(window2);
        }
    }

    public static void updateComponentTreeUI(Component component) {
        LookAndFeelManager.updateComponentTreeUI0(component);
        component.invalidate();
        component.validate();
        component.repaint();
    }

    private static void updateComponentTreeUI0(Component component) {
        Component[] componentArray = null;
        if (component instanceof JToolBar) {
            componentArray = ((JToolBar)component).getComponents();
            if (componentArray != null) {
                for (Component component2 : componentArray) {
                    LookAndFeelManager.updateComponentTreeUI0(component2);
                }
            }
            ((JComponent)component).updateUI();
        } else {
            if (component instanceof JComponent) {
                ((JComponent)component).updateUI();
            }
            if (component instanceof JMenu) {
                componentArray = ((JMenu)component).getMenuComponents();
            } else if (component instanceof Container) {
                componentArray = ((Container)component).getComponents();
            }
            if (componentArray != null) {
                for (Component component3 : componentArray) {
                    LookAndFeelManager.updateComponentTreeUI0(component3);
                }
            }
        }
    }
}

