/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.laf;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Paint;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class GradientPanel
extends JPanel {
    public static final String GRADIENT_START_KEY = "GradientStart";
    public static final String GRADIENT_END_KEY = "GradientEnd";
    private int gradientSize = -1;
    private final Color startColor;
    private final Color endColor;
    private final boolean paintTopOnly;

    public GradientPanel() {
        this(new FlowLayout());
    }

    public GradientPanel(LayoutManager layoutManager) {
        this(layoutManager, true);
    }

    public GradientPanel(LayoutManager layoutManager, boolean bl) {
        super(layoutManager);
        this.paintTopOnly = bl;
        this.startColor = UIManager.getColor(GRADIENT_START_KEY);
        this.endColor = UIManager.getColor(GRADIENT_END_KEY);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Object object;
        Object object2;
        super.paintComponent(graphics);
        if (this.paintTopOnly) {
            if (this.gradientSize == -1) {
                object2 = UIManager.getFont("Label.font");
                object = graphics.getFontMetrics((Font)object2);
                this.gradientSize = ((FontMetrics)object).getHeight() + 6;
            }
        } else {
            this.gradientSize = this.getSize().height;
        }
        object2 = (Graphics2D)graphics;
        object = ((Graphics2D)object2).getPaint();
        int n = this.gradientSize == -1 ? this.getHeight() : this.gradientSize;
        ((Graphics2D)object2).setPaint(new GradientPaint(0.0f, 0.0f, this.startColor, 0.0f, n, this.endColor));
        graphics.fillRect(0, 0, this.getWidth(), n);
        ((Graphics2D)object2).setPaint((Paint)object);
    }
}

