/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive.event;

import com.ibm.vis.interaction.HighlightRepresentation;
import com.ibm.vis.interaction.HighlightState;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.interaction.internal.InteractivityImpl;
import com.ibm.vis.interaction.internal.InteractivityWrapper;
import com.ibm.vis.spec.internal.StrokeSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.ui.awt.VisControl;
import com.spss.java_client.ui.interactive.event.VisControlMouseAdapter;
import com.spss.java_client.ui.interactive.event.VisControlMouseListener;
import com.spss.output.vis.charting.ViewInteractivity;
import com.spss.output.vis.charting.ViewInteractivityListener;
import java.util.ArrayList;
import java.util.List;

public class VisControlMouseSelection
extends VisControlMouseAdapter {
    private final InteractivityImpl interactivity;
    private SceneItem[] selectedItems;
    private SceneItem hoverItem;
    private List<PointBasic> ptList = null;
    private ViewInteractivity viewInteractivity;

    public VisControlMouseSelection(VisControl visControl, ViewInteractivity viewInteractivity) {
        this.viewInteractivity = viewInteractivity;
        this.interactivity = (InteractivityImpl)visControl.getInteractivity();
        this.selectedItems = new SceneItem[0];
        this.hoverItem = null;
    }

    @Override
    public void receiveMouseMoved(final int n, final int n2, VisControlMouseListener.ButtonCode buttonCode, boolean bl, boolean bl2) {
        super.receiveMouseMoved(n, n2, buttonCode, bl, bl2);
        if (!this.enabled.booleanValue()) {
            return;
        }
        InteractivityWrapper interactivityWrapper = new InteractivityWrapper(){

            public void run() {
                SceneItem[] sceneItemArray = VisControlMouseSelection.this.interactivity.getItemsAtPoint((double)n, (double)n2);
                SceneItem[] sceneItemArray2 = VisControlMouseSelection.this.viewInteractivity.processInteractiveEvent(ViewInteractivityListener.InteractivityEvent.MouseMoved, sceneItemArray);
            }
        };
        this.interactivity.executeInteractivity(interactivityWrapper);
    }

    @Override
    public void receiveMouseClicked(int n, int n2, VisControlMouseListener.ButtonCode buttonCode, boolean bl, final boolean bl2) {
        super.receiveMouseClicked(n, n2, buttonCode, bl, bl2);
        if (!this.enabled.booleanValue()) {
            return;
        }
        if (buttonCode.equals((Object)VisControlMouseListener.ButtonCode.BUTTON_RIGHT)) {
            return;
        }
        if (this.ptList == null) {
            this.ptList = new ArrayList<PointBasic>();
        }
        if (!bl2) {
            this.ptList.clear();
        }
        PointBasic pointBasic = new PointBasic();
        pointBasic.setPoint(n, n2);
        this.ptList.add(pointBasic);
        InteractivityWrapper interactivityWrapper = new InteractivityWrapper(){

            public void run() {
                ArrayList<SceneItem> arrayList = new ArrayList<SceneItem>();
                for (PointBasic pointBasic : VisControlMouseSelection.this.ptList) {
                    SceneItem[] sceneItemArray;
                    for (SceneItem sceneItem : sceneItemArray = VisControlMouseSelection.this.interactivity.getItemsAtPoint(pointBasic.getX(), pointBasic.getY())) {
                        arrayList.add(sceneItem);
                    }
                }
                SceneItem[] sceneItemArray = VisControlMouseSelection.this.viewInteractivity.processInteractiveEvent(bl2 ? ViewInteractivityListener.InteractivityEvent.MouseControlClicked : ViewInteractivityListener.InteractivityEvent.MouseClicked, arrayList.toArray(new SceneItem[0]));
                VisControlMouseSelection.this.renderHighlight(sceneItemArray);
            }
        };
        this.interactivity.executeInteractivity(interactivityWrapper);
    }

    @Override
    public void receiveMouseDoubleClicked(final int n, final int n2, VisControlMouseListener.ButtonCode buttonCode, boolean bl, boolean bl2) {
        super.receiveMouseDoubleClicked(n, n2, buttonCode, bl, bl2);
        if (!this.enabled.booleanValue()) {
            return;
        }
        InteractivityWrapper interactivityWrapper = new InteractivityWrapper(){

            public void run() {
                SceneItem[] sceneItemArray = VisControlMouseSelection.this.interactivity.getItemsAtPoint((double)n, (double)n2);
                VisControlMouseSelection.this.viewInteractivity.processInteractiveEvent(ViewInteractivityListener.InteractivityEvent.MouseDoubleClicked, sceneItemArray);
                VisControlMouseSelection.this.ptList = null;
            }
        };
        this.interactivity.executeInteractivity(interactivityWrapper);
    }

    private void renderHighlight(SceneItem[] sceneItemArray) {
        if (sceneItemArray == null) {
            return;
        }
        StyleSpec styleSpec = new StyleSpec();
        styleSpec.fill = "rgba(255,255,255,0.0)";
        styleSpec.outline = "#FFEECA";
        StrokeSpec strokeSpec = new StrokeSpec();
        strokeSpec.width = 4;
        styleSpec.stroke = strokeSpec;
        this.interactivity.setHighlightRepresentation(0, new HighlightRepresentation(styleSpec.toJSON()));
        HighlightState highlightState = this.interactivity.makeHighlightState();
        highlightState.setMultiple(sceneItemArray, 0);
        highlightState.apply();
    }

    private final class PointBasic {
        public double x = 0.0;
        public double y = 0.0;

        public void setX(double d) {
            this.x = d;
        }

        public void setY(double d) {
            this.y = d;
        }

        public void setPoint(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }
    }
}

