/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive.event;

import com.sun.awt.AWTUtilities;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class TooltipPanel
extends JPanel {
    private JDialog window;
    private final JLabel label;
    private Shape borderShape;
    private JComponent component;
    public static int CUT_SIZE = 12;

    public TooltipPanel(JComponent jComponent) {
        super(new BorderLayout());
        this.component = jComponent;
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.label = new JLabel();
        this.add((Component)this.label, "Center");
        this.label.setBorder(BorderFactory.createEmptyBorder(8, 8, 8 + CUT_SIZE, 8));
    }

    @Override
    protected void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.draw(this.borderShape);
    }

    private String modify(String string) {
        if (string.startsWith("<html")) {
            return string;
        }
        return "<html>" + string.replaceAll("\n", "<br>") + "</html>";
    }

    private Shape makeShape() {
        int n = this.window.getWidth();
        int n2 = this.window.getHeight();
        int[] nArray = new int[]{0, n, n, 2 * CUT_SIZE, 3 * CUT_SIZE / 2, CUT_SIZE, 0};
        int[] nArray2 = new int[]{0, 0, n2 - CUT_SIZE, n2 - CUT_SIZE, n2, n2 - CUT_SIZE, n2 - CUT_SIZE};
        return new Polygon(nArray, nArray2, 7);
    }

    public void showTooltipText(String string, double d, double d2) {
        if (this.window == null) {
            this.window = new JDialog(SwingUtilities.windowForComponent(this.component), Dialog.ModalityType.MODELESS);
            this.window.setUndecorated(true);
            this.window.setContentPane(this);
            this.window.setFocusableWindowState(false);
            this.window.setFocusable(false);
        }
        if (string == null) {
            this.window.setVisible(false);
            return;
        }
        this.label.setText(this.modify(string));
        this.window.pack();
        Point point = new Point((int)d, (int)d2);
        SwingUtilities.convertPointToScreen(point, this.component);
        this.window.setLocation(point.x - 3 * CUT_SIZE / 2, (int)((double)point.y - (double)this.window.getHeight() * 1.1));
        this.borderShape = this.makeShape();
        AWTUtilities.setWindowShape((Window)this.window, (Shape)this.borderShape);
        AWTUtilities.setWindowOpacity((Window)this.window, (float)1.0f);
        this.window.setVisible(true);
    }
}

