/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive.event;

import com.ibm.vis.ui.awt.VisControl;
import com.spss.java_client.ui.interactive.event.VisControlMouseListener;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Timer;

public class MouseAdapterListener
extends MouseAdapter
implements ActionListener {
    private static final int clickInterval = OSInfo.getOSType() == OSInfo.OSType.MAC ? 500 : (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
    private VisControlMouseListener.ButtonCode button;
    private Point point;
    private boolean shift;
    private boolean control;
    private VisControl vis;
    private MouseEvent lastEvent;
    private Timer timer;
    private List<VisControlMouseListener> mouseListeners;

    public MouseAdapterListener() {
        this(clickInterval);
    }

    public MouseAdapterListener(int n) {
        this.timer = new Timer(n, this);
    }

    public void setListener(VisControl visControl, List<VisControlMouseListener> list) {
        this.vis = visControl;
        this.mouseListeners = list;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 2) {
            return;
        }
        this.lastEvent = mouseEvent;
        this.vis.grabFocus();
        this.getEventData(this.lastEvent);
        if (this.timer.isRunning()) {
            this.timer.stop();
            this.doubleClick(this.lastEvent);
        } else {
            this.timer.restart();
        }
    }

    private void doubleClick(MouseEvent mouseEvent) {
        for (VisControlMouseListener visControlMouseListener : this.mouseListeners) {
            visControlMouseListener.receiveMouseDoubleClicked(this.point.x, this.point.y, this.button, this.shift, this.control);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.timer.stop();
        this.singleClick(this.lastEvent);
    }

    private void singleClick(MouseEvent mouseEvent) {
        for (VisControlMouseListener visControlMouseListener : this.mouseListeners) {
            visControlMouseListener.receiveMouseClicked(this.point.x, this.point.y, this.button, this.shift, this.control);
        }
    }

    private void getEventData(MouseEvent mouseEvent) {
        this.button = VisControlMouseListener.ButtonCode.BUTTON_NONE;
        if (mouseEvent.getButton() == 1) {
            this.button = VisControlMouseListener.ButtonCode.BUTTON_LEFT;
        } else if (mouseEvent.getButton() == 2) {
            this.button = VisControlMouseListener.ButtonCode.BUTTON_MIDDLE;
        } else if (mouseEvent.getButton() == 3) {
            this.button = VisControlMouseListener.ButtonCode.BUTTON_RIGHT;
        }
        this.point = mouseEvent.getPoint();
        this.shift = (mouseEvent.getModifiers() & 1) != 0;
        this.control = (mouseEvent.getModifiers() & 2) != 0;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.vis.grabFocus();
        this.getEventData(mouseEvent);
        for (VisControlMouseListener visControlMouseListener : this.mouseListeners) {
            visControlMouseListener.receiveMouseDragged(this.point.x, this.point.y, this.button, this.shift, this.control);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.getEventData(mouseEvent);
        for (VisControlMouseListener visControlMouseListener : this.mouseListeners) {
            visControlMouseListener.receiveMouseMoved(this.point.x, this.point.y, this.button, this.shift, this.control);
        }
    }
}

