/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive;

import com.ibm.json.java.JSONObject;
import com.spss.java_client.core.documents.output.OutputItem;
import com.spss.java_client.core.documents.output.chart.JsonChartItem;
import com.spss.java_client.core.documents.output.header.HeaderItem;
import com.spss.java_client.core.documents.output.interactive.JsonInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.TCMSequenceDiagramPopupInteractiveItem;
import com.spss.java_client.core.documents.output.text.TitleItem;
import com.spss.java_client.ui.doc_types.output.JsonInteractiveViewerItem;
import com.spss.java_client.ui.interactive.JsonInteractiveFrame;
import com.spss.java_client.ui.interactive.OutputVisPanel;
import com.spss.java_client.ui.interactive.TCMScenarioAnalysisInteractiveFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.output.vis.charting.OutputVisComponent;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.JMenu;

public class TCMSequenceDiagramPopupInteractiveFrame
extends JsonInteractiveFrame
implements WindowListener {
    private OutputVisComponent mVisComp;
    private JSONObject mSequenceDiagramJSON;
    private JSONObject mSequenceDiagramDataModelJSON;
    private int mPreferredMainHeight;
    private int mPreferredMainWidth;
    private JsonInteractiveFrame mParentJsonInteractiveFrame;

    public TCMSequenceDiagramPopupInteractiveFrame(JsonInteractiveViewerItem jsonInteractiveViewerItem) {
        this(jsonInteractiveViewerItem, null);
    }

    public TCMSequenceDiagramPopupInteractiveFrame(JsonInteractiveViewerItem jsonInteractiveViewerItem, JsonInteractiveFrame jsonInteractiveFrame) {
        super(jsonInteractiveViewerItem);
        this.setTitle(this.mResBundle.getString("IDS_INTERACTIVE_OUTPUT_TITLE") + this.mResBundle.getString("IDS_INTERACTIVE_OUTPUT_TITLE_SEP") + this.mResBundle.getString("IDS_TCM_SEQUENCE_DIAGRAM"));
        this.mParentJsonInteractiveFrame = jsonInteractiveFrame;
        this.setMinimumSize(new Dimension(550, 400));
        this.constructGUI();
        this.constructMenus();
        this.setTabTraversalPolicy();
        this.addWindowListener(this);
        this.setLocationRelativeTo(jsonInteractiveFrame);
        if (this.mParentJsonInteractiveFrame != null) {
            this.mParentJsonInteractiveFrame.addWindowListener(this);
        }
    }

    @Override
    public void doCopyChartToViewer() {
        String string = this.mParentJsonInteractiveFrame != null && this.mParentJsonInteractiveFrame instanceof TCMScenarioAnalysisInteractiveFrame ? this.mResBundle.getString("IDS_TCM_SERIES_PLOTS") : this.mResBundle.getString("IDS_TCM_IMPACT_DIAGRAM") + " " + this.mResBundle.getString("IDS_TCM_SEQUENCE") + " " + this.mResBundle.getString("IDS_TCM_CHART");
        this.copyJsonChartItemIntoViewer(this.getParentHeaderItem(string));
    }

    protected void copyJsonChartItemIntoViewer(HeaderItem headerItem) {
        TCMSequenceDiagramPopupInteractiveItem tCMSequenceDiagramPopupInteractiveItem;
        TCMSequenceDiagramPopupInteractiveItem tCMSequenceDiagramPopupInteractiveItem2 = (TCMSequenceDiagramPopupInteractiveItem)this.mInteractiveViewerItem.getItem();
        JsonInteractiveItem jsonInteractiveItem = this.mParentJsonInteractiveFrame.getJsonInteractiveItem();
        JsonChartItem jsonChartItem = this.constructJsonChartItem(jsonInteractiveItem);
        if (this.mParentJsonInteractiveFrame instanceof TCMScenarioAnalysisInteractiveFrame && (tCMSequenceDiagramPopupInteractiveItem = (TCMSequenceDiagramPopupInteractiveItem)this.mInteractiveViewerItem.getItem()).getSeriesName() != null) {
            jsonChartItem.setDescription(tCMSequenceDiagramPopupInteractiveItem.getSeriesName());
        }
        jsonChartItem.setVDPData(tCMSequenceDiagramPopupInteractiveItem2.getMainVDPData());
        this.mParentJsonInteractiveFrame.insertItemIntoViewerAsLastChild((OutputItem)jsonChartItem, headerItem);
    }

    private HeaderItem getParentHeaderItem(String string) {
        HeaderItem headerItem = this.mParentJsonInteractiveFrame.findItemByDescription(string);
        if (headerItem == null) {
            OutputItem outputItem;
            int n;
            TitleItem titleItem = new TitleItem();
            titleItem.setDescription(ResUtil.getString("IDS_VIEWER_ITEM_TITLE"));
            titleItem.setContents(string);
            JsonInteractiveItem jsonInteractiveItem = this.mParentJsonInteractiveFrame.getJsonInteractiveItem();
            headerItem = new HeaderItem();
            headerItem.setProcedureName(jsonInteractiveItem.getProcedureName());
            headerItem.setCreatorVersion(jsonInteractiveItem.getCreatorVersion());
            headerItem.setAlignment(jsonInteractiveItem.getAlignment());
            headerItem.setVisible(true);
            headerItem.setDescription(string);
            HeaderItem headerItem2 = this.mParentJsonInteractiveFrame instanceof TCMScenarioAnalysisInteractiveFrame ? (HeaderItem)((OutputItem)jsonInteractiveItem.getParentItem()) : (HeaderItem)((OutputItem)jsonInteractiveItem.getParentItem().getParentItem());
            int n2 = -1;
            for (n = 0; n < headerItem2.getChildCount(); ++n) {
                outputItem = (OutputItem)headerItem2.getChildItem(n);
                if (this.mParentJsonInteractiveFrame instanceof TCMScenarioAnalysisInteractiveFrame) {
                    if (!outputItem.getDescription().equals(this.mResBundle.getString("IDS_TCM_SCENARIO_ANALYSIS_FORECASTED_VALUES"))) continue;
                    n2 = n + 1;
                    break;
                }
                if (!outputItem.getDescription().equals(this.mResBundle.getString("IDS_TCM_IMPACT_DIAGRAM") + " " + this.mResBundle.getString("IDS_TCM_CHART"))) continue;
                n2 = n + 1;
                break;
            }
            if (n2 == -1) {
                for (n = 0; n < headerItem2.getChildCount(); ++n) {
                    outputItem = (OutputItem)headerItem2.getChildItem(n);
                    if (!outputItem.getDescription().equals(this.mResBundle.getString("IDS_TCM_IMPACT_DIAGRAM"))) continue;
                    n2 = n + 1;
                    break;
                }
            }
            this.mParentJsonInteractiveFrame.insertItemIntoViewerAt((OutputItem)headerItem, headerItem2, n2);
            this.mParentJsonInteractiveFrame.insertItemIntoViewerAt((OutputItem)titleItem, headerItem, n2);
        }
        return headerItem;
    }

    @Override
    protected JsonChartItem constructJsonChartItem(JsonInteractiveItem jsonInteractiveItem) {
        JsonChartItem jsonChartItem = new JsonChartItem(jsonInteractiveItem.getLocale());
        jsonChartItem.setProcedureName(jsonInteractiveItem.getProcedureName());
        jsonChartItem.setCreatorVersion(jsonInteractiveItem.getCreatorVersion());
        jsonChartItem.setAlignment(jsonInteractiveItem.getAlignment());
        jsonChartItem.setTemplate(false);
        jsonChartItem.getGeoJsonIDs().addAll(jsonInteractiveItem.getGeoJsonIDs());
        jsonChartItem.setVisible(true);
        jsonChartItem.setDescription(this.getDescriptionForSelectedDisplay());
        return jsonChartItem;
    }

    @Override
    protected void constructGUI() {
        TCMSequenceDiagramPopupInteractiveItem tCMSequenceDiagramPopupInteractiveItem = (TCMSequenceDiagramPopupInteractiveItem)this.mInteractiveViewerItem.getItem();
        OutputVisComponent outputVisComponent = tCMSequenceDiagramPopupInteractiveItem.getMainVisComponent();
        this.mMainDisplayPanel = new OutputVisPanel(outputVisComponent);
        this.mMainDisplayPanel.setActionsList(tCMSequenceDiagramPopupInteractiveItem.getMainActionsList());
        this.mMainDisplayPanel.setFocusable(true);
        this.add(this.mMainDisplayPanel);
    }

    @Override
    protected Vector<Object> addControlsForFocusTraversal(Vector<Object> vector) {
        vector.add(this.mCopyToViewerButton);
        vector.add(this.mMainDisplayPanel.getVisControl());
        return vector;
    }

    @Override
    protected void constructMenus() {
        BitSet bitSet = new BitSet();
        bitSet.set(MENU_OPTION_FILE);
        bitSet.set(MENU_OPTION_EDIT);
        bitSet.set(MENU_OPTION_HELP);
        super.constructMenus(bitSet);
        JMenu jMenu = this.createCopyToViewerMenu(false);
        this.addItemToMenu(jMenu, "copy_chart_to_viewer");
        this.fileMenu.add(jMenu);
        this.fileMenu.addSeparator();
        this.addItemToMenu(this.fileMenu, "file_close");
        JMenu jMenu2 = new JMenu(ResUtil.getString("copy_object"));
        jMenu2.setMnemonic(ResUtil.getAccessKey("copy_object"));
        this.addItemToMenu(jMenu2, "copy_chart_to_clipboard");
        this.editMenu.add(jMenu2);
        this.addItemToMenu(this.helpMenu, "help_topics");
    }

    @Override
    protected Dimension getItemSize() {
        return new Dimension(this.mMainDisplayPanel.getWidth(), this.mMainDisplayPanel.getHeight());
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() != this) {
            WindowEvent windowEvent2 = new WindowEvent(this, 201);
            this.dispatchEvent(windowEvent2);
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        if (windowEvent.getSource() != this) {
            this.dispose();
        }
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

