/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.ui.awt.VisControl;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.OutputItem;
import com.spss.java_client.core.documents.output.interactive.TCMScenarioAnalysisInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.TCMSequenceDiagramPopupInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.util.TCMUtils;
import com.spss.java_client.core.documents.output.lighttable.JsonTableItem;
import com.spss.java_client.ui.doc_types.output.JsonInteractiveViewerItem;
import com.spss.java_client.ui.interactive.JsonInteractiveFrame;
import com.spss.java_client.ui.interactive.JsonSplitInteractiveFrame;
import com.spss.java_client.ui.interactive.OutputVisPanel;
import com.spss.java_client.ui.interactive.TCMSequenceDiagramPopupInteractiveFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.output.client.table.OutputTable;
import com.spss.output.vis.charting.OutputVisComponent;
import com.spss.output.vis.charting.nativeImpl.util.OutputVisComponentUtil;
import com.spss.uitools.clipboard.AppClipboard;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TCMScenarioAnalysisInteractiveFrame
extends JsonSplitInteractiveFrame
implements ChangeListener {
    private JTabbedPane mTablesPane;
    private OutputTable mScenarioDefinitionOutputTable;
    private JSONObject mScenarioDefinitionTableJSON;
    private JScrollPane mScenarioDefinitionScrollPane;
    private OutputTable mForecastedValuesOutputTable;
    private JSONObject mForecastedValuesTableJSON;
    private JScrollPane mForecastedValuesScrollPane;
    private JRadioButtonMenuItem mShowForecastedValuesMenuItem;
    private JRadioButtonMenuItem mShowScenarioDefinitionMenuItem;

    public TCMScenarioAnalysisInteractiveFrame(JsonInteractiveViewerItem jsonInteractiveViewerItem) {
        super(jsonInteractiveViewerItem);
        this.setTitle(this.mResBundle.getString("IDS_INTERACTIVE_OUTPUT_TITLE") + this.mResBundle.getString("IDS_INTERACTIVE_OUTPUT_TITLE_SEP") + this.mResBundle.getString("IDS_TCM_SCENARIO_ANALYSIS"));
        this.constructGUI();
        this.constructMenus();
        this.setTabTraversalPolicy();
        this.addWindowListener(this);
    }

    @Override
    protected void constructGUI() {
        TCMScenarioAnalysisInteractiveItem tCMScenarioAnalysisInteractiveItem = (TCMScenarioAnalysisInteractiveItem)this.mInteractiveViewerItem.getItem();
        OutputVisComponent outputVisComponent = tCMScenarioAnalysisInteractiveItem.getMainVisComponent();
        this.mMainDisplayPanel = new OutputVisPanel(outputVisComponent);
        this.mVisCompMainInteracitivity = new JsonInteractiveFrame.VisCompMainInteracitivity(this);
        this.mMainDisplayPanel.setFocusable(true);
        JSONObject jSONObject = OutputVisComponentUtil.exportComponentViewAsVisSpec((VisControl)this.mMainDisplayPanel.getVisControl(), (OutputVisComponent)outputVisComponent, (Integer)tCMScenarioAnalysisInteractiveItem.getWidth(), (Integer)tCMScenarioAnalysisInteractiveItem.getHeight());
        this.mMainDisplayPanel.getVisControl().setSpecification(jSONObject);
        this.mTablesPane = new JTabbedPane();
        this.mForecastedValuesTableJSON = tCMScenarioAnalysisInteractiveItem.getForecastedValuesTableJSON();
        this.mForecastedValuesOutputTable = this.createOutputTable(this.mForecastedValuesTableJSON, tCMScenarioAnalysisInteractiveItem.getDataModelJson(), null);
        this.mForecastedValuesScrollPane = new JScrollPane((Component)this.mForecastedValuesOutputTable.getTableComponent());
        this.mTablesPane.add(this.mResBundle.getString("IDS_TCM_SCENARIO_ANALYSIS_FORECASTED_VALUES"), this.mForecastedValuesScrollPane);
        this.mScenarioDefinitionTableJSON = tCMScenarioAnalysisInteractiveItem.getScenarioDefinitionTableJSON();
        this.mScenarioDefinitionOutputTable = this.createOutputTable(this.mScenarioDefinitionTableJSON, tCMScenarioAnalysisInteractiveItem.getDataModelJson(), null);
        this.mScenarioDefinitionScrollPane = new JScrollPane((Component)this.mScenarioDefinitionOutputTable.getTableComponent());
        this.mTablesPane.add(this.mResBundle.getString("IDS_TCM_SCENARIO_ANALYSIS_SCENARIO_DEFINITION"), this.mScenarioDefinitionScrollPane);
        this.mTablesPane.setSelectedIndex(0);
        this.mTablesPane.addChangeListener(this);
        this.createSplitPane(0, this.mMainDisplayPanel, this.mTablesPane);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.constructCopyToViewerButton(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        gridBagConstraints.fill = 1;
        this.add((Component)this.mSplitPane, gridBagConstraints);
    }

    @Override
    protected Vector<Object> addControlsForFocusTraversal(Vector<Object> vector) {
        vector.add(this.mCopyToViewerButton);
        vector.add(this.mMainDisplayPanel.getVisControl());
        vector.add(this.mTablesPane);
        return vector;
    }

    @Override
    protected void constructMenus() {
        super.constructMenus();
        TCMScenarioAnalysisInteractiveItem tCMScenarioAnalysisInteractiveItem = (TCMScenarioAnalysisInteractiveItem)this.mInteractiveViewerItem.getItem();
        JMenu jMenu = this.createCopyToViewerMenu(false);
        this.addItemToMenu(jMenu, "copy_forecasted_values_table_to_viewer");
        this.addItemToMenu(jMenu, "copy_scenario_definition_table_to_viewer");
        this.addItemToMenu(jMenu, "copy_chart_to_viewer");
        this.addItemToMenu(jMenu, "copy_image_to_viewer");
        this.fileMenu.add(jMenu);
        this.fileMenu.addSeparator();
        this.addItemToMenu(this.fileMenu, "print_settings");
        this.fileMenu.addSeparator();
        this.addItemToMenu(this.fileMenu, "file_close");
        JMenu jMenu2 = new JMenu(ResUtil.getString("copy_object"));
        jMenu2.setMnemonic(ResUtil.getAccessKey("copy_object"));
        this.addItemToMenu(jMenu2, "copy_forecasted_values_table_to_clipboard");
        this.addItemToMenu(jMenu2, "copy_scenario_definition_table_to_clipboard");
        this.addItemToMenu(jMenu2, "copy_chart_to_clipboard");
        this.addItemToMenu(jMenu2, "copy_image_to_clipboard");
        this.editMenu.add(jMenu2);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.mShowForecastedValuesMenuItem = this.addRBItemToMenu(this.viewMenu, "view_forecasted_values", buttonGroup);
        this.mShowForecastedValuesMenuItem.setSelected(true);
        this.mShowScenarioDefinitionMenuItem = this.addRBItemToMenu(this.viewMenu, "view_scenario_definition", buttonGroup);
        this.addItemToMenu(this.helpMenu, "help_topics");
    }

    @Override
    protected void addCopyToViewerPopupMenuItems(JPopupMenu jPopupMenu) {
        JMenu jMenu = this.createCopyToViewerMenu(true);
        this.addItemToMenu(jMenu, "copy_forecasted_values_table_to_viewer");
        this.addItemToMenu(jMenu, "copy_scenario_definition_table_to_viewer");
        this.addItemToMenu(jMenu, "copy_chart_to_viewer");
        this.addItemToMenu(jMenu, "copy_image_to_viewer");
        jPopupMenu.add(jMenu);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("copy_forecasted_values_table_to_viewer".equals(actionEvent.getActionCommand())) {
            this.doCopyForecastedValuesTableToViewer();
        } else if ("copy_scenario_definition_table_to_viewer".equals(actionEvent.getActionCommand())) {
            this.doCopyScenarioDefinitionTableToViewer();
        } else if ("view_forecasted_values".equals(actionEvent.getActionCommand())) {
            this.mTablesPane.setSelectedIndex(0);
            this.doChangeActiveTable(true);
        } else if ("view_scenario_definition".equals(actionEvent.getActionCommand())) {
            this.mTablesPane.setSelectedIndex(1);
            this.doChangeActiveTable(false);
        } else if ("copy_forecasted_values_table_to_clipboard".equals(actionEvent.getActionCommand())) {
            this.doEditCopyToClipBoard(true);
        } else if ("copy_scenario_definition_table_to_clipboard".equals(actionEvent.getActionCommand())) {
            this.doEditCopyToClipBoard(false);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    @Override
    public void doCopyChartToViewer() {
        String string = ((TCMScenarioAnalysisInteractiveItem)this.mInteractiveViewerItem.getItem()).getDescription();
        ((TCMScenarioAnalysisInteractiveItem)this.mInteractiveViewerItem.getItem()).setDescription(this.mResBundle.getString("IDS_TCM_IMPACT_DIAGRAM") + " " + this.mResBundle.getString("IDS_TCM_CHART"));
        this.copyJsonChartItemIntoViewer(true);
        ((TCMScenarioAnalysisInteractiveItem)this.mInteractiveViewerItem.getItem()).setDescription(string);
    }

    public void doEditCopyToClipBoard(boolean bl) {
        TCMScenarioAnalysisInteractiveItem tCMScenarioAnalysisInteractiveItem = (TCMScenarioAnalysisInteractiveItem)this.mInteractiveViewerItem.getItem();
        AppClipboard appClipboard = AppClipboard.getAppClipboard();
        try {
            BufferedImage bufferedImage;
            BufferedImage bufferedImage2 = bufferedImage = bl ? tCMScenarioAnalysisInteractiveItem.getForecastedValuesJSONTableItem().render() : tCMScenarioAnalysisInteractiveItem.getScenarioDefinitionJSONTableItem().render();
            if (bufferedImage != null) {
                appClipboard.addClipboardData(AppClipboard.IMAGE_FLAVOR, (Object)bufferedImage, true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doCopyForecastedValuesTableToViewer() {
        this.copyForecastedValuesTableIntoViewer(false);
    }

    protected void copyForecastedValuesTableIntoViewer(boolean bl) {
        TCMScenarioAnalysisInteractiveItem tCMScenarioAnalysisInteractiveItem = (TCMScenarioAnalysisInteractiveItem)this.mInteractiveViewerItem.getItem();
        JsonTableItem jsonTableItem = tCMScenarioAnalysisInteractiveItem.getForecastedValuesJSONTableItem();
        jsonTableItem.setDescription(tCMScenarioAnalysisInteractiveItem.getDescription() + " " + this.mResBundle.getString("IDS_TCM_OUTLIER_ROOT_CAUSE_OUTLIERS_TABLE"));
        this.insertItemIntoViewer((OutputItem)jsonTableItem);
    }

    public void doCopyScenarioDefinitionTableToViewer() {
        this.copyScenarioDefinitionTableIntoViewer(false);
    }

    protected void copyScenarioDefinitionTableIntoViewer(boolean bl) {
        TCMScenarioAnalysisInteractiveItem tCMScenarioAnalysisInteractiveItem = (TCMScenarioAnalysisInteractiveItem)this.mInteractiveViewerItem.getItem();
        JsonTableItem jsonTableItem = tCMScenarioAnalysisInteractiveItem.getScenarioDefinitionJSONTableItem();
        jsonTableItem.setDescription(tCMScenarioAnalysisInteractiveItem.getDescription() + " " + this.mResBundle.getString("IDS_TCM_OUTLIER_ROOT_CAUSE_OUTLIERS_TABLE"));
        this.insertItemIntoViewer((OutputItem)jsonTableItem);
    }

    private void doChangeActiveTable(boolean bl) {
        TCMScenarioAnalysisInteractiveItem tCMScenarioAnalysisInteractiveItem = (TCMScenarioAnalysisInteractiveItem)this.mInteractiveViewerItem.getItem();
        this.mShowForecastedValuesMenuItem.setSelected(bl);
        tCMScenarioAnalysisInteractiveItem.setForecastedTableSelected(bl);
    }

    @Override
    protected OutputVisPanel getZoomAndPanOutputVisPanel() {
        return this.mMainDisplayPanel;
    }

    @Override
    protected VisControl getZoomAndPanVisControl() {
        return this.mMainDisplayPanel.getVisControl();
    }

    @Override
    protected Dimension getItemSize() {
        Dimension dimension = new Dimension(this.mMainDisplayPanel.getWidth(), this.mMainDisplayPanel.getHeight() + this.mTablesPane.getHeight());
        return dimension;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.mTablesPane) {
            this.doChangeActiveTable(this.mTablesPane.getSelectedIndex() == 0);
        }
    }

    @Override
    public void processVisCompMainMouseClick(JSONObject jSONObject, boolean bl) {
        TCMScenarioAnalysisInteractiveItem tCMScenarioAnalysisInteractiveItem = (TCMScenarioAnalysisInteractiveItem)this.mInteractiveViewerItem.getItem();
        Integer n = (Integer)jSONObject.get((Object)"seriesIndex");
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"seriesName");
        String string = TCMUtils.extractSeriesNameFromObject((JSONObject)jSONObject2, (JSONObject)tCMScenarioAnalysisInteractiveItem.getDataModelJson(), (boolean)true);
        JSONObject jSONObject3 = tCMScenarioAnalysisInteractiveItem.getScenaroAnalysisLine();
        if (jSONObject3 != null) {
            try {
                String string2 = "{";
                string2 = string2 + "\"seriesName\": " + jSONObject2.toString() + ",";
                string2 = string2 + "\"seriesIndex\": " + n;
                string2 = string2 + "}";
                final JSONObject jSONObject4 = JSONObject.parse((String)string2);
                final TCMSequenceDiagramPopupInteractiveItem tCMSequenceDiagramPopupInteractiveItem = new TCMSequenceDiagramPopupInteractiveItem(string);
                tCMSequenceDiagramPopupInteractiveItem.setDataModelJSON(tCMScenarioAnalysisInteractiveItem.getDataModelJson());
                tCMSequenceDiagramPopupInteractiveItem.setParentItem((IOutputItem)this.mInteractiveViewerItem.getItem());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                jSONObject3.serialize((OutputStream)byteArrayOutputStream);
                tCMSequenceDiagramPopupInteractiveItem.setVDPData(ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
                JsonInteractiveViewerItem jsonInteractiveViewerItem = new JsonInteractiveViewerItem((IOutputItem)tCMSequenceDiagramPopupInteractiveItem);
                TCMSequenceDiagramPopupInteractiveFrame tCMSequenceDiagramPopupInteractiveFrame = new TCMSequenceDiagramPopupInteractiveFrame(jsonInteractiveViewerItem, this);
                tCMSequenceDiagramPopupInteractiveFrame.setVisible(true);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        tCMSequenceDiagramPopupInteractiveItem.performActionOnMain("selectSeries", jSONObject4);
                    }
                });
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

