/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive;

import com.ibm.json.java.JSONObject;
import com.spss.java_client.core.documents.output.interactive.TCMOutlierDistributionInteractiveItem;
import com.spss.java_client.ui.doc_types.output.JsonInteractiveViewerItem;
import com.spss.java_client.ui.interactive.JsonInteractiveFrame;
import com.spss.java_client.ui.interactive.JsonSplitInteractiveFrame;
import com.spss.java_client.ui.interactive.OutputVisPanel;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.output.vis.charting.OutputVisComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class TCMOutlierDistributionInteractiveFrame
extends JsonSplitInteractiveFrame
implements ItemListener {
    private String mRangeText;

    public TCMOutlierDistributionInteractiveFrame(JsonInteractiveViewerItem jsonInteractiveViewerItem) {
        super(jsonInteractiveViewerItem);
        this.setTitle(this.mResBundle.getString("IDS_INTERACTIVE_OUTPUT_TITLE") + this.mResBundle.getString("IDS_INTERACTIVE_OUTPUT_TITLE_SEP") + this.mResBundle.getString("IDS_TCM_OUTLIER_DISTRIBUTION"));
        TCMOutlierDistributionInteractiveItem tCMOutlierDistributionInteractiveItem = (TCMOutlierDistributionInteractiveItem)this.mInteractiveViewerItem.getItem();
        if (tCMOutlierDistributionInteractiveItem.isRenderAsMessage()) {
            this.constructMessageGUI();
            this.constructMessageMenus();
        } else {
            this.constructGUI();
            this.constructMenus();
            this.addWindowListener(this);
        }
        this.setTabTraversalPolicy();
    }

    @Override
    protected void constructGUI() {
        TCMOutlierDistributionInteractiveItem tCMOutlierDistributionInteractiveItem = (TCMOutlierDistributionInteractiveItem)this.mInteractiveViewerItem.getItem();
        OutputVisComponent outputVisComponent = tCMOutlierDistributionInteractiveItem.getMainVisComponent();
        this.mMainDisplayPanel = new OutputVisPanel(outputVisComponent);
        this.mVisCompMainInteracitivity = new JsonInteractiveFrame.VisCompMainInteracitivity(this);
        OutputVisComponent outputVisComponent2 = tCMOutlierDistributionInteractiveItem.getAuxiliaryVisComponent();
        this.mAuxDisplayPanel = new OutputVisPanel(outputVisComponent2);
        this.createSplitPane(0, this.mMainDisplayPanel, this.mAuxDisplayPanel);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.constructCopyToViewerButton(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        gridBagConstraints.fill = 1;
        this.add((Component)this.mSplitPane, gridBagConstraints);
    }

    @Override
    protected Vector<Object> addControlsForFocusTraversal(Vector<Object> vector) {
        vector.add(this.mCopyToViewerButton);
        vector.add(this.mMainDisplayPanel.getVisControl());
        vector.add(this.mAuxDisplayPanel.getVisControl());
        return vector;
    }

    @Override
    protected void constructMenus() {
        BitSet bitSet = new BitSet();
        bitSet.set(MENU_OPTION_FILE);
        bitSet.set(MENU_OPTION_EDIT);
        bitSet.set(MENU_OPTION_HELP);
        super.constructMenus(bitSet);
        JMenu jMenu = this.createCopyToViewerMenu(false);
        this.addItemToMenu(jMenu, "copy_chart_histogram_to_viewer");
        this.addItemToMenu(jMenu, "copy_chart_dotplot_to_viewer");
        this.addItemToMenu(jMenu, "copy_image_to_viewer");
        this.fileMenu.add(jMenu);
        this.fileMenu.addSeparator();
        this.addItemToMenu(this.fileMenu, "print_settings");
        this.fileMenu.addSeparator();
        this.addItemToMenu(this.fileMenu, "file_close");
        JMenu jMenu2 = new JMenu(ResUtil.getString("copy_object"));
        jMenu2.setMnemonic(ResUtil.getAccessKey("copy_object"));
        this.addItemToMenu(jMenu2, "copy_chart_histogram_to_clipboard");
        this.addItemToMenu(jMenu2, "copy_chart_dotplot_to_clipboard");
        this.addItemToMenu(jMenu2, "copy_image_to_clipboard");
        this.editMenu.add(jMenu2);
        this.addItemToMenu(this.helpMenu, "help_topics");
    }

    @Override
    protected void addCopyToViewerPopupMenuItems(JPopupMenu jPopupMenu) {
        JMenu jMenu = this.createCopyToViewerMenu(true);
        this.addItemToMenu(jMenu, "copy_chart_histogram_to_viewer");
        this.addItemToMenu(jMenu, "copy_chart_dotplot_to_viewer");
        this.addItemToMenu(jMenu, "copy_image_to_viewer");
        jPopupMenu.add(jMenu);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    @Override
    protected Dimension getItemSize() {
        Dimension dimension = this.mInteractiveViewerItem.getItem().isRenderAsMessage() ? new Dimension(this.mInteractiveViewerItem.getWidth(), this.mInteractiveViewerItem.getHeight()) : new Dimension(this.mMainDisplayPanel.getWidth(), this.mMainDisplayPanel.getHeight() + this.mAuxDisplayPanel.getHeight());
        return dimension;
    }

    @Override
    public void doCopyChartHistogramToViewer() {
        String string = ((TCMOutlierDistributionInteractiveItem)this.mInteractiveViewerItem.getItem()).getDescription();
        ((TCMOutlierDistributionInteractiveItem)this.mInteractiveViewerItem.getItem()).setDescription(this.mResBundle.getString("IDS_TCM_OUTLIER_DISTRIBUTION") + " " + this.mResBundle.getString("IDS_TCM_HISTOGRAM"));
        this.copyJsonChartItemIntoViewer(true);
        ((TCMOutlierDistributionInteractiveItem)this.mInteractiveViewerItem.getItem()).setDescription(string);
    }

    @Override
    public void doCopyChartDotplotToViewer() {
        String string = ((TCMOutlierDistributionInteractiveItem)this.mInteractiveViewerItem.getItem()).getDescription();
        if (this.mRangeText == null) {
            ((TCMOutlierDistributionInteractiveItem)this.mInteractiveViewerItem.getItem()).setDescription(this.mResBundle.getString("IDS_TCM_OUTLIER_DISTRIBUTION") + " " + this.mResBundle.getString("IDS_TCM_DOTPLOT"));
        } else {
            ((TCMOutlierDistributionInteractiveItem)this.mInteractiveViewerItem.getItem()).setDescription(this.mResBundle.getString("IDS_TCM_OUTLIER_DISTRIBUTION") + " " + this.mResBundle.getString("IDS_TCM_DOTPLOT") + " " + "(" + this.mRangeText + ")");
        }
        this.copyJsonChartItemIntoViewer(false);
        ((TCMOutlierDistributionInteractiveItem)this.mInteractiveViewerItem.getItem()).setDescription(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("copy_chart_histogram_to_viewer".equals(actionEvent.getActionCommand())) {
            this.doCopyChartHistogramToViewer();
        } else if ("copy_chart_dotplot_to_viewer".equals(actionEvent.getActionCommand())) {
            this.doCopyChartDotplotToViewer();
        } else if ("copy_image_to_viewer".equals(actionEvent.getActionCommand())) {
            this.doCopyImageToViewer();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    @Override
    public void processVisCompMainMouseClick(JSONObject jSONObject, boolean bl) {
        String string = (String)jSONObject.get((Object)"selectBar");
        if (string != null) {
            try {
                String string2 = "{";
                string2 = string2 + "\"setRange\": \"" + string + "\"";
                string2 = string2 + "}";
                JSONObject jSONObject2 = JSONObject.parse((String)string2);
                ((TCMOutlierDistributionInteractiveItem)this.mInteractiveViewerItem.getItem()).performActionOnAux("timeRangeActions", jSONObject2);
                this.setRangeText(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            string = (String)jSONObject.get((Object)"cancelSelectBar");
            this.mRangeText = null;
            try {
                String string3 = "{";
                string3 = string3 + "\"cancelSetRange\": \"null\"";
                string3 = string3 + "}";
                JSONObject jSONObject3 = JSONObject.parse((String)string3);
                ((TCMOutlierDistributionInteractiveItem)this.mInteractiveViewerItem.getItem()).performActionOnAux("timeRangeActions", jSONObject3);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void setRangeText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string.split("~");
        if (stringArray.length == 2) {
            try {
                Double d = Double.valueOf(stringArray[0]);
                Date date = new Date(d.longValue() * 1000L);
                Double d2 = Double.valueOf(stringArray[1]);
                Date date2 = new Date(d2.longValue() * 1000L);
                DateFormat dateFormat = DateFormat.getDateInstance(3);
                ((SimpleDateFormat)dateFormat).applyPattern("YYYY-MM-dd");
                stringBuilder.append(dateFormat.format(date));
                stringBuilder.append(" - ");
                stringBuilder.append(dateFormat.format(date2));
            }
            catch (NumberFormatException numberFormatException) {
                stringBuilder.append(stringArray[0]);
                stringBuilder.append(" - ");
                stringBuilder.append(stringArray[1]);
            }
        }
        this.mRangeText = stringBuilder.length() > 0 ? stringBuilder.toString() : string;
    }
}

