/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.ui.awt.VisControl;
import com.spss.java_client.core.comp_util.ASLExecutor;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.OutputItem;
import com.spss.java_client.core.documents.output.chart.JsonChartItem;
import com.spss.java_client.core.documents.output.header.HeaderItem;
import com.spss.java_client.core.documents.output.interactive.JsonInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.TCMImpactDiagramInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.TCMModelSystemInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.util.TCMUtils;
import com.spss.java_client.core.documents.output.lighttable.JsonTableItem;
import com.spss.java_client.core.documents.output.rgraph.ImageItem;
import com.spss.java_client.ui.controls.AutoSearchComboBox;
import com.spss.java_client.ui.controls.SpssProgressDlg;
import com.spss.java_client.ui.doc_types.output.JsonInteractiveViewerItem;
import com.spss.java_client.ui.interactive.JsonInteractiveFrame;
import com.spss.java_client.ui.interactive.JsonSplitInteractiveFrame;
import com.spss.java_client.ui.interactive.OutputVisPanel;
import com.spss.java_client.ui.interactive.TCMImpactDiagramInteractiveFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.output.client.table.OutputTable;
import com.spss.output.vis.charting.OutputVisComponent;
import com.spss.output.vis.charting.nativeImpl.util.OutputVisComponentUtil;
import com.spss.shared.export.table_export.TableImager;
import com.spss.uitools.clipboard.AppClipboard;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TCMModelSystemInteractiveFrame
extends JsonSplitInteractiveFrame
implements ItemListener,
ChangeListener {
    private static int ID_HIGHLIGHT_TOP_MODELS = 0;
    private static int ID_HIGHLIGHT_SINGLE_SERIES = 1;
    private static int ID_HIGHLIGHT_ALL_SERIES = 2;
    private static int ID_HIGHLIGHT_MODELS_WITH_NO_INPUTS = 3;
    private static String IDS_HIGHLIGHT_TOP_MODELS = "Top";
    private static String IDS_HIGHLIGHT_SINGLE_SERIES = "Single";
    private static String IDS_HIGHLIGHT_ALL_SERIES = "All";
    private static String IDS_HIGHLIGHT_MODELS_WITH_NO_INPUTS = "AR";
    private JComboBox mHightlightSeriesComboBox;
    private AutoSearchComboBox mSeriesOfInterestComboBox;
    private JLabel mSeriesNameLabel;
    List<String> mSeriesOfInterestCBEntries;
    private JTextField mSigValueTextField;
    private JTabbedPane mTablesPane;
    private JScrollPane mModelFitStatisticsScrollPane;
    private JScrollPane mSeriesWithOutliersScrollPane;
    private OutputTable mModelFitStatisticsTable;
    private OutputTable mSeriesWithOutliersTable;
    private JMenuItem mViewImpactDiagramSingleSeriesItem;
    private JMenuItem mViewImpactDiagramSelectedSeriesItem;
    private JMenuItem mHighlightRelationsForSeriesItem;
    private JMenuItem mViewModelFitStatisticsTableItem;
    private JMenuItem mViewSeriesWithOutliersTableItem;
    private JMenuItem mCopyModelFitStatisticsTableToViewerItem;
    private JMenuItem mCopyModelFitStatisticsTableToClipboardItem;
    private JMenuItem mCopySeriesWithOutliersTableToViewerItem;
    private JMenuItem mCopySeriesWithOutliersTableToClipboardItem;
    private ArrayList<String> mSelectedSeriesNames = new ArrayList();
    private JPopupMenu mModelSystemContextMenu;
    private ASLExecutor aslExecutor = null;
    protected JRadioButtonMenuItem mHightlightTopModelsMenuItem;
    protected JRadioButtonMenuItem mHightlightSingleSeriesMenuItem;
    protected JRadioButtonMenuItem mHightlightAllSeriesMenuItem;
    protected JRadioButtonMenuItem mHightlightModelsWithNoInputsMenuItem;

    public TCMModelSystemInteractiveFrame(JsonInteractiveViewerItem jsonInteractiveViewerItem) {
        super(jsonInteractiveViewerItem);
        this.setTitle(this.mResBundle.getString("IDS_INTERACTIVE_OUTPUT_TITLE") + this.mResBundle.getString("IDS_INTERACTIVE_OUTPUT_TITLE_SEP") + this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM"));
        this.mModelSystemContextMenu = null;
        this.constructGUI();
        this.constructMenus();
        this.setTabTraversalPolicy();
        this.addWindowListener(this);
    }

    @Override
    protected void constructGUI() {
        Object object;
        JComponent jComponent;
        final TCMModelSystemInteractiveItem tCMModelSystemInteractiveItem = (TCMModelSystemInteractiveItem)this.mInteractiveViewerItem.getItem();
        OutputVisComponent outputVisComponent = tCMModelSystemInteractiveItem.getMainVisComponent();
        this.mMainDisplayPanel = new OutputVisPanel(outputVisComponent);
        this.mVisCompMainInteracitivity = new JsonInteractiveFrame.VisCompMainInteracitivity(this);
        this.mMainDisplayPanel.getVisControl().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    if (TCMModelSystemInteractiveFrame.this.mModelSystemContextMenu == null) {
                        TCMModelSystemInteractiveFrame.this.mModelSystemContextMenu = new JPopupMenu();
                        TCMModelSystemInteractiveFrame.this.mViewImpactDiagramSelectedSeriesItem = new JMenuItem(ResUtil.getString("view_impact_diagram_selected_series"));
                        TCMModelSystemInteractiveFrame.this.mViewImpactDiagramSelectedSeriesItem.setMnemonic(ResUtil.getAccessKey("view_impact_diagram_selected_series"));
                        TCMModelSystemInteractiveFrame.this.mViewImpactDiagramSelectedSeriesItem.setActionCommand("view_impact_diagram_selected_series");
                        TCMModelSystemInteractiveFrame.this.mViewImpactDiagramSelectedSeriesItem.addActionListener(TCMModelSystemInteractiveFrame.this);
                        TCMModelSystemInteractiveFrame.this.mViewImpactDiagramSelectedSeriesItem.setEnabled(TCMModelSystemInteractiveFrame.this.mSelectedSeriesNames.size() > 0 && TCMModelSystemInteractiveFrame.this.canExecuteASL());
                        TCMModelSystemInteractiveFrame.this.mModelSystemContextMenu.add(TCMModelSystemInteractiveFrame.this.mViewImpactDiagramSelectedSeriesItem);
                        TCMModelSystemInteractiveFrame.this.mHighlightRelationsForSeriesItem = new JMenuItem(ResUtil.getString("view_relations_for_series"));
                        TCMModelSystemInteractiveFrame.this.mHighlightRelationsForSeriesItem.setMnemonic(ResUtil.getAccessKey("view_relations_for_series"));
                        TCMModelSystemInteractiveFrame.this.mHighlightRelationsForSeriesItem.setActionCommand("view_relations_for_series");
                        TCMModelSystemInteractiveFrame.this.mHighlightRelationsForSeriesItem.addActionListener(TCMModelSystemInteractiveFrame.this);
                        TCMModelSystemInteractiveFrame.this.mHighlightRelationsForSeriesItem.setEnabled(TCMModelSystemInteractiveFrame.this.mSelectedSeriesNames.size() == 1);
                        TCMModelSystemInteractiveFrame.this.mModelSystemContextMenu.add(TCMModelSystemInteractiveFrame.this.mHighlightRelationsForSeriesItem);
                    }
                    if (TCMModelSystemInteractiveFrame.this.mModelSystemContextMenu != null && TCMModelSystemInteractiveFrame.this.mModelSystemContextMenu.getComponentCount() > 0) {
                        mouseEvent.consume();
                        TCMModelSystemInteractiveFrame.this.mModelSystemContextMenu.show((Component)TCMModelSystemInteractiveFrame.this.mMainDisplayPanel.getVisControl(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
        this.mTablesPane = new JTabbedPane();
        JSONObject jSONObject = tCMModelSystemInteractiveItem.getSelectedHighlightActionParams();
        int n = this.highlightActionParamsToIndex(jSONObject);
        if (!tCMModelSystemInteractiveItem.renderModelFitStatisticsTableAsMessage() && !tCMModelSystemInteractiveItem.getModelFitStatisticsTableItem().isEmpty() && n != ID_HIGHLIGHT_MODELS_WITH_NO_INPUTS) {
            jComponent = null;
            if (n == ID_HIGHLIGHT_TOP_MODELS || n == ID_HIGHLIGHT_SINGLE_SERIES) {
                if (n == ID_HIGHLIGHT_TOP_MODELS) {
                    object = TableImager.getProperInputStream((byte[])tCMModelSystemInteractiveItem.getMFSTopModelsTableFilterData().array());
                    try {
                        jComponent = JSONObject.parse((InputStream)object);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                } else {
                    jComponent = tCMModelSystemInteractiveItem.createTableFilterJsonForSeriesName(tCMModelSystemInteractiveItem.getSingleSeriesName(), "IDS_TCM_OVERALL_MODEL_SYSTEM_FIT_STATISTICS_FOR_SINGLE_SERIES");
                }
            }
            this.createModelFitStatisticsScrolPane((JSONObject)jComponent);
            this.mTablesPane.add(this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM_MODEL_FIT_STATISTICS"), this.mModelFitStatisticsScrollPane);
        } else {
            jComponent = this.getNoMFSTablesComponent();
            this.mTablesPane.add(this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM_MODEL_FIT_STATISTICS"), jComponent);
        }
        if (!tCMModelSystemInteractiveItem.renderSeriesWithOutliersTableAsMessage() && !tCMModelSystemInteractiveItem.getModelFitStatisticsTableItem().isEmpty()) {
            jComponent = null;
            if (n == ID_HIGHLIGHT_TOP_MODELS || n == ID_HIGHLIGHT_SINGLE_SERIES) {
                if (n == ID_HIGHLIGHT_TOP_MODELS) {
                    object = TableImager.getProperInputStream((byte[])tCMModelSystemInteractiveItem.getSWOTopModelsTableFilterData().array());
                    try {
                        jComponent = JSONObject.parse((InputStream)object);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                } else {
                    jComponent = tCMModelSystemInteractiveItem.createTableFilterJsonForSeriesName(tCMModelSystemInteractiveItem.getSingleSeriesName(), "IDS_TCM_OVERALL_MODEL_SYSTEM_SERIES_WITH_OUTLIERS");
                }
            }
            this.createSeriesWithOutliersScrolPane((JSONObject)jComponent);
            this.mTablesPane.add(this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM_SERIES_WITH_OUTLIERS"), this.mSeriesWithOutliersScrollPane);
        } else {
            jComponent = this.getNoSWOTablesComponent();
            this.mTablesPane.add(this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM_SERIES_WITH_OUTLIERS"), jComponent);
        }
        int n2 = tCMModelSystemInteractiveItem.getSelectedTableItem() == tCMModelSystemInteractiveItem.getModelFitStatisticsTableItem() ? 0 : 1;
        this.mTablesPane.setSelectedIndex(n2);
        this.mTablesPane.addChangeListener(this);
        this.createSplitPane(1, this.mMainDisplayPanel, this.mTablesPane);
        object = new GridBagLayout();
        this.setLayout((LayoutManager)object);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.constructCopyToViewerButton(), gridBagConstraints);
        JLabel jLabel = new JLabel(this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM_RELATIONS"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 0);
        this.add((Component)jLabel, gridBagConstraints);
        Vector<String> vector = new Vector<String>();
        vector.add(this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM_TOP_MODELS"));
        vector.add(this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM_SINGLE_SERIES"));
        vector.add(this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM_ALL_SERIES"));
        vector.add(this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM_NO_INPUTS"));
        this.mHightlightSeriesComboBox = new JComboBox(vector);
        this.mHightlightSeriesComboBox.setPreferredSize(new Dimension(160, 24));
        this.mHightlightSeriesComboBox.setMinimumSize(new Dimension(160, 24));
        this.mHightlightSeriesComboBox.setSelectedIndex(n);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.add((Component)this.mHightlightSeriesComboBox, gridBagConstraints);
        this.mSeriesNameLabel = new JLabel(this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM_SERIES_NAME"));
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.add((Component)this.mSeriesNameLabel, gridBagConstraints);
        this.mSeriesOfInterestCBEntries = tCMModelSystemInteractiveItem.getSeriesNames();
        this.mSeriesOfInterestComboBox = this.createAutoSearchSeriesComboBox(this.mSeriesOfInterestCBEntries);
        this.mSeriesNameLabel.setEnabled(n == ID_HIGHLIGHT_SINGLE_SERIES);
        this.mSeriesOfInterestComboBox.setEnabled(n == ID_HIGHLIGHT_SINGLE_SERIES);
        String string = tCMModelSystemInteractiveItem.getSingleSeriesName();
        if (string != null && string.length() > 0) {
            this.mSeriesOfInterestComboBox.setSelectedItem(string);
        }
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(2, 4, 4, 0);
        this.add((Component)this.mSeriesOfInterestComboBox, gridBagConstraints);
        JLabel jLabel2 = new JLabel(this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM_HIDE_LINKS"));
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 0);
        this.add((Component)jLabel2, gridBagConstraints);
        this.mSigValueTextField = new JTextField();
        this.mSigValueTextField.setPreferredSize(new Dimension(40, 24));
        this.mSigValueTextField.setMinimumSize(new Dimension(40, 24));
        this.mSigValueTextField.setText(tCMModelSystemInteractiveItem.getSigValue());
        this.mSigValueTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.validate();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.validate();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.validate();
            }

            public void validate() {
                try {
                    Double d = new Double(TCMModelSystemInteractiveFrame.this.mSigValueTextField.getText());
                    tCMModelSystemInteractiveItem.setSigValue(TCMModelSystemInteractiveFrame.this.mSigValueTextField.getText());
                    tCMModelSystemInteractiveItem.performHideLinksAction();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.add((Component)this.mSigValueTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        gridBagConstraints.fill = 1;
        this.add((Component)this.mSplitPane, gridBagConstraints);
        this.mHightlightSeriesComboBox.addItemListener(this);
        this.mSeriesOfInterestComboBox.addItemListener(this);
    }

    @Override
    protected Vector<Object> addControlsForFocusTraversal(Vector<Object> vector) {
        vector.add(this.mCopyToViewerButton);
        vector.add(this.mHightlightSeriesComboBox);
        vector.add(this.mSeriesOfInterestComboBox);
        vector.add(this.mSigValueTextField);
        vector.add(this.mMainDisplayPanel.getVisControl());
        vector.add(this.mTablesPane);
        return vector;
    }

    private JComponent getNoMFSTablesComponent() {
        JTextField jTextField = new JTextField();
        jTextField.setText(this.mResBundle.getString("IDS_TCM_NO_MODEL_FIT_STATISTICS_WARNING"));
        jTextField.setEditable(false);
        jTextField.setHorizontalAlignment(0);
        return jTextField;
    }

    private JComponent getNoSWOTablesComponent() {
        JTextField jTextField = new JTextField();
        jTextField.setText(this.mResBundle.getString("IDS_TCM_NO_OUTLIERS_WARNING"));
        jTextField.setEditable(false);
        jTextField.setHorizontalAlignment(0);
        return jTextField;
    }

    private void createModelFitStatisticsScrolPane(JSONObject jSONObject) {
        TCMModelSystemInteractiveItem tCMModelSystemInteractiveItem = (TCMModelSystemInteractiveItem)this.mInteractiveViewerItem.getItem();
        this.mModelFitStatisticsTable = this.createOutputTable(tCMModelSystemInteractiveItem.getModelFitStatisticsTableJson(), tCMModelSystemInteractiveItem.getDataModelJson(), jSONObject);
        this.setInteractiveTableComp(this.mModelFitStatisticsTable, true, false);
        this.mModelFitStatisticsScrollPane = new JScrollPane((Component)this.mModelFitStatisticsTable.getTableComponent());
    }

    private void createSeriesWithOutliersScrolPane(JSONObject jSONObject) {
        TCMModelSystemInteractiveItem tCMModelSystemInteractiveItem = (TCMModelSystemInteractiveItem)this.mInteractiveViewerItem.getItem();
        this.mSeriesWithOutliersTable = this.createOutputTable(tCMModelSystemInteractiveItem.getSeriesWithOutliersTableJson(), tCMModelSystemInteractiveItem.getDataModelJson(), jSONObject);
        this.setInteractiveTableComp(this.mSeriesWithOutliersTable, true, false);
        this.mSeriesWithOutliersScrollPane = new JScrollPane((Component)this.mSeriesWithOutliersTable.getTableComponent());
    }

    @Override
    protected void constructMenus() {
        super.constructMenus();
        TCMModelSystemInteractiveItem tCMModelSystemInteractiveItem = (TCMModelSystemInteractiveItem)this.mInteractiveViewerItem.getItem();
        JMenu jMenu = this.createCopyToViewerMenu(false);
        this.addItemToMenu(jMenu, "copy_chart_to_viewer");
        this.mCopyModelFitStatisticsTableToViewerItem = this.addItemToMenu(jMenu, "copy_fit_statistics_table_to_viewer");
        this.mCopySeriesWithOutliersTableToViewerItem = this.addItemToMenu(jMenu, "copy_series_with_outliers_table_to_viewer");
        this.addItemToMenu(jMenu, "copy_image_to_viewer");
        this.fileMenu.add(jMenu);
        this.fileMenu.addSeparator();
        this.addItemToMenu(this.fileMenu, "print_settings");
        this.fileMenu.addSeparator();
        this.addItemToMenu(this.fileMenu, "file_close");
        JMenu jMenu2 = new JMenu(ResUtil.getString("copy_object"));
        jMenu2.setMnemonic(ResUtil.getAccessKey("copy_object"));
        this.addItemToMenu(jMenu2, "copy_chart_to_clipboard");
        this.mCopyModelFitStatisticsTableToClipboardItem = this.addItemToMenu(jMenu2, "copy_fit_statistics_table_to_clipboard");
        this.mCopySeriesWithOutliersTableToClipboardItem = this.addItemToMenu(jMenu2, "copy_series_with_outliers_table_to_clipboard");
        this.addItemToMenu(jMenu2, "copy_image_to_clipboard");
        this.editMenu.add(jMenu2);
        JMenu jMenu3 = new JMenu(ResUtil.getString("view_highlight"));
        jMenu3.setMnemonic(ResUtil.getAccessKey("view_highlight"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.mHightlightTopModelsMenuItem = this.addRBItemToMenu(jMenu3, "view_top_models", buttonGroup);
        this.mHightlightSingleSeriesMenuItem = this.addRBItemToMenu(jMenu3, "view_single_series", buttonGroup);
        this.mHightlightAllSeriesMenuItem = this.addRBItemToMenu(jMenu3, "view_all_series", buttonGroup);
        this.mHightlightModelsWithNoInputsMenuItem = this.addRBItemToMenu(jMenu3, "view_models_with_no_inputs", buttonGroup);
        this.viewMenu.add(jMenu3);
        this.mViewImpactDiagramSingleSeriesItem = this.addItemToMenu(this.viewMenu, "view_impact_diagram_single_series");
        this.selectHightlightRelationsMenuItem(this.mHightlightSeriesComboBox.getSelectedIndex());
        this.viewMenu.addSeparator();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.mViewModelFitStatisticsTableItem = this.addRBItemToMenu(this.viewMenu, "view_model_fit_statistics", buttonGroup2);
        this.mViewSeriesWithOutliersTableItem = this.addRBItemToMenu(this.viewMenu, "view_series_with_outliers", buttonGroup2);
        this.mViewModelFitStatisticsTableItem.setSelected(tCMModelSystemInteractiveItem.getSelectedTableItem() == tCMModelSystemInteractiveItem.getModelFitStatisticsTableItem());
        this.mViewSeriesWithOutliersTableItem.setSelected(tCMModelSystemInteractiveItem.getSelectedTableItem() != tCMModelSystemInteractiveItem.getModelFitStatisticsTableItem());
        this.addItemToMenu(this.helpMenu, "help_topics");
        this.enableMenuItems();
    }

    @Override
    protected void addCopyToViewerPopupMenuItems(JPopupMenu jPopupMenu) {
        TCMModelSystemInteractiveItem tCMModelSystemInteractiveItem = (TCMModelSystemInteractiveItem)this.mInteractiveViewerItem.getItem();
        JSONObject jSONObject = tCMModelSystemInteractiveItem.getSelectedHighlightActionParams();
        int n = this.highlightActionParamsToIndex(jSONObject);
        JMenu jMenu = this.createCopyToViewerMenu(true);
        this.addItemToMenu(jMenu, "copy_chart_to_viewer");
        JMenuItem jMenuItem = this.addItemToMenu(jMenu, "copy_fit_statistics_table_to_viewer");
        jMenuItem.setEnabled(!tCMModelSystemInteractiveItem.renderModelFitStatisticsTableAsMessage() && n != ID_HIGHLIGHT_MODELS_WITH_NO_INPUTS);
        JMenuItem jMenuItem2 = this.addItemToMenu(jMenu, "copy_series_with_outliers_table_to_viewer");
        jMenuItem2.setEnabled(!tCMModelSystemInteractiveItem.renderSeriesWithOutliersTableAsMessage());
        this.addItemToMenu(jMenu, "copy_image_to_viewer");
        jPopupMenu.add(jMenu);
    }

    @Override
    protected String getDescriptionForSelectedDisplay() {
        TCMModelSystemInteractiveItem tCMModelSystemInteractiveItem = (TCMModelSystemInteractiveItem)this.mInteractiveViewerItem.getItem();
        String string = tCMModelSystemInteractiveItem.getHighlightTypeString();
        return string;
    }

    @Override
    public void doCopyImageToViewer() {
        BufferedImage bufferedImage = this.mInteractiveViewerItem.getItem().getImage();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "jpg", byteArrayOutputStream);
            ImageItem imageItem = new ImageItem();
            imageItem.setVDPData(ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            imageItem.setDescription(this.getDescriptionForSelectedDisplay());
            String string = this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM") + " " + this.mResBundle.getString("IDS_TCM_IMAGE");
            HeaderItem headerItem = this.getParentHeaderItem(string, this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM"));
            this.insertItemIntoViewerAsLastChild((OutputItem)imageItem, headerItem);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void doCopyChartToViewer() {
        String string = this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM") + " " + this.mResBundle.getString("IDS_TCM_CHART");
        HeaderItem headerItem = this.getParentHeaderItem(string, this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM"));
        this.copyJsonChartItemIntoViewer(headerItem);
    }

    protected void copyJsonChartItemIntoViewer(HeaderItem headerItem) {
        JsonInteractiveItem jsonInteractiveItem = this.mInteractiveViewerItem.getItem();
        JsonChartItem jsonChartItem = this.constructJsonChartItem(jsonInteractiveItem);
        jsonChartItem.setVDPData(jsonInteractiveItem.getMainVDPData());
        this.insertItemIntoViewerAsLastChild((OutputItem)jsonChartItem, headerItem);
    }

    public void doCopyFitStatisticsTableToViewer() {
        TCMModelSystemInteractiveItem tCMModelSystemInteractiveItem = (TCMModelSystemInteractiveItem)this.mInteractiveViewerItem.getItem();
        JsonTableItem jsonTableItem = tCMModelSystemInteractiveItem.getModelFitStatisticsTableItem();
        jsonTableItem.setDescription(this.getDescriptionForSelectedDisplay() + " - " + this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM_MODEL_FIT_STATISTICS"));
        String string = this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM") + " " + this.mResBundle.getString("IDS_TCM_TABLE");
        HeaderItem headerItem = this.getParentHeaderItem(string, this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM"));
        this.insertItemIntoViewerAsLastChild((OutputItem)jsonTableItem, headerItem);
    }

    public void doCopySeriesWithOutliersTableToViewer() {
        TCMModelSystemInteractiveItem tCMModelSystemInteractiveItem = (TCMModelSystemInteractiveItem)this.mInteractiveViewerItem.getItem();
        JsonTableItem jsonTableItem = tCMModelSystemInteractiveItem.getSeriesWithOutliersTableItem();
        jsonTableItem.setDescription(this.getDescriptionForSelectedDisplay() + " - " + this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM_SERIES_WITH_OUTLIERS"));
        String string = this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM") + " " + this.mResBundle.getString("IDS_TCM_TABLE");
        HeaderItem headerItem = this.getParentHeaderItem(string, this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM"));
        this.insertItemIntoViewerAsLastChild((OutputItem)jsonTableItem, headerItem);
    }

    public void doCopyFitStatisticsTableToClipboard() {
        TCMModelSystemInteractiveItem tCMModelSystemInteractiveItem = (TCMModelSystemInteractiveItem)this.mInteractiveViewerItem.getItem();
        AppClipboard appClipboard = AppClipboard.getAppClipboard();
        try {
            BufferedImage bufferedImage = tCMModelSystemInteractiveItem.getModelFitStatisticsTableItem().render();
            if (bufferedImage != null) {
                appClipboard.addClipboardData(AppClipboard.IMAGE_FLAVOR, (Object)bufferedImage, true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doCopySeriesWithOutliersTableToClipboard() {
        TCMModelSystemInteractiveItem tCMModelSystemInteractiveItem = (TCMModelSystemInteractiveItem)this.mInteractiveViewerItem.getItem();
        AppClipboard appClipboard = AppClipboard.getAppClipboard();
        try {
            BufferedImage bufferedImage = tCMModelSystemInteractiveItem.getSeriesWithOutliersTableItem().render();
            if (bufferedImage != null) {
                appClipboard.addClipboardData(AppClipboard.IMAGE_FLAVOR, (Object)bufferedImage, true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof JComboBox && itemEvent.getStateChange() == 1) {
            int n;
            if (itemEvent.getSource() instanceof AutoSearchComboBox) {
                this.enableMenuItems();
            }
            this.mSeriesNameLabel.setEnabled((n = this.mHightlightSeriesComboBox.getSelectedIndex()) == ID_HIGHLIGHT_SINGLE_SERIES);
            this.mSeriesOfInterestComboBox.setEnabled(n == ID_HIGHLIGHT_SINGLE_SERIES);
            if (!(itemEvent.getSource() instanceof AutoSearchComboBox) || n == ID_HIGHLIGHT_SINGLE_SERIES) {
                JComponent jComponent;
                TCMModelSystemInteractiveItem tCMModelSystemInteractiveItem = (TCMModelSystemInteractiveItem)this.mInteractiveViewerItem.getItem();
                String string = this.mSeriesOfInterestComboBox.getEditorValue() != null ? this.mSeriesOfInterestComboBox.getEditorValue().toString() : "";
                tCMModelSystemInteractiveItem.performHighlightAction(n, string);
                if (!tCMModelSystemInteractiveItem.renderModelFitStatisticsTableAsMessage()) {
                    this.filterTable(tCMModelSystemInteractiveItem.getModelFitStatisticsTableItem());
                }
                if (!tCMModelSystemInteractiveItem.renderSeriesWithOutliersTableAsMessage()) {
                    this.filterTable(tCMModelSystemInteractiveItem.getSeriesWithOutliersTableItem());
                }
                this.mTablesPane.removeChangeListener(this);
                this.mTablesPane.removeAll();
                if (!tCMModelSystemInteractiveItem.renderModelFitStatisticsTableAsMessage() && !tCMModelSystemInteractiveItem.getModelFitStatisticsTableItem().isEmpty() && n != ID_HIGHLIGHT_MODELS_WITH_NO_INPUTS) {
                    this.mTablesPane.add(this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM_MODEL_FIT_STATISTICS"), this.mModelFitStatisticsScrollPane);
                } else {
                    jComponent = this.getNoMFSTablesComponent();
                    this.mTablesPane.add(this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM_MODEL_FIT_STATISTICS"), jComponent);
                }
                if (!tCMModelSystemInteractiveItem.renderSeriesWithOutliersTableAsMessage() && !tCMModelSystemInteractiveItem.getSeriesWithOutliersTableItem().isEmpty()) {
                    this.mTablesPane.add(this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM_SERIES_WITH_OUTLIERS"), this.mSeriesWithOutliersScrollPane);
                } else {
                    jComponent = this.getNoSWOTablesComponent();
                    this.mTablesPane.add(this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_SYSTEM_SERIES_WITH_OUTLIERS"), jComponent);
                }
                int n2 = tCMModelSystemInteractiveItem.getSelectedTableItem() == tCMModelSystemInteractiveItem.getModelFitStatisticsTableItem() ? 0 : 1;
                this.mTablesPane.setSelectedIndex(n2);
                this.enableMenuItems();
                this.mViewSeriesWithOutliersTableItem.setSelected(true);
                this.mTablesPane.addChangeListener(this);
                this.mSelectedSeriesNames.clear();
                if (this.mViewImpactDiagramSingleSeriesItem != null) {
                    this.mViewImpactDiagramSingleSeriesItem.setEnabled(n == ID_HIGHLIGHT_SINGLE_SERIES && this.mSeriesOfInterestComboBox.getSelectedItem() != null && this.canExecuteASL());
                }
                if (this.mViewImpactDiagramSelectedSeriesItem != null) {
                    this.mViewImpactDiagramSelectedSeriesItem.setEnabled(false);
                }
                tCMModelSystemInteractiveItem.setDescription(this.getDescriptionForSelectedDisplay());
                this.selectHightlightRelationsMenuItem(n);
            }
        }
        this.refreshCompositeDisplay();
    }

    private void filterTable(JsonTableItem jsonTableItem) {
        ByteBuffer byteBuffer;
        boolean bl;
        TCMModelSystemInteractiveItem tCMModelSystemInteractiveItem = (TCMModelSystemInteractiveItem)this.mInteractiveViewerItem.getItem();
        int n = this.mHightlightSeriesComboBox.getSelectedIndex();
        String string = this.mSeriesOfInterestComboBox.getSelectedItem() != null ? this.mSeriesOfInterestComboBox.getSelectedItem().toString() : "";
        boolean bl2 = jsonTableItem.equals(tCMModelSystemInteractiveItem.getModelFitStatisticsTableItem());
        if (bl2) {
            bl = tCMModelSystemInteractiveItem.renderModelFitStatisticsTableAsMessage();
            byteBuffer = tCMModelSystemInteractiveItem.getMFSTopModelsTableFilterData();
        } else {
            bl = tCMModelSystemInteractiveItem.renderSeriesWithOutliersTableAsMessage();
            byteBuffer = tCMModelSystemInteractiveItem.getSWOTopModelsTableFilterData();
        }
        if (!bl) {
            JSONObject jSONObject;
            block16: {
                jSONObject = null;
                if (n == ID_HIGHLIGHT_TOP_MODELS) {
                    jsonTableItem.setTableFilterVDPData(byteBuffer);
                    jsonTableItem.refreshLightPivotTable();
                    InputStream inputStream = TableImager.getProperInputStream((byte[])byteBuffer.array());
                    try {
                        jSONObject = JSONObject.parse((InputStream)inputStream);
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                } else if (n == ID_HIGHLIGHT_SINGLE_SERIES) {
                    try {
                        if (string == null || string.length() <= 0) break block16;
                        if (bl2) {
                            jSONObject = this.getMFSTableFilterForSeriesName(string);
                            break block16;
                        }
                        jSONObject = this.getSWOTableFilterForSeriesName(string);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                } else if (n == ID_HIGHLIGHT_ALL_SERIES) {
                    jsonTableItem.setTableFilterVDPData(null);
                    jsonTableItem.refreshLightPivotTable();
                } else {
                    jsonTableItem.setTableFilterVDPData(null);
                }
            }
            if (bl2) {
                this.createModelFitStatisticsScrolPane(jSONObject);
            } else {
                this.createSeriesWithOutliersScrolPane(jSONObject);
            }
        }
    }

    private void selectHightlightRelationsMenuItem(int n) {
        if (n == ID_HIGHLIGHT_TOP_MODELS) {
            this.mHightlightTopModelsMenuItem.setSelected(true);
        } else if (n == ID_HIGHLIGHT_SINGLE_SERIES) {
            this.mHightlightSingleSeriesMenuItem.setSelected(true);
        } else if (n == ID_HIGHLIGHT_ALL_SERIES) {
            this.mHightlightAllSeriesMenuItem.setSelected(true);
        } else if (n == ID_HIGHLIGHT_MODELS_WITH_NO_INPUTS) {
            this.mHightlightModelsWithNoInputsMenuItem.setSelected(true);
        }
    }

    private JSONObject getMFSTableFilterForSeriesName(String string) throws IOException {
        TCMModelSystemInteractiveItem tCMModelSystemInteractiveItem = (TCMModelSystemInteractiveItem)this.mInteractiveViewerItem.getItem();
        JSONObject jSONObject = tCMModelSystemInteractiveItem.createTableFilterJsonForSeriesName(string, "IDS_TCM_OVERALL_MODEL_SYSTEM_FIT_STATISTICS_FOR_SINGLE_SERIES");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (jSONObject != null) {
            jSONObject.serialize((OutputStream)byteArrayOutputStream);
            tCMModelSystemInteractiveItem.setSingleSeriesName(string);
            tCMModelSystemInteractiveItem.getModelFitStatisticsTableItem().setTableFilterVDPData(ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            tCMModelSystemInteractiveItem.getModelFitStatisticsTableItem().refreshLightPivotTable();
        }
        return jSONObject;
    }

    private JSONObject getSWOTableFilterForSeriesName(String string) throws IOException {
        TCMModelSystemInteractiveItem tCMModelSystemInteractiveItem = (TCMModelSystemInteractiveItem)this.mInteractiveViewerItem.getItem();
        JSONObject jSONObject = tCMModelSystemInteractiveItem.createTableFilterJsonForSeriesName(string, "IDS_TCM_OVERALL_MODEL_SYSTEM_SERIES_WITH_OUTLIERS");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (jSONObject != null) {
            jSONObject.serialize((OutputStream)byteArrayOutputStream);
            tCMModelSystemInteractiveItem.getSeriesWithOutliersTableItem().setTableFilterVDPData(ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            tCMModelSystemInteractiveItem.getSeriesWithOutliersTableItem().refreshLightPivotTable();
        }
        return jSONObject;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        this.refreshCompositeDisplay();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        TCMModelSystemInteractiveItem tCMModelSystemInteractiveItem = (TCMModelSystemInteractiveItem)this.mInteractiveViewerItem.getItem();
        JsonTableItem jsonTableItem = this.mTablesPane.getSelectedIndex() == 0 ? tCMModelSystemInteractiveItem.getModelFitStatisticsTableItem() : tCMModelSystemInteractiveItem.getSeriesWithOutliersTableItem();
        tCMModelSystemInteractiveItem.setSelectedTableItem(this.mTablesPane.getSelectedIndex(), jsonTableItem);
        this.mViewModelFitStatisticsTableItem.setSelected(tCMModelSystemInteractiveItem.getSelectedTableItem() == tCMModelSystemInteractiveItem.getModelFitStatisticsTableItem());
        this.mViewSeriesWithOutliersTableItem.setSelected(tCMModelSystemInteractiveItem.getSelectedTableItem() != tCMModelSystemInteractiveItem.getModelFitStatisticsTableItem());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("copy_fit_statistics_table_to_viewer".equals(actionEvent.getActionCommand())) {
            this.doCopyFitStatisticsTableToViewer();
        } else if ("copy_series_with_outliers_table_to_viewer".equals(actionEvent.getActionCommand())) {
            this.doCopySeriesWithOutliersTableToViewer();
        } else if ("copy_fit_statistics_table_to_clipboard".equals(actionEvent.getActionCommand())) {
            this.doCopyFitStatisticsTableToClipboard();
        } else if ("copy_series_with_outliers_table_to_clipboard".equals(actionEvent.getActionCommand())) {
            this.doCopySeriesWithOutliersTableToClipboard();
        } else if ("view_top_models".equals(actionEvent.getActionCommand())) {
            this.mHightlightSeriesComboBox.setSelectedIndex(ID_HIGHLIGHT_TOP_MODELS);
        } else if ("view_single_series".equals(actionEvent.getActionCommand())) {
            this.mHightlightSeriesComboBox.setSelectedIndex(ID_HIGHLIGHT_SINGLE_SERIES);
        } else if ("view_all_series".equals(actionEvent.getActionCommand())) {
            this.mHightlightSeriesComboBox.setSelectedIndex(ID_HIGHLIGHT_ALL_SERIES);
        } else if ("view_models_with_no_inputs".equals(actionEvent.getActionCommand())) {
            this.mHightlightSeriesComboBox.setSelectedIndex(ID_HIGHLIGHT_MODELS_WITH_NO_INPUTS);
        } else if ("view_impact_diagram_single_series".equals(actionEvent.getActionCommand())) {
            this.createImpactDiagram(this.mSeriesOfInterestComboBox.getSelectedItem().toString());
        } else if ("view_impact_diagram_selected_series".equals(actionEvent.getActionCommand())) {
            for (int i = 0; i < this.mSelectedSeriesNames.size(); ++i) {
                String string = this.mSelectedSeriesNames.get(i);
                this.createImpactDiagram(string);
            }
        } else if ("view_relations_for_series".equals(actionEvent.getActionCommand())) {
            for (int i = 0; i < this.mSelectedSeriesNames.size() && i < 1; ++i) {
                String string = this.mSelectedSeriesNames.get(i);
                this.mSeriesOfInterestComboBox.setSelectedItem(string);
                this.mHightlightSeriesComboBox.setSelectedIndex(ID_HIGHLIGHT_SINGLE_SERIES);
            }
        } else if ("view_model_fit_statistics".equals(actionEvent.getActionCommand())) {
            this.mTablesPane.setSelectedIndex(0);
            this.mViewModelFitStatisticsTableItem.setSelected(true);
        } else if ("view_series_with_outliers".equals(actionEvent.getActionCommand())) {
            this.mTablesPane.setSelectedIndex(1);
            this.mViewSeriesWithOutliersTableItem.setSelected(true);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private void createImpactDiagram(final String string) {
        final TCMModelSystemInteractiveItem tCMModelSystemInteractiveItem = (TCMModelSystemInteractiveItem)this.mInteractiveViewerItem.getItem();
        final String string2 = tCMModelSystemInteractiveItem.getModelSystemFilePath();
        final SpssProgressDlg spssProgressDlg = new SpssProgressDlg((Window)this, this.mResBundle.getString("IDS_PERFORMING_REQUESTED_ACTION"));
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TCMImpactDiagramInteractiveItem tCMImpactDiagramInteractiveItem;
                    if (TCMModelSystemInteractiveFrame.this.aslExecutor == null) {
                        TCMModelSystemInteractiveFrame.this.aslExecutor = (ASLExecutor)TCMModelSystemInteractiveFrame.this.mInteractiveViewerItem.getTopLevelAncestor();
                    }
                    if ((tCMImpactDiagramInteractiveItem = TCMUtils.createImpactDiagram((String)tCMModelSystemInteractiveItem.getLocale(), (String)string, (JSONObject)tCMModelSystemInteractiveItem.getDataModelJson(), (String)string2, (int)3, (ASLExecutor)TCMModelSystemInteractiveFrame.this.aslExecutor)) != null) {
                        tCMImpactDiagramInteractiveItem.setDescription(TCMUtils.convertSeriesLongNameToShort((String)string) + ":" + TCMModelSystemInteractiveFrame.this.mResBundle.getString("IDS_TCM_IMPACT_DIAGRAM_EFFECTS"));
                        tCMImpactDiagramInteractiveItem.setParentItem((IOutputItem)TCMModelSystemInteractiveFrame.this.mInteractiveViewerItem.getItem());
                        tCMImpactDiagramInteractiveItem.setInitialSeriesOfInterest(string);
                        JsonInteractiveViewerItem jsonInteractiveViewerItem = new JsonInteractiveViewerItem((IOutputItem)tCMImpactDiagramInteractiveItem);
                        final TCMImpactDiagramInteractiveFrame tCMImpactDiagramInteractiveFrame = new TCMImpactDiagramInteractiveFrame(jsonInteractiveViewerItem, TCMModelSystemInteractiveFrame.this);
                        tCMImpactDiagramInteractiveFrame.setVisible(true);
                        TCMModelSystemInteractiveFrame.this.toBack();
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                tCMImpactDiagramInteractiveFrame.toFront();
                                tCMImpactDiagramInteractiveFrame.mSeriesOfIntrestComboBox.setSelectedItem(string);
                            }
                        });
                    } else {
                        String string3 = TCMModelSystemInteractiveFrame.this.mResBundle.getString("IDS_TCM_CREATE_IMPACT_DIAGRAM");
                        String string22 = TCMModelSystemInteractiveFrame.this.mResBundle.getString("IDS_TCM_CREATE_IMPACT_DIAGRAM_ERROR");
                        JOptionPane.showMessageDialog(TCMModelSystemInteractiveFrame.this, string22, string3, 2);
                    }
                    spssProgressDlg.setVisible(false);
                }
                catch (Exception exception) {
                    spssProgressDlg.setVisible(false);
                    exception.printStackTrace();
                }
                finally {
                    spssProgressDlg.setWorkDone(true);
                    spssProgressDlg.dispose();
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        spssProgressDlg.setInterruptThread(thread);
        try {
            Thread.sleep(1000L);
            if (!spssProgressDlg.isWorkDone()) {
                spssProgressDlg.setVisible(true);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void refreshCompositeDisplay() {
        TCMModelSystemInteractiveItem tCMModelSystemInteractiveItem = (TCMModelSystemInteractiveItem)this.mInteractiveViewerItem.getItem();
        VisControl visControl = this.mMainDisplayPanel.getVisControl();
        JSONObject jSONObject = OutputVisComponentUtil.exportComponentViewAsVisSpec((VisControl)visControl, (OutputVisComponent)tCMModelSystemInteractiveItem.getMainVisComponent(), (Integer)((int)((double)tCMModelSystemInteractiveItem.getWidth() * tCMModelSystemInteractiveItem.getMainVisualizationProportion())), (Integer)tCMModelSystemInteractiveItem.getHeight());
        visControl.getInteractivity().getViewportZoom().setViewport(tCMModelSystemInteractiveItem.getMainViewport());
        visControl.setSpecification(jSONObject);
    }

    @Override
    protected Dimension getItemSize() {
        Dimension dimension = new Dimension(this.mMainDisplayPanel.getWidth() + this.mTablesPane.getWidth(), this.mMainDisplayPanel.getHeight());
        return dimension;
    }

    private int highlightActionParamsToIndex(JSONObject jSONObject) {
        TCMModelSystemInteractiveItem tCMModelSystemInteractiveItem = (TCMModelSystemInteractiveItem)this.mInteractiveViewerItem.getItem();
        int n = tCMModelSystemInteractiveItem.getSelectedHighlightType();
        if (jSONObject != null) {
            String string = (String)BasicFactory.getItem((Object)jSONObject, (String)"type");
            if (string.compareTo(IDS_HIGHLIGHT_TOP_MODELS) == 0) {
                n = ID_HIGHLIGHT_TOP_MODELS;
            }
            if (string.compareTo(IDS_HIGHLIGHT_SINGLE_SERIES) == 0) {
                n = ID_HIGHLIGHT_SINGLE_SERIES;
            }
            if (string.compareTo(IDS_HIGHLIGHT_ALL_SERIES) == 0) {
                n = ID_HIGHLIGHT_ALL_SERIES;
            }
            if (string.compareTo(IDS_HIGHLIGHT_MODELS_WITH_NO_INPUTS) == 0) {
                n = ID_HIGHLIGHT_MODELS_WITH_NO_INPUTS;
            }
        }
        return n;
    }

    private boolean canExecuteASL() {
        if (this.aslExecutor == null) {
            this.aslExecutor = (ASLExecutor)this.mInteractiveViewerItem.getTopLevelAncestor();
        }
        return this.aslExecutor.canExecuteASL();
    }

    private void enableMenuItems() {
        TCMModelSystemInteractiveItem tCMModelSystemInteractiveItem = (TCMModelSystemInteractiveItem)this.mInteractiveViewerItem.getItem();
        JSONObject jSONObject = tCMModelSystemInteractiveItem.getSelectedHighlightActionParams();
        int n = this.highlightActionParamsToIndex(jSONObject);
        if (this.mViewImpactDiagramSingleSeriesItem != null) {
            this.mViewImpactDiagramSingleSeriesItem.setEnabled(n == ID_HIGHLIGHT_SINGLE_SERIES && this.mSeriesOfInterestComboBox.getSelectedItem() != null && this.mSeriesOfInterestComboBox.getSelectedItem().toString().length() > 0 && this.canExecuteASL());
        }
        if (this.mCopyModelFitStatisticsTableToViewerItem != null) {
            this.mCopyModelFitStatisticsTableToViewerItem.setEnabled(!tCMModelSystemInteractiveItem.renderModelFitStatisticsTableAsMessage() && n != ID_HIGHLIGHT_MODELS_WITH_NO_INPUTS);
        }
        if (this.mCopyModelFitStatisticsTableToClipboardItem != null) {
            this.mCopyModelFitStatisticsTableToClipboardItem.setEnabled(!tCMModelSystemInteractiveItem.renderModelFitStatisticsTableAsMessage() && n != ID_HIGHLIGHT_MODELS_WITH_NO_INPUTS);
        }
        if (this.mCopySeriesWithOutliersTableToViewerItem != null) {
            this.mCopySeriesWithOutliersTableToViewerItem.setEnabled(!tCMModelSystemInteractiveItem.renderSeriesWithOutliersTableAsMessage());
        }
        if (this.mCopySeriesWithOutliersTableToClipboardItem != null) {
            this.mCopySeriesWithOutliersTableToClipboardItem.setEnabled(!tCMModelSystemInteractiveItem.renderSeriesWithOutliersTableAsMessage());
        }
    }

    @Override
    public void processVisCompMainMouseClick(JSONObject jSONObject, boolean bl) {
        this.mSelectedSeriesNames.clear();
        TCMModelSystemInteractiveItem tCMModelSystemInteractiveItem = (TCMModelSystemInteractiveItem)this.mInteractiveViewerItem.getItem();
        JSONArray jSONArray = (JSONArray)BasicFactory.getItem((Object)jSONObject, (String)"seriesList");
        for (int i = 0; i < jSONArray.size(); ++i) {
            JSONObject jSONObject2 = (JSONObject)BasicFactory.getArrayItem((JSONArray)jSONArray, (int)i);
            String string = (String)BasicFactory.getItem((Object)jSONObject2, (String)"seriesName");
            this.mSelectedSeriesNames.add(string);
            String string2 = (String)BasicFactory.getItem((Object)jSONObject2, (String)"seriesKey");
            tCMModelSystemInteractiveItem.performSelectAction(string2);
        }
        if (this.mViewImpactDiagramSelectedSeriesItem != null) {
            this.mViewImpactDiagramSelectedSeriesItem.setEnabled(this.mSelectedSeriesNames.size() > 0 && this.canExecuteASL());
        }
        if (this.mHighlightRelationsForSeriesItem != null) {
            this.mHighlightRelationsForSeriesItem.setEnabled(this.mSelectedSeriesNames.size() == 1);
        }
    }
}

