/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive;

import com.ibm.json.java.JSONObject;
import com.spss.java_client.core.documents.output.interactive.TCMModelQualityInteractiveItem;
import com.spss.java_client.ui.controls.AutoSearchComboBox;
import com.spss.java_client.ui.doc_types.output.JsonInteractiveViewerItem;
import com.spss.java_client.ui.interactive.JsonInteractiveFrame;
import com.spss.java_client.ui.interactive.JsonSplitInteractiveFrame;
import com.spss.java_client.ui.interactive.OutputVisPanel;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.output.vis.charting.OutputVisComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class TCMModelQualityInteractiveFrame
extends JsonSplitInteractiveFrame
implements ItemListener {
    private AutoSearchComboBox mFindTargetComboBox1;
    private JPanel mDotplotPane;
    List<String> mComboBoxEntries;
    private String mRangeText;

    public TCMModelQualityInteractiveFrame(JsonInteractiveViewerItem jsonInteractiveViewerItem) {
        super(jsonInteractiveViewerItem);
        this.setTitle(this.mResBundle.getString("IDS_INTERACTIVE_OUTPUT_TITLE") + this.mResBundle.getString("IDS_INTERACTIVE_OUTPUT_TITLE_SEP") + this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_QUALITY"));
        TCMModelQualityInteractiveItem tCMModelQualityInteractiveItem = (TCMModelQualityInteractiveItem)this.mInteractiveViewerItem.getItem();
        if (tCMModelQualityInteractiveItem.isRenderAsMessage()) {
            this.constructMessageGUI();
            this.constructMessageMenus();
        } else {
            this.constructGUI();
            this.constructMenus();
            this.addWindowListener(this);
        }
        this.setTabTraversalPolicy();
    }

    @Override
    protected void constructGUI() {
        Object object;
        TCMModelQualityInteractiveItem tCMModelQualityInteractiveItem = (TCMModelQualityInteractiveItem)this.mInteractiveViewerItem.getItem();
        OutputVisComponent outputVisComponent = tCMModelQualityInteractiveItem.getMainVisComponent();
        this.mMainDisplayPanel = new OutputVisPanel(outputVisComponent);
        this.mVisCompMainInteracitivity = new JsonInteractiveFrame.VisCompMainInteracitivity(this);
        OutputVisComponent outputVisComponent2 = tCMModelQualityInteractiveItem.getAuxiliaryVisComponent();
        this.mAuxDisplayPanel = new OutputVisPanel(outputVisComponent2);
        this.mDotplotPane = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.mDotplotPane.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_QUALITY_FIND_MODEL"));
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 15, 4, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.mDotplotPane.add((Component)jLabel, gridBagConstraints);
        if (tCMModelQualityInteractiveItem.getUsedTargetVariableList() != null) {
            this.mComboBoxEntries = new ArrayList<String>();
            object = tCMModelQualityInteractiveItem.getUsedTargetVariableList();
            Arrays.sort(object);
            this.mComboBoxEntries.addAll(Arrays.asList(object));
            this.mFindTargetComboBox1 = this.createAutoSearchSeriesComboBox(this.mComboBoxEntries);
        } else {
            this.mFindTargetComboBox1 = this.createAutoSearchSeriesComboBox(new ArrayList<String>());
        }
        this.mFindTargetComboBox1.setPreferredSize(new Dimension(160, 24));
        this.mFindTargetComboBox1.setMinimumSize(new Dimension(160, 24));
        this.mFindTargetComboBox1.addItemListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.mDotplotPane.add((Component)this.mFindTargetComboBox1, gridBagConstraints);
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        this.mDotplotPane.add((Component)this.mAuxDisplayPanel, gridBagConstraints);
        this.createSplitPane(0, this.mMainDisplayPanel, this.mDotplotPane);
        object = new GridBagLayout();
        this.setLayout((LayoutManager)object);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(4, 4, 4, 0);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 17;
        this.add((Component)this.constructCopyToViewerButton(), gridBagConstraints2);
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 5;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = new Insets(4, 0, 4, 0);
        gridBagConstraints2.fill = 1;
        this.add((Component)this.mSplitPane, gridBagConstraints2);
    }

    @Override
    protected Vector<Object> addControlsForFocusTraversal(Vector<Object> vector) {
        vector.add(this.mCopyToViewerButton);
        vector.add(this.mMainDisplayPanel.getVisControl());
        vector.add(this.mFindTargetComboBox1);
        vector.add(this.mAuxDisplayPanel.getVisControl());
        return vector;
    }

    @Override
    protected void constructMenus() {
        BitSet bitSet = new BitSet();
        bitSet.set(MENU_OPTION_FILE);
        bitSet.set(MENU_OPTION_EDIT);
        bitSet.set(MENU_OPTION_HELP);
        super.constructMenus(bitSet);
        JMenu jMenu = this.createCopyToViewerMenu(false);
        this.addItemToMenu(jMenu, "copy_chart_histogram_to_viewer");
        this.addItemToMenu(jMenu, "copy_chart_dotplot_to_viewer");
        this.addItemToMenu(jMenu, "copy_image_to_viewer");
        this.fileMenu.add(jMenu);
        this.fileMenu.addSeparator();
        this.addItemToMenu(this.fileMenu, "print_settings");
        this.fileMenu.addSeparator();
        this.addItemToMenu(this.fileMenu, "file_close");
        JMenu jMenu2 = new JMenu(ResUtil.getString("copy_object"));
        jMenu2.setMnemonic(ResUtil.getAccessKey("copy_object"));
        this.addItemToMenu(jMenu2, "copy_chart_histogram_to_clipboard");
        this.addItemToMenu(jMenu2, "copy_chart_dotplot_to_clipboard");
        this.addItemToMenu(jMenu2, "copy_image_to_clipboard");
        this.editMenu.add(jMenu2);
        this.addItemToMenu(this.helpMenu, "help_topics");
    }

    @Override
    protected void addCopyToViewerPopupMenuItems(JPopupMenu jPopupMenu) {
        JMenu jMenu = this.createCopyToViewerMenu(true);
        this.addItemToMenu(jMenu, "copy_chart_histogram_to_viewer");
        this.addItemToMenu(jMenu, "copy_chart_dotplot_to_viewer");
        this.addItemToMenu(jMenu, "copy_image_to_viewer");
        jPopupMenu.add(jMenu);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        TCMModelQualityInteractiveItem tCMModelQualityInteractiveItem;
        String string;
        if (itemEvent.getSource() == this.mFindTargetComboBox1 && itemEvent.getStateChange() == 1 && this.mComboBoxEntries.contains(string = (String)((JComboBox)itemEvent.getSource()).getSelectedItem()) && !(tCMModelQualityInteractiveItem = (TCMModelQualityInteractiveItem)this.mInteractiveViewerItem.getItem()).getKeyForTargetVariable(string).equals("-1")) {
            try {
                String string2 = "{";
                string2 = string2 + "\"selectTarget\": \"" + tCMModelQualityInteractiveItem.getKeyForTargetVariable(string) + "\"";
                string2 = string2 + "}";
                JSONObject jSONObject = JSONObject.parse((String)string2);
                tCMModelQualityInteractiveItem.performActionOnAux("targetActions", jSONObject);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    protected Dimension getItemSize() {
        Dimension dimension = this.mInteractiveViewerItem.getItem().isRenderAsMessage() ? new Dimension(this.mInteractiveViewerItem.getWidth(), this.mInteractiveViewerItem.getHeight()) : new Dimension(this.mMainDisplayPanel.getWidth(), this.mMainDisplayPanel.getHeight() + this.mDotplotPane.getHeight());
        return dimension;
    }

    @Override
    public void doCopyChartHistogramToViewer() {
        String string = ((TCMModelQualityInteractiveItem)this.mInteractiveViewerItem.getItem()).getDescription();
        ((TCMModelQualityInteractiveItem)this.mInteractiveViewerItem.getItem()).setDescription(this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_QUALITY") + " " + this.mResBundle.getString("IDS_TCM_HISTOGRAM") + " - " + this.getDisplayStringForType(((TCMModelQualityInteractiveItem)this.mInteractiveViewerItem.getItem()).getFitStatType()));
        this.copyJsonChartItemIntoViewer(true);
        ((TCMModelQualityInteractiveItem)this.mInteractiveViewerItem.getItem()).setDescription(string);
    }

    @Override
    public void doCopyChartDotplotToViewer() {
        String string = ((TCMModelQualityInteractiveItem)this.mInteractiveViewerItem.getItem()).getDescription();
        if (this.mRangeText == null) {
            ((TCMModelQualityInteractiveItem)this.mInteractiveViewerItem.getItem()).setDescription(this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_QUALITY") + " " + this.mResBundle.getString("IDS_TCM_DOTPLOT") + " - " + this.getDisplayStringForType(((TCMModelQualityInteractiveItem)this.mInteractiveViewerItem.getItem()).getFitStatType()));
        } else {
            ((TCMModelQualityInteractiveItem)this.mInteractiveViewerItem.getItem()).setDescription(this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_QUALITY") + " " + this.mResBundle.getString("IDS_TCM_DOTPLOT") + " - " + this.getDisplayStringForType(((TCMModelQualityInteractiveItem)this.mInteractiveViewerItem.getItem()).getFitStatType()) + " " + "(" + this.mRangeText + ")");
        }
        this.copyJsonChartItemIntoViewer(false);
        ((TCMModelQualityInteractiveItem)this.mInteractiveViewerItem.getItem()).setDescription(string);
    }

    private String getDisplayStringForType(TCMModelQualityInteractiveItem.Type type) {
        if (type == TCMModelQualityInteractiveItem.Type.AIC) {
            return this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_QUALITY_AIC");
        }
        if (type == TCMModelQualityInteractiveItem.Type.BIC) {
            return this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_QUALITY_BIC");
        }
        if (type == TCMModelQualityInteractiveItem.Type.NBIC) {
            return this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_QUALITY_NBIC");
        }
        if (type == TCMModelQualityInteractiveItem.Type.RMSE) {
            return this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_QUALITY_RMSE");
        }
        if (type == TCMModelQualityInteractiveItem.Type.RMSPE) {
            return this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_QUALITY_RMSPE");
        }
        if (type == TCMModelQualityInteractiveItem.Type.R_SQUARED) {
            return this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_QUALITY_R_SQUARED");
        }
        return "";
    }

    private void setRangeText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string.split("~");
        if (stringArray.length == 2) {
            stringBuilder.append(stringArray[0]);
            stringBuilder.append(" - ");
            stringBuilder.append(stringArray[1]);
        }
        this.mRangeText = stringBuilder.length() > 0 ? stringBuilder.toString() : string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("copy_chart_histogram_to_viewer".equals(actionEvent.getActionCommand())) {
            this.doCopyChartHistogramToViewer();
        } else if ("copy_chart_dotplot_to_viewer".equals(actionEvent.getActionCommand())) {
            this.doCopyChartDotplotToViewer();
        } else if ("copy_image_to_viewer".equals(actionEvent.getActionCommand())) {
            this.doCopyImageToViewer();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    @Override
    public void processVisCompMainMouseClick(JSONObject jSONObject, boolean bl) {
        String string = (String)jSONObject.get((Object)"selectBar");
        if (string != null) {
            try {
                String string2 = "{";
                string2 = string2 + "\"setRange\": \"" + string + "\"";
                string2 = string2 + "}";
                JSONObject jSONObject2 = JSONObject.parse((String)string2);
                ((TCMModelQualityInteractiveItem)this.mInteractiveViewerItem.getItem()).performActionOnAux("qualityRangeActions", jSONObject2);
                this.setRangeText(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            string = (String)jSONObject.get((Object)"cancelSelectBar");
            this.mRangeText = null;
            try {
                String string3 = "{";
                string3 = string3 + "\"cancelSetRange\": \"null\"";
                string3 = string3 + "}";
                JSONObject jSONObject3 = JSONObject.parse((String)string3);
                ((TCMModelQualityInteractiveItem)this.mInteractiveViewerItem.getItem()).performActionOnAux("qualityRangeActions", jSONObject3);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

