/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive;

import com.spss.java_client.ui.interactive.ChartOptionsDlg;
import com.spss.java_client.ui.interactive.GuideLineInfo;
import com.spss.java_client.ui.interactive.ScaleTargetDetailPanel;
import com.spss.java_client.ui.interactive.ScaleTargetFeedbackCanvas;
import com.spss.java_client.ui.interactive.ValueWeightPair;
import com.spss.vis.ResultsProcessor;
import com.spss.vis.component.VisualizationComponent;
import com.spss.vis.component.hit.HitInfo;
import com.spss.vis.component.hit.HitProcessor;
import com.spss.vis.exception.VisualizationException;
import com.spss.vis.specification.DataValue;
import com.spss.vis.specification.ExtensionSpecification;
import com.spss.vis.specification.Length;
import com.spss.vis.specification.Specification;
import com.spss.vis.specification.VisualizationSpecification;
import com.spss.vis.specification.data.DataSpecification;
import com.spss.vis.specification.data.DerivedVariableSpecification;
import com.spss.vis.specification.data.EmbeddedSourceSpecification;
import com.spss.vis.specification.data.SourceVariableSpecification;
import com.spss.vis.specification.data.VariableSpecification;
import com.spss.vis.specification.element.ElementSpecification;
import com.spss.vis.specification.format.FormatSpecification;
import com.spss.vis.specification.guide.LineGuideSpecification;
import com.spss.vis.specification.label.LabelSpecification;
import com.spss.vis.specification.style.FrameStyle;
import com.spss.vis.specification.style.StyleSpecification;
import com.spss.vis.specification.style.TextAlignmentType;
import com.spss.vis.specification.style.TextStyle;
import java.awt.Color;
import java.awt.Shape;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ScaleTargetMediator {
    private final double DEFAULT_PERCENT = 95.0;
    private VisualizationComponent mVisComp;
    private ScaleTargetFeedbackCanvas mCanvas;
    private ScaleTargetDetailPanel mDetailPanel;
    private GuideLineInfo mGuideLine1;
    private GuideLineInfo mGuideLine2;
    private String mLowerGuideName;
    private String mUpperGuideName;
    private boolean mIsLowerLineInfinity;
    private boolean mIsUpperLineInfinity;
    private ChartOptionsDlg mOptionDlg;
    private boolean mIsCumulative;
    public static final String ASCENDING_KEY = "ascending";
    public static final String DESCENDING_KEY = "descending";
    private String targetId = "Legend";
    private boolean mIsValidValue1;
    private boolean mIsValidValue2;
    private String mLegendTitle;
    private Map<Integer, String> mLegendValueMap;
    private Map<Integer, Color> mColorMap;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 1989, 2013.\n\n";
    }

    public ScaleTargetMediator(VisualizationComponent visualizationComponent, ScaleTargetFeedbackCanvas scaleTargetFeedbackCanvas, ScaleTargetDetailPanel scaleTargetDetailPanel) {
        this.mVisComp = visualizationComponent;
        this.mCanvas = scaleTargetFeedbackCanvas;
        this.mDetailPanel = scaleTargetDetailPanel;
        this.mCanvas.setMediator(this);
        this.mDetailPanel.setMediator(this);
        this.mGuideLine1 = new GuideLineInfo();
        this.mGuideLine2 = new GuideLineInfo();
        this.loadGuideLineIds();
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        ExtensionSpecification[] extensionSpecificationArray = visualizationSpecification.getExtensionSpecifications();
        if (extensionSpecificationArray.length > 0) {
            String string = extensionSpecificationArray[0].get(ASCENDING_KEY);
            if (string != null && string.length() > 0) {
                this.mIsCumulative = true;
            }
            String string2 = extensionSpecificationArray[0].get("lowerinfinity");
            String string3 = extensionSpecificationArray[0].get("upperinfinity");
            if (string2 != null && "true".equals(string2)) {
                this.setLowerLineInfinity(true);
            }
            if (string3 != null && "true".equals(string3)) {
                this.setUpperLineInfinity(true);
            }
        }
    }

    public void updateTable() {
        this.mDetailPanel.refresh();
        if (this.mOptionDlg != null) {
            this.mOptionDlg.refreshSliderPosition();
        }
    }

    public void loadLineValues(boolean bl) throws VisualizationException {
        Shape[] shapeArray;
        Collection collection = this.mVisComp.getHits(true);
        if (bl) {
            shapeArray = new HitProcessor(true, true);
            try {
                this.mVisComp.getVisualization().runProcessor((ResultsProcessor)shapeArray);
            }
            catch (VisualizationException visualizationException) {
                visualizationException.printStackTrace();
            }
            collection = shapeArray.getItems();
        }
        this.mIsValidValue1 = false;
        this.mIsValidValue2 = false;
        for (HitInfo hitInfo : collection) {
            shapeArray = hitInfo.getShapes();
            if (shapeArray == null || !"lineGuide".equals(hitInfo.getType()) || !"main".equals(hitInfo.getSubType())) continue;
            LineGuideSpecification lineGuideSpecification = (LineGuideSpecification)hitInfo.getSpecification();
            DataValue dataValue = lineGuideSpecification.getX();
            if (dataValue == null && (this.getGuideLineName(true).equals(lineGuideSpecification.getName()) || this.getGuideLineName(false).equals(lineGuideSpecification.getName()))) {
                this.mDetailPanel.percentChanged(95.0);
                this.mDetailPanel.loadDetailPanel();
                return;
            }
            if (this.getGuideLineName(true).equals(lineGuideSpecification.getName())) {
                this.mGuideLine1.setValue(dataValue.toDouble());
                this.mGuideLine1.setXCoorPos(shapeArray[0].getBounds().x);
                this.mGuideLine1.setInfo(hitInfo);
                this.mIsValidValue1 = true;
                continue;
            }
            if (!this.getGuideLineName(false).equals(lineGuideSpecification.getName())) continue;
            this.mGuideLine2.setValue(dataValue.toDouble());
            this.mGuideLine2.setXCoorPos(shapeArray[0].getBounds().x);
            this.mGuideLine2.setInfo(hitInfo);
            this.mIsValidValue2 = true;
        }
    }

    public GuideLineInfo getGuideLineInfo(boolean bl) {
        if (bl) {
            return this.mGuideLine1;
        }
        return this.mGuideLine2;
    }

    public boolean isValidValue(boolean bl) {
        if (bl) {
            return this.mIsValidValue1;
        }
        return this.mIsValidValue2;
    }

    public void reset() {
        this.mGuideLine1 = new GuideLineInfo();
        this.mGuideLine2 = new GuideLineInfo();
    }

    public String getGuideLineName(boolean bl) {
        if (bl) {
            return this.mLowerGuideName;
        }
        return this.mUpperGuideName;
    }

    public String formatValue(double d) {
        String string = String.valueOf(d);
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        ElementSpecification[] elementSpecificationArray = (ElementSpecification[])visualizationSpecification.findDescendantsOfType(ElementSpecification.class);
        if (elementSpecificationArray.length > 0) {
            VariableSpecification variableSpecification = elementSpecificationArray[0].getX();
            FormatSpecification[] formatSpecificationArray = (FormatSpecification[])variableSpecification.findDescendantsOfType(FormatSpecification.class);
            if (formatSpecificationArray.length > 0) {
                FormatSpecification formatSpecification = formatSpecificationArray[0];
                if (formatSpecification.getMinimumFractionDigits() != null) {
                    numberFormat.setMinimumFractionDigits(formatSpecification.getMinimumFractionDigits());
                }
                if (formatSpecification.getMaximumFractionDigits() != null) {
                    numberFormat.setMaximumFractionDigits(formatSpecification.getMaximumFractionDigits());
                }
                numberFormat.setGroupingUsed(false);
                string = numberFormat.format(d);
            } else {
                numberFormat.setGroupingUsed(false);
                numberFormat.setMaximumFractionDigits(2);
                string = numberFormat.format(d);
            }
        }
        return string;
    }

    public String displayFormatValue(double d) {
        String string = String.valueOf(d);
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        ElementSpecification[] elementSpecificationArray = (ElementSpecification[])visualizationSpecification.findDescendantsOfType(ElementSpecification.class);
        if (elementSpecificationArray.length > 0) {
            VariableSpecification variableSpecification = elementSpecificationArray[0].getX();
            FormatSpecification[] formatSpecificationArray = (FormatSpecification[])variableSpecification.findDescendantsOfType(FormatSpecification.class);
            if (formatSpecificationArray.length > 0) {
                FormatSpecification formatSpecification = formatSpecificationArray[0];
                if (formatSpecification.getMinimumFractionDigits() != null) {
                    numberFormat.setMinimumFractionDigits(formatSpecification.getMinimumFractionDigits());
                }
                if (formatSpecification.getMaximumFractionDigits() != null) {
                    numberFormat.setMaximumFractionDigits(formatSpecification.getMaximumFractionDigits());
                }
                if (formatSpecification.getUseGrouping() != null) {
                    numberFormat.setGroupingUsed(formatSpecification.getUseGrouping());
                }
                string = numberFormat.format(d);
                if (formatSpecification.getPrefix() != null && formatSpecification.getPrefix().length() > 0) {
                    string = formatSpecification.getPrefix() + string;
                }
                if (formatSpecification.getSuffix() != null && formatSpecification.getSuffix().length() > 0) {
                    string = string + formatSpecification.getSuffix();
                }
            } else {
                numberFormat.setGroupingUsed(false);
                numberFormat.setMaximumFractionDigits(2);
                string = numberFormat.format(d);
            }
        }
        return string;
    }

    public void setChartOptionDialog(ChartOptionsDlg chartOptionsDlg) {
        this.mOptionDlg = chartOptionsDlg;
    }

    public void reloadDetailPanel() {
        this.mDetailPanel.loadDetailPanel();
    }

    public double getLineValueAtPercent(double d) {
        DataSpecification[] dataSpecificationArray;
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        for (DataSpecification dataSpecification : dataSpecificationArray = visualizationSpecification.getDataSpecifications()) {
            EmbeddedSourceSpecification embeddedSourceSpecification;
            if (!(dataSpecification instanceof EmbeddedSourceSpecification) || "tableData".equals((embeddedSourceSpecification = (EmbeddedSourceSpecification)dataSpecification).getId())) continue;
            String[] stringArray = embeddedSourceSpecification.getNames();
            ElementSpecification[] elementSpecificationArray = (ElementSpecification[])visualizationSpecification.findDescendantsOfType(ElementSpecification.class);
            SourceVariableSpecification sourceVariableSpecification = (SourceVariableSpecification)elementSpecificationArray[0].getX();
            String string = sourceVariableSpecification.getSourceName();
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                n = i;
                break;
            }
            if (this.mIsCumulative) {
                return this.calculateCumulativeDistLineValue(embeddedSourceSpecification, n, d, elementSpecificationArray[0]);
            }
            return this.calculateProbDensityLineValue(embeddedSourceSpecification, n, d);
        }
        return 0.0;
    }

    public double[] getLineValuesAtPercent(double d) {
        DataSpecification[] dataSpecificationArray;
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        for (DataSpecification dataSpecification : dataSpecificationArray = visualizationSpecification.getDataSpecifications()) {
            EmbeddedSourceSpecification embeddedSourceSpecification;
            if (!(dataSpecification instanceof EmbeddedSourceSpecification) || "tableData".equals((embeddedSourceSpecification = (EmbeddedSourceSpecification)dataSpecification).getId())) continue;
            String[] stringArray = embeddedSourceSpecification.getNames();
            ElementSpecification[] elementSpecificationArray = (ElementSpecification[])visualizationSpecification.findDescendantsOfType(ElementSpecification.class);
            SourceVariableSpecification sourceVariableSpecification = (SourceVariableSpecification)elementSpecificationArray[0].getX();
            String string = sourceVariableSpecification.getSourceName();
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                n = i;
                break;
            }
            if (this.mIsCumulative) {
                return this.calculateCumulativeDistLineValues(embeddedSourceSpecification, n, d, elementSpecificationArray[0]);
            }
            return this.calculateProbDensityLineValues(embeddedSourceSpecification, n, d);
        }
        return new double[]{0.0};
    }

    public double getPercentAtLineValue(double d, boolean bl) {
        DataSpecification[] dataSpecificationArray;
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        for (DataSpecification dataSpecification : dataSpecificationArray = visualizationSpecification.getDataSpecifications()) {
            EmbeddedSourceSpecification embeddedSourceSpecification;
            if (!(dataSpecification instanceof EmbeddedSourceSpecification) || "tableData".equals((embeddedSourceSpecification = (EmbeddedSourceSpecification)dataSpecification).getId())) continue;
            String[] stringArray = embeddedSourceSpecification.getNames();
            ElementSpecification[] elementSpecificationArray = (ElementSpecification[])visualizationSpecification.findDescendantsOfType(ElementSpecification.class);
            SourceVariableSpecification sourceVariableSpecification = (SourceVariableSpecification)elementSpecificationArray[0].getX();
            String string = sourceVariableSpecification.getSourceName();
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                n = i;
                break;
            }
            if (this.mIsCumulative) {
                return this.calculateCumulativeDistPercent(embeddedSourceSpecification, n, d, elementSpecificationArray[0]);
            }
            return this.calculateProbDensityPercent(embeddedSourceSpecification, n, d, bl);
        }
        return 0.0;
    }

    public double[] getPercentAtLineValues(double d, boolean bl) {
        DataSpecification[] dataSpecificationArray;
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        for (DataSpecification dataSpecification : dataSpecificationArray = visualizationSpecification.getDataSpecifications()) {
            EmbeddedSourceSpecification embeddedSourceSpecification;
            if (!(dataSpecification instanceof EmbeddedSourceSpecification) || "tableData".equals((embeddedSourceSpecification = (EmbeddedSourceSpecification)dataSpecification).getId())) continue;
            String[] stringArray = embeddedSourceSpecification.getNames();
            ElementSpecification[] elementSpecificationArray = (ElementSpecification[])visualizationSpecification.findDescendantsOfType(ElementSpecification.class);
            SourceVariableSpecification sourceVariableSpecification = (SourceVariableSpecification)elementSpecificationArray[0].getX();
            String string = sourceVariableSpecification.getSourceName();
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                n = i;
                break;
            }
            if (this.mIsCumulative) {
                return this.calculateCumulativeDistPercents(embeddedSourceSpecification, n, d, elementSpecificationArray[0]);
            }
            return this.calculateProbDensityPercents(embeddedSourceSpecification, n, d, bl);
        }
        return new double[]{0.0};
    }

    public double getMean() {
        String string;
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        ExtensionSpecification[] extensionSpecificationArray = visualizationSpecification.getExtensionSpecifications();
        if (extensionSpecificationArray.length > 0 && (string = extensionSpecificationArray[0].get("mean")) != null && string.length() > 0) {
            return Double.parseDouble(string);
        }
        return this.getMeanFromData();
    }

    public double[] getMeans() {
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        ExtensionSpecification[] extensionSpecificationArray = visualizationSpecification.getExtensionSpecifications();
        int n = this.mLegendValueMap.size();
        if (extensionSpecificationArray.length > 0) {
            String string;
            String string2 = extensionSpecificationArray[0].get("means");
            if (string2 != null && string2.length() > 0) {
                String[] stringArray = string2.split(";");
                if (n == stringArray.length) {
                    double[] dArray = new double[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        dArray[i] = Double.parseDouble(stringArray[i]);
                    }
                    return dArray;
                }
            } else if (n == 1 && (string = extensionSpecificationArray[0].get("mean")) != null && string.length() > 0) {
                return new double[]{Double.parseDouble(string)};
            }
        }
        return this.getMeansFromData();
    }

    public double getMedian() {
        String string;
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        ExtensionSpecification[] extensionSpecificationArray = visualizationSpecification.getExtensionSpecifications();
        if (extensionSpecificationArray.length > 0 && (string = extensionSpecificationArray[0].get("median")) != null && string.length() > 0) {
            return Double.parseDouble(string);
        }
        return this.getMedianFromData();
    }

    public double[] getMedians() {
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        ExtensionSpecification[] extensionSpecificationArray = visualizationSpecification.getExtensionSpecifications();
        int n = this.mLegendValueMap.size();
        if (extensionSpecificationArray.length > 0) {
            String string;
            String string2 = extensionSpecificationArray[0].get("medians");
            if (string2 != null && string2.length() > 0) {
                String[] stringArray = string2.split(";");
                if (n == stringArray.length) {
                    double[] dArray = new double[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        dArray[i] = Double.parseDouble(stringArray[i]);
                    }
                    return dArray;
                }
            } else if (n == 1 && (string = extensionSpecificationArray[0].get("median")) != null && string.length() > 0) {
                return new double[]{Double.parseDouble(string)};
            }
        }
        return this.getMediansFromData();
    }

    public double[] getSigmas() {
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        ExtensionSpecification[] extensionSpecificationArray = visualizationSpecification.getExtensionSpecifications();
        int n = this.mLegendValueMap.size();
        if (extensionSpecificationArray.length > 0) {
            String string;
            String string2 = extensionSpecificationArray[0].get("stddevs");
            if (string2 != null && string2.length() > 0) {
                String[] stringArray = string2.split(";");
                if (n == stringArray.length) {
                    double[] dArray = new double[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        dArray[i] = Double.parseDouble(stringArray[i]);
                    }
                    return dArray;
                }
            } else if (n == 1 && (string = extensionSpecificationArray[0].get("stddev")) != null && string.length() > 0) {
                return new double[]{Double.parseDouble(string)};
            }
        }
        return this.getSigmasFromData();
    }

    public boolean isUpperLineInfinity() {
        return this.mIsUpperLineInfinity;
    }

    public void setUpperLineInfinity(boolean bl) {
        this.mIsUpperLineInfinity = bl;
    }

    public boolean isLowerLineInfinity() {
        return this.mIsLowerLineInfinity;
    }

    public void setLowerLineInfinity(boolean bl) {
        this.mIsLowerLineInfinity = bl;
    }

    public void updateLineLabel(LineGuideSpecification lineGuideSpecification, String string) {
        LabelSpecification labelSpecification;
        for (LabelSpecification labelSpecification2 : labelSpecification = lineGuideSpecification.getLabelSpecifications()) {
            labelSpecification2.getParent().remove((Specification)labelSpecification2);
        }
        LabelSpecification labelSpecification3 = new LabelSpecification(string);
        StyleSpecification styleSpecification = new StyleSpecification();
        styleSpecification.setTextAngle(Double.valueOf(270.0));
        styleSpecification.setTextAlignment(TextAlignmentType.LEFT);
        labelSpecification3.setStyle((TextStyle)styleSpecification);
        StyleSpecification styleSpecification2 = new StyleSpecification();
        styleSpecification2.setColor(Color.white);
        styleSpecification2.setSecondaryColor(Color.white);
        styleSpecification2.setPaddingLeft(new Length("1"));
        styleSpecification2.setPaddingRight(new Length("1"));
        labelSpecification3.setTextFrameStyle((FrameStyle)styleSpecification2);
        lineGuideSpecification.addLabel(labelSpecification3);
    }

    public boolean isCumulative() {
        return this.mIsCumulative;
    }

    public void updateVisLinesPos() {
        LineGuideSpecification[] lineGuideSpecificationArray;
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        for (LineGuideSpecification lineGuideSpecification : lineGuideSpecificationArray = (LineGuideSpecification[])visualizationSpecification.findDescendantsOfType(LineGuideSpecification.class)) {
            String string;
            double d;
            if (this.getGuideLineName(true).equals(lineGuideSpecification.getName())) {
                d = this.getGuideLineInfo(true).getValue();
                lineGuideSpecification.setX(new DataValue(d));
                string = this.displayPercent(this.getPercentAtLineValue(d, true)) + "%" + "=" + this.displayFormatValue(d) + this.getFirstIterLabel();
                this.updateLineLabel(lineGuideSpecification, string);
                continue;
            }
            if (!this.getGuideLineName(false).equals(lineGuideSpecification.getName())) continue;
            d = this.getGuideLineInfo(false).getValue();
            lineGuideSpecification.setX(new DataValue(d));
            string = this.displayPercent(this.getPercentAtLineValue(d, false)) + "%" + "=" + this.displayFormatValue(d) + this.getFirstIterLabel();
            this.updateLineLabel(lineGuideSpecification, string);
        }
    }

    public String displayPercent(double d) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setGroupingUsed(false);
        return numberFormat.format(d * 100.0);
    }

    public String getLegendTitle() {
        return this.mLegendTitle;
    }

    public void setLegendTitle(String string) {
        this.mLegendTitle = string;
    }

    public Map<Integer, String> getLegendValueMap() {
        return this.mLegendValueMap;
    }

    public void setLegendValueMap(Map<Integer, String> map) {
        this.mLegendValueMap = map;
    }

    public Map<Integer, Color> getColorMap() {
        return this.mColorMap;
    }

    public void setColorMap(Map<Integer, Color> map) {
        this.mColorMap = map;
    }

    /*
     * WARNING - void declaration
     */
    private double[][] getStatisticsData() {
        DataSpecification[] dataSpecificationArray;
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        for (DataSpecification dataSpecification : dataSpecificationArray = visualizationSpecification.getDataSpecifications()) {
            void var17_21;
            SourceVariableSpecification[] sourceVariableSpecificationArray;
            if (!(dataSpecification instanceof EmbeddedSourceSpecification)) continue;
            EmbeddedSourceSpecification embeddedSourceSpecification = (EmbeddedSourceSpecification)dataSpecification;
            String[] stringArray = embeddedSourceSpecification.getNames();
            ElementSpecification[] elementSpecificationArray = (ElementSpecification[])visualizationSpecification.findDescendantsOfType(ElementSpecification.class);
            SourceVariableSpecification sourceVariableSpecification = (SourceVariableSpecification)elementSpecificationArray[0].getX();
            String string = sourceVariableSpecification.getSourceName();
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                n = i;
                break;
            }
            Object[] objectArray = embeddedSourceSpecification.getData();
            double[] dArray = (double[])objectArray[n];
            SourceVariableSpecification stringArray2 = null;
            for (SourceVariableSpecification sourceVariableSpecification2 : sourceVariableSpecificationArray = (SourceVariableSpecification[])visualizationSpecification.findDescendantsOfType(SourceVariableSpecification.class)) {
                if (sourceVariableSpecification2.getWeight() == null || sourceVariableSpecification2.getWeight() != Boolean.TRUE) continue;
                stringArray2 = sourceVariableSpecification2;
                break;
            }
            double[] dArray2 = new double[dArray.length];
            if (stringArray2 != null) {
                Object object;
                int n2 = 0;
                string = stringArray2.getSourceName();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string.equals(stringArray[i])) continue;
                    n2 = i;
                    break;
                }
                if ((object = objectArray[n2]) instanceof String[]) {
                    String[] stringArray3 = (String[])object;
                    for (int i = 0; i < stringArray3.length; ++i) {
                        dArray2[i] = stringArray3[i] != null ? Double.parseDouble(stringArray3[i]) : 1.0;
                    }
                } else if (object instanceof double[]) {
                    double[] dArray3 = (double[])object;
                } else {
                    Arrays.fill(dArray2, 1.0);
                }
            } else {
                Arrays.fill(dArray2, 1.0);
            }
            return new double[][]{dArray, var17_21};
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private double[][] getStatisticsMultiIterData() {
        DataSpecification[] dataSpecificationArray;
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        for (DataSpecification dataSpecification : dataSpecificationArray = visualizationSpecification.getDataSpecifications()) {
            void var17_21;
            void var20_31;
            SourceVariableSpecification[] sourceVariableSpecificationArray;
            EmbeddedSourceSpecification embeddedSourceSpecification;
            if (!(dataSpecification instanceof EmbeddedSourceSpecification) || "tableData".equals((embeddedSourceSpecification = (EmbeddedSourceSpecification)dataSpecification).getId())) continue;
            String[] stringArray = embeddedSourceSpecification.getNames();
            ElementSpecification[] elementSpecificationArray = (ElementSpecification[])visualizationSpecification.findDescendantsOfType(ElementSpecification.class);
            SourceVariableSpecification sourceVariableSpecification = (SourceVariableSpecification)elementSpecificationArray[0].getX();
            String string = sourceVariableSpecification.getSourceName();
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                n = i;
                break;
            }
            Object[] objectArray = embeddedSourceSpecification.getData();
            double[] dArray = (double[])objectArray[n];
            SourceVariableSpecification stringArray2 = null;
            for (SourceVariableSpecification sourceVariableSpecification2 : sourceVariableSpecificationArray = (SourceVariableSpecification[])visualizationSpecification.findDescendantsOfType(SourceVariableSpecification.class)) {
                if (sourceVariableSpecification2.getWeight() == null || sourceVariableSpecification2.getWeight() != Boolean.TRUE) continue;
                stringArray2 = sourceVariableSpecification2;
                break;
            }
            double[] dArray2 = new double[dArray.length];
            if (stringArray2 != null) {
                Object object;
                int n2 = 0;
                string = stringArray2.getSourceName();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string.equals(stringArray[i])) continue;
                    n2 = i;
                    break;
                }
                if ((object = objectArray[n2]) instanceof String[]) {
                    String[] stringArray3 = (String[])object;
                    for (int i = 0; i < stringArray3.length; ++i) {
                        dArray2[i] = stringArray3[i] != null ? Double.parseDouble(stringArray3[i]) : 1.0;
                    }
                } else if (object instanceof double[]) {
                    double[] dArray3 = (double[])object;
                } else {
                    Arrays.fill(dArray2, 1.0);
                }
            } else {
                Arrays.fill(dArray2, 1.0);
            }
            double[] dArray4 = new double[dArray.length];
            int n3 = -1;
            boolean bl = false;
            while (var20_31 < stringArray.length) {
                if ("legend".equalsIgnoreCase(stringArray[var20_31])) {
                    n3 = var20_31;
                    break;
                }
                ++var20_31;
            }
            if (n3 >= 0) {
                Object object = objectArray[n3];
                if (object instanceof String[]) {
                    String[] stringArray4 = (String[])object;
                    for (int i = 0; i < stringArray4.length; ++i) {
                        dArray4[i] = stringArray4[i] != null ? Double.parseDouble(stringArray4[i]) : 1.0;
                    }
                } else if (object instanceof double[]) {
                    dArray4 = (double[])object;
                } else {
                    Arrays.fill((double[])var17_21, 0.0);
                }
            } else {
                Arrays.fill(dArray4, 0.0);
            }
            return new double[][]{dArray, var17_21, dArray4};
        }
        return null;
    }

    private double[][] getStatisticsMultiIterDataForCumulative() {
        DataSpecification[] dataSpecificationArray;
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        for (DataSpecification dataSpecification : dataSpecificationArray = visualizationSpecification.getDataSpecifications()) {
            Object object;
            Specification specification;
            EmbeddedSourceSpecification embeddedSourceSpecification;
            if (!(dataSpecification instanceof EmbeddedSourceSpecification) || "tableData".equals((embeddedSourceSpecification = (EmbeddedSourceSpecification)dataSpecification).getId())) continue;
            String[] stringArray = embeddedSourceSpecification.getNames();
            ElementSpecification[] elementSpecificationArray = (ElementSpecification[])visualizationSpecification.findDescendantsOfType(ElementSpecification.class);
            SourceVariableSpecification sourceVariableSpecification = (SourceVariableSpecification)elementSpecificationArray[0].getX();
            String string = sourceVariableSpecification.getSourceName();
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                n = i;
                break;
            }
            Object[] objectArray = embeddedSourceSpecification.getData();
            double[] dArray = (double[])objectArray[n];
            SourceVariableSpecification sourceVariableSpecification2 = null;
            ExtensionSpecification[] extensionSpecificationArray = visualizationSpecification.getExtensionSpecifications();
            if (extensionSpecificationArray.length > 0 && (specification = visualizationSpecification.getSpecification((String)(object = (Object)extensionSpecificationArray[0].get(ASCENDING_KEY)))) instanceof VariableSpecification) {
                sourceVariableSpecification2 = (SourceVariableSpecification)specification;
            }
            object = new double[dArray.length];
            if (sourceVariableSpecification2 != null) {
                Object object2;
                int n2 = 0;
                string = sourceVariableSpecification2.getSourceName();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string.equals(stringArray[i])) continue;
                    n2 = i;
                    break;
                }
                if ((object2 = objectArray[n2]) instanceof String[]) {
                    String[] stringArray2 = (String[])object2;
                    for (int i = 0; i < stringArray2.length; ++i) {
                        object[i] = stringArray2[i] != null ? Double.parseDouble(stringArray2[i]) : 1.0;
                    }
                } else if (object2 instanceof double[]) {
                    object = (double[])object2;
                } else {
                    Arrays.fill(object, 1.0);
                }
            } else {
                Arrays.fill(object, 1.0);
            }
            double[] dArray2 = new double[dArray.length];
            int n3 = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!"legend".equalsIgnoreCase(stringArray[i])) continue;
                n3 = i;
                break;
            }
            if (n3 >= 0) {
                Object object3 = objectArray[n3];
                if (object3 instanceof String[]) {
                    String[] stringArray3 = (String[])object3;
                    for (int i = 0; i < stringArray3.length; ++i) {
                        dArray2[i] = stringArray3[i] != null ? Double.parseDouble(stringArray3[i]) : 1.0;
                    }
                } else if (object3 instanceof double[]) {
                    dArray2 = (double[])object3;
                } else {
                    Arrays.fill(object, 0.0);
                }
            } else {
                Arrays.fill(dArray2, 0.0);
            }
            return new double[][]{dArray, object, dArray2};
        }
        return null;
    }

    private void loadGuideLineIds() {
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        ExtensionSpecification[] extensionSpecificationArray = visualizationSpecification.getExtensionSpecifications();
        if (extensionSpecificationArray.length > 0) {
            this.mLowerGuideName = extensionSpecificationArray[0].get("lowerSlider");
            this.mUpperGuideName = extensionSpecificationArray[0].get("upperSlider");
        }
    }

    private double getMeanFromData() {
        double[][] dArray = this.getStatisticsData();
        if (dArray != null) {
            double[] dArray2 = dArray[0];
            double[] dArray3 = dArray[1];
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < dArray2.length; ++i) {
                d += dArray2[i] * dArray3[i];
                d2 += dArray3[i];
            }
            if (d2 > 0.0) {
                return d / d2;
            }
        }
        return 0.0;
    }

    private double[] getMeansFromData() {
        double[][] dArray = this.getStatisticsMultiIterData();
        if (dArray != null && dArray.length == 3) {
            int n;
            double[] dArray2 = dArray[0];
            double[] dArray3 = dArray[1];
            double[] dArray4 = dArray[2];
            int n2 = (int)dArray4[dArray4.length - 1] + 1;
            double[] dArray5 = new double[n2];
            double[] dArray6 = new double[n2];
            for (n = 0; n < dArray2.length; ++n) {
                int n3 = (int)dArray4[n];
                dArray5[n3] = dArray5[n3] + dArray2[n] * dArray3[n];
                int n4 = (int)dArray4[n];
                dArray6[n4] = dArray6[n4] + dArray3[n];
            }
            for (n = 0; n < n2; ++n) {
                if (!(dArray6[n] > 0.0)) continue;
                dArray5[n] = dArray5[n] / dArray6[n];
            }
            return dArray5;
        }
        return new double[]{0.0};
    }

    private double getMedianFromData() {
        double d = 0.0;
        double[][] dArray = this.getStatisticsData();
        if (dArray != null) {
            double[] dArray2 = dArray[0];
            double[] dArray3 = dArray[1];
            double d2 = 0.0;
            TreeMap<Double, Double> treeMap = new TreeMap<Double, Double>();
            for (int i = 0; i < dArray2.length; ++i) {
                treeMap.put(dArray2[i], dArray3[i]);
                d2 += dArray3[i];
            }
            double d3 = 0.0;
            Set set = treeMap.keySet();
            for (Double d4 : set) {
                if (!((d3 += ((Double)treeMap.get(d4)).doubleValue()) > d2 / 2.0)) continue;
                d = d4;
                break;
            }
        }
        return d;
    }

    private double[] getMediansFromData() {
        double[][] dArray = this.getStatisticsMultiIterData();
        if (dArray != null && dArray.length == 3) {
            double[] dArray2 = dArray[0];
            double[] dArray3 = dArray[1];
            double[] dArray4 = dArray[2];
            if (dArray4 == null) {
                double d = 0.0;
                TreeMap<Double, Double> treeMap = new TreeMap<Double, Double>();
                for (int i = 0; i < dArray2.length; ++i) {
                    treeMap.put(dArray2[i], dArray3[i]);
                    d += dArray3[i];
                }
                double[] dArray5 = new double[1];
                double d2 = 0.0;
                Set set = treeMap.keySet();
                for (Double d3 : set) {
                    if (!((d2 += ((Double)treeMap.get(d3)).doubleValue()) > d / 2.0)) continue;
                    dArray5[0] = d3;
                    break;
                }
                return dArray5;
            }
            int n = (int)dArray4[dArray4.length - 1] + 1;
            TreeMap[] treeMapArray = new TreeMap[n];
            for (int i = 0; i < treeMapArray.length; ++i) {
                treeMapArray[i] = new TreeMap();
            }
            double[] dArray6 = new double[n];
            for (int i = 0; i < dArray2.length; ++i) {
                treeMapArray[(int)dArray4[i]].put(dArray2[i], dArray3[i]);
                int n2 = (int)dArray4[i];
                dArray6[n2] = dArray6[n2] + dArray3[i];
            }
            double[] dArray7 = new double[n];
            block4: for (int i = 0; i < n; ++i) {
                double d = 0.0;
                Set set = treeMapArray[i].keySet();
                for (Double d4 : set) {
                    if (!((d += ((Double)treeMapArray[i].get(d4)).doubleValue()) > dArray6[(int)dArray4[i]] / 2.0)) continue;
                    dArray7[i] = d4;
                    continue block4;
                }
            }
            return dArray7;
        }
        return new double[]{0.0};
    }

    private double[] getSigmasFromData() {
        double[][] dArray = this.getStatisticsMultiIterData();
        if (dArray != null) {
            int n;
            double[] dArray2 = this.getMeans();
            double[] dArray3 = dArray[0];
            double[] dArray4 = dArray[1];
            double[] dArray5 = dArray[2];
            int n2 = (int)dArray5[dArray5.length - 1] + 1;
            double[] dArray6 = new double[n2];
            double[] dArray7 = new double[n2];
            for (n = 0; n < dArray3.length; ++n) {
                int n3 = (int)dArray5[n];
                dArray7[n3] = dArray7[n3] + dArray4[n];
            }
            for (n = 0; n < dArray3.length; ++n) {
                int n4 = (int)dArray5[n];
                dArray6[n4] = dArray6[n4] + dArray4[n] * (dArray3[n] - dArray2[(int)dArray5[n]]) * (dArray3[n] - dArray2[(int)dArray5[n]]) / dArray7[(int)dArray5[n]];
            }
            double[] dArray8 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray8[i] = Math.sqrt(dArray6[i]);
            }
            return dArray8;
        }
        return new double[]{0.0};
    }

    private double calculateCumulativeDistPercent(EmbeddedSourceSpecification embeddedSourceSpecification, int n, double d, ElementSpecification elementSpecification) {
        return this.calculateCumulativeDistPercents(embeddedSourceSpecification, n, d, elementSpecification)[0];
    }

    private double[] calculateCumulativeDistPercents(EmbeddedSourceSpecification embeddedSourceSpecification, int n, double d, ElementSpecification elementSpecification) {
        int n2;
        SourceVariableSpecification[] sourceVariableSpecificationArray;
        Object object;
        Object object2;
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        VariableSpecification variableSpecification = elementSpecification.getY();
        boolean bl = true;
        if (variableSpecification instanceof DerivedVariableSpecification) {
            bl = false;
        }
        SourceVariableSpecification sourceVariableSpecification = null;
        ExtensionSpecification[] extensionSpecificationArray = visualizationSpecification.getExtensionSpecifications();
        if (extensionSpecificationArray.length > 0 && (object2 = (Object)visualizationSpecification.getSpecification((String)(object = extensionSpecificationArray[0].get(ASCENDING_KEY)))) instanceof VariableSpecification) {
            sourceVariableSpecification = (SourceVariableSpecification)object2;
        }
        object = embeddedSourceSpecification.getData();
        object2 = (double[])object[n];
        double[] dArray = this.getWeightData(embeddedSourceSpecification, sourceVariableSpecification, (double[])object2);
        if (((Object[])object).length == 2) {
            for (int i = 0; i < ((double[])object2).length; ++i) {
                if (!(d <= object2[i])) continue;
                if (bl) {
                    return new double[]{dArray[i]};
                }
                return new double[]{1.0 - dArray[i]};
            }
            if (bl) {
                return new double[]{dArray[dArray.length - 1]};
            }
            return new double[]{1.0 - dArray[dArray.length - 1]};
        }
        SourceVariableSpecification sourceVariableSpecification2 = null;
        for (SourceVariableSpecification n4 : sourceVariableSpecificationArray = (SourceVariableSpecification[])visualizationSpecification.findDescendantsOfType(SourceVariableSpecification.class)) {
            if (!this.targetId.equalsIgnoreCase(n4.getId())) continue;
            sourceVariableSpecification2 = n4;
            break;
        }
        String[] stringArray = embeddedSourceSpecification.getNames();
        int n3 = 0;
        for (int stringArray2 = 0; stringArray2 < stringArray.length; ++stringArray2) {
            if (!sourceVariableSpecification2.getSourceName().equals(stringArray[stringArray2])) continue;
            n3 = stringArray2;
            break;
        }
        String[] stringArray3 = (String[])object[n3];
        int n4 = 1 + Integer.parseInt(stringArray3[stringArray3.length - 1]);
        double[] dArray2 = new double[n4];
        for (int dArray3 = 0; dArray3 < ((double[])object2).length; ++dArray3) {
            n2 = Integer.parseInt(stringArray3[dArray3]);
            if (!(object2[dArray3] <= d)) continue;
            dArray2[n2] = dArray[dArray3];
        }
        double[] dArray3 = new double[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            dArray3[n2] = bl ? dArray2[n2] : 1.0 - dArray2[n2];
        }
        return dArray3;
    }

    private double[] calculateProbDensityPercents(EmbeddedSourceSpecification embeddedSourceSpecification, int n, double d, boolean bl) {
        int n2;
        SourceVariableSpecification d22;
        SourceVariableSpecification[] sourceVariableSpecificationArray;
        SourceVariableSpecification sourceVariableSpecification2 = null;
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        for (SourceVariableSpecification d22 : sourceVariableSpecificationArray = (SourceVariableSpecification[])visualizationSpecification.findDescendantsOfType(SourceVariableSpecification.class)) {
            if (d22.getWeight() == null || d22.getWeight() != Boolean.TRUE) continue;
            sourceVariableSpecification2 = d22;
            break;
        }
        Object[] objectArray = embeddedSourceSpecification.getData();
        double[] dArray = (double[])objectArray[n];
        double[] dArray2 = this.getWeightData(embeddedSourceSpecification, sourceVariableSpecification2, dArray);
        if (objectArray.length == 2) {
            double d3 = 0.0;
            double n3 = 0.0;
            for (int sourceVariableSpecification4 = 0; sourceVariableSpecification4 < dArray.length; ++sourceVariableSpecification4) {
                if (bl) {
                    if (dArray[sourceVariableSpecification4] < d) {
                        d3 += dArray2[sourceVariableSpecification4];
                    }
                } else if (dArray[sourceVariableSpecification4] <= d) {
                    d3 += dArray2[sourceVariableSpecification4];
                }
                n3 += dArray2[sourceVariableSpecification4];
            }
            if (n3 > 0.0) {
                return new double[]{d3 / n3};
            }
            return new double[]{0.0};
        }
        d22 = null;
        for (SourceVariableSpecification n4 : sourceVariableSpecificationArray) {
            if (!this.targetId.equalsIgnoreCase(n4.getId())) continue;
            d22 = n4;
            break;
        }
        String[] stringArray = embeddedSourceSpecification.getNames();
        int n3 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!d22.getSourceName().equals(stringArray[i])) continue;
            n3 = i;
            break;
        }
        String[] stringArray2 = (String[])objectArray[n3];
        int n4 = 1 + Integer.parseInt(stringArray2[stringArray2.length - 1]);
        double[] dArray3 = new double[n4];
        double[] dArray4 = new double[n4];
        for (int i = 0; i < dArray.length; ++i) {
            n2 = Integer.parseInt(stringArray2[i]);
            if (dArray[i] <= d) {
                int n5 = n2;
                dArray3[n5] = dArray3[n5] + dArray2[i];
            }
            int n6 = n2;
            dArray4[n6] = dArray4[n6] + dArray2[i];
        }
        double[] dArray5 = new double[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            if (!(dArray4[n2] > 0.0)) continue;
            dArray5[n2] = dArray3[n2] / dArray4[n2];
        }
        return dArray5;
    }

    private double calculateProbDensityPercent(EmbeddedSourceSpecification embeddedSourceSpecification, int n, double d, boolean bl) {
        return this.calculateProbDensityPercents(embeddedSourceSpecification, n, d, bl)[0];
    }

    private double calculateCumulativeDistLineValue(EmbeddedSourceSpecification embeddedSourceSpecification, int n, double d, ElementSpecification elementSpecification) {
        Object object;
        Object object2;
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        VariableSpecification variableSpecification = elementSpecification.getY();
        boolean bl = true;
        if (variableSpecification instanceof DerivedVariableSpecification) {
            bl = false;
        }
        SourceVariableSpecification sourceVariableSpecification = null;
        ExtensionSpecification[] extensionSpecificationArray = visualizationSpecification.getExtensionSpecifications();
        if (extensionSpecificationArray.length > 0 && (object2 = (Object)visualizationSpecification.getSpecification((String)(object = extensionSpecificationArray[0].get(ASCENDING_KEY)))) instanceof VariableSpecification) {
            sourceVariableSpecification = (SourceVariableSpecification)object2;
        }
        object = embeddedSourceSpecification.getData();
        object2 = (double[])object[n];
        double[] dArray = this.getWeightData(embeddedSourceSpecification, sourceVariableSpecification, (double[])object2);
        for (int i = 0; i < dArray.length; ++i) {
            if (!(bl ? d <= dArray[i] : 1.0 - d <= dArray[i])) continue;
            return object2[i];
        }
        return object2[((double[])object2).length - 1];
    }

    private double calculateProbDensityLineValue(EmbeddedSourceSpecification embeddedSourceSpecification, int n, double d) {
        SourceVariableSpecification[] sourceVariableSpecificationArray;
        SourceVariableSpecification valueWeightPairArray2 = null;
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        for (SourceVariableSpecification sourceVariableSpecification : sourceVariableSpecificationArray = (SourceVariableSpecification[])visualizationSpecification.findDescendantsOfType(SourceVariableSpecification.class)) {
            if (sourceVariableSpecification.getWeight() == null || sourceVariableSpecification.getWeight() != Boolean.TRUE) continue;
            valueWeightPairArray2 = sourceVariableSpecification;
            break;
        }
        Object[] objectArray = embeddedSourceSpecification.getData();
        double[] dArray = (double[])objectArray[n];
        double[] dArray2 = this.getWeightData(embeddedSourceSpecification, valueWeightPairArray2, dArray);
        ValueWeightPair[] valueWeightPairArray = new ValueWeightPair[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            valueWeightPairArray[i] = new ValueWeightPair(dArray[i], dArray2[i]);
        }
        Arrays.sort(valueWeightPairArray, new ValueWeightPair.ValueWeightComparator());
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += dArray2[i];
        }
        double d3 = d * d2;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < valueWeightPairArray.length; ++i) {
            if (!((d4 += valueWeightPairArray[i].getWeight()) >= d3)) continue;
            d5 = valueWeightPairArray[i].getValue();
            break;
        }
        return d5;
    }

    private double[] calculateCumulativeDistLineValues(EmbeddedSourceSpecification embeddedSourceSpecification, int n, double d, ElementSpecification elementSpecification) {
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        VariableSpecification variableSpecification = elementSpecification.getY();
        boolean bl = true;
        if (variableSpecification instanceof DerivedVariableSpecification) {
            bl = false;
        }
        double[][] dArray = this.getStatisticsMultiIterDataForCumulative();
        double[] dArray2 = dArray[0];
        double[] dArray3 = dArray[1];
        double[] dArray4 = dArray[2];
        int n2 = (int)dArray4[dArray4.length - 1] + 1;
        double[] dArray5 = new double[n2];
        block0: for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < dArray3.length; ++j) {
                if ((double)i != dArray4[j]) continue;
                if (bl) {
                    if (!(d <= dArray3[j])) continue;
                    dArray5[i] = dArray2[j];
                    continue block0;
                }
                if (!(1.0 - d <= dArray3[j])) continue;
                dArray5[i] = dArray2[j];
                continue block0;
            }
        }
        return dArray5;
    }

    private double[] calculateProbDensityLineValues(EmbeddedSourceSpecification embeddedSourceSpecification, int n, double d) {
        double[][] dArray = this.getStatisticsMultiIterData();
        double[] dArray2 = dArray[0];
        double[] dArray3 = dArray[1];
        double[] dArray4 = dArray[2];
        int n2 = (int)dArray4[dArray4.length - 1] + 1;
        double[] dArray5 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray5[i] = this.findLineValueAtPercent(dArray2, dArray3, dArray4, d, i);
        }
        return dArray5;
    }

    private double findLineValueAtPercent(double[] dArray, double[] dArray2, double[] dArray3, double d, int n) {
        double d2 = 0.0;
        ArrayList<ValueWeightPair> arrayList = new ArrayList<ValueWeightPair>();
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray3[i] != (double)n) continue;
            arrayList.add(new ValueWeightPair(dArray[i], dArray2[i]));
            d2 += dArray2[i];
        }
        Collections.sort(arrayList, new ValueWeightPair.ValueWeightComparator());
        double d3 = d * d2;
        double d4 = 0.0;
        double d5 = 0.0;
        ValueWeightPair valueWeightPair = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            valueWeightPair = (ValueWeightPair)arrayList.get(i);
            if (!((d4 += valueWeightPair.getWeight()) >= d3)) continue;
            d5 = valueWeightPair.getValue();
            break;
        }
        return d5;
    }

    private double[] getWeightData(EmbeddedSourceSpecification embeddedSourceSpecification, SourceVariableSpecification sourceVariableSpecification, double[] dArray) {
        Object[] objectArray = embeddedSourceSpecification.getData();
        String[] stringArray = embeddedSourceSpecification.getNames();
        double[] dArray2 = new double[dArray.length];
        if (sourceVariableSpecification != null) {
            Object object;
            int n = 0;
            String string = sourceVariableSpecification.getSourceName();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                n = i;
                break;
            }
            if ((object = objectArray[n]) instanceof String[]) {
                String[] stringArray2 = (String[])object;
                for (int i = 0; i < stringArray2.length; ++i) {
                    dArray2[i] = stringArray2[i] != null ? Double.parseDouble(stringArray2[i]) : 1.0;
                }
            } else if (object instanceof double[]) {
                dArray2 = (double[])object;
            } else {
                Arrays.fill(dArray2, 1.0);
            }
        } else {
            Arrays.fill(dArray2, 1.0);
        }
        return dArray2;
    }

    private String getFirstIterLabel() {
        Map<Integer, String> map;
        String string = " (";
        String string2 = this.getLegendTitle();
        if (string2.endsWith("*")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((map = this.getLegendValueMap()).size() > 0) {
            string = string + string2 + "=" + map.get(0);
        }
        string = string + ")";
        return string;
    }
}

