/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive;

import com.spss.java_client.ui.interactive.GraphboardFactory;
import com.spss.java_client.ui.interactive.ScaleTargetDetailPanel;
import com.spss.java_client.ui.interactive.ScaleTargetFeedbackCanvas;
import com.spss.java_client.ui.interactive.ScaleTargetMediator;
import com.spss.vis.ResultsProcessor;
import com.spss.vis.Visualization;
import com.spss.vis.component.VisualizationComponent;
import com.spss.vis.component.hit.HitProcessor;
import com.spss.vis.exception.VisualizationException;
import com.spss.vis.graphboard.vismodel.NviznModelEvent;
import com.spss.vis.graphboard.vismodel.NviznModelEventListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ScaleTargetInteractivePanel
extends JPanel
implements NviznModelEventListener {
    private VisualizationComponent mVisComp;
    private int mPrefWidth;
    private int mPrefHeight;
    private int mImageHeight;
    private ScaleTargetMediator mMediator;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 1989, 2013.\n\n";
    }

    public ScaleTargetInteractivePanel(VisualizationComponent visualizationComponent) {
        this.mVisComp = visualizationComponent;
        try {
            this.init();
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.mPrefWidth, this.mPrefHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws VisualizationException {
        Object object;
        Object object22;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        boolean bl = false;
        Visualization visualization = this.mVisComp.getVisualization();
        HitProcessor hitProcessor = new HitProcessor(true, true);
        Object object3 = visualization;
        synchronized (object3) {
            visualization.runProcessor((ResultsProcessor)hitProcessor);
        }
        object3 = null;
        Rectangle rectangle = null;
        Collection collection = this.mVisComp.getHits(true);
        for (Object object22 : collection) {
            Shape[] shapeArray;
            if ("graph".equals(object22.getType())) {
                shapeArray = object22.getShapes();
                rectangle = shapeArray[0].getBounds();
                break;
            }
            if (!"visualization".equals(object22.getType())) continue;
            shapeArray = object22.getShapes();
            object3 = shapeArray[0].getBounds();
        }
        Object object4 = null;
        for (Shape[] shapeArray : collection) {
            if (!"graph".equals(shapeArray.getType()) || !"cell".equals(shapeArray.getSubType())) continue;
            object = shapeArray.getShapes();
            object4 = object[0].getBounds();
            break;
        }
        this.mImageHeight = object3.height;
        this.refreshPreferedSize();
        object22 = new ScaleTargetFeedbackCanvas(this.mVisComp);
        ((JComponent)object22).setPreferredSize(new Dimension(object3.width, (int)rectangle.getMaxY() - 1));
        ((ScaleTargetFeedbackCanvas)object22).setInnerChartRect((Rectangle)object4);
        int n = 0;
        ScaleTargetInteractivePanel.addUsingGBL(this, (JComponent)object22, gridBagConstraints, 0, 0, 1, 1, 23, new Insets(n, n, n, n));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        object = new ScaleTargetDetailPanel(this.mVisComp);
        ((JComponent)object).setPreferredSize(new Dimension(object3.width, (int)((double)object3.height - rectangle.getMaxY())));
        ScaleTargetInteractivePanel.addUsingGBL(this, (JComponent)object, gridBagConstraints, 0, 1, 1, 1, 23, new Insets(1, n, n, n));
        this.mMediator = new ScaleTargetMediator(this.mVisComp, (ScaleTargetFeedbackCanvas)object22, (ScaleTargetDetailPanel)object);
        GraphboardFactory.createGraphboard().getModel().addListener((NviznModelEventListener)this);
    }

    private void refreshPreferedSize() {
        if (GraphboardFactory.createGraphboard().isEditEnabled()) {
            this.mPrefWidth = 2;
            this.mPrefHeight = 2;
        } else {
            this.mPrefWidth = this.mVisComp.getJComponent().getWidth();
            this.mPrefHeight = this.mImageHeight;
        }
    }

    public void modelChanged(NviznModelEvent nviznModelEvent) {
        if (nviznModelEvent.getType() == NviznModelEvent.HIT_CHANGE || nviznModelEvent.getType() == NviznModelEvent.EDIT_MODE_CHANGED) {
            this.refreshPreferedSize();
            this.invalidate();
            this.repaint();
        }
    }

    public static void addUsingGBL(Container container, JComponent jComponent, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, Insets insets) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.insets = insets == null ? new Insets(0, 0, 0, 0) : insets;
        container.add((Component)jComponent, gridBagConstraints);
    }
}

