/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive;

import com.spss.java_client.ui.interactive.ScaleTargetMediator;
import com.spss.vis.ItemInfo;
import com.spss.vis.ResultsProcessor;
import com.spss.vis.component.VisualizationComponent;
import com.spss.vis.exception.VisualizationException;
import com.spss.vis.processors.picking.InformationProcessor;
import com.spss.vis.specification.ExtensionSpecification;
import com.spss.vis.specification.VisualizationSpecification;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class ScaleTargetFeedbackCanvas
extends JPanel
implements MouseListener,
MouseMotionListener,
ActionListener {
    private Color mTransparent = new Color(0, 0, 0, 0);
    private ScaleTargetMediator mMediator;
    private final VisualizationComponent mVisComp;
    private boolean mIsFirstLineSelected = true;
    private boolean mAnySelection = false;
    private Rectangle mInnerChartRect;
    private int mOffset;
    private final int TRIANGLE_HEIGHT = 13;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 1989, 2013.\n\n";
    }

    public ScaleTargetFeedbackCanvas(VisualizationComponent visualizationComponent) {
        this.mVisComp = visualizationComponent;
        this.init();
    }

    public void setMediator(ScaleTargetMediator scaleTargetMediator) {
        this.mMediator = scaleTargetMediator;
    }

    private void init() {
        this.setOpaque(false);
        this.addActions();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.mMediator == null) {
            return;
        }
        if (this.mMediator.getGuideLineInfo(true).getInfo() == null || this.mMediator.getGuideLineInfo(false).getInfo() == null) {
            try {
                this.mMediator.loadLineValues(false);
                this.mMediator.updateTable();
            }
            catch (VisualizationException visualizationException) {
                visualizationException.printStackTrace();
            }
        }
        if (this.mIsFirstLineSelected) {
            if (this.mMediator.getGuideLineInfo(false).getInfo() != null && !this.mMediator.isUpperLineInfinity() && this.mMediator.isValidValue(false) && this.mMediator.getGuideLineInfo(false).getInfo().getShapes() != null) {
                this.drawGuideLine(graphics2D, this.mMediator.getGuideLineInfo(false).getXCoorPos(), this.mMediator.displayFormatValue(this.mMediator.getGuideLineInfo(false).getValue()));
            }
            if (this.mMediator.getGuideLineInfo(true).getInfo() != null && !this.mMediator.isLowerLineInfinity() && this.mMediator.isValidValue(true) && this.mMediator.getGuideLineInfo(true).getInfo().getShapes() != null) {
                this.drawGuideLine(graphics2D, this.mMediator.getGuideLineInfo(true).getXCoorPos(), this.mMediator.displayFormatValue(this.mMediator.getGuideLineInfo(true).getValue()));
            }
        } else {
            if (this.mMediator.getGuideLineInfo(true).getInfo() != null && !this.mMediator.isLowerLineInfinity() && this.mMediator.isValidValue(true) && this.mMediator.getGuideLineInfo(true).getInfo().getShapes() != null) {
                this.drawGuideLine(graphics2D, this.mMediator.getGuideLineInfo(true).getXCoorPos(), this.mMediator.displayFormatValue(this.mMediator.getGuideLineInfo(true).getValue()));
            }
            if (this.mMediator.getGuideLineInfo(false).getInfo() != null && !this.mMediator.isUpperLineInfinity() && this.mMediator.isValidValue(false) && this.mMediator.getGuideLineInfo(false).getInfo().getShapes() != null) {
                this.drawGuideLine(graphics2D, this.mMediator.getGuideLineInfo(false).getXCoorPos(), this.mMediator.displayFormatValue(this.mMediator.getGuideLineInfo(false).getValue()));
            }
        }
    }

    private void drawGuideLine(Graphics2D graphics2D, int n, String string) {
        Rectangle rectangle = this.mMediator.getGuideLineInfo(false).getInfo().getShapes()[0].getBounds();
        Color color = graphics2D.getColor();
        Paint paint = graphics2D.getPaint();
        graphics2D.setColor(Color.darkGray);
        graphics2D.drawLine(n, rectangle.y, n, rectangle.y + rectangle.height);
        Shape shape = this.getTriangleHandler(n, rectangle.y);
        graphics2D.fill(shape);
        graphics2D.setColor(this.mTransparent);
        Rectangle2D rectangle2D = graphics2D.getFont().getStringBounds(string, graphics2D.getFontRenderContext());
        Rectangle rectangle2 = new Rectangle(n - (int)(rectangle2D.getWidth() / 2.0) - 2, rectangle.y - 13 - 3 - (int)rectangle2D.getHeight(), (int)rectangle2D.getWidth() + 4, (int)rectangle2D.getHeight() + 3);
        graphics2D.fill(rectangle2);
        graphics2D.setColor(Color.darkGray);
        graphics2D.drawString(string, n - (int)(rectangle2D.getWidth() / 2.0) - 1, rectangle.y - 13 - 1);
        graphics2D.setColor(color);
        graphics2D.setPaint(paint);
    }

    private void addActions() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (point.x < this.mInnerChartRect.x || (double)point.x > this.mInnerChartRect.getMaxX()) {
            return;
        }
        int n = this.mMediator.getGuideLineInfo(true).getXCoorPos();
        int n2 = this.mMediator.getGuideLineInfo(false).getXCoorPos();
        Rectangle rectangle = this.mMediator.getGuideLineInfo(true).getInfo().getShapes()[0].getBounds();
        Rectangle rectangle2 = this.mMediator.getGuideLineInfo(false).getInfo().getShapes()[0].getBounds();
        if (point.x >= n - 1 && point.x <= n + 1 || point.x >= n2 - 1 && point.x <= n2 + 1 || this.getTriangleHandler(n, rectangle.y).contains(point) || this.getTriangleHandler(n2, rectangle2.y).contains(point)) {
            ((JPanel)mouseEvent.getSource()).setCursor(Cursor.getPredefinedCursor(12));
            this.mAnySelection = true;
            if (point.x >= n - 1 && point.x <= n + 1 || this.getTriangleHandler(n, rectangle.y).contains(point)) {
                this.mIsFirstLineSelected = true;
                this.mOffset = n - point.x;
            } else {
                this.mIsFirstLineSelected = false;
                this.mOffset = n2 - point.x;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        ((JPanel)mouseEvent.getSource()).setCursor(Cursor.getPredefinedCursor(0));
        this.mAnySelection = false;
        this.mMediator.updateVisLinesPos();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.mAnySelection) {
            Point point = mouseEvent.getPoint();
            point.translate(this.mOffset, 0);
            if (point.x <= this.mInnerChartRect.x || (double)point.x >= this.mInnerChartRect.getMaxX()) {
                return;
            }
            if (this.mInnerChartRect != null && point.y < this.mInnerChartRect.y) {
                point = new Point(point.x, this.mInnerChartRect.y + 2);
            }
            if (this.mInnerChartRect != null && (double)point.y > this.mInnerChartRect.getMaxY()) {
                point = new Point(point.x, (int)this.mInnerChartRect.getMaxY() - 2);
            }
            boolean bl = false;
            boolean bl2 = false;
            VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
            ExtensionSpecification[] extensionSpecificationArray = visualizationSpecification.getExtensionSpecifications();
            if (extensionSpecificationArray.length > 0) {
                String string = extensionSpecificationArray[0].get("lowerinfinity");
                String string2 = extensionSpecificationArray[0].get("upperinfinity");
                if (string != null && "true".equals(string)) {
                    bl = true;
                } else if (string2 != null && "true".equals(string2)) {
                    bl2 = true;
                }
            }
            if (this.mIsFirstLineSelected) {
                if (point.x >= this.mMediator.getGuideLineInfo(false).getXCoorPos() && !bl2) {
                    return;
                }
                this.mMediator.getGuideLineInfo(true).setXCoorPos(point.x);
                this.mMediator.getGuideLineInfo(true).setValue(this.getDataValueAtPoint(point));
            } else {
                if (point.x <= this.mMediator.getGuideLineInfo(true).getXCoorPos() && !bl) {
                    return;
                }
                this.mMediator.getGuideLineInfo(false).setXCoorPos(point.x);
                this.mMediator.getGuideLineInfo(false).setValue(this.getDataValueAtPoint(point));
            }
            this.mMediator.updateTable();
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void setInnerChartRect(Rectangle rectangle) {
        this.mInnerChartRect = rectangle;
    }

    private double getDataValueAtPoint(Point point) {
        String[] stringArray;
        InformationProcessor informationProcessor = InformationProcessor.getCoordinatesPickingProcessor((Point2D)point);
        try {
            this.mVisComp.getVisualization().runProcessor((ResultsProcessor)informationProcessor);
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
        ItemInfo[] itemInfoArray = informationProcessor.getItems();
        if (itemInfoArray.length > 0 && (stringArray = (String[])itemInfoArray[0].get(ItemInfo.COORDINATES_KEY)) != null && stringArray.length > 0) {
            return Double.parseDouble(stringArray[0]);
        }
        return 0.0;
    }

    private Shape getTriangleHandler(int n, int n2) {
        Polygon polygon = new Polygon();
        polygon.addPoint(n, n2 - 1);
        polygon.addPoint(n - 6, n2 - 13);
        polygon.addPoint(n + 6, n2 - 13);
        return polygon;
    }
}

