/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive;

import com.spss.charteditor.util.ResUtil;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.dialogs.base.edit.res.EditResBundle;
import com.spss.java_client.ui.doc_types.output.graphboard.GraphBoardFrame;
import com.spss.java_client.ui.interactive.ChartOptionsDlg;
import com.spss.java_client.ui.interactive.ScaleTargetInteractivePanel;
import com.spss.java_client.ui.interactive.ScaleTargetMediator;
import com.spss.vis.component.VisualizationComponent;
import com.spss.vis.exception.VisualizationException;
import com.spss.vis.specification.DataValue;
import com.spss.vis.specification.ExtensionSpecification;
import com.spss.vis.specification.LabelPurposeType;
import com.spss.vis.specification.Length;
import com.spss.vis.specification.SpecificationChangeEvent;
import com.spss.vis.specification.VisualizationSpecification;
import com.spss.vis.specification.aesthetic.ColorAestheticSpecification;
import com.spss.vis.specification.aesthetic.DashAestheticSpecification;
import com.spss.vis.specification.aesthetic.PatternAestheticSpecification;
import com.spss.vis.specification.data.SourceVariableSpecification;
import com.spss.vis.specification.facet.TableLayoutSpecification;
import com.spss.vis.specification.format.RelabelSpecification;
import com.spss.vis.specification.guide.LineGuideSpecification;
import com.spss.vis.specification.label.LabelSpecification;
import com.spss.vis.specification.label.TextSpecification;
import com.spss.vis.specification.style.StyleCycleSpecification;
import com.spss.vis.specification.style.StyleSpecification;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class ScaleTargetDetailPanel
extends JPanel
implements ActionListener {
    private ScaleTargetMediator mMediator;
    private VisualizationComponent mVisComp;
    private JTable mTable;
    private JButton mOptions;
    private JScrollPane mTableScrollPane;
    private Map<Integer, Color> mColorMap;
    private Map<Integer, String> mLegendValueMap;
    private String mLegendTitle = "";
    private Map<Integer, Integer> mPatternIndexMap;
    private Map<Integer, Image> mIndexImageMap;
    private Map<Integer, String> mDashIndexMap;
    private Map<String, Image> mIndexDashImageMap;
    private int mRowHeight = 17;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 1989, 2013.\n\n";
    }

    public ScaleTargetDetailPanel(VisualizationComponent visualizationComponent) {
        this.mVisComp = visualizationComponent;
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.init();
    }

    public void setMediator(ScaleTargetMediator scaleTargetMediator) {
        this.mMediator = scaleTargetMediator;
        this.mMediator.setLegendValueMap(this.mLegendValueMap);
        this.mMediator.setLegendTitle(this.mLegendTitle);
        this.mMediator.setColorMap(this.mColorMap);
    }

    public void refresh() {
        double d = this.mMediator.getGuideLineInfo(true).getValue();
        double d2 = this.mMediator.getGuideLineInfo(false).getValue();
        double[] dArray = this.mMediator.getPercentAtLineValues(d, true);
        double[] dArray2 = this.mMediator.getPercentAtLineValues(d2, false);
        this.mTable.setModel(this.getTableModel(dArray, dArray2, d, d2));
        GraphBoardFrame.setInteractiveTableModel(this.mTable.getModel());
        int n = 0;
        if (UIManager.getLookAndFeel().getName().equals("Windows") || UIManager.getLookAndFeel().getName().equals("JGoodies Plastic XP")) {
            n = 10;
        }
        Dimension dimension = new Dimension(500, this.mRowHeight * (dArray.length + 1) + n);
        this.mTable.setPreferredSize(dimension);
        this.mTable.setMinimumSize(dimension);
        this.mTable.setMaximumSize(dimension);
        this.mTableScrollPane.setPreferredSize(dimension);
        if (dArray.length > 1) {
            TableColumn tableColumn = this.mTable.getColumnModel().getColumn(0);
            tableColumn.setCellRenderer(new IterationIconCellRenderer());
        }
    }

    private void init() {
        JLabel jLabel;
        ResourceBundle resourceBundle = com.spss.java_client.ui.resources.ResUtil.getBundle(EditResBundle.getDefaultResourceBundleName(), com.spss.java_client.ui.resources.ResUtil.getLocale());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mTable = new JTable();
        this.mTable.setColumnSelectionAllowed(true);
        this.mTableScrollPane = new JScrollPane(this.mTable, 21, 31);
        this.mTable.setColumnSelectionAllowed(true);
        this.mTable.setDefaultRenderer(String.class, new PercentCellRenderer());
        int n = 0;
        this.mOptions = new JButton(com.spss.java_client.ui.resources.ResUtil.getString(resourceBundle, "IDS_CHART_OPTIONS"));
        String string = this.getFootnoteSText();
        ScaleTargetInteractivePanel.addUsingGBL(this, this.mTableScrollPane, gridBagConstraints, 0, 0, 1, 1, 11, new Insets(0, n, n, n));
        int n2 = 1;
        if (string != null) {
            jLabel = new JLabel(string);
            Font font = this.mOptions.getFont();
            jLabel.setFont(font.deriveFont(0, 10.0f));
            ScaleTargetInteractivePanel.addUsingGBL(this, jLabel, gridBagConstraints, 0, n2++, 1, 1, 23, new Insets(n, n, n, n));
        }
        gridBagConstraints.weighty = 1.0;
        ScaleTargetInteractivePanel.addUsingGBL(this, this.mOptions, gridBagConstraints, 0, n2, 1, 1, 24, new Insets(2, n, n, n));
        this.addActions();
        jLabel = new JLabel("abcd");
        this.mRowHeight = jLabel.getPreferredSize().height;
        this.fillInAestheticData();
        this.mLegendValueMap = new HashMap<Integer, String>();
        this.fillLegendValueMap();
    }

    private void addActions() {
        this.mOptions.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ResourceBundle resourceBundle = com.spss.java_client.ui.resources.ResUtil.getBundle(EditResBundle.getDefaultResourceBundleName(), com.spss.java_client.ui.resources.ResUtil.getLocale());
        ChartOptionsDlg chartOptionsDlg = new ChartOptionsDlg((JFrame)this.getTopLevelAncestor(), this.mVisComp, this.mMediator, resourceBundle);
    }

    public void percentChanged(double d) {
        double d2 = (1.0 - d / 100.0) / 2.0;
        double d3 = 1.0 - d2;
        this.mMediator.getGuideLineInfo(true).setValue(this.mMediator.getLineValueAtPercent(d2));
        this.mMediator.getGuideLineInfo(false).setValue(this.mMediator.getLineValueAtPercent(d3));
    }

    public void loadDetailPanel() {
        LineGuideSpecification[] lineGuideSpecificationArray;
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        for (LineGuideSpecification lineGuideSpecification : lineGuideSpecificationArray = (LineGuideSpecification[])visualizationSpecification.findDescendantsOfType(LineGuideSpecification.class)) {
            if (this.mMediator.getGuideLineName(true).equals(lineGuideSpecification.getName())) {
                lineGuideSpecification.setX(new DataValue(this.mMediator.getGuideLineInfo(true).getValue()));
                continue;
            }
            if (!this.mMediator.getGuideLineName(false).equals(lineGuideSpecification.getName())) continue;
            lineGuideSpecification.setX(new DataValue(this.mMediator.getGuideLineInfo(false).getValue()));
        }
        visualizationSpecification.fireSpecificationChangedEvent(new SpecificationChangeEvent((Object)visualizationSpecification, "redraw chart"));
        try {
            this.mMediator.loadLineValues(true);
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
        double d = this.mMediator.getGuideLineInfo(true).getValue();
        double d2 = this.mMediator.getGuideLineInfo(false).getValue();
        double[] dArray = this.mMediator.getPercentAtLineValues(d, true);
        double[] dArray2 = this.mMediator.getPercentAtLineValues(d2, false);
        this.mTable.setModel(this.getTableModel(dArray, dArray2, d, d2));
        GraphBoardFrame.setInteractiveTableModel(this.mTable.getModel());
        int n = 0;
        if (UIManager.getLookAndFeel().getName().equals("Windows")) {
            n = 10;
        }
        Dimension dimension = new Dimension(500, this.mRowHeight * (dArray.length + 1) + n);
        this.mTable.setPreferredSize(dimension);
        this.mTable.setMinimumSize(dimension);
        this.mTable.setMaximumSize(dimension);
        this.mTableScrollPane.setPreferredSize(dimension);
        if (dArray.length > 1) {
            TableColumn tableColumn = this.mTable.getColumnModel().getColumn(0);
            tableColumn.setCellRenderer(new IterationIconCellRenderer());
        }
    }

    private DefaultTableModel getTableModel(double d, double d2, double d3, double d4) {
        String string;
        String string2;
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        ExtensionSpecification[] extensionSpecificationArray = visualizationSpecification.getExtensionSpecifications();
        if (extensionSpecificationArray.length > 0) {
            string2 = extensionSpecificationArray[0].get("lowerinfinity");
            string = extensionSpecificationArray[0].get("upperinfinity");
            if (string2 != null && "true".equals(string2)) {
                String string3 = this.mMediator.displayPercent(d2);
                String string4 = this.mMediator.displayPercent(1.0 - d2);
                Object[][] objectArray = new Object[][]{{string3, string4}};
                Object[] objectArray2 = new String[]{"<" + this.mMediator.displayFormatValue(d4), ">" + this.mMediator.displayFormatValue(d4)};
                return new DefaultTableModel(objectArray, objectArray2){

                    @Override
                    public Class<?> getColumnClass(int n) {
                        return String.class;
                    }

                    @Override
                    public boolean isCellEditable(int n, int n2) {
                        return false;
                    }
                };
            }
            if (string != null && "true".equals(string)) {
                String string5 = this.mMediator.displayPercent(d);
                String string6 = this.mMediator.displayPercent(1.0 - d);
                Object[][] objectArray = new Object[][]{{string5, string6}};
                Object[] objectArray3 = new String[]{"<" + this.mMediator.displayFormatValue(d3), ">" + this.mMediator.displayFormatValue(d3)};
                return new DefaultTableModel(objectArray, objectArray3){

                    @Override
                    public Class<?> getColumnClass(int n) {
                        return String.class;
                    }

                    @Override
                    public boolean isCellEditable(int n, int n2) {
                        return false;
                    }
                };
            }
        }
        string2 = this.mMediator.displayPercent(d);
        string = this.mMediator.displayPercent(Math.abs(d2 - d));
        String string7 = this.mMediator.displayPercent(1.0 - d2);
        if (this.mMediator.isCumulative() && d > d2) {
            string2 = this.mMediator.displayPercent(1.0 - d);
            string7 = this.mMediator.displayPercent(d2);
        }
        Object[][] objectArray = new Object[][]{{string2, string, string7}};
        Object[] objectArray4 = new String[]{"<" + this.mMediator.displayFormatValue(d3), this.mMediator.displayFormatValue(d3) + " - " + this.mMediator.displayFormatValue(d4), ">" + this.mMediator.displayFormatValue(d4)};
        return new DefaultTableModel(objectArray, objectArray4){

            @Override
            public Class<?> getColumnClass(int n) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
    }

    private DefaultTableModel getTableModel(double[] dArray, double[] dArray2, double d, double d2) {
        Object[][] objectArray;
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        ExtensionSpecification[] extensionSpecificationArray = visualizationSpecification.getExtensionSpecifications();
        if (extensionSpecificationArray.length > 0) {
            objectArray = extensionSpecificationArray[0].get("lowerinfinity");
            String string = extensionSpecificationArray[0].get("upperinfinity");
            if (objectArray != null && "true".equals(objectArray)) {
                if (dArray.length == 1) {
                    Object[][] objectArray2 = new String[dArray.length][2];
                    for (int i = 0; i < dArray.length; ++i) {
                        String string2 = this.mMediator.displayPercent(dArray2[i]);
                        String string3 = this.mMediator.displayPercent(1.0 - dArray2[i]);
                        objectArray2[i][0] = string2;
                        objectArray2[i][1] = string3;
                    }
                    Object[] objectArray3 = new String[]{"<" + this.mMediator.displayFormatValue(d2), ">" + this.mMediator.displayFormatValue(d2)};
                    return new DefaultTableModel(objectArray2, objectArray3){

                        @Override
                        public Class<?> getColumnClass(int n) {
                            return String.class;
                        }

                        @Override
                        public boolean isCellEditable(int n, int n2) {
                            return false;
                        }
                    };
                }
                Object[][] objectArray4 = new String[dArray.length][3];
                for (int i = 0; i < dArray.length; ++i) {
                    String string4 = this.mMediator.displayPercent(dArray2[i]);
                    String string5 = this.mMediator.displayPercent(1.0 - dArray2[i]);
                    objectArray4[i][0] = this.mLegendValueMap.get(i);
                    objectArray4[i][1] = string4;
                    objectArray4[i][2] = string5;
                }
                Object[] objectArray5 = new String[]{this.mLegendTitle, "<" + this.mMediator.displayFormatValue(d2), ">" + this.mMediator.displayFormatValue(d2)};
                return new DefaultTableModel(objectArray4, objectArray5){

                    @Override
                    public Class<?> getColumnClass(int n) {
                        return String.class;
                    }

                    @Override
                    public boolean isCellEditable(int n, int n2) {
                        return false;
                    }
                };
            }
            if (string != null && "true".equals(string)) {
                if (dArray.length == 1) {
                    Object[][] objectArray6 = new String[dArray.length][2];
                    for (int i = 0; i < dArray.length; ++i) {
                        String string6 = this.mMediator.displayPercent(dArray[i]);
                        String string7 = this.mMediator.displayPercent(1.0 - dArray[i]);
                        objectArray6[i][0] = string6;
                        objectArray6[i][1] = string7;
                    }
                    Object[] objectArray7 = new String[]{"<" + this.mMediator.displayFormatValue(d), ">" + this.mMediator.displayFormatValue(d)};
                    return new DefaultTableModel(objectArray6, objectArray7){

                        @Override
                        public Class<?> getColumnClass(int n) {
                            return String.class;
                        }

                        @Override
                        public boolean isCellEditable(int n, int n2) {
                            return false;
                        }
                    };
                }
                Object[][] objectArray8 = new String[dArray.length][3];
                for (int i = 0; i < dArray.length; ++i) {
                    String string8 = this.mMediator.displayPercent(dArray[i]);
                    String string9 = this.mMediator.displayPercent(1.0 - dArray[i]);
                    objectArray8[i][0] = this.mLegendValueMap.get(i);
                    objectArray8[i][1] = string8;
                    objectArray8[i][2] = string9;
                }
                Object[] objectArray9 = new String[]{this.mLegendTitle, "<" + this.mMediator.displayFormatValue(d), ">" + this.mMediator.displayFormatValue(d)};
                return new DefaultTableModel(objectArray8, objectArray9){

                    @Override
                    public Class<?> getColumnClass(int n) {
                        return String.class;
                    }

                    @Override
                    public boolean isCellEditable(int n, int n2) {
                        return false;
                    }
                };
            }
        }
        if (dArray.length == 1) {
            objectArray = new String[dArray.length][3];
            for (int i = 0; i < dArray.length; ++i) {
                String string = this.mMediator.displayPercent(dArray[i]);
                String string10 = this.mMediator.displayPercent(Math.abs(dArray2[i] - dArray[i]));
                String string11 = this.mMediator.displayPercent(1.0 - dArray2[i]);
                if (this.mMediator.isCumulative() && dArray[i] > dArray2[i]) {
                    string = this.mMediator.displayPercent(1.0 - dArray[i]);
                    string11 = this.mMediator.displayPercent(dArray2[i]);
                }
                objectArray[i][0] = string;
                objectArray[i][1] = string10;
                objectArray[i][2] = string11;
            }
            Object[] objectArray10 = new String[]{"<" + this.mMediator.displayFormatValue(d), this.mMediator.displayFormatValue(d) + " - " + this.mMediator.displayFormatValue(d2), ">" + this.mMediator.displayFormatValue(d2)};
            return new DefaultTableModel(objectArray, objectArray10){

                @Override
                public Class<?> getColumnClass(int n) {
                    return String.class;
                }

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
        }
        objectArray = new String[dArray.length][4];
        for (int i = 0; i < dArray.length; ++i) {
            String string = this.mMediator.displayPercent(dArray[i]);
            String string12 = this.mMediator.displayPercent(Math.abs(dArray2[i] - dArray[i]));
            String string13 = this.mMediator.displayPercent(1.0 - dArray2[i]);
            if (this.mMediator.isCumulative() && dArray[i] > dArray2[i]) {
                string = this.mMediator.displayPercent(1.0 - dArray[i]);
                string13 = this.mMediator.displayPercent(dArray2[i]);
            }
            objectArray[i][0] = this.mLegendValueMap.get(i);
            objectArray[i][1] = string;
            objectArray[i][2] = string12;
            objectArray[i][3] = string13;
        }
        Object[] objectArray11 = new String[]{this.mLegendTitle, "<" + this.mMediator.displayFormatValue(d), this.mMediator.displayFormatValue(d) + " - " + this.mMediator.displayFormatValue(d2), ">" + this.mMediator.displayFormatValue(d2)};
        return new DefaultTableModel(objectArray, objectArray11){

            @Override
            public Class<?> getColumnClass(int n) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
    }

    private void fillInAestheticData() {
        DashAestheticSpecification[] dashAestheticSpecificationArray;
        PatternAestheticSpecification[] patternAestheticSpecificationArray;
        int n;
        this.mColorMap = new HashMap<Integer, Color>();
        this.mPatternIndexMap = new HashMap<Integer, Integer>();
        this.mIndexImageMap = new HashMap<Integer, Image>();
        int[] nArray = new int[]{0, 12, 2, 3, 4, 5, 1, 7, 8, 9, 10, 11, 6, 24, 14, 27, 16, 17, 18, 19, 20, 15, 22, 23, 24, 25, 26, 21, 28, 29};
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray2 = nArray;
        int n2 = nArray2.length;
        for (n = 0; n < n2; ++n) {
            int n3 = nArray2[n];
            arrayList.add(n3);
        }
        int n4 = 30;
        for (n2 = 0; n2 < n4; ++n2) {
            this.mIndexImageMap.put(arrayList.indexOf(n2), new ImageIcon(ResUtil.getImageResource((String)("pattern" + n2 + ".gif"))).getImage());
        }
        this.mDashIndexMap = new HashMap<Integer, String>();
        this.mIndexDashImageMap = new HashMap<String, Image>();
        String[] stringArray = new String[]{null, "3,2", "3,6", "5,5", "8,8", "12,3", "6,3,3,3", "6,3,6", "8,2,4,2", "12,5,3,5", "15,2,6,2", "10,2,2,2", "8,1,8,7,2,7", "6,2,3,5,2,2", "12,2,2,10,2,2", "12,2,2,2,2,2,2,2"};
        for (n = 0; n < stringArray.length; ++n) {
            this.mIndexDashImageMap.put(stringArray[n], new ImageIcon(ResUtil.getImageResource((String)("LineStyle" + (n + 1) + ".gif"))).getImage());
        }
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        ColorAestheticSpecification[] colorAestheticSpecificationArray = (ColorAestheticSpecification[])visualizationSpecification.findDescendantsOfType(ColorAestheticSpecification.class);
        if (colorAestheticSpecificationArray.length > 0) {
            patternAestheticSpecificationArray = colorAestheticSpecificationArray[0].getCycle();
            dashAestheticSpecificationArray = (DashAestheticSpecification[])patternAestheticSpecificationArray.findDescendantsOfType(StyleSpecification.class);
            for (int i = 0; i < dashAestheticSpecificationArray.length; ++i) {
                this.mColorMap.put(i, dashAestheticSpecificationArray[i].getColor());
            }
        }
        if ((patternAestheticSpecificationArray = (PatternAestheticSpecification[])visualizationSpecification.findDescendantsOfType(PatternAestheticSpecification.class)).length > 0) {
            dashAestheticSpecificationArray = patternAestheticSpecificationArray[0].getCycle();
            StyleSpecification[] styleSpecificationArray = (StyleSpecification[])dashAestheticSpecificationArray.findDescendantsOfType(StyleSpecification.class);
            for (int i = 0; i < styleSpecificationArray.length; ++i) {
                this.mPatternIndexMap.put(i, styleSpecificationArray[i].getPatternIndex());
            }
        }
        if ((dashAestheticSpecificationArray = (DashAestheticSpecification[])visualizationSpecification.findDescendantsOfType(DashAestheticSpecification.class)).length > 0) {
            StyleCycleSpecification styleCycleSpecification = dashAestheticSpecificationArray[0].getCycle();
            StyleSpecification[] styleSpecificationArray = (StyleSpecification[])styleCycleSpecification.findDescendantsOfType(StyleSpecification.class);
            for (int i = 0; i < styleSpecificationArray.length; ++i) {
                this.mDashIndexMap.put(i, this.convertDashLengthes2String(styleSpecificationArray[i].getStrokeDashing()));
            }
        }
    }

    private String convertDashLengthes2String(Length[] lengthArray) {
        if (lengthArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < lengthArray.length; ++i) {
            if (i != lengthArray.length - 1) {
                stringBuffer.append((int)lengthArray[i].getValue()).append(",");
                continue;
            }
            stringBuffer.append((int)lengthArray[i].getValue());
        }
        return stringBuffer.toString();
    }

    private void fillLegendValueMap() {
        TextSpecification[] textSpecificationArray;
        SourceVariableSpecification[] sourceVariableSpecificationArray;
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        for (SourceVariableSpecification sourceVariableSpecification : sourceVariableSpecificationArray = (SourceVariableSpecification[])visualizationSpecification.findDescendantsOfType(SourceVariableSpecification.class)) {
            RelabelSpecification[] relabelSpecificationArray;
            if (!"row".equals(sourceVariableSpecification.getId())) continue;
            for (RelabelSpecification relabelSpecification : relabelSpecificationArray = (RelabelSpecification[])sourceVariableSpecification.findDescendantsOfType(RelabelSpecification.class)) {
                this.mLegendValueMap.put(Integer.valueOf(relabelSpecification.getFrom()), relabelSpecification.getTo());
            }
        }
        SourceVariableSpecification[] sourceVariableSpecificationArray2 = (TableLayoutSpecification[])visualizationSpecification.findDescendantsOfType(TableLayoutSpecification.class);
        if (sourceVariableSpecificationArray2.length > 0 && (textSpecificationArray = (TextSpecification[])sourceVariableSpecificationArray2[0].findDescendantsOfType(TextSpecification.class)).length > 0) {
            this.mLegendTitle = textSpecificationArray[0].getText();
        }
    }

    private String getFootnoteSText() {
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        LabelSpecification[] labelSpecificationArray = (LabelSpecification[])visualizationSpecification.findDescendantsOfType(LabelSpecification.class);
        if (labelSpecificationArray.length == 0) {
            return null;
        }
        for (LabelSpecification labelSpecification : labelSpecificationArray) {
            TextSpecification[] textSpecificationArray;
            if (labelSpecification.getLabelPurpose() != LabelPurposeType.FOOTNOTE || (textSpecificationArray = labelSpecification.getTextSpecifications()).length <= 0) continue;
            return textSpecificationArray[0].getText();
        }
        return null;
    }

    class IterationIconCellRenderer
    extends DefaultTableCellRenderer {
        private int iconSize = 14;
        private BufferedImage image = null;
        private ImageIcon mIcon = null;

        public IterationIconCellRenderer() {
            this.image = ScaleTargetDetailPanel.this.mDashIndexMap.size() > 0 ? new BufferedImage(2 * this.iconSize, this.iconSize, 6) : new BufferedImage(this.iconSize, this.iconSize, 6);
            this.mIcon = new ImageIcon(this.image);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = null;
            jLabel = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Graphics graphics = this.image.getGraphics();
            if (ScaleTargetDetailPanel.this.mColorMap.size() > 0) {
                graphics.setColor((Color)ScaleTargetDetailPanel.this.mColorMap.get(n));
                graphics.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
            } else if (ScaleTargetDetailPanel.this.mPatternIndexMap.size() > 0) {
                Integer n3 = (Integer)ScaleTargetDetailPanel.this.mPatternIndexMap.get(n);
                if (n3 < ScaleTargetDetailPanel.this.mIndexImageMap.size()) {
                    Image image = (Image)ScaleTargetDetailPanel.this.mIndexImageMap.get(n3);
                    graphics.drawImage(image, 0, 0, null);
                }
            } else if (ScaleTargetDetailPanel.this.mDashIndexMap.size() > 0) {
                String string = (String)ScaleTargetDetailPanel.this.mDashIndexMap.get(n);
                if (ScaleTargetDetailPanel.this.mIndexDashImageMap.containsKey(string)) {
                    Image image = (Image)ScaleTargetDetailPanel.this.mIndexDashImageMap.get(string);
                    graphics.drawImage(image, 0, 0, null);
                }
            }
            graphics.dispose();
            jLabel.setIcon(this.mIcon);
            return jLabel;
        }
    }

    static class PercentCellRenderer
    extends DefaultTableCellRenderer {
        PercentCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                return super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)(object + "%")), bl, bl2, n, n2);
            }
            return super.getTableCellRendererComponent(jTable, object + "%", bl, bl2, n, n2);
        }
    }
}

