/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.ui.awt.VisControl;
import com.spss.java_client.core.documents.output.OutputItem;
import com.spss.java_client.core.documents.output.interactive.JsonInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.STPCorrelationsMapInteractiveItem;
import com.spss.java_client.core.documents.output.lighttable.JsonTableItem;
import com.spss.java_client.ui.doc_types.output.JsonInteractiveViewerItem;
import com.spss.java_client.ui.interactive.JsonInteractiveFrame;
import com.spss.java_client.ui.interactive.JsonSplitInteractiveFrame;
import com.spss.java_client.ui.interactive.OutputVisPanel;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.output.client.table.OutputTable;
import com.spss.output.client.table.OutputTableCallback;
import com.spss.output.vis.charting.OutputVisComponent;
import com.spss.output.vis.charting.nativeImpl.util.OutputVisComponentUtil;
import com.spss.uitools.clipboard.AppClipboard;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class STPCorrelationsMapInteractiveFrame
extends JsonSplitInteractiveFrame
implements ChangeListener,
OutputTableCallback {
    public static int ID_CORRELATIONS_MATRIX = 0;
    public static int ID_COVARIANCE_MATRIX = 1;
    public static int ID_TIME_SERIES_PLOT = 2;
    private JTabbedPane mTablesPane;
    private JScrollPane mCorrelationsScrollPane;
    private JScrollPane mCovarianceScrollPane;
    private OutputTable mCorrelationsTable;
    private OutputTable mCovarianceTable;
    private JMenuItem mViewCorrelationsItem;
    private JMenuItem mViewCovarianceItem;
    private JMenuItem mViewTimeSeriesPlotItem;

    public STPCorrelationsMapInteractiveFrame(JsonInteractiveViewerItem jsonInteractiveViewerItem) {
        super(jsonInteractiveViewerItem);
        this.setTitle(this.mResBundle.getString("IDS_INTERACTIVE_OUTPUT_TITLE") + this.mResBundle.getString("IDS_INTERACTIVE_OUTPUT_TITLE_SEP") + jsonInteractiveViewerItem.getItem().getDescription());
        this.constructGUI();
        this.constructMenus();
        this.setTabTraversalPolicy();
        this.addWindowListener(this);
        this.mVisCompMainInteracitivity = new JsonInteractiveFrame.VisCompMainInteracitivity(this);
        this.enableZoomAndPanControls(this.getZoomAndPanVisControl());
    }

    @Override
    protected void constructGUI() {
        STPCorrelationsMapInteractiveItem sTPCorrelationsMapInteractiveItem = (STPCorrelationsMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        OutputVisComponent outputVisComponent = sTPCorrelationsMapInteractiveItem.getMainVisComponent();
        this.mMainDisplayPanel = new OutputVisPanel(outputVisComponent);
        this.mMainDisplayPanel.setActionsList(sTPCorrelationsMapInteractiveItem.getMainActionsList());
        JSONObject jSONObject = OutputVisComponentUtil.exportComponentViewAsVisSpec((VisControl)this.getZoomAndPanVisControl(), (OutputVisComponent)outputVisComponent, (Integer)((int)((double)sTPCorrelationsMapInteractiveItem.getWidth() * sTPCorrelationsMapInteractiveItem.getMainVisualizationProportion())), (Integer)sTPCorrelationsMapInteractiveItem.getHeight());
        this.getZoomAndPanVisControl().setSpecification(jSONObject);
        this.addZoomAndPanListeners((JsonInteractiveItem)sTPCorrelationsMapInteractiveItem, this.getZoomAndPanVisControl());
        this.mTablesPane = new JTabbedPane();
        this.createCorrelationsScrolPane();
        this.mTablesPane.add(this.mResBundle.getString("IDS_STP_CORRELATION"), this.mCorrelationsScrollPane);
        this.createCovarianceScrolPane();
        this.mTablesPane.add(this.mResBundle.getString("IDS_STP_COVARIANCE"), this.mCovarianceScrollPane);
        OutputVisComponent outputVisComponent2 = sTPCorrelationsMapInteractiveItem.getAuxiliaryVisComponent();
        this.mAuxDisplayPanel = new OutputVisPanel(outputVisComponent2);
        this.mTablesPane.add(this.mResBundle.getString("IDS_STP_TIME_SERIES"), this.mAuxDisplayPanel);
        int n = sTPCorrelationsMapInteractiveItem.getSelectedAuxiliaryIndex();
        this.mTablesPane.setSelectedIndex(n);
        this.mTablesPane.addChangeListener(this);
        this.createSplitPane(0, this.mMainDisplayPanel, this.mTablesPane);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.constructCopyToViewerButton(), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.mZoomInButton = this.constructToolbarButton("zoom_in", "zoom_in_TOOLTIP");
        this.mZoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                STPCorrelationsMapInteractiveFrame.this.setZoomLevel(++STPCorrelationsMapInteractiveFrame.this.mCurrentZoomLevel);
                STPCorrelationsMapInteractiveFrame.this.doZoomToLevel(STPCorrelationsMapInteractiveFrame.this.mInteractiveViewerItem.getItem(), STPCorrelationsMapInteractiveFrame.this.mMainDisplayPanel, true, STPCorrelationsMapInteractiveFrame.this.mCurrentZoomLevel);
            }
        });
        this.add((Component)this.mZoomInButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.mZoomOutButton = this.constructToolbarButton("zoom_out", "zoom_out_TOOLTIP");
        this.mZoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                STPCorrelationsMapInteractiveFrame.this.setZoomLevel(--STPCorrelationsMapInteractiveFrame.this.mCurrentZoomLevel);
                STPCorrelationsMapInteractiveFrame.this.doZoomToLevel(STPCorrelationsMapInteractiveFrame.this.mInteractiveViewerItem.getItem(), STPCorrelationsMapInteractiveFrame.this.mMainDisplayPanel, true, STPCorrelationsMapInteractiveFrame.this.mCurrentZoomLevel);
            }
        });
        this.add((Component)this.mZoomOutButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        gridBagConstraints.fill = 1;
        this.add((Component)this.mSplitPane, gridBagConstraints);
    }

    @Override
    protected Vector<Object> addControlsForFocusTraversal(Vector<Object> vector) {
        vector.add(this.mCopyToViewerButton);
        vector.add(this.mZoomInButton);
        vector.add(this.mZoomOutButton);
        vector.add(this.mMainDisplayPanel.getVisControl());
        vector.add(this.mTablesPane);
        return vector;
    }

    private void createCorrelationsScrolPane() {
        STPCorrelationsMapInteractiveItem sTPCorrelationsMapInteractiveItem = (STPCorrelationsMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        this.mCorrelationsTable = this.createOutputTable(sTPCorrelationsMapInteractiveItem.getCorrelationsTableJson(), sTPCorrelationsMapInteractiveItem.getDataModelJson(), sTPCorrelationsMapInteractiveItem.getCorrelationsTableFilterJson());
        this.mCorrelationsTable.setCallback((OutputTableCallback)this);
        this.setInteractiveTableComp(this.mCorrelationsTable, true, true);
        this.mCorrelationsScrollPane = new JScrollPane((Component)this.mCorrelationsTable.getTableComponent());
    }

    private void createCovarianceScrolPane() {
        STPCorrelationsMapInteractiveItem sTPCorrelationsMapInteractiveItem = (STPCorrelationsMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        this.mCovarianceTable = this.createOutputTable(sTPCorrelationsMapInteractiveItem.getCovarianceTableJson(), sTPCorrelationsMapInteractiveItem.getDataModelJson(), sTPCorrelationsMapInteractiveItem.getCovarianceTableFilterJson());
        this.mCovarianceTable.setCallback((OutputTableCallback)this);
        this.setInteractiveTableComp(this.mCovarianceTable, true, true);
        this.mCovarianceScrollPane = new JScrollPane((Component)this.mCovarianceTable.getTableComponent());
    }

    @Override
    protected void constructMenus() {
        super.constructMenus();
        JMenu jMenu = this.createCopyToViewerMenu(false);
        this.addItemToMenu(jMenu, "copy_map_to_viewer");
        this.addItemToMenu(jMenu, "copy_correlations_table_to_viewer");
        this.addItemToMenu(jMenu, "copy_covariance_table_to_viewer");
        this.addItemToMenu(jMenu, "copy_time_series_plot_to_viewer");
        this.addItemToMenu(jMenu, "copy_image_to_viewer");
        this.fileMenu.add(jMenu);
        this.fileMenu.addSeparator();
        this.addItemToMenu(this.fileMenu, "print_settings");
        this.fileMenu.addSeparator();
        this.addItemToMenu(this.fileMenu, "file_close");
        JMenu jMenu2 = new JMenu(ResUtil.getString("copy_object"));
        jMenu2.setMnemonic(ResUtil.getAccessKey("copy_object"));
        this.addItemToMenu(jMenu2, "copy_map_to_clipboard");
        this.addItemToMenu(jMenu2, "copy_correlations_table_to_clipboard");
        this.addItemToMenu(jMenu2, "copy_covariance_table_to_clipboard");
        this.addItemToMenu(jMenu2, "copy_time_series_plot_to_clipboard");
        this.addItemToMenu(jMenu2, "copy_image_to_clipboard");
        this.editMenu.add(jMenu2);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.mViewCorrelationsItem = this.addRBItemToMenu(this.viewMenu, "view_correlations_table", buttonGroup);
        this.mViewCovarianceItem = this.addRBItemToMenu(this.viewMenu, "view_covariance_table", buttonGroup);
        this.mViewTimeSeriesPlotItem = this.addRBItemToMenu(this.viewMenu, "view_time_series_plot", buttonGroup);
        this.mViewCorrelationsItem.setSelected(this.mTablesPane.getSelectedIndex() == 0);
        this.mViewCovarianceItem.setSelected(this.mTablesPane.getSelectedIndex() == 1);
        this.mViewTimeSeriesPlotItem.setSelected(this.mTablesPane.getSelectedIndex() == 2);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.constructZoomMenu());
        this.viewMenu.add(this.constructPanMenu());
        STPCorrelationsMapInteractiveItem sTPCorrelationsMapInteractiveItem = (STPCorrelationsMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        this.mCurrentZoomLevel = sTPCorrelationsMapInteractiveItem.getMainZoomLevel();
        this.setZoomLevel(this.mCurrentZoomLevel);
        this.doZoomToLevel((JsonInteractiveItem)sTPCorrelationsMapInteractiveItem, this.mMainDisplayPanel, true, this.mCurrentZoomLevel);
        this.addItemToMenu(this.helpMenu, "help_topics");
    }

    @Override
    protected OutputVisPanel getZoomAndPanOutputVisPanel() {
        return this.mMainDisplayPanel;
    }

    @Override
    protected VisControl getZoomAndPanVisControl() {
        return this.mMainDisplayPanel.getVisControl();
    }

    @Override
    protected void addCopyToViewerPopupMenuItems(JPopupMenu jPopupMenu) {
        JMenu jMenu = this.createCopyToViewerMenu(true);
        this.addItemToMenu(jMenu, "copy_map_to_viewer");
        this.addItemToMenu(jMenu, "copy_correlations_table_to_viewer");
        this.addItemToMenu(jMenu, "copy_covariance_table_to_viewer");
        this.addItemToMenu(jMenu, "copy_time_series_plot_to_viewer");
        this.addItemToMenu(jMenu, "copy_image_to_viewer");
        jPopupMenu.add(jMenu);
    }

    @Override
    public void doCopyImageToViewer() {
        this.doCopyImageToViewer(this.getDescriptionForSelectedDisplay() + " - " + this.mResBundle.getString("IDS_IMAGE"));
    }

    @Override
    public void doCopyMapToViewer() {
        this.copyJsonChartItemIntoViewer(true, this.getDescriptionForSelectedDisplay() + " - " + this.mResBundle.getString("IDS_MAP"));
    }

    @Override
    public void doCopyChartToViewer() {
        this.copyJsonChartItemIntoViewer(false, this.getDescriptionForSelectedDisplay() + " - " + this.mResBundle.getString("IDS_CHART"));
    }

    public void doCopyCorrelationsTableToViewer() {
        STPCorrelationsMapInteractiveItem sTPCorrelationsMapInteractiveItem = (STPCorrelationsMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        JsonTableItem jsonTableItem = sTPCorrelationsMapInteractiveItem.getCorrelationsTableItem();
        jsonTableItem.setDescription(this.mResBundle.getString("IDS_STP_SPATIAL_CORRELATION_MATRIX"));
        this.insertItemIntoViewer((OutputItem)jsonTableItem);
    }

    public void doCopyCovarianceTableToViewer() {
        STPCorrelationsMapInteractiveItem sTPCorrelationsMapInteractiveItem = (STPCorrelationsMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        JsonTableItem jsonTableItem = sTPCorrelationsMapInteractiveItem.getCovarianceTableItem();
        jsonTableItem.setDescription(this.mResBundle.getString("IDS_STP_SPATIAL_COVARIANCE_MATRIX"));
        this.insertItemIntoViewer((OutputItem)jsonTableItem);
    }

    public void doCopyTableToClipboard(JsonTableItem jsonTableItem) {
        AppClipboard appClipboard = AppClipboard.getAppClipboard();
        try {
            BufferedImage bufferedImage = jsonTableItem.render();
            if (bufferedImage != null) {
                appClipboard.addClipboardData(AppClipboard.IMAGE_FLAVOR, (Object)bufferedImage, true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doCopyTimeSeriesPlotToClipboard() {
        STPCorrelationsMapInteractiveItem sTPCorrelationsMapInteractiveItem = (STPCorrelationsMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        AppClipboard appClipboard = AppClipboard.getAppClipboard();
        BufferedImage bufferedImage = sTPCorrelationsMapInteractiveItem.getTSPlotImage();
        if (bufferedImage != null) {
            appClipboard.addClipboardData(AppClipboard.IMAGE_FLAVOR, (Object)bufferedImage, true);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        STPCorrelationsMapInteractiveItem sTPCorrelationsMapInteractiveItem = (STPCorrelationsMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        sTPCorrelationsMapInteractiveItem.setSelectedAuxiliaryIndex(this.mTablesPane.getSelectedIndex());
        this.mViewCorrelationsItem.setSelected(this.mTablesPane.getSelectedIndex() == 0);
        this.mViewCovarianceItem.setSelected(this.mTablesPane.getSelectedIndex() == 1);
        this.mViewTimeSeriesPlotItem.setSelected(this.mTablesPane.getSelectedIndex() == 2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        STPCorrelationsMapInteractiveItem sTPCorrelationsMapInteractiveItem = (STPCorrelationsMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        if ("copy_correlations_table_to_viewer".equals(actionEvent.getActionCommand())) {
            this.doCopyCorrelationsTableToViewer();
        } else if ("copy_covariance_table_to_viewer".equals(actionEvent.getActionCommand())) {
            this.doCopyCovarianceTableToViewer();
        } else if ("copy_time_series_plot_to_viewer".equals(actionEvent.getActionCommand())) {
            this.doCopyChartToViewer();
        } else if ("copy_correlations_table_to_clipboard".equals(actionEvent.getActionCommand())) {
            this.doCopyTableToClipboard(sTPCorrelationsMapInteractiveItem.getCorrelationsTableItem());
        } else if ("copy_covariance_table_to_clipboard".equals(actionEvent.getActionCommand())) {
            this.doCopyTableToClipboard(sTPCorrelationsMapInteractiveItem.getCovarianceTableItem());
        } else if ("copy_time_series_plot_to_clipboard".equals(actionEvent.getActionCommand())) {
            this.doCopyTimeSeriesPlotToClipboard();
        } else if ("view_correlations_table".equals(actionEvent.getActionCommand())) {
            this.mTablesPane.setSelectedIndex(0);
            this.mViewCorrelationsItem.setSelected(true);
        } else if ("view_covariance_table".equals(actionEvent.getActionCommand())) {
            this.mTablesPane.setSelectedIndex(1);
            this.mViewCovarianceItem.setSelected(true);
        } else if ("view_time_series_plot".equals(actionEvent.getActionCommand())) {
            this.mTablesPane.setSelectedIndex(2);
            this.mViewTimeSeriesPlotItem.setSelected(true);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    @Override
    protected Dimension getItemSize() {
        Dimension dimension = new Dimension(this.mMainDisplayPanel.getWidth(), this.mMainDisplayPanel.getHeight() + this.mTablesPane.getHeight());
        return dimension;
    }

    @Override
    public void processVisCompMainMouseMoved(JSONObject jSONObject, boolean bl) {
        String string = jSONObject.toString();
        if (string.contains("enterRegion")) {
            Number number = (Number)BasicFactory.getItem((Object)jSONObject, (String)"hoverGeoKey");
            if (number != null) {
                try {
                    JSONObject jSONObject2 = JSONObject.parse((String)("{\"action\":{\"hoverAction\":{\"rowMeta\":[\"" + number + "\"]}}}"));
                    if (this.mTablesPane.getSelectedIndex() == 0) {
                        this.mCorrelationsTable.applyTableAction(jSONObject2);
                    } else if (this.mTablesPane.getSelectedIndex() == 1) {
                        this.mCovarianceTable.applyTableAction(jSONObject2);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        } else if (string.contains("enterLocation")) {
            JSONObject jSONObject3 = (JSONObject)BasicFactory.getItem((Object)jSONObject, (String)"hoverLocation");
            if (jSONObject3 != null) {
                Double d = (Double)BasicFactory.getItem((Object)jSONObject3, (String)"x");
                Double d2 = (Double)BasicFactory.getItem((Object)jSONObject3, (String)"y");
                String string2 = "[" + d + ", " + d2 + "]";
                try {
                    JSONObject jSONObject4 = JSONObject.parse((String)("{\"action\":{\"hoverAction\":{\"rowMeta\":[\"" + string2 + "\"]}}}"));
                    if (this.mTablesPane.getSelectedIndex() == 0) {
                        this.mCorrelationsTable.applyTableAction(jSONObject4);
                    } else if (this.mTablesPane.getSelectedIndex() == 1) {
                        this.mCovarianceTable.applyTableAction(jSONObject4);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        } else if (string.contains("leaveRegion") || string.contains("leaveLocation")) {
            try {
                JSONObject jSONObject5 = JSONObject.parse((String)"{\"action\":{\"unhoverAction\":{\"rowMeta\":[]}}}");
                if (this.mTablesPane.getSelectedIndex() == 0) {
                    this.mCorrelationsTable.applyTableAction(jSONObject5);
                } else if (this.mTablesPane.getSelectedIndex() == 1) {
                    this.mCovarianceTable.applyTableAction(jSONObject5);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public void processVisCompMainMouseClick(JSONObject jSONObject, boolean bl) {
        if (jSONObject != null && jSONObject.size() > 0) {
            JSONArray jSONArray;
            STPCorrelationsMapInteractiveItem sTPCorrelationsMapInteractiveItem = (STPCorrelationsMapInteractiveItem)this.mInteractiveViewerItem.getItem();
            if (BasicFactory.getItem((Object)jSONObject, (String)"geokeys") != null) {
                JSONArray jSONArray2 = (JSONArray)BasicFactory.getItem((Object)jSONObject, (String)"geokeys");
                String string = "[";
                String string2 = "[";
                for (int i = 0; i < jSONArray2.size(); ++i) {
                    string = string + jSONArray2.get(i);
                    string2 = string2 + "\"" + jSONArray2.get(i) + "\"";
                    if (i + 1 >= jSONArray2.size()) continue;
                    string = string + ",";
                    string2 = string2 + ",";
                }
                string = string + "]";
                string2 = string2 + "]";
                JSONObject jSONObject2 = sTPCorrelationsMapInteractiveItem.createActionParams(sTPCorrelationsMapInteractiveItem.isRegionsPlot() ? "geokeys" : "locations", jSONArray2.toString());
                JSONObject jSONObject3 = sTPCorrelationsMapInteractiveItem.createActionParams("locations", string2);
                sTPCorrelationsMapInteractiveItem.performHighlightAction(jSONObject2, jSONObject3);
                sTPCorrelationsMapInteractiveItem.createTableFilterJsons(string);
            } else if (BasicFactory.getItem((Object)jSONObject, (String)"action") != null && BasicFactory.getItem((Object)jSONObject, (String)"action").equals("clickLocation") && (jSONArray = (JSONArray)BasicFactory.getItem((Object)jSONObject, (String)"locations")).size() > 0) {
                JSONObject jSONObject4;
                String string = "[";
                String string3 = "[";
                for (int i = 0; i < jSONArray.size(); ++i) {
                    jSONObject4 = (JSONObject)jSONArray.get(i);
                    Double d = (Double)BasicFactory.getItem((Object)jSONObject4, (String)"x");
                    Double d2 = (Double)BasicFactory.getItem((Object)jSONObject4, (String)"y");
                    string = string + "\"[" + d + ", " + d2 + "]\"";
                    string3 = string3 + "[\"" + d + "\"" + ", " + "\"" + d2 + "\"" + "]";
                    if (i + 1 >= jSONArray.size()) continue;
                    string = string + ",";
                    string3 = string3 + ",";
                }
                string = string + "]";
                string3 = string3 + "]";
                JSONObject jSONObject5 = sTPCorrelationsMapInteractiveItem.createActionParams(sTPCorrelationsMapInteractiveItem.isRegionsPlot() ? "geokeys" : "locations", jSONArray.toString());
                jSONObject4 = sTPCorrelationsMapInteractiveItem.createActionParams("locations", string3);
                sTPCorrelationsMapInteractiveItem.performHighlightAction(jSONObject5, jSONObject4);
                sTPCorrelationsMapInteractiveItem.createTableFilterJsons(string);
            }
            this.mMainDisplayPanel.setActionsList(sTPCorrelationsMapInteractiveItem.getMainActionsList());
            this.updateFilteredTable();
        }
    }

    public void takeAction(JSONObject jSONObject) {
        STPCorrelationsMapInteractiveItem sTPCorrelationsMapInteractiveItem = (STPCorrelationsMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"action");
        if (jSONObject2.containsKey((Object)"hoverAction")) {
            JSONObject jSONObject3 = (JSONObject)BasicFactory.getItem((Object)jSONObject2, (String)"hoverAction");
            JSONArray jSONArray = (JSONArray)jSONObject3.get((Object)"rowMeta");
            JSONObject jSONObject4 = sTPCorrelationsMapInteractiveItem.isRegionsPlot() ? sTPCorrelationsMapInteractiveItem.createHoverRegionActionParams((String)jSONArray.get(0)) : sTPCorrelationsMapInteractiveItem.createHoverLocationActionParams((String)jSONArray.get(0));
            sTPCorrelationsMapInteractiveItem.performHoverAction(jSONObject4);
        } else if (jSONObject2.containsKey((Object)"unhoverAction")) {
            try {
                JSONObject jSONObject5 = JSONObject.parse((String)"{}");
                sTPCorrelationsMapInteractiveItem.performLeaveAction(jSONObject5);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected void updateFilteredTable() {
        STPCorrelationsMapInteractiveItem sTPCorrelationsMapInteractiveItem = (STPCorrelationsMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        this.mTablesPane.removeChangeListener(this);
        int n = this.mTablesPane.getSelectedIndex();
        this.mCorrelationsTable = this.createOutputTable(sTPCorrelationsMapInteractiveItem.getCorrelationsTableJson(), sTPCorrelationsMapInteractiveItem.getDataModelJson(), sTPCorrelationsMapInteractiveItem.getCorrelationsTableFilterJson());
        this.mCorrelationsTable.setCallback((OutputTableCallback)this);
        this.setInteractiveTableComp(this.mCorrelationsTable, true, true);
        JScrollPane jScrollPane = (JScrollPane)this.mTablesPane.getComponent(0);
        jScrollPane.getViewport().removeAll();
        jScrollPane.getViewport().add((Component)this.mCorrelationsTable.getTableComponent());
        this.mCovarianceTable = this.createOutputTable(sTPCorrelationsMapInteractiveItem.getCovarianceTableJson(), sTPCorrelationsMapInteractiveItem.getDataModelJson(), sTPCorrelationsMapInteractiveItem.getCovarianceTableFilterJson());
        this.mCovarianceTable.setCallback((OutputTableCallback)this);
        JScrollPane jScrollPane2 = (JScrollPane)this.mTablesPane.getComponent(1);
        jScrollPane2.getViewport().removeAll();
        jScrollPane2.getViewport().add((Component)this.mCovarianceTable.getTableComponent());
        this.mTablesPane.setSelectedIndex(n);
        this.mTablesPane.addChangeListener(this);
    }
}

