/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.ui.awt.VisControl;
import com.spss.java_client.core.documents.output.interactive.JsonInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.STPClustersMapInteractiveItem;
import com.spss.java_client.ui.doc_types.output.JsonInteractiveViewerItem;
import com.spss.java_client.ui.interactive.JsonInteractiveFrame;
import com.spss.java_client.ui.interactive.JsonSplitInteractiveFrame;
import com.spss.java_client.ui.interactive.OutputVisPanel;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.output.vis.charting.OutputVisComponent;
import com.spss.output.vis.charting.nativeImpl.util.OutputVisComponentUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class STPClustersMapInteractiveFrame
extends JsonSplitInteractiveFrame {
    public STPClustersMapInteractiveFrame(JsonInteractiveViewerItem jsonInteractiveViewerItem) {
        super(jsonInteractiveViewerItem);
        STPClustersMapInteractiveItem sTPClustersMapInteractiveItem = (STPClustersMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        this.setTitle(this.mResBundle.getString("IDS_INTERACTIVE_OUTPUT_TITLE") + this.mResBundle.getString("IDS_INTERACTIVE_OUTPUT_TITLE_SEP") + this.mResBundle.getString(sTPClustersMapInteractiveItem.getOrderByCloseness() ? "IDS_STP_CLUSTERS_MAP_BY_CLOSENESS" : "IDS_STP_CLUSTERS_MAP_BY_SIZE"));
        this.constructGUI();
        this.constructMenus();
        this.setTabTraversalPolicy();
        this.mVisCompMainInteracitivity = new JsonInteractiveFrame.VisCompMainInteracitivity(this);
        this.mVisCompAuxInteracitivity = new JsonSplitInteractiveFrame.VisCompAuxInteracitivity(this);
        this.addWindowListener(this);
        this.enableZoomAndPanControls(this.getZoomAndPanVisControl());
    }

    @Override
    protected void constructGUI() {
        STPClustersMapInteractiveItem sTPClustersMapInteractiveItem = (STPClustersMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        OutputVisComponent outputVisComponent = sTPClustersMapInteractiveItem.getMainVisComponent();
        this.mMainDisplayPanel = new OutputVisPanel(outputVisComponent);
        this.mMainDisplayPanel.setActionsList(sTPClustersMapInteractiveItem.getMainActionsList());
        JSONObject jSONObject = OutputVisComponentUtil.exportComponentViewAsVisSpec((VisControl)this.getZoomAndPanVisControl(), (OutputVisComponent)outputVisComponent, (Integer)((int)((double)sTPClustersMapInteractiveItem.getWidth() * sTPClustersMapInteractiveItem.getMainVisualizationProportion())), (Integer)sTPClustersMapInteractiveItem.getHeight());
        this.getZoomAndPanVisControl().setSpecification(jSONObject);
        this.addZoomAndPanListeners((JsonInteractiveItem)sTPClustersMapInteractiveItem, this.getZoomAndPanVisControl());
        OutputVisComponent outputVisComponent2 = sTPClustersMapInteractiveItem.getAuxiliaryVisComponent();
        this.mAuxDisplayPanel = new OutputVisPanel(outputVisComponent2);
        this.mAuxDisplayPanel.setActionsList(sTPClustersMapInteractiveItem.getAuxActionsList());
        this.createSplitPane(0, this.mMainDisplayPanel, this.mAuxDisplayPanel);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.constructCopyToViewerButton(), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.mZoomInButton = this.constructToolbarButton("zoom_in", "zoom_in_TOOLTIP");
        this.mZoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                STPClustersMapInteractiveFrame.this.setZoomLevel(++STPClustersMapInteractiveFrame.this.mCurrentZoomLevel);
                STPClustersMapInteractiveFrame.this.doZoomToLevel(STPClustersMapInteractiveFrame.this.mInteractiveViewerItem.getItem(), STPClustersMapInteractiveFrame.this.mMainDisplayPanel, true, STPClustersMapInteractiveFrame.this.mCurrentZoomLevel);
            }
        });
        this.add((Component)this.mZoomInButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.mZoomOutButton = this.constructToolbarButton("zoom_out", "zoom_out_TOOLTIP");
        this.mZoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                STPClustersMapInteractiveFrame.this.setZoomLevel(--STPClustersMapInteractiveFrame.this.mCurrentZoomLevel);
                STPClustersMapInteractiveFrame.this.doZoomToLevel(STPClustersMapInteractiveFrame.this.mInteractiveViewerItem.getItem(), STPClustersMapInteractiveFrame.this.mMainDisplayPanel, true, STPClustersMapInteractiveFrame.this.mCurrentZoomLevel);
            }
        });
        this.add((Component)this.mZoomOutButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        gridBagConstraints.fill = 1;
        this.add((Component)this.mSplitPane, gridBagConstraints);
    }

    @Override
    protected Vector<Object> addControlsForFocusTraversal(Vector<Object> vector) {
        vector.add(this.mCopyToViewerButton);
        vector.add(this.mZoomInButton);
        vector.add(this.mZoomOutButton);
        vector.add(this.mMainDisplayPanel.getVisControl());
        vector.add(this.mAuxDisplayPanel.getVisControl());
        return vector;
    }

    @Override
    protected void constructMenus() {
        super.constructMenus();
        JMenu jMenu = this.createCopyToViewerMenu(false);
        this.addItemToMenu(jMenu, "copy_map_to_viewer");
        this.addItemToMenu(jMenu, "copy_chart_to_viewer");
        this.addItemToMenu(jMenu, "copy_image_to_viewer");
        this.fileMenu.add(jMenu);
        this.fileMenu.addSeparator();
        this.addItemToMenu(this.fileMenu, "print_settings");
        this.fileMenu.addSeparator();
        this.addItemToMenu(this.fileMenu, "file_close");
        JMenu jMenu2 = new JMenu(ResUtil.getString("copy_object"));
        jMenu2.setMnemonic(ResUtil.getAccessKey("copy_object"));
        this.addItemToMenu(jMenu2, "copy_map_to_clipboard");
        this.addItemToMenu(jMenu2, "copy_chart_to_clipboard");
        this.addItemToMenu(jMenu2, "copy_image_to_clipboard");
        this.editMenu.add(jMenu2);
        this.viewMenu.add(this.constructZoomMenu());
        this.viewMenu.add(this.constructPanMenu());
        STPClustersMapInteractiveItem sTPClustersMapInteractiveItem = (STPClustersMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        this.mCurrentZoomLevel = sTPClustersMapInteractiveItem.getMainZoomLevel();
        this.setZoomLevel(this.mCurrentZoomLevel);
        this.doZoomToLevel((JsonInteractiveItem)sTPClustersMapInteractiveItem, this.mMainDisplayPanel, true, this.mCurrentZoomLevel);
        this.addItemToMenu(this.helpMenu, "help_topics");
    }

    @Override
    protected void addCopyToViewerPopupMenuItems(JPopupMenu jPopupMenu) {
        JMenu jMenu = this.createCopyToViewerMenu(true);
        this.addItemToMenu(jMenu, "copy_map_to_viewer");
        this.addItemToMenu(jMenu, "copy_chart_to_viewer");
        this.addItemToMenu(jMenu, "copy_image_to_viewer");
        jPopupMenu.add(jMenu);
    }

    @Override
    public void doCopyImageToViewer() {
        this.doCopyImageToViewer(this.getDescriptionForSelectedDisplay() + " - " + this.mResBundle.getString("IDS_IMAGE"));
    }

    @Override
    public void doCopyChartToViewer() {
        this.copyJsonChartItemIntoViewer(false, this.getDescriptionForSelectedDisplay() + " - " + this.mResBundle.getString("IDS_CHART"));
    }

    @Override
    public void doCopyMapToViewer() {
        this.copyJsonChartItemIntoViewer(true, this.getDescriptionForSelectedDisplay() + " - " + this.mResBundle.getString("IDS_MAP"));
    }

    @Override
    public BufferedImage getChartImage() {
        STPClustersMapInteractiveItem sTPClustersMapInteractiveItem = (STPClustersMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        return sTPClustersMapInteractiveItem.getAuxImage();
    }

    @Override
    protected OutputVisPanel getZoomAndPanOutputVisPanel() {
        return this.mMainDisplayPanel;
    }

    @Override
    protected VisControl getZoomAndPanVisControl() {
        return this.mMainDisplayPanel.getVisControl();
    }

    @Override
    protected Dimension getItemSize() {
        Dimension dimension = new Dimension(this.mMainDisplayPanel.getWidth(), this.mMainDisplayPanel.getHeight() + this.mAuxDisplayPanel.getHeight());
        return dimension;
    }

    @Override
    public void processVisCompMainMouseMoved(JSONObject jSONObject, boolean bl) {
        String string = jSONObject.toString();
        STPClustersMapInteractiveItem sTPClustersMapInteractiveItem = (STPClustersMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        if (string.contains("enterRegion") || string.contains("enterLocation")) {
            String string2 = (String)BasicFactory.getItem((Object)jSONObject, (String)"clusterId");
            JSONObject jSONObject2 = sTPClustersMapInteractiveItem.createSelectClusterActionParams(string2);
            sTPClustersMapInteractiveItem.performBarAction("hoverBar", jSONObject2);
        } else if (string.contains("leaveRegion") || string.contains("leaveLocation")) {
            try {
                JSONObject jSONObject3 = JSONObject.parse((String)"{}");
                sTPClustersMapInteractiveItem.performBarAction("leaveBar", jSONObject3);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public void processVisCompAuxMouseMoved(JSONObject jSONObject) {
        String string = jSONObject.toString();
        STPClustersMapInteractiveItem sTPClustersMapInteractiveItem = (STPClustersMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        if (string.contains("enterBar")) {
            String string2 = (String)BasicFactory.getItem((Object)jSONObject, (String)"clusterId");
            JSONObject jSONObject2 = sTPClustersMapInteractiveItem.createSelectClusterActionParams(string2);
            sTPClustersMapInteractiveItem.performHoverAction(jSONObject2);
        } else if (string.contains("leaveBar")) {
            try {
                JSONObject jSONObject3 = JSONObject.parse((String)"{}");
                sTPClustersMapInteractiveItem.performLeaveAction(jSONObject3);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public void processVisCompMainMouseClick(JSONObject jSONObject, boolean bl) {
        if (jSONObject != null && jSONObject.size() > 0) {
            STPClustersMapInteractiveItem sTPClustersMapInteractiveItem = (STPClustersMapInteractiveItem)this.mInteractiveViewerItem.getItem();
            String string = (String)BasicFactory.getItem((Object)jSONObject, (String)"clusterId");
            JSONObject jSONObject2 = sTPClustersMapInteractiveItem.createSelectClusterActionParams(string);
            sTPClustersMapInteractiveItem.performHighlightAction(jSONObject2);
            sTPClustersMapInteractiveItem.performBarAction("highLightBar", jSONObject2);
            this.mMainDisplayPanel.setActionsList(sTPClustersMapInteractiveItem.getMainActionsList());
            this.mAuxDisplayPanel.setActionsList(sTPClustersMapInteractiveItem.getAuxActionsList());
        }
    }

    @Override
    public void processVisCompAuxMouseClick(JSONObject jSONObject) {
        if (jSONObject != null && jSONObject.size() > 0) {
            STPClustersMapInteractiveItem sTPClustersMapInteractiveItem = (STPClustersMapInteractiveItem)this.mInteractiveViewerItem.getItem();
            String string = (String)BasicFactory.getItem((Object)jSONObject, (String)"clusterId");
            JSONObject jSONObject2 = sTPClustersMapInteractiveItem.createSelectClusterActionParams(string);
            sTPClustersMapInteractiveItem.performHighlightAction(jSONObject2);
            sTPClustersMapInteractiveItem.performBarAction("highLightBar", jSONObject2);
            this.mMainDisplayPanel.setActionsList(sTPClustersMapInteractiveItem.getMainActionsList());
            this.mAuxDisplayPanel.setActionsList(sTPClustersMapInteractiveItem.getAuxActionsList());
        }
    }
}

