/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.chart.JsonChartItem;
import com.spss.java_client.core.documents.output.interactive.RulesWordCloudInteractiveItem;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.output.JsonInteractiveViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.interactive.JsonInteractiveFrame;
import com.spss.java_client.ui.interactive.OutputVisPanel;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.output.vis.charting.OutputVisCompStateListener;
import com.spss.output.vis.charting.OutputVisComponent;
import com.spss.shared.export.table_export.TableImager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class RulesWordCloudInteractiveFrame
extends JsonInteractiveFrame
implements ItemListener {
    private static int ID_CONFIDENCE = 0;
    private static int ID_SUPPORT = 1;
    private static int ID_LIFT = 2;
    private static int ID_ANT_SUPPORT = 3;
    private static int ID_DEPLOYABILITY = 4;
    private JSONObject mMostInterestingRulesJson;
    private int mSelectedComboBoxIndex = 0;
    private HashMap<Integer, String> mIndexMap = new HashMap();
    private JComboBox mComboBox;
    private Vector mAvailableSortItems;

    public RulesWordCloudInteractiveFrame(JsonInteractiveViewerItem jsonInteractiveViewerItem) {
        super(jsonInteractiveViewerItem);
        this.setTitle(this.mResBundle.getString("IDS_INTERACTIVE_OUTPUT_TITLE") + this.mResBundle.getString("IDS_INTERACTIVE_OUTPUT_TITLE_SEP") + this.mResBundle.getString("IDS_STEM_RULES_WORD_CLOUD"));
        try {
            ByteBuffer byteBuffer = this.mInteractiveViewerItem.getItem().getVDPData();
            InputStream inputStream = TableImager.getProperInputStream((byte[])byteBuffer.array());
            JSONObject jSONObject = JSONObject.parse((InputStream)inputStream);
            this.mMostInterestingRulesJson = (JSONObject)BasicFactory.getItem((Object)jSONObject, (String)"1");
            this.constructGUI();
            this.constructMenus();
            this.setTabTraversalPolicy();
            this.addWindowListener(this);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    protected void constructGUI() {
        RulesWordCloudInteractiveItem rulesWordCloudInteractiveItem = (RulesWordCloudInteractiveItem)this.mInteractiveViewerItem.getItem();
        OutputVisComponent outputVisComponent = rulesWordCloudInteractiveItem.getMainVisComponent();
        this.mMainDisplayPanel = new OutputVisPanel(outputVisComponent);
        this.mVisCompMainInteracitivity = new JsonInteractiveFrame.VisCompMainInteracitivity(this);
        outputVisComponent.addComponentStateListener((OutputVisCompStateListener)this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.constructCopyToViewerButton(), gridBagConstraints);
        JLabel jLabel = new JLabel(this.mResBundle.getString("IDS_STEM_RULES_WORD_CLOUD_SORT"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 0);
        this.add((Component)jLabel, gridBagConstraints);
        String[] stringArray = this.mResBundle.getStringArray("IDS_STEM_STEP_SEVEN_OUTPUT_WORDLE_SORT_ARRARY");
        this.mAvailableSortItems = new Vector();
        int n = 0;
        Object object = this.mMostInterestingRulesJson.get((Object)RulesWordCloudInteractiveItem.ID_TOP_RULES_CONFIDENCE);
        if (object != null && object instanceof JSONObject) {
            this.mAvailableSortItems.add(stringArray[ID_CONFIDENCE]);
            this.mIndexMap.put(n, RulesWordCloudInteractiveItem.ID_TOP_RULES_CONFIDENCE);
            ++n;
        }
        if ((object = this.mMostInterestingRulesJson.get((Object)RulesWordCloudInteractiveItem.ID_TOP_RULES_SUPPORT)) != null && object instanceof JSONObject) {
            this.mAvailableSortItems.add(stringArray[ID_SUPPORT]);
            this.mIndexMap.put(n, RulesWordCloudInteractiveItem.ID_TOP_RULES_SUPPORT);
            ++n;
        }
        if ((object = this.mMostInterestingRulesJson.get((Object)RulesWordCloudInteractiveItem.ID_TOP_RULES_LIFT)) != null && object instanceof JSONObject) {
            this.mAvailableSortItems.add(stringArray[ID_LIFT]);
            this.mIndexMap.put(n, RulesWordCloudInteractiveItem.ID_TOP_RULES_LIFT);
            ++n;
        }
        if ((object = this.mMostInterestingRulesJson.get((Object)RulesWordCloudInteractiveItem.ID_TOP_RULES_ANT_SUPPORT)) != null && object instanceof JSONObject) {
            this.mAvailableSortItems.add(stringArray[ID_ANT_SUPPORT]);
            this.mIndexMap.put(n, RulesWordCloudInteractiveItem.ID_TOP_RULES_ANT_SUPPORT);
            ++n;
        }
        if ((object = this.mMostInterestingRulesJson.get((Object)RulesWordCloudInteractiveItem.ID_TOP_RULES_DEPLOYABILITY)) != null && object instanceof JSONObject) {
            this.mAvailableSortItems.add(stringArray[ID_DEPLOYABILITY]);
            this.mIndexMap.put(n, RulesWordCloudInteractiveItem.ID_TOP_RULES_DEPLOYABILITY);
        }
        this.mComboBox = new JComboBox(this.mAvailableSortItems);
        this.mComboBox.setPreferredSize(new Dimension(160, 24));
        this.mComboBox.setMinimumSize(new Dimension(160, 24));
        this.mComboBox.setSelectedItem(this.templateIdToSortType(rulesWordCloudInteractiveItem.getSelectedTemplateId()));
        this.mComboBox.addItemListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.add((Component)this.mComboBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        gridBagConstraints.fill = 1;
        this.add((Component)this.mMainDisplayPanel, gridBagConstraints);
    }

    @Override
    protected Vector<Object> addControlsForFocusTraversal(Vector<Object> vector) {
        vector.add(this.mCopyToViewerButton);
        vector.add(this.mComboBox);
        vector.add(this.mMainDisplayPanel.getVisControl());
        return vector;
    }

    @Override
    protected void constructMenus() {
        super.constructMenus();
        JMenu jMenu = this.createCopyToViewerMenu(false);
        this.addItemToMenu(jMenu, "copy_chart_to_viewer");
        this.addItemToMenu(jMenu, "copy_image_to_viewer");
        this.fileMenu.add(jMenu);
        this.fileMenu.addSeparator();
        this.addItemToMenu(this.fileMenu, "print_settings");
        this.fileMenu.addSeparator();
        this.addItemToMenu(this.fileMenu, "file_close");
        JMenu jMenu2 = new JMenu(ResUtil.getString("copy_object"));
        jMenu2.setMnemonic(ResUtil.getAccessKey("copy_object"));
        this.addItemToMenu(jMenu2, "copy_chart_to_clipboard");
        this.addItemToMenu(jMenu2, "copy_image_to_clipboard");
        this.editMenu.add(jMenu2);
        JMenu jMenu3 = new JMenu(ResUtil.getString("view_sort"));
        jMenu3.setMnemonic(ResUtil.getAccessKey("view_sort"));
        String[] stringArray = this.mResBundle.getStringArray("IDS_STEM_STEP_SEVEN_OUTPUT_WORDLE_SORT_ARRARY");
        if (this.mAvailableSortItems.contains(stringArray[ID_CONFIDENCE])) {
            this.addItemToMenu(jMenu3, "sort_by_confidence");
        }
        if (this.mAvailableSortItems.contains(stringArray[ID_SUPPORT])) {
            this.addItemToMenu(jMenu3, "sort_by_support");
        }
        if (this.mAvailableSortItems.contains(stringArray[ID_LIFT])) {
            this.addItemToMenu(jMenu3, "sort_by_lift");
        }
        if (this.mAvailableSortItems.contains(stringArray[ID_ANT_SUPPORT])) {
            this.addItemToMenu(jMenu3, "sort_by_ant_support");
        }
        if (this.mAvailableSortItems.contains(stringArray[ID_DEPLOYABILITY])) {
            this.addItemToMenu(jMenu3, "sort_by_deployability");
        }
        this.viewMenu.add(jMenu3);
        this.addItemToMenu(this.helpMenu, "help_topics");
    }

    @Override
    protected void addCopyToViewerPopupMenuItems(JPopupMenu jPopupMenu) {
        JMenu jMenu = this.createCopyToViewerMenu(true);
        this.addItemToMenu(jMenu, "copy_chart_to_viewer");
        this.addItemToMenu(jMenu, "copy_image_to_viewer");
        jPopupMenu.add(jMenu);
    }

    private void updateDisplayPanels(String string) {
        RulesWordCloudInteractiveItem rulesWordCloudInteractiveItem = (RulesWordCloudInteractiveItem)this.mInteractiveViewerItem.getItem();
        rulesWordCloudInteractiveItem.setSelectedTemplate(string);
        OutputVisComponent outputVisComponent = rulesWordCloudInteractiveItem.getMainVisComponent();
        this.mMainDisplayPanel = new OutputVisPanel(outputVisComponent);
        this.setTabTraversalPolicy();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof JComboBox && itemEvent.getStateChange() == 1) {
            this.mSelectedComboBoxIndex = ((JComboBox)itemEvent.getSource()).getSelectedIndex();
            String string = this.mIndexMap.get(this.mSelectedComboBoxIndex);
            if (string.length() > 0) {
                this.remove(this.mMainDisplayPanel);
                this.updateDisplayPanels(string);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 4;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(4, 0, 4, 0);
                gridBagConstraints.fill = 1;
                this.add((Component)this.mMainDisplayPanel, gridBagConstraints);
                this.validate();
            }
        }
    }

    @Override
    protected String getDescriptionForSelectedDisplay() {
        String string = "";
        String string2 = this.mIndexMap.get(this.mSelectedComboBoxIndex);
        if (string2.equals(RulesWordCloudInteractiveItem.ID_TOP_RULES_CONFIDENCE)) {
            string = this.mResBundle.getString("IDS_STEM_RULES_WORD_CLOUD_CONFIDENCE");
        } else if (string2.equals(RulesWordCloudInteractiveItem.ID_TOP_RULES_SUPPORT)) {
            string = this.mResBundle.getString("IDS_STEM_RULES_WORD_CLOUD_SUPPORT");
        } else if (string2.equals(RulesWordCloudInteractiveItem.ID_TOP_RULES_LIFT)) {
            string = this.mResBundle.getString("IDS_STEM_RULES_WORD_CLOUD_LIFT");
        } else if (string2.equals(RulesWordCloudInteractiveItem.ID_TOP_RULES_ANT_SUPPORT)) {
            string = this.mResBundle.getString("IDS_STEM_RULES_WORD_CLOUD_ANT_SUPPORT");
        } else if (string2.equals(RulesWordCloudInteractiveItem.ID_TOP_RULES_DEPLOYABILITY)) {
            string = this.mResBundle.getString("IDS_STEM_RULES_WORD_CLOUD_DEPLOYABILITY");
        }
        return string;
    }

    @Override
    public void doCopyChartToViewer() {
        RulesWordCloudInteractiveItem rulesWordCloudInteractiveItem = (RulesWordCloudInteractiveItem)this.mInteractiveViewerItem.getItem();
        JsonChartItem jsonChartItem = new JsonChartItem(rulesWordCloudInteractiveItem.getLocale());
        jsonChartItem.setProcedureName(rulesWordCloudInteractiveItem.getProcedureName());
        jsonChartItem.setCreatorVersion(rulesWordCloudInteractiveItem.getCreatorVersion());
        jsonChartItem.setAlignment(rulesWordCloudInteractiveItem.getAlignment());
        jsonChartItem.setTemplate(false);
        jsonChartItem.getGeoJsonIDs().addAll(rulesWordCloudInteractiveItem.getGeoJsonIDs());
        jsonChartItem.setVDPData(rulesWordCloudInteractiveItem.getMainVDPData());
        jsonChartItem.setVisible(true);
        jsonChartItem.setDescription(this.getDescriptionForSelectedDisplay());
        ViewerDocument viewerDocument = ((ITopWindow)((Object)this.mInteractiveViewerItem.getTopLevelAncestor())).getViewerDocument();
        viewerDocument.getCoreDocument().insertItem((IOutputItem)jsonChartItem, (IOutputItem)rulesWordCloudInteractiveItem);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String[] stringArray = this.mResBundle.getStringArray("IDS_STEM_STEP_SEVEN_OUTPUT_WORDLE_SORT_ARRARY");
        if ("sort_by_confidence".equals(actionEvent.getActionCommand())) {
            this.mComboBox.setSelectedItem(stringArray[ID_CONFIDENCE]);
        } else if ("sort_by_support".equals(actionEvent.getActionCommand())) {
            this.mComboBox.setSelectedItem(stringArray[ID_SUPPORT]);
        } else if ("sort_by_lift".equals(actionEvent.getActionCommand())) {
            this.mComboBox.setSelectedItem(stringArray[ID_LIFT]);
        } else if ("sort_by_ant_support".equals(actionEvent.getActionCommand())) {
            this.mComboBox.setSelectedItem(stringArray[ID_ANT_SUPPORT]);
        } else if ("sort_by_deployability".equals(actionEvent.getActionCommand())) {
            this.mComboBox.setSelectedItem(stringArray[ID_DEPLOYABILITY]);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    @Override
    protected Dimension getItemSize() {
        return this.mMainDisplayPanel.getSize();
    }

    private String templateIdToSortType(String string) {
        String string2 = null;
        String[] stringArray = this.mResBundle.getStringArray("IDS_STEM_STEP_SEVEN_OUTPUT_WORDLE_SORT_ARRARY");
        if (string.equals(RulesWordCloudInteractiveItem.ID_TOP_RULES_CONFIDENCE)) {
            string2 = stringArray[ID_CONFIDENCE];
        } else if (string.equals(RulesWordCloudInteractiveItem.ID_TOP_RULES_SUPPORT)) {
            string2 = stringArray[ID_SUPPORT];
        } else if (string.equals(RulesWordCloudInteractiveItem.ID_TOP_RULES_LIFT)) {
            string2 = stringArray[ID_LIFT];
        } else if (string.equals(RulesWordCloudInteractiveItem.ID_TOP_RULES_ANT_SUPPORT)) {
            string2 = stringArray[ID_ANT_SUPPORT];
        } else if (string.equals(RulesWordCloudInteractiveItem.ID_TOP_RULES_DEPLOYABILITY)) {
            string2 = stringArray[ID_DEPLOYABILITY];
        }
        return string2;
    }

    @Override
    public void processVisCompMainMouseClick(JSONObject jSONObject, boolean bl) {
        RulesWordCloudInteractiveItem rulesWordCloudInteractiveItem = (RulesWordCloudInteractiveItem)this.mInteractiveViewerItem.getItem();
        Integer n = (Integer)BasicFactory.getItem((Object)jSONObject, (String)"ruleId");
        rulesWordCloudInteractiveItem.performSelectAction(n);
    }
}

