/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.ui.awt.VisControl;
import com.spss.java_client.core.documents.output.interactive.JsonInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.RulesMapInteractiveItem;
import com.spss.java_client.ui.doc_types.output.JsonInteractiveViewerItem;
import com.spss.java_client.ui.interactive.JsonInteractiveFrame;
import com.spss.java_client.ui.interactive.JsonSplitInteractiveFrame;
import com.spss.java_client.ui.interactive.OutputVisPanel;
import com.spss.java_client.ui.interactive.RulesMapAuxiliaryDisplayPanel;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.output.vis.charting.OutputVisCompStateListener;
import com.spss.output.vis.charting.OutputVisComponent;
import com.spss.shared.export.table_export.TableImager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;

public class RulesMapInteractiveFrame
extends JsonSplitInteractiveFrame
implements ItemListener {
    private static int ID_CONFIDENCE = 0;
    private static int ID_SUPPORT = 1;
    private static int ID_LIFT = 2;
    private static int ID_ANT_SUPPORT = 3;
    private static int ID_DEPLOYABILITY = 4;
    private static String SELECT_RULE_ACTION_PREFIX = "select_rule_";
    private RulesMapAuxiliaryDisplayPanel mAuxDisplayPanel;
    private JSONObject mMostInterestingRulesJson;
    private HashMap<Integer, String> mIndexMap = new HashMap();
    private JComboBox mComboBox;
    private Vector mAvailableSortItems;
    private JMenu mSelectMenu;

    public RulesMapInteractiveFrame(JsonInteractiveViewerItem jsonInteractiveViewerItem) {
        super(jsonInteractiveViewerItem);
        this.setTitle(this.mResBundle.getString("IDS_INTERACTIVE_OUTPUT_TITLE") + this.mResBundle.getString("IDS_INTERACTIVE_OUTPUT_TITLE_SEP") + this.mResBundle.getString("IDS_STEM_RULES_MAP"));
        try {
            ByteBuffer byteBuffer = this.mInteractiveViewerItem.getItem().getVDPData();
            InputStream inputStream = TableImager.getProperInputStream((byte[])byteBuffer.array());
            JSONObject jSONObject = JSONObject.parse((InputStream)inputStream);
            this.mMostInterestingRulesJson = (JSONObject)BasicFactory.getItem((Object)jSONObject, (String)"1");
            this.constructGUI();
            this.constructMenus();
            this.setTabTraversalPolicy();
            this.addWindowListener(this);
            RulesMapInteractiveItem rulesMapInteractiveItem = (RulesMapInteractiveItem)this.mInteractiveViewerItem.getItem();
            if (rulesMapInteractiveItem.getMapSupported()) {
                this.enableZoomAndPanControls(this.mAuxDisplayPanel.getVisControl());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    protected void constructGUI() {
        GridBagConstraints gridBagConstraints;
        GridBagLayout gridBagLayout;
        RulesMapInteractiveItem rulesMapInteractiveItem = (RulesMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        OutputVisComponent outputVisComponent = rulesMapInteractiveItem.getMainVisComponent();
        this.mMainDisplayPanel = new OutputVisPanel(outputVisComponent);
        this.mMainDisplayPanel.setActionsList(rulesMapInteractiveItem.getMainActionsList());
        this.mVisCompMainInteracitivity = new JsonInteractiveFrame.VisCompMainInteracitivity(this);
        this.mCurrentZoomLevel = rulesMapInteractiveItem.getAuxZoomLevel();
        boolean bl = rulesMapInteractiveItem.getMapSupported();
        if (bl) {
            gridBagLayout = (JSONObject)this.mMostInterestingRulesJson.get((Object)"map");
            this.mAuxDisplayPanel = new RulesMapAuxiliaryDisplayPanel(rulesMapInteractiveItem, (JSONObject)gridBagLayout, rulesMapInteractiveItem.getSelectedRuleId());
            gridBagConstraints = this.mAuxDisplayPanel.getVisControl();
            gridBagConstraints.setFocusable(true);
            this.addZoomAndPanListeners((JsonInteractiveItem)rulesMapInteractiveItem, (VisControl)gridBagConstraints);
            outputVisComponent.addComponentStateListener((OutputVisCompStateListener)this);
            this.createSplitPane(1, this.mMainDisplayPanel, this.mAuxDisplayPanel);
        }
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.constructCopyToViewerButton(), gridBagConstraints);
        JLabel jLabel = new JLabel(this.mResBundle.getString("IDS_STEM_RULES_MAP_SORT"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 0);
        this.add((Component)jLabel, gridBagConstraints);
        String[] stringArray = this.mResBundle.getStringArray("IDS_STEM_STEP_SEVEN_OUTPUT_WORDLE_SORT_ARRARY");
        this.mAvailableSortItems = new Vector();
        int n = 0;
        JSONObject jSONObject = (JSONObject)this.mMostInterestingRulesJson.get((Object)"barchart");
        Object object = jSONObject.get((Object)RulesMapInteractiveItem.ID_TOP_RULES_CONFIDENCE);
        if (object != null && object instanceof JSONObject) {
            this.mAvailableSortItems.add(stringArray[ID_CONFIDENCE]);
            this.mIndexMap.put(n, RulesMapInteractiveItem.ID_TOP_RULES_CONFIDENCE);
            ++n;
        }
        if ((object = jSONObject.get((Object)RulesMapInteractiveItem.ID_TOP_RULES_SUPPORT)) != null && object instanceof JSONObject) {
            this.mAvailableSortItems.add(stringArray[ID_SUPPORT]);
            this.mIndexMap.put(n, RulesMapInteractiveItem.ID_TOP_RULES_SUPPORT);
            ++n;
        }
        if ((object = jSONObject.get((Object)RulesMapInteractiveItem.ID_TOP_RULES_LIFT)) != null && object instanceof JSONObject) {
            this.mAvailableSortItems.add(stringArray[ID_LIFT]);
            this.mIndexMap.put(n, RulesMapInteractiveItem.ID_TOP_RULES_LIFT);
            ++n;
        }
        if ((object = jSONObject.get((Object)RulesMapInteractiveItem.ID_TOP_RULES_ANT_SUPPORT)) != null && object instanceof JSONObject) {
            this.mAvailableSortItems.add(stringArray[ID_ANT_SUPPORT]);
            this.mIndexMap.put(n, RulesMapInteractiveItem.ID_TOP_RULES_ANT_SUPPORT);
            ++n;
        }
        if ((object = jSONObject.get((Object)RulesMapInteractiveItem.ID_TOP_RULES_DEPLOYABILITY)) != null && object instanceof JSONObject) {
            this.mAvailableSortItems.add(stringArray[ID_DEPLOYABILITY]);
            this.mIndexMap.put(n, RulesMapInteractiveItem.ID_TOP_RULES_DEPLOYABILITY);
        }
        this.mComboBox = new JComboBox(this.mAvailableSortItems);
        this.mComboBox.setPreferredSize(new Dimension(160, 24));
        this.mComboBox.setMinimumSize(new Dimension(160, 24));
        this.mComboBox.setSelectedItem(this.templateIdToSortType(rulesMapInteractiveItem.getSelectedBarChartTemplateId()));
        this.mComboBox.addItemListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.add((Component)this.mComboBox, gridBagConstraints);
        if (bl) {
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(4, 4, 4, 0);
            this.mZoomInButton = this.constructToolbarButton("zoom_in", "zoom_in_TOOLTIP");
            this.mZoomInButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RulesMapInteractiveItem rulesMapInteractiveItem = (RulesMapInteractiveItem)RulesMapInteractiveFrame.this.mInteractiveViewerItem.getItem();
                    RulesMapInteractiveFrame.this.setZoomLevel(++RulesMapInteractiveFrame.this.mCurrentZoomLevel);
                    RulesMapInteractiveFrame.this.doZoomToLevel((JsonInteractiveItem)rulesMapInteractiveItem, RulesMapInteractiveFrame.this.mAuxDisplayPanel.getOutputVisPanel(), false, RulesMapInteractiveFrame.this.mCurrentZoomLevel);
                }
            });
            this.add((Component)this.mZoomInButton, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.mZoomOutButton = this.constructToolbarButton("zoom_out", "zoom_out_TOOLTIP");
            this.mZoomOutButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RulesMapInteractiveItem rulesMapInteractiveItem = (RulesMapInteractiveItem)RulesMapInteractiveFrame.this.mInteractiveViewerItem.getItem();
                    RulesMapInteractiveFrame.this.setZoomLevel(--RulesMapInteractiveFrame.this.mCurrentZoomLevel);
                    RulesMapInteractiveFrame.this.doZoomToLevel((JsonInteractiveItem)rulesMapInteractiveItem, RulesMapInteractiveFrame.this.mAuxDisplayPanel.getOutputVisPanel(), false, RulesMapInteractiveFrame.this.mCurrentZoomLevel);
                }
            });
            this.add((Component)this.mZoomOutButton, gridBagConstraints);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        gridBagConstraints.fill = 1;
        this.add((Component)(bl ? this.mSplitPane : this.mMainDisplayPanel), gridBagConstraints);
    }

    @Override
    protected Vector<Object> addControlsForFocusTraversal(Vector<Object> vector) {
        vector.add(this.mCopyToViewerButton);
        vector.add(this.mComboBox);
        vector.add(this.mZoomInButton);
        vector.add(this.mZoomOutButton);
        vector.add(this.mMainDisplayPanel.getVisControl());
        vector.add(this.mAuxDisplayPanel.getVisControl());
        return vector;
    }

    @Override
    public void dispose() {
        RulesMapInteractiveItem rulesMapInteractiveItem = (RulesMapInteractiveItem)this.getJsonInteractiveItem();
        boolean bl = rulesMapInteractiveItem.getMapSupported();
        if (bl) {
            OutputVisPanel outputVisPanel = this.mAuxDisplayPanel.getOutputVisPanel();
            if (this.mAuxDisplayPanel != null && outputVisPanel != null) {
                outputVisPanel.getVisComponent().removeComponentStateListener((OutputVisCompStateListener)outputVisPanel);
            }
        }
        super.dispose();
    }

    @Override
    protected void constructMenus() {
        super.constructMenus();
        RulesMapInteractiveItem rulesMapInteractiveItem = (RulesMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        boolean bl = rulesMapInteractiveItem.getMapSupported();
        JMenu jMenu = this.createCopyToViewerMenu(false);
        this.addItemToMenu(jMenu, "copy_chart_to_viewer");
        if (bl) {
            this.addItemToMenu(jMenu, "copy_map_to_viewer");
        }
        this.addItemToMenu(jMenu, "copy_image_to_viewer");
        this.fileMenu.add(jMenu);
        this.fileMenu.addSeparator();
        this.addItemToMenu(this.fileMenu, "print_settings");
        this.fileMenu.addSeparator();
        this.addItemToMenu(this.fileMenu, "file_close");
        JMenu jMenu2 = new JMenu(ResUtil.getString("copy_object"));
        jMenu2.setMnemonic(ResUtil.getAccessKey("copy_object"));
        this.addItemToMenu(jMenu2, "copy_chart_to_clipboard");
        if (bl) {
            this.addItemToMenu(jMenu2, "copy_map_to_clipboard");
        }
        this.addItemToMenu(jMenu2, "copy_image_to_clipboard");
        this.editMenu.add(jMenu2);
        JMenu jMenu3 = new JMenu(ResUtil.getString("view_sort"));
        jMenu3.setMnemonic(ResUtil.getAccessKey("view_sort"));
        String[] stringArray = this.mResBundle.getStringArray("IDS_STEM_STEP_SEVEN_OUTPUT_WORDLE_SORT_ARRARY");
        if (this.mAvailableSortItems.contains(stringArray[ID_CONFIDENCE])) {
            this.addItemToMenu(jMenu3, "sort_by_confidence");
        }
        if (this.mAvailableSortItems.contains(stringArray[ID_SUPPORT])) {
            this.addItemToMenu(jMenu3, "sort_by_support");
        }
        if (this.mAvailableSortItems.contains(stringArray[ID_LIFT])) {
            this.addItemToMenu(jMenu3, "sort_by_lift");
        }
        if (this.mAvailableSortItems.contains(stringArray[ID_ANT_SUPPORT])) {
            this.addItemToMenu(jMenu3, "sort_by_ant_support");
        }
        if (this.mAvailableSortItems.contains(stringArray[ID_DEPLOYABILITY])) {
            this.addItemToMenu(jMenu3, "sort_by_deployability");
        }
        this.viewMenu.add(jMenu3);
        this.mSelectMenu = new JMenu(ResUtil.getString("view_select"));
        this.mSelectMenu.setMnemonic(ResUtil.getAccessKey("view_select"));
        this.addRulesToSelectMenu();
        this.viewMenu.add(this.mSelectMenu);
        if (bl) {
            this.viewMenu.add(this.constructZoomMenu());
            this.viewMenu.add(this.constructPanMenu());
            this.setZoomLevel(this.mCurrentZoomLevel);
            this.doZoomToLevel((JsonInteractiveItem)rulesMapInteractiveItem, this.mAuxDisplayPanel.getOutputVisPanel(), false, this.mCurrentZoomLevel);
        }
        this.addItemToMenu(this.helpMenu, "help_topics");
    }

    private void addRulesToSelectMenu() {
        RulesMapInteractiveItem rulesMapInteractiveItem = (RulesMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        this.mSelectMenu.removeAll();
        JSONArray jSONArray = rulesMapInteractiveItem.getRuleIdsArray();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < jSONArray.size(); ++i) {
            String string = BasicFactory.getArrayItem((JSONArray)jSONArray, (int)i).toString();
            String string2 = this.mResBundle.getString("IDS_STEM_RULE_PREFIX");
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string2 + string);
            buttonGroup.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.setMnemonic(string.charAt(string.length() - 1));
            jRadioButtonMenuItem.setActionCommand(SELECT_RULE_ACTION_PREFIX + string);
            jRadioButtonMenuItem.addActionListener(this);
            this.mSelectMenu.add(jRadioButtonMenuItem);
        }
        this.selectRuleMenuItem(rulesMapInteractiveItem.getSelectedRuleId());
    }

    private void selectRuleMenuItem(String string) {
        String string2 = this.mResBundle.getString("IDS_STEM_RULE_PREFIX");
        for (int i = 0; i < this.mSelectMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = this.mSelectMenu.getItem(i);
            if (jMenuItem.getText().compareTo(string2 + string) != 0) continue;
            jMenuItem.setSelected(true);
            break;
        }
        this.performRuleSelectionAction(string);
    }

    @Override
    protected void addCopyToViewerPopupMenuItems(JPopupMenu jPopupMenu) {
        RulesMapInteractiveItem rulesMapInteractiveItem = (RulesMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        boolean bl = rulesMapInteractiveItem.getMapSupported();
        JMenu jMenu = this.createCopyToViewerMenu(true);
        this.addItemToMenu(jMenu, "copy_chart_to_viewer");
        if (bl) {
            this.addItemToMenu(jMenu, "copy_map_to_viewer");
        }
        this.addItemToMenu(jMenu, "copy_image_to_viewer");
        jPopupMenu.add(jMenu);
    }

    private void updateDisplayPanels(String string) {
        RulesMapInteractiveItem rulesMapInteractiveItem = (RulesMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        this.mMainDisplayPanel = new OutputVisPanel(rulesMapInteractiveItem.getMainVisComponent());
        this.mMainDisplayPanel.setActionsList(rulesMapInteractiveItem.getMainActionsList());
        boolean bl = rulesMapInteractiveItem.getMapSupported();
        if (bl) {
            JSONObject jSONObject = (JSONObject)this.mMostInterestingRulesJson.get((Object)"map");
            this.mAuxDisplayPanel.setAuxiliaryJsons(jSONObject);
        }
        rulesMapInteractiveItem.setSelectedTemplates(string, rulesMapInteractiveItem.getSelectedRuleId());
        this.setTabTraversalPolicy();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n;
        String string;
        RulesMapInteractiveItem rulesMapInteractiveItem = (RulesMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        boolean bl = rulesMapInteractiveItem.getMapSupported();
        if (itemEvent.getSource() instanceof JComboBox && itemEvent.getStateChange() == 1 && (string = this.mIndexMap.get(n = ((JComboBox)itemEvent.getSource()).getSelectedIndex())).length() > 0) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 6;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(4, 0, 4, 0);
            gridBagConstraints.fill = 1;
            if (bl) {
                this.remove(this.mSplitPane);
                this.updateDisplayPanels(string);
                this.mSplitPane = new JSplitPane(1, this.mMainDisplayPanel, this.mAuxDisplayPanel);
                this.mSplitPane.setDividerLocation(rulesMapInteractiveItem.calculateMainVisualizationProportion(this.mInteractiveViewerItem.getItem().getWidth()));
                this.mSplitPane.setDividerSize(10);
                this.mSplitPane.setOneTouchExpandable(true);
                this.mSplitPane.addPropertyChangeListener("dividerLocation", this);
                this.add((Component)this.mSplitPane, gridBagConstraints);
            } else {
                this.remove(this.mMainDisplayPanel);
                this.updateDisplayPanels(string);
                this.add((Component)this.mMainDisplayPanel, gridBagConstraints);
            }
            rulesMapInteractiveItem.setDescription(this.sortTypeToDescription(n));
            this.addRulesToSelectMenu();
            this.validate();
        }
    }

    @Override
    public void doCopyChartToViewer() {
        this.copyJsonChartItemIntoViewer(true);
    }

    @Override
    public void doCopyMapToViewer() {
        this.copyJsonChartItemIntoViewer(false);
    }

    @Override
    public BufferedImage getMapImage() {
        RulesMapInteractiveItem rulesMapInteractiveItem = (RulesMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        return rulesMapInteractiveItem.getAuxImage();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String[] stringArray = this.mResBundle.getStringArray("IDS_STEM_STEP_SEVEN_OUTPUT_WORDLE_SORT_ARRARY");
        if ("sort_by_confidence".equals(actionEvent.getActionCommand())) {
            this.mComboBox.setSelectedItem(stringArray[ID_CONFIDENCE]);
        } else if ("sort_by_support".equals(actionEvent.getActionCommand())) {
            this.mComboBox.setSelectedItem(stringArray[ID_SUPPORT]);
        } else if ("sort_by_lift".equals(actionEvent.getActionCommand())) {
            this.mComboBox.setSelectedItem(stringArray[ID_LIFT]);
        } else if ("sort_by_ant_support".equals(actionEvent.getActionCommand())) {
            this.mComboBox.setSelectedItem(stringArray[ID_ANT_SUPPORT]);
        } else if ("sort_by_deployability".equals(actionEvent.getActionCommand())) {
            this.mComboBox.setSelectedItem(stringArray[ID_DEPLOYABILITY]);
        } else if (actionEvent.getActionCommand().startsWith(SELECT_RULE_ACTION_PREFIX)) {
            String string = actionEvent.getActionCommand().substring(SELECT_RULE_ACTION_PREFIX.length());
            this.performRuleSelectionAction(string);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private void performRuleSelectionAction(String string) {
        RulesMapInteractiveItem rulesMapInteractiveItem = (RulesMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        rulesMapInteractiveItem.performSelectAction(Integer.valueOf(string));
        this.mMainDisplayPanel.setActionsList(rulesMapInteractiveItem.getMainActionsList());
        this.mAuxDisplayPanel.showAuxiliaryDisplay(string);
    }

    @Override
    protected OutputVisPanel getZoomAndPanOutputVisPanel() {
        return this.mAuxDisplayPanel.getOutputVisPanel();
    }

    @Override
    protected boolean getZoomAndPanOnMainPanel() {
        return false;
    }

    @Override
    protected BufferedImage getImageToCopy(boolean bl) {
        BufferedImage bufferedImage;
        if (!bl) {
            JSONObject jSONObject = this.mMainDisplayPanel.getRenderingVisSpec();
            VisControl visControl = new VisControl(null, null);
            visControl.setSpecification(jSONObject);
            bufferedImage = (BufferedImage)visControl.makeImage();
        } else {
            bufferedImage = (BufferedImage)this.mAuxDisplayPanel.getVisControl().makeImage();
        }
        return bufferedImage;
    }

    @Override
    protected Dimension getItemSize() {
        RulesMapInteractiveItem rulesMapInteractiveItem = (RulesMapInteractiveItem)this.mInteractiveViewerItem.getItem();
        boolean bl = rulesMapInteractiveItem.getMapSupported();
        Dimension dimension = bl ? new Dimension(this.mMainDisplayPanel.getWidth() + this.mAuxDisplayPanel.getWidth(), this.mMainDisplayPanel.getHeight()) : new Dimension(this.mMainDisplayPanel.getWidth(), this.mMainDisplayPanel.getHeight());
        return dimension;
    }

    private String templateIdToSortType(String string) {
        String string2 = null;
        String[] stringArray = this.mResBundle.getStringArray("IDS_STEM_STEP_SEVEN_OUTPUT_WORDLE_SORT_ARRARY");
        if (string.equals(RulesMapInteractiveItem.ID_TOP_RULES_CONFIDENCE)) {
            string2 = stringArray[ID_CONFIDENCE];
        } else if (string.equals(RulesMapInteractiveItem.ID_TOP_RULES_SUPPORT)) {
            string2 = stringArray[ID_SUPPORT];
        } else if (string.equals(RulesMapInteractiveItem.ID_TOP_RULES_LIFT)) {
            string2 = stringArray[ID_LIFT];
        } else if (string.equals(RulesMapInteractiveItem.ID_TOP_RULES_ANT_SUPPORT)) {
            string2 = stringArray[ID_ANT_SUPPORT];
        } else if (string.equals(RulesMapInteractiveItem.ID_TOP_RULES_DEPLOYABILITY)) {
            string2 = stringArray[ID_DEPLOYABILITY];
        }
        return string2;
    }

    private String sortTypeToDescription(int n) {
        String string = n == ID_CONFIDENCE ? this.mResBundle.getString("IDS_STEM_RULES_CONFIDENCE") : (n == ID_SUPPORT ? this.mResBundle.getString("IDS_STEM_RULES_SUPPORT") : (n == ID_LIFT ? this.mResBundle.getString("IDS_STEM_RULES_LIFT") : (n == ID_ANT_SUPPORT ? this.mResBundle.getString("IDS_STEM_RULES_ANT_SUPPORT") : this.mResBundle.getString("IDS_STEM_RULES_DEPLOYABILITY"))));
        return string;
    }

    @Override
    public void processVisCompMainMouseClick(JSONObject jSONObject, boolean bl) {
        Integer n = (Integer)BasicFactory.getItem((Object)jSONObject, (String)"ruleId");
        this.selectRuleMenuItem(n.toString());
    }
}

