/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive;

import com.ibm.json.java.JSONArray;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.chart.JsonChartItem;
import com.spss.java_client.core.documents.output.interactive.PredictorImportanceInteractiveItem;
import com.spss.java_client.ui.controls.double_slider.DoubleSlider;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.output.JsonInteractiveViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.interactive.JsonInteractiveFrame;
import com.spss.java_client.ui.interactive.OutputVisPanel;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.output.vis.charting.OutputVisCompStateListener;
import com.spss.output.vis.charting.OutputVisComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PredictorImportanceInteractiveFrame
extends JsonInteractiveFrame
implements ChangeListener {
    private static final int MAJOR_TICK_SPACING = 1;
    private DoubleSlider mPredictorDoubleSlider;
    private boolean mShowSlider = false;

    public PredictorImportanceInteractiveFrame(JsonInteractiveViewerItem jsonInteractiveViewerItem) {
        super(jsonInteractiveViewerItem);
        this.setTitle(this.mResBundle.getString("IDS_INTERACTIVE_OUTPUT_TITLE") + this.mResBundle.getString("IDS_INTERACTIVE_OUTPUT_TITLE_SEP") + this.mResBundle.getString("IDS_PREDICTOR_IMPORTANCE"));
        this.constructGUI();
        this.constructMenus();
        this.setTabTraversalPolicy();
        this.addWindowListener(this);
        if (this.mPredictorDoubleSlider != null) {
            this.mPredictorDoubleSlider.addChangeListener(this);
        }
    }

    public boolean showSlider() {
        return this.mShowSlider;
    }

    @Override
    protected Vector<Object> addControlsForFocusTraversal(Vector<Object> vector) {
        vector.add(this.mCopyToViewerButton);
        vector.add(this.mMainDisplayPanel.getVisControl());
        vector.add(this.mPredictorDoubleSlider);
        return vector;
    }

    @Override
    protected void constructGUI() {
        PredictorImportanceInteractiveItem predictorImportanceInteractiveItem = (PredictorImportanceInteractiveItem)this.mInteractiveViewerItem.getItem();
        OutputVisComponent outputVisComponent = predictorImportanceInteractiveItem.getMainVisComponent();
        this.mMainDisplayPanel = new OutputVisPanel(outputVisComponent);
        this.mMainDisplayPanel.setActionsList(predictorImportanceInteractiveItem.getMainActionsList());
        this.mVisCompMainInteracitivity = new JsonInteractiveFrame.VisCompMainInteracitivity(this);
        List list = predictorImportanceInteractiveItem.getChosenPredictorValues();
        String string = predictorImportanceInteractiveItem.getMinPredictor();
        HashMap<String, String> hashMap = this.makeRelabelMap(list, predictorImportanceInteractiveItem.getPreditorCategories(), string);
        boolean bl = this.mShowSlider = list.size() > 2;
        if (this.mShowSlider) {
            this.mPredictorDoubleSlider = new DoubleSlider(list, hashMap);
            this.mPredictorDoubleSlider.setRangeFixed(true);
            this.mPredictorDoubleSlider.setMajorTickSpacing(1);
            this.setSliderInitialValues(predictorImportanceInteractiveItem);
            this.mPredictorDoubleSlider.setPreferredSize(new Dimension(100, 40));
        }
        outputVisComponent.addComponentStateListener((OutputVisCompStateListener)this);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(3));
        jPanel.add(this.constructCopyToViewerButton());
        this.add((Component)jPanel, "North");
        this.add((Component)this.mMainDisplayPanel, "Center");
        if (this.mShowSlider) {
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 3, 10, 10));
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            DialogUtil.addUsingGBL(jPanel2, this.mPredictorDoubleSlider, gridBagConstraints, 0, 0, 2, 1, 18, null);
            JLabel jLabel = new JLabel(this.mResBundle.getString("IDS_PREDICTOR_LEAST"), 4);
            JLabel jLabel2 = new JLabel(this.mResBundle.getString("IDS_PREDICTOR_MOST"));
            DialogUtil.addUsingGBL(jPanel2, jLabel2, gridBagConstraints, 0, 1, 1, 1, 17, null);
            DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 1, 1, 1, 1, 13, null);
            jPanel2.setBackground(Color.white);
            this.add((Component)jPanel2, "South");
        }
    }

    @Override
    protected void constructMenus() {
        BitSet bitSet = new BitSet();
        bitSet.set(MENU_OPTION_FILE);
        bitSet.set(MENU_OPTION_EDIT);
        bitSet.set(MENU_OPTION_HELP);
        this.constructMenus(bitSet);
        JMenu jMenu = this.createCopyToViewerMenu(false);
        this.addItemToMenu(jMenu, "copy_chart_to_viewer");
        this.addItemToMenu(jMenu, "copy_image_to_viewer");
        this.fileMenu.add(jMenu);
        this.fileMenu.addSeparator();
        this.addItemToMenu(this.fileMenu, "print_settings");
        this.fileMenu.addSeparator();
        this.addItemToMenu(this.fileMenu, "file_close");
        JMenu jMenu2 = new JMenu(ResUtil.getString("copy_object"));
        jMenu2.setMnemonic(ResUtil.getAccessKey("copy_object"));
        this.addItemToMenu(jMenu2, "copy_chart_to_clipboard");
        this.addItemToMenu(jMenu2, "copy_image_to_clipboard");
        this.editMenu.add(jMenu2);
        this.addItemToMenu(this.helpMenu, "help_topics");
    }

    @Override
    protected void addCopyToViewerPopupMenuItems(JPopupMenu jPopupMenu) {
        JMenu jMenu = this.createCopyToViewerMenu(true);
        this.addItemToMenu(jMenu, "copy_chart_to_viewer");
        this.addItemToMenu(jMenu, "copy_image_to_viewer");
        jPopupMenu.add(jMenu);
    }

    @Override
    public void doCopyChartToViewer() {
        PredictorImportanceInteractiveItem predictorImportanceInteractiveItem = (PredictorImportanceInteractiveItem)this.mInteractiveViewerItem.getItem();
        JsonChartItem jsonChartItem = new JsonChartItem(predictorImportanceInteractiveItem.getLocale());
        jsonChartItem.setProcedureName(predictorImportanceInteractiveItem.getProcedureName());
        jsonChartItem.setCreatorVersion(predictorImportanceInteractiveItem.getCreatorVersion());
        jsonChartItem.setAlignment(predictorImportanceInteractiveItem.getAlignment());
        jsonChartItem.setTemplate(false);
        jsonChartItem.getGeoJsonIDs().addAll(predictorImportanceInteractiveItem.getGeoJsonIDs());
        jsonChartItem.setVDPData(predictorImportanceInteractiveItem.getMainVDPData());
        jsonChartItem.setVisible(true);
        jsonChartItem.setDescription(this.getDescriptionForSelectedDisplay());
        ViewerDocument viewerDocument = ((ITopWindow)((Object)this.mInteractiveViewerItem.getTopLevelAncestor())).getViewerDocument();
        viewerDocument.getCoreDocument().insertItem((IOutputItem)jsonChartItem, (IOutputItem)predictorImportanceInteractiveItem);
    }

    @Override
    protected Dimension getItemSize() {
        return this.mMainDisplayPanel.getSize();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (jSlider == this.mPredictorDoubleSlider && !jSlider.getValueIsAdjusting()) {
            String string = this.mPredictorDoubleSlider.getValueFor(this.mPredictorDoubleSlider.getHighValue());
            String string2 = this.mPredictorDoubleSlider.getValueFor(this.mPredictorDoubleSlider.getLowValue());
            PredictorImportanceInteractiveItem predictorImportanceInteractiveItem = (PredictorImportanceInteractiveItem)this.mInteractiveViewerItem.getItem();
            predictorImportanceInteractiveItem.performFilterBarsAction(Integer.parseInt(string2), Integer.parseInt(string));
            this.mMainDisplayPanel.setActionsList(predictorImportanceInteractiveItem.getMainActionsList());
            this.mMainDisplayPanel.viewUpdate();
        }
    }

    private HashMap<String, String> makeRelabelMap(List<String> list, JSONArray jSONArray, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : list) {
            String string3;
            try {
                string3 = (String)jSONArray.get(Integer.valueOf(string2).intValue());
            }
            catch (Exception exception) {
                string3 = (String)jSONArray.get(Integer.valueOf(string).intValue());
            }
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    private void setSliderInitialValues(PredictorImportanceInteractiveItem predictorImportanceInteractiveItem) {
        List list = predictorImportanceInteractiveItem.getChosenPredictorValues();
        String string = predictorImportanceInteractiveItem.getSelectedPredictorRange();
        if (string != null && string.length() > 0) {
            String[] stringArray = string.split(",");
            int n = list.indexOf(stringArray[0]);
            int n2 = list.indexOf(stringArray[1]);
            this.mPredictorDoubleSlider.setValues(n, n2);
        }
    }
}

