/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.interaction.Interactivity;
import com.ibm.vis.interaction.ViewportZoom;
import com.ibm.vis.ui.awt.VisControl;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.interactive.event.MouseAdapterListener;
import com.spss.java_client.ui.interactive.event.VisControlMouseListener;
import com.spss.java_client.ui.interactive.event.VisControlMouseSelection;
import com.spss.java_client.ui.interactive.event.VisControlMouseTooltip;
import com.spss.output.vis.charting.OutputVisCompStateListener;
import com.spss.output.vis.charting.OutputVisComponent;
import com.spss.output.vis.charting.ViewInteractivity;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class OutputVisPanel
extends JComponent
implements OutputVisCompStateListener,
FocusListener {
    private OutputVisComponent mVisComp;
    private VisControl mVisControl;
    private JSONObject mVisSpecJSON;
    private List<JSONObject> mActionJSONList = new ArrayList<JSONObject>();
    private List<VisControlMouseListener> mMouseListeners;
    protected double[][] mViewport;
    private static int sBorderThickness = 1;
    private static Border sActiveBorder;
    private static Border sInactiveBorder;

    public OutputVisPanel(OutputVisComponent outputVisComponent) {
        this.mVisComp = outputVisComponent;
        this.mViewport = new double[2][2];
        this.mViewport[0][0] = 0.0;
        this.mViewport[0][1] = 1.0;
        this.mViewport[1][0] = 0.0;
        this.mViewport[1][1] = 1.0;
        this.constructGUI();
        this.updateVisibility();
        this.constructEventHandler();
    }

    private void constructGUI() {
        this.setLayout(null);
        this.mVisControl = new VisControl(null, null);
        this.mVisControl.addFocusListener((FocusListener)this);
        this.add((Component)this.mVisControl);
    }

    private void constructEventHandler() {
        this.mMouseListeners = new ArrayList<VisControlMouseListener>();
        TargetVisControlMouseSelection targetVisControlMouseSelection = new TargetVisControlMouseSelection(this.mVisControl, this.mVisComp.getViewInteractivity());
        targetVisControlMouseSelection.setEnabled(true);
        this.mMouseListeners.add(targetVisControlMouseSelection);
        VisControlMouseTooltip visControlMouseTooltip = new VisControlMouseTooltip(this.mVisControl);
        visControlMouseTooltip.setEnabled(true);
        this.mMouseListeners.add(visControlMouseTooltip);
        TargetVisMouseAdapterListener targetVisMouseAdapterListener = new TargetVisMouseAdapterListener();
        targetVisMouseAdapterListener.setListener(this.mVisControl, this.mMouseListeners);
        this.mVisControl.addMouseListener((MouseListener)targetVisMouseAdapterListener);
        this.mVisControl.addMouseMotionListener((MouseMotionListener)targetVisMouseAdapterListener);
        this.addComponentListener(new VisPanelComponentAdapter());
        this.mVisComp.addComponentStateListener((OutputVisCompStateListener)this);
    }

    public void setViewport(double[][] dArray) {
        this.mViewport = dArray;
        this.mVisControl.getInteractivity().getViewportZoom().setViewport(this.mViewport);
    }

    public synchronized void updateSpecification() {
        Dimension dimension = this.getSize();
        JSONObject jSONObject = this.mVisComp.getViewChartTemplate(Integer.valueOf(dimension.width), Integer.valueOf(dimension.height));
        if (!(jSONObject == null || this.mVisControl == null || this.mVisSpecJSON != null && this.mVisSpecJSON.equals((Object)jSONObject))) {
            this.mVisSpecJSON = jSONObject;
            this.mVisControl.setSpecification(this.mVisSpecJSON);
            ViewportZoom viewportZoom = this.mVisControl.getInteractivity().getViewportZoom();
            if (viewportZoom != null) {
                viewportZoom.setViewport(this.mViewport);
            }
        }
    }

    public OutputVisComponent getVisComponent() {
        return this.mVisComp;
    }

    private void setVisControlSize(int n, int n2) {
        n -= sBorderThickness * 2;
        n2 -= sBorderThickness * 2;
        if (this.mVisControl.hasFocus()) {
            n -= sBorderThickness * 2;
            n2 -= sBorderThickness * 2;
        }
        this.mVisControl.setBounds(new Rectangle(sBorderThickness, sBorderThickness, n, n2));
        this.mVisControl.setSize(new Dimension(n, n2));
    }

    private void updateVisibility() {
        this.setVisControlSize(this.getSize().width, this.getSize().height);
        this.mVisControl.setVisible(true);
    }

    public void viewUpdate() {
        this.mVisComp.showView(this.mActionJSONList);
    }

    public VisControl getVisControl() {
        return this.mVisControl;
    }

    public void viewChartTemplateUpdate() {
        this.setVisControlSize(this.getSize().width, this.getSize().height);
        this.updateSpecification();
    }

    public JSONObject getRenderingVisSpec() {
        return this.mVisControl.getSpecification();
    }

    public Interactivity getInteractivity() {
        return this.mVisControl.getInteractivity();
    }

    public List<JSONObject> getActionsList() {
        return this.mActionJSONList;
    }

    public void setActionsList(List<JSONObject> list) {
        this.mActionJSONList = list;
    }

    public void setActivePane(boolean bl) {
        if (sActiveBorder == null || sInactiveBorder == null) {
            Border border = this.getBorder();
            if (border == null) {
                border = UIManager.getBorder("ScrollPane.viewportBorder");
            }
            Border border2 = BorderFactory.createLineBorder(DialogUtil.getFocusBorderColor(), sBorderThickness);
            Border border3 = BorderFactory.createLineBorder(Color.white, sBorderThickness);
            sActiveBorder = BorderFactory.createCompoundBorder(border, border2);
            sInactiveBorder = BorderFactory.createCompoundBorder(border, border3);
        }
        if (bl) {
            this.setBorder(sActiveBorder);
        } else {
            this.setBorder(sInactiveBorder);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.setActivePane(true);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.setActivePane(false);
    }

    class TargetVisMouseAdapterListener
    extends MouseAdapterListener {
        TargetVisMouseAdapterListener() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            super.mouseDragged(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
        }
    }

    class TargetVisControlMouseSelection
    extends VisControlMouseSelection {
        public TargetVisControlMouseSelection(VisControl visControl, ViewInteractivity viewInteractivity) {
            super(visControl, viewInteractivity);
        }

        @Override
        public void receiveMouseMoved(int n, int n2, VisControlMouseListener.ButtonCode buttonCode, boolean bl, boolean bl2) {
            super.receiveMouseMoved(n, n2, buttonCode, bl, bl2);
        }

        @Override
        public void receiveMouseClicked(int n, int n2, VisControlMouseListener.ButtonCode buttonCode, boolean bl, boolean bl2) {
            super.receiveMouseClicked(n, n2, buttonCode, bl, bl2);
        }

        @Override
        public void receiveMouseDoubleClicked(int n, int n2, VisControlMouseListener.ButtonCode buttonCode, boolean bl, boolean bl2) {
            super.receiveMouseDoubleClicked(n, n2, buttonCode, bl, bl2);
        }
    }

    class VisPanelComponentAdapter
    extends ComponentAdapter {
        VisPanelComponentAdapter() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            OutputVisPanel.this.setVisControlSize(componentEvent.getComponent().getSize().width, componentEvent.getComponent().getSize().height);
            OutputVisPanel.this.viewUpdate();
        }
    }
}

