/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.spss.java_client.core.documents.output.OutputItem;
import com.spss.java_client.core.documents.output.chart.JsonChartItem;
import com.spss.java_client.core.documents.output.interactive.JsonInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.JsonSplitInteractiveItem;
import com.spss.java_client.ui.doc_types.output.JsonInteractiveViewerItem;
import com.spss.java_client.ui.interactive.JsonInteractiveFrame;
import com.spss.java_client.ui.interactive.OutputVisPanel;
import com.spss.output.vis.charting.OutputVisCompStateListener;
import com.spss.output.vis.charting.OutputVisComponent;
import com.spss.output.vis.charting.ViewInteractivityListener;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

public abstract class JsonSplitInteractiveFrame
extends JsonInteractiveFrame
implements PropertyChangeListener {
    protected static final int SPLIT_PANE_DIVIDER_SIZE = 10;
    protected OutputVisPanel mAuxDisplayPanel;
    protected VisCompAuxInteracitivity mVisCompAuxInteracitivity;
    protected JSplitPane mSplitPane;

    public JsonSplitInteractiveFrame(JsonInteractiveViewerItem jsonInteractiveViewerItem) {
        super(jsonInteractiveViewerItem);
    }

    @Override
    protected Vector<Object> addControlsForFocusTraversal(Vector<Object> vector) {
        vector = super.addControlsForFocusTraversal(vector);
        if (this.mAuxDisplayPanel != null && this.mAuxDisplayPanel.getVisControl() != null) {
            vector.add(this.mAuxDisplayPanel.getVisControl());
        }
        return vector;
    }

    @Override
    public void dispose() {
        JsonSplitInteractiveItem jsonSplitInteractiveItem = (JsonSplitInteractiveItem)this.getJsonInteractiveItem();
        OutputVisComponent outputVisComponent = jsonSplitInteractiveItem.getAuxiliaryVisComponent();
        if (outputVisComponent != null) {
            outputVisComponent.removeComponentStateListener((OutputVisCompStateListener)this);
            if (outputVisComponent.getViewInteractivity() != null) {
                outputVisComponent.getViewInteractivity().removeInteractivityListener((ViewInteractivityListener)this.mVisCompAuxInteracitivity);
            }
        }
        if (this.mAuxDisplayPanel != null) {
            this.mAuxDisplayPanel.getVisComponent().removeComponentStateListener((OutputVisCompStateListener)this.mAuxDisplayPanel);
        }
        super.dispose();
    }

    protected void createSplitPane(int n, JComponent jComponent, JComponent jComponent2) {
        JsonSplitInteractiveItem jsonSplitInteractiveItem = (JsonSplitInteractiveItem)this.mInteractiveViewerItem.getItem();
        this.mSplitPane = new JSplitPane(n, jComponent, jComponent2);
        this.mSplitPane.setDividerLocation(jsonSplitInteractiveItem.calculateMainVisualizationProportion(n == 0 ? jsonSplitInteractiveItem.getHeight() : jsonSplitInteractiveItem.getWidth()));
        this.mSplitPane.setDividerSize(10);
        this.mSplitPane.setOneTouchExpandable(true);
        this.mSplitPane.addPropertyChangeListener("dividerLocation", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateMainVisualizationProportion();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        super.componentResized(componentEvent);
        this.updateMainVisualizationProportion();
    }

    protected void copyJsonChartItemIntoViewer(boolean bl) {
        this.copyJsonChartItemIntoViewer(bl, this.getDescriptionForSelectedDisplay());
    }

    protected void copyJsonChartItemIntoViewer(boolean bl, String string) {
        JsonSplitInteractiveItem jsonSplitInteractiveItem = (JsonSplitInteractiveItem)this.mInteractiveViewerItem.getItem();
        JsonChartItem jsonChartItem = this.constructJsonChartItem((JsonInteractiveItem)jsonSplitInteractiveItem, string);
        if (bl) {
            jsonChartItem.setVDPData(jsonSplitInteractiveItem.getMainVDPData());
        } else {
            jsonChartItem.setVDPData(jsonSplitInteractiveItem.getAuxiliaryVDPData());
        }
        this.insertItemIntoViewer((OutputItem)jsonChartItem);
    }

    protected void copyOutputTableIntoViewer(boolean bl) {
    }

    protected void copyJsonTableItemIntoViewer(boolean bl) {
    }

    private void updateMainVisualizationProportion() {
        JsonSplitInteractiveItem jsonSplitInteractiveItem = (JsonSplitInteractiveItem)this.mInteractiveViewerItem.getItem();
        if (jsonSplitInteractiveItem.isRenderAsMessage()) {
            return;
        }
        int n = this.mSplitPane.getDividerLocation();
        jsonSplitInteractiveItem.setMainVisualizationProportion(Double.valueOf((double)n / (this.mSplitPane.getOrientation() == 0 ? this.getItemSize().getHeight() : this.getItemSize().getWidth())));
    }

    public void processVisCompAuxMouseClick(JSONObject jSONObject) {
    }

    public void processVisCompAuxMouseMoved(JSONObject jSONObject) {
    }

    class VisCompAuxInteracitivity
    implements ViewInteractivityListener {
        private JsonSplitInteractiveFrame mWhoToProcessEvents;

        public VisCompAuxInteracitivity(JsonSplitInteractiveFrame jsonSplitInteractiveFrame2) {
            this.mWhoToProcessEvents = jsonSplitInteractiveFrame2;
            ((JsonSplitInteractiveItem)JsonSplitInteractiveFrame.this.mInteractiveViewerItem.getItem()).getAuxiliaryVisComponent().getViewInteractivity().addInteractivityListener((ViewInteractivityListener)this);
        }

        public Boolean accept(ViewInteractivityListener.InteractivityEvent interactivityEvent) {
            return true;
        }

        public void update(ViewInteractivityListener.InteractivityEvent interactivityEvent, JSONObject jSONObject) {
            if (this.mWhoToProcessEvents.hasFrameBeenClosed()) {
                return;
            }
            if (interactivityEvent == ViewInteractivityListener.InteractivityEvent.MouseClicked && jSONObject != null && BasicFactory.isObject((Object)jSONObject)) {
                this.mWhoToProcessEvents.processVisCompAuxMouseClick(jSONObject);
            } else if (interactivityEvent == ViewInteractivityListener.InteractivityEvent.MouseMoved && jSONObject != null && BasicFactory.isObject((Object)jSONObject)) {
                this.mWhoToProcessEvents.processVisCompAuxMouseMoved(jSONObject);
            }
        }
    }
}

