/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive;

import com.ibm.json.java.JSONObject;
import com.ibm.statistics.lighttable.tablecomponent.TableComponent;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.ui.awt.VisControl;
import com.spss.java_client.core.comp_util.ASLExecutor;
import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.OutputItem;
import com.spss.java_client.core.documents.output.chart.JsonChartItem;
import com.spss.java_client.core.documents.output.header.HeaderItem;
import com.spss.java_client.core.documents.output.interactive.JsonInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.JsonSplitInteractiveItem;
import com.spss.java_client.core.documents.output.rgraph.ImageItem;
import com.spss.java_client.core.documents.output.text.TitleItem;
import com.spss.java_client.ui.controls.AutoSearchComboBox;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.documents.output.PrintSettingDlg;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.output.JsonInteractiveViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.interactive.OutputVisPanel;
import com.spss.java_client.ui.interactive.res.InteractiveResBundle;
import com.spss.java_client.ui.resources.ClientResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.output.client.table.OutputTable;
import com.spss.output.vis.charting.OutputVisCompStateListener;
import com.spss.output.vis.charting.OutputVisComponent;
import com.spss.output.vis.charting.ViewInteractivityListener;
import com.spss.shared.export.table_look.TableProperties;
import com.spss.uitools.clipboard.AppClipboard;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.BitSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public abstract class JsonInteractiveFrame
extends JFrame
implements OutputVisCompStateListener,
ActionListener,
ComponentListener,
WindowListener {
    protected OutputVisPanel mMainDisplayPanel;
    protected JsonInteractiveViewerItem mInteractiveViewerItem;
    protected VisCompMainInteracitivity mVisCompMainInteracitivity;
    protected JMenu fileMenu;
    protected JMenu editMenu;
    protected JMenu viewMenu;
    protected JMenu helpMenu;
    protected ResourceBundle mResBundle;
    protected ASLExecutor mASLExecutor;
    protected JButton mCopyToViewerButton;
    protected JButton mZoomInButton;
    protected JButton mZoomOutButton;
    protected JRadioButtonMenuItem mZoomLevel1;
    protected JRadioButtonMenuItem mZoomLevel2;
    protected JRadioButtonMenuItem mZoomLevel3;
    protected JRadioButtonMenuItem mZoomLevel4;
    protected JRadioButtonMenuItem mZoomLevel5;
    protected JRadioButtonMenuItem mZoomLevel6;
    protected JRadioButtonMenuItem mZoomLevel7;
    protected JRadioButtonMenuItem mZoomLevel8;
    protected JRadioButtonMenuItem mZoomLevel9;
    protected JRadioButtonMenuItem mZoomLevel10;
    protected JMenuItem mPanLeftMenuItem;
    protected JMenuItem mPanRightMenuItem;
    protected JMenuItem mPanUpMenuItem;
    protected JMenuItem mPanDownMenuItem;
    protected int mCurrentZoomLevel = 0;
    public static int MENU_OPTION_FILE = 0;
    public static int MENU_OPTION_EDIT = 1;
    public static int MENU_OPTION_VIEW = 2;
    public static int MENU_OPTION_HELP = 3;
    public static int ZOOM_LEVEL_MIN = 1;
    public static int ZOOM_LEVEL_MAX = 10;
    protected boolean mDoubleClickHandled = false;
    private boolean mFrameHasBeenClosed = false;

    public JsonInteractiveFrame(JsonInteractiveViewerItem jsonInteractiveViewerItem) {
        this.mInteractiveViewerItem = jsonInteractiveViewerItem;
        this.mResBundle = ResUtil.getBundle(InteractiveResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        ImageIcon imageIcon = new ImageIcon(ResUtil.getImageResource("modeleditor.png"));
        this.setIconImage(imageIcon.getImage());
        this.addWindowListener(this);
        this.addComponentListener(this);
    }

    protected void setTabTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        this.addControlsForFocusTraversal(vector);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    protected Vector<Object> addControlsForFocusTraversal(Vector<Object> vector) {
        if (this.mCopyToViewerButton != null) {
            vector.add(this.mCopyToViewerButton);
        }
        if (this.mZoomInButton != null) {
            vector.add(this.mZoomInButton);
        }
        if (this.mZoomOutButton != null) {
            vector.add(this.mZoomOutButton);
        }
        if (this.mMainDisplayPanel != null && this.mMainDisplayPanel.getVisControl() != null) {
            vector.add(this.mMainDisplayPanel.getVisControl());
        }
        return vector;
    }

    @Override
    public void dispose() {
        JsonInteractiveItem jsonInteractiveItem = this.getJsonInteractiveItem();
        OutputVisComponent outputVisComponent = jsonInteractiveItem.getMainVisComponent();
        if (outputVisComponent != null) {
            outputVisComponent.removeComponentStateListener((OutputVisCompStateListener)this);
            if (outputVisComponent.getViewInteractivity() != null) {
                outputVisComponent.getViewInteractivity().removeInteractivityListener((ViewInteractivityListener)this.mVisCompMainInteracitivity);
            }
        }
        if (this.mMainDisplayPanel != null) {
            this.mMainDisplayPanel.getVisComponent().removeComponentStateListener((OutputVisCompStateListener)this.mMainDisplayPanel);
        }
        super.dispose();
    }

    public JsonInteractiveItem getJsonInteractiveItem() {
        return this.mInteractiveViewerItem.getItem();
    }

    protected void constructGUI() {
    }

    protected JMenu createCopyToViewerMenu(boolean bl) {
        String string = ResUtil.getString("copy_to_viewer");
        String string2 = UIManager.getLookAndFeel().getName().contains("CobaltLookAndFeel") && bl ? string + "     " : string;
        JMenu jMenu = new JMenu(string2);
        jMenu.setMnemonic(ResUtil.getAccessKey("copy_to_viewer"));
        return jMenu;
    }

    protected void constructMessageGUI() {
        JsonInteractiveItem jsonInteractiveItem = this.mInteractiveViewerItem.getItem();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText("\n" + jsonInteractiveItem.getMessageToRender());
        jTextPane.setEditable(false);
        StyledDocument styledDocument = jTextPane.getStyledDocument();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 1);
        styledDocument.setParagraphAttributes(0, styledDocument.getLength(), simpleAttributeSet, false);
        this.add((Component)jTextPane, gridBagConstraints);
    }

    public int getViewCount() {
        List list = ((JsonInteractiveItem)this.mInteractiveViewerItem.getCoreItem()).getAllViews();
        return list != null ? list.size() : 0;
    }

    protected void constructMessageMenus() {
        this.constructMenus();
        this.fileMenu.setEnabled(false);
        this.editMenu.setEnabled(false);
        if (this.viewMenu != null) {
            this.viewMenu.setEnabled(false);
        }
    }

    protected void constructMenus(BitSet bitSet) {
        JMenuBar jMenuBar = new JMenuBar();
        if (bitSet.get(MENU_OPTION_FILE)) {
            this.fileMenu = new JMenu(ResUtil.getString("File"));
            this.fileMenu.setMnemonic(ResUtil.getAccessKey("File"));
            jMenuBar.add(this.fileMenu);
        }
        if (bitSet.get(MENU_OPTION_EDIT)) {
            this.editMenu = new JMenu(ResUtil.getString("Edit"));
            this.editMenu.setMnemonic(ResUtil.getAccessKey("Edit"));
            jMenuBar.add(this.editMenu);
        }
        if (bitSet.get(MENU_OPTION_VIEW)) {
            this.viewMenu = new JMenu(ResUtil.getString("View"));
            this.viewMenu.setMnemonic(ResUtil.getAccessKey("View"));
            jMenuBar.add(this.viewMenu);
        }
        if (bitSet.get(MENU_OPTION_HELP)) {
            this.helpMenu = new JMenu(ResUtil.getString("Help"));
            this.helpMenu.setMnemonic(ResUtil.getAccessKey("Help"));
            jMenuBar.add(this.helpMenu);
        }
        this.setJMenuBar(jMenuBar);
    }

    protected void constructMenus() {
        BitSet bitSet = new BitSet();
        bitSet.set(MENU_OPTION_FILE, MENU_OPTION_HELP + 1);
        this.constructMenus(bitSet);
    }

    protected JMenuItem addItemToMenu(JMenu jMenu, String string) {
        JMenuItem jMenuItem = new JMenuItem(ResUtil.getString(string));
        this.configureMenuItem(jMenuItem, jMenu, string);
        return jMenuItem;
    }

    protected JCheckBoxMenuItem addCheckBoxItemToMenu(JMenu jMenu, String string) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(ResUtil.getString(string));
        this.configureMenuItem(jCheckBoxMenuItem, jMenu, string);
        return jCheckBoxMenuItem;
    }

    protected JRadioButtonMenuItem addRBItemToMenu(JMenu jMenu, String string, ButtonGroup buttonGroup) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(ResUtil.getString(string));
        buttonGroup.add(jRadioButtonMenuItem);
        this.configureMenuItem(jRadioButtonMenuItem, jMenu, string);
        return jRadioButtonMenuItem;
    }

    private void configureMenuItem(JMenuItem jMenuItem, JMenu jMenu, String string) {
        jMenuItem.setMnemonic(ResUtil.getAccessKey(string));
        jMenuItem.setActionCommand(string);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
    }

    protected JMenu constructZoomMenu() {
        JMenu jMenu = new JMenu(ResUtil.getString("view_zoom"));
        jMenu.setMnemonic(ResUtil.getAccessKey("view_zoom"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.mZoomLevel1 = this.addRBItemToMenu(jMenu, "zoom_level_1", buttonGroup);
        this.mZoomLevel2 = this.addRBItemToMenu(jMenu, "zoom_level_2", buttonGroup);
        this.mZoomLevel3 = this.addRBItemToMenu(jMenu, "zoom_level_3", buttonGroup);
        this.mZoomLevel4 = this.addRBItemToMenu(jMenu, "zoom_level_4", buttonGroup);
        this.mZoomLevel5 = this.addRBItemToMenu(jMenu, "zoom_level_5", buttonGroup);
        this.mZoomLevel6 = this.addRBItemToMenu(jMenu, "zoom_level_6", buttonGroup);
        this.mZoomLevel7 = this.addRBItemToMenu(jMenu, "zoom_level_7", buttonGroup);
        this.mZoomLevel8 = this.addRBItemToMenu(jMenu, "zoom_level_8", buttonGroup);
        this.mZoomLevel9 = this.addRBItemToMenu(jMenu, "zoom_level_9", buttonGroup);
        this.mZoomLevel10 = this.addRBItemToMenu(jMenu, "zoom_level_10", buttonGroup);
        return jMenu;
    }

    protected JMenu constructPanMenu() {
        JMenu jMenu = new JMenu(ResUtil.getString("view_pan"));
        jMenu.setMnemonic(ResUtil.getAccessKey("view_pan"));
        this.mPanLeftMenuItem = this.addItemToMenu(jMenu, "pan_left");
        this.mPanRightMenuItem = this.addItemToMenu(jMenu, "pan_right");
        this.mPanUpMenuItem = this.addItemToMenu(jMenu, "pan_up");
        this.mPanDownMenuItem = this.addItemToMenu(jMenu, "pan_down");
        return jMenu;
    }

    protected JButton constructCopyToViewerButton() {
        this.mCopyToViewerButton = new JButton();
        URL uRL = ResUtil.getImageURL("edit_copy");
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            this.mCopyToViewerButton.setIcon(imageIcon);
            this.mCopyToViewerButton.setPreferredSize(new Dimension(24, 24));
            this.mCopyToViewerButton.setMinimumSize(new Dimension(24, 24));
            this.mCopyToViewerButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JsonInteractiveFrame.this.addCopyToViewerPopupMenuItems(jPopupMenu);
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            });
            this.mCopyToViewerButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JsonInteractiveFrame.this.addCopyToViewerPopupMenuItems(jPopupMenu);
                    jPopupMenu.show(JsonInteractiveFrame.this.mCopyToViewerButton, JsonInteractiveFrame.this.mCopyToViewerButton.getX(), JsonInteractiveFrame.this.mCopyToViewerButton.getY());
                }
            });
            ResourceBundle resourceBundle = ResUtil.getBundle(InteractiveResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
            this.mCopyToViewerButton.setToolTipText(resourceBundle.getString("IDS_INTERACTIVE_COPY_TO_VIEWER_TOOLTIP"));
        }
        return this.mCopyToViewerButton;
    }

    protected JButton constructToolbarButton(String string, String string2) {
        JButton jButton = new JButton();
        URL uRL = ResUtil.getImageURL(string);
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            jButton.setIcon(imageIcon);
            jButton.setPreferredSize(new Dimension(24, 24));
            jButton.setMinimumSize(new Dimension(24, 24));
            ResourceBundle resourceBundle = ResUtil.getBundle(ClientResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
            jButton.setToolTipText(resourceBundle.getString(string2));
        }
        return jButton;
    }

    protected void addCopyToViewerPopupMenuItems(JPopupMenu jPopupMenu) {
    }

    protected void setInteractiveTableComp(OutputTable outputTable, boolean bl, boolean bl2) {
        this.setInteractiveTableComp(outputTable, bl, bl2, true, false);
    }

    protected void setInteractiveTableComp(OutputTable outputTable, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        TableComponent tableComponent = outputTable.getTableComponent();
        tableComponent.setInteractJsonTable(bl);
        tableComponent.setMouseoverEnabled(bl2);
        tableComponent.setMouseLockSupported(bl3);
        tableComponent.setInteractiveTableAllowSort(bl4);
    }

    protected OutputTable createOutputTable(JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3) {
        return this.createOutputTable(jSONObject, jSONObject2, jSONObject3, null);
    }

    protected OutputTable createOutputTable(JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, TableProperties tableProperties) {
        String string = this.getJsonInteractiveItem().getLocale();
        try {
            if (jSONObject3 != null) {
                jSONObject3.put((Object)"locale", (Object)string);
            } else {
                jSONObject3 = JSONObject.parse((String)("{\"locale\":\"" + string + "\"}"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        OutputTable outputTable = new OutputTable(jSONObject, jSONObject2, jSONObject3, tableProperties);
        String string2 = "";
        String string3 = "";
        int n = string.indexOf(95);
        if (n >= 0) {
            string2 = string.substring(0, n);
            if (string.length() >= n + 1) {
                string3 = string.substring(n + 1);
            }
        } else {
            string2 = string;
        }
        outputTable.getPivotTable2d().setLocale(new Locale(string2, string3));
        TableComponent tableComponent = outputTable.getTableComponent();
        tableComponent.refreshTable();
        return outputTable;
    }

    protected AutoSearchComboBox createAutoSearchSeriesComboBox(List<String> list) {
        AutoSearchComboBox.StringSearchable stringSearchable = new AutoSearchComboBox.StringSearchable(list);
        return new AutoSearchComboBox(stringSearchable, this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_QUALITY_FIND_SERIES")){

            @Override
            protected String getNotFoundMessage() {
                return MessageFormat.format(JsonInteractiveFrame.this.mResBundle.getString("IDS_TCM_OVERALL_MODEL_QUALITY_NOTFOUND_SERIES_MSG"), this.getSelectedItem().toString());
            }
        };
    }

    public void doCopyChartToViewer() {
        this.copyJsonChartItemIntoViewer();
    }

    public void doCopyChartHistogramToViewer() {
        this.copyJsonChartItemIntoViewer();
    }

    public void doCopyChartDotplotToViewer() {
        this.copyJsonChartItemIntoViewer();
    }

    public void doCopyMapToViewer() {
    }

    public void doCopyTableToViewer() {
    }

    public void doCopyImageToViewer() {
        this.doCopyImageToViewer(this.getDescriptionForSelectedDisplay());
    }

    public void doCopyImageToViewer(String string) {
        BufferedImage bufferedImage = this.mInteractiveViewerItem.getItem().getImage();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "jpg", byteArrayOutputStream);
            ImageItem imageItem = new ImageItem();
            imageItem.setVDPData(ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            imageItem.setDescription(string);
            this.insertItemIntoViewer((OutputItem)imageItem);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void copyJsonChartItemIntoViewer() {
        JsonInteractiveItem jsonInteractiveItem = this.mInteractiveViewerItem.getItem();
        JsonChartItem jsonChartItem = this.constructJsonChartItem(jsonInteractiveItem);
        jsonChartItem.setVDPData(jsonInteractiveItem.getMainVDPData());
        this.insertItemIntoViewer((OutputItem)jsonChartItem);
    }

    protected JsonChartItem constructJsonChartItem(JsonInteractiveItem jsonInteractiveItem) {
        return this.constructJsonChartItem(jsonInteractiveItem, this.getDescriptionForSelectedDisplay());
    }

    protected JsonChartItem constructJsonChartItem(JsonInteractiveItem jsonInteractiveItem, String string) {
        JsonChartItem jsonChartItem = new JsonChartItem(jsonInteractiveItem.getLocale());
        jsonChartItem.setProcedureName(jsonInteractiveItem.getProcedureName());
        jsonChartItem.setCreatorVersion(jsonInteractiveItem.getCreatorVersion());
        jsonChartItem.setAlignment(jsonInteractiveItem.getAlignment());
        jsonChartItem.setTemplate(false);
        jsonChartItem.getGeoJsonIDs().addAll(jsonInteractiveItem.getGeoJsonIDs());
        jsonChartItem.setVisible(true);
        jsonChartItem.setDescription(string);
        return jsonChartItem;
    }

    protected HeaderItem findItemByDescription(String string) {
        ViewerDocument viewerDocument = ((ITopWindow)((Object)this.mInteractiveViewerItem.getTopLevelAncestor())).getViewerDocument();
        IOutputDocument iOutputDocument = viewerDocument.getCoreDocument();
        for (long i = 0L; i < iOutputDocument.getItemCount(); ++i) {
            try {
                HeaderItem headerItem = (HeaderItem)iOutputDocument.getItemAtIndex(i);
                if (!(headerItem instanceof HeaderItem) || !headerItem.getDescription().equals(string)) continue;
                return headerItem;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }

    protected HeaderItem getParentHeaderItem(String string, String string2) {
        HeaderItem headerItem = this.findItemByDescription(string);
        if (headerItem == null) {
            TitleItem titleItem = new TitleItem();
            titleItem.setDescription(ResUtil.getString("IDS_VIEWER_ITEM_TITLE"));
            titleItem.setContents(string);
            JsonInteractiveItem jsonInteractiveItem = this.mInteractiveViewerItem.getItem();
            headerItem = new HeaderItem();
            headerItem.setProcedureName(jsonInteractiveItem.getProcedureName());
            headerItem.setCreatorVersion(jsonInteractiveItem.getCreatorVersion());
            headerItem.setAlignment(jsonInteractiveItem.getAlignment());
            headerItem.setVisible(true);
            headerItem.setDescription(string);
            HeaderItem headerItem2 = (HeaderItem)jsonInteractiveItem.getParentItem().getParentItem();
            int n = -1;
            for (int i = 0; i < headerItem2.getChildCount(); ++i) {
                OutputItem outputItem = (OutputItem)headerItem2.getChildItem(i);
                if (!outputItem.getDescription().equals(string2)) continue;
                n = i + 1;
                break;
            }
            this.insertItemIntoViewerAt((OutputItem)headerItem, headerItem2, n);
            this.insertItemIntoViewerAt((OutputItem)titleItem, headerItem, n);
        }
        return headerItem;
    }

    protected void insertItemIntoViewerAsLastChild(OutputItem outputItem, HeaderItem headerItem) {
        this.insertItemIntoViewerAt(outputItem, headerItem, headerItem.getChildCount());
    }

    protected void insertItemIntoViewerAt(OutputItem outputItem, HeaderItem headerItem, int n) {
        ViewerDocument viewerDocument = ((ITopWindow)((Object)this.mInteractiveViewerItem.getTopLevelAncestor())).getViewerDocument();
        viewerDocument.getCoreDocument().insertItemAt((IOutputItem)outputItem, headerItem, n);
    }

    protected void insertItemIntoViewer(OutputItem outputItem) {
        this.insertItemIntoViewer(outputItem, (OutputItem)this.mInteractiveViewerItem.getItem());
    }

    protected void insertItemIntoViewer(OutputItem outputItem, OutputItem outputItem2) {
        ViewerDocument viewerDocument = ((ITopWindow)((Object)this.mInteractiveViewerItem.getTopLevelAncestor())).getViewerDocument();
        viewerDocument.getCoreDocument().insertItem((IOutputItem)outputItem, (IOutputItem)outputItem2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JsonInteractiveItem jsonInteractiveItem = this.mInteractiveViewerItem.getItem();
        OutputVisPanel outputVisPanel = this.getZoomAndPanOutputVisPanel();
        if ("print_settings".equals(actionEvent.getActionCommand())) {
            new PrintSettingDlg(this, true);
        } else if ("copy_chart_to_viewer".equals(actionEvent.getActionCommand())) {
            this.doCopyChartToViewer();
        } else if ("copy_map_to_viewer".equals(actionEvent.getActionCommand())) {
            this.doCopyMapToViewer();
        } else if ("copy_table_to_viewer".equals(actionEvent.getActionCommand())) {
            this.doCopyTableToViewer();
        } else if ("copy_image_to_viewer".equals(actionEvent.getActionCommand())) {
            this.doCopyImageToViewer();
        } else if ("file_close".equals(actionEvent.getActionCommand())) {
            this.setVisible(false);
            this.dispose();
        } else if ("zoom_level_1".equals(actionEvent.getActionCommand())) {
            this.mCurrentZoomLevel = 1;
            this.doZoomToLevel(jsonInteractiveItem, outputVisPanel, this.getZoomAndPanOnMainPanel(), this.mCurrentZoomLevel);
        } else if ("zoom_level_2".equals(actionEvent.getActionCommand())) {
            this.mCurrentZoomLevel = 2;
            this.doZoomToLevel(jsonInteractiveItem, outputVisPanel, this.getZoomAndPanOnMainPanel(), this.mCurrentZoomLevel);
        } else if ("zoom_level_3".equals(actionEvent.getActionCommand())) {
            this.mCurrentZoomLevel = 3;
            this.doZoomToLevel(jsonInteractiveItem, outputVisPanel, this.getZoomAndPanOnMainPanel(), this.mCurrentZoomLevel);
        } else if ("zoom_level_4".equals(actionEvent.getActionCommand())) {
            this.mCurrentZoomLevel = 4;
            this.doZoomToLevel(jsonInteractiveItem, outputVisPanel, this.getZoomAndPanOnMainPanel(), this.mCurrentZoomLevel);
        } else if ("zoom_level_5".equals(actionEvent.getActionCommand())) {
            this.mCurrentZoomLevel = 5;
            this.doZoomToLevel(jsonInteractiveItem, outputVisPanel, this.getZoomAndPanOnMainPanel(), this.mCurrentZoomLevel);
        } else if ("zoom_level_6".equals(actionEvent.getActionCommand())) {
            this.mCurrentZoomLevel = 6;
            this.doZoomToLevel(jsonInteractiveItem, outputVisPanel, this.getZoomAndPanOnMainPanel(), this.mCurrentZoomLevel);
        } else if ("zoom_level_7".equals(actionEvent.getActionCommand())) {
            this.mCurrentZoomLevel = 7;
            this.doZoomToLevel(jsonInteractiveItem, outputVisPanel, this.getZoomAndPanOnMainPanel(), this.mCurrentZoomLevel);
        } else if ("zoom_level_8".equals(actionEvent.getActionCommand())) {
            this.mCurrentZoomLevel = 8;
            this.doZoomToLevel(jsonInteractiveItem, outputVisPanel, this.getZoomAndPanOnMainPanel(), this.mCurrentZoomLevel);
        } else if ("zoom_level_9".equals(actionEvent.getActionCommand())) {
            this.mCurrentZoomLevel = 9;
            this.doZoomToLevel(jsonInteractiveItem, outputVisPanel, this.getZoomAndPanOnMainPanel(), this.mCurrentZoomLevel);
        } else if ("zoom_level_10".equals(actionEvent.getActionCommand())) {
            this.mCurrentZoomLevel = 10;
            this.doZoomToLevel(jsonInteractiveItem, outputVisPanel, this.getZoomAndPanOnMainPanel(), this.mCurrentZoomLevel);
        } else if ("pan_left".equals(actionEvent.getActionCommand())) {
            this.doPanLeft(jsonInteractiveItem, outputVisPanel, this.getZoomAndPanOnMainPanel());
        } else if ("pan_right".equals(actionEvent.getActionCommand())) {
            this.doPanRight(jsonInteractiveItem, outputVisPanel, this.getZoomAndPanOnMainPanel());
        } else if ("pan_up".equals(actionEvent.getActionCommand())) {
            this.doPanUp(jsonInteractiveItem, outputVisPanel, this.getZoomAndPanOnMainPanel());
        } else if ("pan_down".equals(actionEvent.getActionCommand())) {
            this.doPanDown(jsonInteractiveItem, outputVisPanel, false);
        } else if ("copy_chart_to_clipboard".equals(actionEvent.getActionCommand()) || "copy_map_to_clipboard".equals(actionEvent.getActionCommand()) || "copy_image_to_clipboard".equals(actionEvent.getActionCommand()) || "copy_chart_histogram_to_clipboard".equals(actionEvent.getActionCommand()) || "copy_chart_dotplot_to_clipboard".equals(actionEvent.getActionCommand()) || "copy_table_to_clipboard".equals(actionEvent.getActionCommand())) {
            AppClipboard appClipboard = AppClipboard.getAppClipboard();
            BufferedImage bufferedImage = "copy_image_to_clipboard".equals(actionEvent.getActionCommand()) ? this.mInteractiveViewerItem.getItem().getImage() : ("copy_chart_to_clipboard".equals(actionEvent.getActionCommand()) || "copy_chart_histogram_to_clipboard".equals(actionEvent.getActionCommand()) ? this.getChartImage() : ("copy_chart_dotplot_to_clipboard".equals(actionEvent.getActionCommand()) ? ((JsonSplitInteractiveItem)this.mInteractiveViewerItem.getItem()).getAuxImage() : ("copy_table_to_clipboard".equals(actionEvent.getActionCommand()) ? this.getTableImage() : this.getMapImage())));
            if (bufferedImage != null) {
                appClipboard.addClipboardData(AppClipboard.IMAGE_FLAVOR, (Object)bufferedImage, true);
            }
        } else if ("help_topics".equals(actionEvent.getActionCommand())) {
            StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.getHelpID());
        }
    }

    public BufferedImage getChartImage() {
        return this.mInteractiveViewerItem.getItem().getMainImage();
    }

    public BufferedImage getTableImage() {
        return ((JsonSplitInteractiveItem)this.mInteractiveViewerItem.getItem()).getAuxImage();
    }

    public BufferedImage getMapImage() {
        return this.mInteractiveViewerItem.getItem().getMainImage();
    }

    protected abstract Dimension getItemSize();

    protected String getDescriptionForSelectedDisplay() {
        return this.mInteractiveViewerItem.getItem().getDescription();
    }

    protected void addZoomAndPanListeners(final JsonInteractiveItem jsonInteractiveItem, VisControl visControl) {
        final OutputVisPanel outputVisPanel = this.getZoomAndPanOutputVisPanel();
        ThisMouseListener thisMouseListener = new ThisMouseListener(jsonInteractiveItem, outputVisPanel);
        visControl.addMouseListener((MouseListener)thisMouseListener);
        visControl.addMouseWheelListener((MouseWheelListener)thisMouseListener);
        visControl.addMouseMotionListener((MouseMotionListener)thisMouseListener);
        jsonInteractiveItem.setZoomSupported(true);
        visControl.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 37) {
                    JsonInteractiveFrame.this.doPanLeft(jsonInteractiveItem, outputVisPanel, JsonInteractiveFrame.this.getZoomAndPanOnMainPanel());
                } else if (n == 39) {
                    JsonInteractiveFrame.this.doPanRight(jsonInteractiveItem, outputVisPanel, JsonInteractiveFrame.this.getZoomAndPanOnMainPanel());
                } else if (n == 38) {
                    JsonInteractiveFrame.this.doPanUp(jsonInteractiveItem, outputVisPanel, JsonInteractiveFrame.this.getZoomAndPanOnMainPanel());
                } else if (n == 40) {
                    JsonInteractiveFrame.this.doPanDown(jsonInteractiveItem, outputVisPanel, JsonInteractiveFrame.this.getZoomAndPanOnMainPanel());
                } else if (n == 61 && keyEvent.isControlDown() && keyEvent.isShiftDown()) {
                    JsonInteractiveFrame.this.zoomIn(jsonInteractiveItem, outputVisPanel);
                } else if (n == 45 && keyEvent.isControlDown()) {
                    JsonInteractiveFrame.this.zoomOut(jsonInteractiveItem, outputVisPanel);
                }
            }
        });
    }

    protected VisControl getZoomAndPanVisControl() {
        return null;
    }

    protected OutputVisPanel getZoomAndPanOutputVisPanel() {
        return null;
    }

    protected boolean getZoomAndPanOnMainPanel() {
        return true;
    }

    protected void setZoomLevel(int n) {
        switch (n) {
            default: {
                this.mZoomLevel1.setSelected(true);
                break;
            }
            case 2: {
                this.mZoomLevel2.setSelected(true);
                break;
            }
            case 3: {
                this.mZoomLevel3.setSelected(true);
                break;
            }
            case 4: {
                this.mZoomLevel4.setSelected(true);
                break;
            }
            case 5: {
                this.mZoomLevel5.setSelected(true);
                break;
            }
            case 6: {
                this.mZoomLevel6.setSelected(true);
                break;
            }
            case 7: {
                this.mZoomLevel7.setSelected(true);
                break;
            }
            case 8: {
                this.mZoomLevel8.setSelected(true);
                break;
            }
            case 9: {
                this.mZoomLevel9.setSelected(true);
                break;
            }
            case 10: {
                this.mZoomLevel10.setSelected(true);
            }
        }
    }

    protected void enableZoomAndPanControls(VisControl visControl) {
        double[][] dArray = visControl.getInteractivity().getViewportZoom().getViewport();
        this.mZoomInButton.setEnabled(dArray[0][1] - dArray[0][0] > 0.101);
        this.mZoomOutButton.setEnabled(dArray[0][0] > 0.0 || dArray[1][0] > 0.0 || dArray[0][1] < 1.0 || dArray[1][1] < 1.0);
        this.mPanLeftMenuItem.setEnabled(dArray[1][0] > 0.0);
        this.mPanRightMenuItem.setEnabled(dArray[1][1] < 1.0);
        this.mPanUpMenuItem.setEnabled(dArray[0][1] < 1.0);
        this.mPanDownMenuItem.setEnabled(dArray[0][0] > 0.0);
    }

    protected void zoomOut(JsonInteractiveItem jsonInteractiveItem, OutputVisPanel outputVisPanel) {
        if (this.mCurrentZoomLevel > ZOOM_LEVEL_MIN) {
            this.setZoomLevel(--this.mCurrentZoomLevel);
            this.doZoomToLevel(jsonInteractiveItem, outputVisPanel, this.getZoomAndPanOnMainPanel(), this.mCurrentZoomLevel);
        }
    }

    protected void zoomIn(JsonInteractiveItem jsonInteractiveItem, OutputVisPanel outputVisPanel) {
        if (this.mCurrentZoomLevel < ZOOM_LEVEL_MAX) {
            this.setZoomLevel(++this.mCurrentZoomLevel);
            this.doZoomToLevel(jsonInteractiveItem, outputVisPanel, this.getZoomAndPanOnMainPanel(), this.mCurrentZoomLevel);
        }
    }

    protected void doZoomToLevel(JsonInteractiveItem jsonInteractiveItem, OutputVisPanel outputVisPanel, boolean bl, int n) {
        VisControl visControl = outputVisPanel.getVisControl();
        double[][] dArray = visControl.getInteractivity().getViewportZoom().getViewport();
        int n2 = n - 1;
        dArray[0][0] = 0.0 + (double)n2 * 0.05;
        dArray[0][1] = 1.0 - (double)n2 * 0.05;
        dArray[1][0] = 0.0 + (double)n2 * 0.05;
        dArray[1][1] = 1.0 - (double)n2 * 0.05;
        visControl.getInteractivity().getViewportZoom().setViewport(dArray);
        outputVisPanel.setViewport(dArray);
        jsonInteractiveItem.setZoomLevel(bl, n);
        jsonInteractiveItem.setViewport(bl, dArray);
        this.enableZoomAndPanControls(visControl);
    }

    protected void doPanLeft(JsonInteractiveItem jsonInteractiveItem, OutputVisPanel outputVisPanel, boolean bl) {
        VisControl visControl = outputVisPanel.getVisControl();
        double[][] dArray = visControl.getInteractivity().getViewportZoom().getViewport();
        if (dArray[1][0] > 0.0) {
            dArray[1][0] = Math.max(dArray[1][0] - 0.05, 0.0);
            dArray[1][1] = Math.min(dArray[1][1] - 0.05, 1.0);
            visControl.getInteractivity().getViewportZoom().setViewport(dArray);
            outputVisPanel.setViewport(dArray);
            jsonInteractiveItem.setViewport(bl, dArray);
        }
        this.enableZoomAndPanControls(visControl);
    }

    protected void doPanRight(JsonInteractiveItem jsonInteractiveItem, OutputVisPanel outputVisPanel, boolean bl) {
        VisControl visControl = outputVisPanel.getVisControl();
        double[][] dArray = visControl.getInteractivity().getViewportZoom().getViewport();
        if (dArray[1][1] < 1.0) {
            dArray[1][0] = Math.max(dArray[1][0] + 0.05, 0.0);
            dArray[1][1] = Math.min(dArray[1][1] + 0.05, 1.0);
            visControl.getInteractivity().getViewportZoom().setViewport(dArray);
            outputVisPanel.setViewport(dArray);
            jsonInteractiveItem.setViewport(bl, dArray);
        }
        this.enableZoomAndPanControls(visControl);
    }

    private boolean setRangeLeftRight(double[][] dArray, double d, boolean bl) {
        boolean bl2 = false;
        if (bl && dArray[1][1] < 1.0) {
            dArray[1][0] = Math.max(dArray[1][0] + d, 0.0);
            dArray[1][1] = Math.min(dArray[1][1] + d, 1.0);
            bl2 = true;
        }
        if (!bl && dArray[1][0] > 0.0) {
            dArray[1][0] = Math.max(dArray[1][0] - d, 0.0);
            dArray[1][1] = Math.min(dArray[1][1] - d, 1.0);
            bl2 = true;
        }
        return bl2;
    }

    private boolean setRangeUpDown(double[][] dArray, double d, boolean bl) {
        boolean bl2 = false;
        if (bl && dArray[0][1] < 1.0) {
            dArray[0][0] = Math.max(dArray[0][0] + d, 0.0);
            dArray[0][1] = Math.min(dArray[0][1] + d, 1.0);
            bl2 = true;
        }
        if (!bl && dArray[0][0] > 0.0) {
            dArray[0][0] = Math.max(dArray[0][0] - d, 0.0);
            dArray[0][1] = Math.min(dArray[0][1] - d, 1.0);
            bl2 = true;
        }
        return bl2;
    }

    protected void doPanUp(JsonInteractiveItem jsonInteractiveItem, OutputVisPanel outputVisPanel, boolean bl) {
        VisControl visControl = outputVisPanel.getVisControl();
        double[][] dArray = visControl.getInteractivity().getViewportZoom().getViewport();
        if (dArray[0][1] < 1.0) {
            dArray[0][0] = Math.max(dArray[0][0] + 0.05, 0.0);
            dArray[0][1] = Math.min(dArray[0][1] + 0.05, 1.0);
            visControl.getInteractivity().getViewportZoom().setViewport(dArray);
            outputVisPanel.setViewport(dArray);
            jsonInteractiveItem.setViewport(bl, dArray);
        }
        this.enableZoomAndPanControls(visControl);
    }

    protected void doPanDown(JsonInteractiveItem jsonInteractiveItem, OutputVisPanel outputVisPanel, boolean bl) {
        VisControl visControl = outputVisPanel.getVisControl();
        double[][] dArray = visControl.getInteractivity().getViewportZoom().getViewport();
        if (dArray[0][0] > 0.0) {
            dArray[0][0] = Math.max(dArray[0][0] - 0.05, 0.0);
            dArray[0][1] = Math.min(dArray[0][1] - 0.05, 1.0);
            visControl.getInteractivity().getViewportZoom().setViewport(dArray);
            outputVisPanel.setViewport(dArray);
            jsonInteractiveItem.setViewport(bl, dArray);
        }
        this.enableZoomAndPanControls(visControl);
    }

    protected void refreshCompositeDisplay() {
    }

    public ASLExecutor getASLExecutor() {
        return this.mASLExecutor;
    }

    public void setASLExecutor(ASLExecutor aSLExecutor) {
        this.mASLExecutor = aSLExecutor;
    }

    protected BufferedImage getImageToCopy(boolean bl) {
        return this.mInteractiveViewerItem.getItem().getImage();
    }

    protected String getHelpID() {
        return "idh_interactive_output";
    }

    public void viewChartTemplateUpdate() {
    }

    public void viewUpdate() {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this.mInteractiveViewerItem.isInEditMode()) {
            this.mInteractiveViewerItem.endEdit();
            this.repaint();
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.mFrameHasBeenClosed = true;
        if (this.mInteractiveViewerItem.isInEditMode()) {
            this.mInteractiveViewerItem.endEdit();
            this.repaint();
        }
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void doPostDisplayProccessing() {
    }

    public boolean hasFrameBeenClosed() {
        return this.mFrameHasBeenClosed;
    }

    public void processVisCompMainMouseClick(boolean bl) {
    }

    public void processVisCompMainMouseClick(JSONObject jSONObject, boolean bl) {
    }

    public void processVisCompMainMouseDoubleClick(JSONObject jSONObject, boolean bl) {
    }

    public void processVisCompMainMouseMoved(JSONObject jSONObject, boolean bl) {
    }

    class VisCompMainInteracitivity
    implements ViewInteractivityListener {
        private JsonInteractiveFrame mWhoToProcessEvents;

        public VisCompMainInteracitivity(JsonInteractiveFrame jsonInteractiveFrame2) {
            this.mWhoToProcessEvents = jsonInteractiveFrame2;
            JsonInteractiveFrame.this.mInteractiveViewerItem.getItem().getMainVisComponent().getViewInteractivity().addInteractivityListener((ViewInteractivityListener)this);
        }

        public Boolean accept(ViewInteractivityListener.InteractivityEvent interactivityEvent) {
            return true;
        }

        public void update(ViewInteractivityListener.InteractivityEvent interactivityEvent, JSONObject jSONObject) {
            if (this.mWhoToProcessEvents.hasFrameBeenClosed()) {
                return;
            }
            if ((interactivityEvent == ViewInteractivityListener.InteractivityEvent.MouseClicked || interactivityEvent == ViewInteractivityListener.InteractivityEvent.MouseControlClicked) && jSONObject != null && BasicFactory.isObject((Object)jSONObject)) {
                this.mWhoToProcessEvents.processVisCompMainMouseClick(jSONObject, interactivityEvent == ViewInteractivityListener.InteractivityEvent.MouseControlClicked);
            } else if (interactivityEvent == ViewInteractivityListener.InteractivityEvent.MouseMoved && jSONObject != null && BasicFactory.isObject((Object)jSONObject)) {
                this.mWhoToProcessEvents.processVisCompMainMouseMoved(jSONObject, false);
            } else if ((interactivityEvent == ViewInteractivityListener.InteractivityEvent.MouseClicked || interactivityEvent == ViewInteractivityListener.InteractivityEvent.MouseControlClicked) && jSONObject == null) {
                this.mWhoToProcessEvents.processVisCompMainMouseClick(interactivityEvent == ViewInteractivityListener.InteractivityEvent.MouseControlClicked);
            } else if (interactivityEvent == ViewInteractivityListener.InteractivityEvent.MouseDoubleClicked || interactivityEvent == ViewInteractivityListener.InteractivityEvent.MouseControlClicked) {
                this.mWhoToProcessEvents.processVisCompMainMouseDoubleClick(jSONObject, interactivityEvent == ViewInteractivityListener.InteractivityEvent.MouseControlClicked);
            }
        }
    }

    class ThisMouseListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private JsonInteractiveItem targetItem;
        private OutputVisPanel visPanel;
        private Point dragStart;
        private Point dragEnd;

        ThisMouseListener(JsonInteractiveItem jsonInteractiveItem, OutputVisPanel outputVisPanel) {
            this.targetItem = jsonInteractiveItem;
            this.visPanel = outputVisPanel;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                if (mouseEvent.getButton() == 1) {
                    if (!JsonInteractiveFrame.this.mDoubleClickHandled) {
                        JsonInteractiveFrame.this.zoomIn(this.targetItem, this.visPanel);
                    }
                    JsonInteractiveFrame.this.mDoubleClickHandled = false;
                } else if (mouseEvent.getButton() == 3) {
                    JsonInteractiveFrame.this.zoomOut(this.targetItem, this.visPanel);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.dragStart = mouseEvent.getPoint();
            this.dragEnd = null;
            JsonInteractiveFrame.this.setCursor(Cursor.getPredefinedCursor(13));
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            JsonInteractiveFrame.this.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            VisControl visControl = (VisControl)mouseEvent.getSource();
            JFrame jFrame = (JFrame)visControl.getTopLevelAncestor();
            if (!jFrame.isActive()) {
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            VisControl visControl = (VisControl)mouseEvent.getSource();
            JFrame jFrame = (JFrame)visControl.getTopLevelAncestor();
            if (!jFrame.isActive()) {
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            VisControl visControl = (VisControl)mouseEvent.getSource();
            JFrame jFrame = (JFrame)visControl.getTopLevelAncestor();
            if (!jFrame.isActive()) {
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.doPan(mouseEvent);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (mouseWheelEvent.getWheelRotation() < 0) {
                JsonInteractiveFrame.this.zoomIn(this.targetItem, this.visPanel);
            } else {
                JsonInteractiveFrame.this.zoomOut(this.targetItem, this.visPanel);
            }
        }

        private void doPan(MouseEvent mouseEvent) {
            VisControl visControl = this.visPanel.getVisControl();
            double[][] dArray = visControl.getInteractivity().getViewportZoom().getViewport();
            boolean bl = JsonInteractiveFrame.this.getZoomAndPanOnMainPanel();
            this.dragEnd = mouseEvent.getPoint();
            double d = this.dragEnd.getX() - this.dragStart.getX();
            double d2 = this.dragEnd.getY() - this.dragStart.getY();
            boolean bl2 = false;
            double d3 = Math.abs(d / 100.0);
            double d4 = Math.abs(d2 / 100.0);
            if (d < 0.0) {
                bl2 = JsonInteractiveFrame.this.setRangeLeftRight(dArray, d3, true);
            } else if (d > 0.0) {
                bl2 = JsonInteractiveFrame.this.setRangeLeftRight(dArray, d3, false);
            }
            if (d2 > 0.0) {
                bl2 = JsonInteractiveFrame.this.setRangeUpDown(dArray, d4, true);
            } else if (d2 < 0.0) {
                bl2 = JsonInteractiveFrame.this.setRangeUpDown(dArray, d4, false);
            }
            if (bl2) {
                visControl.getInteractivity().getViewportZoom().setViewport(dArray);
                this.visPanel.setViewport(dArray);
                this.targetItem.setViewport(bl, dArray);
            }
            JsonInteractiveFrame.this.enableZoomAndPanControls(visControl);
            this.dragStart = this.dragEnd;
            this.dragEnd = null;
        }
    }
}

