/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.statistics.lighttable.LightPivotTable;
import com.ibm.statistics.lighttable.base.TableLayer;
import com.ibm.statistics.lighttable.data.CellData;
import com.ibm.statistics.lighttable.data.ExCellData;
import com.ibm.statistics.lighttable.tablecomponent.TableComponent;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.spss.java_client.core.documents.output.OneServerOutputUtils;
import com.spss.java_client.core.documents.output.OutputItem;
import com.spss.java_client.core.documents.output.interactive.DecisionRulesTableInteractiveItem;
import com.spss.java_client.core.documents.output.lighttable.JsonTableItem;
import com.spss.java_client.ui.doc_types.output.JsonInteractiveViewerItem;
import com.spss.java_client.ui.interactive.InteractiveTableEditor;
import com.spss.java_client.ui.interactive.JsonInteractiveFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.output.client.table.OutputTable;
import com.spss.output.client.table.OutputTableCallback;
import com.spss.shared.export.table_look.TableProperties;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.text.NumberFormatter;

public class DecisionRulesTableInteractiveFrame
extends JsonInteractiveFrame
implements ItemListener,
InteractiveTableEditor,
OutputTableCallback {
    private OutputTable mDecisionRulesTable;
    private JComboBox mTableContentsComboBox;
    private JComboBox mTargetCategoryComboBox;
    private JLabel targetCategoryComboBoxLabel;
    private JLabel mFindRuleLabel;
    private JTextField mFindRuleTextField;
    private JLabel mPageLabel1;
    private JLabel mPageLabel2;
    private JFormattedTextField mPageTextField;
    private JButton mFirstPageButton;
    private JButton mPreviousPageButton;
    private JButton mNextPageButton;
    private JButton mLastPageButton;
    private ArrayList<ArrayList<ExCellData>> mRowHeaderExCellDataArrayList = null;

    public DecisionRulesTableInteractiveFrame(JsonInteractiveViewerItem jsonInteractiveViewerItem) {
        super(jsonInteractiveViewerItem);
        this.setTitle(this.mResBundle.getString("IDS_INTERACTIVE_OUTPUT_TITLE") + this.mResBundle.getString("IDS_INTERACTIVE_OUTPUT_TITLE_SEP") + this.mResBundle.getString("IDS_TREES_TOP_DECISION_RULES"));
        this.constructGUI();
        this.constructMenus();
        this.setPreferredSize(new Dimension(700, 900));
        this.setTabTraversalPolicy();
        this.addWindowListener(this);
    }

    public int getHighlightedRow() {
        DecisionRulesTableInteractiveItem decisionRulesTableInteractiveItem = (DecisionRulesTableInteractiveItem)this.mInteractiveViewerItem.getItem();
        return decisionRulesTableInteractiveItem.getHighlightedRow();
    }

    @Override
    public void doPostDisplayProccessing() {
        DecisionRulesTableInteractiveItem decisionRulesTableInteractiveItem = (DecisionRulesTableInteractiveItem)this.mInteractiveViewerItem.getItem();
        JsonTableItem jsonTableItem = decisionRulesTableInteractiveItem.getTableItem();
        int n = jsonTableItem.getHighlightedRow();
        if (n > -1) {
            this.mDecisionRulesTable.getTableComponent().highlightingRow(n);
            this.mDecisionRulesTable.getTableComponent().refreshTable();
        }
    }

    @Override
    protected void constructGUI() {
        Object object;
        DecisionRulesTableInteractiveItem decisionRulesTableInteractiveItem = (DecisionRulesTableInteractiveItem)this.mInteractiveViewerItem.getItem();
        this.createTable();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.constructCopyToViewerButton(), gridBagConstraints);
        JLabel jLabel = new JLabel(this.mResBundle.getString("IDS_TREES_TABLE_CONTENTS"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 16, 4, 0);
        this.add((Component)jLabel, gridBagConstraints);
        Vector<String> vector = new Vector<String>();
        String string = this.mResBundle.getString("IDS_TREES_TOP_RULES");
        String string2 = this.mResBundle.getString("IDS_TREES_TOP_RULES_BY_CATEGORY");
        String string3 = this.mResBundle.getString("IDS_TREES_ALL_RULES");
        vector.add(string);
        if (this.isTargetCategorical()) {
            vector.add(string2);
        }
        vector.add(string3);
        this.mTableContentsComboBox = new JComboBox(vector);
        this.mTableContentsComboBox.setPreferredSize(new Dimension(160, 24));
        this.mTableContentsComboBox.setMinimumSize(new Dimension(160, 24));
        int n = 0;
        n = decisionRulesTableInteractiveItem.getTableContentMode() == DecisionRulesTableInteractiveItem.TableContentMode.TOP_RULES ? 0 : (decisionRulesTableInteractiveItem.getTableContentMode() == DecisionRulesTableInteractiveItem.TableContentMode.TOP_RULES_BY_CAT || !this.isTargetCategorical() ? 1 : 2);
        this.mTableContentsComboBox.setSelectedIndex(n);
        this.mTableContentsComboBox.addItemListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.add((Component)this.mTableContentsComboBox, gridBagConstraints);
        this.targetCategoryComboBoxLabel = new JLabel(this.mResBundle.getString("IDS_TREES_TARGET_CATEGORY"));
        this.targetCategoryComboBoxLabel.setVisible(this.isTopRulesByCategorySelected());
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 0);
        this.add((Component)this.targetCategoryComboBoxLabel, gridBagConstraints);
        this.mTargetCategoryComboBox = new JComboBox(this.getTargetCategories());
        this.mTargetCategoryComboBox.setPreferredSize(new Dimension(160, 24));
        this.mTargetCategoryComboBox.setMinimumSize(new Dimension(160, 24));
        if (this.isTargetCategorical()) {
            object = decisionRulesTableInteractiveItem.getSelectedCategory();
            if (object == null || ((String)object).length() == 0) {
                this.mTargetCategoryComboBox.setSelectedIndex(0);
            } else {
                this.mTargetCategoryComboBox.setSelectedItem(object);
            }
            this.mTargetCategoryComboBox.addItemListener(this);
        }
        this.mTargetCategoryComboBox.setVisible(this.isTopRulesByCategorySelected());
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.add((Component)this.mTargetCategoryComboBox, gridBagConstraints);
        object = this.createPagePanel();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        gridBagConstraints.anchor = 13;
        this.add((Component)object, gridBagConstraints);
        this.addDecisionRulesTable();
    }

    private void createTable() {
        DecisionRulesTableInteractiveItem decisionRulesTableInteractiveItem = (DecisionRulesTableInteractiveItem)this.mInteractiveViewerItem.getItem();
        TableProperties tableProperties = OneServerOutputUtils.getTableProperties((String)decisionRulesTableInteractiveItem.getTableItem().getTableLookPath());
        Hashtable hashtable = tableProperties.getGeneralProperties();
        hashtable.put("hideEmptyRows", false);
        this.mDecisionRulesTable = this.createOutputTable(decisionRulesTableInteractiveItem.getTableJson(), decisionRulesTableInteractiveItem.getDataModelJson(), decisionRulesTableInteractiveItem.getTableFilterJson(), tableProperties);
        this.mDecisionRulesTable.setCallback((OutputTableCallback)this);
        this.mDecisionRulesTable.applyTableAction(decisionRulesTableInteractiveItem.getTableActionJson());
        boolean bl = decisionRulesTableInteractiveItem.getAllowSorting() && decisionRulesTableInteractiveItem.getTableContentMode() == DecisionRulesTableInteractiveItem.TableContentMode.ALL_RULES;
        this.setInteractiveTableComp(this.mDecisionRulesTable, true, false, true, bl);
        TableLayer tableLayer = this.mDecisionRulesTable.getTableComponent().getLighttable().getCurrentLayer();
        decisionRulesTableInteractiveItem.setNumberOfRows(tableLayer.getRowHeaderRowCount());
    }

    private void addDecisionRulesTable() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        this.add((Component)this.mDecisionRulesTable.getTableComponent(), gridBagConstraints);
    }

    private JPanel createPagePanel() {
        final DecisionRulesTableInteractiveItem decisionRulesTableInteractiveItem = (DecisionRulesTableInteractiveItem)this.mInteractiveViewerItem.getItem();
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        if (decisionRulesTableInteractiveItem.getAllowSearching()) {
            this.mFindRuleLabel = new JLabel(this.mResBundle.getString("IDS_TREES_FIND_RULE_BY_ID"));
            this.mFindRuleLabel.setVisible(this.isAllRulesSelected());
            jPanel.add((Component)this.mFindRuleLabel, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.mFindRuleTextField = new JTextField();
            this.mFindRuleTextField.setPreferredSize(new Dimension(80, 24));
            this.mFindRuleTextField.setMinimumSize(new Dimension(80, 24));
            this.mFindRuleTextField.setVisible(this.isAllRulesSelected());
            this.mFindRuleTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n == 10) {
                        DecisionRulesTableInteractiveFrame.this.findRule();
                    }
                }
            });
            jPanel.add((Component)this.mFindRuleTextField, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        int n = this.getNumberOfPages();
        this.mPageLabel1 = new JLabel(this.mResBundle.getString("IDS_TREES_PAGE"));
        this.mPageLabel1.setVisible(this.isAllRulesSelected());
        gridBagConstraints.insets = new Insets(4, 12, 4, 0);
        jPanel.add((Component)this.mPageLabel1, gridBagConstraints);
        NumberFormat numberFormat = NumberFormat.getInstance();
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
        numberFormatter.setValueClass(Integer.class);
        numberFormatter.setMinimum(Integer.valueOf(1));
        numberFormatter.setMaximum(Integer.valueOf(this.getNumberOfPages()));
        numberFormatter.setCommitsOnValidEdit(false);
        this.mPageTextField = new JFormattedTextField(numberFormatter);
        this.mPageTextField.setPreferredSize(new Dimension(24, 24));
        this.mPageTextField.setMinimumSize(new Dimension(24, 24));
        this.mPageTextField.setText(decisionRulesTableInteractiveItem.getCurrentPage());
        this.mPageTextField.setVisible(this.isAllRulesSelected());
        this.mPageTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 10) {
                    DecisionRulesTableInteractiveFrame.this.validatePage();
                }
            }
        });
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        jPanel.add((Component)this.mPageTextField, gridBagConstraints);
        this.mPageLabel2 = new JLabel(this.mResBundle.getString("IDS_TREES_PAGE_OF") + n);
        this.mPageLabel2.setVisible(this.isAllRulesSelected());
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 10);
        jPanel.add((Component)this.mPageLabel2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.mFirstPageButton = this.constructToolbarButton("output_first_page", "output_first_page_TOOLTIP");
        this.mFirstPageButton.setVisible(this.isAllRulesSelected());
        this.mFirstPageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DecisionRulesTableInteractiveFrame.this.mPageTextField.setText("1");
                DecisionRulesTableInteractiveFrame.this.validatePage();
                DecisionRulesTableInteractiveFrame.this.enablePageButtons();
            }
        });
        jPanel.add((Component)this.mFirstPageButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.mPreviousPageButton = this.constructToolbarButton("output_previous_page", "output_previous_page_TOOLTIP");
        this.mPreviousPageButton.setVisible(this.isAllRulesSelected());
        this.mPreviousPageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Math.max(1, new Integer(decisionRulesTableInteractiveItem.getCurrentPage()) - 1);
                DecisionRulesTableInteractiveFrame.this.mPageTextField.setText(new Integer(n).toString());
                DecisionRulesTableInteractiveFrame.this.validatePage();
                DecisionRulesTableInteractiveFrame.this.enablePageButtons();
            }
        });
        jPanel.add((Component)this.mPreviousPageButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.mNextPageButton = this.constructToolbarButton("output_next_page", "output_next_page_TOOLTIP");
        this.mNextPageButton.setVisible(this.isAllRulesSelected());
        this.mNextPageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Math.min(new Integer(DecisionRulesTableInteractiveFrame.this.getNumberOfPages()), new Integer(decisionRulesTableInteractiveItem.getCurrentPage()) + 1);
                DecisionRulesTableInteractiveFrame.this.mPageTextField.setText(new Integer(n).toString());
                DecisionRulesTableInteractiveFrame.this.validatePage();
                DecisionRulesTableInteractiveFrame.this.enablePageButtons();
            }
        });
        jPanel.add((Component)this.mNextPageButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.mLastPageButton = this.constructToolbarButton("output_last_page", "output_last_page_TOOLTIP");
        this.mLastPageButton.setVisible(this.isAllRulesSelected());
        this.mLastPageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = DecisionRulesTableInteractiveFrame.this.getNumberOfPages();
                DecisionRulesTableInteractiveFrame.this.mPageTextField.setText(new Integer(n).toString());
                DecisionRulesTableInteractiveFrame.this.validatePage();
                DecisionRulesTableInteractiveFrame.this.enablePageButtons();
            }
        });
        jPanel.add((Component)this.mLastPageButton, gridBagConstraints);
        this.enablePageButtons();
        return jPanel;
    }

    private void findRule() {
        DecisionRulesTableInteractiveItem decisionRulesTableInteractiveItem = (DecisionRulesTableInteractiveItem)this.mInteractiveViewerItem.getItem();
        String string = this.mFindRuleTextField.getText();
        TableLayer tableLayer = this.mDecisionRulesTable.getTableComponent().getLighttable().getCurrentLayer();
        int n = tableLayer.getRowHeaderRowCount();
        int n2 = this.doFindRowForRuleId(string);
        decisionRulesTableInteractiveItem.setHighlightedRow(n2);
        if (n2 >= 0 && n2 < n) {
            String string2 = decisionRulesTableInteractiveItem.getCurrentPage();
            int n3 = this.getPageNumber(n2);
            if (Integer.valueOf(string2) != n3) {
                this.mPageTextField.setText(new Integer(n3).toString());
                this.validatePage();
            }
            TableComponent tableComponent = this.mDecisionRulesTable.getTableComponent();
            tableComponent.highlightingRow(n2);
            tableComponent.refreshTable();
            tableComponent.scrollDataRowToVisible(n2);
        } else {
            String string3 = this.mResBundle.getString("IDS_FIND_RULE_TITLE");
            String string4 = this.mResBundle.getString("IDS_RULE_ID_NOT_FOUND");
            JOptionPane.showMessageDialog(this, string4, string3, 2);
        }
    }

    private boolean validatePage() {
        DecisionRulesTableInteractiveItem decisionRulesTableInteractiveItem = (DecisionRulesTableInteractiveItem)this.mInteractiveViewerItem.getItem();
        boolean bl = false;
        try {
            Integer n = new Integer(this.mPageTextField.getText());
            if (n >= 1 && n <= this.getNumberOfPages()) {
                decisionRulesTableInteractiveItem.setCurrentPage(n.toString());
                this.refreshTable();
                bl = true;
            } else {
                String string = this.mResBundle.getString("IDS_INVALID_PAGE_TITLE");
                String string2 = this.mResBundle.getString("IDS_INVALID_PAGE_NUMBER");
                JOptionPane.showMessageDialog(this, string2, string, 2);
            }
            this.enablePageButtons();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return bl;
    }

    private void enablePageButtons() {
        DecisionRulesTableInteractiveItem decisionRulesTableInteractiveItem = (DecisionRulesTableInteractiveItem)this.mInteractiveViewerItem.getItem();
        int n = new Integer(decisionRulesTableInteractiveItem.getCurrentPage());
        int n2 = this.getNumberOfPages();
        this.mFirstPageButton.setEnabled(n > 1);
        this.mPreviousPageButton.setEnabled(n > 1);
        this.mNextPageButton.setEnabled(n < n2);
        this.mLastPageButton.setEnabled(n < n2);
    }

    @Override
    protected Vector<Object> addControlsForFocusTraversal(Vector<Object> vector) {
        DecisionRulesTableInteractiveItem decisionRulesTableInteractiveItem = (DecisionRulesTableInteractiveItem)this.mInteractiveViewerItem.getItem();
        vector.add(this.mCopyToViewerButton);
        vector.add(this.mTableContentsComboBox);
        vector.add(this.mTargetCategoryComboBox);
        if (decisionRulesTableInteractiveItem.getAllowSearching()) {
            vector.add(this.mFindRuleTextField);
        }
        vector.add(this.mPageTextField);
        vector.add(this.mFirstPageButton);
        vector.add(this.mPreviousPageButton);
        vector.add(this.mNextPageButton);
        vector.add(this.mLastPageButton);
        vector.add(this.mDecisionRulesTable.getTableComponent());
        return vector;
    }

    @Override
    protected void constructMenus() {
        BitSet bitSet = new BitSet();
        bitSet.set(MENU_OPTION_FILE);
        bitSet.set(MENU_OPTION_EDIT);
        bitSet.set(MENU_OPTION_HELP);
        super.constructMenus(bitSet);
        JMenu jMenu = this.createCopyToViewerMenu(false);
        this.addItemToMenu(jMenu, "copy_table_to_viewer");
        this.addItemToMenu(jMenu, "copy_image_to_viewer");
        this.fileMenu.add(jMenu);
        this.fileMenu.addSeparator();
        this.addItemToMenu(this.fileMenu, "print_settings");
        this.fileMenu.addSeparator();
        this.addItemToMenu(this.fileMenu, "file_close");
        JMenu jMenu2 = new JMenu(ResUtil.getString("copy_object"));
        jMenu2.setMnemonic(ResUtil.getAccessKey("copy_object"));
        this.addItemToMenu(jMenu2, "copy_table_to_clipboard");
        this.addItemToMenu(jMenu2, "copy_image_to_clipboard");
        this.editMenu.add(jMenu2);
        this.addItemToMenu(this.helpMenu, "help_topics");
    }

    @Override
    protected void addCopyToViewerPopupMenuItems(JPopupMenu jPopupMenu) {
        JMenu jMenu = this.createCopyToViewerMenu(true);
        this.addItemToMenu(jMenu, "copy_table_to_viewer");
        this.addItemToMenu(jMenu, "copy_image_to_viewer");
        jPopupMenu.add(jMenu);
    }

    @Override
    protected Dimension getItemSize() {
        Dimension dimension = new Dimension(this.mDecisionRulesTable.getTableComponent().getWidth(), this.mDecisionRulesTable.getTableComponent().getHeight());
        return dimension;
    }

    @Override
    public void doCopyTableToViewer() {
        DecisionRulesTableInteractiveItem decisionRulesTableInteractiveItem = (DecisionRulesTableInteractiveItem)this.mInteractiveViewerItem.getItem();
        JsonTableItem jsonTableItem = new JsonTableItem(decisionRulesTableInteractiveItem.getTableItem());
        jsonTableItem.setDescription(decisionRulesTableInteractiveItem.getDescription());
        this.insertItemIntoViewer((OutputItem)jsonTableItem);
    }

    @Override
    public BufferedImage getTableImage() {
        DecisionRulesTableInteractiveItem decisionRulesTableInteractiveItem = (DecisionRulesTableInteractiveItem)this.mInteractiveViewerItem.getItem();
        return decisionRulesTableInteractiveItem.getMainImage();
    }

    private boolean isTargetCategorical() {
        DecisionRulesTableInteractiveItem decisionRulesTableInteractiveItem = (DecisionRulesTableInteractiveItem)this.mInteractiveViewerItem.getItem();
        return decisionRulesTableInteractiveItem.isTargetCategorical();
    }

    private Vector getTargetCategories() {
        DecisionRulesTableInteractiveItem decisionRulesTableInteractiveItem;
        String string;
        Vector vector = new Vector();
        if (this.isTargetCategorical() && (string = (decisionRulesTableInteractiveItem = (DecisionRulesTableInteractiveItem)this.mInteractiveViewerItem.getItem()).getTargetName()) != null) {
            JSONObject jSONObject = decisionRulesTableInteractiveItem.getDataModelJson();
            JSONArray jSONArray = (JSONArray)BasicFactory.getItem((Object)jSONObject, (String)"fields");
            for (int i = 0; i < jSONArray.size(); ++i) {
                String string2;
                JSONObject jSONObject2 = (JSONObject)BasicFactory.getArrayItem((JSONArray)jSONArray, (int)i);
                String string3 = (String)BasicFactory.getItem((Object)jSONObject2, (String)"id");
                if (!string3.equals(string)) continue;
                Vector<String> vector2 = new Vector<String>();
                Vector<String> vector3 = new Vector<String>();
                JSONObject jSONObject3 = (JSONObject)BasicFactory.getItem((Object)jSONObject2, (String)"valueLabels");
                JSONArray jSONArray2 = (JSONArray)BasicFactory.getItem((Object)jSONObject3, (String)"values");
                for (int j = 0; j < jSONArray2.size(); ++j) {
                    Object object = BasicFactory.getArrayItem((JSONArray)jSONArray2, (int)j);
                    string2 = object.toString();
                    if (string2 == null || string2.isEmpty()) continue;
                    vector2.add(string2);
                }
                JSONArray jSONArray3 = (JSONArray)BasicFactory.getItem((Object)jSONObject3, (String)"labels");
                for (int j = 0; j < jSONArray3.size(); ++j) {
                    string2 = (String)BasicFactory.getArrayItem((JSONArray)jSONArray3, (int)j);
                    if (string2 == null || string2.isEmpty()) continue;
                    vector3.add(string2);
                }
                if (!vector3.isEmpty() && vector3.size() == vector2.size()) {
                    vector.addAll(vector3);
                    break;
                }
                vector.addAll(vector2);
                break;
            }
        }
        return vector;
    }

    private int getNumberOfPages() {
        TableLayer tableLayer = this.mDecisionRulesTable.getTableComponent().getLighttable().getCurrentLayer();
        int n = tableLayer.getRowHeaderRowCount() / DecisionRulesTableInteractiveItem.NUM_ROWS_PER_PAGE;
        if (tableLayer.getRowHeaderRowCount() % DecisionRulesTableInteractiveItem.NUM_ROWS_PER_PAGE > 0) {
            ++n;
        }
        return n;
    }

    private int getPageNumber(int n) {
        int n2 = n / DecisionRulesTableInteractiveItem.NUM_ROWS_PER_PAGE + 1;
        return n2;
    }

    private boolean isTopRulesByCategorySelected() {
        boolean bl = false;
        if (this.mTableContentsComboBox != null) {
            int n = this.mTableContentsComboBox.getSelectedIndex();
            bl = this.isTargetCategorical() && n == 1;
        }
        return bl;
    }

    private boolean isAllRulesSelected() {
        boolean bl = false;
        if (this.mTableContentsComboBox != null) {
            int n = this.mTableContentsComboBox.getSelectedIndex();
            bl = this.isTargetCategorical() ? n == 2 : n == 1;
        }
        return bl;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        DecisionRulesTableInteractiveItem decisionRulesTableInteractiveItem = (DecisionRulesTableInteractiveItem)this.mInteractiveViewerItem.getItem();
        if (itemEvent.getSource() == this.mTableContentsComboBox && itemEvent.getStateChange() == 1) {
            this.mTargetCategoryComboBox.setVisible(this.isTopRulesByCategorySelected());
            this.targetCategoryComboBoxLabel.setVisible(this.isTopRulesByCategorySelected());
            if (decisionRulesTableInteractiveItem.getAllowSearching()) {
                this.mFindRuleLabel.setVisible(this.isAllRulesSelected());
                this.mFindRuleTextField.setVisible(this.isAllRulesSelected());
            }
            this.mPageLabel1.setVisible(this.isAllRulesSelected());
            this.mPageTextField.setVisible(this.isAllRulesSelected());
            this.mPageLabel2.setVisible(this.isAllRulesSelected());
            this.mFirstPageButton.setVisible(this.isAllRulesSelected());
            this.mPreviousPageButton.setVisible(this.isAllRulesSelected());
            this.mNextPageButton.setVisible(this.isAllRulesSelected());
            this.mLastPageButton.setVisible(this.isAllRulesSelected());
        }
        if (itemEvent.getSource() == this.mTableContentsComboBox && itemEvent.getStateChange() == 1 || itemEvent.getSource() == this.mTargetCategoryComboBox && itemEvent.getStateChange() == 1) {
            if (itemEvent.getSource() == this.mTableContentsComboBox) {
                int n = ((JComboBox)itemEvent.getSource()).getSelectedIndex();
                decisionRulesTableInteractiveItem.setTableContentMode(n);
            }
            if (this.isTargetCategorical()) {
                decisionRulesTableInteractiveItem.setSelectedCategory(this.mTargetCategoryComboBox.getSelectedItem().toString());
                decisionRulesTableInteractiveItem.updateTableFilterData();
            }
            this.refreshTable();
            decisionRulesTableInteractiveItem.getTableItem().setActionJson(decisionRulesTableInteractiveItem.getTableActionJson());
        }
    }

    private void refreshTable() {
        this.remove((Component)this.mDecisionRulesTable.getTableComponent());
        this.createTable();
        this.addDecisionRulesTable();
    }

    @Override
    public LightPivotTable getActiveLightTable() {
        return this.mDecisionRulesTable.getTableComponent().getLighttable();
    }

    public int doFindRowForRuleId(String string) {
        OutputTable outputTable;
        int n = -1;
        if (this.mRowHeaderExCellDataArrayList == null) {
            DecisionRulesTableInteractiveItem decisionRulesTableInteractiveItem = (DecisionRulesTableInteractiveItem)this.mInteractiveViewerItem.getItem();
            outputTable = this.createOutputTable(decisionRulesTableInteractiveItem.getTableJson(), decisionRulesTableInteractiveItem.getDataModelJson(), decisionRulesTableInteractiveItem.getTableFilterJson());
            outputTable.getTableComponent().sortDataColumn(decisionRulesTableInteractiveItem.getSortColumnIndex(), decisionRulesTableInteractiveItem.getSortAscending());
            this.mRowHeaderExCellDataArrayList = outputTable.getTableComponent().getRowHeaderExCells();
        }
        for (int i = 0; i < this.mRowHeaderExCellDataArrayList.size(); ++i) {
            ExCellData exCellData;
            CellData cellData;
            outputTable = this.mRowHeaderExCellDataArrayList.get(i);
            if (outputTable.size() <= 0 || !(cellData = (exCellData = (ExCellData)outputTable.get(0)).getCelldata()).getCellText().equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public void takeAction(JSONObject jSONObject) {
        DecisionRulesTableInteractiveItem decisionRulesTableInteractiveItem = (DecisionRulesTableInteractiveItem)this.mInteractiveViewerItem.getItem();
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"action");
        if (jSONObject2.containsKey((Object)"sortAction")) {
            JSONObject jSONObject3 = (JSONObject)BasicFactory.getItem((Object)jSONObject2, (String)"sortAction");
            String string = (String)BasicFactory.getItem((Object)jSONObject3, (String)"sortAscending");
            Integer n = (Integer)BasicFactory.getItem((Object)jSONObject3, (String)"sortColumn");
            boolean bl = new Boolean(string);
            if (decisionRulesTableInteractiveItem.getSortAscending() != bl || decisionRulesTableInteractiveItem.getSortColumnIndex() != n.intValue()) {
                decisionRulesTableInteractiveItem.setSortAscending(bl);
                decisionRulesTableInteractiveItem.setSortColumnIndex(n.intValue());
                this.mRowHeaderExCellDataArrayList = null;
                this.refreshTable();
                if (decisionRulesTableInteractiveItem.getTableContentMode() == DecisionRulesTableInteractiveItem.TableContentMode.ALL_RULES && this.getHighlightedRow() >= 0) {
                    this.findRule();
                }
            }
        }
    }
}

