/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.interactive.ScaleTargetInteractivePanel;
import com.spss.java_client.ui.interactive.ScaleTargetMediator;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.vis.component.VisualizationComponent;
import com.spss.vis.specification.DataValue;
import com.spss.vis.specification.ExtensionSpecification;
import com.spss.vis.specification.GraphSpecification;
import com.spss.vis.specification.Length;
import com.spss.vis.specification.Specification;
import com.spss.vis.specification.VisualizationSpecification;
import com.spss.vis.specification.aesthetic.AestheticSpecification;
import com.spss.vis.specification.data.EmbeddedSourceSpecification;
import com.spss.vis.specification.data.SourceVariableSpecification;
import com.spss.vis.specification.data.VariableSpecification;
import com.spss.vis.specification.element.AreaSpecification;
import com.spss.vis.specification.element.ElementSpecification;
import com.spss.vis.specification.element.IntervalSpecification;
import com.spss.vis.specification.element.LineSpecification;
import com.spss.vis.specification.guide.GuideSpecification;
import com.spss.vis.specification.guide.LineGuideSpecification;
import com.spss.vis.specification.label.LabelSpecification;
import com.spss.vis.specification.statistic.StatisticSpecification;
import com.spss.vis.specification.style.FrameStyle;
import com.spss.vis.specification.style.LineStyle;
import com.spss.vis.specification.style.StyleSpecification;
import com.spss.vis.specification.style.TextAlignmentType;
import com.spss.vis.specification.style.TextStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class ChartOptionsDlg
extends BaseDialog
implements ActionListener,
FocusListener,
KeyListener,
TableModelListener {
    private ScaleTargetMediator mMediator;
    private VisualizationComponent mVisComp;
    private JComboBox mViewCombo;
    private FloatTextField mLowerTxt;
    private FloatTextField mUpperTxt;
    private JCheckBox mNegativeInfinityChk;
    private JCheckBox mPositiveInfinityChk;
    private JCheckBox mMeanChk;
    private JCheckBox mMedianChk;
    private JCheckBox mSigmasChk;
    private JCheckBox mPercentilesChk;
    private JCheckBox mCustomPosChk;
    private FloatTextField mBottomPercentTxt;
    private FloatTextField mTopPercentTxt;
    private FloatTextField mSigmasTxt;
    private JTable mPositionsTable;
    private CustomListModel mTableModel;
    private boolean mIsTableEditable;
    private JLabel mViewLbl;
    private JLabel mLowerLbl;
    private JLabel mUpperLbl;
    private JLabel mBottomLbl;
    private JLabel mTopLbl;
    private JButton mContinueBtn;
    private JButton mCancelBtn;
    private JButton mHelpBtn;
    private int mOldViewTypeIndex;
    private boolean mIsLowerSliderDirty;
    private boolean mIsUpperSliderDirty;
    private boolean mIsMeanDirty;
    private boolean mIsMedianDirty;
    private boolean mIsSigmaDirty;
    private boolean mIsPercentBottomDirty;
    private boolean mIsPercentTopDirty;
    private boolean mIsCustomPositionDirty;
    private static final String MEAN_LINE_ID = "meanLine";
    private static final String MEDIAN_LINE_ID = "medianLine";
    private static final String SIGMAS_LOW_LINE_ID = "sigmasLowLine";
    private static final String SIGMAS_HIGH_LINE_ID = "sigmasHighLine";
    private static final String PERCENTILES_BOTTOM_LINE_ID = "percentilesBottomLine";
    private static final String PERCENTILES_TOP_LINE_ID = "percentilesTopLine";
    private static final String CUSTOM_POSITION_ID = "customPosition";
    private static final String SIGMA_VALUE_ID = "sigmaValue";
    private static final String PERCENT_BOTTOM_VALUE_ID = "percentBottomValue";
    private static final String PERCENT_TOP_VALUE_ID = "percentTopValue";
    private static final String CUSTOM_POSITIONS_STATUS = "customPositionStatus";
    private static final String SELECTED_ITERATIONS = "selectedIterations";
    private static final String LABEL_REFERENCE_LINES = "labelReferenceLines";
    public static final String LOWER_INFINITY_STATUS = "lowerinfinity";
    public static final String UPPER_INFINITY_STATUS = "upperinfinity";
    private JTable mLinesToSelectTable;
    private JCheckBox mLblRefLinesChk;
    private JLabel applyLinesLbl;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 1989, 2013.\n\n";
    }

    public ChartOptionsDlg(JFrame jFrame, VisualizationComponent visualizationComponent, ScaleTargetMediator scaleTargetMediator, ResourceBundle resourceBundle) {
        super(jFrame, ResUtil.getString(resourceBundle, "IDS_CHART_OPTIONS"), resourceBundle, "");
        String string;
        this.mVisComp = visualizationComponent;
        this.mMediator = scaleTargetMediator;
        this.mMediator.setChartOptionDialog(this);
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        ExtensionSpecification[] extensionSpecificationArray = visualizationSpecification.getExtensionSpecifications();
        if (extensionSpecificationArray.length > 0 && (string = extensionSpecificationArray[0].get("targets")) != null && string.length() > 0 && Integer.parseInt(string) > 1) {
            this.applyLinesLbl.setText(ResUtil.getString(this.mResBundle, "IDS_APPLY_LINES_TO_TARGETS"));
        }
        this.initializeControls();
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.setVisible(true);
    }

    public void refreshSliderPosition() {
        double d = this.mMediator.getGuideLineInfo(true).getValue();
        double d2 = this.mMediator.getGuideLineInfo(false).getValue();
        this.mLowerTxt.setText(this.mMediator.formatValue(d));
        this.mUpperTxt.setText(this.mMediator.formatValue(d2));
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        double d;
        double d2;
        if (this.mLowerTxt.getText().length() > 0 && this.mUpperTxt.getText().length() > 0 && (d2 = Double.parseDouble(this.mLowerTxt.getText())) > (d = Double.parseDouble(this.mUpperTxt.getText()))) {
            Object object = focusEvent.getSource();
            if (this.mLowerTxt == object) {
                this.mLowerTxt.setText(this.mMediator.formatValue(this.mMediator.getGuideLineInfo(true).getValue()));
            } else if (this.mUpperTxt == object) {
                this.mUpperTxt.setText(this.mMediator.formatValue(this.mMediator.getGuideLineInfo(false).getValue()));
            }
            String string = ResUtil.getString(this.mResBundle, "IDS_LOEWER_TEXT_WARNING");
            JOptionPane.showMessageDialog((Component)((Object)this), string);
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        double d;
        double d2;
        Object object = actionEvent.getSource();
        if (this.mContinueBtn == object) {
            this.doContinue();
            return;
        }
        if ((this.mLowerTxt == object || this.mUpperTxt == object) && this.mLowerTxt.getText().length() > 0 && this.mUpperTxt.getText().length() > 0 && (d2 = Double.parseDouble(this.mLowerTxt.getText())) > (d = Double.parseDouble(this.mUpperTxt.getText()))) {
            if (this.mLowerTxt == object) {
                this.mLowerTxt.setText(this.mMediator.formatValue(this.mMediator.getGuideLineInfo(true).getValue()));
            } else if (this.mUpperTxt == object) {
                this.mUpperTxt.setText(this.mMediator.formatValue(this.mMediator.getGuideLineInfo(false).getValue()));
            }
            String string = ResUtil.getString(this.mResBundle, "IDS_LOEWER_TEXT_WARNING");
            JOptionPane.showMessageDialog((Component)((Object)this), string);
            return;
        }
        if (this.mBottomPercentTxt == object && (d2 = Double.parseDouble(this.mBottomPercentTxt.getText())) >= 50.0) {
            String string = ResUtil.getString(this.mResBundle, "IDS_BOTTOM_PERCENT_WARNING");
            JOptionPane.showMessageDialog((Component)((Object)this), string);
            return;
        }
        this.mContinueBtn.setEnabled(true);
        if (this.mNegativeInfinityChk.isEnabled() && this.mNegativeInfinityChk.isSelected()) {
            this.mLowerLbl.setEnabled(false);
            this.mLowerTxt.setEnabled(false);
            this.mLowerTxt.setEditable(false);
            this.mPositiveInfinityChk.setEnabled(false);
        } else {
            this.mLowerLbl.setEnabled(true);
            this.mLowerTxt.setEnabled(true);
            this.mLowerTxt.setEditable(true);
            this.mPositiveInfinityChk.setEnabled(true);
        }
        if (this.mPositiveInfinityChk.isEnabled() && this.mPositiveInfinityChk.isSelected()) {
            this.mUpperLbl.setEnabled(false);
            this.mUpperTxt.setEnabled(false);
            this.mUpperTxt.setEditable(false);
            this.mNegativeInfinityChk.setEnabled(false);
        } else {
            this.mUpperLbl.setEnabled(true);
            this.mUpperTxt.setEnabled(true);
            this.mUpperTxt.setEditable(true);
            this.mNegativeInfinityChk.setEnabled(true);
        }
        if (this.mSigmasChk.isSelected()) {
            this.mSigmasTxt.setEnabled(true);
        } else {
            this.mSigmasTxt.setEnabled(false);
        }
        if (this.mPercentilesChk == object) {
            if (this.mPercentilesChk.isSelected()) {
                this.mBottomPercentTxt.setEnabled(true);
                this.mTopPercentTxt.setEnabled(true);
                this.mBottomLbl.setEnabled(true);
                this.mTopLbl.setEnabled(true);
            } else {
                this.mBottomPercentTxt.setEnabled(false);
                this.mTopPercentTxt.setEnabled(false);
                this.mBottomLbl.setEnabled(false);
                this.mTopLbl.setEnabled(false);
            }
        }
        if (this.mCustomPosChk == object) {
            if (this.mCustomPosChk.isSelected()) {
                this.mIsTableEditable = true;
                this.mPositionsTable.setEnabled(true);
            } else {
                this.mIsTableEditable = false;
                this.mPositionsTable.setEnabled(false);
            }
        }
        if (this.mLblRefLinesChk == object) {
            this.mContinueBtn.setEnabled(true);
            this.mIsMeanDirty = true;
            this.mIsMedianDirty = true;
            this.mIsSigmaDirty = true;
            this.mIsPercentBottomDirty = true;
            this.mIsPercentTopDirty = true;
            VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
            ExtensionSpecification[] extensionSpecificationArray = visualizationSpecification.getExtensionSpecifications();
            if (extensionSpecificationArray != null && extensionSpecificationArray.length > 0) {
                extensionSpecificationArray[0].put(LABEL_REFERENCE_LINES, String.valueOf(this.mLblRefLinesChk.isSelected()));
            }
        }
        this.setDirty(object);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.mContinueBtn.setEnabled(true);
        this.setDirty(keyEvent.getSource());
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0) {
            this.mContinueBtn.setEnabled(true);
            this.mIsCustomPositionDirty = true;
        }
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_simulation_chartoptions");
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel();
        this.mContinueBtn = new JButton(ResUtil.getString(this.mResBundle, "IDS_CONTINUE"));
        this.mContinueBtn.addActionListener(this);
        this.mCancelBtn = new JButton((Action)this.createCancelAction());
        this.mHelpBtn = new JButton((Action)this.createHelpAction());
        jPanel.add(this.mContinueBtn);
        jPanel.add(this.mCancelBtn);
        jPanel.add(this.mHelpBtn);
        return jPanel;
    }

    protected void init() {
        super.init();
        this.mViewCombo = new JComboBox();
        this.mLowerTxt = new FloatTextField(2);
        this.mLowerTxt.setColumns(8);
        this.mUpperTxt = new FloatTextField(2);
        this.mUpperTxt.setColumns(8);
        this.mNegativeInfinityChk = new JCheckBox("-" + ResUtil.getString(this.mResBundle, "IDS_INFINITY"));
        this.mPositiveInfinityChk = new JCheckBox(ResUtil.getString(this.mResBundle, "IDS_INFINITY"));
        this.mMeanChk = new JCheckBox(ResUtil.getString(this.mResBundle, "IDS_MEAN"));
        this.mMedianChk = new JCheckBox(ResUtil.getString(this.mResBundle, "IDS_MEDIAN"));
        this.mSigmasChk = new JCheckBox(ResUtil.getString(this.mResBundle, "IDS_SIGMAS"));
        this.mPercentilesChk = new JCheckBox(ResUtil.getString(this.mResBundle, "IDS_PERCENTILES"));
        this.mCustomPosChk = new JCheckBox(ResUtil.getString(this.mResBundle, "IDS_CUSTOM_POSITIONS"));
        this.mBottomPercentTxt = new FloatTextField(0.0, 50.0, 2);
        this.mTopPercentTxt = new FloatTextField(50.0, 100.0, 2);
        this.mSigmasTxt = new FloatTextField(1.0, 10.0, 2);
        this.mBottomPercentTxt.setColumns(6);
        this.mTopPercentTxt.setColumns(6);
        this.mSigmasTxt.setColumns(5);
        this.mTableModel = new CustomListModel();
        this.mPositionsTable = new JTable(this.mTableModel);
        this.mPositionsTable.setTableHeader(null);
        this.mPositionsTable.getModel().addTableModelListener(this);
        this.mPositionsTable.setDefaultRenderer(String.class, new CustomCellRender());
        TableCellEditor tableCellEditor = this.mPositionsTable.getDefaultEditor(String.class);
        JTextField jTextField = (JTextField)((DefaultCellEditor)tableCellEditor).getComponent();
        jTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                ChartOptionsDlg.this.mContinueBtn.setEnabled(true);
            }
        });
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 5;
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(ResUtil.getString(this.mResBundle, "IDS_SLIDER_POSITIONS")));
        jPanel2.setLayout(new GridBagLayout());
        this.mLowerLbl = new JLabel(ResUtil.getString(this.mResBundle, "IDS_LOWER"));
        this.mUpperLbl = new JLabel(ResUtil.getString(this.mResBundle, "IDS_UPPER"));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel2, this.mLowerLbl, gridBagConstraints, 0, 0, 1, 1, 23, new Insets(0, n, n, n));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel2, (JComponent)this.mLowerTxt, gridBagConstraints, 1, 0, 1, 1, 23, new Insets(0, n, n, n));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel2, this.mUpperLbl, gridBagConstraints, 2, 0, 1, 1, 23, new Insets(0, n, n, n));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel2, (JComponent)this.mUpperTxt, gridBagConstraints, 3, 0, 1, 1, 23, new Insets(0, n, n, n));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel2, this.mNegativeInfinityChk, gridBagConstraints, 1, 1, 1, 1, 23, new Insets(0, n, n, n));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel2, this.mPositiveInfinityChk, gridBagConstraints, 3, 1, 1, 1, 23, new Insets(0, n, n, n));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(ResUtil.getString(this.mResBundle, "IDS_REFERENCE_LINES")));
        jPanel3.setLayout(new GridBagLayout());
        this.applyLinesLbl = new JLabel(ResUtil.getString(this.mResBundle, "IDS_APPLY_LINES_TO_ITERATIONS"));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel3, this.applyLinesLbl, gridBagConstraints, 0, 0, 2, 1, 23, new Insets(0, n, n, n));
        this.mLinesToSelectTable = new JTable();
        JScrollPane jScrollPane = new JScrollPane(this.mLinesToSelectTable);
        int n2 = 200;
        int n3 = 80;
        jScrollPane.setPreferredSize(new Dimension(n2, n3));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel3, jScrollPane, gridBagConstraints, 0, 1, 2, 1, 23, new Insets(0, n, n, n));
        JLabel jLabel = new JLabel(ResUtil.getString(this.mResBundle, "IDS_SELECT_LINES_TO_APPLY"));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel3, jLabel, gridBagConstraints, 0, 2, 2, 1, 23, new Insets(n, n, 0, n));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel3, this.mMeanChk, gridBagConstraints, 0, 3, 1, 1, 23, new Insets(0, n * 2, n, n));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel3, this.mMedianChk, gridBagConstraints, 0, 4, 1, 1, 23, new Insets(0, n * 2, n, n));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel3, this.mSigmasChk, gridBagConstraints, 0, 5, 1, 1, 23, new Insets(0, n * 2, n, n));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel3, (JComponent)this.mSigmasTxt, gridBagConstraints, 1, 5, 1, 1, 23, new Insets(0, n * 2, n, n));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel3, this.mPercentilesChk, gridBagConstraints, 0, 6, 1, 1, 23, new Insets(0, n * 2, n, n));
        this.mBottomLbl = new JLabel(ResUtil.getString(this.mResBundle, "IDS_BOTTOM"));
        this.mTopLbl = new JLabel(ResUtil.getString(this.mResBundle, "IDS_TOP"));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel3, this.mBottomLbl, gridBagConstraints, 0, 7, 1, 1, 24, new Insets(0, n, n, n));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel3, this.mTopLbl, gridBagConstraints, 0, 8, 1, 1, 24, new Insets(0, n, n, n));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel3, (JComponent)this.mBottomPercentTxt, gridBagConstraints, 1, 7, 1, 1, 23, new Insets(0, 0, n, n));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel3, (JComponent)this.mTopPercentTxt, gridBagConstraints, 1, 8, 1, 1, 23, new Insets(0, 0, n, n));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel3, this.mCustomPosChk, gridBagConstraints, 3, 0, 1, 1, 23, new Insets(0, n, n, n));
        JScrollPane jScrollPane2 = new JScrollPane(this.mPositionsTable, 20, 31);
        jScrollPane2.setPreferredSize(new Dimension(130, 150));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel3, jScrollPane2, gridBagConstraints, 3, 1, 1, 8, 23, new Insets(0, 5 * n, n, n));
        gridBagConstraints.fill = 1;
        ScaleTargetInteractivePanel.addUsingGBL(jPanel3, new JSeparator(1), gridBagConstraints, 2, 0, 1, 9, 23, new Insets(n, n, n, n));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel3, new JSeparator(), gridBagConstraints, 0, 9, 4, 1, 23, new Insets(n, n, n, n));
        gridBagConstraints.fill = 0;
        this.mLblRefLinesChk = new JCheckBox(ResUtil.getString(this.mResBundle, "IDS_LABEL_REF_LINES"));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel3, this.mLblRefLinesChk, gridBagConstraints, 0, 10, 4, 1, 23, new Insets(n, n, n, n));
        this.mViewLbl = new JLabel(ResUtil.getString(this.mResBundle, "IDS_VIEW"));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel, this.mViewLbl, gridBagConstraints, 0, 0, 1, 1, 23, new Insets(n, n, n, n));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel, this.mViewCombo, gridBagConstraints, 1, 0, 1, 1, 23, new Insets(n, n, n, n));
        gridBagConstraints.fill = 1;
        ScaleTargetInteractivePanel.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 2, 1, 23, new Insets(n, n, n, n));
        ScaleTargetInteractivePanel.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 2, 1, 23, new Insets(n, n, n, n));
        this.addListeners();
    }

    private void addListeners() {
        this.mViewCombo.addActionListener(this);
        this.mLowerTxt.addActionListener((ActionListener)this);
        this.mUpperTxt.addActionListener((ActionListener)this);
        this.mLowerTxt.addFocusListener((FocusListener)this);
        this.mUpperTxt.addFocusListener((FocusListener)this);
        this.mNegativeInfinityChk.addActionListener(this);
        this.mPositiveInfinityChk.addActionListener(this);
        this.mMeanChk.addActionListener(this);
        this.mMedianChk.addActionListener(this);
        this.mSigmasChk.addActionListener(this);
        this.mPercentilesChk.addActionListener(this);
        this.mCustomPosChk.addActionListener(this);
        this.mBottomPercentTxt.addActionListener((ActionListener)this);
        this.mTopPercentTxt.addActionListener((ActionListener)this);
        this.mSigmasTxt.addActionListener((ActionListener)this);
        this.mLblRefLinesChk.addActionListener(this);
        this.mLowerTxt.addKeyListener((KeyListener)this);
        this.mUpperTxt.addKeyListener((KeyListener)this);
        this.mBottomPercentTxt.addKeyListener((KeyListener)this);
        this.mTopPercentTxt.addKeyListener((KeyListener)this);
        this.mSigmasTxt.addKeyListener((KeyListener)this);
        this.mPositionsTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    ChartOptionsDlg.this.mPositionsTable.setValueAt("", ChartOptionsDlg.this.mPositionsTable.getSelectedRow(), 0);
                }
                ChartOptionsDlg.this.mContinueBtn.setEnabled(true);
            }
        });
    }

    private void initializeControls() {
        int n;
        Object[] objectArray;
        Object object;
        LineSpecification lineSpecification2;
        LineSpecification[] lineSpecificationArray;
        LineSpecification[] lineSpecificationArray2;
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        if (this.mMediator.isCumulative()) {
            this.mViewLbl.setText(ResUtil.getString(this.mResBundle, "IDS_ORDER"));
            this.mViewCombo.setModel(new DefaultComboBoxModel<String>(new String[]{ResUtil.getString(this.mResBundle, "IDS_ASCENDING"), ResUtil.getString(this.mResBundle, "IDS_DESCENDING")}));
            lineSpecificationArray2 = (LineSpecification[])visualizationSpecification.findDescendantsOfType(LineSpecification.class);
            lineSpecificationArray = lineSpecificationArray2[0].getY();
            if (lineSpecificationArray instanceof SourceVariableSpecification) {
                this.mViewCombo.setSelectedIndex(0);
            } else {
                this.mViewCombo.setSelectedIndex(1);
            }
        } else {
            this.mViewLbl.setText(ResUtil.getString(this.mResBundle, "IDS_VIEW"));
            this.mViewCombo.setModel(new DefaultComboBoxModel<String>(new String[]{ResUtil.getString(this.mResBundle, "IDS_CURVE"), ResUtil.getString(this.mResBundle, "IDS_HISTOGRAM")}));
            lineSpecificationArray2 = (GraphSpecification[])visualizationSpecification.findDescendantsOfType(GraphSpecification.class);
            lineSpecificationArray = lineSpecificationArray2[0].getElementSpecifications()[0];
            if (lineSpecificationArray instanceof AreaSpecification) {
                this.mViewCombo.setSelectedIndex(0);
            } else {
                this.mViewCombo.setSelectedIndex(1);
            }
        }
        this.mOldViewTypeIndex = this.mViewCombo.getSelectedIndex();
        this.refreshSliderPosition();
        for (LineSpecification lineSpecification2 : lineSpecificationArray2 = (LineGuideSpecification[])visualizationSpecification.findDescendantsOfType(LineGuideSpecification.class)) {
            if (lineSpecification2.getName().startsWith(MEAN_LINE_ID)) {
                this.mMeanChk.setSelected(true);
            }
            if (lineSpecification2.getName().startsWith(MEDIAN_LINE_ID)) {
                this.mMedianChk.setSelected(true);
            }
            if (lineSpecification2.getName().startsWith(SIGMAS_LOW_LINE_ID) || lineSpecification2.getName().startsWith(SIGMAS_HIGH_LINE_ID)) {
                this.mSigmasChk.setSelected(true);
            }
            if (lineSpecification2.getName().startsWith(PERCENTILES_BOTTOM_LINE_ID) || lineSpecification2.getName().startsWith(PERCENTILES_TOP_LINE_ID)) {
                this.mPercentilesChk.setSelected(true);
            }
            if (lineSpecification2.getName() == null || !lineSpecification2.getName().startsWith(CUSTOM_POSITION_ID)) continue;
            this.mTableModel.addValue(lineSpecification2.getX().toString());
        }
        this.mTableModel.addValue("");
        if (this.mSigmasChk.isSelected()) {
            this.mSigmasTxt.setEnabled(true);
        } else {
            this.mSigmasTxt.setEnabled(false);
        }
        if (this.mPercentilesChk.isSelected()) {
            this.mBottomPercentTxt.setEnabled(true);
            this.mTopPercentTxt.setEnabled(true);
            this.mBottomLbl.setEnabled(true);
            this.mTopLbl.setEnabled(true);
        } else {
            this.mBottomPercentTxt.setEnabled(false);
            this.mTopPercentTxt.setEnabled(false);
            this.mBottomLbl.setEnabled(false);
            this.mTopLbl.setEnabled(false);
        }
        lineSpecificationArray = visualizationSpecification.getExtensionSpecifications();
        if (lineSpecificationArray != null && lineSpecificationArray.length > 0) {
            String string = lineSpecificationArray[0].get(LOWER_INFINITY_STATUS);
            String string2 = lineSpecificationArray[0].get(UPPER_INFINITY_STATUS);
            lineSpecification2 = lineSpecificationArray[0].get(SIGMA_VALUE_ID);
            String string3 = lineSpecificationArray[0].get(PERCENT_BOTTOM_VALUE_ID);
            object = lineSpecificationArray[0].get(PERCENT_TOP_VALUE_ID);
            objectArray = lineSpecificationArray[0].get(CUSTOM_POSITIONS_STATUS);
            if (string != null && "true".equals(string)) {
                this.mMediator.setLowerLineInfinity(true);
                this.mNegativeInfinityChk.setSelected(true);
                if (this.mNegativeInfinityChk.isEnabled()) {
                    this.mPositiveInfinityChk.setEnabled(false);
                    this.mLowerTxt.setEditable(false);
                    this.mLowerTxt.setEnabled(false);
                    this.mLowerLbl.setEnabled(false);
                }
            } else {
                this.mMediator.setLowerLineInfinity(false);
                this.mNegativeInfinityChk.setSelected(false);
                if (this.mNegativeInfinityChk.isEnabled()) {
                    this.mPositiveInfinityChk.setEnabled(true);
                    this.mLowerTxt.setEditable(true);
                    this.mLowerTxt.setEnabled(true);
                    this.mLowerLbl.setEnabled(true);
                }
            }
            if (string2 != null && "true".equals(string2)) {
                this.mMediator.setUpperLineInfinity(true);
                this.mPositiveInfinityChk.setSelected(true);
                if (this.mPositiveInfinityChk.isEnabled()) {
                    this.mNegativeInfinityChk.setEnabled(false);
                    this.mUpperTxt.setEditable(false);
                    this.mUpperTxt.setEnabled(false);
                    this.mUpperLbl.setEnabled(false);
                }
            } else {
                this.mMediator.setUpperLineInfinity(false);
                this.mPositiveInfinityChk.setSelected(false);
                if (this.mPositiveInfinityChk.isEnabled()) {
                    this.mNegativeInfinityChk.setEnabled(true);
                    this.mUpperTxt.setEditable(true);
                    this.mUpperTxt.setEnabled(true);
                    this.mUpperLbl.setEnabled(true);
                }
            }
            if (lineSpecification2 != null && lineSpecification2.length() > 0) {
                this.mSigmasTxt.setText((String)lineSpecification2);
            }
            if (objectArray != null && "true".equals(objectArray)) {
                this.mCustomPosChk.setSelected(true);
            } else {
                this.mCustomPosChk.setSelected(false);
            }
            if (this.mPercentilesChk.isSelected()) {
                if (string3 != null) {
                    this.mBottomPercentTxt.setText(string3);
                }
                if (object != null) {
                    this.mTopPercentTxt.setText((String)object);
                }
            }
        }
        if (this.mCustomPosChk.isSelected()) {
            this.mIsTableEditable = true;
            this.mPositionsTable.setEnabled(true);
        } else {
            this.mIsTableEditable = false;
            this.mPositionsTable.setEnabled(false);
        }
        this.mContinueBtn.setEnabled(false);
        this.getRootPane().setDefaultButton(null);
        Specification specification = visualizationSpecification.getSpecification("source0");
        if (specification instanceof EmbeddedSourceSpecification && ((n = ((EmbeddedSourceSpecification)specification).getData().length) < 2 || n > 3)) {
            this.mViewLbl.setEnabled(false);
            this.mViewCombo.setEnabled(false);
        }
        Map<Integer, String> map = this.mMediator.getLegendValueMap();
        lineSpecification2 = new Object[map.size()][2];
        for (int i = 0; i < map.size(); ++i) {
            lineSpecification2[i][0] = Boolean.FALSE;
            if (map.size() == 1 && (map.get(i) == null || map.get(i).length() == 0)) {
                object = null;
                objectArray = (ElementSpecification[])visualizationSpecification.findDescendantsOfType(ElementSpecification.class);
                if (objectArray.length > 0) {
                    object = objectArray[0].getX();
                }
                if (object != null) {
                    lineSpecification2[i][1] = object.getLabel();
                    continue;
                }
                lineSpecification2[i][1] = "";
                continue;
            }
            lineSpecification2[i][1] = map.get(i);
        }
        if (lineSpecificationArray != null && lineSpecificationArray.length > 0) {
            String string = lineSpecificationArray[0].get(SELECTED_ITERATIONS);
            if (string != null) {
                object = string.split(";");
                for (String string4 : object) {
                    if (string4 == null || string4.length() <= 0) continue;
                    lineSpecification2[Integer.parseInt((String)string4)][0] = Boolean.TRUE;
                }
            } else {
                lineSpecification2[0][0] = Boolean.TRUE;
            }
            if ((object = lineSpecificationArray[0].get(LABEL_REFERENCE_LINES)) == null || "true".equals(object)) {
                this.mLblRefLinesChk.setSelected(true);
            }
        }
        String string = ResUtil.getString(this.mResBundle, "IDS_APPLY");
        object = this.mMediator.getLegendTitle();
        if (object == null || ((String)object).length() == 0) {
            object = ResUtil.getString(this.mResBundle, "IDS_TARGET");
        } else if (((String)object).endsWith("*")) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        objectArray = new String[]{string, object};
        DefaultTableModel defaultTableModel = new DefaultTableModel((Object[][])lineSpecification2, objectArray){

            public Class getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }
        };
        this.mLinesToSelectTable.setModel(defaultTableModel);
        int n2 = 200;
        int n3 = 16;
        int n4 = this.mLinesToSelectTable.getFontMetrics(this.mLinesToSelectTable.getFont()).stringWidth(string);
        TableColumn tableColumn = this.mLinesToSelectTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(n4 + n3);
        tableColumn = this.mLinesToSelectTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(n2 - n4 - n3);
        this.mLinesToSelectTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                ChartOptionsDlg.this.mContinueBtn.setEnabled(true);
                ChartOptionsDlg.this.mIsMeanDirty = true;
                ChartOptionsDlg.this.mIsMedianDirty = true;
                ChartOptionsDlg.this.mIsSigmaDirty = true;
                ChartOptionsDlg.this.mIsPercentBottomDirty = true;
                ChartOptionsDlg.this.mIsPercentTopDirty = true;
            }
        });
    }

    private void viewTypeChange() {
        if (this.mViewCombo.getSelectedIndex() == 0) {
            if (this.mMediator.isCumulative()) {
                this.switchOrder(true);
            } else {
                this.switchElement((ElementSpecification)new AreaSpecification());
            }
        } else if (this.mMediator.isCumulative()) {
            this.switchOrder(false);
        } else {
            this.switchElement((ElementSpecification)new IntervalSpecification());
        }
        this.setAllDirty();
    }

    private void switchElement(ElementSpecification elementSpecification) {
        StatisticSpecification[] statisticSpecificationArray;
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        GraphSpecification[] graphSpecificationArray = (GraphSpecification[])visualizationSpecification.findDescendantsOfType(GraphSpecification.class);
        ElementSpecification elementSpecification2 = graphSpecificationArray[0].getElementSpecifications()[0];
        elementSpecification.setX(elementSpecification2.getX());
        elementSpecification.setStyle(elementSpecification2.getStyle(""));
        StatisticSpecification[] statisticSpecificationArray2 = statisticSpecificationArray = elementSpecification2.getStatistics();
        int n = statisticSpecificationArray2.length;
        for (int i = 0; i < n; ++i) {
            StatisticSpecification statisticSpecification = statisticSpecificationArray2[i];
            elementSpecification.addStatistic(statisticSpecification);
        }
        for (StatisticSpecification statisticSpecification : statisticSpecificationArray2 = elementSpecification2.getAestheticSpecifications()) {
            elementSpecification.addAesthetic((AestheticSpecification)statisticSpecification);
        }
        elementSpecification.setPositionModifier(elementSpecification2.getPositionModifier());
        graphSpecificationArray[0].remove((Specification)elementSpecification2);
        graphSpecificationArray[0].addElement(elementSpecification);
        this.mVisComp.refresh();
    }

    private void switchOrder(boolean bl) {
        Specification specification;
        Object object;
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        ExtensionSpecification[] extensionSpecificationArray = visualizationSpecification.getExtensionSpecifications();
        if (extensionSpecificationArray.length > 0) {
            if (bl) {
                LineSpecification[] lineSpecificationArray;
                object = extensionSpecificationArray[0].get("ascending");
                specification = visualizationSpecification.getSpecification((String)object);
                if (specification instanceof VariableSpecification && (lineSpecificationArray = (LineSpecification[])visualizationSpecification.findDescendantsOfType(LineSpecification.class)).length > 0) {
                    lineSpecificationArray[0].setY((VariableSpecification)specification);
                }
            } else {
                LineSpecification[] lineSpecificationArray;
                object = extensionSpecificationArray[0].get("descending");
                specification = visualizationSpecification.getSpecification((String)object);
                if (specification instanceof VariableSpecification && (lineSpecificationArray = (LineSpecification[])visualizationSpecification.findDescendantsOfType(LineSpecification.class)).length > 0) {
                    lineSpecificationArray[0].setY((VariableSpecification)specification);
                }
            }
        }
        if (((LineSpecification[])(object = (LineSpecification[])visualizationSpecification.findDescendantsOfType(LineSpecification.class))).length > 0) {
            specification = object[0].getY();
            this.mVisComp.refresh();
        }
    }

    private void doContinue() {
        Object object;
        Boolean bl;
        int n;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        Object object2;
        Object object3;
        Object object4;
        int n3;
        int n4 = this.mLinesToSelectTable.getRowCount();
        String string = "";
        for (n3 = 0; n3 < n4; ++n3) {
            object4 = (ExtensionSpecification[])this.mLinesToSelectTable.getValueAt(n3, 0);
            if (object4 != Boolean.TRUE) continue;
            string = string + n3 + ";";
        }
        if (string.length() > 0) {
            VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
            object4 = visualizationSpecification.getExtensionSpecifications();
            object4[0].put(SELECTED_ITERATIONS, string);
        }
        if ((n3 = this.mViewCombo.getSelectedIndex()) != this.mOldViewTypeIndex) {
            this.viewTypeChange();
        }
        if (this.mPositionsTable.isEditing()) {
            this.mPositionsTable.getCellEditor().stopCellEditing();
        }
        if (this.mIsLowerSliderDirty && this.mLowerTxt.getText().length() > 0) {
            this.mMediator.getGuideLineInfo(true).setValue(Double.parseDouble(this.mLowerTxt.getText()));
        }
        if (this.mIsUpperSliderDirty && this.mUpperTxt.getText().length() > 0) {
            this.mMediator.getGuideLineInfo(false).setValue(Double.parseDouble(this.mUpperTxt.getText()));
        }
        if (this.mIsMeanDirty) {
            object4 = this.getLineGuidesStartsWithName(MEAN_LINE_ID);
            object3 = ((ArrayList)object4).iterator();
            while (object3.hasNext()) {
                object2 = (LineGuideSpecification)object3.next();
                if (object2 == null) continue;
                object2.getParent().remove((Specification)object2);
            }
            if (this.mMeanChk.isSelected()) {
                object3 = this.mMediator.getMeans();
                object2 = new double[((Object)object3).length];
                n2 = 0;
                objectArray2 = new int[((Iterator<E>)object3).length];
                objectArray = new String[((Iterator<E>)object3).length];
                for (n = 0; n < ((Iterator<E>)object3).length; ++n) {
                    bl = (Boolean)this.mLinesToSelectTable.getValueAt(n, 0);
                    if (bl != Boolean.TRUE) continue;
                    objectArray[n2] = ResUtil.getString(this.mResBundle, "IDS_MEAN") + " = " + this.mMediator.displayFormatValue((double)object3[n]);
                    object2[n2] = object3[n];
                    objectArray2[n2] = n;
                    ++n2;
                }
                this.addReferences((double[])object2, MEAN_LINE_ID, (String[])objectArray, (int[])objectArray2, n2);
            }
        }
        if (this.mIsMedianDirty) {
            object4 = this.getLineGuidesStartsWithName(MEDIAN_LINE_ID);
            object3 = ((ArrayList)object4).iterator();
            while (object3.hasNext()) {
                object2 = (LineGuideSpecification)object3.next();
                if (object2 == null) continue;
                object2.getParent().remove((Specification)object2);
            }
            if (this.mMedianChk.isSelected()) {
                object3 = this.mMediator.getMedians();
                object2 = new double[((Object)object3).length];
                n2 = 0;
                objectArray2 = new int[((Iterator<E>)object3).length];
                objectArray = new String[((Iterator<E>)object3).length];
                for (n = 0; n < ((Iterator<E>)object3).length; ++n) {
                    bl = (Boolean)this.mLinesToSelectTable.getValueAt(n, 0);
                    if (bl != Boolean.TRUE) continue;
                    objectArray[n2] = ResUtil.getString(this.mResBundle, "IDS_MEDIAN") + " = " + this.mMediator.displayFormatValue((double)object3[n]);
                    object2[n2] = object3[n];
                    objectArray2[n2] = n;
                    ++n2;
                }
                this.addReferences((double[])object3, MEDIAN_LINE_ID, (String[])objectArray, (int[])objectArray2, n2);
            }
        }
        if (this.mIsSigmaDirty) {
            object4 = this.getLineGuidesStartsWithName(SIGMAS_LOW_LINE_ID);
            object3 = ((ArrayList)object4).iterator();
            while (object3.hasNext()) {
                object2 = (LineGuideSpecification)object3.next();
                if (object2 == null) continue;
                object2.getParent().remove((Specification)object2);
            }
            object4 = this.getLineGuidesStartsWithName(SIGMAS_HIGH_LINE_ID);
            object3 = ((ArrayList)object4).iterator();
            while (object3.hasNext()) {
                object2 = (LineGuideSpecification)object3.next();
                if (object2 == null) continue;
                object2.getParent().remove((Specification)object2);
            }
            if (this.mSigmasChk.isSelected() && this.mSigmasTxt.getText().length() > 0) {
                object3 = this.mMediator.getSigmas();
                double d = Double.parseDouble(this.mSigmasTxt.getText());
                objectArray2 = this.mMediator.getMeans();
                objectArray = new double[((Object)object3).length];
                for (n = 0; n < objectArray.length; ++n) {
                    objectArray[n] = (String)(objectArray2[n] - d * object3[n]);
                }
                double[] dArray = new double[((Object)object3).length];
                int n5 = 0;
                int[] nArray = new int[((Object)object3).length];
                object = new String[((Object)object3).length];
                for (int i = 0; i < ((Object)object3).length; ++i) {
                    Boolean bl2 = (Boolean)this.mLinesToSelectTable.getValueAt(i, 0);
                    if (bl2 != Boolean.TRUE) continue;
                    object[n5] = "-" + d + " " + ResUtil.getString(this.mResBundle, "IDS_SIGMA") + " = " + this.mMediator.displayFormatValue((double)objectArray[i]);
                    dArray[n5] = (double)objectArray[i];
                    nArray[n5] = i;
                    ++n5;
                }
                this.addReferences(dArray, SIGMAS_LOW_LINE_ID, (String[])object, nArray, n5);
                double[] dArray2 = new double[((Object)object3).length];
                for (int i = 0; i < dArray2.length; ++i) {
                    dArray2[i] = objectArray2[i] + d * object3[i];
                }
                double[] dArray3 = new double[((Object)object3).length];
                n5 = 0;
                nArray = new int[((Object)object3).length];
                object = new String[((Object)object3).length];
                for (int i = 0; i < ((Object)object3).length; ++i) {
                    Boolean bl3 = (Boolean)this.mLinesToSelectTable.getValueAt(i, 0);
                    if (bl3 != Boolean.TRUE) continue;
                    object[n5] = d + " " + ResUtil.getString(this.mResBundle, "IDS_SIGMA") + " = " + this.mMediator.displayFormatValue(dArray2[i]);
                    dArray3[n5] = dArray2[i];
                    nArray[n5] = i;
                    ++n5;
                }
                this.addReferences(dArray3, SIGMAS_HIGH_LINE_ID, (String[])object, nArray, n5);
            }
        }
        if (this.mIsPercentBottomDirty || this.mIsPercentTopDirty) {
            object4 = this.getLineGuidesStartsWithName(PERCENTILES_BOTTOM_LINE_ID);
            object3 = ((ArrayList)object4).iterator();
            while (object3.hasNext()) {
                LineGuideSpecification lineGuideSpecification = (LineGuideSpecification)object3.next();
                if (lineGuideSpecification == null) continue;
                lineGuideSpecification.getParent().remove((Specification)lineGuideSpecification);
            }
            object4 = this.getLineGuidesStartsWithName(PERCENTILES_TOP_LINE_ID);
            object3 = ((ArrayList)object4).iterator();
            while (object3.hasNext()) {
                LineGuideSpecification lineGuideSpecification = (LineGuideSpecification)object3.next();
                if (lineGuideSpecification == null) continue;
                lineGuideSpecification.getParent().remove((Specification)lineGuideSpecification);
            }
            if (this.mPercentilesChk.isSelected()) {
                if (this.mBottomPercentTxt.getText().length() > 0) {
                    double d = Double.parseDouble(this.mBottomPercentTxt.getText());
                    double[] dArray = this.mMediator.getLineValuesAtPercent(d / 100.0);
                    objectArray2 = new double[dArray.length];
                    int n6 = 0;
                    int[] nArray = new int[dArray.length];
                    String[] stringArray = new String[dArray.length];
                    for (int i = 0; i < dArray.length; ++i) {
                        object = (Boolean)this.mLinesToSelectTable.getValueAt(i, 0);
                        if (object != Boolean.TRUE) continue;
                        stringArray[n6] = d + "%" + " = " + this.mMediator.displayFormatValue(dArray[i]);
                        objectArray2[n6] = (int)dArray[i];
                        nArray[n6] = i;
                        ++n6;
                    }
                    this.addReferences((double[])objectArray2, PERCENTILES_BOTTOM_LINE_ID, stringArray, nArray, n6);
                }
                if (this.mTopPercentTxt.getText().length() > 0) {
                    double d = Double.parseDouble(this.mTopPercentTxt.getText());
                    double[] dArray = this.mMediator.getLineValuesAtPercent(d / 100.0);
                    objectArray2 = new double[dArray.length];
                    int n7 = 0;
                    int[] nArray = new int[dArray.length];
                    String[] stringArray = new String[dArray.length];
                    for (int i = 0; i < dArray.length; ++i) {
                        object = (Boolean)this.mLinesToSelectTable.getValueAt(i, 0);
                        if (object != Boolean.TRUE) continue;
                        stringArray[n7] = d + "%" + " = " + this.mMediator.displayFormatValue(dArray[i]);
                        objectArray2[n7] = (int)dArray[i];
                        nArray[n7] = i;
                        ++n7;
                    }
                    this.addReferences((double[])objectArray2, PERCENTILES_TOP_LINE_ID, stringArray, nArray, n7);
                }
            }
        }
        object4 = this.mVisComp.getVisualization().getSpecification();
        ExtensionSpecification[] extensionSpecificationArray = object4.getExtensionSpecifications();
        if (this.mIsLowerSliderDirty || this.mIsUpperSliderDirty || this.mIsSigmaDirty || this.mIsPercentBottomDirty || this.mIsPercentTopDirty) {
            if (this.mNegativeInfinityChk.isEnabled() && this.mNegativeInfinityChk.isSelected()) {
                extensionSpecificationArray[0].put(LOWER_INFINITY_STATUS, "true");
                this.mMediator.setLowerLineInfinity(true);
            } else {
                extensionSpecificationArray[0].put(LOWER_INFINITY_STATUS, "false");
                this.mMediator.setLowerLineInfinity(false);
            }
            if (this.mPositiveInfinityChk.isEnabled() && this.mPositiveInfinityChk.isSelected()) {
                extensionSpecificationArray[0].put(UPPER_INFINITY_STATUS, "true");
                this.mMediator.setUpperLineInfinity(true);
            } else {
                extensionSpecificationArray[0].put(UPPER_INFINITY_STATUS, "false");
                this.mMediator.setUpperLineInfinity(false);
            }
            if (this.mSigmasChk.isSelected() && this.mSigmasTxt.getText().length() > 0) {
                extensionSpecificationArray[0].put(SIGMA_VALUE_ID, this.mSigmasTxt.getText());
            }
            if (this.mPercentilesChk.isSelected()) {
                if (this.mBottomPercentTxt.getText().length() > 0) {
                    extensionSpecificationArray[0].put(PERCENT_BOTTOM_VALUE_ID, this.mBottomPercentTxt.getText());
                }
                if (this.mTopPercentTxt.getText().length() > 0) {
                    extensionSpecificationArray[0].put(PERCENT_TOP_VALUE_ID, this.mTopPercentTxt.getText());
                }
            }
        }
        if (this.mIsCustomPositionDirty) {
            if (this.mCustomPosChk.isSelected()) {
                extensionSpecificationArray[0].put(CUSTOM_POSITIONS_STATUS, "true");
                for (int i = 0; i < this.mTableModel.getRowCount() - 1; ++i) {
                    String string2 = (String)this.mTableModel.getValueAt(i, 0);
                    double d = Double.parseDouble(string2);
                    LineGuideSpecification lineGuideSpecification = this.getLineGuideByName(CUSTOM_POSITION_ID + i);
                    if (lineGuideSpecification == null) {
                        this.addReference(d, CUSTOM_POSITION_ID + i, string2);
                        continue;
                    }
                    lineGuideSpecification.setX(new DataValue(string2));
                    this.mMediator.updateLineLabel(lineGuideSpecification, string2);
                }
            } else {
                extensionSpecificationArray[0].put(CUSTOM_POSITIONS_STATUS, "false");
                for (int i = 0; i < this.mTableModel.getRowCount() - 1; ++i) {
                    LineGuideSpecification lineGuideSpecification = this.getLineGuideByName(CUSTOM_POSITION_ID + i);
                    if (lineGuideSpecification == null) continue;
                    lineGuideSpecification.getParent().remove((Specification)lineGuideSpecification);
                }
            }
        }
        this.mMediator.updateVisLinesPos();
        this.mMediator.reloadDetailPanel();
        this.dispose();
    }

    private void addReference(double d, String string, String string2) {
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        GraphSpecification[] graphSpecificationArray = (GraphSpecification[])visualizationSpecification.findDescendantsOfType(GraphSpecification.class);
        LineGuideSpecification lineGuideSpecification = new LineGuideSpecification();
        lineGuideSpecification.setName(string);
        lineGuideSpecification.setX(new DataValue(d));
        StyleSpecification styleSpecification = new StyleSpecification();
        styleSpecification.setColor(Color.black);
        lineGuideSpecification.setStyle((LineStyle)styleSpecification);
        LabelSpecification labelSpecification = new LabelSpecification(string2);
        StyleSpecification styleSpecification2 = new StyleSpecification();
        styleSpecification2.setTextAngle(Double.valueOf(270.0));
        styleSpecification2.setTextAlignment(TextAlignmentType.LEFT);
        labelSpecification.setStyle((TextStyle)styleSpecification2);
        StyleSpecification styleSpecification3 = new StyleSpecification();
        styleSpecification3.setColor(Color.white);
        styleSpecification3.setSecondaryColor(Color.white);
        styleSpecification3.setPaddingLeft(new Length("1"));
        styleSpecification3.setPaddingRight(new Length("1"));
        labelSpecification.setTextFrameStyle((FrameStyle)styleSpecification3);
        lineGuideSpecification.addLabel(labelSpecification);
        graphSpecificationArray[0].addGuide((GuideSpecification)lineGuideSpecification);
    }

    private void addReferences(double[] dArray, String string, String[] stringArray, int[] nArray, int n) {
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        GraphSpecification[] graphSpecificationArray = (GraphSpecification[])visualizationSpecification.findDescendantsOfType(GraphSpecification.class);
        for (int i = 0; i < n; ++i) {
            LineGuideSpecification lineGuideSpecification = new LineGuideSpecification();
            lineGuideSpecification.setName(string + i);
            lineGuideSpecification.setX(new DataValue(dArray[i]));
            StyleSpecification styleSpecification = new StyleSpecification();
            styleSpecification.setColor(Color.black);
            lineGuideSpecification.setStyle((LineStyle)styleSpecification);
            graphSpecificationArray[0].addGuide((GuideSpecification)lineGuideSpecification);
            if (!this.mLblRefLinesChk.isSelected()) continue;
            LabelSpecification labelSpecification = new LabelSpecification(stringArray[i]);
            StyleSpecification styleSpecification2 = new StyleSpecification();
            styleSpecification2.setTextAngle(Double.valueOf(270.0));
            styleSpecification2.setTextAlignment(TextAlignmentType.LEFT);
            Map<Integer, Color> map = this.mMediator.getColorMap();
            Color color = map.get(nArray[i]);
            if (color == null) {
                color = Color.white;
            }
            styleSpecification2.setColor(this.getSupplementColor(color));
            labelSpecification.setStyle((TextStyle)styleSpecification2);
            StyleSpecification styleSpecification3 = new StyleSpecification();
            styleSpecification3.setColor(color);
            styleSpecification3.setSecondaryColor(Color.white);
            styleSpecification3.setPaddingLeft(new Length("1"));
            styleSpecification3.setPaddingRight(new Length("1"));
            labelSpecification.setTextFrameStyle((FrameStyle)styleSpecification3);
            lineGuideSpecification.addLabel(labelSpecification);
        }
    }

    private Color getSupplementColor(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    private LineGuideSpecification getLineGuideByName(String string) {
        LineGuideSpecification[] lineGuideSpecificationArray;
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        GraphSpecification[] graphSpecificationArray = (GraphSpecification[])visualizationSpecification.findDescendantsOfType(GraphSpecification.class);
        for (LineGuideSpecification lineGuideSpecification : lineGuideSpecificationArray = (LineGuideSpecification[])graphSpecificationArray[0].findDescendantsOfType(LineGuideSpecification.class)) {
            if (!string.equals(lineGuideSpecification.getName())) continue;
            return lineGuideSpecification;
        }
        return null;
    }

    private ArrayList<LineGuideSpecification> getLineGuidesStartsWithName(String string) {
        LineGuideSpecification[] lineGuideSpecificationArray;
        ArrayList<LineGuideSpecification> arrayList = new ArrayList<LineGuideSpecification>();
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        GraphSpecification[] graphSpecificationArray = (GraphSpecification[])visualizationSpecification.findDescendantsOfType(GraphSpecification.class);
        for (LineGuideSpecification lineGuideSpecification : lineGuideSpecificationArray = (LineGuideSpecification[])graphSpecificationArray[0].findDescendantsOfType(LineGuideSpecification.class)) {
            if (!lineGuideSpecification.getName().startsWith(string)) continue;
            arrayList.add(lineGuideSpecification);
        }
        return arrayList;
    }

    private void setDirty(Object object) {
        if (this.mLowerTxt == object || this.mNegativeInfinityChk == object) {
            this.mIsLowerSliderDirty = true;
        }
        if (this.mUpperTxt == object || this.mPositiveInfinityChk == object) {
            this.mIsUpperSliderDirty = true;
        }
        if (this.mMeanChk == object) {
            this.mIsMeanDirty = true;
        }
        if (this.mMedianChk == object) {
            this.mIsMedianDirty = true;
        }
        if (this.mSigmasChk == object || this.mSigmasTxt == object) {
            this.mIsSigmaDirty = true;
        }
        if (this.mPercentilesChk == object) {
            this.mIsPercentBottomDirty = true;
            this.mIsPercentTopDirty = true;
        }
        if (this.mBottomPercentTxt == object) {
            this.mIsPercentBottomDirty = true;
        }
        if (this.mTopPercentTxt == object) {
            this.mIsPercentTopDirty = true;
        }
        if (this.mCustomPosChk == object) {
            this.mIsCustomPositionDirty = true;
        }
    }

    private void setAllDirty() {
        this.mIsLowerSliderDirty = true;
        this.mIsUpperSliderDirty = true;
        this.mIsMeanDirty = true;
        this.mIsMedianDirty = true;
        this.mIsSigmaDirty = true;
        this.mIsPercentBottomDirty = true;
        this.mIsPercentTopDirty = true;
        this.mIsCustomPositionDirty = true;
    }

    class CustomCellRender
    extends DefaultTableCellRenderer {
        CustomCellRender() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = null;
            component = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            component.setEnabled(ChartOptionsDlg.this.mCustomPosChk.isSelected());
            return component;
        }
    }

    class CustomListModel
    extends AbstractTableModel {
        private Vector<String> mData = new Vector();

        CustomListModel() {
        }

        @Override
        public int getRowCount() {
            return this.mData.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.mData.get(n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            try {
                if (((String)object).length() > 0) {
                    this.mData.set(n, (String)object);
                } else {
                    this.mData.remove(n);
                    this.mData.add("");
                }
                if (this.mData.size() - 1 == n && ((String)object).length() > 0) {
                    this.mData.add("");
                }
                this.fireTableDataChanged();
            }
            catch (NumberFormatException numberFormatException) {
                String string = ResUtil.getString(ChartOptionsDlg.this.mResBundle, "IDS_NUMBER_WARNING");
                JOptionPane.showMessageDialog((Component)((Object)ChartOptionsDlg.this), string);
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return ChartOptionsDlg.this.mIsTableEditable;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public void addValue(String string) {
            this.mData.add(string);
        }
    }
}

