/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.interactive;

import com.spss.java_client.ui.dialogs.base.edit.res.EditResBundle;
import com.spss.java_client.ui.interactive.GraphboardFactory;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.vis.component.VisualizationComponent;
import com.spss.vis.exception.VisualizationException;
import com.spss.vis.graphboard.vismodel.NviznModelEvent;
import com.spss.vis.graphboard.vismodel.NviznModelEventListener;
import com.spss.vis.specification.ExtensionSpecification;
import com.spss.vis.specification.Specification;
import com.spss.vis.specification.VisualizationSpecification;
import com.spss.vis.specification.aesthetic.ColorAestheticSpecification;
import com.spss.vis.specification.data.VariableSpecification;
import com.spss.vis.specification.dimension.DimensionSpecification;
import com.spss.vis.specification.element.ElementSpecification;
import com.spss.vis.specification.label.DescriptionGroupSpecification;
import com.spss.vis.specification.label.TextSpecification;
import com.spss.vis.specification.legend.LegendSpecification;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CategoricalTargetInteractivePanel
extends JPanel
implements ItemListener,
NviznModelEventListener {
    private VisualizationComponent mVisComp;
    private JComboBox mCombo;
    private VariableSpecification mIterationVar;
    private VariableSpecification mAestheticVar;
    private final String ITERATION_ID = "iteration";
    private final String AESTHETIC_ID = "aesthetic";
    private final String CHART_TYPE_ID = "chartType";

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 1989, 2013.\n\n";
    }

    public CategoricalTargetInteractivePanel(VisualizationComponent visualizationComponent) {
        this.mVisComp = visualizationComponent;
        try {
            this.init();
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.updateInterval();
            this.updateDimension();
            this.mVisComp.refresh();
        }
    }

    private void init() throws VisualizationException {
        this.setBorder(BorderFactory.createEmptyBorder(10, 30, 0, 0));
        ResourceBundle resourceBundle = ResUtil.getBundle(EditResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        JLabel jLabel = new JLabel(ResUtil.getString(resourceBundle, "IDS_CLUSTER_ON"));
        this.mCombo = new JComboBox<String>(this.getClusterOnItems(resourceBundle));
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        ExtensionSpecification[] extensionSpecificationArray = visualizationSpecification.getExtensionSpecifications();
        if (extensionSpecificationArray != null && extensionSpecificationArray.length > 0) {
            String string = extensionSpecificationArray[0].get("iteration");
            String string2 = extensionSpecificationArray[0].get("aesthetic");
            if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
                this.mIterationVar = (VariableSpecification)visualizationSpecification.getSpecification(string);
                this.mAestheticVar = (VariableSpecification)visualizationSpecification.getSpecification(string2);
                ElementSpecification[] elementSpecificationArray = (ElementSpecification[])visualizationSpecification.findDescendantsOfType(ElementSpecification.class);
                if (elementSpecificationArray != null && elementSpecificationArray.length > 0) {
                    VariableSpecification variableSpecification = elementSpecificationArray[0].getX();
                    if (variableSpecification == this.mIterationVar) {
                        this.mCombo.setSelectedIndex(0);
                    } else {
                        this.mCombo.setSelectedIndex(1);
                    }
                }
            }
        }
        this.add(jLabel);
        this.add(this.mCombo);
        GraphboardFactory.createGraphboard().getModel().addListener((NviznModelEventListener)this);
        this.mCombo.addItemListener(this);
    }

    private void updateInterval() {
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        ElementSpecification[] elementSpecificationArray = (ElementSpecification[])visualizationSpecification.findDescendantsOfType(ElementSpecification.class);
        if (elementSpecificationArray != null && elementSpecificationArray.length > 0) {
            int n = this.mCombo.getSelectedIndex();
            if (n == 0) {
                DescriptionGroupSpecification[] descriptionGroupSpecificationArray;
                LegendSpecification[] legendSpecificationArray;
                elementSpecificationArray[0].setX(this.mIterationVar);
                ColorAestheticSpecification[] colorAestheticSpecificationArray = (ColorAestheticSpecification[])elementSpecificationArray[0].findDescendantsOfType(ColorAestheticSpecification.class);
                if (colorAestheticSpecificationArray != null && colorAestheticSpecificationArray.length > 0) {
                    colorAestheticSpecificationArray[0].setVariable(this.mIterationVar);
                    if (colorAestheticSpecificationArray[0].getDomain() != null && colorAestheticSpecificationArray[0].getDomain().getVariableReferences() != null && colorAestheticSpecificationArray[0].getDomain().getVariableReferences().length > 0) {
                        colorAestheticSpecificationArray[0].getDomain().getVariableReferences()[0].setReference(this.mIterationVar);
                    }
                }
                if ((legendSpecificationArray = (LegendSpecification[])visualizationSpecification.findDescendantsOfType(LegendSpecification.class)).length > 0 && (descriptionGroupSpecificationArray = (DescriptionGroupSpecification[])legendSpecificationArray[0].findDescendantsOfType(DescriptionGroupSpecification.class)).length > 0) {
                    descriptionGroupSpecificationArray[0].setTarget((Specification)this.mIterationVar);
                }
            } else {
                DescriptionGroupSpecification[] descriptionGroupSpecificationArray;
                LegendSpecification[] legendSpecificationArray;
                elementSpecificationArray[0].setX(this.mAestheticVar);
                ColorAestheticSpecification[] colorAestheticSpecificationArray = (ColorAestheticSpecification[])elementSpecificationArray[0].findDescendantsOfType(ColorAestheticSpecification.class);
                if (colorAestheticSpecificationArray != null && colorAestheticSpecificationArray.length > 0) {
                    colorAestheticSpecificationArray[0].setVariable(this.mAestheticVar);
                    if (colorAestheticSpecificationArray[0].getDomain() != null && colorAestheticSpecificationArray[0].getDomain().getVariableReferences() != null && colorAestheticSpecificationArray[0].getDomain().getVariableReferences().length > 0) {
                        colorAestheticSpecificationArray[0].getDomain().getVariableReferences()[0].setReference(this.mAestheticVar);
                    }
                }
                if ((legendSpecificationArray = (LegendSpecification[])visualizationSpecification.findDescendantsOfType(LegendSpecification.class)).length > 0 && (descriptionGroupSpecificationArray = (DescriptionGroupSpecification[])legendSpecificationArray[0].findDescendantsOfType(DescriptionGroupSpecification.class)).length > 0) {
                    descriptionGroupSpecificationArray[0].setTarget((Specification)this.mAestheticVar);
                }
            }
        }
    }

    private void updateDimension() {
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        DimensionSpecification[] dimensionSpecificationArray = (DimensionSpecification[])visualizationSpecification.findDescendantsOfType(DimensionSpecification.class);
        if (dimensionSpecificationArray.length > 0) {
            int n = this.mCombo.getSelectedIndex();
            if (n == 0) {
                TextSpecification[] textSpecificationArray;
                LegendSpecification[] legendSpecificationArray;
                dimensionSpecificationArray[0].setClusterVariable(this.mAestheticVar);
                DescriptionGroupSpecification[] descriptionGroupSpecificationArray = (DescriptionGroupSpecification[])dimensionSpecificationArray[0].findDescendantsOfType(DescriptionGroupSpecification.class);
                if (descriptionGroupSpecificationArray.length > 0) {
                    descriptionGroupSpecificationArray[0].setTarget((Specification)this.mAestheticVar);
                }
                String string = null;
                String string2 = null;
                TextSpecification[] textSpecificationArray2 = (TextSpecification[])dimensionSpecificationArray[0].findDescendantsOfType(TextSpecification.class);
                if (textSpecificationArray2.length > 0) {
                    string2 = textSpecificationArray2[0].getText();
                }
                if ((legendSpecificationArray = (LegendSpecification[])visualizationSpecification.findDescendantsOfType(LegendSpecification.class)).length > 0 && (textSpecificationArray = (TextSpecification[])legendSpecificationArray[0].findDescendantsOfType(TextSpecification.class)).length > 0) {
                    string = textSpecificationArray[0].getText();
                    if (string2 != null && string != null) {
                        textSpecificationArray[0].setText(string2);
                        textSpecificationArray2[0].setText(string);
                    }
                }
            } else {
                TextSpecification[] textSpecificationArray;
                LegendSpecification[] legendSpecificationArray;
                dimensionSpecificationArray[0].setClusterVariable(this.mIterationVar);
                DescriptionGroupSpecification[] descriptionGroupSpecificationArray = (DescriptionGroupSpecification[])dimensionSpecificationArray[0].findDescendantsOfType(DescriptionGroupSpecification.class);
                if (descriptionGroupSpecificationArray.length > 0) {
                    descriptionGroupSpecificationArray[0].setTarget((Specification)this.mIterationVar);
                }
                String string = null;
                String string3 = null;
                TextSpecification[] textSpecificationArray3 = (TextSpecification[])dimensionSpecificationArray[0].findDescendantsOfType(TextSpecification.class);
                if (textSpecificationArray3.length > 0) {
                    string3 = textSpecificationArray3[0].getText();
                }
                if ((legendSpecificationArray = (LegendSpecification[])visualizationSpecification.findDescendantsOfType(LegendSpecification.class)).length > 0 && (textSpecificationArray = (TextSpecification[])legendSpecificationArray[0].findDescendantsOfType(TextSpecification.class)).length > 0) {
                    string = textSpecificationArray[0].getText();
                    if (string3 != null && string != null) {
                        textSpecificationArray[0].setText(string3);
                        textSpecificationArray3[0].setText(string);
                    }
                }
            }
        }
    }

    public void modelChanged(NviznModelEvent nviznModelEvent) {
        if (GraphboardFactory.createGraphboard().isEditEnabled()) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
        }
    }

    private String[] getClusterOnItems(ResourceBundle resourceBundle) {
        VisualizationSpecification visualizationSpecification = this.mVisComp.getVisualization().getSpecification();
        ExtensionSpecification[] extensionSpecificationArray = visualizationSpecification.getExtensionSpecifications();
        if (extensionSpecificationArray.length > 0) {
            String string = extensionSpecificationArray[0].get("chartType");
            if ("1".equals(string)) {
                return new String[]{ResUtil.getString(resourceBundle, "IDS_CLUSTER_ITERATION"), ResUtil.getString(resourceBundle, "IDS_CLUSTER_CLUSTER_NUMBER")};
            }
            if ("2".equals(string)) {
                return new String[]{ResUtil.getString(resourceBundle, "IDS_CLUSTER_ITERATION"), ResUtil.getString(resourceBundle, "IDS_CLUSTER_CATEGORY")};
            }
            if ("3".equals(string)) {
                return new String[]{ResUtil.getString(resourceBundle, "IDS_CLUSTER_ITERATION"), ResUtil.getString(resourceBundle, "IDS_CLUSTER_TARGET")};
            }
        }
        return new String[]{ResUtil.getString(resourceBundle, "IDS_CLUSTER_ITERATION"), ResUtil.getString(resourceBundle, "IDS_CLUSTER_CATEGORY")};
    }
}

