/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.syntax.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class SyntaxUndoableEdit
extends AbstractUndoableEdit {
    private UndoableEdit mTotalEdit;
    private SyntaxUndoableEdit mCurrentEdit;
    private boolean mNeedToAdd = true;

    SyntaxUndoableEdit(UndoableEdit undoableEdit, boolean bl) {
        this.mTotalEdit = undoableEdit;
        this.mNeedToAdd = bl;
    }

    @Override
    public boolean addEdit(UndoableEdit undoableEdit) {
        if (undoableEdit instanceof SyntaxUndoableEdit) {
            return this.addMoreEdit((SyntaxUndoableEdit)undoableEdit);
        }
        return false;
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.mCurrentEdit != null) {
            this.mCurrentEdit.undo();
        }
        this.mTotalEdit.undo();
    }

    @Override
    public void redo() throws CannotRedoException {
        this.mTotalEdit.redo();
        if (this.mCurrentEdit != null) {
            this.mCurrentEdit.redo();
        }
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    private boolean addMoreEdit(SyntaxUndoableEdit syntaxUndoableEdit) {
        if (!syntaxUndoableEdit.mNeedToAdd) {
            return false;
        }
        if (this.mCurrentEdit == null) {
            this.mCurrentEdit = syntaxUndoableEdit;
            return true;
        }
        return this.mCurrentEdit.addEdit(syntaxUndoableEdit);
    }
}

