/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.syntax.undo;

import com.spss.java_client.ui.dialogs.base.edit.find.SyntaxSearchOptions;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.syntax.undo.DefaultEdit;
import com.spss.java_client.ui.undo.SpssUndoManager;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class SyntaxUndoManager
extends SpssUndoManager
implements UndoableEditListener {
    private UndoableEditSupport undoSupport = new UndoableEditSupport();
    public CompoundEdit mCompoundEdit;
    private JTextPane mTextPane;
    private int mLastOffset;
    private boolean mInCompundEdit = false;
    private boolean mIgnoreUndoableEdits = false;

    public SyntaxUndoManager(SpssFrame spssFrame) {
        super(spssFrame);
    }

    @Override
    public synchronized void discardAllEdits() {
        super.discardAllEdits();
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        if (!this.mIgnoreUndoableEdits) {
            if (this.mCompoundEdit == null) {
                this.mCompoundEdit = this.startCompoundEdit(undoableEditEvent.getEdit());
                return;
            }
            if (this.mInCompundEdit) {
                this.mCompoundEdit.addEdit(undoableEditEvent.getEdit());
            } else {
                AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = (AbstractDocument.DefaultDocumentEvent)undoableEditEvent.getEdit();
                int n = this.mTextPane.getCaretPosition() - this.mLastOffset;
                if (Math.abs(n) == 1 || defaultDocumentEvent.getType().equals(DocumentEvent.EventType.CHANGE)) {
                    this.mCompoundEdit.addEdit(undoableEditEvent.getEdit());
                    this.mLastOffset += n;
                    return;
                }
                this.mCompoundEdit.end();
                this.mCompoundEdit = this.startCompoundEdit(undoableEditEvent.getEdit());
            }
        }
    }

    public void completeEdit() {
        if (this.mCompoundEdit != null) {
            this.mCompoundEdit.end();
            this.mCompoundEdit = null;
        }
        this.mInCompundEdit = false;
    }

    private CompoundEdit startCompoundEdit(UndoableEdit undoableEdit) {
        this.mLastOffset = this.mTextPane.getCaretPosition();
        this.mCompoundEdit = new MyCompoundEdit();
        this.mCompoundEdit.addEdit(undoableEdit);
        this.addEdit(this.mCompoundEdit);
        return this.mCompoundEdit;
    }

    public void setEditor(JTextPane jTextPane) {
        this.mTextPane = jTextPane;
    }

    public void startCompoundEdit() {
        this.mInCompundEdit = true;
    }

    public boolean isIgnoreUndoableEdits() {
        return this.mIgnoreUndoableEdits;
    }

    public void setIgnoreUndoableEdits(boolean bl) {
        this.mIgnoreUndoableEdits = bl;
    }

    private static SyntaxSearchOptions createClone(SyntaxSearchOptions syntaxSearchOptions) {
        SyntaxSearchOptions syntaxSearchOptions2 = null;
        try {
            syntaxSearchOptions2 = (SyntaxSearchOptions)syntaxSearchOptions.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return syntaxSearchOptions2;
    }

    public synchronized boolean addOurEdit(UndoableEdit undoableEdit) {
        boolean bl;
        block6: {
            bl = false;
            try {
                if (undoableEdit == null) break block6;
                if (undoableEdit instanceof DefaultEdit) {
                    try {
                        ((DefaultEdit)undoableEdit).apply();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        throw exception;
                    }
                }
                if (undoableEdit.canRedo() || undoableEdit.canUndo()) {
                    bl = super.addEdit(undoableEdit);
                    this.undoSupport.postEdit(undoableEdit);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    class MyCompoundEdit
    extends CompoundEdit {
        MyCompoundEdit() {
        }

        @Override
        public boolean isInProgress() {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            if (SyntaxUndoManager.this.mCompoundEdit != null) {
                SyntaxUndoManager.this.mCompoundEdit.end();
            }
            super.undo();
            SyntaxUndoManager.this.mCompoundEdit = null;
        }
    }
}

