/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.syntax.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public abstract class DefaultEdit
extends AbstractUndoableEdit {
    private String name = "";
    private String undoName = "Undo ";
    private String redoName = "Redo";
    private boolean applied = false;
    private boolean deleteOnSelectionChange = false;

    public DefaultEdit(String string, boolean bl, boolean bl2) {
        this.name = string;
        if (bl) {
            this.undoName = "Undo ";
        }
        if (bl2) {
            this.redoName = "Redo";
        }
    }

    public boolean isDeleteOnSelectionChange() {
        return this.deleteOnSelectionChange;
    }

    public void setDeleteOnSelectionChange(boolean bl) {
        this.deleteOnSelectionChange = bl;
    }

    public abstract void undoEdit();

    protected void setApplied(boolean bl) {
        this.applied = bl;
    }

    public boolean canApply() {
        return !this.applied;
    }

    public abstract void applyEdit() throws Exception;

    public void apply() throws Exception {
        if (this.canApply()) {
            this.applyEdit();
            this.setApplied(true);
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.undoEdit();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        try {
            this.applyEdit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void die() {
        this.applied = true;
        super.die();
    }

    @Override
    public String getPresentationName() {
        return this.name;
    }

    @Override
    public String getUndoPresentationName() {
        return this.undoName;
    }

    @Override
    public String getRedoPresentationName() {
        return this.redoName;
    }
}

