/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.syntax;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.FileDrop;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.AppMgr;
import com.spss.java_client.core.documents.ICoreDocument;
import com.spss.java_client.core.documents.syntax.ISyntaxDocListener;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.core.server.messages.spsswmsg.SpsswMsgSyntaxError;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.dialogs.base.RenameDlg;
import com.spss.java_client.ui.dialogs.base.SyntaxKeyboardShortcutsDlg;
import com.spss.java_client.ui.dialogs.base.edit.find.ISearchProxy;
import com.spss.java_client.ui.dialogs.base.edit.find.SearchOptions;
import com.spss.java_client.ui.dialogs.base.edit.find.SyntaxFindDlg;
import com.spss.java_client.ui.dialogs.base.edit.find.SyntaxSearchOptions;
import com.spss.java_client.ui.dialogs.base.view.res.ViewResBundle;
import com.spss.java_client.ui.dialogs.common.SPSSFontChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.SpssView;
import com.spss.java_client.ui.doc_types.actions.ReplaceAction;
import com.spss.java_client.ui.doc_types.actions.SyntaxHelpAction;
import com.spss.java_client.ui.doc_types.actions.syntax.RunAction;
import com.spss.java_client.ui.doc_types.syntax.SyntaxBuffer;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import com.spss.java_client.ui.doc_types.syntax.SyntaxPrefManager;
import com.spss.java_client.ui.doc_types.syntax.undo.SyntaxUndoManager;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.utils.FontUtil;
import com.spss.shared.syntaxeditor.SpssSyntaxTextPane;
import com.spss.shared.syntaxeditor.SyntaxCommand;
import com.spss.shared.syntaxeditor.SyntaxHighlightDocument;
import com.spss.shared.syntaxeditor.SyntaxMasterPanel;
import com.spss.shared.syntaxeditor.shared_objects.BookmarkInfo;
import com.spss.shared.syntaxeditor.shared_objects.ErrorInfo;
import com.spss.shared.syntaxeditor.shared_objects.RunInfo;
import com.spss.shared.syntaxeditor.shared_objects.SyntaxEditorEnums;
import com.spss.shared.syntaxeditor.shared_objects.SyntaxEditorState;
import com.spss.uitools.clipboard.AppClipboard;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.EncodingValidator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class SyntaxView
extends SpssView
implements ISyntaxDocListener,
CaretListener,
FocusListener,
ISearchProxy,
SyntaxMasterPanel.SyntaxCallback {
    private KeyAdapter mKeyAdapter = null;
    private ActionListener mActionListener = null;
    private MousePopupListener mMousePopupListener = null;
    private SyntaxMasterPanel mSyntaxMasterPanel;
    private SyntaxFrame mParentFrame = null;
    private JPopupMenu mPopupMenu;
    private JMenuItem mCutItem;
    private JMenuItem mCopyItem;
    private JMenuItem mPasteItem;
    private JMenuItem mDeleteItem;
    private JMenuItem mSelectCommandItem;
    private JMenuItem mRunAllItem;
    private JMenuItem mRunSelectionItem;
    private JMenuItem mRunToEndItem;
    private JMenuItem mRunContinueItem;
    private JMenuItem mBookmarkItem;
    private JMenuItem mRenameBookmarkItem;
    private JMenuItem mBreakpointItem;
    private JMenuItem mHelpItem;
    private SyntaxBuffer mSyntaxBuffer = new SyntaxBuffer();
    private EncodingValidator mEncodingValidator;
    private long mSyntaxWindowID = -1L;
    private PreDocChangeNotification mPreDocChangeNotification = new PreDocChangeNotification();

    public SyntaxView(SyntaxFrame syntaxFrame, long l) {
        this.mParentFrame = syntaxFrame;
        this.mSyntaxWindowID = l;
        this.createSyntaxView();
        InputMap inputMap = this.getActiveSyntaxTextPane().getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(155, 2), "copy-to-clipboard");
        inputMap.put(KeyStroke.getKeyStroke(155, 1), "paste-from-clipboard");
        inputMap.put(KeyStroke.getKeyStroke(127, 1), "cut-to-clipboard");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SyntaxView.this.loadFontFromPrefs();
                SyntaxView.this.getActiveSyntaxTextPane().requestFocus();
            }
        });
    }

    public void pasteSyntax(String string, boolean bl) {
        this.pasteSyntax(string, bl, true);
    }

    public void pasteSyntax(String string, boolean bl, boolean bl2) {
        String string2;
        String string3 = string2 = bl2 ? SyntaxMgr.getSyntaxMgr().wrapSyntaxForPaste(string) : string;
        if (bl) {
            this.mSyntaxMasterPanel.pasteAtCursor(string2);
        } else {
            try {
                this.mSyntaxMasterPanel.append(string2);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    public String toString(SyntaxFrame.SyntaxSegment syntaxSegment) {
        return this.getTextForSegment(syntaxSegment);
    }

    public long getSytaxWindowID() {
        return this.mSyntaxWindowID;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (keyEvent.isControlDown() || keyEvent.isMetaDown()) {
            ActionCatalog.getActionCatalog().enableActions(this.mParentFrame, ActionCatalog.getActionCatalog().getMneumonicActions());
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public String processRunSyntax(SyntaxFrame.SyntaxSegment syntaxSegment) {
        SyntaxEditorEnums.SyntaxSegment syntaxSegment2 = this.convertToSyntaxEditorEnum(syntaxSegment);
        RunInfo runInfo = this.mSyntaxMasterPanel.processRunSyntax(syntaxSegment2);
        StringBuilder stringBuilder = new StringBuilder();
        if (runInfo.getStartLineNum() > -1 && runInfo.getEndLineNum() >= runInfo.getStartLineNum()) {
            stringBuilder.append("_SLINE ").append(runInfo.getStartLineNum());
            stringBuilder.append(" ").append(this.mSyntaxWindowID).append(".\n");
            String string = runInfo.getText().trim();
            stringBuilder.append(string);
            if (string.charAt(string.length() - 1) != '.') {
                stringBuilder.append('.');
            }
            stringBuilder.append("\n_SLINE OFF.");
            this.mParentFrame.updateToolbarEnableStatus();
        }
        return stringBuilder.toString();
    }

    public String processRunSyntaxToGetExtensionHelp(SyntaxFrame.SyntaxSegment syntaxSegment) {
        SyntaxEditorEnums.SyntaxSegment syntaxSegment2 = this.convertToSyntaxEditorEnum(syntaxSegment);
        RunInfo runInfo = this.mSyntaxMasterPanel.processRunSyntax(syntaxSegment2);
        if (!runInfo.getText().contains("/help") && !runInfo.getText().contains("/HELP")) {
            runInfo.appendHelpCommandToText();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (runInfo.getStartLineNum() > -1 && runInfo.getEndLineNum() >= runInfo.getStartLineNum()) {
            stringBuilder.append("_SLINE ").append(runInfo.getStartLineNum());
            stringBuilder.append(" ").append(this.mSyntaxWindowID).append(".\n");
            String string = runInfo.getText().trim();
            stringBuilder.append(string);
            if (string.charAt(string.length() - 1) != '.') {
                stringBuilder.append('.');
            }
            stringBuilder.append("\n_SLINE OFF.");
            this.mParentFrame.updateToolbarEnableStatus();
        }
        return stringBuilder.toString();
    }

    public String getTextForSegment(SyntaxFrame.SyntaxSegment syntaxSegment) {
        SyntaxEditorEnums.SyntaxSegment syntaxSegment2 = this.convertToSyntaxEditorEnum(syntaxSegment);
        return this.mSyntaxMasterPanel.getTextForSegment(syntaxSegment2);
    }

    public String getCommandNameForSyntaxSegment(SyntaxFrame.SyntaxSegment syntaxSegment) {
        SyntaxEditorEnums.SyntaxSegment syntaxSegment2 = this.convertToSyntaxEditorEnum(syntaxSegment);
        return this.mSyntaxMasterPanel.getCommandNameForSyntaxSegment(syntaxSegment2);
    }

    public String getCommandHelpFileNameForSyntaxSegment(SyntaxFrame.SyntaxSegment syntaxSegment) {
        SyntaxEditorEnums.SyntaxSegment syntaxSegment2 = this.convertToSyntaxEditorEnum(syntaxSegment);
        return this.mSyntaxMasterPanel.getCommandHelpFileNameForSyntaxSegment(syntaxSegment2);
    }

    public SyntaxEditorEnums.SyntaxSegment convertToSyntaxEditorEnum(SyntaxFrame.SyntaxSegment syntaxSegment) {
        SyntaxEditorEnums.SyntaxSegment syntaxSegment2 = SyntaxEditorEnums.SyntaxSegment.CURRENT;
        switch (syntaxSegment) {
            case ALL: {
                syntaxSegment2 = SyntaxEditorEnums.SyntaxSegment.ALL;
                break;
            }
            case SELECTION: {
                syntaxSegment2 = SyntaxEditorEnums.SyntaxSegment.SELECTION;
                break;
            }
            case CURRENT: {
                syntaxSegment2 = SyntaxEditorEnums.SyntaxSegment.SELECTION;
                break;
            }
            case TO_END: {
                syntaxSegment2 = SyntaxEditorEnums.SyntaxSegment.TO_END;
                break;
            }
            case STEP_FIRST_COMMAND: {
                syntaxSegment2 = SyntaxEditorEnums.SyntaxSegment.STEP_FIRST_COMMAND;
                break;
            }
            case STEP_FIRST_COMMAND_IN_SELECTION: {
                syntaxSegment2 = SyntaxEditorEnums.SyntaxSegment.STEP_FIRST_COMMAND_IN_SELECTION;
                break;
            }
            case CONTINUE: {
                syntaxSegment2 = SyntaxEditorEnums.SyntaxSegment.CONTINUE;
            }
        }
        return syntaxSegment2;
    }

    @Override
    public String toString() {
        return this.toString(SyntaxFrame.SyntaxSegment.ALL);
    }

    public static boolean isValidCoderResult(CoderResult coderResult) {
        return coderResult == CoderResult.UNDERFLOW;
    }

    public CoderResult validateCharacterEncoding(String string, boolean bl) {
        if (ComponentState.isUnicodeServer()) {
            return CoderResult.UNDERFLOW;
        }
        if (string == null || string.length() == 0) {
            return CoderResult.UNDERFLOW;
        }
        boolean bl2 = this.mEncodingValidator.validateString(string);
        if (!bl2 && !bl) {
            boolean bl3 = this.mEncodingValidator.getResult().equals(CoderResult.OVERFLOW);
            String string2 = bl3 ? "ERR_STRING_OVERFLOW_MSG" : "ERR_STRING_UNMAPPABLE_MSG";
            String string3 = UIToolResUtil.getString((String)string2);
            JOptionPane.showMessageDialog(this.getParent(), string3);
            this.getActiveSyntaxTextPane().selectAll();
            this.getActiveSyntaxTextPane().requestFocusInWindow();
        }
        return this.mEncodingValidator.getResult();
    }

    public void changeFont() {
        int n;
        int n2;
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("doc_types/syntax");
        String string = preferences2.get("font_family", PrefDefaults.DEF_SYNTAX_FONT_FAMILY);
        SPSSFontChooser sPSSFontChooser = new SPSSFontChooser(this.mParentFrame, true, string, n2 = preferences2.getInt("font_style", 0), n = preferences2.getInt("font_size", PrefDefaults.DEF_SYNTAX_FONT_SIZE));
        if (sPSSFontChooser.getReturnValue() == 0) {
            Font font = sPSSFontChooser.getSelectedFont();
            this.mSyntaxMasterPanel.setEditorFont(font);
            int n3 = (int)FontUtil.physicalToLogicalSize((float)font.getSize2D());
            preferences2.put("font_family", font.getFamily(ResUtil.getLocale()));
            preferences2.putInt("font_style", font.getStyle());
            preferences2.putInt("font_size", n3);
        }
    }

    private void loadFontFromPrefs() {
        if (CommandLine.isProduction()) {
            return;
        }
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("doc_types/syntax");
        String string = preferences2.get("font_family", PrefDefaults.DEF_SYNTAX_FONT_FAMILY);
        int n = preferences2.getInt("font_style", 0);
        int n2 = preferences2.getInt("font_size", PrefDefaults.DEF_SYNTAX_FONT_SIZE);
        Font font = FontUtil.makeFont((String)string, (int)n, (float)n2);
        this.mSyntaxMasterPanel.setEditorFont(font, false);
    }

    public String getSelectedText() {
        int n;
        int n2;
        String string = null;
        if (this.getActiveSyntaxTextPane().getSelectedText() != null) {
            n2 = this.getActiveSyntaxTextPane().getSelectionStart();
            n = this.getActiveSyntaxTextPane().getSelectionEnd();
        } else {
            n2 = n = this.mSyntaxMasterPanel.getCaretPosition();
        }
        try {
            string = this.getActiveSyntaxTextPane().getText(n2, n - n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return string;
    }

    public void setSelectAll() {
        this.getActiveSyntaxTextPane().selectAll();
    }

    public int findSubstringIgnoreCase(String string, String string2, int n) {
        int n2 = string2.length();
        for (int i = n; i <= string.length() - n2; ++i) {
            if (!string.regionMatches(true, i, string2, 0, n2)) continue;
            return i;
        }
        return -1;
    }

    public boolean selectionEquals(String string, boolean bl) {
        return this.selectionEquals(this.getActiveSyntaxTextPane(), string, bl);
    }

    public boolean selectionEquals(JTextComponent jTextComponent, String string, boolean bl) {
        String string2 = jTextComponent.getSelectedText();
        boolean bl2 = bl ? string2 != null && string2.equals(string) : string2 != null && string2.equalsIgnoreCase(string);
        return bl2;
    }

    public void replace(String string, String string2, boolean bl) {
        if (this.selectionEquals(string, bl)) {
            try {
                this.mSyntaxMasterPanel.replace(string2, this.getActiveSyntaxTextPane().getSelectionStart(), this.getActiveSyntaxTextPane().getSelectionEnd() - this.getActiveSyntaxTextPane().getSelectionStart());
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    public void notifyOpenDocument(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.processOpenDocument(string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SyntaxView.this.processOpenDocument(string);
                }
            });
        }
    }

    private void processOpenDocument(String string) {
        this.mSyntaxMasterPanel.setIsInProcessOpenDoc(true);
        this.setCoreDocIntoSyntaxPane(this.getSyntaxCoreDocument());
        this.loadFontFromPrefs();
        this.mSyntaxMasterPanel.processOpenDocument(string);
        this.getActiveSyntaxTextPane().setCaretPosition(0);
        this.getActiveSyntaxTextPane().scrollRectToVisible(new Rectangle(0, 0, 10, 10));
        this.mParentFrame.getUndoManager().discardAllEdits();
        this.mParentFrame.setModified(false);
        this.mParentFrame.updateToolbarEnableStatus();
        this.mSyntaxMasterPanel.setIsInProcessOpenDoc(false);
    }

    private void setCoreDocIntoSyntaxPane(SyntaxHighlightDocument syntaxHighlightDocument) {
        this.mSyntaxMasterPanel.setIsInProcessOpenDoc(true);
        this.mSyntaxMasterPanel.setDocument(syntaxHighlightDocument);
        this.updateSyntaxHighlightDocumentCallbacks();
        this.mSyntaxMasterPanel.setSyntaxCommands(SyntaxMgr.getStaticSyntaxCommands());
        SyntaxEditorState syntaxEditorState = SyntaxPrefManager.getSyntaxEditorPreferences();
        if (CommandLine.isProduction()) {
            syntaxEditorState.setAutoCompleteActive(false);
            syntaxEditorState.setAutoDisplayErrorPane(false);
            syntaxEditorState.setDisplayCommandSpans(false);
            syntaxEditorState.setDisplayHighlighting(false);
            syntaxEditorState.setDisplayLineNums(false);
            syntaxEditorState.setDisplayNavigationPane(false);
            syntaxEditorState.setDisplayValidationColoring(false);
        }
        this.mSyntaxMasterPanel.setState(syntaxEditorState);
        this.mSyntaxMasterPanel.setIsInProcessOpenDoc(false);
    }

    public void notifySaveDocument() {
        this.mParentFrame.updateTitleBar();
        this.mParentFrame.updateToolbarEnableStatus();
    }

    public void notifyCloseDocument() {
        if (this.mParentFrame.getDocument() != null) {
            this.mParentFrame.dispose();
        }
    }

    @Override
    public void performClose() {
        SyntaxHighlightDocument syntaxHighlightDocument = this.getSyntaxCoreDocument();
        if (syntaxHighlightDocument != null) {
            syntaxHighlightDocument.removeUndoableEditListener((UndoableEditListener)this.mParentFrame.getUndoManager());
        }
        if (this.mSyntaxMasterPanel != null) {
            this.removeSyntaxTextPanelListeners(this.mSyntaxMasterPanel.getMainSpssSyntaxTextPane());
            this.removeSyntaxTextPanelListeners(this.mSyntaxMasterPanel.getSplitSpssSyntaxTextPane());
            this.getActiveSyntaxTextPane().removeAll();
            this.mSyntaxMasterPanel = null;
        }
        this.mMousePopupListener = null;
        this.mKeyAdapter = null;
        if (this.mCutItem != null) {
            this.mCutItem.removeActionListener(this.mActionListener);
            this.mCopyItem.removeActionListener(this.mActionListener);
            this.mPasteItem.removeActionListener(this.mActionListener);
            this.mSelectCommandItem.removeActionListener(this.mActionListener);
            this.mDeleteItem.removeActionListener(this.mActionListener);
            this.mRunAllItem.removeActionListener(this.mActionListener);
            this.mRunSelectionItem.removeActionListener(this.mActionListener);
            this.mRunToEndItem.removeActionListener(this.mActionListener);
            this.mRunContinueItem.removeActionListener(this.mActionListener);
            this.mBreakpointItem.removeActionListener(this.mActionListener);
            this.mBookmarkItem.removeActionListener(this.mActionListener);
            this.mRenameBookmarkItem.removeActionListener(this.mActionListener);
            this.mHelpItem.removeActionListener(this.mActionListener);
        }
        this.mActionListener = null;
        if (this.mPopupMenu != null) {
            this.mPopupMenu.setBorder(null);
            this.mPopupMenu.removeAll();
            this.mPopupMenu = null;
        }
        this.removeAll();
        this.mParentFrame = null;
        super.performClose();
    }

    private void addSyntaxTextPanelListeners(SpssSyntaxTextPane spssSyntaxTextPane) {
        spssSyntaxTextPane.addMouseListener((MouseListener)this.mMousePopupListener);
        spssSyntaxTextPane.setEditable(true);
        spssSyntaxTextPane.setDragEnabled(true);
        spssSyntaxTextPane.addCaretListener((CaretListener)this);
        spssSyntaxTextPane.addFocusListener((FocusListener)this);
        spssSyntaxTextPane.addKeyListener((KeyListener)this.mKeyAdapter);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(72, 2, false);
        ReplaceAction replaceAction = new ReplaceAction("edit_replace");
        this.getActiveSyntaxTextPane().registerKeyboardAction(replaceAction, "Replace", keyStroke, 0);
    }

    private void removeSyntaxTextPanelListeners(SpssSyntaxTextPane spssSyntaxTextPane) {
        if (spssSyntaxTextPane != null) {
            spssSyntaxTextPane.removeCaretListener((CaretListener)this);
            spssSyntaxTextPane.removeFocusListener((FocusListener)this);
            spssSyntaxTextPane.removeKeyListener((KeyListener)this.mKeyAdapter);
            spssSyntaxTextPane.removeMouseListener((MouseListener)this.mMousePopupListener);
        }
    }

    public void pasteSyntax(String string) {
        this.pasteSyntax(string, false);
        this.mParentFrame.updateTitleBar();
    }

    public void pasteSyntaxAction(String string) {
        this.mSyntaxMasterPanel.doPaste(string);
    }

    public void syncContent() {
        this.mParentFrame.updateTitleBar();
    }

    public void setSyntax(String string) {
        this.mSyntaxMasterPanel.setContent(string);
    }

    public void addSyntaxError(SpsswMsgSyntaxError spsswMsgSyntaxError) {
        if (spsswMsgSyntaxError.getCommand() == null || spsswMsgSyntaxError.getErrorInfo() == null) {
            return;
        }
        ErrorInfo errorInfo = new ErrorInfo(String.valueOf(spsswMsgSyntaxError.getSyntaxLine() + 1), spsswMsgSyntaxError.getCommand(), spsswMsgSyntaxError.getErrorInfo());
        this.mSyntaxMasterPanel.addSyntaxError(errorInfo);
    }

    public void addRemoveSyntaxCommands(ArrayList<SyntaxCommand> arrayList, boolean bl) {
        this.mSyntaxMasterPanel.addRemoveSyntaxCommands(arrayList, bl);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        if (caretEvent.getSource().equals(this.getActiveSyntaxTextPane()) && !this.mSyntaxMasterPanel.isDoOnlyBaseDocProcessing()) {
            this.processCaretUpdate();
        }
    }

    private void processCaretUpdate() {
        if (!this.mSyntaxMasterPanel.isInProcessOpenDoc()) {
            int n = this.mSyntaxMasterPanel.getCaretPosition();
            int n2 = this.mSyntaxMasterPanel.getLineNumberFromCharacterPos(n);
            int n3 = this.mSyntaxMasterPanel.convertToLineOffset(n2, n);
            this.mParentFrame.updateLineColumnNumber(n2 + 1, n3);
            this.mParentFrame.updateToolbarEnableStatus();
            SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame();
            boolean bl = this.getActiveSyntaxTextPane().getSelectedText() != null && this.getActiveSyntaxTextPane().getSelectedText().length() > 0;
            this.mCutItem.setEnabled(bl);
            this.mCopyItem.setEnabled(bl);
            this.mPasteItem.setEnabled(AppClipboard.getAppClipboard().isFlavorAvailable(DataFlavor.stringFlavor));
            this.mSelectCommandItem.setEnabled(true);
            if (spssFrame instanceof SyntaxFrame) {
                this.mDeleteItem.setEnabled(((SyntaxFrame)spssFrame).getSyntaxView().getSelectedText().length() > 0);
            }
        }
    }

    private JTextPane getActiveSyntaxTextPane() {
        return this.mSyntaxMasterPanel.getSyntaxTextPane();
    }

    public void setState(SyntaxEditorState syntaxEditorState) {
        this.mSyntaxMasterPanel.setState(syntaxEditorState);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public String getDocumentName() {
        ICoreDocument iCoreDocument = this.mParentFrame != null ? this.mParentFrame.getCoreDocument() : null;
        return iCoreDocument != null ? iCoreDocument.getDocName() : "";
    }

    @Override
    public boolean findNext(String string, SearchOptions searchOptions) {
        return this.selectNext(string, (SyntaxSearchOptions)searchOptions);
    }

    @Override
    public boolean replaceNext(String string, String string2, SearchOptions searchOptions) {
        String string3;
        this.mSyntaxMasterPanel.setDoOnlyBaseDocProcessing(true);
        SyntaxSearchOptions syntaxSearchOptions = (SyntaxSearchOptions)searchOptions;
        String string4 = string3 = syntaxSearchOptions.getTreatNewline() ? string.replace("\\n", "\n") : string;
        if (this.selectionEquals(string3, syntaxSearchOptions.getMatchCase())) {
            try {
                String string5 = syntaxSearchOptions.getTreatNewline() ? this.replaceUserNewLine(string2) : string2;
                this.mSyntaxMasterPanel.replace(string5, this.getActiveSyntaxTextPane().getSelectionStart(), this.getActiveSyntaxTextPane().getSelectionEnd() - this.getActiveSyntaxTextPane().getSelectionStart());
                this.mParentFrame.setModified(true);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            syntaxSearchOptions.offsetEndsBasedOnReplace(syntaxSearchOptions.getWordLengthDiff());
            syntaxSearchOptions.setOffset(syntaxSearchOptions.getOffset() + string2.length() - 1);
        }
        this.mSyntaxMasterPanel.setDoOnlyBaseDocProcessing(false);
        return this.selectNext(string, syntaxSearchOptions);
    }

    @Override
    public int replaceAll(String string, String string2, SearchOptions searchOptions) {
        searchOptions.setFirstSearch(true);
        int n = this.mSyntaxMasterPanel.getLineNumberFromCharacterPos(this.getActiveSyntaxTextPane().getCaretPosition());
        int n2 = 0;
        if (searchOptions.getSearchArea() == SearchOptions.SearchArea.all) {
            this.mSyntaxMasterPanel.getSyntaxTextPane().setCaretPosition(0);
        }
        this.mSyntaxMasterPanel.setDoOnlyBaseDocProcessing(true);
        SyntaxSearchOptions syntaxSearchOptions = (SyntaxSearchOptions)searchOptions;
        syntaxSearchOptions.setWordLengthDiff(string2.length() - string.length());
        if (syntaxSearchOptions.getSearchArea() == SearchOptions.SearchArea.all) {
            this.setSelectionRange(0, 0);
        }
        SyntaxUndoManager syntaxUndoManager = (SyntaxUndoManager)this.mParentFrame.getUndoManager();
        syntaxUndoManager.completeEdit();
        syntaxUndoManager.startCompoundEdit();
        while (this.replaceNext(string, string2, searchOptions)) {
            ++n2;
        }
        syntaxUndoManager.completeEdit();
        this.mSyntaxMasterPanel.setDoOnlyBaseDocProcessing(false);
        if (n2 > 0) {
            this.mParentFrame.setModified(true);
        }
        int n3 = this.mSyntaxMasterPanel.getLineStartDocOffset(n);
        try {
            this.getActiveSyntaxTextPane().setCaretPosition(n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.mSyntaxMasterPanel.doFullHighlighting();
        return n2;
    }

    @Override
    public void stopSearch() {
    }

    private boolean selectNext(String string, SyntaxSearchOptions syntaxSearchOptions) {
        String string2;
        boolean bl = false;
        boolean bl2 = syntaxSearchOptions.getSearchDirection() == SearchOptions.SearchDirection.down;
        boolean bl3 = syntaxSearchOptions.getSearchArea() == SearchOptions.SearchArea.selected;
        syntaxSearchOptions.setItemsSearched(1);
        int n = syntaxSearchOptions.getOffset();
        if (syntaxSearchOptions.isFirstSearch()) {
            syntaxSearchOptions.setUserSelectionStart(this.getActiveSyntaxTextPane().getSelectionStart());
            syntaxSearchOptions.setUserSelectionEnd(this.getActiveSyntaxTextPane().getSelectionEnd());
            syntaxSearchOptions.setStartOffset(this.getActiveSyntaxTextPane().getCaret().getDot());
            syntaxSearchOptions.setFirstSearch(false);
            int n2 = n = bl3 ? 0 : syntaxSearchOptions.getStartOffset();
            n = bl2 ? --n : ++n;
        }
        int n3 = bl3 ? 0 : syntaxSearchOptions.getStartOffset();
        Pattern pattern = this.makeSearchPattern(string, syntaxSearchOptions);
        try {
            string2 = bl3 ? this.getActiveSyntaxTextPane().getText(syntaxSearchOptions.getUserSelectionStart(), syntaxSearchOptions.getUserSelectionEnd() - syntaxSearchOptions.getUserSelectionStart()) : this.getActiveSyntaxTextPane().getText();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return false;
        }
        try {
            int n4;
            block14: {
                Matcher matcher;
                block13: {
                    matcher = pattern.matcher(string2);
                    if (!bl2) break block13;
                    if (n + 1 < string2.length() && !syntaxSearchOptions.getIsWrapped() && matcher.find(n + 1) && matcher.start() >= n3) {
                        syntaxSearchOptions.setOffset(matcher.start());
                        bl = true;
                    }
                    if (bl || bl3) break block14;
                    n4 = syntaxSearchOptions.getIsWrapped() ? n + 1 : 0;
                    syntaxSearchOptions.setIsWrapped(true);
                    if (!matcher.find(n4) || matcher.start() >= n3) break block14;
                    syntaxSearchOptions.setOffset(matcher.start());
                    bl = true;
                    break block14;
                }
                if (n <= -1) {
                    n = string2.length();
                }
                n4 = -1;
                if (!syntaxSearchOptions.getIsWrapped()) {
                    while (matcher.find(n4 + 1)) {
                        n4 = matcher.start();
                        if (n4 >= n || n4 >= n3) continue;
                        syntaxSearchOptions.setOffset(n4);
                        bl = true;
                    }
                }
                if (!bl && !bl3) {
                    n4 = n3;
                    if (n <= n3 + 1) {
                        n = string2.length();
                    }
                    syntaxSearchOptions.setIsWrapped(true);
                    while (matcher.find(n4 + 1)) {
                        n4 = matcher.start();
                        if (n4 >= n || n4 <= n3) continue;
                        syntaxSearchOptions.setOffset(n4);
                        bl = true;
                    }
                }
            }
            if (bl) {
                n4 = bl3 ? syntaxSearchOptions.getUserSelectionStart() + syntaxSearchOptions.getOffset() : syntaxSearchOptions.getOffset();
                String string3 = syntaxSearchOptions.getTreatNewline() ? string.replace("\\n", "\n") : string;
                int n5 = n4 + string3.length();
                this.getActiveSyntaxTextPane().select(n4, n5);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    private Pattern makeSearchPattern(String string, SyntaxSearchOptions syntaxSearchOptions) {
        string = this.prepStringForPattern(string, syntaxSearchOptions.getTreatNewline());
        String string2 = !syntaxSearchOptions.getMatchCase() ? "(?i)(?u)" + string : string;
        return Pattern.compile(string2);
    }

    private String prepStringForPattern(String string, boolean bl) {
        if (bl) {
            string = string.replace("\\n", "\n");
        }
        string = string.replace("\\", "\\\\");
        string = string.replace(".", "\\x2E");
        string = string.replace("*", "\\x2A");
        string = string.replace("$", "\\x24");
        string = string.replace("^", "\\x5E");
        string = string.replace("(", "\\x28");
        string = string.replace(")", "\\x29");
        string = string.replace("[", "\\x5B");
        string = string.replace("]", "\\x5D");
        string = string.replace("{", "\\x7B");
        string = string.replace("|", "\\x7C");
        string = string.replace("}", "\\x7D");
        string = string.replace("+", "\\x2B");
        string = string.replace("-", "\\x2D");
        string = string.replace("%", "\\x25");
        string = string.replace("?", "\\x3F");
        return string;
    }

    private String replaceUserNewLine(String string) {
        string = string.replace("\\n", "\n");
        return string;
    }

    public void updateNewCoreSyntaxDocument(SyntaxHighlightDocument syntaxHighlightDocument) {
        this.setCoreDocIntoSyntaxPane(syntaxHighlightDocument);
        this.updateSyntaxHighlightDocumentCallbacks();
        syntaxHighlightDocument.addUndoableEditListener((UndoableEditListener)this.mParentFrame.getUndoManager());
    }

    private void updateSyntaxHighlightDocumentCallbacks() {
        this.mSyntaxMasterPanel.setSyntaxHighlightDocCallback((SyntaxHighlightDocument.SyntaxHighlightDocCallback)this.mSyntaxMasterPanel);
        this.mSyntaxMasterPanel.setPreNotificationCallback((SyntaxHighlightDocument.PreDocChangeNotification)this.mPreDocChangeNotification);
    }

    private void createSyntaxView() {
        SyntaxEditorState syntaxEditorState = SyntaxPrefManager.getSyntaxEditorPreferences();
        this.mSyntaxMasterPanel = ComponentState.isBtdRtlOrLtr() ? new SyntaxMasterPanel((SyntaxMasterPanel.SyntaxCallback)this, SyntaxMgr.getStaticSyntaxCommands(), false) : new SyntaxMasterPanel((SyntaxMasterPanel.SyntaxCallback)this, SyntaxMgr.getStaticSyntaxCommands(), !syntaxEditorState.isOptimizeRtoL());
        if (CommandLine.isProduction()) {
            this.mSyntaxMasterPanel.setBasicEditorMode();
        }
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options");
        boolean bl = preferences.getBoolean("syntax_auto_open_err_pane", true);
        this.mSyntaxMasterPanel.setAutoOpenErrorWhenError(bl);
        this.mSyntaxMasterPanel.removeSyntaxSplit();
        SyntaxUndoManager syntaxUndoManager = (SyntaxUndoManager)this.mParentFrame.getUndoManager();
        syntaxUndoManager.setEditor(this.mSyntaxMasterPanel.getSyntaxTextPane());
        this.mEncodingValidator = new EncodingValidator(ComponentState.getCurrentCharset());
        this.mKeyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 112) {
                    if (!keyEvent.isConsumed()) {
                        SyntaxView.this.doHelp();
                        keyEvent.consume();
                    }
                } else if (keyEvent.getKeyCode() == 113) {
                    String string = SyntaxView.this.getActiveSyntaxTextPane().getText();
                    if (string != null && string.trim().length() > 2) {
                        int n = SyntaxView.this.getActiveSyntaxTextPane().getSelectionStart();
                        int n2 = SyntaxView.this.getActiveSyntaxTextPane().getSelectionEnd();
                        SyntaxView.this.mSyntaxBuffer.calculateSyntaxBlock(string, n, n2, keyEvent.isShiftDown());
                        SyntaxView.this.getActiveSyntaxTextPane().select(SyntaxView.this.mSyntaxBuffer.getSyntaxBlockStart(), SyntaxView.this.mSyntaxBuffer.getSyntaxBlockEnd() + 1);
                    }
                } else if (keyEvent.getKeyCode() == 84 && keyEvent.isControlDown()) {
                    if (!keyEvent.isConsumed()) {
                        SyntaxView.this.mSyntaxMasterPanel.doSelectionInErrorPane();
                        keyEvent.consume();
                    }
                } else if (keyEvent.getKeyCode() == 86 && keyEvent.isControlDown()) {
                    if (!keyEvent.isConsumed()) {
                        SyntaxView.this.processPaste();
                        keyEvent.consume();
                    }
                } else if ((keyEvent.getKeyCode() == 525 || keyEvent.getKeyCode() == 121 && keyEvent.isShiftDown()) && !keyEvent.isConsumed()) {
                    SyntaxView.this.showMainPanelPopup(SyntaxView.this.getCaretPoint());
                    keyEvent.consume();
                }
            }
        };
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        this.add((Component)this.mSyntaxMasterPanel, gridBagConstraints);
        this.createPopupMenu();
        this.addSyntaxTextPanelListeners(this.getSyntaxMasterPanel().getMainSpssSyntaxTextPane());
    }

    Point getCaretPoint() {
        Rectangle rectangle = null;
        try {
            rectangle = this.getActiveSyntaxTextPane().modelToView(this.mSyntaxMasterPanel.getCaretPosition());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return rectangle != null ? new Point((int)rectangle.getX(), (int)rectangle.getY()) : null;
    }

    private void createPopupMenu() {
        this.mPopupMenu = new JPopupMenu();
        final ResourceBundle resourceBundle = ResUtil.getBundle(ViewResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        this.mActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals(resourceBundle.getString("IDS_POPUP_CUT_MENU"))) {
                    SyntaxView.this.processCut();
                } else if (actionEvent.getActionCommand().equals(resourceBundle.getString("IDS_POPUP_COPY_MENU"))) {
                    SyntaxView.this.processCopy();
                } else if (actionEvent.getActionCommand().equals(resourceBundle.getString("IDS_POPUP_PASTE_MENU"))) {
                    SyntaxView.this.processPaste();
                } else if (actionEvent.getActionCommand().equals(resourceBundle.getString("IDS_POPUP_DELETE_MENU"))) {
                    SyntaxView.this.processDelete();
                } else if (actionEvent.getActionCommand().equals(resourceBundle.getString("IDS_POPUP_RUN_ALL_MENU"))) {
                    SyntaxView.this.processRunAll();
                } else if (actionEvent.getActionCommand().equals(resourceBundle.getString("IDS_POPUP_RUN_SELECTION_MENU"))) {
                    SyntaxView.this.processRunSelection();
                } else if (actionEvent.getActionCommand().equals(resourceBundle.getString("IDS_POPUP_RUN_TO_END_MENU"))) {
                    SyntaxView.this.processRunToEnd();
                } else if (actionEvent.getActionCommand().equals(resourceBundle.getString("IDS_POPUP_RUN_STEP_FROM_START"))) {
                    SyntaxView.this.processRunStepFromStart();
                } else if (actionEvent.getActionCommand().equals(resourceBundle.getString("IDS_POPUP_RUN_STEP_FROM_CURRENT"))) {
                    SyntaxView.this.processRunStepFromCurrent();
                } else if (actionEvent.getActionCommand().equals(resourceBundle.getString("IDS_POPUP_RUN_CONTINUE_MENU"))) {
                    SyntaxView.this.processContinue();
                } else if (actionEvent.getActionCommand().equals(resourceBundle.getString("IDS_POPUP_SELECT_COMMAND_MENU"))) {
                    SyntaxView.this.processSelectCommand();
                } else if (actionEvent.getActionCommand().equals(resourceBundle.getString("IDS_POPUP_BREAKPOINT_MENU"))) {
                    SyntaxView.this.toggleBreakpoint();
                } else if (actionEvent.getActionCommand().equals(resourceBundle.getString("IDS_POPUP_BOOKMARK_MENU"))) {
                    SyntaxView.this.toggleBookmark();
                } else if (actionEvent.getActionCommand().equals(resourceBundle.getString("IDS_POPUP_SYNTAX_KEYBOARD_SHORTCUT_DLG"))) {
                    SyntaxView.this.showKeyboardShortcutsDlg();
                } else if (actionEvent.getActionCommand().equals(resourceBundle.getString("IDS_POPUP_RENAME_BOOKMARK_MENU"))) {
                    SyntaxView.this.mSyntaxMasterPanel.doRenameBookmarkDlg(SyntaxView.this.getCaretLine());
                } else if (actionEvent.getActionCommand().equals(resourceBundle.getString("IDS_POPUP_SYNTAX_HELP_MENU"))) {
                    SyntaxView.this.doHelp();
                } else if (actionEvent.getActionCommand().equals(resourceBundle.getString("IDS_POPUP_SYNTAX_HELP_MENU"))) {
                    SyntaxView.this.doHelp();
                }
            }
        };
        this.mCutItem = new JMenuItem(resourceBundle.getString("IDS_POPUP_CUT_MENU"));
        this.mCutItem.addActionListener(this.mActionListener);
        this.mCutItem.setEnabled(false);
        this.mCutItem.setHorizontalTextPosition(4);
        this.mPopupMenu.add(this.mCutItem);
        this.mCopyItem = new JMenuItem(resourceBundle.getString("IDS_POPUP_COPY_MENU"));
        this.mCopyItem.addActionListener(this.mActionListener);
        this.mCopyItem.setEnabled(false);
        this.mCopyItem.setHorizontalTextPosition(4);
        this.mPopupMenu.add(this.mCopyItem);
        this.mPasteItem = new JMenuItem(resourceBundle.getString("IDS_POPUP_PASTE_MENU"));
        this.mPasteItem.addActionListener(this.mActionListener);
        this.mPasteItem.setEnabled(AppClipboard.getAppClipboard().isFlavorAvailable(DataFlavor.stringFlavor));
        this.mPasteItem.setHorizontalTextPosition(4);
        this.mPopupMenu.add(this.mPasteItem);
        this.mDeleteItem = new JMenuItem(resourceBundle.getString("IDS_POPUP_DELETE_MENU"));
        this.mDeleteItem.addActionListener(this.mActionListener);
        this.mDeleteItem.setEnabled(false);
        this.mDeleteItem.setHorizontalTextPosition(4);
        this.mPopupMenu.add(this.mDeleteItem);
        this.mSelectCommandItem = new JMenuItem(resourceBundle.getString("IDS_POPUP_SELECT_COMMAND_MENU"));
        this.mSelectCommandItem.addActionListener(this.mActionListener);
        this.mSelectCommandItem.setEnabled(false);
        this.mSelectCommandItem.setHorizontalTextPosition(4);
        this.mPopupMenu.add(this.mSelectCommandItem);
        this.mPopupMenu.addSeparator();
        this.mRunAllItem = new JMenuItem(resourceBundle.getString("IDS_POPUP_RUN_ALL_MENU"));
        this.mRunAllItem.addActionListener(this.mActionListener);
        this.mRunAllItem.setEnabled(true);
        this.mRunAllItem.setHorizontalTextPosition(4);
        this.mPopupMenu.add(this.mRunAllItem);
        this.mRunSelectionItem = new JMenuItem(resourceBundle.getString("IDS_POPUP_RUN_SELECTION_MENU"));
        this.mRunSelectionItem.addActionListener(this.mActionListener);
        this.mRunSelectionItem.setEnabled(true);
        this.mRunSelectionItem.setHorizontalTextPosition(4);
        this.mPopupMenu.add(this.mRunSelectionItem);
        this.mRunToEndItem = new JMenuItem(resourceBundle.getString("IDS_POPUP_RUN_TO_END_MENU"));
        this.mRunToEndItem.addActionListener(this.mActionListener);
        this.mRunToEndItem.setEnabled(true);
        this.mRunToEndItem.setHorizontalTextPosition(4);
        this.mPopupMenu.add(this.mRunToEndItem);
        this.mPopupMenu.addSeparator();
        this.mRunContinueItem = new JMenuItem(resourceBundle.getString("IDS_POPUP_RUN_CONTINUE_MENU"));
        this.mRunContinueItem.addActionListener(this.mActionListener);
        this.mRunContinueItem.setEnabled(true);
        this.mRunContinueItem.setHorizontalTextPosition(4);
        this.mPopupMenu.add(this.mRunContinueItem);
        this.mPopupMenu.addSeparator();
        this.mBreakpointItem = new JMenuItem(resourceBundle.getString("IDS_POPUP_BREAKPOINT_MENU"));
        this.mBreakpointItem.addActionListener(this.mActionListener);
        this.mBreakpointItem.setEnabled(true);
        this.mBreakpointItem.setHorizontalTextPosition(4);
        this.mPopupMenu.add(this.mBreakpointItem);
        this.mBookmarkItem = new JMenuItem(resourceBundle.getString("IDS_POPUP_BOOKMARK_MENU"));
        this.mBookmarkItem.addActionListener(this.mActionListener);
        this.mBookmarkItem.setEnabled(true);
        this.mBookmarkItem.setHorizontalTextPosition(4);
        this.mPopupMenu.add(this.mBookmarkItem);
        this.mRenameBookmarkItem = new JMenuItem(resourceBundle.getString("IDS_POPUP_RENAME_BOOKMARK_MENU"));
        this.mRenameBookmarkItem.addActionListener(this.mActionListener);
        this.mRenameBookmarkItem.setEnabled(true);
        this.mRenameBookmarkItem.setHorizontalTextPosition(4);
        this.mPopupMenu.add(this.mRenameBookmarkItem);
        this.mPopupMenu.addSeparator();
        this.mHelpItem = new JMenuItem(resourceBundle.getString("IDS_POPUP_SYNTAX_KEYBOARD_SHORTCUT_DLG"));
        this.mHelpItem.addActionListener(this.mActionListener);
        this.mHelpItem.setEnabled(true);
        this.mHelpItem.setHorizontalTextPosition(4);
        this.mPopupMenu.add(this.mHelpItem);
        this.mPopupMenu.setBorder(new BevelBorder(0));
        this.mPopupMenu.addSeparator();
        this.mHelpItem = new JMenuItem(resourceBundle.getString("IDS_POPUP_SYNTAX_HELP_MENU"));
        this.mHelpItem.addActionListener(this.mActionListener);
        this.mHelpItem.setEnabled(true);
        this.mHelpItem.setHorizontalTextPosition(4);
        this.mPopupMenu.add(this.mHelpItem);
        this.mPopupMenu.setBorder(new BevelBorder(0));
        this.mMousePopupListener = new MousePopupListener();
        this.mSyntaxMasterPanel.addCopyMenuItem(resourceBundle.getString("IDS_POPUP_COPY_MENU"));
        this.mSyntaxMasterPanel.addClearMenuItem(resourceBundle.getString("IDS_POPUP_CLEAR_ERROR_TABLE_MENU"));
    }

    private void showKeyboardShortcutsDlg() {
        SyntaxKeyboardShortcutsDlg syntaxKeyboardShortcutsDlg = new SyntaxKeyboardShortcutsDlg(this.mParentFrame);
        syntaxKeyboardShortcutsDlg.setVisible(true);
    }

    private void doHelp() {
        Container container = this.getTopLevelAncestor();
        if (container instanceof SyntaxFrame) {
            SyntaxHelpAction.doHelpForSyntaxFrame((SyntaxFrame)container);
        }
    }

    private void processPaste() {
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame();
        if (spssFrame instanceof SyntaxFrame) {
            spssFrame.doPaste();
        }
    }

    private void processCopy() {
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame();
        if (spssFrame instanceof SyntaxFrame) {
            spssFrame.doCopy();
        }
    }

    private void processCut() {
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame();
        if (spssFrame instanceof SyntaxFrame) {
            spssFrame.doCut();
        }
    }

    private void processDelete() {
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame();
        if (spssFrame instanceof SyntaxFrame) {
            spssFrame.doDelete();
        }
    }

    private void processContinue() {
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame();
        if (spssFrame instanceof SyntaxFrame) {
            ((SyntaxFrame)spssFrame).clearErrorPane();
            RunAction.doRunForSegment(this.mParentFrame, SyntaxFrame.SyntaxSegment.CONTINUE);
        }
    }

    private void processSelectCommand() {
        this.mSyntaxMasterPanel.selectSegment(SyntaxEditorEnums.SyntaxSegment.SELECTION);
    }

    private void processRunAll() {
        RunAction.doRunForSegment(this.mParentFrame, SyntaxFrame.SyntaxSegment.ALL);
    }

    private void processRunToEnd() {
        RunAction.doRunForSegment(this.mParentFrame, SyntaxFrame.SyntaxSegment.TO_END);
    }

    private void processRunStepFromStart() {
        RunAction.doRunForSegment(this.mParentFrame, SyntaxFrame.SyntaxSegment.STEP_FIRST_COMMAND);
    }

    private void processRunStepFromCurrent() {
        RunAction.doRunForSegment(this.mParentFrame, SyntaxFrame.SyntaxSegment.STEP_FIRST_COMMAND_IN_SELECTION);
    }

    private void processRunSelection() {
        RunAction.doRunForSegment(this.mParentFrame, SyntaxFrame.SyntaxSegment.SELECTION);
    }

    private SyntaxHighlightDocument getSyntaxCoreDocument() {
        return this.mParentFrame.getDocument() != null ? this.mParentFrame.getDocument().getCoreSyntaxDocument() : null;
    }

    public void setEncoding(Charset charset) {
        this.mEncodingValidator.setEncoding(charset);
    }

    public Charset getEncoding() {
        return this.mEncodingValidator.getEncoding();
    }

    public void notifyILangChange(Locale locale) {
        this.mSyntaxMasterPanel.setResourceLocale(locale);
        this.createPopupMenu();
    }

    public void notifyCharsetChange() {
        this.setEncoding(ComponentState.getCurrentCharset());
    }

    public boolean isAnySelected() {
        return this.getActiveSyntaxTextPane().getSelectedText() != null && this.getActiveSyntaxTextPane().getSelectedText().length() > 0;
    }

    public void doUndo() {
        this.mSyntaxMasterPanel.setDoOnlyBaseDocProcessing(true);
        int n = this.mSyntaxMasterPanel.getCaretPosition();
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame();
        boolean bl = spssFrame.getUndoManager().canUndo();
        if (bl) {
            spssFrame.getUndoManager().undo();
        }
        this.mSyntaxMasterPanel.setDoOnlyBaseDocProcessing(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SyntaxView.this.mSyntaxMasterPanel.updateAfterIgnoreDocUdates();
            }
        });
        if (bl) {
            this.mParentFrame.setModified(true);
        }
    }

    public void doRedo() {
        this.mSyntaxMasterPanel.setDoOnlyBaseDocProcessing(true);
        int n = this.mSyntaxMasterPanel.getCaretPosition();
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame();
        boolean bl = spssFrame.getUndoManager().canRedo();
        if (bl) {
            spssFrame.getUndoManager().redo();
        }
        try {
            this.getActiveSyntaxTextPane().setCaretPosition(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.mSyntaxMasterPanel.setDoOnlyBaseDocProcessing(false);
        if (bl) {
            this.mParentFrame.setModified(true);
        }
    }

    public SyntaxMasterPanel getSyntaxMasterPanel() {
        return this.mSyntaxMasterPanel;
    }

    public void setNavigationPaneVisible(boolean bl) {
        this.mSyntaxMasterPanel.setNavigationPaneVisible(bl);
    }

    public void setErrorPaneVisible(boolean bl) {
        this.mSyntaxMasterPanel.showErrorPane(bl);
    }

    public void showLineNumbers(boolean bl) {
        this.mSyntaxMasterPanel.showLineNumbers(bl);
    }

    public void showCommandSpans(boolean bl) {
        this.mSyntaxMasterPanel.showCommandSpans(bl);
    }

    public boolean isNavPaneShowing() {
        return this.mSyntaxMasterPanel.isNavPaneShowing();
    }

    public boolean isErrorPaneShowing() {
        return this.mSyntaxMasterPanel.isErrorPaneShowing();
    }

    public boolean isLineNumsShowing() {
        return this.mSyntaxMasterPanel.isLineNumsShowing();
    }

    public boolean isCommandSpansShowing() {
        return this.mSyntaxMasterPanel.isCommandSpansShowing();
    }

    public void showHighlighting(boolean bl) {
        this.mSyntaxMasterPanel.showHighlighting(bl);
    }

    public boolean isShowHighlight() {
        return this.mSyntaxMasterPanel.isDoHighlight();
    }

    public void showErrorHighlighting(boolean bl) {
        this.mSyntaxMasterPanel.showErrorHighlighting(bl);
    }

    public boolean isShowErrorHighlighting() {
        return this.mSyntaxMasterPanel.isShowErrorHighlighting();
    }

    public boolean isAutoCompleteActive() {
        return this.mSyntaxMasterPanel.isAutoCompleteActive();
    }

    public void setAutoCompleteActive(boolean bl) {
        this.mSyntaxMasterPanel.setAutoCompleteActive(bl);
    }

    public void doToggleComments() {
        SyntaxUndoManager syntaxUndoManager = (SyntaxUndoManager)this.mParentFrame.getUndoManager();
        syntaxUndoManager.completeEdit();
        syntaxUndoManager.startCompoundEdit();
        this.mSyntaxMasterPanel.toggleComments();
        this.mParentFrame.setModified(true);
        syntaxUndoManager.completeEdit();
    }

    public void doClearAllBreakpoints() {
        this.mSyntaxMasterPanel.doClearAllBreakpoints();
    }

    public void setHonorBreakpoints(boolean bl) {
        this.mSyntaxMasterPanel.setHonorBreakpoints(bl);
    }

    public boolean isHonorBreakpoints() {
        return this.mSyntaxMasterPanel.isHonorBreakpoints();
    }

    public ArrayList<BookmarkInfo> getBookmarkInfos() {
        return this.mSyntaxMasterPanel.getBookmarkInfos();
    }

    public BookmarkInfo getBookmarkInfo(int n) {
        return this.mSyntaxMasterPanel.getBookmarkInfo(n);
    }

    public void doRenameBookmarkDlg(BookmarkInfo bookmarkInfo) {
        if (bookmarkInfo != null) {
            String string = this.doRenameBookmarkDlg(bookmarkInfo.toString());
            this.mSyntaxMasterPanel.renameBookmark(bookmarkInfo, string);
        }
    }

    public String doRenameBookmarkDlg(String string) {
        RenameDlg renameDlg = new RenameDlg(this.mParentFrame, "IDS_RENAME_BOOKMARK_TITLE", "IDS_RENAME_BOOKMARK_LABEL", string, StatsHelp.Book.BASE, "IDH_IDD_SYNEDITOR_BOOKMARKS");
        renameDlg.setVisible(true);
        return renameDlg.isOk() ? renameDlg.getNewName() : string;
    }

    public boolean hasBookmarks() {
        return this.mSyntaxMasterPanel.hasBookmarks();
    }

    public boolean hasNextBookmark() {
        return this.mSyntaxMasterPanel.hasNextBookmark();
    }

    public void doNextBookmark() {
        this.mSyntaxMasterPanel.doNextBookmark();
    }

    public boolean hasPreviousBookmark() {
        return this.mSyntaxMasterPanel.hasPreviousBookmark();
    }

    public void doPreviousBookmark() {
        this.mSyntaxMasterPanel.doPreviousBookmark();
    }

    public void gotoBookmark(BookmarkInfo bookmarkInfo) {
        this.mSyntaxMasterPanel.gotoBookmark(bookmarkInfo);
    }

    public void doAddBookmark() {
        this.mSyntaxMasterPanel.doAddBookmark();
    }

    public void doClearAllBookmarks() {
        this.mSyntaxMasterPanel.doClearAllBookmarks();
    }

    public boolean hasSelection() {
        return this.mSyntaxMasterPanel.hasSelection();
    }

    public boolean hasSelectedText() {
        String string = this.getActiveSyntaxTextPane().getSelectedText();
        return string != null && string.trim().length() > 0;
    }

    public int getCaretLine() {
        return this.mSyntaxMasterPanel.getCaretLine();
    }

    public boolean caretLineHasText() {
        int n = this.getCaretLine();
        boolean bl = this.mSyntaxMasterPanel.isEmptyLine(n);
        return !bl;
    }

    public boolean isEditorEmpty() {
        boolean bl = this.mSyntaxMasterPanel.isEditorEmpty();
        return !bl;
    }

    public boolean caretLineHasBookmark() {
        int n = this.mSyntaxMasterPanel.getCaretLine();
        return this.mSyntaxMasterPanel.lineHasBoomark(n);
    }

    public boolean caretLineHasBreakpoint() {
        int n = this.mSyntaxMasterPanel.getCaretLine();
        return this.mSyntaxMasterPanel.hasBreakPoint(n);
    }

    public boolean hasNextStepSyntaxBlock() {
        return this.mSyntaxMasterPanel != null && this.mSyntaxMasterPanel.hasNextStepSyntaxBlock();
    }

    public void toggleBreakpoint() {
        this.mSyntaxMasterPanel.toggleBreakpoint();
    }

    public void toggleBookmark() {
        this.mSyntaxMasterPanel.toggleBookmark();
    }

    public int getLineNumberFromCaretPos() {
        return this.mSyntaxMasterPanel.getLineNumberFromCaretPos();
    }

    public boolean isInStep() {
        return this.mSyntaxMasterPanel.isInStep();
    }

    public boolean isInRunBreakPoint() {
        return this.mSyntaxMasterPanel.isInRunBreakPoint();
    }

    public boolean canContinue() {
        return this.mSyntaxMasterPanel.canContinue();
    }

    public void clearErrorPane() {
        this.mSyntaxMasterPanel.clearErrorPane();
    }

    public Object processNotification(int n, Object object) {
        Object object2 = null;
        switch (n) {
            case 1: {
                if (this.mParentFrame == null) break;
                this.mParentFrame.updateToolbarButtons();
                break;
            }
            case 2: {
                if (this.mParentFrame == null) break;
                this.mParentFrame.updateToolbarEnableStatus();
                break;
            }
            case 3: {
                object2 = this.doRenameBookmarkDlg((String)object);
                break;
            }
            case 4: {
                if (this.mParentFrame == null) break;
                this.mParentFrame.setModified(true);
                break;
            }
            case 5: {
                if (this.mParentFrame == null) break;
                SyntaxUndoManager syntaxUndoManager = (SyntaxUndoManager)this.mParentFrame.getUndoManager();
                syntaxUndoManager.completeEdit();
                syntaxUndoManager.startCompoundEdit();
                break;
            }
            case 6: {
                if (this.mParentFrame == null) break;
                SyntaxUndoManager syntaxUndoManager = (SyntaxUndoManager)this.mParentFrame.getUndoManager();
                syntaxUndoManager.completeEdit();
                break;
            }
            case 7: {
                object2 = this.processDrop((DropTargetDropEvent)object);
                break;
            }
            case 10: {
                if (this.mParentFrame == null) break;
                this.mParentFrame.updateToolbarEnableStatus();
            }
        }
        return object2;
    }

    public boolean processDrop(DropTargetDropEvent dropTargetDropEvent) {
        boolean bl = false;
        if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || FileDrop.isLinuxDropFilesEvent((DropTargetDropEvent)dropTargetDropEvent)) {
            bl = true;
            try {
                AppMgr.processDroppedFiles((DropTargetDropEvent)dropTargetDropEvent);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bl;
    }

    public void clearSelection() {
        this.setSelectionRange(-1, -1);
    }

    private void setSelectionRange(int n, int n2) {
        this.getActiveSyntaxTextPane().setSelectionStart(n);
        this.getActiveSyntaxTextPane().setSelectionEnd(n2);
    }

    public boolean isDividerOn() {
        return this.mSyntaxMasterPanel.isSplitPaneOn();
    }

    public void showDivider(boolean bl) {
        if (bl) {
            this.mSyntaxMasterPanel.addSyntaxSplit();
            this.addSyntaxTextPanelListeners(this.mSyntaxMasterPanel.getSplitSpssSyntaxTextPane());
        } else {
            this.mSyntaxMasterPanel.removeSyntaxSplit();
            this.removeSyntaxTextPanelListeners(this.mSyntaxMasterPanel.getSplitSpssSyntaxTextPane());
        }
    }

    public boolean hasNextSyntaxError() {
        return this.mSyntaxMasterPanel.hasNextError();
    }

    public void gotoNextSyntaxError() {
        this.mSyntaxMasterPanel.gotoNextError();
    }

    public boolean hasPreviousSyntaxError() {
        return this.mSyntaxMasterPanel.hasPreviousError();
    }

    public void gotoPreviousSyntaxError() {
        this.mSyntaxMasterPanel.gotoPreviousError();
    }

    public void doAutoIndent() {
        SyntaxUndoManager syntaxUndoManager = (SyntaxUndoManager)this.mParentFrame.getUndoManager();
        syntaxUndoManager.completeEdit();
        syntaxUndoManager.startCompoundEdit();
        this.mSyntaxMasterPanel.doAutoIndent();
        syntaxUndoManager.completeEdit();
    }

    public void doIndent() {
        SyntaxUndoManager syntaxUndoManager = (SyntaxUndoManager)this.mParentFrame.getUndoManager();
        syntaxUndoManager.completeEdit();
        syntaxUndoManager.startCompoundEdit();
        this.mSyntaxMasterPanel.doIndent();
        syntaxUndoManager.completeEdit();
    }

    public void doOutdent() {
        SyntaxUndoManager syntaxUndoManager = (SyntaxUndoManager)this.mParentFrame.getUndoManager();
        syntaxUndoManager.completeEdit();
        syntaxUndoManager.startCompoundEdit();
        this.mSyntaxMasterPanel.doOutdent();
        syntaxUndoManager.completeEdit();
    }

    private void showMainPanelPopup(Point point) {
        boolean bl = this.mSyntaxMasterPanel.canContinue();
        this.mRunContinueItem.setEnabled(bl);
        bl = this.caretLineHasText();
        this.mBreakpointItem.setEnabled(bl);
        this.mBookmarkItem.setEnabled(true);
        bl = this.canRenameBookmark();
        this.mRenameBookmarkItem.setEnabled(bl);
        this.mPopupMenu.show(this.mSyntaxMasterPanel.getSyntaxTextPane(), (int)point.getX(), (int)point.getY());
    }

    private boolean canRenameBookmark() {
        boolean bl = this.mSyntaxMasterPanel.hasBookmark(this.mSyntaxMasterPanel.getCaretLine());
        int n = this.getActiveSyntaxTextPane().getSelectionStart();
        int n2 = this.getActiveSyntaxTextPane().getSelectionEnd();
        return bl && n == n2;
    }

    public void processSyntaxEditAction(String string) {
        SyntaxMasterPanel.SyntaxEditOption syntaxEditOption = this.convertToSyntaxEditorEnum(string);
        this.mSyntaxMasterPanel.processSyntaxEditAction(syntaxEditOption);
    }

    protected SyntaxMasterPanel.SyntaxEditOption convertToSyntaxEditorEnum(String string) {
        SyntaxMasterPanel.SyntaxEditOption syntaxEditOption = SyntaxMasterPanel.SyntaxEditOption.UNKNOWN;
        if (string.equals("syntax_edit_join_lines")) {
            syntaxEditOption = SyntaxMasterPanel.SyntaxEditOption.JOIN_LINES;
        } else if (string.equals("syntax_edit_duplicate_lines")) {
            syntaxEditOption = SyntaxMasterPanel.SyntaxEditOption.DUPLICATE_LINES;
        } else if (string.equals("syntax_edit_delete_lines")) {
            syntaxEditOption = SyntaxMasterPanel.SyntaxEditOption.DELETE_LINES;
        } else if (string.equals("syntax_edit_remove_empty_lines")) {
            syntaxEditOption = SyntaxMasterPanel.SyntaxEditOption.REMOVE_EMPTY_LINES;
        } else if (string.equals("syntax_edit_toggle_column_edit")) {
            syntaxEditOption = SyntaxMasterPanel.SyntaxEditOption.TOGGLE_COLUMN_EDITING;
        } else if (string.equals("syntax_edit_exit_column_edit")) {
            syntaxEditOption = SyntaxMasterPanel.SyntaxEditOption.EXIT_COLUMN_EDITING;
        } else if (string.equals("syntax_edit_move_lines_up")) {
            syntaxEditOption = SyntaxMasterPanel.SyntaxEditOption.MOVE_LINES_UP;
        } else if (string.equals("syntax_edit_move_lines_down")) {
            syntaxEditOption = SyntaxMasterPanel.SyntaxEditOption.MOVE_LINES_DOWN;
        } else if (string.equals("syntax_edit_trim_leading")) {
            syntaxEditOption = SyntaxMasterPanel.SyntaxEditOption.TRIM_LEADING;
        } else if (string.equals("syntax_edit_trim_trailing")) {
            syntaxEditOption = SyntaxMasterPanel.SyntaxEditOption.TRIM_TRAILING;
        } else if (string.equals("syntax_edit_trim_both")) {
            syntaxEditOption = SyntaxMasterPanel.SyntaxEditOption.TRIM_BOTH;
        } else if (string.equals("syntax_edit_shortcuts_dialog")) {
            this.showKeyboardShortcutsDlg();
        }
        return syntaxEditOption;
    }

    class PreDocChangeNotification
    implements SyntaxHighlightDocument.PreDocChangeNotification {
        PreDocChangeNotification() {
        }

        public void preReplaceNotification(int n, int n2, String string) {
        }

        public void preRemoveNotification(int n, int n2) {
            SyntaxUndoManager syntaxUndoManager = (SyntaxUndoManager)SyntaxView.this.mParentFrame.getUndoManager();
            if (n2 == 1) {
                char c = SyntaxView.this.getSyntaxCoreDocument().getCharAt(n);
                if (c == '\n') {
                    syntaxUndoManager.completeEdit();
                } else if (c == ' ' && n + 1 < SyntaxView.this.getSyntaxCoreDocument().getLength() && (c = SyntaxView.this.getSyntaxCoreDocument().getCharAt(n + 1)) != ' ') {
                    syntaxUndoManager.completeEdit();
                }
            }
        }

        public void preInsertNotification(int n, String string) {
            SyntaxUndoManager syntaxUndoManager = (SyntaxUndoManager)SyntaxView.this.mParentFrame.getUndoManager();
            if (string.length() == 1) {
                char c;
                if (string.charAt(0) == '\n') {
                    syntaxUndoManager.completeEdit();
                } else if (string.charAt(0) != ' ' && n - 1 >= 0 && (c = SyntaxView.this.getSyntaxCoreDocument().getCharAt(n - 1)) == ' ') {
                    syntaxUndoManager.completeEdit();
                }
            }
        }
    }

    class MousePopupListener
    extends MouseAdapter {
        MousePopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            mouseEvent.getComponent().requestFocusInWindow();
            this.checkPopup(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.checkPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.checkPopup(mouseEvent);
            this.resetSearch();
        }

        private void resetSearch() {
            SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame();
            SyntaxFindDlg syntaxFindDlg = ((SyntaxFrame)spssFrame).getSearchDialog();
            if (syntaxFindDlg != null) {
                syntaxFindDlg.setFirstSearch();
            }
        }

        private void checkPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                SyntaxView.this.showMainPanelPopup(mouseEvent.getPoint());
            }
        }
    }
}

