/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.syntax;

import com.spss.java_client.ui.doc_types.StatusBar;
import com.spss.java_client.ui.doc_types.doc_util.ThinBeveledBorder;
import com.spss.java_client.ui.resources.ClientResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class SyntaxStatusBar
extends StatusBar {
    JLabel mLineColumnPane = null;
    private JLabel mOverWritePane = null;
    private JLabel mNumLockPane = null;
    private JLabel mCapsLockPane = null;

    public SyntaxStatusBar() {
        final ResourceBundle resourceBundle = ResUtil.getBundle(ClientResBundle.getDefaultResourceBundleName(), Locale.getDefault());
        this.mLineColumnPane = new JLabel("Ln 1 Col 1");
        this.mOverWritePane = new JLabel("   ");
        this.mNumLockPane = new JLabel("   ");
        this.mCapsLockPane = new JLabel("    ");
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        ThinBeveledBorder thinBeveledBorder = new ThinBeveledBorder(uIDefaults.getColor("ToolBar.highlight"), uIDefaults.getColor("ToolBar.shadow"), 1);
        this.mLineColumnPane.setBorder(thinBeveledBorder);
        this.mOverWritePane.setBorder(thinBeveledBorder);
        this.mNumLockPane.setBorder(thinBeveledBorder);
        this.mCapsLockPane.setBorder(thinBeveledBorder);
        this.setBorder(new ThinBeveledBorder(uIDefaults.getColor("ToolBar.highlight"), uIDefaults.getColor("ToolBar.shadow"), 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = this.mNextXpos;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.01;
        gridBagConstraints.weighty = 0.99;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        this.mLineColumnPane.setToolTipText(ResUtil.getString(resourceBundle, "IDS_SBAR_LINE_COLUMN_PANE_MESSAGE"));
        this.mLineColumnPane.addMouseListener(this);
        this.add((Component)this.mLineColumnPane, gridBagConstraints);
        gridBagConstraints.gridx = this.mNextXpos + 1;
        this.mOverWritePane.setToolTipText(ResUtil.getString(resourceBundle, "IDS_SBAR_OVERWRITE_PANE_MESSAGE"));
        this.mOverWritePane.addMouseListener(this);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SyntaxStatusBar.this.mOverWritePane.getText().trim().equals("")) {
                    SyntaxStatusBar.this.mOverWritePane.setText(ResUtil.getString(resourceBundle, "IDS_SBAR_OVERWRITE_PANE_TEXT"));
                } else {
                    SyntaxStatusBar.this.mOverWritePane.setText("      ");
                }
            }
        };
        this.mOverWritePane.getInputMap(2).put(KeyStroke.getKeyStroke(155, 0), "showOVR");
        this.mOverWritePane.getActionMap().put("showOVR", abstractAction);
        this.add((Component)this.mOverWritePane, gridBagConstraints);
        gridBagConstraints.gridx = this.mNextXpos + 2;
        this.mNumLockPane.setToolTipText(ResUtil.getString(resourceBundle, "IDS_SBAR_NUM_LOCK_PANE_MESSAGE"));
        this.mNumLockPane.addMouseListener(this);
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SyntaxStatusBar.this.checkNumLockState();
            }
        };
        this.mNumLockPane.getInputMap(2).put(KeyStroke.getKeyStroke(144, 0), "showNUM");
        this.mNumLockPane.getActionMap().put("showNUM", abstractAction2);
        this.add((Component)this.mNumLockPane, gridBagConstraints);
        gridBagConstraints.gridx = this.mNextXpos + 3;
        this.mCapsLockPane.setToolTipText(ResUtil.getString(resourceBundle, "IDS_SBAR_CAPS_LOCK_PANE_MESSAGE"));
        this.mCapsLockPane.addMouseListener(this);
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SyntaxStatusBar.this.checkCapsLockState();
            }
        };
        this.mCapsLockPane.getInputMap(2).put(KeyStroke.getKeyStroke(20, 0), "showCAP");
        this.mCapsLockPane.getActionMap().put("showCAP", abstractAction3);
        this.add((Component)this.mCapsLockPane, gridBagConstraints);
        this.setStatusBarFont();
        this.checkCapsLockState();
        this.checkNumLockState();
    }

    private void checkCapsLockState() {
        ResourceBundle resourceBundle = ResUtil.getBundle(ClientResBundle.getDefaultResourceBundleName(), Locale.getDefault());
        boolean bl = false;
        try {
            bl = this.getToolkit().getLockingKeyState(20);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (bl) {
            this.mCapsLockPane.setText(ResUtil.getString(resourceBundle, "IDS_SBAR_CAPS_LOCK_PANE_TEXT"));
        } else {
            this.mCapsLockPane.setText("      ");
        }
    }

    private void checkNumLockState() {
        ResourceBundle resourceBundle = ResUtil.getBundle(ClientResBundle.getDefaultResourceBundleName(), Locale.getDefault());
        boolean bl = false;
        try {
            bl = this.getToolkit().getLockingKeyState(144);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (bl) {
            this.mNumLockPane.setText(ResUtil.getString(resourceBundle, "IDS_SBAR_NUM_LOCK_PANE_TEXT"));
        } else {
            this.mNumLockPane.setText("      ");
        }
    }

    @Override
    public JLabel getPane(StatusBar.StatusPane statusPane) {
        JLabel jLabel = super.getPane(statusPane);
        if (jLabel == null) {
            if (statusPane == StatusBar.StatusPane.lineColumnPane) {
                jLabel = this.mLineColumnPane;
            } else if (statusPane == StatusBar.StatusPane.overWritePane) {
                jLabel = this.mOverWritePane;
            } else if (statusPane == StatusBar.StatusPane.numLockPane) {
                jLabel = this.mNumLockPane;
            } else if (statusPane == StatusBar.StatusPane.capLockPane) {
                jLabel = this.mCapsLockPane;
            }
        }
        assert (jLabel != null);
        return jLabel;
    }

    @Override
    public void updateStatusBarHelpText(AbstractButton abstractButton) {
        super.updateStatusBarHelpText(abstractButton);
        ResourceBundle resourceBundle = ResUtil.getBundle(ClientResBundle.getDefaultResourceBundleName(), Locale.getDefault());
        if (abstractButton != null) {
            String string;
            String string2 = string = abstractButton.getToolTipText() != null ? abstractButton.getToolTipText() : abstractButton.getText();
            if (string != null && string.length() != 0) {
                if (string.equals(ResUtil.getString(resourceBundle, "GOTO_CASE_TEXT"))) {
                    String string3 = ResUtil.getString(resourceBundle, "NEW_GOTO_CASE_TEXT");
                    this.updateStatusBarHelpText(string3);
                } else if (string.equals(ResUtil.getString(resourceBundle, "RUN_CURRENT_TEXT"))) {
                    String string4 = ResUtil.getString(resourceBundle, "NEW_RUN_CURRENT_TEXT");
                    this.updateStatusBarHelpText(string4);
                } else if (string.equals(ResUtil.getString(resourceBundle, "DESIGNATE_WINDOW_TEXT"))) {
                    String string5 = ResUtil.getString(resourceBundle, "NEW_DESIGNATE_WINDOW_TEXT");
                    this.updateStatusBarHelpText(string5);
                }
            }
        }
    }
}

