/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.syntax;

import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.shared.syntaxeditor.shared_objects.FontState;
import com.spss.shared.syntaxeditor.shared_objects.SyntaxEditorState;
import java.awt.Color;
import java.util.prefs.Preferences;

public class SyntaxPrefManager {
    public static SyntaxEditorState getSyntaxEditorPreferences() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options").node("syntax_editor");
        SyntaxEditorState syntaxEditorState = new SyntaxEditorState();
        boolean bl = preferences.getBoolean("display_syntax_color_coding", true);
        syntaxEditorState.setDisplayHighlighting(bl);
        FontState fontState = SyntaxPrefManager.readCommandFontState(preferences);
        syntaxEditorState.setCommandsFontState(fontState);
        fontState = SyntaxPrefManager.readSubCommandFontState(preferences);
        syntaxEditorState.setSubCommandsFontState(fontState);
        fontState = SyntaxPrefManager.readKeywordFontState(preferences);
        syntaxEditorState.setKeywordsFontState(fontState);
        fontState = SyntaxPrefManager.readQuoteFontState(preferences);
        syntaxEditorState.setQuotesFontState(fontState);
        fontState = SyntaxPrefManager.readValueFontState(preferences);
        syntaxEditorState.setValueFontState(fontState);
        fontState = SyntaxPrefManager.readCommentsFontState(preferences);
        syntaxEditorState.setCommentsFontState(fontState);
        bl = preferences.getBoolean("display_validation_color_coding", true);
        syntaxEditorState.setDisplayValidationColoring(bl);
        bl = preferences.getBoolean("syntax_optimize_r_to_l", false);
        syntaxEditorState.setOptimizeRtoL(bl);
        bl = preferences.getBoolean("syntax_paste_at_cursor", false);
        syntaxEditorState.setPasteAtCursor(bl);
        fontState = SyntaxPrefManager.readErrorCommandFontState(preferences);
        syntaxEditorState.setErrorCommandsFontState(fontState);
        fontState = SyntaxPrefManager.readErrorWithinCommandFontState(preferences);
        syntaxEditorState.setErrorWithinCommandsFontState(fontState);
        bl = preferences.getBoolean("auto_display_autocomplete", true);
        syntaxEditorState.setAutoCompleteActive(bl);
        bl = preferences.getBoolean("syntax_display_line_nums", true);
        syntaxEditorState.setDisplayLineNums(bl);
        bl = preferences.getBoolean("syntax_display_command_spans", true);
        syntaxEditorState.setDisplayCommandSpans(bl);
        bl = preferences.getBoolean("syntax_display_nav_pane", true);
        syntaxEditorState.setDisplayNavigationPane(bl);
        bl = preferences.getBoolean("syntax_auto_open_err_pane", true);
        syntaxEditorState.setAutoDisplayErrorPane(bl);
        int n = preferences.getInt("syntax_indent_size", 4);
        syntaxEditorState.setIndentSize(n);
        return syntaxEditorState;
    }

    private static FontState readCommandFontState(Preferences preferences) {
        FontState fontState = new FontState();
        boolean bl = preferences.getBoolean("syntax_command_is_bold", true);
        fontState.setBold(bl);
        bl = preferences.getBoolean("syntax_command_is_italic", false);
        fontState.setItalic(bl);
        bl = preferences.getBoolean("syntax_command_is_underline", false);
        fontState.setUnderline(bl);
        int n = preferences.getInt("syntax_command_color", PrefDefaults.DEF_SYNTAX_COMMAND_COLOR);
        fontState.setColor(new Color(n));
        n = preferences.getInt("syntax_command_bgcolor", -1);
        fontState.setBGColor(new Color(n));
        return fontState;
    }

    private static FontState readSubCommandFontState(Preferences preferences) {
        FontState fontState = new FontState();
        boolean bl = preferences.getBoolean("syntax_subcommand_is_bold", false);
        fontState.setBold(bl);
        bl = preferences.getBoolean("syntax_subcommand_is_italic", false);
        fontState.setItalic(bl);
        bl = preferences.getBoolean("syntax_subcommand_is_underline", false);
        fontState.setUnderline(bl);
        int n = preferences.getInt("syntax_subcommand_color", PrefDefaults.DEF_SYNTAX_SUBCOMMAND_COLOR);
        fontState.setColor(new Color(n));
        n = preferences.getInt("syntax_subcommand_bgcolor", -1);
        fontState.setBGColor(new Color(n));
        return fontState;
    }

    private static FontState readKeywordFontState(Preferences preferences) {
        FontState fontState = new FontState();
        boolean bl = preferences.getBoolean("syntax_keyword_is_bold", false);
        fontState.setBold(bl);
        bl = preferences.getBoolean("syntax_keyword_is_italic", false);
        fontState.setItalic(bl);
        bl = preferences.getBoolean("syntax_keyword_is_underline", false);
        fontState.setUnderline(bl);
        int n = preferences.getInt("syntax_keyword_color", PrefDefaults.DEF_SYNTAX_KEYWORD_COLOR);
        fontState.setColor(new Color(n));
        n = preferences.getInt("syntax_keyword_bgcolor", -1);
        fontState.setBGColor(new Color(n));
        return fontState;
    }

    private static FontState readQuoteFontState(Preferences preferences) {
        FontState fontState = new FontState();
        boolean bl = preferences.getBoolean("syntax_quote_is_bold", false);
        fontState.setBold(bl);
        bl = preferences.getBoolean("syntax_quote_is_italic", false);
        fontState.setItalic(bl);
        bl = preferences.getBoolean("syntax_quote_is_underline", false);
        fontState.setUnderline(bl);
        int n = preferences.getInt("syntax_quote_color", PrefDefaults.DEF_SYNTAX_QUOTE_COLOR);
        fontState.setColor(new Color(n));
        n = preferences.getInt("syntax_quote_bgcolor", -1);
        fontState.setBGColor(new Color(n));
        return fontState;
    }

    private static FontState readValueFontState(Preferences preferences) {
        FontState fontState = new FontState();
        boolean bl = preferences.getBoolean("syntax_value_is_bold", false);
        fontState.setBold(bl);
        bl = preferences.getBoolean("syntax_value_is_italic", false);
        fontState.setItalic(bl);
        bl = preferences.getBoolean("syntax_value_is_underline", false);
        fontState.setUnderline(bl);
        int n = preferences.getInt("syntax_value_color", PrefDefaults.DEF_SYNTAX_VALUE_COLOR);
        fontState.setColor(new Color(n));
        n = preferences.getInt("syntax_value_bgcolor", -1);
        fontState.setBGColor(new Color(n));
        return fontState;
    }

    private static FontState readCommentsFontState(Preferences preferences) {
        FontState fontState = new FontState();
        boolean bl = preferences.getBoolean("syntax_comments_is_bold", false);
        fontState.setBold(bl);
        bl = preferences.getBoolean("syntax_comments_is_italic", false);
        fontState.setItalic(bl);
        bl = preferences.getBoolean("syntax_comments_is_underline", false);
        fontState.setUnderline(bl);
        int n = preferences.getInt("syntax_comments_color", PrefDefaults.DEF_SYNTAX_COMMENTS_COLOR);
        fontState.setColor(new Color(n));
        n = preferences.getInt("syntax_comments_bgcolor", -1);
        fontState.setBGColor(new Color(n));
        return fontState;
    }

    private static FontState readErrorCommandFontState(Preferences preferences) {
        FontState fontState = new FontState();
        boolean bl = preferences.getBoolean("syntax_err_command_is_bold", true);
        fontState.setBold(bl);
        bl = preferences.getBoolean("syntax_err_command_is_italic", false);
        fontState.setItalic(bl);
        bl = preferences.getBoolean("syntax_err_command_is_underline", false);
        fontState.setUnderline(bl);
        int n = preferences.getInt("syntax_err_command_color", PrefDefaults.DEF_SYNTAX_ERR_COMMAND_COLOR);
        fontState.setColor(new Color(n));
        n = preferences.getInt("syntax_err_command_bgcolor", -1);
        fontState.setBGColor(new Color(n));
        return fontState;
    }

    private static FontState readErrorWithinCommandFontState(Preferences preferences) {
        FontState fontState = new FontState();
        boolean bl = preferences.getBoolean("syntax_err_within_command_is_bold", false);
        fontState.setBold(bl);
        bl = preferences.getBoolean("syntax_err_within_command_is_italic", false);
        fontState.setItalic(bl);
        bl = preferences.getBoolean("syntax_err_within_command_is_underline", false);
        fontState.setUnderline(bl);
        int n = preferences.getInt("syntax_err_within_command_color", PrefDefaults.DEF_SYNTAX_ERR_WITHIN_COMMAND_COLOR);
        fontState.setColor(new Color(n));
        n = preferences.getInt("syntax_err_within_command_bgcolor", -1);
        fontState.setBGColor(new Color(n));
        return fontState;
    }

    public static void savePrefs(SyntaxEditorState syntaxEditorState) {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options").node("syntax_editor");
        preferences.putBoolean("display_syntax_color_coding", syntaxEditorState.isDisplayHighlighting());
        SyntaxPrefManager.saveCommandFontState(syntaxEditorState, preferences);
        SyntaxPrefManager.saveSubCommandFontState(syntaxEditorState, preferences);
        SyntaxPrefManager.saveKeywordFontState(syntaxEditorState, preferences);
        SyntaxPrefManager.saveQuoteFontState(syntaxEditorState, preferences);
        SyntaxPrefManager.saveValueFontState(syntaxEditorState, preferences);
        SyntaxPrefManager.saveCommentsFontState(syntaxEditorState, preferences);
        preferences.putBoolean("display_validation_color_coding", syntaxEditorState.isDisplayValidationColoring());
        preferences.putBoolean("syntax_optimize_r_to_l", syntaxEditorState.isOptimizeRtoL());
        preferences.putBoolean("syntax_paste_at_cursor", syntaxEditorState.isPasteAtCursor());
        SyntaxPrefManager.saveErrorCommandFontState(syntaxEditorState, preferences);
        SyntaxPrefManager.saveErrorWithinCommandFontState(syntaxEditorState, preferences);
        preferences.putBoolean("auto_display_autocomplete", syntaxEditorState.isAutoCompleteActive());
        preferences.putBoolean("syntax_display_line_nums", syntaxEditorState.isDisplayLineNums());
        preferences.putBoolean("syntax_display_command_spans", syntaxEditorState.isDisplayCommandSpans());
        preferences.putBoolean("syntax_display_nav_pane", syntaxEditorState.isDisplayNavigationPane());
        preferences.putBoolean("syntax_auto_open_err_pane", syntaxEditorState.isAutoDisplayErrorPane());
        preferences.putInt("syntax_indent_size", syntaxEditorState.getIndentSize());
    }

    private static void saveCommandFontState(SyntaxEditorState syntaxEditorState, Preferences preferences) {
        FontState fontState = syntaxEditorState.getCommandsFontState();
        preferences.putBoolean("syntax_command_is_bold", fontState.isBold());
        preferences.putBoolean("syntax_command_is_italic", fontState.isItalic());
        preferences.putBoolean("syntax_command_is_underline", fontState.isUnderline());
        preferences.putInt("syntax_command_color", fontState.getColor().getRGB());
        preferences.putInt("syntax_command_bgcolor", fontState.getBGColor().getRGB());
    }

    private static void saveSubCommandFontState(SyntaxEditorState syntaxEditorState, Preferences preferences) {
        FontState fontState = syntaxEditorState.getSubCommandsFontState();
        preferences.putBoolean("syntax_subcommand_is_bold", fontState.isBold());
        preferences.putBoolean("syntax_subcommand_is_italic", fontState.isItalic());
        preferences.putBoolean("syntax_subcommand_is_underline", fontState.isUnderline());
        preferences.putInt("syntax_subcommand_color", fontState.getColor().getRGB());
        preferences.putInt("syntax_subcommand_bgcolor", fontState.getBGColor().getRGB());
    }

    private static void saveKeywordFontState(SyntaxEditorState syntaxEditorState, Preferences preferences) {
        FontState fontState = syntaxEditorState.getKeywordsFontState();
        preferences.putBoolean("syntax_keyword_is_bold", fontState.isBold());
        preferences.putBoolean("syntax_keyword_is_italic", fontState.isItalic());
        preferences.putBoolean("syntax_keyword_is_underline", fontState.isUnderline());
        preferences.putInt("syntax_keyword_color", fontState.getColor().getRGB());
        preferences.putInt("syntax_keyword_bgcolor", fontState.getBGColor().getRGB());
    }

    private static void saveQuoteFontState(SyntaxEditorState syntaxEditorState, Preferences preferences) {
        FontState fontState = syntaxEditorState.getQuotesFontState();
        preferences.putBoolean("syntax_quote_is_bold", fontState.isBold());
        preferences.putBoolean("syntax_quote_is_italic", fontState.isItalic());
        preferences.putBoolean("syntax_quote_is_underline", fontState.isUnderline());
        preferences.putInt("syntax_quote_color", fontState.getColor().getRGB());
        preferences.putInt("syntax_quote_bgcolor", fontState.getBGColor().getRGB());
    }

    private static void saveValueFontState(SyntaxEditorState syntaxEditorState, Preferences preferences) {
        FontState fontState = syntaxEditorState.getValueFontState();
        preferences.putBoolean("syntax_value_is_bold", fontState.isBold());
        preferences.putBoolean("syntax_value_is_italic", fontState.isItalic());
        preferences.putBoolean("syntax_value_is_underline", fontState.isUnderline());
        preferences.putInt("syntax_value_color", fontState.getColor().getRGB());
        preferences.putInt("syntax_value_bgcolor", fontState.getBGColor().getRGB());
    }

    private static void saveCommentsFontState(SyntaxEditorState syntaxEditorState, Preferences preferences) {
        FontState fontState = syntaxEditorState.getCommentsFontState();
        preferences.putBoolean("syntax_comments_is_bold", fontState.isBold());
        preferences.putBoolean("syntax_comments_is_italic", fontState.isItalic());
        preferences.putBoolean("syntax_comments_is_underline", fontState.isUnderline());
        preferences.putInt("syntax_comments_color", fontState.getColor().getRGB());
        preferences.putInt("syntax_comments_bgcolor", fontState.getBGColor().getRGB());
    }

    private static void saveErrorCommandFontState(SyntaxEditorState syntaxEditorState, Preferences preferences) {
        FontState fontState = syntaxEditorState.getErrorCommandsFontState();
        preferences.putBoolean("syntax_err_command_is_bold", fontState.isBold());
        preferences.putBoolean("syntax_err_command_is_italic", fontState.isItalic());
        preferences.putBoolean("syntax_err_command_is_underline", fontState.isUnderline());
        preferences.putInt("syntax_err_command_color", fontState.getColor().getRGB());
        preferences.putInt("syntax_err_command_bgcolor", fontState.getBGColor().getRGB());
    }

    private static void saveErrorWithinCommandFontState(SyntaxEditorState syntaxEditorState, Preferences preferences) {
        FontState fontState = syntaxEditorState.getErrorWithinCommandsFontState();
        preferences.putBoolean("syntax_err_within_command_is_bold", fontState.isBold());
        preferences.putBoolean("syntax_err_within_command_is_italic", fontState.isItalic());
        preferences.putBoolean("syntax_err_within_command_is_underline", fontState.isUnderline());
        preferences.putInt("syntax_err_within_command_color", fontState.getColor().getRGB());
        preferences.putInt("syntax_err_within_command_bgcolor", fontState.getBGColor().getRGB());
    }
}

