/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.syntax;

import com.ibm.json.java.JSONObject;
import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.ILocaleListener;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.ICoreDocument;
import com.spss.java_client.core.documents.ICoreDocumentUIAgent;
import com.spss.java_client.core.documents.data.DataDocument;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.syntax.ISyntaxDocListener;
import com.spss.java_client.core.documents.syntax.ISyntaxDocument;
import com.spss.java_client.core.documents.syntax.ISyntaxDocumentUIAgent;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.core.server.messages.spsswmsg.SpsswMsgSyntaxError;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controlbar.BaseToolbar;
import com.spss.java_client.ui.dialogs.base.edit.find.ISearchProxy;
import com.spss.java_client.ui.dialogs.base.edit.find.SyntaxFindDlg;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.StatusBar;
import com.spss.java_client.ui.doc_types.actions.ActivateDatasetAction;
import com.spss.java_client.ui.doc_types.actions.NewSyntaxAction;
import com.spss.java_client.ui.doc_types.actions.OpenSyntaxAction;
import com.spss.java_client.ui.doc_types.actions.SaveAction;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.actions.data.WndSplitAction;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.java_client.ui.doc_types.doc_util.MenuCache;
import com.spss.java_client.ui.doc_types.doc_util.MenuItemCache;
import com.spss.java_client.ui.doc_types.doc_util.MenuMgr;
import com.spss.java_client.ui.doc_types.output.IViewerWindow;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerTreePane;
import com.spss.java_client.ui.doc_types.syntax.SyntaxPrefManager;
import com.spss.java_client.ui.doc_types.syntax.SyntaxStatusBar;
import com.spss.java_client.ui.doc_types.syntax.SyntaxView;
import com.spss.java_client.ui.doc_types.syntax.undo.SyntaxUndoManager;
import com.spss.java_client.ui.print.SpssPrintable;
import com.spss.java_client.ui.print.SyntaxViewPrintable;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.undo.SpssUndoManager;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.syntaxeditor.SyntaxCommand;
import com.spss.shared.syntaxeditor.SyntaxHighlightDocument;
import com.spss.shared.syntaxeditor.shared_objects.SyntaxEditorState;
import com.spss.uitools.clipboard.AppClipboard;
import com.spss.uitools.clipboard.StringWrapper;
import com.spss.uitools.util.WindowUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SyntaxFrame
extends SpssFrame
implements ITopWindow,
ISyntaxDocumentUIAgent,
ActionListener,
ILocaleListener,
DocumentListener {
    private static SyntaxFindDlg sSearchDialog = null;
    protected SyntaxView mView = null;
    protected ISyntaxDocument mDocument = null;
    protected JComboBox mDatasetCombo;
    private String mActiveDatasetName = null;
    private boolean mComboUpdate;
    private String mSelectedStr;
    private static MenuCache mMenuTreeCache = new MenuCache(null);
    private static Vector<String> mDeletedAddOnItems = new Vector();
    private static long mSyntaxWindowID = 1L;

    public static SyntaxFrame createSyntaxFrame(boolean bl) {
        SyntaxFrame syntaxFrame = null;
        try {
            syntaxFrame = new SyntaxFrame();
            SpssFrameMgr.getSpssFrameMgr().positionNewFrame(syntaxFrame);
            if (bl) {
                syntaxFrame.setVisible(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return syntaxFrame;
    }

    @Override
    public ICoreDocument getCoreDocument() {
        return this.mDocument;
    }

    public void setCoreDocument(ISyntaxDocument iSyntaxDocument) {
        this.mDocument = iSyntaxDocument;
        this.mDocument.setDocumentListener((ISyntaxDocListener)this.mView);
        this.mDocument.setUIAgent((ICoreDocumentUIAgent)this);
        SyntaxHighlightDocument syntaxHighlightDocument = this.mDocument.getCoreSyntaxDocument();
        syntaxHighlightDocument.addDocumentListener((DocumentListener)this);
        this.mView.updateNewCoreSyntaxDocument(syntaxHighlightDocument);
        this.updateTitleBar();
    }

    @Override
    public DocType docType() {
        return DocType.SYNTAX_DOC;
    }

    public void setModified(boolean bl) {
        if (this.mDocument != null && this.mDocument.getModifiedFlag() != bl) {
            this.mDocument.setModifiedFlag(bl);
            this.updateTitleBar();
            SpssAction spssAction = (SpssAction)this.mToolbarActionMap.get("file_save");
            if (spssAction != null) {
                spssAction.setEnabled(bl);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        if (this.mComboUpdate) {
            return;
        }
        int n = this.mDatasetCombo.getSelectedIndex();
        if (n > -1 && (string = (String)this.mDatasetCombo.getItemAt(n)) != null && this.mActiveDatasetName != null && !this.mActiveDatasetName.equals(string)) {
            ActivateDatasetAction.activateDataset(string);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateDatasetCombo() {
        this.mComboUpdate = true;
        this.mDatasetCombo.removeAllItems();
        DataMgr dataMgr = DataMgr.getDataMgr();
        int n = -1;
        LocallyUniqueId locallyUniqueId = dataMgr.getActiveDocumentId();
        if (locallyUniqueId == null) {
            locallyUniqueId = dataMgr.getActiveBackendDocumentId();
        }
        if (locallyUniqueId == null) {
            if (dataMgr.getDataDocumentCount() <= 0) return;
            DataDocument dataDocument = (DataDocument)dataMgr.getDataDocument(0);
            String string = dataDocument.getDatasetName();
            if (string == null || string.length() == 0) {
                this.mDatasetCombo.addItem(ResUtil.getString("IDS_DATASET_UNNAMED"));
            } else {
                this.mDatasetCombo.addItem(string);
            }
            n = 0;
            ActivateDatasetAction.activateDataset(string);
        } else {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            n = dataMgr.getDataSourceNames(locallyUniqueId, arrayList, arrayList2);
            if (arrayList.size() > 0) {
                for (String string : arrayList) {
                    if (string == null || string.length() == 0) {
                        this.mDatasetCombo.addItem(ResUtil.getString("IDS_DATASET_UNNAMED"));
                        continue;
                    }
                    this.mDatasetCombo.addItem(string);
                }
            }
            if (arrayList2.size() > 0) {
                this.mActiveDatasetName = (String)arrayList2.get(0);
            }
        }
        if (this.mDatasetCombo.getItemCount() > 0) {
            this.mDatasetCombo.setSelectedIndex(n);
        }
        this.mComboUpdate = false;
    }

    @Override
    public boolean saveModified() {
        if (this.mDocument != null && this.mDocument.getModifiedFlag() && this.mDocument.getPromptToSaveFlag()) {
            if (this.getExtendedState() == 1) {
                this.setExtendedState(0);
            }
            Toolkit.getDefaultToolkit().beep();
            String string = this.mDocument.getFileSpec() == null ? this.mDocument.getDocName() : this.mDocument.getFileSpec().getPath();
            String string2 = String.format(ResUtil.getString("ERR_SYNTAX_SAVE_QUERY"), string);
            String string3 = VersionInfo.getAppVersionString();
            int n = SpssAlertOptionPane.showConfirmDialog(this, string2, string3, SpssAlertOptionPane.OptionType.YES_NO_CANCEL_OPTION);
            if (n == 3 || n == -1) {
                return false;
            }
            if (n == 1 && !DocUtil.saveCoreDocument(this)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void saveFrameSize() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("doc_types").node("syntax");
        if (this.getExtendedState() == 6) {
            preferences2.putInt("syntax_editor_height", -1);
            preferences2.putInt("syntax_editor_width", -1);
        } else {
            Dimension dimension = this.getSize();
            preferences2.putInt("syntax_editor_height", (int)dimension.getHeight());
            preferences2.putInt("syntax_editor_width", (int)dimension.getWidth());
        }
    }

    @Override
    public void updateTitleBar() {
        this.setSyntaxDlgTitle();
        if (this.mDocument != null) {
            try {
                if (this.mDocument.getFileSpec() != null) {
                    String string = this.mDocument.getFileSpec().getCanonicalPath();
                    this.getRootPane().putClientProperty("Window.documentFile", new File(string));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void setSyntaxDlgTitle() {
        boolean bl = false;
        String string = "";
        if (this.mDocument != null) {
            string = this.mDocument.getDocName();
            bl = this.mDocument.getModifiedFlag();
        }
        String string2 = String.format(ComponentState.getSPSSLocale(), ResUtil.getString("IDS_SPSS_SYNTAX_VIEWER"), VersionInfo.getProductNickName());
        String string3 = "";
        if (bl) {
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                string3 = "*";
            } else {
                String string4 = UIManager.getLookAndFeel().getClass().getName();
                if (string4.contains("SpssPlasticXPLookAndFeel")) {
                    string3 = "*";
                }
            }
            this.getRootPane().putClientProperty("Window.documentModified", Boolean.TRUE);
        } else {
            this.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
        }
        String string5 = string.length() > 0 ? string3 + string + " - " + string2 : string2;
        this.setTitle(string5);
    }

    @Override
    public void performClose() {
        boolean bl = false;
        if (this.mDocument != null) {
            if (!this.saveModified()) {
                return;
            }
            if (sSearchDialog != null && sSearchDialog.getParent() == this && sSearchDialog.isVisible()) {
                bl = true;
            }
            SyntaxHighlightDocument syntaxHighlightDocument = this.mDocument.getCoreSyntaxDocument();
            syntaxHighlightDocument.removeDocumentListener((DocumentListener)this);
            ISyntaxDocument iSyntaxDocument = this.mDocument;
            this.mDocument = null;
            SyntaxMgr.getSyntaxMgr().closeSyntaxDocument(iSyntaxDocument);
            this.mPrintOptions = null;
            if (this.mView != null) {
                this.mView.performClose();
                this.remove(this.mView);
                this.mView = null;
            }
        }
        if (this.mDatasetCombo != null) {
            this.mDatasetCombo.removeActionListener(this);
        }
        this.saveFrameSize();
        this.setVisible(false);
        super.performClose();
        this.dispose();
        if (bl) {
            SpssFrameMgr.getSpssFrameMgr().reparentSearchDialog(DocType.SYNTAX_DOC);
        }
    }

    public SyntaxFindDlg getSearchDialog() {
        if (sSearchDialog == null) {
            sSearchDialog = new SyntaxFindDlg(this, (ISearchProxy)this.mView);
        } else if (sSearchDialog.getParent() != this) {
            sSearchDialog.dispose();
            sSearchDialog = new SyntaxFindDlg(this, (ISearchProxy)this.mView);
        }
        return sSearchDialog;
    }

    @Override
    public void resetSearchDialog() {
        if (sSearchDialog != null) {
            sSearchDialog.dispose();
            sSearchDialog = null;
        }
    }

    public void pasteSyntax(String string) {
        SyntaxEditorState syntaxEditorState = SyntaxPrefManager.getSyntaxEditorPreferences();
        boolean bl = syntaxEditorState.isPasteAtCursor();
        this.mView.pasteSyntax(string, bl);
    }

    public void pasteSyntax(String string, boolean bl) {
        this.mView.pasteSyntax(string, bl);
    }

    public void pasteSyntax(String string, boolean bl, boolean bl2) {
        this.mView.pasteSyntax(string, bl, bl2);
    }

    public String getSyntax(SyntaxSegment syntaxSegment) {
        return this.mView.toString(syntaxSegment);
    }

    public String getCommandNameForSyntaxSegment(SyntaxSegment syntaxSegment) {
        return this.mView.getCommandNameForSyntaxSegment(syntaxSegment);
    }

    public String getCommandHelpFileNameForSyntaxSegment(SyntaxSegment syntaxSegment) {
        return this.mView.getCommandHelpFileNameForSyntaxSegment(syntaxSegment);
    }

    public String processRunSyntax(SyntaxSegment syntaxSegment) {
        return this.mView.processRunSyntax(syntaxSegment);
    }

    public String processRunSyntaxToGetExtensionHelp(SyntaxSegment syntaxSegment) {
        return this.mView.processRunSyntaxToGetExtensionHelp(syntaxSegment);
    }

    public ISyntaxDocument getDocument() {
        return this.mDocument;
    }

    @Override
    public ViewerDocument getViewerDocument() {
        return null;
    }

    @Override
    public IViewerWindow getIViewerWindow() {
        return null;
    }

    @Override
    public void dispose() {
        ComponentState.removeLocaleListener((ILocaleListener)this);
        super.dispose();
    }

    @Override
    public SpssPrintable getPrintable() {
        this.mPrintOptions.setPrintMode(SpssPrintable.PrintMode.NORMAL);
        SyntaxViewPrintable syntaxViewPrintable = new SyntaxViewPrintable(this, this.mPrintOptions);
        syntaxViewPrintable.setPrintSelection(this.mView.isAnySelected());
        return syntaxViewPrintable;
    }

    @Override
    public void doCopy() {
        AppClipboard appClipboard = AppClipboard.getAppClipboard();
        this.mSelectedStr = this.mView.getSelectedText();
        appClipboard.addClipboardData(AppClipboard.STRING_FLAVOR, (Object)this.mSelectedStr, true);
    }

    @Override
    public void doPaste() {
        try {
            String string;
            AppClipboard appClipboard = AppClipboard.getAppClipboard();
            Object object = appClipboard.getClipboardData(AppClipboard.DATAVIEW_STRING_FLAVOR);
            String string2 = string = object instanceof StringWrapper ? object.toString() : null;
            if (string == null) {
                object = appClipboard.getClipboardData(AppClipboard.STRING_FLAVOR);
                String string3 = string = object instanceof String ? object.toString() : null;
            }
            if (string != null) {
                string = SyntaxMgr.doOpenNewLineConversion((String)string);
                this.mView.pasteSyntaxAction(string);
                this.updateToolbarEnableStatus();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void doCut() {
        this.doCopy();
        this.doDelete();
    }

    @Override
    public void doDelete() {
        this.mSelectedStr = this.mView.getSelectedText();
        this.mView.replace(this.mSelectedStr, "", true);
    }

    public void doSelectAll() {
        this.mView.setSelectAll();
    }

    @Override
    public void doGridFont() {
        this.mView.changeFont();
    }

    public SyntaxView getSyntaxView() {
        return this.mView;
    }

    public String getSelectedString() {
        return this.mSelectedStr;
    }

    @Override
    public void pack() {
        super.pack();
        if (sSearchDialog != null) {
            sSearchDialog.dispose();
            sSearchDialog = null;
        }
    }

    @Override
    public void updateToolbarEnableStatus() {
        if (SwingUtilities.isEventDispatchThread()) {
            super.updateToolbarEnableStatus();
            this.updateDatasetCombo();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SyntaxFrame.super.updateToolbarEnableStatus();
                    SyntaxFrame.this.updateDatasetCombo();
                }
            });
        }
    }

    @Override
    public void refreshToolbar() {
        super.refreshToolbar();
        this.addActiveDatasetToToolsToolbar();
    }

    @Override
    public void notifySpssLocaleChange(Locale locale) {
    }

    @Override
    public void notifyCharsetChange(String string) {
        this.mView.notifyCharsetChange();
    }

    @Override
    public void notifyILangChange(Locale locale) {
        super.notifyILangChange(locale);
        this.mView.notifyILangChange(locale);
    }

    @Override
    public void setVisible(boolean bl) {
        if (CommandLine.isExternalCaller()) {
            super.setVisible(false);
        } else {
            super.setVisible(bl);
            if (bl) {
                this.mView.getSyntaxMasterPanel().positionErrorPaneAtStart();
            }
        }
    }

    public SyntaxFrame() throws HeadlessException {
        super(String.format(ComponentState.getSPSSLocale(), ResUtil.getString("IDS_SPSS_SYNTAX_VIEWER"), VersionInfo.getProductNickName()), "syntax");
        WindowUtil.setMacWindowCanFullScreen((Window)this, (boolean)true);
        this.setDefaultCloseOperation(0);
        this.addActiveDatasetToToolsToolbar();
        this.mView = new SyntaxView(this, ++mSyntaxWindowID);
        this.getContentPane().add((Component)this.mView, "Center");
        this.updateTitleBar();
        ComponentState.addLocaleListener((ILocaleListener)this);
        InputMap inputMap = this.rootPane.getInputMap(2);
        ActionMap actionMap = this.rootPane.getActionMap();
        KeyStroke keyStroke = ResUtil.getShortcut("IDK_NEW_WINDOW");
        NewSyntaxAction newSyntaxAction = new NewSyntaxAction("file_new_syntax");
        inputMap.put(keyStroke, newSyntaxAction.getValue("Name"));
        actionMap.put(newSyntaxAction.getValue("Name"), newSyntaxAction);
        KeyStroke keyStroke2 = ResUtil.getShortcut("IDK_OPEN_WINDOW");
        OpenSyntaxAction openSyntaxAction = new OpenSyntaxAction("file_open_syntax");
        inputMap.put(keyStroke2, openSyntaxAction.getValue("Name"));
        actionMap.put(openSyntaxAction.getValue("Name"), openSyntaxAction);
        KeyStroke keyStroke3 = ResUtil.getShortcut("file_save");
        SaveAction saveAction = new SaveAction("file_save");
        inputMap.put(keyStroke3, saveAction.getValue("Name"));
        actionMap.put(saveAction.getValue("Name"), saveAction);
        this.setToolbarButtonState();
        this.pack();
    }

    private void setToolbarButtonState() {
        Component[] componentArray;
        for (Component component : componentArray = this.mTBPanelNorth.getComponents()) {
            if (!(component instanceof BaseToolbar)) continue;
            ((BaseToolbar)component).checkButton("syntax_honor_breakpoints", true);
        }
    }

    @Override
    protected void buildMenuBar() {
        try {
            Preferences preferences;
            String string;
            Preferences preferences2 = PrefsMgr.getPrefsMgr().getUIUserPrefs();
            if (preferences2.nodeExists(this.mRootMenuPrefPath + "/0;File") && (string = (preferences = preferences2.node(this.mRootMenuPrefPath + "/0;File")).get("14", "")).equals("file_cache_data")) {
                Preferences preferences3 = preferences2.node(this.mRootMenuPrefPath);
                preferences3.removeNode();
            }
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        super.buildMenuBar();
    }

    @Override
    protected boolean doActivate() {
        return true;
    }

    @Override
    protected void saveMenuBarDefaultPreferences() throws BackingStoreException {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node(this.mRootMenuPrefPath);
        preferences2.removeNode();
        preferences2 = preferences.node(this.mRootMenuPrefPath);
        Preferences preferences3 = PrefsMgr.getPrefsMgr().getUISystemPrefs();
        Preferences preferences4 = null;
        if (preferences3 != null && preferences3.nodeExists(this.mRootMenuPrefPath)) {
            preferences4 = preferences3.node(this.mRootMenuPrefPath);
        }
        Preferences preferences5 = preferences2.node("0;File");
        MenuMgr.saveSyntaxFileMenuDefaultPreferences(preferences5);
        Preferences preferences6 = preferences2.node("1;Edit");
        MenuMgr.saveSyntaxEditDefaultPreferences(preferences6);
        Preferences preferences7 = preferences2.node("2;View");
        MenuMgr.saveViewSyntaxPreferences(preferences7);
        Preferences preferences8 = preferences2.node("3;Data");
        MenuMgr.saveSyntaxDataMenuDefaultPreferences(preferences8);
        Preferences preferences9 = preferences2.node("4;Transform");
        MenuMgr.saveTransformDefaultPreferences(preferences9);
        Preferences preferences10 = preferences2.node("5;Analyze");
        this.copyMenuItemFromInstaller(preferences4, preferences10, "5;Analyze");
        MenuMgr.saveAnalyzeDefaultPreferences(preferences10);
        Preferences preferences11 = preferences2.node("7;Graphs");
        MenuMgr.saveGraphsDefaultPreferences(preferences11);
        Preferences preferences12 = preferences2.node("8;Utilities");
        MenuMgr.saveSyntaxUtilitiesDefaultPreferences(preferences12);
        Preferences preferences13 = preferences2.node("9;Run");
        MenuMgr.saveRunDefaultPreferences(preferences13);
        Preferences preferences14 = preferences2.node("10;Tools");
        MenuMgr.saveToolsDefaultPreferences(preferences14);
        Preferences preferences15 = preferences2.node("12;Extensions");
        MenuMgr.saveExtensionPreferences(preferences15);
        Preferences preferences16 = preferences2.node("13;Window");
        MenuMgr.saveSyntaxEditorWindowDefaultPreferences(preferences16);
        Preferences preferences17 = preferences2.node("14;Help");
        this.copyMenuItemFromInstaller(preferences4, preferences17, "14;Help");
        MenuMgr.saveHelpDefaultPreferences(preferences17);
    }

    @Override
    protected void setupStatusBar() {
        this.mStatusBarPanel = new SyntaxStatusBar();
    }

    @Override
    protected void setupUndoManager() {
        this.mUndoManager = new SyntaxUndoManager(this);
        this.mUndoManager.setLimit(10);
    }

    @Override
    public SpssUndoManager getUndoManager() {
        return this.mUndoManager;
    }

    protected void addActiveDatasetToToolsToolbar() {
        BaseToolbar baseToolbar = this.getToolbar("tbsyn2");
        this.createDatasetCombo();
        if (baseToolbar != null) {
            int n = 4;
            JLabel jLabel = new JLabel(ResUtil.getString("IDS_DATASET_COMBO_ACTIVE"));
            baseToolbar.add(Box.createHorizontalStrut(n));
            baseToolbar.add(jLabel);
            baseToolbar.add(Box.createHorizontalStrut(n));
            baseToolbar.add(this.mDatasetCombo);
            baseToolbar.add(Box.createHorizontalStrut(n));
        }
    }

    private void createDatasetCombo() {
        if (this.mDatasetCombo == null) {
            this.mDatasetCombo = new JComboBox();
            this.mDatasetCombo.addActionListener(this);
        }
    }

    private BaseToolbar getToolbar(String string) {
        Component[] componentArray;
        BaseToolbar baseToolbar = null;
        JPanel jPanel = this.getToolBarPanel();
        for (Component component : componentArray = jPanel.getComponents()) {
            BaseToolbar baseToolbar2;
            String string2;
            if (!(component instanceof BaseToolbar) || !(string2 = (baseToolbar2 = (BaseToolbar)component).getPreferencesNode()).equals(string)) continue;
            baseToolbar = baseToolbar2;
            break;
        }
        return baseToolbar;
    }

    void updateLineColumnNumber(int n, int n2) {
        final String string = "ln " + n + " " + "Col " + n2;
        if (SwingUtilities.isEventDispatchThread()) {
            this.mStatusBarPanel.putPaneMessage(StatusBar.StatusPane.lineColumnPane, string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){
                String mMessage;
                {
                    this.mMessage = string;
                }

                @Override
                public void run() {
                    SyntaxFrame.this.mStatusBarPanel.putPaneMessage(StatusBar.StatusPane.lineColumnPane, this.mMessage);
                }
            });
        }
    }

    public void designateSyntaxFrame() {
        SpssFrameMgr.getSpssFrameMgr().designateWindow(this);
    }

    public void addSyntaxError(SpsswMsgSyntaxError spsswMsgSyntaxError) {
        this.mView.addSyntaxError(spsswMsgSyntaxError);
    }

    public void addRemoveSyntaxCommands(ArrayList<SyntaxCommand> arrayList, boolean bl) {
        this.mView.addRemoveSyntaxCommands(arrayList, bl);
    }

    public long getSyntaxWindowID() {
        return this.mView.getSytaxWindowID();
    }

    public void closeDocument() {
        this.performClose();
    }

    @Override
    public MenuItemCache getMenuTreeCache() {
        return mMenuTreeCache;
    }

    @Override
    public void setMenuTreeCache(MenuCache menuCache) {
        mMenuTreeCache = menuCache;
        try {
            this.saveMenuBarPreferences();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        this.refreshMenuBar();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this.mView.getSyntaxMasterPanel().isDoOnlyBaseDocProcessing()) {
            this.documentChangeUpdate();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (!this.mView.getSyntaxMasterPanel().isDoOnlyBaseDocProcessing()) {
            this.documentChangeUpdate();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private void documentChangeUpdate() {
        this.processDocumentChangeUpdate();
    }

    public void processDocumentChangeUpdate() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateToolbarEnableStatus();
            this.setModified(true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SyntaxFrame.this.updateToolbarEnableStatus();
                    SyntaxFrame.this.setModified(true);
                }
            });
        }
    }

    @Override
    protected void addDeletedAddOnItem(String string) {
        mDeletedAddOnItems.add(string);
    }

    @Override
    protected Vector<String> getDeletedAddOnItem() {
        return mDeletedAddOnItems;
    }

    @Override
    public void clearDeletedAddOnItems() {
        mDeletedAddOnItems.removeAllElements();
    }

    public void clearErrorPane() {
        this.mView.clearErrorPane();
    }

    public void setHonorBreakpoints(boolean bl) {
        Component[] componentArray;
        for (Component component : componentArray = this.mTBPanelNorth.getComponents()) {
            if (!(component instanceof BaseToolbar)) continue;
            ((BaseToolbar)component).checkButton("syntax_honor_breakpoints", bl);
            this.mView.setHonorBreakpoints(bl);
        }
    }

    public void updateToolbarButtons() {
        Set set = this.mToolbarActionMap.keySet();
        for (String string : set) {
            Component[] componentArray;
            SpssAction spssAction = (SpssAction)this.mToolbarActionMap.get(string);
            if ((spssAction == null || !(spssAction.getMenuItem() instanceof JCheckBoxMenuItem)) && !(spssAction instanceof WndSplitAction)) continue;
            boolean bl = spssAction.getMenuItemCheckStatus(this);
            for (Component component : componentArray = this.mTBPanelNorth.getComponents()) {
                JToggleButton jToggleButton;
                if (!(component instanceof BaseToolbar) || (jToggleButton = ((BaseToolbar)component).findCheckButton(spssAction.getActionId())) == null) continue;
                jToggleButton.setSelected(bl);
            }
        }
    }

    public void doSyntaxDivider(boolean bl) {
        Component[] componentArray;
        for (Component component : componentArray = this.mTBPanelNorth.getComponents()) {
            if (!(component instanceof BaseToolbar)) continue;
            ((BaseToolbar)component).checkButton("window_split", bl);
            SyntaxView syntaxView = this.getSyntaxView();
            syntaxView.showDivider(bl);
        }
    }

    @Override
    public ViewerTreePane getViewerTreePane() {
        return null;
    }

    public boolean canExecuteASL() {
        return false;
    }

    public boolean executeASL(JSONObject jSONObject, Vector<JSONObject> vector) {
        return false;
    }

    public static enum SyntaxSegment {
        ALL,
        SELECTION,
        CURRENT,
        TO_END,
        STEP_FIRST_COMMAND,
        STEP_FIRST_COMMAND_IN_SELECTION,
        CONTINUE;

    }
}

