/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output.undo;

import com.spss.java_client.core.common.OutputItemAlignment;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.OutputDocument;
import com.spss.java_client.ui.doc_types.output.IViewerWindow;
import com.spss.java_client.ui.doc_types.output.TextViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.undo.UndoItemInfo;
import com.spss.java_client.ui.texteditor.SpssTextPane;
import java.util.Map;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class OutputUndoableEdit
extends AbstractUndoableEdit {
    private OutputItemAlignment mRedoAlignment;
    private Map<ViewerItem, OutputItemAlignment> mUndoAlignmentMap;
    private ViewerItem[] mFocusedItems;
    private IViewerWindow mWindow;
    private Map<IOutputItem, UndoItemInfo> mRedoMap;
    private Map<IOutputItem, UndoItemInfo> mUndoMap;
    private boolean mIsDragDrop;
    private boolean mIsAlignmentUndo;
    private boolean mIsPasteAfterUndo;

    public OutputUndoableEdit(IViewerWindow iViewerWindow, Map<IOutputItem, UndoItemInfo> map) {
        this.mWindow = iViewerWindow;
        this.mUndoMap = map;
        this.mWindow.getUndoManager().addEdit(this);
        this.mWindow.updateToolbarEnableStatus();
    }

    public OutputUndoableEdit(IViewerWindow iViewerWindow, Map<IOutputItem, UndoItemInfo> map, boolean bl) {
        this.mWindow = iViewerWindow;
        this.mUndoMap = map;
        this.mIsPasteAfterUndo = bl;
        this.mWindow.getUndoManager().addEdit(this);
        this.mWindow.updateToolbarEnableStatus();
    }

    public OutputUndoableEdit(IViewerWindow iViewerWindow, ViewerItem[] viewerItemArray, Map<ViewerItem, OutputItemAlignment> map, OutputItemAlignment outputItemAlignment) {
        this.mWindow = iViewerWindow;
        this.mFocusedItems = viewerItemArray;
        this.mUndoAlignmentMap = map;
        this.mRedoAlignment = outputItemAlignment;
        this.mIsAlignmentUndo = true;
        this.mWindow.getUndoManager().addEdit(this);
        this.mWindow.updateToolbarEnableStatus();
    }

    public OutputUndoableEdit(IViewerWindow iViewerWindow, Map<IOutputItem, UndoItemInfo> map, Map<IOutputItem, UndoItemInfo> map2, boolean bl) {
        this.mWindow = iViewerWindow;
        this.mUndoMap = map;
        this.mIsDragDrop = bl;
        this.mRedoMap = map2;
        this.mWindow.getUndoManager().addEdit(this);
        this.mWindow.updateToolbarEnableStatus();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction(true);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction(false);
    }

    @Override
    public void die() {
        super.die();
        this.cleanupOrphanedItems();
        this.mRedoAlignment = null;
        this.mUndoAlignmentMap = null;
        this.mFocusedItems = null;
        this.mWindow = null;
        this.mRedoMap = null;
        this.mUndoMap = null;
    }

    private void doAction(boolean bl) {
        if (this.mIsAlignmentUndo) {
            if (bl) {
                for (ViewerItem viewerItem : this.mFocusedItems) {
                    if (viewerItem.getComponentType() == ViewerDocument.ComponentType.log || viewerItem.getComponentType() == ViewerDocument.ComponentType.text) continue;
                    viewerItem.getCoreItem().setAlignment(this.mUndoAlignmentMap.get(viewerItem));
                    if (!(viewerItem instanceof TextViewerItem)) continue;
                    this.alignTextItem(viewerItem, this.mUndoAlignmentMap.get(viewerItem));
                }
            } else {
                for (ViewerItem viewerItem : this.mFocusedItems) {
                    if (viewerItem.getComponentType() == ViewerDocument.ComponentType.log || viewerItem.getComponentType() == ViewerDocument.ComponentType.text) continue;
                    viewerItem.getCoreItem().setAlignment(this.mRedoAlignment);
                    if (!(viewerItem instanceof TextViewerItem)) continue;
                    this.alignTextItem(viewerItem, this.mRedoAlignment);
                }
            }
        } else {
            OutputDocument outputDocument = (OutputDocument)this.mWindow.getDocument().getCoreDocument();
            for (IOutputItem iOutputItem : this.mUndoMap.keySet()) {
                IOutputItem iOutputItem2;
                UndoItemInfo undoItemInfo;
                if (bl) {
                    undoItemInfo = this.mUndoMap.get(iOutputItem);
                    iOutputItem2 = undoItemInfo.getInsertAfter();
                    if (this.mIsDragDrop) {
                        outputDocument.deleteItem(iOutputItem);
                        outputDocument.insertItem(iOutputItem, iOutputItem2, undoItemInfo.getParent() != iOutputItem2);
                        continue;
                    }
                    if (this.mIsPasteAfterUndo) {
                        outputDocument.deleteItem(iOutputItem);
                        continue;
                    }
                    outputDocument.insertItem(iOutputItem, iOutputItem2, undoItemInfo.getParent() != iOutputItem2);
                    continue;
                }
                if (this.mIsDragDrop) {
                    undoItemInfo = this.mRedoMap.get(iOutputItem);
                    outputDocument.deleteItem(iOutputItem);
                    iOutputItem2 = undoItemInfo.getInsertAfter();
                    outputDocument.insertItem(iOutputItem, iOutputItem2, undoItemInfo.getParent() != iOutputItem2);
                    continue;
                }
                if (this.mIsPasteAfterUndo) {
                    undoItemInfo = this.mUndoMap.get(iOutputItem);
                    outputDocument.insertItem(iOutputItem, undoItemInfo.getInsertAfter(), undoItemInfo.getParent() != undoItemInfo.getInsertAfter());
                    continue;
                }
                outputDocument.deleteItem(iOutputItem);
            }
        }
        this.mWindow.updateToolbarEnableStatus();
    }

    private void alignTextItem(ViewerItem viewerItem, OutputItemAlignment outputItemAlignment) {
        SpssTextPane spssTextPane = ((TextViewerItem)viewerItem).getTextPane();
        StyledDocument styledDocument = (StyledDocument)spssTextPane.getDocument();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        if (outputItemAlignment == OutputItemAlignment.Left) {
            StyleConstants.setAlignment(simpleAttributeSet, 0);
        } else if (outputItemAlignment == OutputItemAlignment.Right) {
            StyleConstants.setAlignment(simpleAttributeSet, 2);
        } else {
            StyleConstants.setAlignment(simpleAttributeSet, 1);
        }
        styledDocument.setParagraphAttributes(0, styledDocument.getLength(), simpleAttributeSet, false);
    }

    private void cleanupOrphanedItems() {
        if (this.mUndoMap != null) {
            for (IOutputItem iOutputItem : this.mUndoMap.keySet()) {
                if (iOutputItem == null || !iOutputItem.isValid() || iOutputItem.getParentItem() != null) continue;
                iOutputItem.destroy();
            }
        }
        if (this.mRedoMap != null) {
            for (IOutputItem iOutputItem : this.mRedoMap.keySet()) {
                if (iOutputItem == null || !iOutputItem.isValid() || iOutputItem.getParentItem() != null) continue;
                iOutputItem.destroy();
            }
        }
    }
}

