/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output.undo;

import com.ibm.statistics.lighttable.ui.LtEditorInfo;
import com.spss.java_client.core.documents.output.VizCache;
import com.spss.java_client.core.documents.output.table.TableItem;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerSearchOptions;
import com.spss.java_client.ui.doc_types.output.IViewerWindow;
import com.spss.java_client.ui.doc_types.output.LightTableViewerItem;
import com.spss.java_client.ui.doc_types.output.TableViewerItem;
import com.spss.java_client.ui.doc_types.output.TextViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerTreePane;
import com.spss.java_client.ui.texteditor.SpssTextPane;
import com.spss.pivottable.PTInfo;
import com.spss.pivottable.gui.editing.InPlaceEditHandler;
import com.spss.pivottable.selection.IPvtSelectItem;
import com.spss.pivottable.selection.ItemPicker;
import com.spss.pivottable.selection.SelectionProcessor;
import com.spss.pivottable.util.EditorUtil;
import com.spss.vis.Visualization;
import com.spss.vis.exception.VisualizationException;
import com.spss.vis.specification.VisualizationSpecification;
import com.spss.vis.specification.data.SourceVariableSpecification;
import com.spss.vis.specification.data.VariableSpecification;
import com.spss.vizimager.VizDataProcessor;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.nio.ByteBuffer;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class OutputSearchReplaceUndo
extends AbstractUndoableEdit {
    private IViewerWindow mWindow;
    private TextViewerItem mTextItem = null;
    private TableViewerItem mTableItem = null;
    private JTree mTree = null;
    private TreePath mEditingPath = null;
    private IViewerWindow.PaneType mPaneType;
    private int mStartPos;
    private int mEndPos;
    private String mLastText;
    private String mNewText = "";
    private IPvtSelectItem mSelectedCell = null;
    private InPlaceEditHandler mCellEditHandler = null;
    private boolean mWasLayerText = false;

    public OutputSearchReplaceUndo(IViewerWindow iViewerWindow, TextViewerItem textViewerItem, String string) {
        SpssTextPane spssTextPane = textViewerItem.getTextPane();
        this.mWindow = iViewerWindow;
        this.mTextItem = textViewerItem;
        this.mPaneType = IViewerWindow.PaneType.Content;
        this.mStartPos = spssTextPane.getSelectionStart();
        this.mEndPos = this.mStartPos + string.length();
        this.mLastText = spssTextPane.getSelectedText();
        spssTextPane.replaceSelection(string);
        spssTextPane.select(this.mStartPos, this.mEndPos);
        iViewerWindow.getUndoManager().addEdit(this);
        iViewerWindow.updateToolbarEnableStatus();
    }

    public OutputSearchReplaceUndo(IViewerWindow iViewerWindow, JTree jTree, String string) {
        this.mWindow = iViewerWindow;
        this.mTree = jTree;
        this.mPaneType = IViewerWindow.PaneType.Outline;
        this.mEditingPath = this.mTree.getEditingPath();
        ViewerTreePane.NavTreeCellEditor navTreeCellEditor = (ViewerTreePane.NavTreeCellEditor)this.mTree.getCellEditor();
        JTextField jTextField = navTreeCellEditor.getEditingComponent();
        this.mStartPos = jTextField.getSelectionStart();
        this.mEndPos = this.mStartPos + string.length();
        this.mLastText = jTextField.getSelectedText();
        navTreeCellEditor.replace(string);
        iViewerWindow.getUndoManager().addEdit(this);
        iViewerWindow.updateToolbarEnableStatus();
    }

    public OutputSearchReplaceUndo(IViewerWindow iViewerWindow, TableViewerItem tableViewerItem, ViewerSearchOptions viewerSearchOptions, String string) {
        this.mWindow = iViewerWindow;
        this.mTableItem = tableViewerItem;
        Point point = viewerSearchOptions.getTableSearcher().getCellLocation();
        PTInfo pTInfo = tableViewerItem.getTableEditor().getPivotTableInfo();
        Component component = pTInfo.getTextEditor().getComponent();
        if (!(component instanceof JTextPane)) {
            assert (false);
            return;
        }
        this.mSelectedCell = ItemPicker.pick((Shape)new Rectangle(point.x - 2, point.y - 2, 4, 4), (Point)point, (PTInfo)pTInfo);
        if (this.mSelectedCell == null) {
            assert (false);
            return;
        }
        if (viewerSearchOptions.getTableSearcher().currentCellIsLayerLabel()) {
            this.mWasLayerText = true;
            this.mLastText = viewerSearchOptions.getTableSearcher().getCurrentSearchCell().getCellValue();
            if (this.mLastText.contains(viewerSearchOptions.getSearchString())) {
                this.mNewText = this.mLastText.replaceFirst(viewerSearchOptions.getSearchString(), string);
                VariableSpecification variableSpecification = EditorUtil.getLayerSpecs((VisualizationSpecification)pTInfo.getVisualizationSpecification())[0].getVariable();
                EditorUtil.setLabelValue((PTInfo)pTInfo, (SourceVariableSpecification)((SourceVariableSpecification)variableSpecification), (String)"0", (String)this.mNewText);
                pTInfo.setDataModified(true);
                pTInfo.setXmlDirty(true);
            } else {
                this.mNewText = this.mLastText;
            }
        } else {
            this.mWasLayerText = false;
            pTInfo.getSelectionMgr().clear();
            pTInfo.getSelectionMgr().add((Object)this.mSelectedCell);
            JTextPane jTextPane = (JTextPane)component;
            this.mLastText = jTextPane.getText();
            jTextPane.replaceSelection(string);
            this.mNewText = jTextPane.getText();
            this.mCellEditHandler = SelectionProcessor.getEditHandler((PTInfo)pTInfo, (IPvtSelectItem)this.mSelectedCell);
        }
        iViewerWindow.getUndoManager().addEdit(this);
        iViewerWindow.updateToolbarEnableStatus();
    }

    public OutputSearchReplaceUndo(IViewerWindow iViewerWindow, LightTableViewerItem lightTableViewerItem, ViewerSearchOptions viewerSearchOptions, String string) {
        this.mWindow = iViewerWindow;
        LtEditorInfo ltEditorInfo = lightTableViewerItem.getEditorFrame().getEditorInfo();
        Component component = ltEditorInfo.getTextEditor().getComponent();
        if (!(component instanceof JTextPane)) {
            assert (false);
            return;
        }
        JTextPane jTextPane = (JTextPane)component;
        this.mLastText = jTextPane.getText();
        jTextPane.replaceSelection(string);
        this.mNewText = jTextPane.getText();
    }

    @Override
    public String getPresentationName() {
        return super.getPresentationName();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction();
    }

    private void doAction() {
        this.mWindow.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (this.mPaneType == IViewerWindow.PaneType.Outline) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mEditingPath.getLastPathComponent();
                ViewerTreePane.NavTreeNode navTreeNode = (ViewerTreePane.NavTreeNode)defaultMutableTreeNode.getUserObject();
                String string = navTreeNode.toString();
                String string2 = this.mLastText;
                this.mLastText = string.substring(this.mStartPos, this.mEndPos);
                string = string.substring(0, this.mStartPos) + string2 + string.substring(this.mEndPos);
                this.mEndPos = this.mStartPos + string2.length();
                navTreeNode.setName(string);
                navTreeNode.getItem().getCoreItem().setDescription(string);
                ((DefaultTreeModel)this.mTree.getModel()).nodeChanged(defaultMutableTreeNode);
            } else if (this.mTextItem != null) {
                SpssTextPane spssTextPane = this.mTextItem.getTextPane();
                spssTextPane.setSelectionStart(this.mStartPos);
                spssTextPane.setSelectionEnd(this.mEndPos);
                String string = this.mLastText;
                this.mEndPos = this.mStartPos + string.length();
                this.mLastText = spssTextPane.getSelectedText();
                spssTextPane.replaceSelection(string);
                if (this.mTextItem.isInEditMode()) {
                    spssTextPane.select(this.mStartPos, this.mStartPos + string.length());
                } else {
                    this.mTextItem.commitText();
                }
            } else if (this.mTableItem != null) {
                Object object;
                PTInfo pTInfo = this.mTableItem.getTableEditor().getPivotTableInfo();
                ByteBuffer byteBuffer = ((TableItem)this.mTableItem.getCoreItem()).getVDPData();
                this.instantiateEditorData(pTInfo);
                if (byteBuffer != null) {
                    this.setupVDPData(pTInfo);
                }
                if (this.mWasLayerText) {
                    object = this.mTableItem.getTableEditor().getPivotTableInfo();
                    VariableSpecification variableSpecification = EditorUtil.getLayerSpecs((VisualizationSpecification)object.getVisualizationSpecification())[0].getVariable();
                    EditorUtil.setLabelValue((PTInfo)object, (SourceVariableSpecification)((SourceVariableSpecification)variableSpecification), (String)"0", (String)this.mLastText);
                    object.setDataModified(true);
                    object.setXmlDirty(true);
                } else {
                    pTInfo.getSelectionMgr().clear();
                    pTInfo.getSelectionMgr().add((Object)this.mSelectedCell);
                    this.mCellEditHandler.update(this.mLastText, this.mTableItem.getTableEditor().getPivotTableInfo(), this.mSelectedCell);
                }
                pTInfo.redrawTable();
                if (!this.mTableItem.isInEditMode()) {
                    this.mTableItem.deactivateEdit();
                }
                object = this.mLastText;
                this.mLastText = this.mNewText;
                this.mNewText = object;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mWindow.updateToolbarEnableStatus();
        this.mWindow.setCursor(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instantiateEditorData(PTInfo pTInfo) {
        Visualization visualization;
        Visualization visualization2 = visualization = VizCache.getCache().getVisualization((TableItem)this.mTableItem.getCoreItem());
        synchronized (visualization2) {
            pTInfo.setVisualization_no_undo(visualization);
            pTInfo.setVisualizationSpecification(visualization.getSpecification());
            try {
                EditorUtil.setLayerHeightConsideringControlWidth((Visualization)visualization, (PTInfo)pTInfo);
            }
            catch (VisualizationException visualizationException) {
                // empty catch block
            }
        }
        pTInfo.reset();
    }

    private void setupVDPData(PTInfo pTInfo) {
        ByteBuffer byteBuffer = ((TableItem)this.mTableItem.getCoreItem()).getVDPData();
        if (byteBuffer != null) {
            VizDataProcessor vizDataProcessor = new VizDataProcessor();
            vizDataProcessor.readDataSources(byteBuffer);
            pTInfo.setExternalDataSource(VizCache.getCache().getDataReader((TableItem)this.mTableItem.getCoreItem()));
        }
    }
}

