/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output.model_editor;

import com.pasw.core.container.DefaultContainer;
import com.pasw.framework.common.container.Container;
import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ColumnDataProvider;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.chart.ChartItem;
import com.spss.java_client.core.documents.output.modelviewer.ModelItem;
import com.spss.java_client.core.documents.output.modelviewer.ModelUtil;
import com.spss.java_client.core.documents.output.serialize.IOutputFlavor;
import com.spss.java_client.core.documents.output.serialize.OutputSerializer;
import com.spss.java_client.core.documents.output.serialize.OutputTransfer;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.base.graphs.GraphboardTemplateChooser;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.output.ModelViewerItem;
import com.spss.java_client.ui.doc_types.output.model_editor.FieldSelectionNewDataSetDlg;
import com.spss.java_client.ui.doc_types.output.model_editor.GenerateFieldSelectionDlg;
import com.spss.java_client.ui.doc_types.output.model_editor.GraphboardModel;
import com.spss.java_client.ui.doc_types.output.model_editor.ModelViewerAction;
import com.spss.java_client.ui.doc_types.output.model_editor.ModelViewerPrintAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.pes.help.Helper;
import com.spss.shared.core_tools.dictionary.IDataSrc;
import com.spss.uitools.clipboard.AppClipboard;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.util.CharacterUtil;
import com.spss.uitools.util.SpssDomWriter;
import com.spss.vis.Row;
import com.spss.vis.Source;
import com.spss.vis.Visualization;
import com.spss.vis.action.source.ConvertToEmbeddedAction;
import com.spss.vis.exception.VisualizationException;
import com.spss.vis.graphboard.Graphboard;
import com.spss.vis.graphboard.palette.GraphboardToolBar;
import com.spss.vis.graphboard.template.MapInfo;
import com.spss.vis.modelviewer.ModelViewer;
import com.spss.vis.modelviewer.UserSelection;
import com.spss.vis.modelviewer.component.ModelViewerUIComponentImpl;
import com.spss.vis.modelviewer.datamodel.DataModel;
import com.spss.vis.modelviewer.datamodel.ModelSplitModel;
import com.spss.vis.modelviewer.datamodel.common.MiningField;
import com.spss.vis.modelviewer.datamodel.common.MiningSchema;
import com.spss.vis.modelviewer.datamodel.common.OutputField;
import com.spss.vis.modelviewer.datamodel.statxml.SplitField;
import com.spss.vis.modelviewer.datamodel.statxml.SplitGroup;
import com.spss.vis.modelviewer.datamodel.statxml.StatXML;
import com.spss.vis.modelviewer.datamodel.statxml.cf.datamodel.Field;
import com.spss.vis.modelviewer.datamodel.statxml.cf.datamodel.Fields;
import com.spss.vis.modelviewer.datamodel.statxml.cf.datamodel.OutputValueFormat;
import com.spss.vis.modelviewer.interactivity.InformationController;
import com.spss.vis.modelviewer.main.LaunchingActionEvent;
import com.spss.vis.modelviewer.main.ModelViewerImpl;
import com.spss.vis.modelviewer.util.ArraySource;
import com.spss.vis.modelviewer.view.View;
import com.spss.vis.modelviewer.view.ViewInfo;
import com.spss.vis.modelviewer.view.alm.ModelSummaryView;
import com.spss.vis.modelviewer.view.cluster.ClustersMainView;
import com.spss.vis.modelviewer.view.common.InformationView;
import com.spss.vis.modelviewer.view.common.information.InformationPanel;
import com.spss.vis.modelviewer.view.common.information.InformationTree;
import com.spss.vis.modelviewer.view.ensemble.EnsembleModelSummaryView;
import com.spss.vis.modelviewer.view.glmm.GLMMModelSummaryView;
import com.spss.vis.modelviewer.view.knn.KnnFeatureView;
import com.spss.vis.specification.VisualizationSpecification;
import com.spss.vis.specification.data.MeasurementLevel;
import com.spss.vis.specification.layout.LocationSpecification;
import com.spss.vizconverter.VizConverter;
import com.spss.vizconverter.VizTemplate;
import com.spss.vizimager.IVDPVersion;
import com.spss.vizimager.VizDataProcessor;
import com.spss.vizimager.VizDataSource;
import com.spss.vizimager.VizDataWriter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.prefs.Preferences;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeNode;
import javax.swing.undo.UndoManager;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ModelViewerFrame
extends JFrame
implements WindowListener,
MenuListener,
IVDPVersion,
ActionListener {
    private ModelViewerItem mViwerItem;
    private ModelViewer mModelViewer;
    private boolean mIsModelChanged;
    private int[] mClustersSelected;
    private String[] mSelectedClustersStrings;
    private String mMemberVarName = null;
    private Set<String> mLabelVarSet;
    private Map<String, String> mSlotValueLabelMap = new HashMap<String, String>();
    private UndoManager mUndoManager = new UndoManager();
    private Map<String, ModelViewerFrame> mChildFrameMap;
    private boolean mIsMainFrame;
    private File mParentFold = new File(FileLocationsUtil.getOtherFilesDirectoryPath());
    private String mFieldsList;
    private boolean mIsIncludeFields;
    private List<String> mActiveDatasetVars;
    private static String TRANSFORMED = "_transformed";

    public ModelViewerFrame(ModelViewerItem modelViewerItem, ModelViewer modelViewer, String string) {
        this(modelViewerItem, modelViewer, string, true);
    }

    public ModelViewerFrame(ModelViewerItem modelViewerItem, ModelViewer modelViewer, String string, boolean bl) {
        super(string);
        this.mViwerItem = modelViewerItem;
        this.mModelViewer = modelViewer;
        this.mIsMainFrame = bl;
        Helper helper = new Helper(){

            public void setHelpFile(String string, String string2) {
            }

            public void handleHelp(String string) {
                StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, string);
            }
        };
        this.mModelViewer.getComponent().getGraphboard(true).setHelpHandler(helper);
        this.init();
        this.getContentPane().add((Component)modelViewer.getComponent());
        this.addWindowListener(this);
        if (this.mIsMainFrame) {
            this.mModelViewer.addActionListener((ActionListener)this);
            this.loadPreferences();
            this.mChildFrameMap = new HashMap<String, ModelViewerFrame>();
        }
    }

    public ModelViewerItem getViewerItem() {
        return this.mViwerItem;
    }

    public void close() {
        this.mViwerItem.endEdit();
    }

    public static void updateMenuEnableStatus(JMenu jMenu, ModelViewerFrame modelViewerFrame) {
        int n = jMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            Action action;
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem instanceof JMenu || jMenuItem == null || !((action = jMenuItem.getAction()) instanceof ModelViewerAction)) continue;
            ModelViewerAction modelViewerAction = (ModelViewerAction)action;
            jMenuItem.setEnabled(modelViewerAction.getMenuItemEnableStatus(modelViewerFrame));
        }
    }

    public String getMemberVarName() {
        ArrayList arrayList;
        if (this.mMemberVarName == null && (arrayList = ((ModelViewerImpl)this.mModelViewer).getDataModel().getOutputField(OutputField.ResultFeature.entityId)) != null && arrayList.size() > 0) {
            OutputField outputField = (OutputField)arrayList.get(0);
            this.mMemberVarName = outputField.getName();
        }
        return this.mMemberVarName;
    }

    private void refreshMenuCheckStatus(JMenu jMenu, ModelViewerFrame modelViewerFrame) {
        int n = jMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            ModelViewerAction modelViewerAction;
            JMenuItem jMenuItem;
            JMenuItem jMenuItem2 = jMenu.getItem(i);
            if (jMenuItem2 instanceof JCheckBoxMenuItem) {
                jMenuItem = (JCheckBoxMenuItem)jMenuItem2;
                modelViewerAction = (ModelViewerAction)jMenuItem2.getAction();
                ((JCheckBoxMenuItem)jMenuItem).setState(modelViewerAction.getMenuItemCheckStatus(modelViewerFrame));
                continue;
            }
            if (!(jMenuItem2 instanceof JRadioButtonMenuItem)) continue;
            jMenuItem = (JRadioButtonMenuItem)jMenuItem2;
            modelViewerAction = (ModelViewerAction)jMenuItem2.getAction();
            jMenuItem.setSelected(modelViewerAction.getMenuItemCheckStatus(modelViewerFrame));
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this.mIsMainFrame) {
            this.applyPreferences();
        }
        if (this.mChildFrameMap != null) {
            Set<String> set = this.mChildFrameMap.keySet();
            for (String string : set) {
                ModelViewerFrame modelViewerFrame = this.mChildFrameMap.get(string);
                if (modelViewerFrame == null) continue;
                modelViewerFrame.dispose();
            }
        }
        if (this.mIsMainFrame) {
            this.close();
        }
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        JMenu jMenu = (JMenu)menuEvent.getSource();
        ModelViewerFrame.updateMenuEnableStatus(jMenu, this);
        this.refreshMenuCheckStatus(jMenu, this);
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    public boolean needsRerendering() {
        return this.mIsModelChanged;
    }

    public void setDirty(boolean bl) {
        this.mIsModelChanged = bl;
    }

    public ByteBuffer writeStreamData(ArrayList<Source> arrayList) {
        ByteBuffer byteBuffer;
        try {
            Object[] objectArray;
            int n = 8;
            short s = 0;
            for (Source source : arrayList) {
                s = (short)(s + 1);
                objectArray = source.getVariables();
                n += source.size() * objectArray.length * 8 + 288 * objectArray.length;
            }
            int n2 = 40;
            int n3 = -80;
            if (n3 >= -80) {
                n2 = 80;
            }
            n += s * n2;
            objectArray = this.buildStringData(arrayList);
            byteBuffer = ByteBuffer.allocate(n += objectArray.length);
            byteBuffer.order(ByteOrder.nativeOrder());
            int n4 = 0;
            byte by = (byte)(ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? 1 : 0);
            byteBuffer.put(n4++, by);
            if (n3 >= -80) {
                byteBuffer.put(n4++, (byte)-80);
            } else {
                byteBuffer.put(n4++, (byte)-81);
            }
            byteBuffer.putShort(n4, s);
            byteBuffer.putInt(n4 += 2, n);
            n4 += 4;
            int n5 = 28;
            if (n3 >= -80) {
                n5 = 65;
            }
            int n6 = s * n2 + n4;
            s = 0;
            for (Source source : arrayList) {
                String[] stringArray = source.getVariables();
                byteBuffer.putInt(n4, source.size());
                byteBuffer.putInt(n4 += 4, stringArray.length);
                byteBuffer.putInt(n4 += 4, n6);
                n4 += 4;
                String string = source.getID();
                byte[] byArray = string.getBytes("UTF-8");
                for (int i = 0; i < n5; ++i) {
                    if (i < byArray.length) {
                        byteBuffer.put(n4 + i, byArray[i]);
                        continue;
                    }
                    byteBuffer.put(n4 + i, (byte)0);
                }
                n4 += this.bound4Bytes(n5);
                this.putSourceData(byteBuffer, source, n6);
                s = (short)(s + 1);
                n6 += source.size() * stringArray.length * 8 + 288 * stringArray.length;
            }
            byteBuffer.position(n6);
            byteBuffer.put((byte[])objectArray);
            byteBuffer = ModelViewerFrame.compressStream(byteBuffer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return byteBuffer;
    }

    public ModelItem getModelItem() {
        return this.mViwerItem.getModelItem();
    }

    public void doMainCopy() {
        VisualizationSpecification visualizationSpecification;
        Visualization visualization;
        String string = null;
        Visualization visualization2 = visualization = this.mModelViewer.getViewInformation();
        int n = ((ViewInfo[])visualization2).length;
        for (int i = 0; i < n; ++i) {
            ViewInfo viewInfo = visualization2[i];
            if (!viewInfo.isMainView() || !viewInfo.isShowing()) continue;
            string = viewInfo.getName();
            break;
        }
        if (string != null && (visualization2 = this.mModelViewer.makeVisualizationForView(string)) != null && (visualizationSpecification = visualization2.getSpecification()) != null) {
            this.doCopy(this.mModelViewer.getComponent().getGraphboard(true), this.convertToEmbedded(visualization2, visualizationSpecification));
        }
    }

    public void doAuxiliaryCopy() {
        VisualizationSpecification visualizationSpecification;
        Visualization visualization;
        String string = null;
        Visualization visualization2 = visualization = this.mModelViewer.getViewInformation();
        int n = ((ViewInfo[])visualization2).length;
        for (int i = 0; i < n; ++i) {
            ViewInfo viewInfo = visualization2[i];
            if (viewInfo.isMainView() || !viewInfo.isShowing()) continue;
            string = viewInfo.getName();
            break;
        }
        if (string != null && (visualization2 = this.mModelViewer.makeVisualizationForView(string)) != null && (visualizationSpecification = visualization2.getSpecification()) != null) {
            this.doCopy(this.mModelViewer.getComponent().getGraphboard(false), this.convertToEmbedded(visualization2, visualizationSpecification));
        }
    }

    public void reset() {
        if (this.mIsMainFrame) {
            this.mModelViewer.removeActionListener((ActionListener)this);
            this.mChildFrameMap.clear();
        }
        this.mViwerItem = null;
        this.mModelViewer = null;
        this.mClustersSelected = null;
        this.mSelectedClustersStrings = null;
        this.mMemberVarName = null;
        if (this.mLabelVarSet != null) {
            this.mLabelVarSet.clear();
        }
        this.mSlotValueLabelMap.clear();
        this.mUndoManager.discardAllEdits();
    }

    public void generateGraph() {
        ViewInfo[] viewInfoArray;
        for (ViewInfo viewInfo : viewInfoArray = this.mModelViewer.getViewInformation()) {
            if (!(viewInfo instanceof ClustersMainView)) continue;
            UserSelection userSelection = this.mModelViewer.getUserSelection();
            this.mClustersSelected = null;
            this.mSelectedClustersStrings = null;
            if (userSelection != null) {
                this.mSelectedClustersStrings = userSelection.getSubsets();
                if (this.mSelectedClustersStrings != null && this.mSelectedClustersStrings.length > 0) {
                    this.mClustersSelected = new int[this.mSelectedClustersStrings.length];
                    for (int i = 0; i < this.mSelectedClustersStrings.length; ++i) {
                        int n = this.mSelectedClustersStrings[i].indexOf("-");
                        this.mClustersSelected[i] = Integer.parseInt(this.mSelectedClustersStrings[i].substring(n + 1));
                    }
                }
            }
            GraphboardTemplateChooser graphboardTemplateChooser = new GraphboardTemplateChooser(null);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = graphboardTemplateChooser.getSize();
            graphboardTemplateChooser.setModelFrame(this);
            graphboardTemplateChooser.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
            graphboardTemplateChooser.setVisible(true);
            break;
        }
    }

    public void graphboardCallback(final GraphboardModel graphboardModel) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ModelViewerFrame.this.generateChartFromSyntax(graphboardModel);
            }
        });
    }

    public boolean hasClusterSelected() {
        String[] stringArray;
        boolean bl = false;
        UserSelection userSelection = this.mModelViewer.getUserSelection();
        if (userSelection != null && (stringArray = userSelection.getSubsets()) != null && stringArray.length > 0) {
            bl = true;
        }
        return bl;
    }

    public UndoManager getUndoManager() {
        return this.mUndoManager;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        LaunchingActionEvent launchingActionEvent;
        Object object;
        if (actionEvent.getActionCommand().equals("LaunchingActionEvent") && (object = (launchingActionEvent = (LaunchingActionEvent)actionEvent).getSource()) instanceof ModelViewerUIComponentImpl) {
            String string = null;
            if (launchingActionEvent != null) {
                string = launchingActionEvent.getModelID();
            }
            if (string != null && this.mChildFrameMap != null) {
                ModelViewerFrame modelViewerFrame;
                ModelViewerFrame modelViewerFrame2 = this.mChildFrameMap.get(string);
                if (modelViewerFrame2 == null) {
                    modelViewerFrame = this.createModelViewer(string);
                    modelViewerFrame2 = new ModelViewerFrame(this.mViwerItem, (ModelViewer)modelViewerFrame, this.getSplitID((ModelViewerUIComponentImpl)object), false);
                    this.mChildFrameMap.put(string, modelViewerFrame2);
                }
                modelViewerFrame = modelViewerFrame2;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        modelViewerFrame.pack();
                        modelViewerFrame.setVisible(true);
                        modelViewerFrame.toFront();
                    }
                });
            }
        }
    }

    public void doExportText() {
        List list = ((ModelViewerImpl)this.mModelViewer).getViews();
        for (View view : list) {
            if (!(view instanceof InformationView)) continue;
            InformationView informationView = (InformationView)view;
            Graphboard graphboard = this.mModelViewer.getComponent().getGraphboard(true);
            List list2 = informationView.getUserController(ComponentState.getOLangLocale(), graphboard);
            InformationPanel informationPanel = ((InformationController)list2.get(0)).getInformationPanel();
            InformationTree informationTree = informationPanel.getTree();
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(this.mParentFold);
            jFileChooser.setFileFilter(new SimpleFileFilter(".txt", ResUtil.getString("IDS_TEXT_EXPORT")));
            int n = jFileChooser.showSaveDialog(null);
            if (n != 0) break;
            String string = jFileChooser.getSelectedFile().getPath();
            if (!string.endsWith(".txt")) {
                string = string + ".txt";
            }
            File file = new File(string);
            this.mParentFold = file.getParentFile();
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            try {
                FileWriter fileWriter = new FileWriter(file);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                informationTree.generateBranchText(informationTree.getModel().getRoot(), bufferedWriter, 0, Boolean.valueOf(true));
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break;
        }
    }

    private TreeNode[] getTreePath(TreeNode treeNode) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        arrayList.add(treeNode);
        for (treeNode = treeNode.getParent(); treeNode != null; treeNode = treeNode.getParent()) {
            arrayList.add(treeNode);
        }
        TreeNode[] treeNodeArray = new TreeNode[arrayList.size() + 1];
        for (int i = 0; i < arrayList.size(); ++i) {
            treeNodeArray[i] = (TreeNode)arrayList.get(arrayList.size() - i - 1);
        }
        return treeNodeArray;
    }

    public void doExportHtml() {
        List list = ((ModelViewerImpl)this.mModelViewer).getViews();
        for (View view : list) {
            if (!(view instanceof InformationView)) continue;
            InformationView informationView = (InformationView)view;
            Graphboard graphboard = this.mModelViewer.getComponent().getGraphboard(true);
            List list2 = informationView.getUserController(ComponentState.getOLangLocale(), graphboard);
            InformationPanel informationPanel = ((InformationController)list2.get(0)).getInformationPanel();
            InformationTree informationTree = informationPanel.getTree();
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(this.mParentFold);
            jFileChooser.setFileFilter(new SimpleFileFilter(".html", ResUtil.getString("IDS_HTML_EXPORT")));
            int n = jFileChooser.showSaveDialog(null);
            if (n != 0) break;
            String string = jFileChooser.getSelectedFile().getPath();
            if (!string.endsWith(".html")) {
                string = string + ".html";
            }
            File file = new File(string);
            this.mParentFold = file.getParentFile();
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            try {
                FileWriter fileWriter = new FileWriter(file);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                informationTree.generateBranchHTML(informationTree.getModel().getRoot(), bufferedWriter, Boolean.valueOf(true));
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break;
        }
    }

    public void doExportPmml() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(this.mParentFold);
        jFileChooser.setFileFilter(new SimpleFileFilter(".zip", ResUtil.getString("IDS_PMML_EXPORT")));
        int n = jFileChooser.showSaveDialog(null);
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().getPath();
            if (!string.endsWith(".zip")) {
                string = string + ".zip";
            }
            File file = new File(string);
            this.mParentFold = file.getParentFile();
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            ModelItem modelItem = this.mViwerItem.getModelItem();
            DefaultContainer defaultContainer = (DefaultContainer)modelItem.getPMMLContainer();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                JarOutputStream jarOutputStream = new JarOutputStream(fileOutputStream);
                Iterator iterator = defaultContainer.getKeyIterator();
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        Container.Key key = (Container.Key)iterator.next();
                        if (key.toString().equals("rootPMML")) continue;
                        InputStream inputStream = defaultContainer.getContentFromInputStream(key);
                        ByteArrayOutputStream byteArrayOutputStream = ModelUtil.readPmmlStream((InputStream)inputStream);
                        ModelViewerFrame.saveToJarFile(jarOutputStream, "pmml_" + key.toString() + ".xml", byteArrayOutputStream.toByteArray(), byteArrayOutputStream.size());
                        byteArrayOutputStream.close();
                    }
                } else {
                    InputStream inputStream = defaultContainer.getContentFromInputStream();
                    ByteArrayOutputStream byteArrayOutputStream = ModelUtil.readPmmlStream((InputStream)inputStream);
                    if (fileOutputStream != null) {
                        if (jarOutputStream == null) {
                            jarOutputStream = new JarOutputStream(fileOutputStream);
                        }
                        Document document = modelItem.getModelViewer().getRevisedPmml();
                        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                        SpssDomWriter spssDomWriter = new SpssDomWriter();
                        spssDomWriter.setOutput((OutputStream)byteArrayOutputStream2, null);
                        spssDomWriter.write((Node)document);
                        byteArrayOutputStream2.close();
                        ModelViewerFrame.saveToJarFile(jarOutputStream, "file_no_key.xml", byteArrayOutputStream2.toByteArray(), byteArrayOutputStream.size());
                    }
                    byteArrayOutputStream.close();
                }
                jarOutputStream.close();
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void doCopyView() {
        List list = ((ModelViewerImpl)this.mModelViewer).getViews();
        for (View view : list) {
            VisualizationSpecification visualizationSpecification;
            if (!view.isShowing() || !view.isMainView()) continue;
            if (view instanceof InformationView) {
                InformationView informationView = (InformationView)view;
                Graphboard graphboard = this.mModelViewer.getComponent().getGraphboard(true);
                List list2 = informationView.getUserController(ComponentState.getOLangLocale(), graphboard);
                InformationPanel informationPanel = ((InformationController)list2.get(0)).getInformationPanel();
                InformationTree informationTree = informationPanel.getTree();
                this.doCopyInformation(informationTree);
                break;
            }
            Visualization visualization = this.mModelViewer.makeVisualizationForView(view.getName());
            if (visualization == null || (visualizationSpecification = visualization.getSpecification()) == null) break;
            this.doCopy(this.mModelViewer.getComponent().getGraphboard(true), this.convertToEmbedded(visualization, visualizationSpecification));
            break;
        }
    }

    public void doFieldSelectionInputNotUsed() {
        this.mIsIncludeFields = true;
        this.mFieldsList = null;
        FieldSelectionNewDataSetDlg fieldSelectionNewDataSetDlg = new FieldSelectionNewDataSetDlg(this);
    }

    public void doFieldSelectionPredictorImportance() {
        this.mIsIncludeFields = true;
        this.mFieldsList = null;
        GenerateFieldSelectionDlg generateFieldSelectionDlg = new GenerateFieldSelectionDlg(this);
        if (!generateFieldSelectionDlg.isCancel()) {
            new FieldSelectionNewDataSetDlg(this);
        }
    }

    public String getFieldsList(ReturnResult returnResult) {
        if (this.mFieldsList == null || this.mFieldsList.length() == 0) {
            HashSet<String> hashSet = new HashSet<String>();
            List list = ((ModelViewerImpl)this.mModelViewer).getViews();
            for (View view : list) {
                if (!(view instanceof ModelSummaryView) && !(view instanceof GLMMModelSummaryView) && !(view instanceof EnsembleModelSummaryView)) continue;
                DataModel dataModel = view.getDataModel();
                MiningSchema miningSchema = dataModel.getMiningSchema();
                Set set = miningSchema.keySet();
                String string = null;
                int n = 0;
                for (Object object : set) {
                    MiningField object2 = (MiningField)miningSchema.get(object);
                    string = object2.getName();
                    if (string.endsWith(TRANSFORMED)) {
                        n = string.indexOf(TRANSFORMED);
                        string = string.substring(0, n);
                    }
                    hashSet.add(string);
                }
                if (this.checkFieldsValidation(hashSet)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (String string2 : hashSet) {
                        stringBuffer.append(string2 + " ");
                    }
                    this.mFieldsList = stringBuffer.toString();
                    break;
                }
                returnResult.isSuccess = false;
                break;
            }
        }
        return this.mFieldsList;
    }

    public boolean isIncludeFields() {
        return this.mIsIncludeFields;
    }

    public void setIsIncludeFields(boolean bl) {
        this.mIsIncludeFields = bl;
    }

    public boolean setTopFields(int n) {
        this.extractActiveDatasetVars();
        HashSet<String> hashSet = new HashSet<String>();
        Map map = this.mModelViewer.getPredictors(2);
        Set set = map.keySet();
        List list = ((ModelViewerImpl)this.mModelViewer).getViews();
        block0: for (Object object : list) {
            if (!(object instanceof ModelSummaryView) && !(object instanceof EnsembleModelSummaryView)) continue;
            DataModel object2 = object.getDataModel();
            MiningSchema miningSchema = object2.getMiningSchema();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Set set2 = miningSchema.keySet();
            int n2 = 0;
            for (String string : set2) {
                if (!set.contains(string)) continue;
                if (string.endsWith(TRANSFORMED)) {
                    n2 = string.indexOf(TRANSFORMED);
                    string = string.substring(0, n2);
                }
                arrayList.add(miningSchema.get((Object)string));
            }
            Collections.sort(arrayList, new ImportanceComparator());
            Object object3 = null;
            int n3 = 1;
            for (MiningField miningField : arrayList) {
                if (n3 > n) break block0;
                object3 = miningField.getName();
                if (((String)object3).endsWith(TRANSFORMED)) {
                    n2 = ((String)object3).indexOf(TRANSFORMED);
                    object3 = ((String)object3).substring(0, n2);
                }
                hashSet.add((String)object3);
                ++n3;
            }
        }
        if (this.checkFieldsValidation(hashSet)) {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : hashSet) {
                stringBuffer.append(string + " ");
            }
            this.mFieldsList = stringBuffer.toString();
            return true;
        }
        return false;
    }

    public boolean setImportanceFields(double d) {
        this.extractActiveDatasetVars();
        HashSet<String> hashSet = new HashSet<String>();
        Map map = this.mModelViewer.getPredictors(2);
        Set set = map.keySet();
        List list = ((ModelViewerImpl)this.mModelViewer).getViews();
        for (Object object : list) {
            MiningField miningField;
            Object object22;
            MiningField miningField2;
            if (!(object instanceof ModelSummaryView) && !(object instanceof EnsembleModelSummaryView)) continue;
            DataModel object3 = object.getDataModel();
            MiningSchema miningSchema = object3.getMiningSchema();
            Set set2 = miningSchema.keySet();
            LinkedHashMap<String, MiningField> linkedHashMap = new LinkedHashMap<String, MiningField>();
            for (String string : set2) {
                miningField2 = (MiningField)miningSchema.get((Object)string);
                if (miningField2 == null || miningField2.getImportance() == null) continue;
                linkedHashMap.put(string, miningField2);
            }
            ArrayList arrayList = new ArrayList();
            int n = 0;
            set2 = linkedHashMap.keySet();
            miningField2 = null;
            for (Object object22 : set2) {
                miningField2 = (MiningField)linkedHashMap.get(object22);
                if (((String)object22).endsWith(TRANSFORMED)) {
                    n = ((String)object22).indexOf(TRANSFORMED);
                    object22 = ((String)object22).substring(0, n);
                }
                if (!set.contains(object22) || miningField2 == null) continue;
                arrayList.add(miningField2);
            }
            Object object4 = null;
            Collections.sort(arrayList, new ImportanceComparator());
            object22 = arrayList.iterator();
            while (object22.hasNext() && !((miningField = (MiningField)object22.next()).getImportance() <= d)) {
                object4 = miningField.getName();
                if (((String)object4).endsWith(TRANSFORMED)) {
                    n = ((String)object4).indexOf(TRANSFORMED);
                    object4 = ((String)object4).substring(0, n);
                }
                hashSet.add((String)object4);
            }
            break block0;
        }
        if (this.checkFieldsValidation(hashSet)) {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : hashSet) {
                stringBuffer.append(string + " ");
            }
            this.mFieldsList = stringBuffer.toString();
            return true;
        }
        return false;
    }

    private void generateChartFromSyntax(GraphboardModel graphboardModel) {
        byte[] byArray = this.createDataArray(graphboardModel);
        if (byArray == null) {
            return;
        }
        byte[] byArray2 = this.createXmlArray(graphboardModel);
        this.mViwerItem.addChart(graphboardModel.getLableStr(), byArray2, byArray, graphboardModel.getModelMapInfo());
    }

    private byte[] createXmlArray(GraphboardModel graphboardModel) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object52;
        Object object6;
        Map<String, String> map;
        Object object7;
        Object object8;
        int n;
        VizConverter vizConverter = new VizConverter();
        DocumentBuilder documentBuilder = vizConverter.preCreateDocument();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("vizTemplate");
        element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        element.setAttribute("xmlns:vizml", "http://xml.spss.com/visualization");
        element.setAttribute("xsi:schemaLocation", "http://xml.spss.com/spss/viewer/vizTemplate http://xml.spss.com/spss/viewer/vizTemplate-1.0.xsd");
        element.setAttribute("xmlns", "http://xml.spss.com/spss/viewer/vizTemplate");
        document.appendChild(element);
        Element element2 = document.createElement("templateSpecification");
        element.appendChild(element2);
        element2.setAttribute("templateName", graphboardModel.getTemplate().getName());
        Map<String, MeasurementLevel> map2 = graphboardModel.getVarMeasureLevels();
        String string = null;
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(DataMgr.getDataMgr().getActiveDocumentId());
        if (iSpssDataSrc == null) {
            iSpssDataSrc = DataMgr.getDataMgr().getDataSource(DataMgr.getDataMgr().getActiveBackendDocumentId());
        }
        if (iSpssDataSrc != null && (n = iSpssDataSrc.getWeightVarIndex()) >= 0 && n < iSpssDataSrc.columnCount() && (object8 = iSpssDataSrc.getVariable(n)) != null) {
            string = object8.getName();
        }
        Map<String, String> map3 = graphboardModel.getVarMapping();
        object8 = map3.keySet();
        Iterator<String> iterator = object8.iterator();
        while (iterator.hasNext()) {
            object7 = iterator.next();
            map = map3.get(object7);
            if (map == null || ((String)((Object)map)).length() <= 0) continue;
            for (Object object52 : object6 = ((String)((Object)map)).split(",")) {
                String string2;
                object4 = document.createElement("mapping");
                element2.appendChild((Node)object4);
                object4.setAttribute("slotName", (String)object7);
                object4.setAttribute("slotValue", (String)object52);
                object4.setAttribute("dataSetName", "graphdataset");
                if (this.mLabelVarSet.contains(object52)) {
                    object4.setAttribute("labelingVariableName", (String)object52 + "Label");
                }
                if ((string2 = this.mSlotValueLabelMap.get(object52)) != null && string2.length() > 0) {
                    object4.setAttribute("slotLabel", string2);
                }
                if ((object3 = map2.get(object52)) == MeasurementLevel.interval || object3 == MeasurementLevel.ratio) {
                    object4.setAttribute("categorical", "false");
                } else {
                    object4.setAttribute("categorical", "true");
                }
                if (string != null && string.equals(object52)) {
                    object4.setAttribute("weight", "true");
                }
                object2 = document.createElement("vizml:format");
                object4.appendChild((Node)object2);
                object2.setAttribute("errorCharacter", "*");
                object2.setAttribute("maximumFractionDigits", "0");
                object2.setAttribute("minimumFractionDigits", "0");
                object2.setAttribute("minimumIntegerDigits", "0");
                object2.setAttribute("scientific", "onlyForSmall");
                object2.setAttribute("small", "0");
                object2.setAttribute("useGrouping", "false");
            }
        }
        object7 = graphboardModel.getSumMapping();
        object8 = object7.keySet();
        iterator = object8.iterator();
        while (iterator.hasNext()) {
            map = iterator.next();
            object6 = (String)object7.get(map);
            if (object6 == null || ((String)object6).length() <= 0) continue;
            object = document.createElement("mapping");
            element2.appendChild((Node)object);
            object.setAttribute("slotName", (String)((Object)map));
            object.setAttribute("slotValue", (String)object6);
            object.setAttribute("dataSetName", "graphdataset");
            object.setAttribute("categorical", "true");
            if (string == null || !string.equals(object6)) continue;
            object.setAttribute("weight", "true");
        }
        map = graphboardModel.getTitlesMapping();
        if (map.size() > 0) {
            object6 = map.keySet();
            object = object6.iterator();
            while (object.hasNext()) {
                String string3 = (String)object.next();
                String string4 = (String)map.get(string3);
                if (string4 == null || string4.length() <= 0) continue;
                string4 = string4.replace("\n", "\\n");
                object52 = document.createElement("mapping");
                element2.appendChild((Node)object52);
                object52.setAttribute("slotName", string3);
                object52.setAttribute("slotValue", CharacterUtil.smartQuote((String)string4));
                object52.setAttribute("dataSetName", "graphdataset");
                object52.setAttribute("categorical", "true");
            }
        } else {
            object6 = this.getChartTitle();
            if (object6 != null) {
                object = document.createElement("mapping");
                element2.appendChild((Node)object);
                object.setAttribute("slotName", "Title");
                object.setAttribute("dataSetName", "graphdataset");
                object.setAttribute("categorical", "true");
                object.setAttribute("slotValue", (String)object6);
            }
        }
        object6 = document.createElement("styleSheetSpecification");
        element.appendChild((Node)object6);
        if (graphboardModel.getRpi().isLocal()) {
            object6.setAttribute("location", "local");
            element2.setAttribute("location", "local");
        } else {
            object6.setAttribute("location", graphboardModel.getRpi().getSelectFolderPath());
            element2.setAttribute("location", graphboardModel.getRpi().getSelectFolderPath());
        }
        object6.setAttribute("styleSheetName", graphboardModel.getStylesheetName());
        object = graphboardModel.getTemplateBuilder().getMainMaps();
        List list = graphboardModel.getTemplateBuilder().getReferenceMaps();
        if (object != null && object.size() > 0 || list != null && list.size() > 0) {
            Object object9;
            Object object102;
            Object object11;
            long l = 0L;
            object4 = null;
            long l2 = 0L;
            object2 = null;
            if (object != null && object.size() > 0) {
                object11 = object.iterator();
                while (object11.hasNext()) {
                    object102 = (MapInfo.MainMap)object11.next();
                    object9 = object102.getMapIdentifier();
                    if (!(object9 instanceof MapInfo.FileMapIdentifier)) continue;
                    object4 = ((MapInfo.FileMapIdentifier)object9).getFilePath();
                    l = UUID.randomUUID().getMostSignificantBits();
                    break;
                }
            }
            if (list != null && list.size() > 0) {
                for (Object object102 : list) {
                    object9 = object102.getMapIdentifier();
                    if (!(object9 instanceof MapInfo.FileMapIdentifier)) continue;
                    object2 = ((MapInfo.FileMapIdentifier)object9).getFilePath();
                    l2 = UUID.randomUUID().getMostSignificantBits();
                    break;
                }
            }
            try {
                byte[] byArray;
                int n2;
                byte[] byArray2;
                Closeable closeable;
                InputStream inputStream;
                object11 = null;
                object102 = null;
                if (object4 != null && ((String)object4).length() > 0) {
                    object9 = new URI((String)object4);
                    inputStream = ((URI)object9).toURL().openStream();
                    closeable = new ByteArrayOutputStream();
                    byArray2 = new byte[1024];
                    while ((n2 = inputStream.read(byArray2)) > 0) {
                        ((ByteArrayOutputStream)closeable).write(byArray2, 0, n2);
                    }
                    byArray = ((ByteArrayOutputStream)closeable).toByteArray();
                    ((ByteArrayOutputStream)closeable).close();
                    object11 = ByteBuffer.allocate(byArray.length);
                    ((ByteBuffer)object11).put(byArray);
                }
                if (object2 != null && ((String)object2).length() > 0) {
                    object9 = new URI((String)object2);
                    inputStream = ((URI)object9).toURL().openStream();
                    closeable = new ByteArrayOutputStream();
                    byArray2 = new byte[1024];
                    while ((n2 = inputStream.read(byArray2)) > 0) {
                        ((ByteArrayOutputStream)closeable).write(byArray2, 0, n2);
                    }
                    byArray = ((ByteArrayOutputStream)closeable).toByteArray();
                    ((ByteArrayOutputStream)closeable).close();
                    object102 = ByteBuffer.allocate(byArray.length);
                    ((ByteBuffer)object102).put(byArray);
                }
                object9 = new ModelViewerItem.ModelMapInfo(l, (String)object4, (ByteBuffer)object11, l2, (String)object2, (ByteBuffer)object102);
                graphboardModel.setModelMapInfo((ModelViewerItem.ModelMapInfo)object9);
                inputStream = graphboardModel.getTemplateBuilder().getSpecification();
                closeable = new CharArrayWriter();
                inputStream.writeXml((Writer)closeable);
                return ((CharArrayWriter)closeable).toString().getBytes("UTF-8");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        VizTemplate vizTemplate = vizConverter.graphBoardConverterToXml(document, ComponentState.getOLangLocale());
        object52 = vizTemplate.getXmlString();
        object4 = vizTemplate.getStyleSheetString();
        byte[] byArray = null;
        object3 = null;
        try {
            byArray = ((String)object52).getBytes("UTF8");
            object3 = ((String)object4).getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return vizConverter.graphBoardApplyStyleSheet((byte[])object3, byArray);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] createDataArray(GraphboardModel graphboardModel) {
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        DataFrame dataFrame = SpssFrameMgr.getSpssFrameMgr().getDataFrame(locallyUniqueId);
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(dataFrame.getDatasetId());
        Source source = graphboardModel.getTemplateSource();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(source.getVariables()));
        Set<String> set = graphboardModel.getVarNames();
        ColumnDataProvider columnDataProvider = new String[set.size()];
        columnDataProvider = set.toArray((T[])columnDataProvider);
        int[] nArray = new int[set.size()];
        int n = 0;
        for (String string : columnDataProvider) {
            nArray[n++] = arrayList.indexOf(string);
        }
        ColumnDataProvider columnDataProvider2 = new ColumnDataProvider(iSpssDataSrc);
        OBS[][] oBSArrayArray = new OBS[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            oBSArrayArray[i] = columnDataProvider2.getColumn(nArray[i]);
        }
        String string = this.getMemberVarName();
        int n2 = arrayList.indexOf(string);
        if (n2 >= 0 && n2 < arrayList.size()) {
            ArrayList[] arrayListArray = new ArrayList[nArray.length];
            for (n = 0; n < arrayListArray.length; ++n) {
                arrayListArray[n] = new ArrayList();
            }
            ArrayList[] arrayListArray2 = new ArrayList[nArray.length];
            for (n = 0; n < arrayListArray2.length; ++n) {
                arrayListArray2[n] = new ArrayList();
            }
            int n3 = 0;
            OBS[] oBSArray = columnDataProvider2.getColumn(n2);
            for (OBS oBS : oBSArray) {
                int n4 = (int)oBS.getNum();
                if (this.isCaseSelected(n4)) {
                    for (int i = 0; i < nArray.length; ++i) {
                        arrayListArray[i].add(oBSArrayArray[i][n3]);
                        if (oBSArrayArray[i][n3].isString()) {
                            arrayListArray2[i].add(oBSArrayArray[i][n3].getString().trim());
                            continue;
                        }
                        if (oBSArrayArray[i][n3].isMissing((IDataSrc)iSpssDataSrc)) continue;
                        arrayListArray2[i].add(oBSArrayArray[i][n3].getNum());
                    }
                }
                ++n3;
            }
            this.mSlotValueLabelMap.clear();
            HashMap hashMap = new HashMap();
            for (n = 0; n < nArray.length; ++n) {
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(nArray[n]);
                this.mSlotValueLabelMap.put((String)columnDataProvider[n], iSpssVariable.getLabel());
                IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
                int n5 = iValueLabelMap.size();
                if (n5 <= 1) continue;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                hashMap.put(columnDataProvider[n], arrayList2);
                for (ArrayList arrayList3 : arrayListArray[n]) {
                    arrayList2.add(iValueLabelMap.get((OBS)arrayList3));
                }
            }
            VizDataProcessor vizDataProcessor = new VizDataProcessor();
            Vector<VizDataSource> vector = new Vector<VizDataSource>();
            VizDataSource vizDataSource = vizDataProcessor.createDataSource(arrayListArray2[0].size());
            vizDataSource.setID("graphdataset");
            for (n = 0; n < nArray.length; ++n) {
                void var25_43;
                Object e = arrayListArray2[n].get(0);
                Object var25_40 = null;
                if (e instanceof String) {
                    String[] stringArray = arrayListArray2[n].toArray(new String[0]);
                } else if (e instanceof Double) {
                    Double[] doubleArray = arrayListArray2[n].toArray(new Double[0]);
                }
                this.AddDataSourceColumn((Object[])var25_43, (String)columnDataProvider[n], vizDataSource);
            }
            this.mLabelVarSet = hashMap.keySet();
            for (String string2 : this.mLabelVarSet) {
                ArrayList arrayList3;
                arrayList3 = (ArrayList)hashMap.get(string2);
                vizDataSource.setStringColumn(string2 + "Label", arrayList3.toArray(new String[0]));
            }
            vector.add(vizDataSource);
            VizDataWriter vizDataWriter = vizDataProcessor.getDataWriter();
            ByteBuffer byteBuffer = vizDataWriter.writeStreamData(vector);
            vizDataWriter.releaseAllData();
            return byteBuffer.array();
        }
        return null;
    }

    private void AddDataSourceColumn(Object[] objectArray, String string, VizDataSource vizDataSource) {
        double[] dArray;
        if (objectArray instanceof Double[]) {
            dArray = new double[((Double[])objectArray).length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = ((Double[])objectArray)[i];
            }
        } else {
            Object[] objectArray2 = objectArray;
            dArray = new double[objectArray2.length];
            int n = 0;
            for (Object object : objectArray2) {
                dArray[n] = Double.NaN;
                if (object != null) {
                    if (object instanceof String) {
                        try {
                            dArray[n] = Double.parseDouble((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            dArray[n] = Double.NaN;
                        }
                    } else if (object instanceof Double) {
                        if (!Double.isInfinite((Double)object)) {
                            dArray[n] = (Double)object;
                        }
                    } else {
                        throw new NumberFormatException();
                    }
                }
                ++n;
            }
        }
        if (dArray != null) {
            vizDataSource.setColumn(string, DoubleBuffer.wrap(dArray));
        }
    }

    private boolean isCaseSelected(int n) {
        boolean bl = false;
        for (int n2 : this.mClustersSelected) {
            if (n2 != n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private String getChartTitle() {
        if (this.mSelectedClustersStrings == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string : this.mSelectedClustersStrings) {
            if (bl) {
                stringBuffer.append(" '").append(this.mMemberVarName).append("'=\"").append(string).append("\"");
                bl = false;
                continue;
            }
            stringBuffer.append(" ").append(ResUtil.getString("cluster_or")).append(" '").append(this.mMemberVarName).append("'=\"").append(string).append("\"");
        }
        return stringBuffer.toString();
    }

    protected byte[] buildStringData(ArrayList<Source> arrayList) {
        Vector vector;
        Vector<byte[]> vector2;
        int n;
        int n2 = 4;
        try {
            n = 0;
            for (Source object : arrayList) {
                n += 0;
            }
            if (n == 0) {
                return new byte[0];
            }
            vector2 = new Vector<byte[]>();
            vector = new Vector();
            for (Source source : arrayList) {
                byte[] byArray = source.getID().getBytes("UTF-8");
                n2 += 4 + byArray.length;
                vector2.add(byArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new byte[0];
        }
        n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.putInt(arrayList.size());
        for (byte[] byArray : vector) {
            byteBuffer.putInt(((byte[])vector2.get(n)).length);
            byteBuffer.put((byte[])vector2.get(n));
            byteBuffer.put(byArray);
            ++n;
        }
        return byteBuffer.array();
    }

    protected int bound4Bytes(int n) {
        if (n % 4 > 0) {
            n = (n / 4 + 1) * 4;
        }
        return n;
    }

    private void init() {
        if (this.mViwerItem.getModelItem().getPMMLContainerBuffer() != null && this.mViwerItem.getModelItem().getStatXMLContainerBuffer() != null) {
            this.initNewModel();
            this.extractActiveDatasetVars();
        } else {
            this.initLegacy();
        }
    }

    private void initLegacy() {
        ViewInfo[] viewInfoArray;
        Object object2;
        ImageIcon imageIcon = new ImageIcon(ResUtil.getImageResource("modeleditor.png"));
        this.setIconImage(imageIcon.getImage());
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu(new ModelViewerAction("model_file", this.mModelViewer, this));
        JMenu jMenu2 = new JMenu(new ModelViewerAction("Edit", this.mModelViewer, this));
        JMenu jMenu3 = new JMenu(new ModelViewerAction("model_view", this.mModelViewer, this));
        JMenu jMenu4 = new JMenu(new ModelViewerAction("Help", this.mModelViewer, this));
        JMenu jMenu5 = this.mModelViewer.getComponent().getPaletteMenu();
        Graphboard graphboard = this.mModelViewer.getComponent().getGraphboard(true);
        List list = this.mModelViewer.getComponent().getGraphboard(false).getPalettes();
        for (Object object2 : list) {
            this.synchPalettesForMainAux((GraphboardToolBar)object2, graphboard);
        }
        JMenuItem jMenuItem = new JMenuItem(new ModelViewerAction("model_file_close", this.mModelViewer, this));
        object2 = new JCheckBoxMenuItem(new ModelViewerAction("model_view_edit_mode", this.mModelViewer, this));
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new ModelViewerAction("model_view_explore_mode", this.mModelViewer, this));
        JMenuItem jMenuItem2 = new JMenuItem(new ModelViewerAction("edit_undo", this.mModelViewer, this));
        JMenuItem jMenuItem3 = new JMenuItem(new ModelViewerAction("edit_redo", this.mModelViewer, this));
        JMenuItem jMenuItem4 = new JMenuItem(new ModelViewerAction("help_topics", this.mModelViewer, this));
        JMenuItem jMenuItem5 = new JMenuItem(new ModelViewerAction("edit_copy_main", this.mModelViewer, this));
        JMenuItem jMenuItem6 = new JMenuItem(new ModelViewerAction("edit_copy_auxiliary", this.mModelViewer, this));
        JMenuItem jMenuItem7 = new JMenuItem(new ModelViewerAction("model_file_properties", this.mModelViewer, this));
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        if (this.isClusterModel()) {
            ViewInfo[] viewInfoArray2;
            viewInfoArray = new JMenu(new ModelViewerAction("model_generate", this.mModelViewer, this));
            if (!CommandLine.isClementineCaller()) {
                viewInfoArray2 = new JMenuItem(new ModelViewerAction("model_filter_cases", this.mModelViewer, this));
                viewInfoArray.add((JMenuItem)viewInfoArray2);
            }
            viewInfoArray2 = new JMenuItem(new ModelViewerAction("model_graph", this.mModelViewer, this));
            viewInfoArray.add((JMenuItem)viewInfoArray2);
            jMenuBar.add((JMenu)viewInfoArray);
            viewInfoArray.addMenuListener(this);
        }
        jMenuBar.add(jMenu3);
        jMenuBar.add(jMenu4);
        jMenu.add(jMenuItem7);
        jMenu.add(jMenuItem);
        jMenu2.add(jMenuItem2);
        jMenu2.add(jMenuItem3);
        jMenu2.add(jMenuItem5);
        jMenu2.add(jMenuItem6);
        jMenu4.add(jMenuItem4);
        for (ViewInfo viewInfo : viewInfoArray = this.mModelViewer.getViewInformation()) {
            if (!(viewInfo instanceof KnnFeatureView)) continue;
            jMenu3.add((JMenuItem)object2);
            jMenu3.add(jCheckBoxMenuItem);
            break;
        }
        jMenu3.add(jMenu5);
        jMenu3.addMenuListener(this);
        jMenu2.addMenuListener(this);
        ((ModelViewerAction)((AbstractButton)object2).getAction()).initEditStatus();
    }

    private void initNewModel() {
        ViewInfo[] viewInfoArray;
        Object object3;
        Object object22;
        ImageIcon imageIcon = new ImageIcon(ResUtil.getImageResource("modeleditor.png"));
        this.setIconImage(imageIcon.getImage());
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu(new ModelViewerAction("model_file", this.mModelViewer, this));
        JMenu jMenu2 = new JMenu(new ModelViewerAction("Edit", this.mModelViewer, this));
        JMenu jMenu3 = new JMenu(new ModelViewerAction("model_view", this.mModelViewer, this));
        JMenu jMenu4 = new JMenu(new ModelViewerAction("Help", this.mModelViewer, this));
        JMenu jMenu5 = this.mModelViewer.getComponent().getPaletteMenu();
        Graphboard graphboard = this.mModelViewer.getComponent().getGraphboard(true);
        List list = this.mModelViewer.getComponent().getGraphboard(false).getPalettes();
        for (Object object22 : list) {
            this.synchPalettesForMainAux((GraphboardToolBar)object22, graphboard);
        }
        JMenuItem jMenuItem = new JMenuItem(new ModelViewerAction("model_file_close", this.mModelViewer, this));
        object22 = new JCheckBoxMenuItem(new ModelViewerAction("model_view_edit_mode", this.mModelViewer, this));
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new ModelViewerAction("model_view_explore_mode", this.mModelViewer, this));
        JMenuItem jMenuItem2 = new JMenuItem(new ModelViewerAction("help_topics", this.mModelViewer, this));
        JMenuItem jMenuItem3 = new JMenuItem(new ModelViewerAction("edit_copy_view", this.mModelViewer, this));
        JMenuItem jMenuItem4 = new JMenuItem(new ModelViewerAction("model_file_print_view", this.mModelViewer, this));
        JMenuItem jMenuItem5 = new JMenuItem(new ModelViewerAction("model_file_export_text", this.mModelViewer, this));
        JMenuItem jMenuItem6 = new JMenuItem(new ModelViewerAction("model_file_export_html", this.mModelViewer, this));
        JMenuItem jMenuItem7 = new JMenuItem(new ModelViewerAction("model_file_export_pmml", this.mModelViewer, this));
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        boolean bl = false;
        boolean bl2 = false;
        List list2 = ((ModelViewerImpl)this.mModelViewer).getViews();
        for (Object object3 : list2) {
            if (object3 instanceof GLMMModelSummaryView) {
                bl = true;
                continue;
            }
            if (!(object3 instanceof ModelSummaryView) && !(object3 instanceof EnsembleModelSummaryView)) continue;
            bl2 = true;
        }
        JMenu jMenu6 = new JMenu(new ModelViewerAction("model_generate", this.mModelViewer, this));
        object3 = new JMenuItem(new ModelViewerAction("model_field_selection_input_target", this.mModelViewer, this));
        JMenuItem jMenuItem8 = new JMenuItem(new ModelViewerAction("model_field_selection_predictor_importance", this.mModelViewer, this));
        jMenu6.add((JMenuItem)object3);
        if (bl2) {
            jMenu6.add(jMenuItem8);
        }
        if (bl || bl2) {
            jMenuBar.add(jMenu6);
        }
        jMenu.add(jMenuItem4);
        jMenu.add(new JMenuItem(new ModelViewerPrintAction(this.mViwerItem)));
        jMenu.addSeparator();
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenu.add(jMenuItem5);
        jMenu.add(jMenuItem6);
        jMenu.add(jMenuItem7);
        jMenu2.add(jMenuItem3);
        jMenu4.add(jMenuItem2);
        for (ViewInfo viewInfo : viewInfoArray = this.mModelViewer.getViewInformation()) {
            if (!(viewInfo instanceof KnnFeatureView)) continue;
            jMenu3.add((JMenuItem)object22);
            jMenu3.add(jCheckBoxMenuItem);
            break;
        }
        if (jMenu5.getItemCount() > 0) {
            jMenu3.add(jMenu5);
        }
        jMenu3.addMenuListener(this);
        jMenu2.addMenuListener(this);
        jMenu6.addMenuListener(this);
        jMenuBar.add(jMenu4);
        if (jMenu3.getItemCount() > 0) {
            jMenuBar.add(jMenu3);
        }
        ((ModelViewerAction)((AbstractButton)object22).getAction()).initEditStatus();
    }

    private static ByteBuffer compressStream(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = null;
        try {
            byte[] byArray;
            if (byteBuffer.hasArray()) {
                byArray = byteBuffer.array();
            } else {
                byArray = new byte[byteBuffer.capacity()];
                byteBuffer.get(byArray, 0, byteBuffer.capacity());
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            ((OutputStream)deflaterOutputStream).write(byArray);
            ((OutputStream)deflaterOutputStream).close();
            byArray = byteArrayOutputStream.toByteArray();
            byteBuffer2 = ByteBuffer.wrap(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteBuffer2;
    }

    private void putSourceData(ByteBuffer byteBuffer, Source source, int n) throws Exception {
        String[] stringArray;
        int n2 = n;
        ArraySource arraySource = (ArraySource)source;
        int n3 = arraySource.size();
        for (String string : stringArray = source.getVariables()) {
            byte[] byArray = string.getBytes("UTF-8");
            for (int i = 0; i < 288; ++i) {
                if (i < byArray.length) {
                    byteBuffer.put(n2 + i, byArray[i]);
                    continue;
                }
                byteBuffer.put(n2 + i, (byte)0);
            }
            n2 += 288;
            Iterator iterator = source.iterator(null);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                byteBuffer.putDouble(n2, row.getDouble(string));
                n2 += 8;
            }
        }
    }

    private void doCopy(Graphboard graphboard, VisualizationSpecification visualizationSpecification) {
        AppClipboard appClipboard = AppClipboard.getAppClipboard();
        OutputSerializer outputSerializer = new OutputSerializer();
        IOutputItem[] iOutputItemArray = new IOutputItem[1];
        ChartItem chartItem = new ChartItem();
        chartItem.setChartType(false);
        chartItem.setDescription(ResUtil.getString("IDS_VIEWER_ITEM_CHART"));
        byte[] byArray = this.extractCompressedXML(visualizationSpecification);
        chartItem.setCompressedXML(ByteBuffer.wrap(byArray));
        chartItem.setVDPData(null);
        iOutputItemArray[0] = chartItem;
        byte[] byArray2 = outputSerializer.serializeItems(iOutputItemArray);
        appClipboard.addClipboardData(IOutputFlavor.NATIVE_FLAVOR, (Object)new OutputTransfer(byArray2), false);
        Visualization visualization = graphboard.getVisualizationComponent().getVisualization();
        try {
            BufferedImage bufferedImage = visualization.makeImage();
            appClipboard.addClipboardData(IOutputFlavor.IMAGE_FLAVOR, (Object)bufferedImage, false);
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
        appClipboard.flush();
    }

    private void doCopyInformation(InformationTree informationTree) {
        AppClipboard appClipboard = AppClipboard.getAppClipboard();
        Rectangle rectangle = informationTree.getBounds();
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 6);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        informationTree.print(graphics);
        graphics.dispose();
        appClipboard.addClipboardData(IOutputFlavor.IMAGE_FLAVOR, (Object)bufferedImage, false);
        appClipboard.flush();
    }

    private void loadPreferences() {
        Preferences preferences = this.getBasePreference();
        final int n = preferences.getInt("width", 900);
        final int n2 = preferences.getInt("height", 700);
        Dimension dimension = this.getToolkit().getScreenSize();
        int n3 = (dimension.width - n) / 2;
        int n4 = (dimension.height - n2) / 2;
        final int n5 = preferences.getInt("x_pos", n3);
        final int n6 = preferences.getInt("y_pos", n4);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ModelViewerFrame.this.setSize(n, n2);
                ModelViewerFrame.this.setLocation(n5, n6);
            }
        });
    }

    private void applyPreferences() {
        Preferences preferences = this.getBasePreference();
        Point point = this.getLocation();
        preferences.putInt("x_pos", point.x);
        preferences.putInt("y_pos", point.y);
        preferences.putInt("width", this.getSize().width);
        preferences.putInt("height", this.getSize().height);
    }

    private Preferences getBasePreference() {
        String string = PrefsMgr.getPrefsMgr().getUIUserPrefs().absolutePath();
        Preferences preferences = Preferences.userRoot().node(string);
        return preferences.node("dialog_settings/modelviewer");
    }

    private byte[] extractCompressedXML(VisualizationSpecification visualizationSpecification) {
        byte[] byArray = null;
        try {
            StringWriter stringWriter = new StringWriter();
            visualizationSpecification.writeXml((Writer)stringWriter);
            stringWriter.close();
            StringBuffer stringBuffer = stringWriter.getBuffer();
            byArray = stringBuffer.toString().getBytes("UTF-8");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            ((OutputStream)deflaterOutputStream).write(byArray);
            ((OutputStream)deflaterOutputStream).close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray;
    }

    private void synchPalettesForMainAux(GraphboardToolBar graphboardToolBar, Graphboard graphboard) {
        for (GraphboardToolBar graphboardToolBar2 : graphboard.getPalettes()) {
            if (!graphboardToolBar2.getID().equals(graphboardToolBar.getID())) continue;
            graphboardToolBar2.getCheckBoxMenuItem().addChangeListener(new PaletteChangeListener(graphboardToolBar));
        }
    }

    private VisualizationSpecification convertToEmbedded(Visualization visualization, VisualizationSpecification visualizationSpecification) {
        Object object;
        VisualizationSpecification visualizationSpecification2 = visualizationSpecification.clone();
        LocationSpecification[] locationSpecificationArray = visualizationSpecification2.getLocations();
        if (locationSpecificationArray.length > 0) {
            object = locationSpecificationArray;
            int n = ((LocationSpecification[])object).length;
            for (int i = 0; i < n; ++i) {
                Object object2 = object[i];
                object2.setMax(null);
            }
        }
        if ((object = visualization.getUserSources()).size() > 0) {
            try {
                new ConvertToEmbeddedAction(object.values()).modify(visualizationSpecification2);
            }
            catch (VisualizationException visualizationException) {
                visualizationException.printStackTrace();
            }
        }
        return visualizationSpecification2;
    }

    private boolean isClusterModel() {
        boolean bl = false;
        List list = ((ModelViewerImpl)this.mModelViewer).getViews();
        for (View view : list) {
            if (!(view instanceof ClustersMainView)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private ModelViewer createModelViewer(String string) {
        ModelViewer modelViewer = ModelViewer.make();
        DefaultContainer.ContentKey contentKey = new DefaultContainer.ContentKey();
        contentKey.addKeyValue(string);
        Container container = this.mViwerItem.getPMMLContainer();
        Container container2 = this.mViwerItem.getStatXMLContainer();
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        try {
            if (container != null) {
                inputStream = container.getContentFromInputStream((Container.Key)contentKey);
            }
            if (container2 != null) {
                inputStream2 = container2.getContentFromInputStream((Container.Key)contentKey);
            }
            modelViewer.getComponent();
            modelViewer.setInput((Reader)new InputStreamReader(inputStream, "UTF-8"), (Reader)new InputStreamReader(inputStream2, "UTF-8"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return modelViewer;
    }

    private static void saveToJarFile(JarOutputStream jarOutputStream, String string, byte[] byArray, int n) {
        JarEntry jarEntry = new JarEntry(string);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        jarEntry.setSize(n);
        jarEntry.setCrc(cRC32.getValue());
        try {
            jarOutputStream.putNextEntry(jarEntry);
            jarOutputStream.write(byArray);
            jarOutputStream.closeEntry();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void extractActiveDatasetVars() {
        this.mActiveDatasetVars = new ArrayList<String>();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(DataMgr.getDataMgr().getActiveDocumentId());
        if (iSpssDataSrc == null) {
            iSpssDataSrc = DataMgr.getDataMgr().getDataSource(DataMgr.getDataMgr().getActiveBackendDocumentId());
        }
        if (iSpssDataSrc != null) {
            int n = iSpssDataSrc.columnCount();
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                this.mActiveDatasetVars.add(iSpssVariable.getName());
            }
            Vector vector = iSpssDataSrc.getMRVariables();
            for (ISpssVariable iSpssVariable : vector) {
                this.mActiveDatasetVars.add(iSpssVariable.getName());
            }
        }
    }

    private boolean checkFieldsValidation(Set<String> set) {
        boolean bl = true;
        if (set.size() > 0 && this.mActiveDatasetVars != null) {
            ArrayList<String> arrayList = new ArrayList<String>(set);
            arrayList.removeAll(this.mActiveDatasetVars);
            if (arrayList.size() > 0) {
                set.removeAll(arrayList);
                StringBuffer stringBuffer = new StringBuffer();
                for (String string : arrayList) {
                    stringBuffer.append(string + " ");
                }
                int n = JOptionPane.showConfirmDialog(null, ResUtil.getString("IDS_INVALID_FIELDS_WARNING") + stringBuffer.toString(), ResUtil.getString("IDS_VIEWER_ITEM_WARNINGS"), 2);
                bl = n == 0;
            }
        }
        return bl;
    }

    private String getSplitID(ModelViewerUIComponentImpl modelViewerUIComponentImpl) {
        String string = "";
        DataModel dataModel = modelViewerUIComponentImpl.getDataModel();
        ModelSplitModel modelSplitModel = dataModel.getModelSplitModel();
        Integer n = modelSplitModel.getSelectedRow();
        StatXML statXML = dataModel.getStatXML();
        Fields fields = null;
        com.spss.vis.modelviewer.datamodel.statxml.cf.datamodel.DataModel dataModel2 = statXML.getDataModel();
        if (dataModel2 != null) {
            fields = dataModel2.getFields();
        }
        List list = statXML.getSplitGroups();
        SplitGroup splitGroup = (SplitGroup)list.get(n);
        List list2 = splitGroup.getSplitFields();
        int n2 = list2.size();
        for (int i = 0; i < n2; ++i) {
            Field field;
            SplitField splitField = (SplitField)list2.get(i);
            string = string + splitField.getName();
            String string2 = splitField.getValue();
            if (fields != null && (field = fields.getField(splitField.getName())) != null) {
                OutputValueFormat outputValueFormat;
                String string3 = field.getDisplayLabelForValue(string2);
                if (string3 != null) {
                    string2 = string3;
                } else if (field.getBaseFieldContent() != null && field.getBaseFieldContent().getFieldFormat() != null && (outputValueFormat = field.getBaseFieldContent().getFieldFormat().getFormat()) != null) {
                    string2 = outputValueFormat.format(string2, ComponentState.getOLangLocale());
                }
            }
            string = string + ":" + string2;
            string = string + " ";
        }
        return string;
    }

    static class ReturnResult {
        boolean isSuccess = true;

        ReturnResult() {
        }
    }

    class ImportanceComparator
    implements Comparator<MiningField> {
        ImportanceComparator() {
        }

        @Override
        public int compare(MiningField miningField, MiningField miningField2) {
            if (miningField.getImportance() == null) {
                return 1;
            }
            if (miningField2.getImportance() == null) {
                return -1;
            }
            if (miningField.getImportance() > miningField2.getImportance()) {
                return -1;
            }
            if (miningField.getImportance() < miningField2.getImportance()) {
                return 1;
            }
            return 0;
        }
    }

    static class SimpleFileFilter
    extends FileFilter {
        String description;
        String filter;

        public SimpleFileFilter(String string, String string2) {
            this.filter = string;
            this.description = string2;
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(this.filter);
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    class PaletteChangeListener
    implements ChangeListener {
        private GraphboardToolBar sameToolBarInAux;

        public PaletteChangeListener(GraphboardToolBar graphboardToolBar) {
            this.sameToolBarInAux = graphboardToolBar;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)changeEvent.getSource();
            this.sameToolBarInAux.setVisible(jCheckBoxMenuItem.isSelected());
        }
    }
}

