/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output.model_editor;

import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.dialogs.documents.output.PrintSettingDlg;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.output.model_editor.FilterRecordsDlg;
import com.spss.java_client.ui.doc_types.output.model_editor.ModelViewerFrame;
import com.spss.java_client.ui.doc_types.output.model_editor.ModelViewerUndoEdit;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.help.StatsHelp;
import com.spss.vis.graphboard.vismodel.NviznModelEvent;
import com.spss.vis.graphboard.vismodel.NviznModelEventListener;
import com.spss.vis.modelviewer.ModelViewer;
import com.spss.vis.modelviewer.UserSelection;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

public class ModelViewerAction
extends SpssAction
implements NviznModelEventListener {
    private ModelViewerFrame mFrame;
    private ModelViewer mModelViewer;
    private static boolean sInEditMode = false;
    private MainViewModelHander mMainViewModelHandler;
    private AuxViewModelHander mAuxViewModelHandler;
    private static volatile boolean mNoModelMessage = false;

    public ModelViewerAction(String string, ModelViewer modelViewer, ModelViewerFrame modelViewerFrame) {
        super(string);
        this.mFrame = modelViewerFrame;
        this.mModelViewer = modelViewer;
        this.configureAction(true);
        this.mMainViewModelHandler = new MainViewModelHander();
        this.mAuxViewModelHandler = new AuxViewModelHander();
        this.addListeners();
    }

    public boolean getMenuItemEnableStatus(ModelViewerFrame modelViewerFrame) {
        boolean bl = true;
        if (this.mActionId.equals("edit_undo")) {
            bl = sInEditMode && this.mFrame.getUndoManager().canUndo();
        } else if (this.mActionId.equals("edit_redo")) {
            bl = sInEditMode && this.mFrame.getUndoManager().canRedo();
        } else if (this.mActionId.equals("model_graph") || this.mActionId.equals("model_filter_cases")) {
            bl = this.mFrame.hasClusterSelected();
        }
        return bl;
    }

    public boolean getMenuItemCheckStatus(ModelViewerFrame modelViewerFrame) {
        boolean bl = true;
        if (this.mActionId.equals("model_view_edit_mode")) {
            bl = sInEditMode;
        } else if (this.mActionId.equals("model_view_explore_mode")) {
            bl = !sInEditMode;
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mActionId.equals("model_file_close")) {
            this.mFrame.close();
        } else if (this.mActionId.equals("model_view_edit_mode")) {
            this.mModelViewer.getComponent().getGraphboard(true).setEditEnabled(true);
            sInEditMode = true;
        } else if (this.mActionId.equals("model_view_explore_mode")) {
            this.mModelViewer.getComponent().getGraphboard(true).setEditEnabled(false);
            sInEditMode = false;
        } else if (this.mActionId.equals("edit_undo")) {
            mNoModelMessage = true;
            this.mFrame.getUndoManager().undo();
            mNoModelMessage = false;
        } else if (this.mActionId.equals("edit_redo")) {
            mNoModelMessage = true;
            this.mFrame.getUndoManager().redo();
            mNoModelMessage = false;
        } else if (this.mActionId.equals("model_file_properties") || this.mActionId.equals("model_file_print_view")) {
            new PrintSettingDlg(this.mFrame);
        } else if (this.mActionId.equals("edit_copy_main")) {
            this.mFrame.doMainCopy();
        } else if (this.mActionId.equals("edit_copy_auxiliary")) {
            this.mFrame.doAuxiliaryCopy();
        } else if (this.mActionId.equals("help_topics")) {
            StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_model_viewer");
        } else if (this.mActionId.equals("model_filter_cases")) {
            if (this.preValidateFilter()) {
                UserSelection userSelection = this.mModelViewer.getUserSelection();
                FilterRecordsDlg filterRecordsDlg = new FilterRecordsDlg(this.mFrame, userSelection.getSubsets());
                filterRecordsDlg.setVisible(true);
            }
        } else if (this.mActionId.equals("model_graph")) {
            if (this.preValidateGraph()) {
                this.mFrame.generateGraph();
            }
        } else if (this.mActionId.equals("model_file_export_text")) {
            this.mFrame.doExportText();
        } else if (this.mActionId.equals("model_file_export_html")) {
            this.mFrame.doExportHtml();
        } else if (this.mActionId.equals("model_file_export_pmml")) {
            this.mFrame.doExportPmml();
        } else if (this.mActionId.equals("edit_copy_view")) {
            this.mFrame.doCopyView();
        } else if (this.mActionId.equals("model_field_selection_input_target")) {
            this.mFrame.doFieldSelectionInputNotUsed();
        } else if (this.mActionId.equals("model_field_selection_predictor_importance")) {
            this.mFrame.doFieldSelectionPredictorImportance();
        }
    }

    public void modelChanged(NviznModelEvent nviznModelEvent) {
        if (nviznModelEvent.getType() == NviznModelEvent.EDIT_MODE_CHANGED) {
            sInEditMode = this.mModelViewer.getComponent().getGraphboard(true).isEditEnabled();
            this.mFrame.setDirty(true);
        }
    }

    public void initEditStatus() {
        if (sInEditMode) {
            this.mModelViewer.getComponent().getGraphboard(true).setEditEnabled(true);
        } else {
            this.mModelViewer.getComponent().getGraphboard(true).setEditEnabled(false);
        }
    }

    private boolean preValidateFilter() {
        String string = this.mFrame.getMemberVarName();
        if (string == null || !this.checkClusterVarInDataset(string)) {
            JOptionPane.showMessageDialog(this.mFrame, ResUtil.getString("model_filter_warning"), ResUtil.getString("model_filter_title"), 2);
            return false;
        }
        return true;
    }

    private boolean preValidateGraph() {
        String string = this.mFrame.getMemberVarName();
        if (string == null || !this.checkClusterVarInDataset(string)) {
            JOptionPane.showMessageDialog(null, ResUtil.getString("cluster_graph_generate_warning"), ResUtil.getString("warning_title"), 2);
            return false;
        }
        return true;
    }

    private boolean checkClusterVarInDataset(String string) {
        boolean bl = false;
        DataMgr dataMgr = DataMgr.getDataMgr();
        ISpssDataSrc iSpssDataSrc = dataMgr.getDataSource(dataMgr.getActiveDocumentId());
        if (iSpssDataSrc == null) {
            iSpssDataSrc = dataMgr.getDataSource(dataMgr.getActiveBackendDocumentId());
        }
        if (iSpssDataSrc != null) {
            int n = iSpssDataSrc.columnCount();
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                if (!iSpssVariable.getName().equals(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private void addListeners() {
        if (this.mActionId.equals("model_view_edit_mode") || this.mActionId.equals("model_view_explore_mode")) {
            this.mModelViewer.getComponent().getGraphboard(true).getModel().addListener((NviznModelEventListener)this);
        }
        if (this.mActionId.equals("edit_undo")) {
            this.mModelViewer.getComponent().getGraphboard(true).getModel().addListener((NviznModelEventListener)this.mMainViewModelHandler);
            this.mModelViewer.getComponent().getGraphboard(false).getModel().addListener((NviznModelEventListener)this.mAuxViewModelHandler);
        }
    }

    class AuxViewModelHander
    implements NviznModelEventListener {
        AuxViewModelHander() {
        }

        public void modelChanged(NviznModelEvent nviznModelEvent) {
            if (nviznModelEvent.getType() == NviznModelEvent.SPECIFICATION_CHANGED) {
                if (ModelViewerAction.this.mActionId.equals("edit_undo") && ModelViewerAction.this.mModelViewer.getComponent().getGraphboard(false).getModel().canUndo() && !mNoModelMessage) {
                    ModelViewerAction.this.mFrame.getUndoManager().addEdit(new ModelViewerUndoEdit(ModelViewerAction.this.mModelViewer.getComponent().getGraphboard(false).getModel()));
                }
                ModelViewerAction.this.mFrame.setDirty(true);
            }
        }
    }

    class MainViewModelHander
    implements NviznModelEventListener {
        MainViewModelHander() {
        }

        public void modelChanged(NviznModelEvent nviznModelEvent) {
            if (nviznModelEvent.getType() == NviznModelEvent.SPECIFICATION_CHANGED) {
                if (ModelViewerAction.this.mActionId.equals("edit_undo") && ModelViewerAction.this.mModelViewer.getComponent().getGraphboard(true).getModel().canUndo() && !mNoModelMessage) {
                    ModelViewerAction.this.mFrame.getUndoManager().addEdit(new ModelViewerUndoEdit(ModelViewerAction.this.mModelViewer.getComponent().getGraphboard(true).getModel()));
                }
                ModelViewerAction.this.mFrame.setDirty(true);
            }
        }
    }
}

