/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output.model_editor;

import com.spss.java_client.core.resources.ComponentResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.output.model_editor.ModelViewerFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.WindowsButtonGroup;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GenerateFieldSelectionDlg
extends BaseProcedureDialog
implements ActionListener,
ChangeListener {
    private ModelViewerFrame mParentFrame;
    private JRadioButton mIncludeRadio;
    private JRadioButton mExcludeRadio;
    private JRadioButton mNumFieldsRadio;
    private JRadioButton mImportanceRadio;
    private JSpinner mNumFieldSpner;
    private JSpinner mImportanceSpner;
    private boolean mIsCancel = true;
    private static final String sNumFieldSpinnerId = "NumFieldId";
    private static final String sImportanceSpinnerId = "ImportanceId";
    private static final String sNumFieldSpinnerState = "NumFieldState";
    private static final String sImportanceSpinnerState = "ImportanceState";

    public GenerateFieldSelectionDlg(ModelViewerFrame modelViewerFrame) {
        super((JFrame)modelViewerFrame, true, ComponentResBundle.getDefaultResourceBundleName(), "");
        this.setTitle(ResUtil.getString("FIELD_SEL_GENERATE_TITLE"));
        this.mParentFrame = modelViewerFrame;
        this.setup();
        this.pack();
        this.setLocationRelativeTo(modelViewerFrame);
        this.setVisible(true);
    }

    @Override
    public String generateSyntax() {
        Object object;
        this.mIsCancel = false;
        this.mParentFrame.setIsIncludeFields(this.mIncludeRadio.isSelected());
        if (this.mNumFieldsRadio.isSelected() && (object = this.mNumFieldSpner.getValue()) instanceof Integer && !this.mParentFrame.setTopFields((Integer)object)) {
            this.mIsCancel = true;
            return "failed";
        }
        if (this.mImportanceRadio.isSelected() && (object = this.mImportanceSpner.getValue()) instanceof Double && !this.mParentFrame.setImportanceFields((Double)object)) {
            this.mIsCancel = true;
            return "failed";
        }
        return null;
    }

    @Override
    public String getIActionKey() {
        return "GenerateFieldSelectionDlg";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_generate_field_selection_importance";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.enableOkPaste(true);
        Object object = actionEvent.getSource();
        if (object == this.mNumFieldsRadio) {
            this.mNumFieldSpner.setEnabled(true);
            this.mImportanceSpner.setEnabled(false);
        } else if (object == this.mImportanceRadio) {
            this.mNumFieldSpner.setEnabled(false);
            this.mImportanceSpner.setEnabled(true);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.enableOkPaste(true);
    }

    public String getResString(String string) {
        return ResUtil.getString(string);
    }

    @Override
    protected boolean canBeRecalled() {
        return false;
    }

    public boolean isCancel() {
        return this.mIsCancel;
    }

    @Override
    protected boolean okPastePressed() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        GenerateFieldSelectionDlg.saveState(dialogDataModel, (Container)((Object)this));
        dialogDataModel.putObject(sNumFieldSpinnerId, this.mNumFieldSpner.getValue());
        dialogDataModel.putObject(sImportanceSpinnerId, this.mImportanceSpner.getValue());
        dialogDataModel.putBoolean(sNumFieldSpinnerState, this.mNumFieldSpner.isEnabled());
        dialogDataModel.putBoolean(sImportanceSpinnerState, this.mImportanceSpner.isEnabled());
        return true;
    }

    @Override
    protected void loadDialogState() {
        Boolean bl;
        super.loadDialogState();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        BaseProcedureDialog.loadState(dialogDataModel, (Container)((Object)this), BaseProcedureDialog.NameLabelOption.no_override);
        Object object = dialogDataModel.getObject(sNumFieldSpinnerId);
        if (object != null) {
            this.mNumFieldSpner.setValue(object);
        }
        if ((object = dialogDataModel.getObject(sImportanceSpinnerId)) != null) {
            this.mImportanceSpner.setValue(object);
        }
        if ((bl = dialogDataModel.getBoolean(sNumFieldSpinnerState)) != null) {
            this.mNumFieldSpner.setEnabled(bl);
        }
        if ((bl = dialogDataModel.getBoolean(sImportanceSpinnerState)) != null) {
            this.mImportanceSpner.setEnabled(bl);
        }
    }

    @Override
    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = super.setupCmdButtonPanel();
        jPanel.remove(this.getPasteButton());
        jPanel.remove(this.getResetButton());
        return jPanel;
    }

    private void setup() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 21;
        Insets insets = new Insets(4, 5, 4, 5);
        JLabel jLabel = new JLabel(ResUtil.getString("FIELD_SEL_GENERATE_MODE"));
        this.mIncludeRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_FIELD_SEL_GENERATE_INCLUDE"));
        this.mExcludeRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_FIELD_SEL_GENERATE_EXCLUDE"));
        this.mNumFieldsRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_FIELD_SEL_GENERATE_TOP_NUMBER"));
        this.mImportanceRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_FIELD_SEL_GENERATE_GREATER_THAN"));
        this.mNumFieldSpner = new JSpinner();
        this.mNumFieldSpner.setModel(new SpinnerNumberModel(10, 1, Integer.MAX_VALUE, 1));
        this.mImportanceSpner = new JSpinner();
        this.mImportanceSpner.setModel(new SpinnerNumberModel(0.5, 0.0, 1.0, 0.1));
        this.mNumFieldSpner.setPreferredSize(new Dimension(50, this.mNumFieldSpner.getPreferredSize().height));
        this.mImportanceSpner.setPreferredSize(new Dimension(50, this.mImportanceSpner.getPreferredSize().height));
        WindowsButtonGroup windowsButtonGroup = new WindowsButtonGroup();
        windowsButtonGroup.add(this.mIncludeRadio);
        windowsButtonGroup.add(this.mExcludeRadio);
        this.mIncludeRadio.setSelected(true);
        this.mImportanceSpner.setEnabled(false);
        WindowsButtonGroup windowsButtonGroup2 = new WindowsButtonGroup();
        windowsButtonGroup2.add(this.mNumFieldsRadio);
        windowsButtonGroup2.add(this.mImportanceRadio);
        this.mNumFieldsRadio.setSelected(true);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel2 = new JPanel();
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setHgap(10);
        flowLayout.setVgap(0);
        jPanel2.setLayout(flowLayout);
        jPanel2.add(jLabel);
        jPanel2.add(this.mIncludeRadio);
        jPanel2.add(this.mExcludeRadio);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mNumFieldsRadio, gridBagConstraints, 0, 1, 1, 1, n, new Insets(4, 5, 4, 50));
        DialogUtil.addUsingGBL(jPanel, this.mNumFieldSpner, gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mImportanceRadio, gridBagConstraints, 0, 2, 1, 1, 26, new Insets(4, 5, 4, 40));
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mImportanceSpner, gridBagConstraints, 1, 2, 1, 1, n, insets);
        this.enableOkPaste(true);
        this.addListeners();
        this.add(jPanel);
    }

    private void addListeners() {
        this.mIncludeRadio.addActionListener(this);
        this.mExcludeRadio.addActionListener(this);
        this.mNumFieldsRadio.addActionListener(this);
        this.mImportanceRadio.addActionListener(this);
        this.mNumFieldSpner.addChangeListener(this);
        this.mImportanceSpner.addChangeListener(this);
    }
}

