/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output.model_editor;

import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.core.documents.data.IDataDocument;
import com.spss.java_client.core.resources.ComponentResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.doc_types.output.model_editor.ModelViewerFrame;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FieldSelectionNewDataSetDlg
extends BaseProcedureDialog
implements KeyListener {
    private ModelViewerFrame mParentFrame;
    private JTextField mDatasetNameTxt;

    public FieldSelectionNewDataSetDlg(ModelViewerFrame modelViewerFrame) {
        super((JFrame)modelViewerFrame, true, ComponentResBundle.getDefaultResourceBundleName(), "");
        this.setTitle(ResUtil.getString("FIELD_SEL_NEW_DATASET_TITLE"));
        this.mParentFrame = modelViewerFrame;
        this.setup();
        this.pack();
        this.setLocationRelativeTo(modelViewerFrame);
        this.setVisible(true);
    }

    @Override
    public String generateSyntax() {
        if (this.mDatasetNameTxt == null || this.mDatasetNameTxt.getText().length() == 0) {
            return null;
        }
        String string = this.mDatasetNameTxt.getText();
        String string2 = "  ";
        String string3 = "DATASET COPY ";
        string3 = string3 + string;
        string3 = string3 + ".\n";
        string3 = string3 + "DATASET ACTIVATE ";
        string3 = string3 + string;
        string3 = string3 + ".\n";
        string3 = string3 + "ADD FILES FILE=* ";
        ModelViewerFrame.ReturnResult returnResult = new ModelViewerFrame.ReturnResult();
        String string4 = this.mParentFrame.getFieldsList(returnResult);
        if (!returnResult.isSuccess) {
            return "failed";
        }
        if (string4 != null) {
            string3 = string3 + string2;
            string3 = this.mParentFrame.isIncludeFields() ? string3 + "/KEEP " : string3 + "/DROP ";
            string3 = string3 + string4;
        }
        string3 = string3 + ".\n";
        string3 = string3 + "EXECUTE";
        string3 = string3.trim();
        string3 = string3 + SyntaxUtil.terminateSyntax();
        return string3;
    }

    @Override
    public String getIActionKey() {
        return "FieldSelectionNewDataSetDlg";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_generate_field_selection_input_target";
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.mDatasetNameTxt != null) {
            super.enableOkPaste(this.mDatasetNameTxt.getText().length() > 0);
        } else {
            super.enableOkPaste(false);
        }
    }

    @Override
    protected boolean canBeRecalled() {
        return false;
    }

    @Override
    public boolean okPastePressed() {
        boolean bl = false;
        if (this.mDatasetNameTxt == null || this.mDatasetNameTxt.getText().length() == 0) {
            return bl;
        }
        if (DatasetNameValidator.validateDatasetName((String)this.mDatasetNameTxt.getText(), (Component)((Object)this)) == 1) {
            bl = true;
        }
        return bl;
    }

    @Override
    protected void loadDialogState() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        BaseProcedureDialog.loadState(dialogDataModel, (Container)((Object)this), BaseProcedureDialog.NameLabelOption.no_override);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = DataMgr.getDataMgr().getDataDocumentCount();
        for (int i = 0; i < n; ++i) {
            IDataDocument iDataDocument = DataMgr.getDataMgr().getDataDocument(i);
            arrayList.add(iDataDocument.getDatasetName());
        }
        String string = "DataSet" + n++;
        while (arrayList.contains(string)) {
            string = "DataSet" + n++;
        }
        this.mDatasetNameTxt.setText(string);
    }

    @Override
    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = super.setupCmdButtonPanel();
        jPanel.remove(this.getResetButton());
        return jPanel;
    }

    private void setup() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 21;
        Insets insets = new Insets(4, 5, 4, 5);
        JLabel jLabel = new JLabel(ResUtil.getString("FIELD_SEL_NEW_DATASET_DESCRIPTION"));
        JLabel jLabel2 = new JLabel(ResUtil.getString("IDS_FIELD_SEL_NEW_DATASET_DATASET_NAME"));
        jLabel2.setDisplayedMnemonic(ResUtil.getAccessKey("IDS_FIELD_SEL_NEW_DATASET_DATASET_NAME"));
        this.mDatasetNameTxt = new JTextField(30);
        this.mDatasetNameTxt.addKeyListener(this);
        jLabel2.setLabelFor(this.mDatasetNameTxt);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, new Insets(4, 5, 25, 5));
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mDatasetNameTxt, gridBagConstraints, 1, 1, 1, 1, 26, new Insets(4, 5, 25, 5));
        this.add(jPanel);
        super.enableOkPaste(true);
    }
}

