/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output.graphboard;

import com.spss.charteditor.util.TrinityUtil;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.doc_types.output.GraphBoardViewerItem;
import com.spss.java_client.ui.doc_types.output.graphboard.GraphBoardAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.pes.help.Helper;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.vis.graphboard.Graphboard;
import com.spss.vis.graphboard.help.HelpHandler;
import com.spss.vis.graphboard.palette.GraphboardToolBar;
import com.spss.vis.implementation.ComponentNavigation;
import com.spss.vis.specification.ExtensionSpecification;
import com.spss.vis.specification.Specification;
import com.spss.vis.specification.VisualizationSpecification;
import com.spss.vis.specification.data.EmbeddedSourceSpecification;
import com.spss.vis.specification.data.VariableSpecification;
import com.spss.vis.specification.format.FormatSpecification;
import com.spss.vis.specification.format.RelabelSpecification;
import com.spss.vis.specification.guide.LineGuideSpecification;
import com.spss.vis.specification.interaction.SwingControllerSpecification;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.prefs.Preferences;
import java.util.zip.DeflaterOutputStream;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.table.TableModel;

public class GraphBoardFrame
extends JFrame
implements WindowListener,
MenuListener {
    private GraphBoardViewerItem mViwerItem;
    private Graphboard mGraphBoard;
    private boolean mIsChartChanged = false;
    private static TableModel sModel;
    public static final String sGraphBoardFrameSizeLocation = "GraphBoardFrameSizeLocation";

    public GraphBoardFrame(GraphBoardViewerItem graphBoardViewerItem, Graphboard graphboard, String string) {
        super(string);
        this.mViwerItem = graphBoardViewerItem;
        this.mGraphBoard = graphboard;
        this.mGraphBoard.getVisualizationComponent().getNavigation().setMethod(ComponentNavigation.Method.SCROLL);
        this.mGraphBoard.getModel().setRawMode(true);
        this.init();
        VisualizationSpecification visualizationSpecification = this.mGraphBoard.getVisualizationComponent().getVisualization().getSpecification();
        if (((SwingControllerSpecification[])visualizationSpecification.findDescendantsOfType(SwingControllerSpecification.class)).length > 0) {
            this.mIsChartChanged = true;
        }
        HelpHandler helpHandler = new HelpHandler(this){

            public void setHelpFile(String string, String string2) {
            }

            public void handleHelp(String string) {
                StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, string);
            }
        };
        graphboard.setHelpHandler((Helper)helpHandler);
        this.addWindowListener(this);
        sModel = null;
    }

    private void init() {
        Object object2;
        ImageIcon imageIcon = new ImageIcon(ResUtil.getImageResource("spssgraph.gif"));
        this.setIconImage(imageIcon.getImage());
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu(new GraphBoardAction("model_file", this.mGraphBoard, this));
        JMenu jMenu2 = new JMenu(new GraphBoardAction("Edit", this.mGraphBoard, this));
        JMenu jMenu3 = new JMenu(new GraphBoardAction("model_view", this.mGraphBoard, this));
        JMenu jMenu4 = new JMenu(new GraphBoardAction("Help", this.mGraphBoard, this));
        JMenu jMenu5 = new JMenu(new GraphBoardAction("model_view_palette", this.mGraphBoard, this));
        List list = this.mGraphBoard.getPalettes();
        for (Object object2 : list) {
            if (object2.getAvailability() == GraphboardToolBar.Behavior.UNAVAILABLE) continue;
            jMenu5.add(object2.getCheckBoxMenuItem());
        }
        JMenuItem jMenuItem = new JMenuItem(new GraphBoardAction("model_file_close", this.mGraphBoard, this));
        object2 = new JCheckBoxMenuItem(new GraphBoardAction("model_view_edit_mode", this.mGraphBoard, this));
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new GraphBoardAction("model_view_explore_mode", this.mGraphBoard, this));
        JMenuItem jMenuItem2 = new JMenuItem(new GraphBoardAction("edit_undo", this.mGraphBoard, this));
        JMenuItem jMenuItem3 = new JMenuItem(new GraphBoardAction("edit_redo", this.mGraphBoard, this));
        JMenuItem jMenuItem4 = new JMenuItem(new GraphBoardAction("help_topics", this.mGraphBoard, this));
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        jMenuBar.add(jMenu4);
        jMenu.add(jMenuItem);
        jMenu2.add(jMenuItem2);
        jMenu2.add(jMenuItem3);
        jMenu4.add(jMenuItem4);
        jMenu3.add((JMenuItem)object2);
        jMenu3.add(jCheckBoxMenuItem);
        jMenu3.add(jMenu5);
        jMenu3.addMenuListener(this);
    }

    public void loadPreferences() {
        this.loadSizeAndLocationState();
    }

    protected void loadSizeAndLocationState() {
        Preferences preferences = this.getBasePreference();
        Dimension dimension = new Dimension(900, 700);
        Dimension dimension2 = this.getToolkit().getScreenSize();
        int n = (int)((double)dimension2.width - dimension.getWidth()) / 2;
        int n2 = (int)((double)dimension2.height - dimension.getHeight()) / 2;
        Dimension dimension3 = ProcedureDlgMgr.getMgr().getDialogSize(sGraphBoardFrameSizeLocation);
        if (dimension3 != null) {
            this.setSize(dimension3);
        } else {
            this.setSize(new Dimension(900, 700));
        }
        Point point = ProcedureDlgMgr.getMgr().getDialogLocation(sGraphBoardFrameSizeLocation);
        if (point != null) {
            this.setLocation(point);
        } else {
            this.setLocation(new Point(n, n2));
        }
    }

    public void close() {
        this.mViwerItem.endEdit();
    }

    public static void updateMenuCheckStatus(JMenu jMenu, GraphBoardFrame graphBoardFrame) {
        int n = jMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            Action action;
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem instanceof JMenu || jMenuItem == null || !((action = jMenuItem.getAction()) instanceof GraphBoardAction)) continue;
            GraphBoardAction graphBoardAction = (GraphBoardAction)action;
            jMenuItem.setEnabled(graphBoardAction.getMenuItemEnableStatus(graphBoardFrame));
        }
    }

    private void refreshMenuCheckStatus(JMenu jMenu, GraphBoardFrame graphBoardFrame) {
        int n = jMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            GraphBoardAction graphBoardAction;
            JMenuItem jMenuItem;
            JMenuItem jMenuItem2 = jMenu.getItem(i);
            if (jMenuItem2 instanceof JCheckBoxMenuItem) {
                jMenuItem = (JCheckBoxMenuItem)jMenuItem2;
                graphBoardAction = (GraphBoardAction)jMenuItem2.getAction();
                ((JCheckBoxMenuItem)jMenuItem).setState(graphBoardAction.getMenuItemCheckStatus(graphBoardFrame));
                continue;
            }
            if (!(jMenuItem2 instanceof JRadioButtonMenuItem)) continue;
            jMenuItem = (JRadioButtonMenuItem)jMenuItem2;
            graphBoardAction = (GraphBoardAction)jMenuItem2.getAction();
            jMenuItem.setSelected(graphBoardAction.getMenuItemCheckStatus(graphBoardFrame));
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.applyPreferences();
        this.close();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        JMenu jMenu = (JMenu)menuEvent.getSource();
        GraphBoardFrame.updateMenuCheckStatus(jMenu, this);
        this.refreshMenuCheckStatus(jMenu, this);
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    public boolean needsRerendering() {
        return this.mIsChartChanged;
    }

    public void setDirty(boolean bl) {
        this.mIsChartChanged = bl;
    }

    public byte[] extractCompressedXML(boolean bl) {
        byte[] byArray = null;
        try {
            boolean bl2;
            StringWriter stringWriter = new StringWriter();
            VisualizationSpecification visualizationSpecification = this.mGraphBoard.getVisualizationComponent().getVisualization().getSpecification();
            boolean bl3 = bl2 = ((SwingControllerSpecification[])visualizationSpecification.findDescendantsOfType(SwingControllerSpecification.class)).length > 0;
            if (bl2) {
                this.modifiedForInteractiveChart(visualizationSpecification);
            }
            visualizationSpecification.writeXml((Writer)stringWriter);
            stringWriter.close();
            EmbeddedSourceSpecification embeddedSourceSpecification = TrinityUtil.findFirstEmbeddedSourceSpec((VisualizationSpecification)visualizationSpecification);
            StringBuffer stringBuffer = stringWriter.getBuffer();
            if (!bl && !bl2) {
                int n = stringBuffer.indexOf("<embeddedSource");
                int n2 = stringBuffer.indexOf("</embeddedSource>");
                int n3 = n2 + 17;
                if (n3 <= 0) {
                    n3 = n + 1;
                }
                stringBuffer.replace(n, n3, "<userSource id=\"" + embeddedSourceSpecification.getId() + "\"/>");
            }
            byArray = stringBuffer.toString().getBytes("UTF-8");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            ((OutputStream)deflaterOutputStream).write(byArray);
            ((OutputStream)deflaterOutputStream).close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray;
    }

    public static byte[] extractCompressedXML(VisualizationSpecification visualizationSpecification) {
        byte[] byArray = null;
        try {
            StringWriter stringWriter = new StringWriter();
            visualizationSpecification.writeXml((Writer)stringWriter);
            stringWriter.close();
            StringBuffer stringBuffer = stringWriter.getBuffer();
            byArray = stringBuffer.toString().getBytes("UTF-8");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            ((OutputStream)deflaterOutputStream).write(byArray);
            ((OutputStream)deflaterOutputStream).close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray;
    }

    public void reset() {
        this.mViwerItem = null;
        this.mGraphBoard = null;
    }

    public static void setInteractiveTableModel(TableModel tableModel) {
        sModel = tableModel;
    }

    private void applyPreferences() {
        ProcedureDlgMgr.getMgr().saveDialogSize(sGraphBoardFrameSizeLocation, this.getSize());
        ProcedureDlgMgr.getMgr().saveDialogLocation(sGraphBoardFrameSizeLocation, this.getLocation());
    }

    private Preferences getBasePreference() {
        String string = PrefsMgr.getPrefsMgr().getUIUserPrefs().absolutePath();
        Preferences preferences = Preferences.userRoot().node(string);
        return preferences.node("dialog_settings/graphboard");
    }

    private void modifiedForInteractiveChart(VisualizationSpecification visualizationSpecification) {
        Specification specification = visualizationSpecification.getSpecification("tableData");
        if (specification instanceof EmbeddedSourceSpecification && sModel != null) {
            ExtensionSpecification[] extensionSpecificationArray;
            FormatSpecification formatSpecification;
            int n;
            int n2;
            EmbeddedSourceSpecification embeddedSourceSpecification = (EmbeddedSourceSpecification)specification;
            Object[] objectArray = embeddedSourceSpecification.getData();
            int n3 = sModel.getRowCount();
            int n4 = sModel.getColumnCount();
            String[][] stringArray = null;
            boolean bl = true;
            Specification specification2 = visualizationSpecification.getSpecification("source0");
            if (specification2 instanceof EmbeddedSourceSpecification) {
                boolean bl2 = bl = ((EmbeddedSourceSpecification)specification2).getData().length == 2;
            }
            if (bl) {
                stringArray = new String[objectArray.length][n4];
                for (n2 = 0; n2 < n4; ++n2) {
                    stringArray[0][n2] = (String)sModel.getValueAt(0, n2);
                    stringArray[1][n2] = String.valueOf(n2);
                    if (objectArray.length <= 2) continue;
                    for (n = 2; n < objectArray.length; ++n) {
                        stringArray[n][n2] = "0";
                    }
                }
            } else {
                n2 = n4 - 1;
                stringArray = new String[objectArray.length][(n4 - 1) * n3];
                for (n = 0; n < sModel.getRowCount(); ++n) {
                    for (int i = 0; i < n4 - 1; ++i) {
                        stringArray[0][i + n2 * n] = UIToolResUtil.removeLocale((String)((String)sModel.getValueAt(n, i + 1)));
                        stringArray[1][i + n2 * n] = String.valueOf(i);
                        stringArray[2][i + n2 * n] = String.valueOf(n);
                        stringArray[3][i + n2 * n] = String.valueOf(n);
                    }
                }
            }
            embeddedSourceSpecification.setData((Object[])stringArray);
            VariableSpecification variableSpecification = (VariableSpecification)visualizationSpecification.getSpecification("column");
            if (variableSpecification != null && (formatSpecification = variableSpecification.getDisplayFormatChild()) != null) {
                int n5;
                RelabelSpecification[] relabelSpecificationArray;
                for (RelabelSpecification lineGuideSpecificationArray : relabelSpecificationArray = formatSpecification.getRelabeling()) {
                    formatSpecification.remove((Specification)lineGuideSpecificationArray);
                }
                if (bl) {
                    for (n5 = 0; n5 < n4; ++n5) {
                        formatSpecification.addRelabeling(new RelabelSpecification(stringArray[1][n5], sModel.getColumnName(n5)));
                    }
                } else {
                    for (n5 = 0; n5 < n4 - 1; ++n5) {
                        formatSpecification.addRelabeling(new RelabelSpecification(stringArray[1][n5], sModel.getColumnName(n5 + 1)));
                    }
                }
            }
            if ((extensionSpecificationArray = visualizationSpecification.getExtensionSpecifications()).length > 0) {
                String string = extensionSpecificationArray[0].get("lowerSlider");
                String string2 = extensionSpecificationArray[0].get("upperSlider");
                String string3 = extensionSpecificationArray[0].get("lowerinfinity");
                String string4 = extensionSpecificationArray[0].get("upperinfinity");
                if (string != null && string2 != null) {
                    LineGuideSpecification[] lineGuideSpecificationArray;
                    for (LineGuideSpecification lineGuideSpecification : lineGuideSpecificationArray = (LineGuideSpecification[])visualizationSpecification.findDescendantsOfType(LineGuideSpecification.class)) {
                        if (string.equals(lineGuideSpecification.getName())) {
                            lineGuideSpecification.getStyle().setVisible(Boolean.valueOf(string3 == null || !"true".equals(string3)));
                        }
                        if (!string2.equals(lineGuideSpecification.getName())) continue;
                        lineGuideSpecification.getStyle().setVisible(Boolean.valueOf(string4 == null || !"true".equals(string4)));
                    }
                }
            }
        }
    }
}

